﻿Imports System.Xml.Linq
Public NotInheritable Class frmAbout
  Private Class UpdateChecker
    Private WithEvents wsDownload As New Net.WebClient
    Private WithEvents wsXML As New Net.WebClient
    Private Structure FileDetails
      Public Structure FileDetail
        Public Attributes As IO.FileAttributes
        Public Created As Date
        Public LastWrite As Date
        Public Length As Long
      End Structure
      Public FilePath As String
      Public FileInfo As FileDetail
      Public FileHash As String
      Public FileURL As String
      Public FileVer As String
    End Structure
    Private Structure NewsArticle
      Public pubdate As String
      Public description As String
    End Structure
    Private xPath As String = AppTemp & "\ver.xml"
    Private Updates As New Collection
    Friend News As String
    Event Complete(FilesUpdated As Integer)
    Event HasUpdates()
    Event NoUpdates()
    Event Errored(Message As String)
    Event UpdateProgress(Value As Long, Maximum As Long)
    Private bCancel As Boolean

    Sub New()
      News = Nothing
    End Sub

    Friend Sub Cancel()
      bCancel = True
      If wsDownload.IsBusy Then wsDownload.CancelAsync()
      If My.Computer.FileSystem.FileExists(AppTemp & "\Update.zip") AndAlso My.Computer.FileSystem.GetFileInfo(AppTemp & "\Update.zip").Length < 0 Then My.Computer.FileSystem.DeleteFile(AppTemp & "\Update.zip")
    End Sub

    Friend Sub BeginCheck()
      bCancel = False
      If My.Computer.FileSystem.FileExists(xPath) Then
        wsXML_DownloadFileCompleted(New Object, New System.ComponentModel.AsyncCompletedEventArgs(Nothing, False, Nothing))
      Else
        wsXML.CachePolicy = New Net.Cache.HttpRequestCachePolicy(System.Net.Cache.HttpRequestCacheLevel.NoCacheNoStore)
        wsXML.DownloadFileAsync(New Uri("http://update.realityripple.com/Entelechy/ver.xml"), xPath)
      End If
    End Sub

    Private Sub wsDownload_DownloadFileCompleted(sender As Object, e As System.ComponentModel.AsyncCompletedEventArgs) Handles wsDownload.DownloadFileCompleted
      If bCancel Then Exit Sub
      If e.Error Is Nothing Then
        RaiseEvent Complete(Updates.Count)
      Else
        RaiseEvent Complete(0)
      End If
    End Sub

    Private Sub wsDownload_DownloadProgressChanged(sender As Object, e As System.Net.DownloadProgressChangedEventArgs) Handles wsDownload.DownloadProgressChanged
      If bCancel Then Exit Sub
      If e.TotalBytesToReceive > 0 Then RaiseEvent UpdateProgress(e.BytesReceived, e.TotalBytesToReceive)
    End Sub

    Private Sub wsXML_DownloadFileCompleted(sender As Object, e As System.ComponentModel.AsyncCompletedEventArgs) Handles wsXML.DownloadFileCompleted
      If bCancel Then Exit Sub
      If e.Error IsNot Nothing Then
        RaiseEvent Errored(e.Error.Message)
        Exit Sub
      End If
      Try
        Dim xVer As XDocument = XDocument.Load(xPath)
        Dim xVerFile As XElement = xVer.Element("verfile")
        Dim xNews As XElement = xVerFile.Element("news")
        If xNews IsNot Nothing Then
          News = String.Empty
          For Each Article In xNews.Elements("entry")
            News &= "[" & Article.Element("pubdate").Value & "] " & Replace(Article.Element("description").Value, "\n", vbNewLine) & vbNewLine
          Next
        Else
          News = My.Resources.ABOUT_NEWS_FAIL
        End If
        If bCancel Then Exit Sub
        Dim xUpdates As XElement = xVerFile.Element("updates")
        If xUpdates IsNot Nothing Then
          Updates.Clear()
          Dim sRequest As String = "http://e.realityripple.com/update.php?f="
          For Each File In xUpdates.Elements("file")
            If bCancel Then Exit Sub
            Dim uItem As FileDetails
            uItem.FilePath = File.Element("path").Value
            uItem.FileInfo.Attributes = File.Element("info").Element("attributes").Value
            uItem.FileInfo.Created = DateValue(File.Element("info").Element("created").Value)
            uItem.FileInfo.LastWrite = DateValue(File.Element("info").Element("lastwrite").Value)
            uItem.FileInfo.Length = File.Element("info").Element("length").Value
            uItem.FileHash = File.Element("hash").Value
            uItem.FileURL = File.Element("url").Value
            uItem.FileVer = File.Element("ver").Value
            Dim bUpdate As Boolean = False
            Dim sLocalPath As String = Application.StartupPath & "\" & uItem.FilePath
            If My.Computer.FileSystem.FileExists(sLocalPath) Then
              If FileVersionInfo.GetVersionInfo(sLocalPath).FileVersion = String.Empty Then
                Using MD5 As New System.Security.Cryptography.HMACMD5({31, 41, 59, 26, 53, 58, 97, 93, 238, 46, 26, 43, 38, 32, 79, 50, 28, 84, 197, 16, 93, 99, 37, 5, 105, 8, 20, 97, 4, 94, 45, 92, 30, 78, 16, 40, 62, 86, 208, 9, 98, 62, 80, 34, 82, 53, 42, 11, 70, 67, 98, 214, 80, 86, 51, 32, 82, 30, 66, 4, 70, 93, 84, 46})
                  If BitConverter.ToString(MD5.ComputeHash(My.Computer.FileSystem.ReadAllBytes(sLocalPath))) <> uItem.FileHash Then
                    'File has no version and a different hash
                    bUpdate = True
                  End If
                End Using
              Else
                If FileVersionInfo.GetVersionInfo(sLocalPath).FileVersion < uItem.FileVer Then
                  'File has a different version
                  bUpdate = True
                End If
              End If
            Else
              'File doesn't exist yet
              bUpdate = True
            End If
            If bUpdate Then
              Updates.Add(uItem)
              sRequest &= uItem.FileURL & ";"
            End If
          Next
          If bCancel Then Exit Sub
          If sRequest <> "http://e.realityripple.com/update.php?f=" Then
            RaiseEvent HasUpdates()
            sRequest = sRequest.Substring(0, sRequest.Length - 1)
            wsDownload.CachePolicy = New Net.Cache.HttpRequestCachePolicy(System.Net.Cache.HttpRequestCacheLevel.NoCacheNoStore)
            wsDownload.DownloadFileAsync(New Uri(sRequest), AppTemp & "\Update.zip")
          Else
            RaiseEvent NoUpdates()
          End If
        End If
      Catch ex As Exception
        RaiseEvent Errored(ex.Message)
      End Try
    End Sub
  End Class
  Private WithEvents Updater As New UpdateChecker
  Private Sub ShowImage(iImage As Image, pPicture As PictureBox, Animated As Boolean)
    If Animated Then
      pPicture.Image = iImage
      pPicture.SizeMode = PictureBoxSizeMode.Zoom
    Else
      pPicture.Image = DrawThumbnail(iImage, pPicture.Width, pPicture.Height)
      pPicture.SizeMode = PictureBoxSizeMode.CenterImage
    End If
  End Sub
  Private Function DrawThumbnail(iImage As Image, lWidth As Integer, lHeight As Integer) As Image
    Dim imgThumb As New Bitmap(lWidth, lHeight)
    Dim tWid As Integer
    Dim tHgh As Integer
    If iImage.Width > lWidth Or iImage.Height > lHeight Then
      If iImage.Width < iImage.Height Then
        tHgh = lHeight
        tWid = iImage.Width / (iImage.Height / lHeight)
      ElseIf iImage.Width > iImage.Height Then
        tHgh = iImage.Height / (iImage.Width / lWidth)
        tWid = lWidth
      Else
        tHgh = lWidth
        tWid = lHeight
      End If
    Else
      tWid = iImage.Width
      tHgh = iImage.Height
    End If
    Dim g As Graphics = Graphics.FromImage(imgThumb)
    g.InterpolationMode = Drawing2D.InterpolationMode.HighQualityBicubic
    g.SmoothingMode = Drawing2D.SmoothingMode.AntiAlias
    g.DrawImage(iImage, 0, 0, tWid, tHgh)
    g.Dispose()
    Return imgThumb
  End Function
  Private Sub frmAbout_FormClosing(sender As Object, e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
    tmrCheck.Enabled = False
    Updater.Cancel()

  End Sub
  Private Sub frmAbout_Load(sender As Object, e As System.EventArgs) Handles Me.Load
    lblVer.Text = Version
    ShowImage(My.Resources.BANNER_BATTLENET, pctBNet, False)
    ShowImage(My.Resources.BANNER_DIABLO, pctDiablo, True)
    ShowImage(My.Resources.BANNER_STARCRAFT, pctStarcraft, True)
    ShowImage(My.Resources.BANNER_WARCRAFT, pctWarcraft, False)
    Dim geckoINI As New INIReader(System.Windows.Forms.Application.StartupPath & "\xulrunner\platform.ini")
    lblGeckoVer.Text = "v" & geckoINI.GetValue("Build", "Milestone")
    lblFreeImageVer.Text = "v" & FreeImageAPI.FreeImage.GetVersion
    Dim fvi = FileVersionInfo.GetVersionInfo(Application.StartupPath & "\StormLib.dll")
    lblStormVer.Text = "v" & fvi.FileMajorPart & "." & fvi.FileMinorPart & "." & fvi.FileBuildPart & "." & fvi.FilePrivatePart
    lblIonicZipVer.Text = "v" & Ionic.Zip.ZipFile.LibraryVersion.ToString
    SetUpdateValue(My.Resources.ABOUT_UPDATE_CHECK, True)
    tmrCheck.Enabled = True
  End Sub
  Private Sub cmdDonate_Click(sender As System.Object, e As System.EventArgs) Handles cmdDonate.Click
    Process.Start("http://realityripple.com/donate.php")
  End Sub
  Private Sub SetUpdateValue(Message As String, Throbber As Boolean)
    If Throbber Then
      If lblUpdate.Image Is Nothing Then lblUpdate.Image = My.Resources.LOAD
      If Not lblUpdate.Text = "      " & Message Then lblUpdate.Text = "      " & Message
    Else
      If lblUpdate.Image IsNot Nothing Then lblUpdate.Image = Nothing
      If Not lblUpdate.Text = Message Then lblUpdate.Text = Message
    End If
  End Sub
  Private Sub Updater_Complete(FilesUpdated As Integer) Handles Updater.Complete
    If FilesUpdated > 0 Then
      SetUpdateValue(My.Resources.ABOUT_UPDATE_DOWNLOAD_COMPLETE, False)
      If MsgBox(ResString(My.Resources.ABOUT_UPDATE_COMPLTE_RESTART, FilesUpdated, IIf(FilesUpdated = 1, String.Empty, "s")), vbQuestion Or vbYesNo) = MsgBoxResult.Yes Then
        frmMain.Close()
      Else
        MsgBox(My.Resources.ABOUT_UPDTATE_COMPLETE_NORESTART, MsgBoxStyle.Information)
      End If
    Else
      SetUpdateValue(My.Resources.ABOUT_UPDATE_FAIL, False)
      If My.Computer.FileSystem.FileExists(AppTemp & "\Update.zip") Then My.Computer.FileSystem.DeleteFile(AppTemp & "\Update.zip")
    End If
  End Sub
  Private Sub Updater_Errored(Message As String) Handles Updater.Errored
    SetUpdateValue(My.Resources.ABOUT_UPDATE_FAIL, False)
    MsgBox(My.Resources.ABOUT_UPDATE_FAIL & vbNewLine & Message, MsgBoxStyle.Exclamation)
  End Sub
  Private Sub Updater_HasUpdates() Handles Updater.HasUpdates
    SetUpdateValue(My.Resources.ABOUT_UPDATE_DOWNLOAD, True)
    MakeNewsTip()
  End Sub
  Private Sub Updater_NoUpdates() Handles Updater.NoUpdates
    SetUpdateValue(My.Resources.ABOUT_UPDATE_NONE, False)
    MakeNewsTip()
  End Sub
  Private Sub MakeNewsTip()
    If Not String.IsNullOrEmpty(Updater.News) And Me.Visible Then
      Dim ttX As New ToolTip()
      ttX.IsBalloon = True
      ttX.InitialDelay = 0
      ttX.AutoPopDelay = 30000
      ttX.UseAnimation = True
      ttX.UseFading = True
      ttX.ToolTipTitle = My.Resources.ABOUT_NEWS_TITLE
      ttX.ToolTipIcon = ToolTipIcon.Info
      ttX.ShowAlways = True
      ttX.SetToolTip(lblUpdate, Updater.News)
      ttX.Show(Updater.News, lblUpdate, 30000)
    End If
  End Sub
  Private Sub Updater_UpdateProgress(Value As Long, Maximum As Long) Handles Updater.UpdateProgress
    SetUpdateValue(ResString(My.Resources.ABOUT_UPDATE_DOWNLOAD_PROGRESS, FormatPercent(Value / Maximum, 0, TriState.True, TriState.True, TriState.False)), True)
  End Sub
  Private Sub tmrCheck_Tick(sender As System.Object, e As System.EventArgs) Handles tmrCheck.Tick
    tmrCheck.Enabled = False
    If Me.Visible Then Updater.BeginCheck()
  End Sub
End Class
