﻿Public Class WhisWin

  Private Sub txtSend_KeyDown(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles txtSend.KeyDown
    If e.KeyCode = Keys.F2 Then gWhisper.ToggleTimestamps()
  End Sub

  Private Sub txtSend_KeyPress(sender As Object, e As System.Windows.Forms.KeyPressEventArgs) Handles txtSend.KeyPress
    If e.KeyChar = Chr(13) Then
      cmdSend.PerformClick()
      e.Handled = True
    End If
  End Sub

  Private Sub cmdSend_Click(sender As System.Object, e As System.EventArgs) Handles cmdSend.Click
    If Not String.IsNullOrEmpty(txtSend.Text) Then
      CType(Me.Parent.Tag(0), BNUI).SendMessage("/w " & Me.Tag & " " & txtSend.Text)
      txtSend.Text = String.Empty
    End If
  End Sub

  Private Sub gWhisper_HyperlinkClick(sender As Object, e As GeckoChat.LinkClickEventArgs) Handles gWhisper.HyperlinkClick
    txtSend.Focus()
    If e.Mouse.Button = 0 Then
      Process.Start(e.URL)
    ElseIf e.Mouse.Button = 2 Then
      mnuAddress.Tag = e.URL
      mnuAddress.Show(gWhisper, e.Mouse.Location)
    End If
  End Sub

  Private Sub gWhisper_Load(sender As Object, e As System.EventArgs) Handles gWhisper.Load
    gWhisper.TimeStampFormat = CType(Me.Parent.Tag(0), BNUI).Config.Display.TimeStamp
    gWhisper.ToggleTimestamps(False)
  End Sub

  Private Sub gWhisper_MouseUp(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles gWhisper.MouseUp
    txtSend.Focus()
    If e.Button = 2 Then
      mnuTimeStamp.Checked = CType(Me.Parent.Tag(0), BNUI).Config.Display.TimeStampEnabled
      mnuRichText.Checked = CType(Me.Parent.Tag(0), BNUI).Config.Display.RichText
      mnuEmoticons.Checked = CType(Me.Parent.Tag(0), BNUI).Config.Display.Emoticons
      mnuChatBox.Show(gWhisper, e.Location)
    End If
  End Sub

  Private Sub gWhisper_UserNameClick(sender As Object, e As GeckoChat.NameClickEventArgs) Handles gWhisper.UserNameClick
    txtSend.Focus()
    If e.Mouse.Button = 2 Then
      mnuUser.Tag = e.Account
      mnuFriend.Checked = CType(Me.Parent.Tag(0), BNUI).IsFriend(e.Account)
      mnuUser.Show(gWhisper, e.Mouse.Location)
    End If
  End Sub

  Private Sub txtSend_MouseWheel(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles txtSend.MouseWheel
    gWhisper.ScrollTo(e.Delta)
  End Sub

  Private Sub mnuName_Click(sender As System.Object, e As System.EventArgs) Handles mnuName.Click
    txtSend.SelectionLength = 0
    txtSend.SelectedText = mnuUser.Tag
  End Sub

  Private Sub mnuInfo_Click(sender As Object, e As EventArgs) Handles mnuInfo.Click
    CType(Me.Parent.Tag(0), BNUI).SendMessage("/info " & mnuUser.Tag)
  End Sub

  Private Sub mnuWhois_Click(sender As Object, e As EventArgs) Handles mnuWhois.Click
    CType(Me.Parent.Tag(0), BNUI).SendMessage("/whois " & mnuUser.Tag)
  End Sub

  Private Sub mnuFriend_Click(sender As Object, e As EventArgs) Handles mnuFriend.Click
    If mnuFriend.Checked Then
      CType(Me.Parent.Tag(0), BNUI).SendMessage("/f r " & mnuUser.Tag)
    Else
      CType(Me.Parent.Tag(0), BNUI).SendMessage("/f a " & mnuUser.Tag)
    End If
  End Sub

  Private Sub mnuProfile_Click(sender As Object, e As EventArgs) Handles mnuProfile.Click
    CType(Me.Parent.Tag(0), BNUI).GetUIProfile(mnuUser.Tag)
  End Sub

  Private Sub ClearChatToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles mnuClearChat.Click
    gWhisper.Clear()
  End Sub

  Private Sub TimestampToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles mnuTimeStamp.Click
    CType(Me.Parent.Tag(0), BNUI).Config.Display.TimeStampEnabled = Not CType(Me.Parent.Tag(0), BNUI).Config.Display.TimeStampEnabled
    gWhisper.ToggleTimestamps(CType(Me.Parent.Tag(0), BNUI).Config.Display.TimeStampEnabled)
    SaveSettings(CType(Me.Parent.Tag(0), BNUI).Index, CType(Me.Parent.Tag(0), BNUI).Config)
  End Sub

  Private Sub RichTextToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles mnuRichText.Click
    CType(Me.Parent.Tag(0), BNUI).Config.Display.RichText = Not CType(Me.Parent.Tag(0), BNUI).Config.Display.RichText
    CType(Me.Parent.Tag(0), BNUI).gChat.RichText = CType(Me.Parent.Tag(0), BNUI).Config.Display.RichText
    SaveSettings(CType(Me.Parent.Tag(0), BNUI).Index, CType(Me.Parent.Tag(0), BNUI).Config)
  End Sub

  Private Sub EmoticonsToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles mnuEmoticons.Click
    CType(Me.Parent.Tag(0), BNUI).Config.Display.Emoticons = Not CType(Me.Parent.Tag(0), BNUI).Config.Display.Emoticons
    CType(Me.Parent.Tag(0), BNUI).gChat.Emoticons = CType(Me.Parent.Tag(0), BNUI).Config.Display.Emoticons
    SaveSettings(CType(Me.Parent.Tag(0), BNUI).Index, CType(Me.Parent.Tag(0), BNUI).Config)
  End Sub

  Private Sub MenuItem1_Click(sender As System.Object, e As System.EventArgs) Handles mnuUTF8.Click
    CType(Me.Parent.Tag(0), BNUI).Config.UTF8 = Not CType(Me.Parent.Tag(0), BNUI).Config.UTF8
    SaveSettings(CType(Me.Parent.Tag(0), BNUI).Index, CType(Me.Parent.Tag(0), BNUI).Config)
  End Sub

  Private Sub OpenURLInBrowserToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles OpenURLInBrowserToolStripMenuItem.Click
    Process.Start(mnuAddress.Tag)
  End Sub

  Private Sub CopyURLToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles CopyURLToolStripMenuItem.Click
    Clipboard.SetText(mnuAddress.Tag)
  End Sub


End Class
