﻿Public Class W3Profile

  Private _getPercent As Double

  Private Property GetPercent(Experience As UInteger, Unknown As Byte, Level As Byte) As Double
    Get
      Return _getPercent
    End Get
    Set(value As Double)
      _getPercent = value
    End Set
  End Property

  Private Delegate Sub LoadAccountInfoCallback([bReadOnly] As Boolean, [InfoStrings] As String())
  Private Delegate Sub LoadClanInfoCallback([InfoStrings] As String())
  Private Delegate Sub LoadAccountPacketCallback(pktRead As BNCSReader)
  Private ResMan As New Resources.ResourceManager("Entelechy.W3Profile", Reflection.[Assembly].GetExecutingAssembly)

  Public Property sHomepage As String
    Get
      sHomepage = txtHomepage.Text
    End Get
    Set(value As String)
      txtHomepage.Text = value
    End Set
  End Property

  Public Property sAdditionalInformation As String
    Get
      sAdditionalInformation = txtAdditionalInformation.Text
    End Get
    Set(value As String)
      txtAdditionalInformation.Text = value
    End Set
  End Property

  Public Sub LoadProfileInfo(bReadOnly As Boolean, InfoStrings() As String)
    If Me.txtHomepage.InvokeRequired Then
      Dim d As New LoadAccountInfoCallback(AddressOf LoadProfileInfo)
      Me.BeginInvoke(d, New Object() {[bReadOnly], [InfoStrings]})
    Else
      If bReadOnly Then
        cmdIcon.Visible = False
        If pnlIcon.Controls.Contains(cmdIcon) Then pnlIcon.Controls.Remove(cmdIcon)
        pnlIcon.RowCount = 1
      Else
        cmdIcon.Visible = True
        cmdIcon.Enabled = False
        pnlIcon.RowCount = 2
        If Not pnlIcon.Controls.Contains(cmdIcon) Then pnlIcon.Controls.Add(cmdIcon, 0, 1)
      End If
      pctIcon.Image = pctIcon.InitialImage
      lblUserName.Text = Parent.Text
      txtHomepage.ReadOnly = bReadOnly
      txtAdditionalInformation.ReadOnly = bReadOnly
      txtHomepage.Text = DeCensor(InfoStrings(0))
      txtAdditionalInformation.Text = DeCensor(InfoStrings(1))
      If String.IsNullOrEmpty(InfoStrings(2)) Then
        'No Clan
        lblClanName.Tag = Nothing
        lblClan.Visible = False
        pctClanInfo.Visible = False
        lblClanName.Visible = False
        lblClanRank.Visible = False
        pctClanRank.Visible = False
        lblClanRanking.Visible = False
        lblJoin.Visible = False
        lblJoinDate.Visible = False
        pnlUserInfo.Controls.Remove(lblClanName)
        pnlUserInfo.Controls.Remove(lblClan)
        pnlUserInfo.Controls.Remove(pctClanInfo)
        pnlUserInfo.Controls.Remove(lblClanRank)
        pnlUserInfo.Controls.Remove(pctClanRank)
        pnlUserInfo.Controls.Remove(lblClanRanking)
        pnlUserInfo.Controls.Remove(lblJoin)
        pnlUserInfo.Controls.Remove(lblJoinDate)
        pnlUserInfo.RowCount = 3
        pnlUserInfo.RowStyles(1).SizeType = SizeType.AutoSize
        pnlUserInfo.RowStyles(2).SizeType = SizeType.Percent
        pnlUserInfo.RowStyles(2).Height = 100.0!
        pnlUserInfo.AutoSize = True
        tabWAR3Play.TabPages.Remove(tabWAR3PlayClan)
        tabWAR3Ladder.TabPages.Remove(tabWAR3LadderClan)
      Else
        lblClanName.Tag = InfoStrings(2)
      End If
      txtHomepage.BackColor = Color.Black
      txtHomepage.ForeColor = Color.White
      txtAdditionalInformation.BackColor = Color.Black
      txtAdditionalInformation.ForeColor = Color.White
    End If
  End Sub

  Public Sub LoadClanInfo(InfoStrings() As String)
    If Me.txtHomepage.InvokeRequired Then
      Dim d As New LoadClanInfoCallback(AddressOf LoadClanInfo)
      Me.BeginInvoke(d, New Object() {[InfoStrings]})
    Else
      lblClanName.Text = InfoStrings(0) & " [" & lblClanName.Tag & "]"
      Dim ClanRank As Byte = CByte(InfoStrings(1))
      lblClanRanking.Text = ClanRankToString(ClanRank)
      pctClanRank.Image = CType(Me.ParentForm.Tag, BNUI).imlClan.Images(ClanRank)
      Dim JoinDate As UInt64 = CULng(InfoStrings(2))
      lblJoinDate.Text = UInt64ToDate(JoinDate).ToString("f")
    End If
  End Sub

  Public Sub LoadWAR3Info(pktRead As BNCSReader)
    If Me.txtAdditionalInformation.InvokeRequired Then
      Dim d As New LoadAccountPacketCallback(AddressOf LoadWAR3Info)
      Me.BeginInvoke(d, New Object() {[pktRead]})
    Else
      Dim CommandID As Byte = pktRead.ReadByte
      Dim tBrush As New TextureBrush(My.Resources.RECORD_WAR3_EXPBAR)
      tBrush.ScaleTransform(1.0!, CSng(13 / My.Resources.RECORD_WAR3_EXPBAR.Height), Drawing2D.MatrixOrder.Prepend)
      Select Case CommandID
        Case &H4 'USER_STATS
          Dim Cookie As UInt32 = pktRead.ReadUInt32
          Dim IconName As String = pktRead.ReadDWORDString
          cmdIcon.Tag = IconName
          cmdIcon.Enabled = True
          If CType(Me.ParentForm.Tag, BNUI).W3Icons IsNot Nothing Then
            Dim IconID As String = (From IconInfo As BNUI.W3IconList In CType(Me.ParentForm.Tag, BNUI).W3Icons Where IconInfo.Name = IconName Select IconInfo.Icon).FirstOrDefault
            If IconName = "opeo" And String.IsNullOrEmpty(IconID) Then IconID = "W3O1"
            If String.IsNullOrEmpty(IconID) Then
              pctIcon.Image = pctIcon.ErrorImage
            Else
              If My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\Portrait\" & IIf(CType(Me.ParentForm.Tag, BNUI).Config.Account.Client.Product = BNUI.GameType.WAR3, "WAR3", "W3XP") & "_" & IconID & ".gif") Then
                pctIcon.Tag = Nothing
                pctIcon.Image = Image.FromFile(AppTemp & "\icons\WAR3\Portrait\" & IIf(CType(Me.ParentForm.Tag, BNUI).Config.Account.Client.Product = BNUI.GameType.WAR3, "WAR3", "W3XP") & "_" & IconID & ".gif").Clone
              Else
                pctIcon.Tag = IconID
                pctIcon.LoadAsync("http://classic.battle.net/war3/ladder/portraits/animated/" & IIf(CType(Me.ParentForm.Tag, BNUI).Config.Account.Client.Product = BNUI.GameType.WAR3, "WAR3", "W3XP") & "/" & IconID & ".gif")
              End If
            End If
          Else
            pctIcon.Image = pctIcon.ErrorImage
          End If
          Dim LadderRecords As Byte = pktRead.ReadByte
          If LadderRecords > 0 Then
            pnlWAR3LadderPersonal.SuspendLayout()
            pnlWAR3LadderPersonal.Controls.Clear()
            pnlWAR3LadderPersonal.RowStyles.Clear()
            For I As Byte = 0 To LadderRecords - 1
              pnlWAR3LadderPersonal.RowStyles.Add(New RowStyle(SizeType.Absolute, 50))
              Dim LadderType As String = pktRead.ReadDWORDString
              Dim Wins As UInt16 = pktRead.ReadUInt16
              Dim Losses As UInt16 = pktRead.ReadUInt16
              Dim Level As Byte = pktRead.ReadByte
              Dim Unknown As Byte = pktRead.ReadByte
              Dim Experience As UInt16 = pktRead.ReadInt16
              Dim Rank As UInt32 = pktRead.ReadInt32
              'UI Objects
              Dim pnlTmp As New TableLayoutPanel
              Dim lblLadderType As New Label
              Dim pnlRank As New TableLayoutPanel
              Dim lblRank As New Label
              Dim lblRankVal As New Label
              Dim pctLevel As New PictureBox
              Dim pnlRecord As New TableLayoutPanel
              Dim lblWins As New Label
              Dim lblLosses As New Label
              Dim lblWinsValue As New Label
              Dim lblLossesValue As New Label
              'pnlTmp
              pnlTmp.ColumnCount = 3
              pnlTmp.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 33.33333!))
              pnlTmp.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 33.33333!))
              pnlTmp.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 33.33333!))
              pnlTmp.RowCount = 2
              pnlTmp.RowStyles.Add(New RowStyle(SizeType.AutoSize))
              pnlTmp.RowStyles.Add(New RowStyle(SizeType.Percent, 100.0!))
              pnlTmp.Controls.Add(lblLadderType, 0, 0)
              pnlTmp.Controls.Add(pnlRank, 0, 1)
              pnlTmp.Controls.Add(pctLevel, 1, 1)
              pnlTmp.Controls.Add(pnlRecord, 2, 1)
              pnlTmp.Dock = DockStyle.Fill
              pnlTmp.Location = New System.Drawing.Point(0, 0)
              pnlTmp.Margin = New Padding(0)
              pnlTmp.Name = "pnlWAR3LadderPersonal" & I.ToString
              pnlTmp.Size = New System.Drawing.Size(237, 50)
              pnlTmp.TabIndex = I
              'lblLadderType
              lblLadderType.Anchor = AnchorStyles.Left
              lblLadderType.AutoSize = True
              lblLadderType.ForeColor = System.Drawing.Color.White
              lblLadderType.Margin = New Padding(3, 0, 0, 0)
              lblLadderType.Name = "lblWAR3LadderPersonalLadderType" & I.ToString
              lblLadderType.TabIndex = 0
              pnlTmp.SetColumnSpan(lblLadderType, 3)
              Select Case LadderType
                Case "SOLO" : lblLadderType.Text = ResMan.GetString("LADDER_SOLO")
                Case "TEAM" : lblLadderType.Text = ResMan.GetString("LADDER_TEAM")
                Case "FFA " : lblLadderType.Text = ResMan.GetString("LADDER_FFA")
              End Select
              'pnlRank
              pnlRank.ColumnCount = 1
              pnlRank.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 100.0!))
              pnlRank.RowCount = 2
              pnlRank.RowStyles.Add(New ColumnStyle(SizeType.AutoSize))
              pnlRank.RowStyles.Add(New ColumnStyle(SizeType.Percent, 100.0!))
              pnlRank.Controls.Add(lblRank, 0, 0)
              pnlRank.Controls.Add(lblRankVal, 0, 1)
              pnlRank.Dock = DockStyle.Fill
              'lblRank
              lblRank.Anchor = AnchorStyles.Top
              lblRank.AutoSize = True
              lblRank.ForeColor = System.Drawing.Color.Gold
              lblRank.Margin = New Padding(3, 0, 3, 0)
              lblRank.Name = "lblWAR3LadderPersonalRank" & I.ToString
              lblRank.TabIndex = 1
              lblRank.Text = ResMan.GetString("lblRank.Text")
              'lblRankVal
              lblRankVal.Anchor = AnchorStyles.None
              lblRankVal.AutoSize = True
              lblRankVal.ForeColor = System.Drawing.Color.White
              lblRankVal.Name = "lblWAR3LadderPersonalRankVal" & I.ToString
              lblRankVal.TabIndex = 2
              lblRankVal.Text = IIf(Rank > 0, Rank, ResMan.GetString("RANK_NONE"))
              'pctLevel
              pctLevel.Anchor = CType((AnchorStyles.Left Or AnchorStyles.Right), AnchorStyles)
              pctLevel.BorderStyle = TextBoxBorder
              pctLevel.Location = New System.Drawing.Point(3, 25)
              pctLevel.Name = "pctWAR3LadderPersonalLevel" & I.ToString
              pctLevel.Size = New System.Drawing.Size(65, 15)
              pctLevel.TabIndex = 4
              Dim b As Image = New Bitmap(pctLevel.DisplayRectangle.Width, pctLevel.DisplayRectangle.Height)
              Dim sF As SizeF
              Using g As Graphics = Graphics.FromImage(b)
                Dim ExpBar As Double = GetUserPercent(Experience, Level)
                g.FillRectangle(tBrush, New Rectangle(0, 0, ExpBar * (b.Width - 2), b.Height))
                sF = g.MeasureString(ResString(ResMan.GetString("pctLevel.Text"), Level), New Font("Microsoft Sans Serif", 7.0!, FontStyle.Regular, GraphicsUnit.Point, CType(0, Byte)))
              End Using
              Dim f As Image = New Bitmap(CInt(sF.Width), CInt(sF.Height))
              Using g As Graphics = Graphics.FromImage(f)
                g.TextRenderingHint = Drawing.Text.TextRenderingHint.SingleBitPerPixelGridFit
                g.DrawString(ResString(ResMan.GetString("pctLevel.Text"), Level), New Font("Microsoft Sans Serif", 7.0!, FontStyle.Regular, GraphicsUnit.Point, CType(0, Byte)), Brushes.White, 0, 0)
              End Using
              pctLevel.BackgroundImage = b
              pctLevel.BackgroundImageLayout = ImageLayout.Stretch
              pctLevel.Image = f
              pctLevel.SizeMode = PictureBoxSizeMode.CenterImage
              ttUI.SetToolTip(pctLevel, ResString(ResMan.GetString("pctLevel.ToolTip"), Experience, Unknown))
              'pnlRecord
              pnlRecord.ColumnCount = 2
              pnlRecord.ColumnStyles.Add(New ColumnStyle())
              pnlRecord.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 100.0!))
              pnlRecord.Controls.Add(lblWins, 0, 0)
              pnlRecord.Controls.Add(lblLosses, 0, 1)
              pnlRecord.Controls.Add(lblWinsValue, 1, 0)
              pnlRecord.Controls.Add(lblLossesValue, 1, 1)
              pnlRecord.Dock = DockStyle.Fill
              pnlRecord.Location = New System.Drawing.Point(71, 15)
              pnlRecord.Margin = New Padding(0)
              pnlRecord.Name = "pnlWAR3LadderPersonalRecord" & I.ToString
              pnlRecord.RowCount = 2
              pnlRecord.RowStyles.Add(New RowStyle(SizeType.Percent, 50.0!))
              pnlRecord.RowStyles.Add(New RowStyle(SizeType.Percent, 50.0!))
              pnlRecord.Size = New System.Drawing.Size(71, 35)
              pnlRecord.TabIndex = 5
              'lblWins
              lblWins.Anchor = AnchorStyles.Left
              lblWins.AutoSize = True
              lblWins.ForeColor = System.Drawing.Color.Gold
              lblWins.Location = New System.Drawing.Point(3, 2)
              lblWins.Margin = New Padding(3, 0, 0, 0)
              lblWins.Name = "lblWAR3LadderPersonalWins" & I.ToString
              lblWins.Size = New System.Drawing.Size(34, 13)
              lblWins.TabIndex = 0
              lblWins.Text = ResMan.GetString("lblWins.Text")
              'lblLosses
              lblLosses.Anchor = AnchorStyles.Left
              lblLosses.AutoSize = True
              lblLosses.ForeColor = System.Drawing.Color.Gold
              lblLosses.Location = New System.Drawing.Point(3, 19)
              lblLosses.Margin = New Padding(3, 0, 0, 0)
              lblLosses.Name = "lblWAR3LadderPersonalLosses" & I.ToString
              lblLosses.Size = New System.Drawing.Size(43, 13)
              lblLosses.TabIndex = 1
              lblLosses.Text = ResMan.GetString("lblLosses.Text")
              'lblWinsValue
              lblWinsValue.Anchor = AnchorStyles.Right
              lblWinsValue.AutoSize = True
              lblWinsValue.Location = New System.Drawing.Point(55, 2)
              lblWinsValue.Margin = New Padding(0, 0, 3, 0)
              lblWinsValue.Name = "lblWAR3LadderPersonalWinsValue" & I.ToString
              lblWinsValue.Size = New System.Drawing.Size(13, 13)
              lblWinsValue.TabIndex = 2
              lblWinsValue.Text = Wins
              'lblLossesValue
              lblLossesValue.Anchor = AnchorStyles.Right
              lblLossesValue.AutoSize = True
              lblLossesValue.Location = New System.Drawing.Point(55, 19)
              lblLossesValue.Margin = New Padding(0, 0, 3, 0)
              lblLossesValue.Name = "lblWAR3LadderPersonalLossesValue" & I.ToString
              lblLossesValue.Size = New System.Drawing.Size(13, 13)
              lblLossesValue.TabIndex = 3
              lblLossesValue.Text = Losses
              pnlWAR3LadderPersonal.Controls.Add(pnlTmp, 0, I)
            Next I
            pnlWAR3LadderPersonal.RowStyles.Add(New RowStyle(SizeType.Percent, 100))
            Dim lblTmp As New Label
            lblTmp.Text = String.Empty
            pnlWAR3LadderPersonal.Controls.Add(lblTmp, 0, LadderRecords)
            pnlWAR3LadderPersonal.AutoScrollMinSize = New Size(0, LadderRecords * 50)
            pnlWAR3LadderPersonal.ResumeLayout()
          Else
            tabWAR3Ladder.TabPages.Remove(tabWAR3LadderPersonal)
          End If
          Dim RaceRecords As Byte = pktRead.ReadByte
          If RaceRecords > 0 Then
            Dim Wins As UInt16
            Dim Losses As UInt16
            'RANDOM
            Wins = pktRead.ReadUInt16
            Losses = pktRead.ReadUInt16
            lblWAR3PlayPersonalRandomWins.Text = Wins
            lblWAR3PlayPersonalRandomLosses.Text = Losses
            lblWAR3PlayPersonalRandomPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")
            'HUMAN
            Wins = pktRead.ReadUInt16
            Losses = pktRead.ReadUInt16
            lblWAR3PlayPersonalHumanWins.Text = Wins
            lblWAR3PlayPersonalHumanLosses.Text = Losses
            lblWAR3PlayPersonalHumanPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")
            'ORC
            Wins = pktRead.ReadUInt16
            Losses = pktRead.ReadUInt16
            lblWAR3PlayPersonalOrcWins.Text = Wins
            lblWAR3PlayPersonalOrcLosses.Text = Losses
            lblWAR3PlayPersonalOrcPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")
            'UNDEAD
            Wins = pktRead.ReadUInt16
            Losses = pktRead.ReadUInt16
            lblWAR3PlayPersonalUndeadWins.Text = Wins
            lblWAR3PlayPersonalUndeadLosses.Text = Losses
            lblWAR3PlayPersonalUndeadPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")
            'NIGHT ELF
            Wins = pktRead.ReadUInt16
            Losses = pktRead.ReadUInt16
            lblWAR3PlayPersonalNightElfWins.Text = Wins
            lblWAR3PlayPersonalNightElfLosses.Text = Losses
            lblWAR3PlayPersonalNightElfPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")
            'TOURNAMENT
            If RaceRecords > 5 Then
              Wins = pktRead.ReadUInt16
              Losses = pktRead.ReadUInt16
            Else
              Wins = 0
              Losses = 0
            End If
            lblWAR3PlayPersonalTournamentWins.Text = Wins
            lblWAR3PlayPersonalTournamentLosses.Text = Losses
            lblWAR3PlayPersonalTournamentPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")
            'TOTAL
            Wins = Val(lblWAR3PlayPersonalHumanWins.Text) + Val(lblWAR3PlayPersonalOrcWins.Text) + Val(lblWAR3PlayPersonalUndeadWins.Text) + Val(lblWAR3PlayPersonalNightElfWins.Text) + Val(lblWAR3PlayPersonalRandomWins.Text)
            Losses = Val(lblWAR3PlayPersonalHumanLosses.Text) + Val(lblWAR3PlayPersonalOrcLosses.Text) + Val(lblWAR3PlayPersonalUndeadLosses.Text) + Val(lblWAR3PlayPersonalNightElfLosses.Text) + Val(lblWAR3PlayPersonalRandomLosses.Text)
            lblWAR3PlayPersonalTotalWins.Text = Wins
            lblWAR3PlayPersonalTotalLosses.Text = Losses
            lblWAR3PlayPersonalTotalPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")
            If Wins = 0 And Losses = 0 Then tabWAR3Play.TabPages.Remove(tabWAR3PlayPersonal)
          End If
          Dim TeamRecords As Byte = pktRead.ReadByte
          If TeamRecords > 0 Then
            pnlWAR3LadderTeam.SuspendLayout()
            pnlWAR3LadderTeam.Controls.Clear()
            pnlWAR3LadderTeam.RowStyles.Clear()
            For I As Byte = 0 To TeamRecords - 1
              pnlWAR3LadderTeam.RowStyles.Add(New RowStyle(SizeType.Absolute, 50))
              Dim Team As String = pktRead.ReadDWORDString
              Dim Wins As UInt16 = pktRead.ReadUInt16
              Dim Losses As UInt16 = pktRead.ReadUInt16
              Dim Level As Byte = pktRead.ReadByte
              Dim Unknown As Byte = pktRead.ReadByte
              Dim Experience As UInt16 = pktRead.ReadInt16
              Dim Rank As UInt32 = pktRead.ReadInt32
              Dim LastGame As UInt64 = pktRead.ReadInt64
              Dim Partners As Byte = pktRead.ReadByte
              Dim sPartners() As String = pktRead.ReadCStringArray(Partners)
              'UI Objects
              Dim pnlTmp As New TableLayoutPanel
              Dim lblLastGame As New Label
              Dim pctLevel As New PictureBox
              Dim pnlRecord As New TableLayoutPanel
              Dim lblWins As New Label
              Dim lblLosses As New Label
              Dim lblWinsValue As New Label
              Dim lblLossesValue As New Label
              Dim pnlPartners As New TableLayoutPanel
              Dim lblPartners As New Label
              Dim lblPartner1 As New Label
              Dim lblPartner2 As New Label
              Dim lblPartner3 As New Label
              'pnlTmp
              pnlTmp.ColumnCount = 3
              pnlTmp.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 30.0!))
              pnlTmp.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 30.0!))
              pnlTmp.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 40.0!))
              pnlTmp.Controls.Add(lblLastGame, 0, 0)
              pnlTmp.Controls.Add(pctLevel, 0, 1)
              pnlTmp.Controls.Add(pnlRecord, 1, 1)
              pnlTmp.Controls.Add(pnlPartners, 2, 1)
              pnlTmp.Dock = DockStyle.Fill
              pnlTmp.Location = New System.Drawing.Point(0, 0)
              pnlTmp.Margin = New Padding(0)
              pnlTmp.Name = "pnlWAR3LadderTeam" & I.ToString
              pnlTmp.RowCount = 2
              pnlTmp.RowStyles.Add(New RowStyle(SizeType.Absolute, 15.0!))
              pnlTmp.RowStyles.Add(New RowStyle(SizeType.Percent, 33.33333!))
              pnlTmp.RowStyles.Add(New RowStyle(SizeType.Absolute, 20.0!))
              pnlTmp.Size = New System.Drawing.Size(237, 50)
              pnlTmp.TabIndex = I
              'lblLastGame
              lblLastGame.Anchor = AnchorStyles.Left
              lblLastGame.AutoSize = True
              lblLastGame.AutoEllipsis = True
              pnlTmp.SetColumnSpan(lblLastGame, 3)
              lblLastGame.Font = New System.Drawing.Font("Microsoft Sans Serif", 9, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Pixel, CType(0, Byte))
              lblLastGame.ForeColor = System.Drawing.Color.Gray
              lblLastGame.Location = New System.Drawing.Point(3, 1)
              lblLastGame.Name = "lblWAR3LadderTeamLastGame" & I.ToString
              lblLastGame.Size = New System.Drawing.Size(83, 12)
              lblLastGame.TabIndex = 0
              lblLastGame.Text = ResString(ResMan.GetString("lblLastGame.Text"), UInt64ToDate(LastGame).ToString("F"))
              'pctLevel
              pctLevel.Anchor = CType((AnchorStyles.Left Or AnchorStyles.Right), AnchorStyles)
              pctLevel.BorderStyle = TextBoxBorder
              pctLevel.Location = New System.Drawing.Point(3, 25)
              pctLevel.Name = "pctWAR3LadderTeamLevel" & I.ToString
              pctLevel.Size = New System.Drawing.Size(65, 15)
              pctLevel.TabIndex = 4
              Dim b As Image = New Bitmap(pctLevel.DisplayRectangle.Width, pctLevel.DisplayRectangle.Height)
              Dim sF As SizeF
              Using g As Graphics = Graphics.FromImage(b)
                Dim ExpBar As Double = GetUserPercent(Experience, Level)
                g.FillRectangle(tBrush, New Rectangle(0, 0, ExpBar * (b.Width - 2), b.Height))
                sF = g.MeasureString(ResString(ResMan.GetString("pctLevel.Text"), Level), New Font("Microsoft Sans Serif", 7.0!, FontStyle.Regular, GraphicsUnit.Point, CType(0, Byte)))
              End Using
              Dim f As Image = New Bitmap(CInt(sF.Width), CInt(sF.Height))
              Using g As Graphics = Graphics.FromImage(f)
                g.TextRenderingHint = Drawing.Text.TextRenderingHint.SingleBitPerPixelGridFit
                g.DrawString(ResString(ResMan.GetString("pctLevel.Text"), Level), New Font("Microsoft Sans Serif", 7.0!, FontStyle.Regular, GraphicsUnit.Point, CType(0, Byte)), Brushes.White, 0, 0)
              End Using
              pctLevel.BackgroundImage = b
              pctLevel.BackgroundImageLayout = ImageLayout.Stretch
              pctLevel.Image = f
              pctLevel.SizeMode = PictureBoxSizeMode.CenterImage
              ttUI.SetToolTip(pctLevel, ResString(ResMan.GetString("pctLevel.ToolTipRank"), Experience, IIf(Rank = 0, ResMan.GetString("RANK_NONE"), Rank), Unknown))
              'pnlRecord
              pnlRecord.ColumnCount = 2
              pnlRecord.ColumnStyles.Add(New ColumnStyle())
              pnlRecord.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 100.0!))
              pnlRecord.Controls.Add(lblWins, 0, 0)
              pnlRecord.Controls.Add(lblLosses, 0, 1)
              pnlRecord.Controls.Add(lblWinsValue, 1, 0)
              pnlRecord.Controls.Add(lblLossesValue, 1, 1)
              pnlRecord.Dock = DockStyle.Fill
              pnlRecord.Location = New System.Drawing.Point(71, 15)
              pnlRecord.Margin = New Padding(0)
              pnlRecord.Name = "pnlWAR3LadderTeamRecord" & I.ToString
              pnlRecord.RowCount = 2
              pnlRecord.RowStyles.Add(New RowStyle(SizeType.Percent, 50.0!))
              pnlRecord.RowStyles.Add(New RowStyle(SizeType.Percent, 50.0!))
              pnlRecord.Size = New System.Drawing.Size(71, 35)
              pnlRecord.TabIndex = 5
              'lblWins
              lblWins.Anchor = AnchorStyles.Left
              lblWins.AutoSize = True
              lblWins.ForeColor = System.Drawing.Color.Gold
              lblWins.Location = New System.Drawing.Point(3, 2)
              lblWins.Margin = New Padding(3, 0, 0, 0)
              lblWins.Name = "lblWAR3LadderTeamWins" & I.ToString
              lblWins.Size = New System.Drawing.Size(34, 13)
              lblWins.TabIndex = 0
              lblWins.Text = ResMan.GetString("lblWins.Text")
              'lblLosses
              lblLosses.Anchor = AnchorStyles.Left
              lblLosses.AutoSize = True
              lblLosses.ForeColor = System.Drawing.Color.Gold
              lblLosses.Location = New System.Drawing.Point(3, 19)
              lblLosses.Margin = New Padding(3, 0, 0, 0)
              lblLosses.Name = "lblWAR3LadderTeamLosses" & I.ToString
              lblLosses.Size = New System.Drawing.Size(43, 13)
              lblLosses.TabIndex = 1
              lblLosses.Text = ResMan.GetString("lblLosses.Text")
              'lblWinsValue
              lblWinsValue.Anchor = AnchorStyles.Right
              lblWinsValue.AutoSize = True
              lblWinsValue.Location = New System.Drawing.Point(55, 2)
              lblWinsValue.Margin = New Padding(0, 0, 3, 0)
              lblWinsValue.Name = "lblWAR3LadderTeamWinsValue" & I.ToString
              lblWinsValue.Size = New System.Drawing.Size(13, 13)
              lblWinsValue.TabIndex = 2
              lblWinsValue.Text = Wins
              'lblLossesValue
              lblLossesValue.Anchor = AnchorStyles.Right
              lblLossesValue.AutoSize = True
              lblLossesValue.Location = New System.Drawing.Point(55, 19)
              lblLossesValue.Margin = New Padding(0, 0, 3, 0)
              lblLossesValue.Name = "lblWAR3LadderTeamLossesValue" & I.ToString
              lblLossesValue.Size = New System.Drawing.Size(13, 13)
              lblLossesValue.TabIndex = 3
              lblLossesValue.Text = Losses
              'pnlPartners
              pnlPartners.ColumnCount = 2
              pnlPartners.ColumnStyles.Add(New ColumnStyle())
              pnlPartners.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 100.0!))
              pnlPartners.Controls.Add(lblPartners, 0, 0)
              pnlPartners.Controls.Add(lblPartner1, 1, 0)
              pnlPartners.Controls.Add(lblPartner2, 1, 1)
              pnlPartners.Controls.Add(lblPartner3, 1, 2)
              pnlPartners.Dock = DockStyle.Fill
              pnlPartners.Location = New System.Drawing.Point(142, 15)
              pnlPartners.Margin = New Padding(0)
              pnlPartners.Name = "pnlWAR3LadderTeamPartners" & I.ToString
              pnlPartners.RowCount = 3
              pnlPartners.RowStyles.Add(New RowStyle(SizeType.Percent, 33.33!))
              pnlPartners.RowStyles.Add(New RowStyle(SizeType.Percent, 33.33!))
              pnlPartners.RowStyles.Add(New RowStyle(SizeType.Percent, 33.33!))
              pnlPartners.Size = New System.Drawing.Size(95, 35)
              pnlPartners.TabIndex = 12
              'pnlPartners.CellBorderStyle = TableLayoutPanelCellBorderStyle.Single
              'lblPartners
              lblPartners.Anchor = AnchorStyles.Left
              lblPartners.AutoSize = True
              lblPartners.Font = New System.Drawing.Font("Microsoft Sans Serif", 8, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Pixel, CType(0, Byte))
              lblPartners.ForeColor = System.Drawing.Color.Gold
              lblPartners.Location = New System.Drawing.Point(3, 0)
              lblPartners.Name = "lblWAR3LadderTeamPartners" & I.ToString
              lblPartners.Size = New System.Drawing.Size(36, 8)
              lblPartners.TabIndex = 0
              lblPartners.Text = ResMan.GetString("lblPartners.Text")
              'lblPartner1
              lblPartner1.Anchor = CType((AnchorStyles.Left Or AnchorStyles.Right), AnchorStyles)
              lblPartner1.AutoSize = False
              lblPartner1.AutoEllipsis = True
              lblPartner1.Font = New System.Drawing.Font("Microsoft Sans Serif", 8, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Pixel, CType(0, Byte))
              lblPartner1.Location = New System.Drawing.Point(45, 0)
              lblPartner1.Name = "lblWAR3LadderTeamPartner1" & I.ToString
              'lblPartner1.Size = New System.Drawing.Size(47, 8)
              lblPartner1.TabIndex = 3
              lblPartner1.BackColor = Color.Black
              If Partners > 0 Then lblPartner1.Text = sPartners(0)
              'lblPartner2
              lblPartner2.Anchor = CType((AnchorStyles.Left Or AnchorStyles.Right), AnchorStyles)
              lblPartner1.AutoSize = False
              lblPartner2.AutoEllipsis = True
              lblPartner2.Font = New System.Drawing.Font("Microsoft Sans Serif", 8, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Pixel, CType(0, Byte))
              lblPartner2.Location = New System.Drawing.Point(45, 8)
              lblPartner2.Name = "lblWAR3LadderTeamPartner2" & I.ToString
              'lblPartner2.Size = New System.Drawing.Size(47, 8)
              lblPartner2.TabIndex = 1
              lblPartner2.BackColor = Color.Black
              If Partners > 1 Then lblPartner2.Text = sPartners(1)
              'lblPartner3
              lblPartner3.Anchor = CType((AnchorStyles.Left Or AnchorStyles.Right), AnchorStyles) ' CType((AnchorStyles.Left Or AnchorStyles.Right Or AnchorStyles.Top Or AnchorStyles.Bottom), AnchorStyles)
              lblPartner1.AutoSize = False
              lblPartner3.AutoEllipsis = True
              lblPartner3.Font = New System.Drawing.Font("Microsoft Sans Serif", 8, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Pixel, CType(0, Byte))
              lblPartner3.Location = New System.Drawing.Point(45, 16)
              lblPartner3.Name = "lblWAR3LadderTeamPartner3" & I.ToString
              'lblPartner3.Size = New System.Drawing.Size(47, 8)
              lblPartner3.TabIndex = 4
              lblPartner3.BackColor = Color.Black
              If Partners > 2 Then lblPartner3.Text = sPartners(2)
              pnlWAR3LadderTeam.Controls.Add(pnlTmp, 0, I)
            Next I
            pnlWAR3LadderTeam.RowStyles.Add(New RowStyle(SizeType.Percent, 100))
            Dim lblTmp As New Label
            lblTmp.Text = String.Empty
            pnlWAR3LadderTeam.Controls.Add(lblTmp, 0, TeamRecords)
            pnlWAR3LadderTeam.AutoScrollMinSize = New Size(0, TeamRecords * 50)
            pnlWAR3LadderTeam.ResumeLayout()
          Else
            tabWAR3Ladder.TabPages.Remove(tabWAR3LadderTeam)
          End If
          If tabWAR3Play.TabPages.Count = 0 Then
            grpWAR3Play.Visible = False
            pnlProfile.Controls.Remove(grpWAR3Play)
            pnlProfile.RowCount = 5
          End If
          If tabWAR3Ladder.TabPages.Count = 0 Then
            grpWAR3Ladder.Visible = False
            pnlInfo.Controls.Remove(grpWAR3Ladder)
            pnlInfo.ColumnCount = 1
          End If
        Case &H8 'CLAN_STATS
          Dim Cookie As UInt32 = pktRead.ReadUInt32
          Dim ClanRecords As Byte = pktRead.ReadByte
          If ClanRecords > 0 Then
            pnlWAR3LadderClan.SuspendLayout()
            pnlWAR3LadderClan.Controls.Clear()
            pnlWAR3LadderClan.RowStyles.Clear()
            For I As Byte = 0 To ClanRecords - 1
              pnlWAR3LadderClan.RowStyles.Add(New RowStyle(SizeType.Absolute, 50))
              Dim LadderType As String = pktRead.ReadDWORDString
              Dim Wins As UInt32 = pktRead.ReadUInt32
              Dim Losses As UInt32 = pktRead.ReadUInt32
              Dim Level As Byte = pktRead.ReadByte
              Dim Unknown As Byte = pktRead.ReadByte
              Dim Experience As UInt32 = pktRead.ReadInt32
              Dim Rank As UInt32 = pktRead.ReadInt32
              'UI Objects
              Dim pnlTmp As New TableLayoutPanel
              Dim lblLadderType As New Label
              Dim pnlRank As New TableLayoutPanel
              Dim lblRank As New Label
              Dim lblRankVal As New Label
              Dim pctLevel As New PictureBox
              Dim pnlRecord As New TableLayoutPanel
              Dim lblWins As New Label
              Dim lblLosses As New Label
              Dim lblWinsValue As New Label
              Dim lblLossesValue As New Label
              'pnlTmp
              pnlTmp.ColumnCount = 3
              pnlTmp.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 33.33333!))
              pnlTmp.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 33.33333!))
              pnlTmp.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 33.33333!))
              pnlTmp.RowCount = 2
              pnlTmp.RowStyles.Add(New RowStyle(SizeType.AutoSize))
              pnlTmp.RowStyles.Add(New RowStyle(SizeType.Percent, 100.0!))
              pnlTmp.Controls.Add(lblLadderType, 0, 0)
              pnlTmp.Controls.Add(pnlRank, 0, 1)
              pnlTmp.Controls.Add(pctLevel, 1, 1)
              pnlTmp.Controls.Add(pnlRecord, 2, 1)
              pnlTmp.Dock = DockStyle.Fill
              pnlTmp.Location = New System.Drawing.Point(0, 0)
              pnlTmp.Margin = New Padding(0)
              pnlTmp.Name = "pnlWAR3LadderClan" & I.ToString
              pnlTmp.Size = New System.Drawing.Size(237, 50)
              pnlTmp.TabIndex = I
              'lblLadderType
              lblLadderType.Anchor = AnchorStyles.Left
              lblLadderType.AutoSize = True
              lblLadderType.ForeColor = System.Drawing.Color.White
              lblLadderType.Margin = New Padding(3, 0, 0, 0)
              lblLadderType.Name = "lblWAR3LadderClanLadderType" & I.ToString
              lblLadderType.TabIndex = 0
              pnlTmp.SetColumnSpan(lblLadderType, 3)
              Select Case LadderType
                Case "CLNS" : lblLadderType.Text = ResMan.GetString("LADDER_CLNS")
                Case "CLN2" : lblLadderType.Text = ResMan.GetString("LADDER_CLN2")
                Case "CLN3" : lblLadderType.Text = ResMan.GetString("LADDER_CLN3")
                Case "CLN4" : lblLadderType.Text = ResMan.GetString("LADDER_CLN4")
              End Select
              'pnlRank
              pnlRank.ColumnCount = 1
              pnlRank.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 100.0!))
              pnlRank.RowCount = 2
              pnlRank.RowStyles.Add(New ColumnStyle(SizeType.AutoSize))
              pnlRank.RowStyles.Add(New ColumnStyle(SizeType.Percent, 100.0!))
              pnlRank.Controls.Add(lblRank, 0, 0)
              pnlRank.Controls.Add(lblRankVal, 0, 1)
              pnlRank.Dock = DockStyle.Fill
              'lblRank
              lblRank.Anchor = AnchorStyles.Top
              lblRank.AutoSize = True
              lblRank.ForeColor = System.Drawing.Color.Gold
              lblRank.Margin = New Padding(3, 0, 3, 0)
              lblRank.Name = "lblWAR3LadderClanRank" & I.ToString
              lblRank.TabIndex = 1
              lblRank.Text = ResMan.GetString("lblRank.Text")
              'lblRankVal
              lblRankVal.Anchor = AnchorStyles.None
              lblRankVal.AutoSize = True
              lblRankVal.ForeColor = System.Drawing.Color.White
              lblRankVal.Name = "lblWAR3LadderClanRankVal" & I.ToString
              lblRankVal.TabIndex = 2
              lblRankVal.Text = IIf(Rank > 0, Rank, ResMan.GetString("RANK_NONE"))
              'pctLevel
              pctLevel.Anchor = CType((AnchorStyles.Left Or AnchorStyles.Right), AnchorStyles)
              pctLevel.BorderStyle = TextBoxBorder
              pctLevel.Location = New System.Drawing.Point(3, 25)
              pctLevel.Name = "pctWAR3LadderClanLevel" & I.ToString
              pctLevel.Size = New System.Drawing.Size(65, 15)
              pctLevel.TabIndex = 4
              Dim b As Image = New Bitmap(pctLevel.DisplayRectangle.Width, pctLevel.DisplayRectangle.Height)
              Dim sF As SizeF
              Using g As Graphics = Graphics.FromImage(b)
                Dim ExpBar As Double = GetClanPercent(Experience, Level)
                g.FillRectangle(tBrush, New Rectangle(0, 0, ExpBar * (b.Width - 2), b.Height))
                sF = g.MeasureString(ResString(ResMan.GetString("pctLevel.Text"), Level), New Font("Microsoft Sans Serif", 7.0!, FontStyle.Regular, GraphicsUnit.Point, CType(0, Byte)))
              End Using
              Dim f As Image = New Bitmap(CInt(sF.Width), CInt(sF.Height))
              Using g As Graphics = Graphics.FromImage(f)
                g.TextRenderingHint = Drawing.Text.TextRenderingHint.SingleBitPerPixelGridFit
                g.DrawString(ResString(ResMan.GetString("pctLevel.Text"), Level), New Font("Microsoft Sans Serif", 7.0!, FontStyle.Regular, GraphicsUnit.Point, CType(0, Byte)), Brushes.White, 0, 0)
              End Using
              pctLevel.BackgroundImage = b
              pctLevel.BackgroundImageLayout = ImageLayout.Stretch
              pctLevel.Image = f
              pctLevel.SizeMode = PictureBoxSizeMode.CenterImage
              ttUI.SetToolTip(pctLevel, ResString(ResMan.GetString("pctLevel.ToolTip"), Experience, Unknown))
              'pnlRecord
              pnlRecord.ColumnCount = 2
              pnlRecord.ColumnStyles.Add(New ColumnStyle())
              pnlRecord.ColumnStyles.Add(New ColumnStyle(SizeType.Percent, 100.0!))
              pnlRecord.Controls.Add(lblWins, 0, 0)
              pnlRecord.Controls.Add(lblLosses, 0, 1)
              pnlRecord.Controls.Add(lblWinsValue, 1, 0)
              pnlRecord.Controls.Add(lblLossesValue, 1, 1)
              pnlRecord.Dock = DockStyle.Fill
              pnlRecord.Location = New System.Drawing.Point(71, 15)
              pnlRecord.Margin = New Padding(0)
              pnlRecord.Name = "pnlWAR3LadderClanRecord" & I.ToString
              pnlRecord.RowCount = 2
              pnlRecord.RowStyles.Add(New RowStyle(SizeType.Percent, 50.0!))
              pnlRecord.RowStyles.Add(New RowStyle(SizeType.Percent, 50.0!))
              pnlRecord.Size = New System.Drawing.Size(71, 35)
              pnlRecord.TabIndex = 5
              'lblWins
              lblWins.Anchor = AnchorStyles.Left
              lblWins.AutoSize = True
              lblWins.ForeColor = System.Drawing.Color.Gold
              lblWins.Location = New System.Drawing.Point(3, 2)
              lblWins.Margin = New Padding(3, 0, 0, 0)
              lblWins.Name = "lblWAR3LadderClanWins" & I.ToString
              lblWins.Size = New System.Drawing.Size(34, 13)
              lblWins.TabIndex = 0
              lblWins.Text = ResMan.GetString("lblWins.Text")
              'lblLosses
              lblLosses.Anchor = AnchorStyles.Left
              lblLosses.AutoSize = True
              lblLosses.ForeColor = System.Drawing.Color.Gold
              lblLosses.Location = New System.Drawing.Point(3, 19)
              lblLosses.Margin = New Padding(3, 0, 0, 0)
              lblLosses.Name = "lblWAR3LadderClanLosses" & I.ToString
              lblLosses.Size = New System.Drawing.Size(43, 13)
              lblLosses.TabIndex = 1
              lblLosses.Text = ResMan.GetString("lblLosses.Text")
              'lblWinsValue
              lblWinsValue.Anchor = AnchorStyles.Right
              lblWinsValue.AutoSize = True
              lblWinsValue.Location = New System.Drawing.Point(55, 2)
              lblWinsValue.Margin = New Padding(0, 0, 3, 0)
              lblWinsValue.Name = "lblWAR3LadderClanWinsValue" & I.ToString
              lblWinsValue.Size = New System.Drawing.Size(13, 13)
              lblWinsValue.TabIndex = 2
              lblWinsValue.Text = Wins
              'lblLossesValue
              lblLossesValue.Anchor = AnchorStyles.Right
              lblLossesValue.AutoSize = True
              lblLossesValue.Location = New System.Drawing.Point(55, 19)
              lblLossesValue.Margin = New Padding(0, 0, 3, 0)
              lblLossesValue.Name = "lblWAR3LadderClanLossesValue" & I.ToString
              lblLossesValue.Size = New System.Drawing.Size(13, 13)
              lblLossesValue.TabIndex = 3
              lblLossesValue.Text = Losses
              pnlWAR3LadderClan.Controls.Add(pnlTmp, 0, I)
            Next I
            pnlWAR3LadderClan.RowStyles.Add(New RowStyle(SizeType.Percent, 100))
            Dim lblTmp As New Label
            lblTmp.Text = String.Empty
            pnlWAR3LadderClan.Controls.Add(lblTmp, 0, ClanRecords)
            pnlWAR3LadderClan.AutoScrollMinSize = New Size(0, ClanRecords * 50)
            pnlWAR3LadderClan.ResumeLayout()
          Else
            tabWAR3Ladder.TabPages.Remove(tabWAR3LadderClan)
          End If
          Dim ClanRaceRecords As Byte = pktRead.ReadByte
          If ClanRaceRecords > 0 Then
            Dim Wins As UInt32
            Dim Losses As UInt32

            Wins = pktRead.ReadUInt32
            Losses = pktRead.ReadUInt32
            lblWAR3PlayClanRandomWins.Text = Wins
            lblWAR3PlayClanRandomLosses.Text = Losses
            lblWAR3PlayClanRandomPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")

            Wins = pktRead.ReadUInt32
            Losses = pktRead.ReadUInt32
            lblWAR3PlayClanHumanWins.Text = Wins
            lblWAR3PlayClanHumanLosses.Text = Losses
            lblWAR3PlayClanHumanPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")

            Wins = pktRead.ReadUInt32
            Losses = pktRead.ReadUInt32
            lblWAR3PlayClanOrcWins.Text = Wins
            lblWAR3PlayClanOrcLosses.Text = Losses
            lblWAR3PlayClanOrcPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")

            Wins = pktRead.ReadUInt32
            Losses = pktRead.ReadUInt32
            lblWAR3PlayClanUndeadWins.Text = Wins
            lblWAR3PlayClanUndeadLosses.Text = Losses
            lblWAR3PlayClanUndeadPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")

            Wins = pktRead.ReadUInt32
            Losses = pktRead.ReadUInt32
            lblWAR3PlayClanNightElfWins.Text = Wins
            lblWAR3PlayClanNightElfLosses.Text = Losses
            lblWAR3PlayClanNightElfPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")

            If ClanRaceRecords > 5 Then
              Wins = pktRead.ReadUInt32
              Losses = pktRead.ReadUInt32
            Else
              Wins = 0
              Losses = 0
            End If
            lblWAR3PlayClanTournamentWins.Text = Wins
            lblWAR3PlayClanTournamentLosses.Text = Losses
            lblWAR3PlayClanTournamentPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")

            Wins = Val(lblWAR3PlayClanHumanWins.Text) + Val(lblWAR3PlayClanOrcWins.Text) + Val(lblWAR3PlayClanUndeadWins.Text) + Val(lblWAR3PlayClanNightElfWins.Text) + Val(lblWAR3PlayClanRandomWins.Text)
            Losses = Val(lblWAR3PlayClanHumanLosses.Text) + Val(lblWAR3PlayClanOrcLosses.Text) + Val(lblWAR3PlayClanUndeadLosses.Text) + Val(lblWAR3PlayClanNightElfLosses.Text) + Val(lblWAR3PlayClanRandomLosses.Text)
            lblWAR3PlayClanTotalWins.Text = Wins
            lblWAR3PlayClanTotalLosses.Text = Losses
            lblWAR3PlayClanTotalPercent.Text = IIf(Wins > 0 Or Losses > 0, Format(Wins / (Wins + Losses), "p").ToString, "0.00 %")
            If Wins = 0 And Losses = 0 Then tabWAR3Play.TabPages.Remove(tabWAR3PlayClan)
          Else
            tabWAR3Play.TabPages.Remove(tabWAR3PlayClan)
          End If
          If tabWAR3Play.TabPages.Count = 0 Then
            grpWAR3Play.Visible = False
            pnlProfile.Controls.Remove(grpWAR3Play)
            pnlProfile.RowCount = 5
          End If
          If tabWAR3Ladder.TabPages.Count = 0 Then
            grpWAR3Ladder.Visible = False
            pnlInfo.Controls.Remove(grpWAR3Ladder)
            pnlInfo.ColumnCount = 1
          End If
        Case &H9 'ICON_LIST
          Dim Cookie As UInt32 = pktRead.ReadUInt32
          Dim Unknown As UInt32 = pktRead.ReadUInt32
          Dim Tiers As Byte = pktRead.ReadByte
          Dim Count As Byte = pktRead.ReadByte
          For I As Byte = 0 To Count - 1
            Dim Icon As String = pktRead.ReadDWORDString()
            Dim Name As String = pktRead.ReadDWORDString()
            Dim Race As Byte = pktRead.ReadByte
            Dim Wins As UInt16 = pktRead.ReadInt16
            Dim Enabled As Byte = pktRead.ReadByte
            'Somethin else...
          Next I
      End Select
    End If
  End Sub

  Private Sub txtField_LinkClicked(sender As Object, e As System.Windows.Forms.LinkClickedEventArgs) Handles txtHomepage.LinkClicked, txtHomepage.LinkClicked, txtAdditionalInformation.LinkClicked
    Process.Start(e.LinkText)
  End Sub

  Private Function RaceFromIndex(Index As Integer) As String
    Select Case Index
      Case 0 : Return My.Resources.STATSTRING_W3_RACE_H
      Case 1 : Return My.Resources.STATSTRING_W3_RACE_O
      Case 2 : Return My.Resources.STATSTRING_W3_RACE_U
      Case 3 : Return My.Resources.STATSTRING_W3_RACE_N
      Case 4 : Return My.Resources.STATSTRING_W3_RACE_R
      Case 5 : Return My.Resources.STATSTRING_W3_RACE_D
      Case Else : Return ResString(My.Resources.STATSTRING_W3_UNKNOWN, PadHex(Index, 4)) ' "Unknown (0x" & IIf(Hex(Index).Length = 1, "0", String.Empty) & Hex(Index) & ")"
    End Select
  End Function

  Private Function GetUserPercent(CurrentXP As UInt16, Level As Byte) As Double
    Dim StartingXP, PreviousXP, NextXP As UInt16
    Select Case Level
      Case 0, 1
        PreviousXP = 0
        StartingXP = 0
        NextXP = 100
      Case 2
        PreviousXP = 0
        StartingXP = 100
        NextXP = 200
      Case 3
        PreviousXP = 100
        StartingXP = 200
        NextXP = 400
      Case 4
        PreviousXP = 200
        StartingXP = 400
        NextXP = 600
      Case 5
        PreviousXP = 400
        StartingXP = 600
        NextXP = 900
      Case 6
        PreviousXP = 600
        StartingXP = 900
        NextXP = 1200
      Case 7
        PreviousXP = 900
        StartingXP = 1200
        NextXP = 1600
      Case 8
        PreviousXP = 1200
        StartingXP = 1600
        NextXP = 2000
      Case 9
        PreviousXP = 1600
        StartingXP = 2000
        NextXP = 2500
      Case Is > 9
        PreviousXP = 2000 + ((Level - 10) * 500)
        StartingXP = 2000 + ((Level - 9) * 500)
        NextXP = 2000 + ((Level - 8) * 500)
    End Select
    If CurrentXP > StartingXP And CurrentXP < NextXP Then
      'More than current level
      Return 0.5 + (((CurrentXP - StartingXP) / (NextXP - StartingXP)) / 2)
    ElseIf CurrentXP < StartingXP And CurrentXP > PreviousXP Then
      'Less
      Return (((CurrentXP - PreviousXP) / (StartingXP - PreviousXP)) / 2)
    Else
      Return 0.5
    End If
  End Function

  Private Function GetClanPercent(CurrentXP As UInt32, Level As Byte) As Double
    Dim StartingXP, PreviousXP, NextXP As UInt32
    Select Case Level
      Case 0, 1
        PreviousXP = 0
        StartingXP = 0
        NextXP = 25000
      Case 2
        PreviousXP = 0
        StartingXP = 25000
        NextXP = 50000
      Case 3
        PreviousXP = 25000
        StartingXP = 50000
        NextXP = 75000
      Case 4
        PreviousXP = 50000
        StartingXP = 75000
        NextXP = 100000
      Case 5
        PreviousXP = 75000
        StartingXP = 100000
        NextXP = 150000
      Case 6
        PreviousXP = 100000
        StartingXP = 150000
        NextXP = 200000
      Case 7
        PreviousXP = 150000
        StartingXP = 200000
        NextXP = 250000
      Case 8
        PreviousXP = 200000
        StartingXP = 250000
        NextXP = 300000
      Case 9
        PreviousXP = 250000
        StartingXP = 300000
        NextXP = 350000
      Case Is > 9
        PreviousXP = 250000 + ((Level - 10) * 100000)
        StartingXP = 250000 + ((Level - 9) * 100000)
        NextXP = 250000 + ((Level - 8) * 100000)
    End Select
    If CurrentXP > StartingXP And CurrentXP < NextXP Then
      'More than current level
      Return 0.5 + (((CurrentXP - StartingXP) / (NextXP - StartingXP)) / 2)
    ElseIf CurrentXP < StartingXP And CurrentXP > PreviousXP Then
      'Less
      Return (((CurrentXP - PreviousXP) / (StartingXP - PreviousXP)) / 2)
    Else
      Return 0.5
    End If
  End Function

  Private Sub pnlWAR3LadderTeamList_SizeChanged(sender As Object, e As System.EventArgs) Handles pnlWAR3LadderTeam.SizeChanged
    pnlWAR3LadderTeam.Padding = New Padding(0, 0, 1, 0)
  End Sub

  Private Sub pctClanInfo_Click(sender As System.Object, e As System.EventArgs) Handles pctClanInfo.Click
    Process.Start("http://classic.battle.net/war3/ladder/" & IIf(CType(Me.ParentForm.Tag, BNUI).Config.Account.Client.Product = BNUI.GameType.WAR3, "war3", "w3xp") & "-clan-profile.aspx?Gateway=" & BNServerNames.GetGatewayName(CType(Me.ParentForm.Tag, BNUI).Config.Server, True).Split(" ")(0) & "&ClanTag=" & lblClanName.Tag)
  End Sub

  Private Sub cmdIcon_Click(sender As System.Object, e As System.EventArgs) Handles cmdIcon.Click
    frmW3IconSelection.Tag = Me.ParentForm.Tag
    frmW3IconSelection.CurrentIcon = cmdIcon.Tag
    If frmW3IconSelection.ShowDialog(Me.ParentForm) = DialogResult.OK Then
      Dim sIcon As String = frmW3IconSelection.CurrentIcon
      Dim UI As BNUI = Me.ParentForm.Tag
      If String.IsNullOrEmpty(sIcon) Then
        UI.BNCS_WARCRAFTGENERAL_Send(WID_SETICON, 0)
      Else
        UI.BNCS_WARCRAFTGENERAL_Send(WID_SETICON, BitConverter.ToUInt32(System.Text.Encoding.ASCII.GetBytes(StrReverse(sIcon)), 0))
      End If

    End If
  End Sub

  Private Sub pctWebProfile_Click(sender As System.Object, e As System.EventArgs) Handles pctWebProfile.Click
    Process.Start("http://classic.battle.net/war3/ladder/" & IIf(CType(Me.ParentForm.Tag, BNUI).Config.Account.Client.Product = BNUI.GameType.WAR3, "war3", "w3xp") & "-player-profile.aspx?Gateway=" & BNServerNames.GetGatewayName(CType(Me.ParentForm.Tag, BNUI).Config.Server, True).Split(" ")(0) & "&PlayerName=" & lblUserName.Text)
  End Sub

  Private Sub pctIcon_LoadCompleted(sender As Object, e As System.ComponentModel.AsyncCompletedEventArgs) Handles pctIcon.LoadCompleted
    If e.Error Is Nothing Then
      If pctIcon.Tag IsNot Nothing Then
        If Not My.Computer.FileSystem.DirectoryExists(AppTemp & "\icons\WAR3\Portrait") Then My.Computer.FileSystem.CreateDirectory(AppTemp & "\icons\WAR3\Portrait")
        pctIcon.Image.Save(AppTemp & "\icons\WAR3\Portrait\" & IIf(CType(Me.ParentForm.Tag, BNUI).Config.Account.Client.Product = BNUI.GameType.WAR3, "WAR3", "W3XP") & "_" & pctIcon.Tag & ".gif")
      End If
    Else
      pctIcon.Image = pctIcon.ErrorImage
    End If
  End Sub
End Class