﻿Public Class BNProfile

  Private Property pnlTeamList As Object

  Private Delegate Sub LoadAccountInfoCallback([bReadOnly] As Boolean, [InfoStrings] As String())
  Private Delegate Sub LoadAccountPacketCallback([bReadOnly] As Boolean, pktRead As BNCSReader)
  Public RecordProds As New ArrayList
  Private ResMan As New Resources.ResourceManager("Entelechy.BNProfile", Reflection.[Assembly].GetExecutingAssembly)

  Public Property sSex As String
    Get
      sSex = txtSex.Text
    End Get
    Set(value As String)
      txtSex.Text = value
    End Set
  End Property

  Public Property sAge As String
    Get
      sAge = txtAge.Text
    End Get
    Set(value As String)
      txtAge.Text = value
    End Set
  End Property

  Public Property sLocation As String
    Get
      sLocation = txtLocation.Text
    End Get
    Set(value As String)
      txtLocation.Text = value
    End Set
  End Property

  Public Property sDescription As String
    Get
      sDescription = txtDescription.Text
    End Get
    Set(value As String)
      txtDescription.Text = value
    End Set
  End Property

  Public Sub LoadProfileInfo(bReadOnly As Boolean, InfoStrings() As String)
    If Me.txtSex.InvokeRequired Then
      Dim d As New LoadAccountInfoCallback(AddressOf LoadProfileInfo)
      Me.BeginInvoke(d, New Object() {[bReadOnly], [InfoStrings]})
    Else
      txtSex.ReadOnly = bReadOnly
      txtAge.ReadOnly = bReadOnly
      txtLocation.ReadOnly = bReadOnly
      txtDescription.ReadOnly = bReadOnly
      txtSex.Text = DeCensor(InfoStrings(0))
      txtAge.Text = DeCensor(InfoStrings(1))
      txtLocation.Text = DeCensor(InfoStrings(2))
      txtDescription.Text = DeCensor(InfoStrings(3))
      txtSex.BackColor = Color.Black
      txtSex.ForeColor = Color.White
      txtAge.BackColor = Color.Black
      txtAge.ForeColor = Color.White
      txtLocation.BackColor = Color.Black
      txtLocation.ForeColor = Color.White
      txtDescription.BackColor = Color.Black
      txtDescription.ForeColor = Color.White
      'tabRecord_SelectedIndexChanged(New Object, New EventArgs)
    End If
  End Sub

  Private Function TrimTo4(sTmp As String) As String
    If sTmp.Length > 4 Then
      Return sTmp.Substring(0, 4)
    Else
      Return sTmp
    End If
  End Function

  Public Sub LoadSTARInfo(bReadOnly As Boolean, InfoStrings() As String)
    If Me.txtSex.InvokeRequired Then
      Dim d As New LoadAccountInfoCallback(AddressOf LoadSTARInfo)
      Me.BeginInvoke(d, New Object() {[bReadOnly], [InfoStrings]})
    Else
      If InfoStrings(3) = String.Empty And InfoStrings(8) = String.Empty Then
        If tbsRecord.TabPages.Contains(tabSTAR) Then tbsRecord.TabPages.Remove(tabSTAR)
      Else
        If Not tbsRecord.TabPages.Contains(tabSTAR) Then tbsRecord.TabPages.Add(tabSTAR)
        lblSTARNormalRecord.Text = ResString(ResMan.GetString("lblSTARNormalRecord.Text"), IIf(InfoStrings(0) = String.Empty, "0", InfoStrings(0)), IIf(InfoStrings(1) = String.Empty, "0", InfoStrings(1)))
        lblSTARNormalDisconnects.Text = ResString(ResMan.GetString("lblSTARNormalDisconnects.Text"), IIf(InfoStrings(2) = String.Empty, "0", InfoStrings(2)))
        lblSTARNormalLastGame.Text = ResString(ResMan.GetString("lblSTARNormalLastGame.Text"), IIf(InfoStrings(3) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(3)), FTStrToDate(InfoStrings(4)).ToString("M/dd/yyy HH:mm"))))
        lblSTARLadderRecord.Text = ResString(ResMan.GetString("lblSTARLadderRecord.Text"), IIf(InfoStrings(5) = String.Empty, "0", InfoStrings(5)), IIf(InfoStrings(6) = String.Empty, "0", InfoStrings(6)))
        lblSTARLadderDisconnects.Text = ResString(ResMan.GetString("lblSTARLadderDisconnects.Text"), IIf(InfoStrings(7) = String.Empty, "0", InfoStrings(7)))
        lblSTARLadderLastGame.Text = ResString(ResMan.GetString("lblSTARLadderLastGame.Text"), IIf(InfoStrings(8) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(8)), FTStrToDate(InfoStrings(9)).ToString("M/dd/yyy HH:mm"))))
        lblSTARLadderRatingValue.Text = IIf(InfoStrings(10) = String.Empty, ResMan.GetString("RATING_NONE"), InfoStrings(10))
        lblSTARLadderRatingHigh.Text = IIf(InfoStrings(11) = String.Empty, String.Empty, ResString(ResMan.GetString("lblSTARLadderRatingHigh.Text"), InfoStrings(11)))
        lblSTARLadderRankValue.Text = IIf(InfoStrings(12) = String.Empty Or InfoStrings(12) = "0", ResMan.GetString("RANK_NONE"), "#" & InfoStrings(12))
      End If
      tabRecord_SelectedIndexChanged(New Object, New EventArgs)
    End If
  End Sub

  Public Sub LoadSEXPInfo(bReadOnly As Boolean, InfoStrings() As String)
    If Me.txtSex.InvokeRequired Then
      Dim d As New LoadAccountInfoCallback(AddressOf LoadSEXPInfo)
      Me.BeginInvoke(d, New Object() {[bReadOnly], [InfoStrings]})
    Else
      If InfoStrings(3) = String.Empty And InfoStrings(8) = String.Empty Then
        If tbsRecord.TabPages.Contains(tabSEXP) Then tbsRecord.TabPages.Remove(tabSEXP)
      Else
        If Not tbsRecord.TabPages.Contains(tabSEXP) Then tbsRecord.TabPages.Add(tabSEXP)
        lblSEXPNormalRecord.Text = ResString(ResMan.GetString("lblSEXPNormalRecord.Text"), IIf(InfoStrings(0) = String.Empty, "0", InfoStrings(0)), IIf(InfoStrings(1) = String.Empty, "0", InfoStrings(1)))
        lblSEXPNormalDisconnects.Text = ResString(ResMan.GetString("lblSEXPNormalDisconnects.Text"), IIf(InfoStrings(2) = String.Empty, "0", InfoStrings(2)))
        lblSEXPNormalLastGame.Text = ResString(ResMan.GetString("lblSEXPNormalLastGame.Text"), IIf(InfoStrings(3) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(3)), FTStrToDate(InfoStrings(4)).ToString("M/dd/yyy HH:mm"))))
        lblSEXPLadderRecord.Text = ResString(ResMan.GetString("lblSEXPLadderRecord.Text"), IIf(InfoStrings(5) = String.Empty, "0", InfoStrings(5)), IIf(InfoStrings(6) = String.Empty, "0", InfoStrings(6)))
        lblSEXPLadderDisconnects.Text = ResString(ResMan.GetString("lblSEXPLadderDisconnects.Text"), IIf(InfoStrings(7) = String.Empty, "0", InfoStrings(7)))
        lblSEXPLadderLastGame.Text = ResString(ResMan.GetString("lblSEXPLadderLastGame.Text"), IIf(InfoStrings(8) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(8)), FTStrToDate(InfoStrings(9)).ToString("M/dd/yyy HH:mm"))))
        lblSEXPLadderRatingValue.Text = IIf(InfoStrings(10) = String.Empty, ResMan.GetString("RATING_NONE"), InfoStrings(10))
        lblSEXPLadderRatingHigh.Text = IIf(InfoStrings(11) = String.Empty, String.Empty, ResString(ResMan.GetString("lblSEXPLadderRatingHigh.Text"), InfoStrings(11)))
        lblSEXPLadderRankValue.Text = IIf(InfoStrings(12) = String.Empty Or InfoStrings(12) = "0", ResMan.GetString("RANK_NONE"), "#" & InfoStrings(12))
      End If
      tabRecord_SelectedIndexChanged(New Object, New EventArgs)
    End If
  End Sub

  Public Sub LoadJSTRInfo(bReadOnly As Boolean, InfoStrings() As String)
    If Me.txtSex.InvokeRequired Then
      Dim d As New LoadAccountInfoCallback(AddressOf LoadJSTRInfo)
      Me.BeginInvoke(d, New Object() {[bReadOnly], [InfoStrings]})
    Else
      If InfoStrings(3) = String.Empty And InfoStrings(8) = String.Empty Then
        If tbsRecord.TabPages.Contains(tabJSTR) Then tbsRecord.TabPages.Remove(tabJSTR)
      Else
        If Not tbsRecord.TabPages.Contains(tabJSTR) Then tbsRecord.TabPages.Add(tabJSTR)
        lblJSTRNormalRecord.Text = ResString(ResMan.GetString("lblJSTRNormalRecord.Text"), IIf(InfoStrings(0) = String.Empty, "0", InfoStrings(0)), IIf(InfoStrings(1) = String.Empty, "0", InfoStrings(1)))
        lblJSTRNormalDisconnects.Text = ResString(ResMan.GetString("lblJSTRNormalDisconnects.Text"), IIf(InfoStrings(2) = String.Empty, "0", InfoStrings(2)))
        lblJSTRNormalLastGame.Text = ResString(ResMan.GetString("lblJSTRNormalLastGame.Text"), IIf(InfoStrings(3) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(3)), FTStrToDate(InfoStrings(4)).ToString("M/dd/yyy HH:mm"))))
        lblJSTRLadderRecord.Text = ResString(ResMan.GetString("lblJSTRLadderRecord.Text"), IIf(InfoStrings(5) = String.Empty, "0", InfoStrings(5)), IIf(InfoStrings(6) = String.Empty, "0", InfoStrings(6)))
        lblJSTRLadderDisconnects.Text = ResString(ResMan.GetString("lblJSTRLadderDisconnects.Text"), IIf(InfoStrings(7) = String.Empty, "0", InfoStrings(7)))
        lblJSTRLadderLastGame.Text = ResString(ResMan.GetString("lblJSTRLadderLastGame.Text"), IIf(InfoStrings(8) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(8)), FTStrToDate(InfoStrings(9)).ToString("M/dd/yyy HH:mm"))))
        lblJSTRLadderRatingValue.Text = IIf(InfoStrings(10) = String.Empty, ResMan.GetString("RATING_NONE"), InfoStrings(10))
        lblJSTRLadderRatingHigh.Text = IIf(InfoStrings(11) = String.Empty, String.Empty, ResString(ResMan.GetString("lblJSTRLadderRatingHigh.Text"), InfoStrings(11)))
        lblJSTRLadderRankValue.Text = IIf(InfoStrings(12) = String.Empty Or InfoStrings(12) = "0", ResMan.GetString("RANK_NONE"), "#" & InfoStrings(12))
      End If
      tabRecord_SelectedIndexChanged(New Object, New EventArgs)
    End If
  End Sub

  Public Sub LoadSSHRInfo(bReadOnly As Boolean, InfoStrings() As String)
    If Me.txtSex.InvokeRequired Then
      Dim d As New LoadAccountInfoCallback(AddressOf LoadSSHRInfo)
      Me.BeginInvoke(d, New Object() {[bReadOnly], [InfoStrings]})
    Else
      If InfoStrings(3) = String.Empty And InfoStrings(8) = String.Empty Then
        If tbsRecord.TabPages.Contains(tabSSHR) Then tbsRecord.TabPages.Remove(tabSSHR)
      Else
        If Not tbsRecord.TabPages.Contains(tabSSHR) Then tbsRecord.TabPages.Add(tabSSHR)
        lblSSHRNormalRecord.Text = ResString(ResMan.GetString("lblSSHRNormalRecord.Text"), IIf(InfoStrings(0) = String.Empty, "0", InfoStrings(0)), IIf(InfoStrings(1) = String.Empty, "0", InfoStrings(1)))
        lblSSHRNormalDisconnects.Text = ResString(ResMan.GetString("lblSSHRNormalDisconnects.Text"), IIf(InfoStrings(2) = String.Empty, "0", InfoStrings(2)))
        lblSSHRNormalLastGame.Text = ResString(ResMan.GetString("lblSSHRLadderLastGame.Text"), IIf(InfoStrings(3) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(3)), FTStrToDate(InfoStrings(4)).ToString("M/dd/yyy HH:mm"))))
        lblSSHRLadderRecord.Text = ResString(ResMan.GetString("lblSSHRLadderRecord.Text"), IIf(InfoStrings(5) = String.Empty, "0", InfoStrings(5)), IIf(InfoStrings(6) = String.Empty, "0", InfoStrings(6)))
        lblSSHRLadderDisconnects.Text = ResString(ResMan.GetString("lblSSHRLadderDisconnects.Text"), IIf(InfoStrings(7) = String.Empty, "0", InfoStrings(7)))
        lblSSHRLadderLastGame.Text = ResString(ResMan.GetString("lblSSHRLadderLastGame.Text"), IIf(InfoStrings(8) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(8)), FTStrToDate(InfoStrings(9)).ToString("M/dd/yyy HH:mm"))))
        lblSSHRLadderRatingValue.Text = IIf(InfoStrings(10) = String.Empty, ResMan.GetString("RATING_NONE"), InfoStrings(10))
        lblSSHRLadderRatingHigh.Text = IIf(InfoStrings(11) = String.Empty, String.Empty, ResString(ResMan.GetString("lblSSHRLadderRatingHigh.Text"), InfoStrings(11)))
        lblSSHRLadderRankValue.Text = IIf(InfoStrings(12) = String.Empty Or InfoStrings(12) = "0", ResMan.GetString("RANK_NONE"), "#" & InfoStrings(12))
      End If
      tabRecord_SelectedIndexChanged(New Object, New EventArgs)
    End If
  End Sub

  Public Sub LoadW2BNInfo(bReadOnly As Boolean, InfoStrings() As String)
    If Me.txtSex.InvokeRequired Then
      Dim d As New LoadAccountInfoCallback(AddressOf LoadW2BNInfo)
      Me.BeginInvoke(d, New Object() {[bReadOnly], [InfoStrings]})
    Else
      If InfoStrings(3) = String.Empty And InfoStrings(8) = String.Empty And InfoStrings(16) = String.Empty Then
        If tbsRecord.TabPages.Contains(tabW2BN) Then tbsRecord.TabPages.Remove(tabW2BN)
        If tbsRecord.TabPages.Contains(tabW2BNIRON) Then tbsRecord.TabPages.Remove(tabW2BNIRON)
      Else
        If InfoStrings(13) = String.Empty And InfoStrings(14) = String.Empty And InfoStrings(15) = String.Empty And InfoStrings(16) = String.Empty Then
          'No Iron Man
          If tbsRecord.TabPages.Contains(tabW2BNIRON) Then tbsRecord.TabPages.Remove(tabW2BNIRON)
          If Not tbsRecord.TabPages.Contains(tabW2BN) Then tbsRecord.TabPages.Add(tabW2BN)
          lblW2BNNormalRecord.Text = ResString(ResMan.GetString("lblW2BNNormalRecord.Text"), IIf(InfoStrings(0) = String.Empty, "0", InfoStrings(0)), IIf(InfoStrings(1) = String.Empty, "0", InfoStrings(1)))
          lblW2BNNormalDisconnects.Text = ResString(ResMan.GetString("lblW2BNNormalDisconnects.Text"), IIf(InfoStrings(2) = String.Empty, "0", InfoStrings(2)))
          lblW2BNNormalLastGame.Text = ResString(ResMan.GetString("lblW2BNNormalLastGame.Text"), IIf(InfoStrings(3) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(3)), FTStrToDate(InfoStrings(4)).ToString("M/dd/yyy HH:mm"))))
          lblW2BNLadderRecord.Text = ResString(ResMan.GetString("lblW2BNLadderRecord.Text"), IIf(InfoStrings(5) = String.Empty, "0", InfoStrings(5)), IIf(InfoStrings(6) = String.Empty, "0", InfoStrings(6)))
          lblW2BNLadderDisconnects.Text = ResString(ResMan.GetString("lblW2BNLadderDisconnects.Text"), IIf(InfoStrings(7) = String.Empty, "0", InfoStrings(7)))
          lblW2BNLadderLastGame.Text = ResString(ResMan.GetString("lblW2BNLadderLastGame.Text"), IIf(InfoStrings(8) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(8)), FTStrToDate(InfoStrings(9)).ToString("M/dd/yyy HH:mm"))))
          lblW2BNLadderRatingValue.Text = IIf(InfoStrings(10) = String.Empty, ResMan.GetString("RATING_NONE"), InfoStrings(10))
          lblW2BNLadderRatingHigh.Text = IIf(InfoStrings(11) = String.Empty, String.Empty, ResString(ResMan.GetString("lblW2BNLadderRatingHigh.Text"), InfoStrings(11)))
          lblW2BNLadderRankValue.Text = IIf(InfoStrings(12) = String.Empty Or InfoStrings(12) = "0", ResMan.GetString("RANK_NONE"), "#" & InfoStrings(12))
        Else
          If Not tbsRecord.TabPages.Contains(tabW2BNIRON) Then tbsRecord.TabPages.Add(tabW2BNIRON)
          If tbsRecord.TabPages.Contains(tabW2BN) Then tbsRecord.TabPages.Remove(tabW2BN)
          lblW2BNIRONNormalRecord.Text = ResString(ResMan.GetString("lblW2BNIRONNormalRecord.Text"), IIf(InfoStrings(0) = String.Empty, "0", InfoStrings(0)), IIf(InfoStrings(1) = String.Empty, "0", InfoStrings(1)))
          lblW2BNIRONNormalDisconnects.Text = ResString(ResMan.GetString("lblW2BNIRONNormalDisconnects.Text"), IIf(InfoStrings(2) = String.Empty, "0", InfoStrings(2)))
          lblW2BNIRONNormalLastGame.Text = ResString(ResMan.GetString("lblW2BNIRONNormalLastGame.Text"), IIf(InfoStrings(3) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(3)), FTStrToDate(InfoStrings(4)).ToString("M/dd/yyy HH:mm"))))
          lblW2BNIRONLadderRecord.Text = ResString(ResMan.GetString("lblW2BNIRONLadderRecord.Text"), IIf(InfoStrings(5) = String.Empty, "0", InfoStrings(5)), IIf(InfoStrings(6) = String.Empty, "0", InfoStrings(6)))
          lblW2BNIRONLadderDisconnects.Text = ResString(ResMan.GetString("lblW2BNIRONLadderDisconnects.Text"), IIf(InfoStrings(7) = String.Empty, "0", InfoStrings(7)))
          lblW2BNIRONLadderLastGame.Text = ResString(ResMan.GetString("lblW2BNIRONLadderLastGame.Text"), IIf(InfoStrings(8) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(8)), FTStrToDate(InfoStrings(9)).ToString("M/dd/yyy HH:mm"))))
          lblW2BNIRONLadderRatingValue.Text = IIf(InfoStrings(10) = String.Empty, ResMan.GetString("RATING_NONE"), InfoStrings(10))
          lblW2BNIRONLadderRatingHigh.Text = IIf(InfoStrings(11) = String.Empty, String.Empty, ResString(ResMan.GetString("lblW2BNIRONLadderRatingHigh.Text"), InfoStrings(11)))
          lblW2BNIRONLadderRankValue.Text = IIf(InfoStrings(12) = String.Empty Or InfoStrings(12) = "0", ResMan.GetString("RANK_NONE"), "#" & InfoStrings(12))
          lblW2BNIRONRecord.Text = ResString(ResMan.GetString("lblW2BNIRONRecord.Text"), IIf(InfoStrings(13) = String.Empty, "0", InfoStrings(13)), IIf(InfoStrings(14) = String.Empty, "0", InfoStrings(14)))
          lblW2BNIRONDisconnects.Text = ResString(ResMan.GetString("lblW2BNIRONDisconnects.Text"), IIf(InfoStrings(15) = String.Empty, "0", InfoStrings(15)))
          lblW2BNIRONLastGame.Text = ResString(ResMan.GetString("lblW2BNIRONLastGame.Text"), IIf(InfoStrings(16) = String.Empty, ResMan.GetString("LAST_NEVER"), ResString(ResMan.GetString("LAST_GAME"), TrimTo4(InfoStrings(16)), FTStrToDate(InfoStrings(17)).ToString("M/dd/yyy HH:mm"))))
          lblW2BNIRONRatingValue.Text = IIf(InfoStrings(18) = String.Empty, ResMan.GetString("RATING_NONE"), InfoStrings(18))
          lblW2BNIRONRatingHigh.Text = IIf(InfoStrings(19) = String.Empty, String.Empty, ResString(ResMan.GetString("lblW2BNIRONRatingHigh.Text"), InfoStrings(19)))
          lblW2BNIRONRankValue.Text = IIf(InfoStrings(20) = String.Empty Or InfoStrings(20) = "0", ResMan.GetString("RANK_NONE"), "#" & InfoStrings(20))
        End If
      End If
      tabRecord_SelectedIndexChanged(New Object, New EventArgs)
    End If
  End Sub

  Private Sub txtField_LinkClicked(sender As Object, e As System.Windows.Forms.LinkClickedEventArgs) Handles txtDescription.LinkClicked, txtLocation.LinkClicked, txtSex.LinkClicked
    Process.Start(e.LinkText)
  End Sub

  Private Sub BNProfile_Load(sender As Object, e As System.EventArgs) Handles Me.Load
    pnlInfo.ColumnStyles(1).Width = 0
    Me.Tag = "Loading"
    imlProducts.Images.Clear()
    If My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\STAR.png") Then
      tbsRecord.ItemSize = New Size(35, 20)
      imlProducts.Images.Add(Image.FromFile(AppTemp & "\icons\icons\STAR.png"))
      imlProducts.Images.Add(Image.FromFile(AppTemp & "\icons\icons\SEXP.png"))
      imlProducts.Images.Add(Image.FromFile(AppTemp & "\icons\icons\JSTR.png"))
      imlProducts.Images.Add(Image.FromFile(AppTemp & "\icons\icons\SSHR.png"))
      imlProducts.Images.Add(Image.FromFile(AppTemp & "\icons\icons\W2BN.png"))
      tabSTAR.ImageIndex = 0
      tabSTAR.Text = String.Empty
      tabSEXP.ImageIndex = 1
      tabSEXP.Text = String.Empty
      tabJSTR.ImageIndex = 2
      tabJSTR.Text = String.Empty
      tabSSHR.ImageIndex = 3
      tabSSHR.Text = String.Empty
      tabW2BN.ImageIndex = 4
      tabW2BN.Text = String.Empty
      tabW2BNIRON.ImageIndex = 4
      tabW2BNIRON.Text = String.Empty
    Else
      tbsRecord.ItemSize = New Size(42, 18)
      tabSTAR.Text = "STAR"
      tabSEXP.Text = "SEXP"
      tabJSTR.Text = "JSTR"
      tabSSHR.Text = "SSHR"
      tabW2BN.Text = "W2BN"
      tabW2BNIRON.Text = "W2BN"
    End If
    If tbsRecord.TabPages.Contains(tabSTAR) Then tbsRecord.TabPages.Remove(tabSTAR)
    If tbsRecord.TabPages.Contains(tabSEXP) Then tbsRecord.TabPages.Remove(tabSEXP)
    If tbsRecord.TabPages.Contains(tabJSTR) Then tbsRecord.TabPages.Remove(tabJSTR)
    If tbsRecord.TabPages.Contains(tabSSHR) Then tbsRecord.TabPages.Remove(tabSSHR)
    If tbsRecord.TabPages.Contains(tabW2BN) Then tbsRecord.TabPages.Remove(tabW2BN)
    If tbsRecord.TabPages.Contains(tabW2BNIRON) Then tbsRecord.TabPages.Remove(tabW2BNIRON)
    Me.Tag = Nothing
  End Sub

  Private Sub tabRecord_SelectedIndexChanged(sender As Object, e As System.EventArgs) Handles tbsRecord.SelectedIndexChanged
    If Me.Tag IsNot "Loading" And tbsRecord.SelectedTab IsNot Nothing Then
      Select Case tbsRecord.SelectedTab.Name
        Case "tabSTAR", "tabSEXP", "tabJSTR", "tabSSHR"
          pnlInfo.ColumnStyles(0).Width = 100
          pnlInfo.ColumnStyles(1).SizeType = SizeType.Absolute
          pnlInfo.ColumnStyles(1).Width = 283
          tbsRecord.Dock = DockStyle.None
          tbsRecord.Size = New Size(277, 227)
        Case "tabW2BN"
          pnlInfo.ColumnStyles(0).Width = 100
          pnlInfo.ColumnStyles(1).SizeType = SizeType.Absolute
          pnlInfo.ColumnStyles(1).Width = 283
          tbsRecord.Dock = DockStyle.None
          tbsRecord.Size = New Size(277, 228)
        Case "tabW2BNIRON"
          pnlInfo.ColumnStyles(0).Width = 100
          pnlInfo.ColumnStyles(1).SizeType = SizeType.Absolute
          pnlInfo.ColumnStyles(1).Width = 283
          tbsRecord.Dock = DockStyle.None
          tbsRecord.Size = New Size(277, 276)
      End Select
    End If
  End Sub
End Class