﻿Imports System.Text.RegularExpressions

Public Class GeckoChat
  Public Enum ChatType
    None
    UserChat
    UserWhisper
    SelfChat
    FriendChat
    StatChat
    Emote
    D2Emote
    ServiceInfo
    ServiceError
    ServiceSuccess
    ServiceBroadcast
    HelpInfo
    VerboseInfo
  End Enum
  Public Class NameClickEventArgs
    Inherits EventArgs
    Dim c_Account As String
    Dim c_Mouse As MouseEventArgs
    Public Sub New()
      c_Account = Nothing
    End Sub
    Public Sub New(Account As String)
      c_Account = Account
    End Sub
    Public Sub New(Account As String, Mouse As MouseEventArgs)
      c_Account = Account
      c_Mouse = Mouse
    End Sub
    Public Property Account As String
      Get
        Return c_Account
      End Get
      Set(value As String)
        c_Account = value
      End Set
    End Property
    Public Property Mouse As MouseEventArgs
      Get
        Return c_Mouse
      End Get
      Set(value As MouseEventArgs)
        c_Mouse = value
      End Set
    End Property
  End Class
  Public Class LinkClickEventArgs
    Inherits EventArgs
    Dim c_URL As String
    Dim c_Mouse As MouseEventArgs
    Public Sub New()
      c_URL = Nothing
    End Sub
    Public Sub New(URL As String)
      c_URL = URL
    End Sub
    Public Sub New(URL As String, Mouse As MouseEventArgs)
      c_URL = URL
      c_Mouse = Mouse
    End Sub
    Public Property URL As String
      Get
        Return c_URL
      End Get
      Set(value As String)
        c_URL = value
      End Set
    End Property
    Public Property Mouse As MouseEventArgs
      Get
        Return c_Mouse
      End Get
      Set(value As MouseEventArgs)
        c_Mouse = value
      End Set
    End Property
  End Class
  Private Class URLTitleGrabber
    Implements IDisposable
    Private WithEvents webClient As Net.WebClient
    Public Event UpdateHTMLTitle(URL As String, Title As String)
    Public Event UpdateHTMLObject(URL As String, ContentType As String, ContentLength As UInt32)
    Private Structure DBList
      Public URL As String
      Public Title As String
    End Structure
    Private TitleList As New Collections.ArrayList

    Public Sub New()
      webClient = New Net.WebClient
      webClient.CachePolicy = New Net.Cache.HttpRequestCachePolicy(Net.Cache.HttpRequestCacheLevel.CacheIfAvailable)
    End Sub

    Public Function GetHTMLTitle(URL As String) As String
      Try
        Dim tItem As DBList = (From titleItem As DBList In TitleList Where StrComp(titleItem.URL, URL, CompareMethod.Text) = 0 Select titleItem).FirstOrDefault
        If String.IsNullOrEmpty(tItem.Title) OrElse tItem.URL = tItem.Title Then
          If webClient.IsBusy Then
            Return URL
          Else
            If URL.StartsWith("www.") Then
              webClient.DownloadStringAsync(New Uri("http://" & URL), URL)
            ElseIf URL.StartsWith("http://") Or URL.StartsWith("https://") Then
              webClient.DownloadStringAsync(New Uri(URL), URL)
            ElseIf URL.StartsWith("file://") Then
              webClient.DownloadStringAsync(New Uri(URL), URL)
            End If
            Return URL
          End If
        Else
          Return tItem.Title
        End If
      Catch ex As Exception
        Return URL & " unresolvable."
      End Try
    End Function

    Private Sub webClient_DownloadProgressChanged(sender As Object, e As System.Net.DownloadProgressChangedEventArgs) Handles webClient.DownloadProgressChanged
      If Not String.IsNullOrEmpty(webClient.ResponseHeaders("Content-Type")) Then
        Dim ContentType As String = webClient.ResponseHeaders("Content-Type")
        If ContentType.Contains(";") Then ContentType = ContentType.Split(";"c).First
        Select Case ContentType.ToLower
          Case "text/html"
            If e.TotalBytesToReceive > 1024 * 1024 Then
              Dim tItem As DBList
              tItem.URL = e.UserState
              tItem.Title = webClient.ResponseHeaders("Content-Type") & " (" & ByteSize(e.TotalBytesToReceive) & ")"
              TitleList.Add(tItem)
              RaiseEvent UpdateHTMLTitle(tItem.URL, tItem.Title)
              webClient.CancelAsync()
            ElseIf e.TotalBytesToReceive = -1 Then
              If e.BytesReceived > 1024 * 1024 Then
                Dim tItem As DBList
                tItem.URL = e.UserState
                tItem.Title = webClient.ResponseHeaders("Content-Type") & " (Unknown Size [Over 1 MB])"
                TitleList.Add(tItem)
                RaiseEvent UpdateHTMLTitle(tItem.URL, tItem.Title)
                webClient.CancelAsync()
              End If
            End If
          Case "image/gif", "image/jpeg", "image/png", "image/svg+xml", "image/tiff", "image/vnd.microsoft.icon", "audio/wave", "audio/wav", "audio/x-wav", "audio/x-pn-wav", "audio/webm", "audio/ogg", "video/webm", "video/ogg", "application/ogg"
            Dim tItem As DBList
            tItem.URL = e.UserState
            tItem.Title = webClient.ResponseHeaders("Content-Type") & " (" & ByteSize(e.TotalBytesToReceive) & ")"
            TitleList.Add(tItem)
            RaiseEvent UpdateHTMLObject(tItem.URL, webClient.ResponseHeaders("Content-Type"), e.TotalBytesToReceive)
          Case Else
            If e.TotalBytesToReceive > 1024 * 512 Then
              Dim tItem As DBList
              tItem.URL = e.UserState
              tItem.Title = webClient.ResponseHeaders("Content-Type") & " (" & ByteSize(e.TotalBytesToReceive) & ")"
              TitleList.Add(tItem)
              RaiseEvent UpdateHTMLTitle(tItem.URL, tItem.Title)
              webClient.CancelAsync()
            ElseIf e.TotalBytesToReceive = -1 Then
              Dim tItem As DBList
              tItem.URL = e.UserState
              tItem.Title = webClient.ResponseHeaders("Content-Type") & " (Unknown Size)"
              TitleList.Add(tItem)
              RaiseEvent UpdateHTMLTitle(tItem.URL, tItem.Title)
              webClient.CancelAsync()
            End If
        End Select
      Else
        If e.TotalBytesToReceive > 1024 * 512 Then
          Dim tItem As DBList
          tItem.URL = e.UserState
          tItem.Title = "Unknown Content Type (" & ByteSize(e.TotalBytesToReceive) & ")"
          TitleList.Add(tItem)
          RaiseEvent UpdateHTMLTitle(tItem.URL, tItem.Title)
          webClient.CancelAsync()
        ElseIf e.TotalBytesToReceive = -1 Then
          Dim tItem As DBList
          tItem.URL = e.UserState
          tItem.Title = "Unknown Content Type (Unknown Size)"
          TitleList.Add(tItem)
          RaiseEvent UpdateHTMLTitle(tItem.URL, tItem.Title)
          webClient.CancelAsync()
        End If
      End If
    End Sub

    Private Sub webClient_DownloadStringCompleted(sender As Object, e As System.Net.DownloadStringCompletedEventArgs) Handles webClient.DownloadStringCompleted
      If e.Error Is Nothing Then
        Dim result As String = e.Result
        If Not String.IsNullOrEmpty(webClient.ResponseHeaders("Content-Type")) Then
          Dim ContentType As String = webClient.ResponseHeaders("Content-Type")
          If ContentType.Contains(";") Then ContentType = ContentType.Split(";"c).First
          Select Case ContentType.ToLower
            Case "text/html"
              If Not (String.IsNullOrEmpty(result) Or result = "0") Then
                If InStr(result, "<title", CompareMethod.Text) > 0 Then
                  Dim sText As String = result.Substring(InStr(result, "<title", CompareMethod.Text) + 5)
                  sText = sText.Substring(InStr(sText, ">", CompareMethod.Text))
                  sText = sText.Substring(0, InStr(sText, "</title>", CompareMethod.Text) - 1)
                  Dim tItem As DBList
                  tItem.URL = e.UserState
                  tItem.Title = sText.Replace(vbCr, String.Empty).Replace(vbLf, String.Empty).Trim.Replace("&", "&&")
                  If tItem.Title.Contains("YouTube        - ") Then tItem.Title = tItem.Title.Replace("YouTube        - ", "YouTube - ")
                  TitleList.Add(tItem)
                  RaiseEvent UpdateHTMLTitle(tItem.URL, tItem.Title)
                  Exit Sub
                End If
              End If
            Case "image/gif", "image/jpeg", "image/png", "image/svg+xml", "image/tiff", "image/vnd.microsoft.icon", "audio/wave", "audio/wav", "audio/x-wav", "audio/x-pn-wav", "audio/webm", "audio/ogg", "video/webm", "video/ogg"
              Dim tItem As DBList
              tItem.URL = e.UserState
              tItem.Title = webClient.ResponseHeaders("Content-Type") & " (" & ByteSize(result.Length) & ")"
              TitleList.Add(tItem)
              RaiseEvent UpdateHTMLObject(tItem.URL, webClient.ResponseHeaders("Content-Type"), result.Length)
            Case Else
              Dim tItem As DBList
              tItem.URL = e.UserState
              tItem.Title = webClient.ResponseHeaders("Content-Type") & " (" & ByteSize(result.Length) & ")"
              TitleList.Add(tItem)
              RaiseEvent UpdateHTMLTitle(tItem.URL, tItem.Title)
          End Select
        End If
      Else
        Dim tItem As DBList
        tItem.URL = e.UserState
        tItem.Title = e.Error.Message
        TitleList.Add(tItem)
        RaiseEvent UpdateHTMLTitle(tItem.URL, tItem.Title)
      End If
    End Sub

#Region "IDisposable Support"
    Private disposedValue As Boolean ' To detect redundant calls

    ' IDisposable
    Protected Overridable Sub Dispose(disposing As Boolean)
      If Not Me.disposedValue Then
        If disposing Then
          ' TODO: dispose managed state (managed objects).
          webClient.Dispose()
        End If

        ' TODO: free unmanaged resources (unmanaged objects) and override Finalize() below.
        ' TODO: set large fields to null.
      End If
      Me.disposedValue = True
    End Sub

    ' TODO: override Finalize() only if Dispose( disposing As Boolean) above has code to free unmanaged resources.
    'Protected Overrides Sub Finalize()
    '    ' Do not change this code.  Put cleanup code in Dispose( disposing As Boolean) above.
    '    Dispose(False)
    '    MyBase.Finalize()
    'End Sub

    ' This code added by Visual Basic to correctly implement the disposable pattern.
    Public Sub Dispose() Implements IDisposable.Dispose
      ' Do not change this code.  Put cleanup code in Dispose( disposing As Boolean) above.
      Dispose(True)
      GC.SuppressFinalize(Me)
    End Sub
#End Region
  End Class
  Private Class GeckoBox
    Inherits Skybound.Gecko.GeckoWebBrowser
    Protected Overrides Sub OnPaint(e As System.Windows.Forms.PaintEventArgs)
      e.Graphics.Clear(Color.Black)
      Dim sFmt As New Drawing.StringFormat
      sFmt.Alignment = StringAlignment.Near
      sFmt.LineAlignment = StringAlignment.Near
      Dim uCount As UInt64 = MyBase.Document.GetElementsByClassName("contents").Count
      If uCount > 0 Then
        Dim uVal As UInt64 = 2
        For I As Integer = 0 To uCount - 1
          Dim sText As String = MyBase.Document.GetElementsByClassName("contents")(I).TextContent
          Dim brushColor As Brush
          Dim sType As String = "text"
          If MyBase.Document.GetElementsByClassName("contents")(I).HasChildNodes Then
            If MyBase.Document.GetElementsByClassName("contents")(I).ChildNodes.Count > 1 Then
              If MyBase.Document.GetElementsByClassName("contents")(I).ChildNodes(1).HasAttributes Then sType = MyBase.Document.GetElementsByClassName("contents")(I).ChildNodes(1).Attributes(0).NodeValue
            Else
              If MyBase.Document.GetElementsByClassName("contents")(I).ChildNodes(0).HasAttributes Then sType = MyBase.Document.GetElementsByClassName("contents")(I).ChildNodes(0).Attributes(0).NodeValue
            End If
          End If
          If sType.Contains(" ") Then sType = Split(sType, " ")(0)
          Select Case sType
            Case "text" : brushColor = Brushes.White
            Case "emote" : brushColor = Brushes.Yellow
            Case "d2emote", "whisper" : brushColor = Brushes.Gray
            Case "info" : brushColor = Brushes.Yellow
            Case "error" : brushColor = Brushes.Red
            Case "success" : brushColor = Brushes.Lime
            Case "broadcast" : brushColor = Brushes.Orange
            Case Else : brushColor = Brushes.White
          End Select
          If MyBase.Document.DocumentElement.ScrollTop > 0 Then
            e.Graphics.DrawString(sText, New Font(Drawing.FontFamily.GenericSansSerif, 10, FontStyle.Regular, GraphicsUnit.Point), brushColor, New Rectangle(0, uVal - MyBase.Document.DocumentElement.ScrollTop, MyBase.DisplayRectangle.Width, MyBase.Document.GetElementsByClassName("contents")(I).ParentElement.ClientHeight), sFmt)
          Else
            e.Graphics.DrawString(sText, New Font(Drawing.FontFamily.GenericSansSerif, 10, FontStyle.Regular, GraphicsUnit.Point), brushColor, New Rectangle(0, uVal, MyBase.DisplayRectangle.Width, MyBase.Document.GetElementsByClassName("contents")(I).ParentElement.ClientHeight), sFmt)
          End If
          uVal += MyBase.Document.GetElementsByClassName("contents")(I).ParentElement.ClientHeight + 4
          If e.ClipRectangle.Height > 0 Then
            'If uVal - 4 > e.ClipRectangle.Height Then Exit For
          End If

        Next
        'e.Graphics.DrawString("Preview not available" & vbNewLine & "Feature will return soon", New Font(FontFamily.GenericSerif, 24, FontStyle.Regular, GraphicsUnit.Pixel), Brushes.Crimson, MyBase.DisplayRectangle, sFmt)
        'e.Graphics.DrawRectangle(Pens.Gray, MyBase.DisplayRectangle)
      End If
      MyBase.OnPaint(e)
    End Sub
  End Class
  Public Event UserNameClick(sender As Object, e As NameClickEventArgs)
  Public Event UserNameHover(sender As Object, e As NameClickEventArgs)
  Public Event HyperlinkClick(sender As Object, e As LinkClickEventArgs)
  Public Shadows Event MouseDown(sender As Object, e As MouseEventArgs)
  Public Shadows Event MouseUp(sender As Object, e As MouseEventArgs)
  Public Event ReconnectResult(sender As Object, e As Boolean)
  Private sTimeStampFormat As String
  Private bTimeStampEnabled As Boolean
  Private bEmoticons As Boolean
  Private bRichText As Boolean
  Private lMaxLines As UInt32
  Private sLogFile As String
  Private sCSS As String
  Private Delegate Sub AddChatCallBack(ctType As ChatType, sName As String, sMessage As String, sMsgID As String)
  Private Delegate Sub UpdateProgressCallBack(sID As String, sMessage As String)
  Private Delegate Sub CallBack(Obj As Object)
  Private Const ScrollGive As Integer = 30
  Private WithEvents titleGrabber As New URLTitleGrabber
  Private WithEvents tmrReconnect As New Timers.Timer(1000)
  Private WithEvents gwBrowse As GeckoBox
  Private ReconnectMessage As String
  Private ReconnectLeft As UShort

  Public Property MaxLines As UInt32
    Get
      Return lMaxLines
    End Get
    Set(value As UInt32)
      lMaxLines = value
      TrimLines()
    End Set
  End Property

  Public Property TimeStampFormat As String
    Get
      Return sTimeStampFormat
    End Get
    Set(value As String)
      sTimeStampFormat = value
      RedoTimestamps()
    End Set
  End Property

  Public Property LogFile As String
    Get
      Return sLogFile
    End Get
    Set(value As String)
      If String.IsNullOrEmpty(sLogFile) And Not String.IsNullOrEmpty(value) Then
        sLogFile = value
        SaveLog("<tr><td style=""display: table-cell;"" time=""" & Now & """ name=""timestamp"" class=""timestamp"">" & Now.ToString(sTimeStampFormat) & "&nbsp;</td><td class=""chat""><table class=""message""><tr><td><div class=""contents""><span class=""info"">Logging Enabled - " & Now.ToString("D") & ".</span></div></td></tr></table></td></tr>")
        SaveLog("<tr><td colspan=""2""><hr></td></tr>")
      ElseIf Not String.IsNullOrEmpty(sLogFile) And String.IsNullOrEmpty(value) Then
        SaveLog("<tr><td colspan=""2""><hr></td></tr>")
        SaveLog("<tr><td style=""display: table-cell;"" time=""" & Now & """ name=""timestamp"" class=""timestamp"">" & Now.ToString(sTimeStampFormat) & "&nbsp;</td><td class=""chat""><table class=""message""><tr><td><div class=""contents""><span class=""info"">Logging Disabled - " & Now.ToString("D") & ".</span></div></td></tr></table></td></tr>")
        sLogFile = String.Empty
      Else
        sLogFile = value
      End If
    End Set
  End Property

  Public Property Emoticons As Boolean
    Get
      Return bEmoticons
    End Get
    Set(value As Boolean)
      bEmoticons = value
      RedoEmoticons()
    End Set
  End Property

  Public Property RichText As Boolean
    Get
      Return bRichText
    End Get
    Set(value As Boolean)
      bRichText = value
    End Set
  End Property

  Public ReadOnly Property AtBottom As Boolean
    Get
      Try
        If gwBrowse Is Nothing Then Return False
        If gwBrowse.Document Is Nothing Then Return False
        Return (gwBrowse.Document.DocumentElement.ScrollHeight - gwBrowse.Document.DocumentElement.ScrollTop < gwBrowse.Document.DocumentElement.OffsetHeight + ScrollGive)
      Catch ex As Exception
        Return False
      End Try
    End Get
  End Property

  Public Sub ToBottom()
    gwBrowse.Document.DocumentElement.ScrollTop = (gwBrowse.Document.DocumentElement.ScrollHeight - gwBrowse.Document.DocumentElement.OffsetHeight)
  End Sub

  Private Sub SaveLog(Line As String)
    If Not My.Computer.FileSystem.FileExists(sLogFile) Then
      If Not My.Computer.FileSystem.DirectoryExists(IO.Path.GetDirectoryName(sLogFile)) Then My.Computer.FileSystem.CreateDirectory(IO.Path.GetDirectoryName(sLogFile))
      My.Computer.FileSystem.WriteAllText(sLogFile, "<!DOCTYPE html>" & vbNewLine &
                                                   "<html>" & vbNewLine &
                                                   " <head>" & vbNewLine &
                                                   "  <title>" & IO.Path.GetFileNameWithoutExtension(sLogFile) & " Chat Log</title>" & vbNewLine &
                                                   "  <meta http-equiv=""Content-Type"" content=""text/html; charset=utf-8"" />" & vbNewLine &
                                                   "  <style type=""text/css"">" & vbNewLine &
                                                   "   html{height: 100%;} body{background-color: black; background-image: -moz-linear-gradient(bottom, black, #141414); background-repeat: no-repeat; background-attachment: fixed; color: yellow; margin: 0; padding: 0; top: 0; left: 0; font-family: Microsoft Sans Serif; font-size: 10pt;} table.chat{width: 100%; margin: 0; padding: 0;} td.timestamp{color: white; white-space: nowrap; vertical-align: top; width: 100px;} td.chat{width: 100%;} table.message{table-layout: fixed; margin: 0; padding: 0; border-spacing: 0;} table.message td{padding: 0;} div.contents{width: 100%; word-wrap: break-word;} span.protocol{color: gray;} a.user{color: yellow !important; text-decoration: none !important;} a.self{color: aqua !important; text-decoration: none !important;} a.friend{color: lime !important; text-decoration: none !important;} a.d2emote{color: gray !important; text-decoration: none !important;} span.text{color: white;} span.emote{color: yellow;} span.d2emote{color: gray;} span.info{color: yellow;} span.error{color: red;} span.success{color: lime;} span.whisper{color: gray;} span.broadcast{color: orange;} a{color: white; text-decoration: none;} a:hover{text-decoration: underline;} a:active{color: red; text-decoration: underline;}" & vbNewLine &
                                                   "  </style>" & vbNewLine &
                                                   " </head>" & vbNewLine &
                                                   " <body>" & vbNewLine &
                                                   "  <table class=""message"">" & vbNewLine &
                                                   "  </table>" & vbNewLine &
                                                   " </body>" & vbNewLine &
                                                   "</html>", False)
    End If
    If Not sLogFile.Contains(Now.ToString("yyyy'-'MM'-'dd")) Then
      LogFile = IO.Path.GetDirectoryName(sLogFile) & "\" & Now.ToString("yyyy'-'MM'-'dd") & ".html"
      SaveLog(Line)
      Exit Sub
    End If
    Dim sText As String = My.Computer.FileSystem.ReadAllText(sLogFile)
    If sText.Contains("  </table>") Then
      Dim sBegin As String = sText.Substring(0, sText.LastIndexOf("  </table>") - 1)
      Dim sEnd As String = sText.Substring(sText.LastIndexOf("  </table>"))
      If Line.Contains("style=""display: none;"" ") Then Line = Line.Replace("style=""display: none;"" ", String.Empty)
      If Line.Contains("href=""#") Then Line = Line.Replace("href=""#", "href=""")
      If Line.Contains("time=") And Line.Contains(" name=""timestamp""") Then Line = Line.Substring(0, Line.IndexOf("time=") - 1) & Line.Substring(Line.IndexOf("name=""timestamp""") + 16)
      sText = sBegin & vbNewLine & "   " & Line & vbNewLine & sEnd
      My.Computer.FileSystem.WriteAllText(sLogFile, sText, False)
    Else
      My.Computer.FileSystem.DeleteFile(sLogFile)
      SaveLog(Line)
    End If
  End Sub

  Public Sub SetCSS(StyleSheet As String)
    sCSS = Replace(StyleSheet, "\n", vbNewLine)
    If gwBrowse Is Nothing Then Exit Sub
    If gwBrowse.Document Is Nothing Then Exit Sub
    If gwBrowse.Document.StyleSheets.Count > 0 Then
      If String.IsNullOrEmpty(sCSS) Then
        If Not CType(gwBrowse.Document.DocumentElement.FirstChild, Skybound.Gecko.GeckoElement).InnerHtml = "   <title>Entelechy ChatBox</title>   <link rel=""stylesheet"" href=""chrome://entelechy/skin/box.css"" type=""text/css"">   <meta http-equiv=""Content-Type"" content=""text/html; charset=utf-8"">" Then CType(gwBrowse.Document.DocumentElement.FirstChild, Skybound.Gecko.GeckoElement).InnerHtml = "   <title>Entelechy ChatBox</title>   <link rel=""stylesheet"" href=""chrome://entelechy/skin/box.css"" type=""text/css"">   <meta http-equiv=""Content-Type"" content=""text/html; charset=utf-8"">"
      Else
        CType(gwBrowse.Document.DocumentElement.FirstChild, Skybound.Gecko.GeckoElement).InnerHtml = "   <title>Entelechy ChatBox</title>   <style type=""text/css"">" & sCSS & "</style>   <meta http-equiv=""Content-Type"" content=""text/html; charset=utf-8"">"
      End If
    Else
      If Not String.IsNullOrEmpty(sCSS) Then gwBrowse.Document.DocumentElement.Style.CssText = sCSS
    End If
  End Sub

  Private Sub gwBrowse_DocumentCompleted(sender As Object, e As System.EventArgs) Handles gwBrowse.DocumentCompleted
    SetCSS(sCSS)
  End Sub

  Private Sub gwBrowse_DomMouseDown(sender As Object, e As Skybound.Gecko.GeckoDomMouseEventArgs) Handles gwBrowse.DomMouseDown
    If gwBrowse Is Nothing Then Exit Sub
    RaiseEvent MouseDown(sender, New MouseEventArgs(e.Button, 1, e.ClientX, e.ClientY, 0))
  End Sub

  Private Sub gwBrowse_DomMouseMove(sender As Object, e As Skybound.Gecko.GeckoDomMouseEventArgs) Handles gwBrowse.DomMouseMove
    If e.Target IsNot Nothing AndAlso e.Target.TagName.ToLower = "a" Then
      e.Handled = True
      If Not String.IsNullOrEmpty(e.Target.GetAttribute("name")) Then
        If e.Target.GetAttribute("name") = "URL" Then
          If e.Target.GetAttribute("title") = e.Target.GetAttribute("href").Substring(1) Then
            e.Target.SetAttribute("title", titleGrabber.GetHTMLTitle(e.Target.GetAttribute("href").Substring(1)))
          End If
        Else
          RaiseEvent UserNameHover(sender, New NameClickEventArgs(e.Target.GetAttribute("name"), New MouseEventArgs(e.Button, 1, e.ClientX, e.ClientY, 0)))
        End If
      End If
    End If
  End Sub

  Private Sub gwBrowse_DomMouseUp(sender As Object, e As Skybound.Gecko.GeckoDomMouseEventArgs) Handles gwBrowse.DomMouseUp
    If gwBrowse Is Nothing Then Exit Sub
    If gwBrowse.CanCopySelection Then
      gwBrowse.CopySelection()
      Dim sTmp As String = Clipboard.GetText
      If sTmp IsNot String.Empty Then
        gwBrowse.SelectNone()
        Clipboard.SetText(Replace(sTmp, vbTab & vbNewLine, " "))
      End If
    End If
    If e.Target IsNot Nothing AndAlso e.Target.TagName.ToLower = "a" Then
      e.Handled = True
      If Not String.IsNullOrEmpty(e.Target.GetAttribute("name")) Then
        If e.Target.GetAttribute("name") = "URL" Then
          If e.Button = 0 Then
            If Not String.IsNullOrEmpty(e.Target.GetAttribute("href")) AndAlso Not e.Target.GetAttribute("href") = "#" AndAlso Not e.Target.GetAttribute("href").StartsWith("##") Then RaiseEvent HyperlinkClick(sender, New LinkClickEventArgs(e.Target.GetAttribute("href").Substring(1), New MouseEventArgs(e.Button, 1, e.ClientX, e.ClientY, 0)))
          Else
            If Not String.IsNullOrEmpty(e.Target.GetAttribute("href")) AndAlso Not e.Target.GetAttribute("href") = "#" Then
              If e.Target.GetAttribute("href").StartsWith("##") Then
                RaiseEvent HyperlinkClick(sender, New LinkClickEventArgs(e.Target.GetAttribute("href").Substring(2), New MouseEventArgs(e.Button, 1, e.ClientX, e.ClientY, 0)))
              Else
                RaiseEvent HyperlinkClick(sender, New LinkClickEventArgs(e.Target.GetAttribute("href").Substring(1), New MouseEventArgs(e.Button, 1, e.ClientX, e.ClientY, 0)))
              End If
            End If
          End If
          Exit Sub
        ElseIf e.Target.GetAttribute("name") = "CONRET" Then
          If e.Target.GetAttribute("href") = "#OK" Then
            EndReconnect(True)
          ElseIf e.Target.GetAttribute("href") = "#CANCEL" Then
            EndReconnect(False)
          End If
        Else
          RaiseEvent UserNameClick(sender, New NameClickEventArgs(e.Target.GetAttribute("name"), New MouseEventArgs(e.Button, 1, e.ClientX, e.ClientY, 0)))
          Exit Sub
        End If
      End If
    ElseIf e.Target IsNot Nothing AndAlso e.Target.Parent IsNot Nothing AndAlso e.Target.Parent.TagName.ToLower = "a" Then
      e.Handled = True
      If Not String.IsNullOrEmpty(e.Target.Parent.GetAttribute("name")) Then
        If e.Target.Parent.GetAttribute("name") = "THUMBURL" Then
          If Not String.IsNullOrEmpty(e.Target.Parent.GetAttribute("href")) AndAlso Not e.Target.Parent.GetAttribute("href") = "#" AndAlso Not e.Target.Parent.GetAttribute("href").StartsWith("##") Then RaiseEvent HyperlinkClick(sender, New LinkClickEventArgs(e.Target.Parent.GetAttribute("href").Substring(1), New MouseEventArgs(e.Button, 1, e.ClientX, e.ClientY, 0)))
        Else
          RaiseEvent UserNameClick(sender, New NameClickEventArgs(e.Target.Parent.GetAttribute("name"), New MouseEventArgs(e.Button, 1, e.ClientX, e.ClientY, 0)))
          Exit Sub
        End If
      End If
    End If
    RaiseEvent MouseUp(sender, New MouseEventArgs(e.Button, 1, e.ClientX, e.ClientY, 0))
  End Sub

  Private Sub RedoTimestamps()
    If gwBrowse Is Nothing Then Exit Sub
    If Not gwBrowse.Created Then Exit Sub
    Dim bScroll As Boolean = (gwBrowse.Document.DocumentElement.ScrollHeight - gwBrowse.Document.DocumentElement.ScrollTop < gwBrowse.Document.DocumentElement.OffsetHeight + ScrollGive)
    If sTimeStampFormat = String.Empty Then
      For Each el In gwBrowse.Document.GetElementsByName("timestamp")
        el.TextContent = String.Empty
      Next
    Else
      For Each el In gwBrowse.Document.GetElementsByName("timestamp")
        el.TextContent = TimeValue(el.GetAttribute("time")).ToString(sTimeStampFormat)
      Next
    End If
    If bScroll AndAlso gwBrowse.Document.GetElementsByTagName("tr").Count > 0 Then gwBrowse.Document.GetElementsByTagName("tr").Last.ScrollIntoView(False)
  End Sub

  Private Sub RedoEmoticons()
    If gwBrowse Is Nothing Then Exit Sub
    If Not gwBrowse.Created Then Exit Sub

    If gwBrowse.Document.Body.GetElementsByTagName("span").Count > 0 Then
      Dim bScroll As Boolean = (gwBrowse.Document.DocumentElement.ScrollHeight - gwBrowse.Document.DocumentElement.ScrollTop < gwBrowse.Document.DocumentElement.OffsetHeight + ScrollGive)
      Dim els = (From elItems In gwBrowse.Document.GetElementsByTagName("span") Where InStr(elItems.ClassName, "usertext") > 0)
      For Each el In els
        If bEmoticons Then
          el.InnerHtml = AddEmotes(el.InnerHtml)
        Else
          el.InnerHtml = RemoveEmotes(el.InnerHtml)
        End If
      Next
      If bScroll AndAlso gwBrowse.Document.GetElementsByTagName("tr").Count > 0 Then gwBrowse.Document.GetElementsByTagName("tr").Last.ScrollIntoView(False)
    End If
  End Sub

  Public Sub ToggleTimestamps()
    If gwBrowse Is Nothing Then Exit Sub
    If Not gwBrowse.Created Then Exit Sub
    bTimeStampEnabled = Not bTimeStampEnabled
    ToggleTimestamps(bTimeStampEnabled)
  End Sub

  Public Sub ToggleTimestamps(Enable As Boolean)
    If gwBrowse Is Nothing Then Exit Sub
    If Not gwBrowse.Created Then Exit Sub
    bTimeStampEnabled = Enable
    Dim bScroll As Boolean = (gwBrowse.Document.DocumentElement.ScrollHeight - gwBrowse.Document.DocumentElement.ScrollTop < gwBrowse.Document.DocumentElement.OffsetHeight + ScrollGive)
    For Each el In gwBrowse.Document.GetElementsByName("timestamp")
      el.SetAttribute("style", "display: " & IIf(Enable, "table-cell;", "none;"))
    Next
    If bScroll AndAlso gwBrowse.Document.GetElementsByTagName("tr").Count > 0 Then gwBrowse.Document.GetElementsByTagName("tr").Last.ScrollIntoView(False)
  End Sub

  Public Function GetBitmap() As Bitmap
    If gwBrowse IsNot Nothing AndAlso gwBrowse.Created Then
      Dim bTmp As New Bitmap(gwBrowse.DisplayRectangle.Width - 4, gwBrowse.DisplayRectangle.Height)
      gwBrowse.DrawToBitmap(bTmp, gwBrowse.DisplayRectangle)
      Return bTmp
    Else
      Return New Bitmap(1, 1)
    End If
  End Function

  Private Sub ctlGeckoChat_Load(sender As Object, e As System.EventArgs) Handles Me.Load
    If DesignMode Then
      Me.BackColor = Color.Black
    Else
      Me.BackColor = Color.Transparent
      gwBrowse = New GeckoBox
      gwBrowse.Dock = DockStyle.Fill
      gwBrowse.Margin = New Padding(0)
      gwBrowse.Padding = New Padding(0)
      gwBrowse.NoDefaultContextMenu = True
      Me.Controls.Add(gwBrowse)
      If gwBrowse.Created Then
        Control.CheckForIllegalCrossThreadCalls = True
        Clear()
      Else
        MsgBox("Unable to create Gecko Browser!", MsgBoxStyle.Critical)
      End If
    End If
  End Sub

  Public Sub ScrollTo(Delta As Integer)
    If gwBrowse Is Nothing Then Exit Sub
    Dim lY As Integer = gwBrowse.Document.DocumentElement.ScrollTop
    gwBrowse.Document.DocumentElement.ScrollTop = lY - (Delta / 5)
  End Sub

  Public Sub Clear()
    If gwBrowse Is Nothing Then Exit Sub
    gwBrowse.Navigate("chrome://entelechy/content/box.html")
  End Sub

  Public Sub AddChat(ctType As ChatType, sName As String, sMessage As String, Optional sMsgID As String = Nothing)
    If gwBrowse Is Nothing Then Exit Sub
    If Me.InvokeRequired Then
      Dim d As New AddChatCallBack(AddressOf AddChat)
      Me.BeginInvoke(d, New Object() {ctType, sName, sMessage, sMsgID})
    Else
      If Not gwBrowse.Created Then Exit Sub
      If gwBrowse.Url.AbsoluteUri = "about:blank" Then Clear()
      Do While gwBrowse.IsBusy
        Application.DoEvents()
      Loop
      Dim bScroll As Boolean = AtBottom
      Dim nTmp As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("tr")
      Dim nTimeStamp As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("td")
      nTimeStamp.ClassName = "timestamp"
      nTimeStamp.TextContent = Now.ToString(sTimeStampFormat)
      nTimeStamp.InnerHtml &= "&nbsp;"
      nTimeStamp.SetAttribute("name", "timestamp")
      nTimeStamp.SetAttribute("time", Now)
      Dim sDispStyle As String = IIf(bTimeStampEnabled, "display: table-cell;", "display: none;")
      nTimeStamp.SetAttribute("style", sDispStyle)
      nTmp.AppendChild(nTimeStamp)
      Dim nCtd As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("td")
      nCtd.ClassName = "chat"
      Dim nMessageTable As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("table")
      nMessageTable.ClassName = "message"
      Dim nMessageTR As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("tr")
      Dim nMessageTD As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("td")
      Dim nChat As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("div")
      nChat.ClassName = "contents"
      Select Case ctType
        Case ChatType.None
          HTMLizeMessage(sMessage)
          nChat.InnerHtml = sMessage
        Case ChatType.UserChat
          Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("a")
          nUser.ClassName = "user"
          If InStr(sName, ": ") > 0 Then
            nUser.SetAttribute("name", sName.Substring(sName.IndexOf(": ") + 2))
          Else
            nUser.SetAttribute("name", sName)
          End If
          nUser.TextContent = "<" & sName & "> "
          nChat.AppendChild(nUser)
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "text usertext"
          HTMLizeMessage(sMessage)
          nText.InnerHtml = sMessage
          nChat.AppendChild(nText)
        Case ChatType.UserWhisper
          Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("a")
          nUser.ClassName = "user"
          If InStr(sName, ": ") > 0 Then
            nUser.SetAttribute("name", sName.Substring(sName.IndexOf(": ") + 2))
          Else
            nUser.SetAttribute("name", sName)
          End If
          nUser.TextContent = "<" & sName & "> "
          nChat.AppendChild(nUser)
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "whisper usertext"
          HTMLizeMessage(sMessage)
          nText.InnerHtml = sMessage
          nChat.AppendChild(nText)
        Case ChatType.SelfChat
          Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("a")
          nUser.ClassName = "self"
          If InStr(sName, ": ") > 0 Then
            nUser.SetAttribute("name", sName.Substring(sName.IndexOf(": ") + 2))
          Else
            nUser.SetAttribute("name", sName)
          End If
          nUser.TextContent = "<" & sName & "> "
          nChat.AppendChild(nUser)
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "text usertext"
          HTMLizeMessage(sMessage)
          nText.InnerHtml = sMessage
          nChat.AppendChild(nText)
        Case ChatType.FriendChat
          Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("a")
          nUser.ClassName = "friend"
          If InStr(sName, ": ") > 0 Then
            nUser.SetAttribute("name", sName.Substring(sName.IndexOf(": ") + 2))
          Else
            nUser.SetAttribute("name", sName)
          End If
          nUser.TextContent = "<" & sName & "> "
          nChat.AppendChild(nUser)
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "text usertext"
          HTMLizeMessage(sMessage)
          nText.InnerHtml = sMessage
          nChat.AppendChild(nText)
        Case ChatType.StatChat
          Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("a")
          nUser.ClassName = "user"
          If InStr(sName, ": ") > 0 Then
            nUser.SetAttribute("name", sName.Substring(sName.IndexOf(": ") + 2))
          Else
            nUser.SetAttribute("name", sName)
          End If
          nUser.TextContent = "<" & sName & " (StatChat)> "
          nChat.AppendChild(nUser)
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "whisper usertext"
          HTMLizeMessage(sMessage)
          nText.InnerHtml = sMessage
          nChat.AppendChild(nText)
        Case ChatType.Emote
          Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("a")
          nUser.ClassName = "user"
          nUser.SetAttribute("name", sName)
          nUser.TextContent = "<" & sName & " "
          nChat.AppendChild(nUser)
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "emote usertext"
          HTMLizeMessage(sMessage)
          nText.InnerHtml = sMessage & "&gt;"
          nChat.AppendChild(nText)
        Case ChatType.D2Emote
          Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("a")
          nUser.ClassName = "d2emote"
          nUser.SetAttribute("name", sName)
          nUser.TextContent = "*" & sName & " "
          nChat.AppendChild(nUser)
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "d2emote usertext"
          HTMLizeMessage(sMessage)
          nText.InnerHtml = sMessage & "*"
          nChat.AppendChild(nText)
        Case ChatType.ServiceInfo
          If sName <> String.Empty Then
            Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
            nUser.ClassName = "protocol"
            nUser.TextContent = "[" & sName & "] "
            nChat.AppendChild(nUser)
          End If
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "info"
          HTMLizeMessage(sMessage)
          nText.InnerHtml = sMessage
          nChat.AppendChild(nText)
        Case ChatType.ServiceError
          If sName <> String.Empty Then
            Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
            nUser.ClassName = "protocol"
            nUser.TextContent = "[" & sName & "] "
            nChat.AppendChild(nUser)
          End If
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "error"
          HTMLizeMessage(sMessage)
          nText.InnerHtml = sMessage
          nChat.AppendChild(nText)
        Case ChatType.ServiceSuccess
          If sName <> String.Empty Then
            Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
            nUser.ClassName = "protocol"
            nUser.TextContent = "[" & sName & "] "
            nChat.AppendChild(nUser)
          End If
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "success"
          HTMLizeMessage(sMessage)
          nText.InnerHtml = sMessage
          nChat.AppendChild(nText)
        Case ChatType.ServiceBroadcast
          If sName <> String.Empty Then
            Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
            nUser.ClassName = "protocol"
            nUser.TextContent = "[" & sName & "] "
            nChat.AppendChild(nUser)
          End If
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "broadcast"
          HTMLizeMessage(sMessage)
          nText.InnerHtml = sMessage
          nChat.AppendChild(nText)
        Case ChatType.VerboseInfo
          If sName <> String.Empty Then
            Dim nUser As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
            nUser.ClassName = "protocol"
            nUser.TextContent = "{" & sName & "} "
            nChat.AppendChild(nUser)
          End If
          Dim nText As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nText.ClassName = "whisper"
          nText.InnerHtml = sMessage
          nChat.AppendChild(nText)
        Case ChatType.HelpInfo
          Dim nCommand As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
          nCommand.ClassName = "info"
          nCommand.TextContent = sName & " - "
          nChat.AppendChild(nCommand)
          If InStr(sMessage, "|") > 0 Then
            Dim sParts() As String = sMessage.Split("|")
            Dim nDescription As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
            nDescription.ClassName = "text"
            nDescription.InnerHtml = sParts(0)
            nChat.AppendChild(nDescription)
            Dim nExtra As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
            nExtra.ClassName = "whisper"
            nExtra.InnerHtml = sParts(1)
            nChat.AppendChild(nExtra)
          Else
            Dim nDescription As Skybound.Gecko.GeckoElement = gwBrowse.Document.CreateElement("span")
            nDescription.ClassName = "text"
            nDescription.InnerHtml = sMessage
            nChat.AppendChild(nDescription)
          End If
      End Select
      nMessageTD.AppendChild(nChat)
      nMessageTR.AppendChild(nMessageTD)
      nMessageTable.AppendChild(nMessageTR)
      nCtd.AppendChild(nMessageTable)
      nTmp.AppendChild(nCtd)
      If Not String.IsNullOrEmpty(LogFile) Then SaveLog("<tr>" & nTmp.InnerHtml & "</tr>")
      If sMsgID <> String.Empty Then nTmp.SetAttribute("id", sMsgID)
      gwBrowse.Document.Body.GetElementsByTagName("table")(0).AppendChild(nTmp)
      TrimLines()
      If bScroll Then ToBottom()
      If Me.Parent IsNot Nothing AndAlso
         Me.Parent.Parent IsNot Nothing AndAlso
         Me.Parent.Parent.Parent IsNot Nothing AndAlso
         Me.Parent.Parent.Parent.Parent IsNot Nothing Then If Me.Parent.Parent.Parent.Parent.Name = "BNUI" Then frmMain.UpdatePreviewBitmap(Me.Parent.Parent.Parent.Parent.Tag)
    End If
  End Sub

  Public Sub UpdateProgress(sID As String, sMessage As String)
    If gwBrowse Is Nothing Then Exit Sub
    If Me.InvokeRequired Then
      Dim d As New UpdateProgressCallBack(AddressOf UpdateProgress)
      Me.BeginInvoke(d, New Object() {sID, sMessage})
    Else
      Dim nTmp As Skybound.Gecko.GeckoElement = gwBrowse.Document.GetElementById(sID)
      If nTmp IsNot Nothing Then
        HTMLizeMessage(sMessage)
        nTmp.GetElementsByTagName("div").Last.GetElementsByTagName("span").Last.InnerHtml = sMessage
      End If
    End If
  End Sub

  Public Sub TerminateProgress(sID As String, Optional sFinalMessage As String = Nothing)
    If gwBrowse Is Nothing Then Exit Sub
    If Me.InvokeRequired Then
      Dim d As New UpdateProgressCallBack(AddressOf TerminateProgress)
      Me.BeginInvoke(d, New Object() {sID, sFinalMessage})
    Else
      Do
        If gwBrowse.Document Is Nothing Then Exit Do
        Dim nTmp As Skybound.Gecko.GeckoElement = gwBrowse.Document.GetElementById(sID)
        If nTmp IsNot Nothing Then
          If sFinalMessage IsNot Nothing Then
            HTMLizeMessage(sFinalMessage)
            nTmp.GetElementsByTagName("div").Last.GetElementsByTagName("span").Last.InnerHtml = sFinalMessage
          End If
          nTmp.Id = Nothing
        Else
          Exit Do
        End If
      Loop
    End If
  End Sub

  Public Sub ReconnectAlert(Obj As Object)
    If gwBrowse Is Nothing Then Exit Sub
    If Me.InvokeRequired Then
      Me.Invoke(New CallBack(AddressOf ReconnectAlert), Obj)
    Else
      Dim nTmp As Skybound.Gecko.GeckoElement = gwBrowse.Document.GetElementById("CONRET")
      If nTmp IsNot Nothing Then
        tmrReconnect.Stop()
        EndReconnect(False)
      End If
      ReconnectMessage = Obj(0)
      ReconnectLeft = Obj(1)
      AddChat(ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ReconnectMessage, "CONRET")
      tmrReconnect.Start()
    End If
  End Sub

  Public Sub EndReconnect(Ret As Boolean)
    If Me.InvokeRequired Then
      Me.Invoke(New CallBack(AddressOf EndReconnect), Ret)
    Else
      tmrReconnect.Stop()
      Dim nTmp As Skybound.Gecko.GeckoElement = gwBrowse.Document.GetElementById("CONRET")
      If nTmp IsNot Nothing Then
        If Not String.IsNullOrEmpty(ReconnectMessage) Then nTmp.GetElementsByTagName("div").Last.GetElementsByTagName("span").Last.InnerHtml = ReconnectMessage
        nTmp.Id = Nothing
      End If
      ReconnectMessage = Nothing
      ReconnectLeft = Nothing
      'If nTmp IsNot Nothing Then
      'gwBrowse.Document.Body.GetElementsByTagName("table")(0).RemoveChild(nTmp)
      'End If
      RaiseEvent ReconnectResult(New Object, Ret)
    End If
  End Sub

  Private Sub tmrReconnect_Elapsed(sender As Object, e As System.Timers.ElapsedEventArgs) Handles tmrReconnect.Elapsed
    UpdateReconnect()
  End Sub

  Private Sub UpdateReconnect()
    If Me.InvokeRequired Then
      Me.Invoke(New MethodInvoker(AddressOf UpdateReconnect))
    Else
      If gwBrowse.Document Is Nothing Then Exit Sub
      Dim nTmp As Skybound.Gecko.GeckoElement = gwBrowse.Document.GetElementById("CONRET")
      If nTmp IsNot Nothing Then
        HTMLizeMessage(ReconnectMessage)
        nTmp.GetElementsByTagName("div").Last.GetElementsByTagName("span").Last.InnerHtml = ReconnectMessage & " [<a name=""CONRET"" href=""#OK"">Reconnect</a> (" & ConvertTime(ReconnectLeft * 1000, True) & ")] [<a name=""CONRET"" href=""#CANCEL"">Cancel</a>]"
        If ReconnectLeft = 0 Then
          EndReconnect(True)
        Else
          ReconnectLeft -= 1
        End If
      End If
    End If
  End Sub

  Private Sub HTMLizeMessage(ByRef sMessage As String)
    If sMessage Is Nothing Then Exit Sub
    Dim regx As New Regex("(aaa://|aaas://|acap://|cap://|cid:|crid://|data:|dav:|dict://|dns:|dns://|fax:|file://|ftp://|geo:|go:|go://|gopher://|h323:|http://|https://|iax:|icap://|im:|imap://|info://|ipp://|iris\.|ldap://|urn:lsid:|mailto:|mid:|modem:|msrp://|msrps://|mtqp://|mupdate://|news:|nfs://|nntp://|opaquelocktoken:|pop://|pres:|prospero://|rstp://|service:|shttp://|sieve://|sip:|sips:|sms:|snmp://|soap\.|tag:|tel:|telnet://|tftp://|thismessage:/|tip://|tv:|urn:|vemmi://|wais://|xmlrpc\.|xmpp:|z39.50r://|z39.50s://|about:|adiumxtra://|aim:|apt:|apf://|aw://|bolo://|callto:|chrome:|content://|cvs://|doi:10\.|ed2k://|facetime://|feed:|finger://|fish://|gg:|gizmoproject://call\?id=|gtalk:chat\?jid=|irc://|ircs://|irc6://|itms:|jar:|javascript:|keyparc://|lastfm://|ldaps://|magnet:|maps:q=|mms://|msnim:|mumble://|mvn:|notes://|palm:|paparazzi:|psyc:|psyc://|rmi://|rsync://|rmtp://|secondlife://|sgn://|skype:|spotify:|ssh://|sftp://|smb://|soldat://|steam:|steam://|svn://|svn\+ssh://|teamspeak://|unreal://|ut2004://|ventrilo://|view-source:|webcal://|ws:|wtai://|wyciwyg://|xfire:|xri://|ymsgr:sendIM\?|bnftp://|www\.)([\w+?\.\w+])+([a-zA-Z0-9\~\!\@\#\$\%\^\&amp;\*\(\)_\-\=\+\\\/\?\.\:\;\'\,]*)?([a-zA-Z0-9/\?])", RegexOptions.IgnoreCase)
    Dim matches As MatchCollection = regx.Matches(sMessage)
    sMessage = sMessage.Replace("<", "&lt;")
    sMessage = sMessage.Replace(">", "&gt;")
    Dim matchItems = (From mItem As Match In matches Select mItem.Value).Distinct
    For Each match As String In matchItems
      sMessage = sMessage.Replace(match, "<a href=""#" & match & """ name=""URL"" title=""" & titleGrabber.GetHTMLTitle(match) & """>" & match & "</a>")
    Next
    If bEmoticons Then sMessage = AddEmotes(sMessage)
    Do While InStr(sMessage, "  ") > 0
      sMessage = sMessage.Replace("  ", "&nbsp;&nbsp;")
    Loop
    If bRichText Then
      If sMessage.Contains("Á") Then
        sMessage = sMessage.Replace("ÁQ", "ÿc5")
        sMessage = sMessage.Replace("ÁR", "ÿc:")

        sMessage = sMessage.Replace("ÁS", "ÿc9")
        sMessage = sMessage.Replace("ÁX", "ÿc9")
        sMessage = sMessage.Replace("ÁZ", "ÿc9")

        sMessage = sMessage.Replace("ÁT", "ÿc.")
        sMessage = sMessage.Replace("ÁU", "ÿc.")
        sMessage = sMessage.Replace("ÁV", "ÿc.")

        sMessage = sMessage.Replace("ÁW", "ÿc/")
        sMessage = sMessage.Replace("ÁP", "ÿc/")

        sMessage = sMessage.Replace("ÁY", "ÿc1")
      End If
      If sMessage.Contains("ÿc") Then
        Dim sHTML As String = String.Empty
        Dim bC, bB, bI, bS, bU As Boolean
        For I As Integer = 0 To sMessage.Length - 1
          If sMessage(I) = "ÿ"c Then
            If I < sMessage.Length - 1 AndAlso sMessage(I + 1) = "c"c Then
              I += 1
              If I < sMessage.Length - 1 Then
                Dim colorVal As Color = Color.Transparent
                Select Case sMessage(I + 1)
                  Case "0"c, "/"c : colorVal = Color.White
                  Case "1"c : colorVal = Color.Red
                  Case "2"c, "<"c : colorVal = Color.Lime
                  Case "3"c : colorVal = Color.FromArgb(&HFFAC00FF)
                  Case "4"c, "7"c : colorVal = Color.FromArgb(&HFFD5AC00)
                  Case "5"c, "&"c : colorVal = Color.Gray
                  Case "6"c : colorVal = Color.Black
                  Case "8"c : colorVal = Color.FromArgb(&HFFFF7F00)
                  Case "9"c, "%"c : colorVal = Color.Yellow
                  Case "*"c, """"c : colorVal = Color.Blue
                  Case "("c : colorVal = Color.Silver
                  Case ")"c, "."c : colorVal = Color.Aqua
                  Case "+"c : colorVal = Color.FromArgb(&HFFB2FFFF)
                  Case ":" : colorVal = Color.FromArgb(&HFF00C000)
                  Case ";" : colorVal = Color.Fuchsia
                  Case "b"
                    bB = Not bB
                    If bB Then
                      sHTML &= "<span style=""font-weight: bold;"">"
                    Else
                      sHTML &= "</span>"
                    End If
                    I += 1
                  Case "i"
                    bI = Not bI
                    If bI Then
                      sHTML &= "<span style=""font-style: italic;"">"
                    Else
                      sHTML &= "</span>"
                    End If
                    I += 1
                  Case "u"
                    bU = Not bU
                    If bU Then
                      sHTML &= "<span style=""text-decoration: underline;"">"
                    Else
                      sHTML &= "</span>"
                    End If
                    I += 1
                  Case "s"
                    bS = Not bS
                    If bS Then
                      sHTML &= "<span style=""text-decoration: line-through;"">"
                    Else
                      sHTML &= "</span>"
                    End If
                    I += 1
                  Case Else
                    sHTML &= "ÿc"
                End Select
                If colorVal <> Color.Transparent Then
                  If bB Then sHTML &= "</span>"
                  If bI Then sHTML &= "</span>"
                  If bS Then sHTML &= "</span>"
                  If bU Then sHTML &= "</span>"
                  If bC Then sHTML &= "</span>"
                  sHTML &= "<span style=""color: #" & PadHex(colorVal.ToArgb And Not &HFF000000, 6) & ";"">"
                  If bB Then sHTML &= "<span style=""font-weight: bold;"">"
                  If bI Then sHTML &= "<span style=""font-style: italic;"">"
                  If bS Then sHTML &= "<span style=""text-decoration: line-through;"">"
                  If bU Then sHTML &= "<span style=""text-decoration: underline;"">"
                  bC = True
                  I += 1
                End If
              Else
                sHTML &= "ÿc"
              End If
            Else
              sHTML &= sMessage(I)
            End If
          Else
            sHTML &= sMessage(I)
          End If
        Next
        If bB Then sHTML &= "</span>"
        If bI Then sHTML &= "</span>"
        If bS Then sHTML &= "</span>"
        If bU Then sHTML &= "</span>"
        If bC Then sHTML &= "</span>"
        sMessage = sHTML
      End If
    End If
  End Sub

  Private Function AddEmotes(sMessage As String) As String
    Dim sEmotes() As String = Split(My.Resources.EMOTICONS, vbNewLine)
    For Each sEmote In sEmotes
      Dim sEmoticon As String = sEmote.Split(vbTab)(0)
      Dim sFile As String = sEmote.Split(vbTab)(1)
      sEmoticon = sEmoticon.Replace("<", "&lt;")
      sEmoticon = sEmoticon.Replace(">", "&gt;")
      EmoteCheck(sMessage, sEmoticon, sFile)
    Next
    Return sMessage
  End Function

  Private Sub EmoteCheck(ByRef Message As String, sEmote As String, sFile As String)
    If Message = sEmote Then
      Message = "<img src=""chrome://entelechy/skin/emote/" & sFile & ".png"" class=""emoticon"" title=""" & sEmote & """ alt=""" & sEmote & """>"
    ElseIf Message.Length > sEmote.Length Then
      If Message.Substring(0, sEmote.Length + 1) = sEmote & " " Then
        Message = "<img src=""chrome://entelechy/skin/emote/" & sFile & ".png"" class=""emoticon"" title=""" & sEmote & """ alt=""" & sEmote & """>" & Message.Substring(sEmote.Length)
      End If
      While Message.Contains(" " & sEmote & " ")
        Message = Message.Replace(" " & sEmote & " ", " <img src=""chrome://entelechy/skin/emote/" & sFile & ".png"" class=""emoticon"" title=""" & sEmote & """ alt=""" & sEmote & """> ")
      End While
      If Message.Substring(Message.Length - sEmote.Length - 1) = " " & sEmote Then
        Message = Message.Substring(0, Message.Length - sEmote.Length - 1) & " <img src=""chrome://entelechy/skin/emote/" & sFile & ".png"" class=""emoticon"" title=""" & sEmote & """ alt=""" & sEmote & """>"
      End If
    End If
  End Sub

  Private Function RemoveEmotes(sMessage As String) As String
    If InStr(sMessage, "img") > 0 Then
      Dim regx As New Regex("<img src=""chrome://entelechy/skin/emote/\S+\.png"" class=""emoticon"" title=""[^"" <>]+"" alt=""[^"" <>]+"">", RegexOptions.IgnoreCase)
      Dim mactches As MatchCollection = regx.Matches(sMessage)
      For Each match As Match In mactches
        sMessage = sMessage.Replace(match.Value, match.Value.Substring(match.Value.LastIndexOf("alt=""") + 5, match.Value.LastIndexOf(""">") - (match.Value.LastIndexOf("alt=""") + 5)))
      Next
    End If
    Return sMessage
  End Function

  Private Sub GeckoChat_Resize(sender As Object, e As System.EventArgs) Handles Me.Resize
    If gwBrowse Is Nothing Then Exit Sub
    If Not gwBrowse.Created Then Exit Sub
    Dim bScroll As Boolean = (gwBrowse.Document.DocumentElement.ScrollHeight - gwBrowse.Document.DocumentElement.ScrollTop < gwBrowse.Document.DocumentElement.OffsetHeight + ScrollGive)
    If bScroll Then gwBrowse.Document.DocumentElement.ScrollTop = (gwBrowse.Document.DocumentElement.ScrollHeight - gwBrowse.Document.DocumentElement.OffsetHeight)
  End Sub

  Private Sub TrimLines()
    If gwBrowse Is Nothing Then Exit Sub
    If Not gwBrowse.Created Then Exit Sub
    Dim tTable = gwBrowse.Document.Body.GetElementsByTagName("table").FirstOrDefault
    If tTable IsNot Nothing And lMaxLines > 0 Then
      If tTable.GetElementsByTagName("tr").Count > lMaxLines Then
        Do While tTable.GetElementsByTagName("tr").Count > lMaxLines - (lMaxLines / 10)
          Dim fItem = tTable.GetElementsByTagName("tr").FirstOrDefault
          If fItem IsNot Nothing Then tTable.RemoveChild(fItem)
        Loop
      End If
    End If
  End Sub

  Private Sub titleGrabber_UpdateHTMLObject(URL As String, ContentType As String, ContentLength As UInt32) Handles titleGrabber.UpdateHTMLObject
    For Each el In gwBrowse.Document.GetElementsByName("URL")
      If Not String.IsNullOrEmpty(el.GetAttribute("href")) AndAlso StrComp(el.GetAttribute("href").Substring(1), URL, CompareMethod.Text) = 0 Then
        Dim rndID As String
        Do
          rndID = String.Empty
          For I As Integer = 0 To (Int(Rnd() * 4) + 8)
            rndID &= Chr(Int(Rnd() * 26) + 65)
          Next
        Loop While gwBrowse.Document.GetElementById(rndID) IsNot Nothing
        el.SetAttribute("href", "##" & URL)
        el.SetAttribute("name", "URL")
        el.SetAttribute("title", ContentType & " (" & ByteSize(ContentLength) & ")")
        el.SetAttribute("onclick", "toggleObject('" & rndID & "');")
        Select Case ContentType
          Case "image/gif", "image/jpeg", "image/png", "image/svg+xml", "image/tiff", "image/vnd.microsoft.icon"
            el.Parent.InnerHtml &= "<div id=""" & rndID & """ style=""display: none; width: 100%; text-align: center;""><br><a href=""#" & URL & """ name=""THUMBURL""><img src=""http://rcb.realityripple.com/thumbs/upload.php?url=" & URL & """ title=""" & ContentType & " (" & ByteSize(ContentLength) & ")"" alt=""" & URL & """ style=""border: 0px;""></a></div>"
          Case "audio/wave", "audio/wav", "audio/x-wav", "audio/x-pn-wav", "audio/webm", "audio/ogg"
            el.Parent.InnerHtml &= "<div id=""" & rndID & """ style=""display: none; width: 100%; text-align: center;""><br><audio src=""" & URL & """ controls=""controls"" preload=""metadata"">Unable to load!</audio></div>"
          Case "video/webm", "video/ogg", "application/ogg"
            el.Parent.InnerHtml &= "<div id=""" & rndID & """ style=""display: none; width: 100%; text-align: center;""><br><video src=""" & URL & """ controls=""controls"" preload=""metadata"">Unable to load!</video></div>"
        End Select
      End If
    Next
  End Sub

  Private Sub titleGrabber_UpdateHTMLTitle(URL As String, Title As String) Handles titleGrabber.UpdateHTMLTitle
    For Each el In gwBrowse.Document.GetElementsByName("URL")
      If Not String.IsNullOrEmpty(el.GetAttribute("href")) AndAlso StrComp(el.GetAttribute("href").Substring(1), URL, CompareMethod.Text) = 0 Then el.SetAttribute("title", Title)
    Next
  End Sub
End Class
