﻿Imports System.Net
Imports System.Net.Sockets
Imports Ionic.Zip
Imports System.Threading
Imports System.Timers
Imports System.Text
Imports Entelechy.NativeMethods
Public Class BNUI
#Region "Enums"
  Public Enum GameType
    DRTL = &H4452544C
    DSHR = &H44534852
    D2DV = &H44324456
    D2XP = &H44325850
    DIII = &H4433
    STAR = &H53544152
    SSHR = &H53534852
    JSTR = &H4A535452
    SEXP = &H53455850
    SCII = &H5332
    W2BN = &H5732424E
    WAR3 = &H57415233
    W3XP = &H57335850
    WOW = &H574F57
    CHAT = &H54484143
  End Enum
  Public Enum GameArch
    IX86 = &H49583836
    PMAC = &H504D4143
    XMAC = &H584D4143
  End Enum
  Public Enum JoinFlags
    NoCreate = &H0
    First = &H1
    Forced = &H2
    D2First = &H5
  End Enum
  Public Enum ProxyType
    SOCKS4 = 4
    SOCKS5 = 5
    HTTP = 1
  End Enum
  Private Enum SOCKS4Status
    Granted = &H5A
    Failed = &H5B
    NoIdent = &H5C
    IdentFail = &H5D
  End Enum
  Private Enum SOCKS5AuthMethods
    None = &H0
    GSSAPI = &H1
    UserPass = &H2
    ChallengeHandshake = &H3
    ChallengeResponse = &H5
    SSL = &H6
    NDS = &H7
    MultiAuthFramework = &H8
  End Enum
  Private Enum SOCKS5Status
    Granted = &H0
    Failure = &H1
    NotAllowedByRuleset = &H2
    NetworkUnreachable = &H3
    HostUnreachable = &H4
    RefusedByDestination = &H5
    TTLExpired = &H6
    CommandNotSupported = &H7
    AddressNotSupported = &H8
  End Enum
  Private Enum SOCKS5AddressType
    IPv4 = &H1
    Domain = &H3
    IPv6 = &H4
  End Enum
  Private Enum SOCKS5ConnectState
    Handshake
    Authentication
    Authentication2
    Authentication3
    Authentication4
    Authentication5
    Authentication6
    Request
    Complete
  End Enum
  Private Enum CHAPATAs
    Status = 0
    TextMessage = 1
    UserIdentity = 2
    Challenge = 3
    Response = 4
    Charset = 5
    Identifier = 10
    Algorithms = 11
  End Enum
#End Region

#Region "Structs"
  Public Structure ProductKey
    Public ProductVal As UInt32
    Public PublicVal As UInt32
    Public PrivateVal As UInt32
    Public PrivateVal26() As Byte
  End Structure
  Public Structure BNCSVariables
    Public ServerIP As IPAddress
    Public ClientToken As UInt32
    Public ServerToken As UInt32
    Public UDPToken As UInt32
    Public UDPCode As UInt32
    Public UniqueName As String
    Public UseNLS As Boolean
    Public LastAd As UInt32
    Public LastPing As Integer
    Public EnterVoid As Boolean
  End Structure
  Public Structure W3IconList
    Public Icon As String
    Public Name As String
    Public Race As Byte
    Public Wins As UInt16
    Public Enabled As Byte
    Public Sub New(nIcon As String, nName As String, nRace As Byte, nWins As UInt16, nEnabled As Byte)
      Icon = nIcon
      Name = nName
      Race = nRace
      Wins = nWins
      Enabled = nEnabled
    End Sub
  End Structure
  Private Structure SOCKS5Variables
    Public AuthMethod As SOCKS5AuthMethods
    Public ConnectionState As SOCKS5ConnectState
  End Structure
  Private Structure MCPData
    Public Status As UInt32
    Public MCPIP As IPAddress
    Public MCPPort As UInt32
    Public BNCSIP As UInt32
    Public UDPToken As UInt32
    Public NullVal As UInt16
    Public KeyProd As UInt16
    Public KeyPub As UInt32
    Public GatewayID As UInt32
    Public ProductID As UInt32
    Public PlatformID As UInt32
    Public BNCSIP2 As UInt32
    Public Locale As UInt32
    Public MCPHash1 As UInt32
    Public MCPHash2 As UInt32
    Public MCPHash3 As UInt32
    Public MCPHash4 As UInt32
    Public MCPHash5 As UInt32
  End Structure
  Private Structure CRevData
    Public MPQName As String
    Public MPQTime As UInt64
    Public Request() As Byte
  End Structure
  Private Structure ChatVariables
    Public LastWhisper As String
    Public IsAway As String
    Public IsDnD As String
    Public AccountCreatead As String
    Public LastLogon As String
    Public LastLogoff As String
    Public TimeLogged As UInt32
    Public LoginTime As UInt32
    Public ClanTag As String
    Public ClanRank As Byte
    Public PingSpoofing As UInt32
    Public PingFirst As Boolean
    Public MimicUser As String
    Public PubGameList As Boolean
    Public RetryChannel As String
    Public RetryCount As UInt32
  End Structure
#End Region

#Region "Classes"
  Public Class cConfig
    Private c_VerByte As UInt32
    Private c_HashPath As String
    Private c_Server As String
    Private c_UTF8 As Boolean
    Private c_AutoAway As Byte
    Private c_WhisFwd As String
    Private c_LogChat As Boolean
    Private c_AutoConnect As Boolean
    Private c_AutoReconnect As UInt16
    Private c_PingSpoof As UInt32
    Private c_SquelchList As ArrayList
    Private c_TagSquelchList As ArrayList
    Private c_Parent As BNUI
    Public Class cAccount
      Private c_ProfileName As String
      Private c_Username As String
      Private c_Password As String
      Private c_EMail As String
      Private c_HomeChannel As String
      Private c_StatString As String
      Public Class cClient
        Private c_Product As GameType
        Private c_Spawn As Boolean
        Private c_D2Realm As Boolean
        Private c_UDPPlug As Boolean
        Public CDKey As ProductKey
        Public EXPKey As ProductKey
        Public Property Product As GameType
          Get
            Return c_Product
          End Get
          Set(value As GameType)
            c_Product = value
          End Set
        End Property
        Public Property Spawn As Boolean
          Get
            Return c_Spawn
          End Get
          Set(value As Boolean)
            c_Spawn = value
          End Set
        End Property
        Public Property D2Realm As Boolean
          Get
            Return c_D2Realm
          End Get
          Set(value As Boolean)
            c_D2Realm = value
          End Set
        End Property
        Public Property UDPPlug As Boolean
          Get
            Return c_UDPPlug
          End Get
          Set(value As Boolean)
            c_UDPPlug = value
          End Set
        End Property
      End Class
      Public Class cChange
        Private c_EMail As String
        Private c_Password As String
        Private c_PassReset As Boolean
        Public Property EMail As String
          Get
            Return c_EMail
          End Get
          Set(value As String)
            c_EMail = value
          End Set
        End Property
        Public Property Password As String
          Get
            Return c_Password
          End Get
          Set(value As String)
            c_Password = value
          End Set
        End Property
        Public Property PassReset As Boolean
          Get
            Return c_PassReset
          End Get
          Set(value As Boolean)
            c_PassReset = value
          End Set
        End Property
      End Class
      Public Client As cClient
      Public Change As cChange
      Public Property ProfileName As String
        Get
          Return c_ProfileName
        End Get
        Set(value As String)
          c_ProfileName = value
        End Set
      End Property
      Public Property Username As String
        Get
          Return c_Username
        End Get
        Set(value As String)
          c_Username = value
        End Set
      End Property
      Public Property Password As String
        Get
          Return c_Password
        End Get
        Set(value As String)
          c_Password = value
        End Set
      End Property
      Public Property EMail As String
        Get
          Return c_EMail
        End Get
        Set(value As String)
          c_EMail = value
        End Set
      End Property
      Public Property HomeChannel As String
        Get
          Return c_HomeChannel
        End Get
        Set(value As String)
          c_HomeChannel = value
        End Set
      End Property
      Public Property StatString As String
        Get
          Return c_StatString
        End Get
        Set(value As String)
          c_StatString = value
        End Set
      End Property
      Public Sub New()
        Client = New cClient
        Change = New cChange
      End Sub
    End Class
    Public Class cIdle
      Private c_IdleOn As Boolean
      Private c_IdleTime As UInt16
      Private c_IdleOnSong As Boolean
      Private c_IdleText As String
      Public Property IdleOn As Boolean
        Get
          Return c_IdleOn
        End Get
        Set(value As Boolean)
          c_IdleOn = value
        End Set
      End Property
      Public Property IdleTime As UInt16
        Get
          Return c_IdleTime
        End Get
        Set(value As UInt16)
          c_IdleTime = value
        End Set
      End Property
      Public Property IdleOnSong As Boolean
        Get
          Return c_IdleOnSong
        End Get
        Set(value As Boolean)
          c_IdleOnSong = value
        End Set
      End Property
      Public Property IdleText As String
        Get
          Return c_IdleText
        End Get
        Set(value As String)
          c_IdleText = value
        End Set
      End Property
    End Class
    Public Class cDisplay
      Public Class cInterface
        Private c_CSS As String
        Private c_ListWidth As UInt32
        Private c_PreWidth As UInt32
        Private c_SendWidth As UInt32
        Private c_WhisperWidth As UInt32
        Private c_Parent As BNUI = Nothing
        Public Property CustomCSS As String
          Get
            Return c_CSS
          End Get
          Set(value As String)
            c_CSS = value
            If c_Parent IsNot Nothing Then c_Parent.gChat.SetCSS(c_CSS)
          End Set
        End Property
        Public Property ListWidth As UInt32
          Get
            Return c_ListWidth
          End Get
          Set(value As UInt32)
            c_ListWidth = value
          End Set
        End Property
        Public Property PreWidth As UInt32
          Get
            Return c_PreWidth
          End Get
          Set(value As UInt32)
            c_PreWidth = value
          End Set
        End Property
        Public Property SendWidth As UInt32
          Get
            Return c_SendWidth
          End Get
          Set(value As UInt32)
            c_SendWidth = value
          End Set
        End Property
        Public Property WhisperWidth As UInt32
          Get
            Return c_WhisperWidth
          End Get
          Set(value As UInt32)
            c_WhisperWidth = value
          End Set
        End Property
        Public Property Parent As BNUI
          Get
            Return c_Parent
          End Get
          Set(value As BNUI)
            c_Parent = value
            CustomCSS = c_CSS
          End Set
        End Property
        Public Sub New()
        End Sub
        Public Sub New(ByRef Parent As BNUI)
          c_Parent = Parent
        End Sub
      End Class
      Public UI As cInterface
      Private c_PubAway As Boolean
      Private c_MaxLines As UInt32
      Private c_D2Emote As Boolean
      Private c_JoinLeave As Boolean
      Private c_TimeStampEnabled As Boolean
      Private c_TimeStamp As String
      Private c_WhisWin As Byte
      Private c_AccountInfo As Boolean
      Private c_RichText As Boolean
      Private c_Emoticons As Boolean
      Private c_PreventSpam As Boolean
      Private c_GetAds As Boolean
      Private c_Parent As BNUI = Nothing
      Public Property PubAway As Boolean
        Get
          Return c_PubAway
        End Get
        Set(value As Boolean)
          c_PubAway = value
        End Set
      End Property
      Public Property MaxLines As UInt32
        Get
          Return c_MaxLines
        End Get
        Set(value As UInt32)
          c_MaxLines = value
          If c_Parent IsNot Nothing AndAlso c_Parent.gChat IsNot Nothing Then c_Parent.gChat.MaxLines = value
        End Set
      End Property
      Public Property D2Emote As Boolean
        Get
          Return c_D2Emote
        End Get
        Set(value As Boolean)
          c_D2Emote = value
        End Set
      End Property
      Public Property JoinLeave As Boolean
        Get
          Return c_JoinLeave
        End Get
        Set(value As Boolean)
          c_JoinLeave = value
        End Set
      End Property
      Public Property TimeStampEnabled As Boolean
        Get
          Return c_TimeStampEnabled
        End Get
        Set(value As Boolean)
          c_TimeStampEnabled = value
          If c_Parent IsNot Nothing AndAlso c_Parent.gChat IsNot Nothing Then c_Parent.gChat.ToggleTimestamps(value)
        End Set
      End Property
      Public Property TimeStamp As String
        Get
          Return c_TimeStamp
        End Get
        Set(value As String)
          c_TimeStamp = value
          If c_Parent IsNot Nothing AndAlso c_Parent.gChat IsNot Nothing Then c_Parent.gChat.TimeStampFormat = value
        End Set
      End Property
      Public Property WhisWin As Byte
        Get
          Return c_WhisWin
        End Get
        Set(value As Byte)
          c_WhisWin = value
        End Set
      End Property
      Public Property AccountInfo As Boolean
        Get
          Return c_AccountInfo
        End Get
        Set(value As Boolean)
          c_AccountInfo = value
        End Set
      End Property
      Public Property Emoticons As Boolean
        Get
          Return c_Emoticons
        End Get
        Set(value As Boolean)
          c_Emoticons = value
          If c_Parent IsNot Nothing AndAlso c_Parent.gChat IsNot Nothing Then c_Parent.gChat.Emoticons = value
        End Set
      End Property
      Public Property RichText As Boolean
        Get
          Return c_RichText
        End Get
        Set(value As Boolean)
          c_RichText = value
          If c_Parent IsNot Nothing AndAlso c_Parent.gChat IsNot Nothing Then c_Parent.gChat.RichText = value
        End Set
      End Property
      Public Property PreventSpam As Boolean
        Get
          Return c_PreventSpam
        End Get
        Set(value As Boolean)
          c_PreventSpam = value
        End Set
      End Property
      Public Property GetAds As Boolean
        Get
          Return c_GetAds
        End Get
        Set(value As Boolean)
          c_GetAds = value
          If c_Parent IsNot Nothing Then
            If c_Parent.pctAd IsNot Nothing Then
              If value Then
                If c_Parent.IsOnline Then
                  c_Parent.tmrAds.Stop()
                  c_Parent.tmrAds.Start()
                  c_Parent.BNCS_CHECKAD_Send()
                End If
              Else
                c_Parent.pctAd.Image = Nothing
                c_Parent.pctAd.Tag = Nothing
                c_Parent.pctAd.Size = New Size(1, 1)
              End If
            End If
          End If
        End Set
      End Property
      Public Property Parent As BNUI
        Get
          Return c_Parent
        End Get
        Set(value As BNUI)
          c_Parent = value
          If UI IsNot Nothing Then UI.Parent = value
        End Set
      End Property
      Public Sub New()
        UI = New cInterface
      End Sub
      Public Sub New(ByRef Parent As BNUI)
        c_Parent = Parent
        UI = New cInterface(c_Parent)
      End Sub
    End Class
    Public Class cProxy
      Private c_Use As Boolean
      Private c_IP As String
      Private c_Port As UInt16
      Private c_Ver As ProxyType
      Private c_User As String
      Private c_Pass As String
      Public Property Use As Boolean
        Get
          Return c_Use
        End Get
        Set(value As Boolean)
          c_Use = value
        End Set
      End Property
      Public Property IP As String
        Get
          Return c_IP
        End Get
        Set(value As String)
          c_IP = value
        End Set
      End Property
      Public Property Port As UInt16
        Get
          Return c_Port
        End Get
        Set(value As UInt16)
          c_Port = value
        End Set
      End Property
      Public Property Ver As ProxyType
        Get
          Return c_Ver
        End Get
        Set(value As ProxyType)
          c_Ver = value
        End Set
      End Property
      Public Property User As String
        Get
          Return c_User
        End Get
        Set(value As String)
          c_User = value
        End Set
      End Property
      Public Property Pass As String
        Get
          Return c_Pass
        End Get
        Set(value As String)
          c_Pass = value
        End Set
      End Property
    End Class

    Public Account As cAccount
    Public Idle As cIdle
    Public Display As cDisplay
    Public Proxy As cProxy
    Public Property VerByte As UInt32
      Get
        Return c_VerByte
      End Get
      Set(value As UInt32)
        c_VerByte = value
      End Set
    End Property
    Public Property HashPath As String
      Get
        Return c_HashPath
      End Get
      Set(value As String)
        c_HashPath = value
      End Set
    End Property
    Public Property Server As String
      Get
        Return c_Server
      End Get
      Set(value As String)
        c_Server = value
      End Set
    End Property
    Public Property UTF8 As Boolean
      Get
        Return c_UTF8
      End Get
      Set(value As Boolean)
        c_UTF8 = value
      End Set
    End Property
    Public Property AutoAway As Byte
      Get
        Return c_AutoAway
      End Get
      Set(value As Byte)
        c_AutoAway = value
      End Set
    End Property
    Public Property WhisFwd As String
      Get
        Return c_WhisFwd
      End Get
      Set(value As String)
        c_WhisFwd = value
      End Set
    End Property
    Public Property LogChat As Boolean
      Get
        Return c_LogChat
      End Get
      Set(value As Boolean)
        c_LogChat = value
        If c_Parent IsNot Nothing AndAlso c_Parent.gChat IsNot Nothing Then
          If value Then
            If Not My.Computer.FileSystem.DirectoryExists(AppData & "\Logs") Then My.Computer.FileSystem.CreateDirectory(AppData & "\Logs")
            If Not My.Computer.FileSystem.DirectoryExists(AppData & "\Logs\" & ValidFile(Account.ProfileName)) Then My.Computer.FileSystem.CreateDirectory(AppData & "\Logs\" & ValidFile(Account.ProfileName))
            c_Parent.gChat.LogFile = AppData & "\Logs\" & ValidFile(Account.ProfileName) & "\" & Now.ToString("yyyy'-'MM'-'dd") & ".html"
          Else
            c_Parent.gChat.LogFile = String.Empty
          End If
        End If
      End Set
    End Property
    Public Property AutoConnect As Boolean
      Get
        Return c_AutoConnect
      End Get
      Set(value As Boolean)
        c_AutoConnect = value
      End Set
    End Property
    Public Property AutoReconnect As UInt16
      Get
        Return c_AutoReconnect
      End Get
      Set(value As UInt16)
        c_AutoReconnect = value
      End Set
    End Property
    Public Property PingSpoof As UInt32
      Get
        Return c_PingSpoof
      End Get
      Set(value As UInt32)
        c_PingSpoof = value
        If c_Parent IsNot Nothing AndAlso c_Parent.PingSpoof IsNot Nothing Then c_Parent.PingSpoof.WaitTime = value
      End Set
    End Property
    Public Property SquelchList As ArrayList
      Get
        Return c_SquelchList
      End Get
      Set(value As ArrayList)
        c_SquelchList = value
      End Set
    End Property
    Public Property TagSquelchList As ArrayList
      Get
        Return c_TagSquelchList
      End Get
      Set(value As ArrayList)
        c_TagSquelchList = value
      End Set
    End Property
    Public Property Parent As BNUI
      Get
        Return c_Parent
      End Get
      Set(value As BNUI)
        c_Parent = value
        If Display IsNot Nothing Then Display.Parent = value
      End Set
    End Property
    Public Sub New()
      Account = New cAccount
      With Account
        .ProfileName = "Entelechy@U.S. West"
        .Username = "Entelechy"
        .Password = "im mil le"
        .EMail = "nobody@void"
        .HomeChannel = String.Empty
        .StatString = "LTRD 50 1 3 255 255 255 255 1057 0"
        .Client.Product = BNUI.GameType.DRTL
        .Client.Spawn = False
        .Client.CDKey = Nothing
        .Client.EXPKey = Nothing
        .Client.D2Realm = False
        .Client.UDPPlug = False
      End With
      Idle = New cIdle
      With Idle
        .IdleOn = False
        .IdleOnSong = False
        .IdleTime = 20
        .IdleText = "/me is running %v"
      End With
      Display = New cDisplay
      With Display
        .PubAway = False
        .MaxLines = 250
        .D2Emote = False
        .JoinLeave = False
        .PreventSpam = True
        .TimeStampEnabled = True
        .TimeStamp = "[hh:mm:ss tt]"
        .WhisWin = 1
        .RichText = True
        .Emoticons = True
        .AccountInfo = True
        .GetAds = False
        '.UI = New cDisplay.cInterface
        .UI.ListWidth = 225
        .UI.PreWidth = 60
        .UI.SendWidth = 75
        .UI.WhisperWidth = 75
      End With
      Proxy = New cProxy
      With Proxy
        .Use = False
        .IP = "127.0.0.1"
        .Port = "1080"
        .Ver = ProxyType.SOCKS4
      End With
      Server = "uswest.battle.net"
      AutoAway = False
      UTF8 = True
      WhisFwd = String.Empty
      LogChat = False
      AutoConnect = False
      PingSpoof = 3
      SquelchList = New ArrayList
      TagSquelchList = New ArrayList
      AutoReconnect = 10
      VerByte = 0
      If String.IsNullOrEmpty(HashPath) Then HashPath = AppData & "\Hashes\"
    End Sub
    Public Sub New(ByRef Parent As BNUI)
      c_Parent = Parent
      Account = New cAccount
      With Account
        .ProfileName = "Entelechy@U.S. West"
        .Username = "Entelechy"
        .Password = "im mil le"
        .EMail = "nobody@void"
        .HomeChannel = String.Empty
        .StatString = "LTRD 50 1 3 255 255 255 255 1057 0"
        .Client.Product = BNUI.GameType.DRTL
        .Client.Spawn = False
        .Client.CDKey = Nothing
        .Client.EXPKey = Nothing
        .Client.D2Realm = False
        .Client.UDPPlug = False
      End With
      Idle = New cIdle
      With Idle
        .IdleOn = False
        .IdleOnSong = False
        .IdleTime = 20
        .IdleText = "/me is running %v"
      End With
      Display = New cDisplay(Parent)
      With Display
        .PubAway = False
        .MaxLines = 250
        .D2Emote = False
        .JoinLeave = False
        .PreventSpam = True
        .TimeStampEnabled = True
        .TimeStamp = "[hh:mm:ss tt]"
        .WhisWin = 1
        .RichText = True
        .Emoticons = True
        .AccountInfo = True
        .GetAds = False
        '.UI = New cDisplay.cInterface
        .UI.ListWidth = 225
        .UI.PreWidth = 60
        .UI.SendWidth = 75
        .UI.WhisperWidth = 75
      End With
      Proxy = New cProxy
      With Proxy
        .Use = False
        .IP = "127.0.0.1"
        .Port = "1080"
        .Ver = ProxyType.SOCKS4
      End With
      Server = "uswest.battle.net"
      AutoAway = False
      UTF8 = True
      WhisFwd = String.Empty
      LogChat = False
      AutoConnect = False
      PingSpoof = 3
      SquelchList = New ArrayList
      TagSquelchList = New ArrayList
      AutoReconnect = 10
      VerByte = 0
      If String.IsNullOrEmpty(HashPath) Then HashPath = AppData & "\Hashes\"
    End Sub
  End Class
  Private Class ChatQueue
    Implements IDisposable
    Private Const BASECOST As UInt16 = 250 'Unit price to send a single packet 
    Private Const THRESHOLD As UInt16 = 65 'Number of bytes that sets the "upper" and "lower" thresholds (65)
    Private Const HIGHCOST As UInt16 = 15 'Price per byte for "upper" messages (12, 18)
    Private Const LOWCOST As UInt16 = 12 'Price per byte for "lower" messages (8)
    Private Const MAXIMUM As UInt16 = 800 'Maximum units attainable (800)
    Private Const GROWTHRATE As UInt16 = 3 'Unit regrowth rate (per 10ms) (1)
    Private Credits As Int32
    Private growTimer As Threading.Timer
    Private Queue As New ArrayList
    Public Event SendMessage(sMessage As String)
    Public Sub New()
      Credits = 0
      growTimer = New Threading.Timer(AddressOf Replenish, growTimer, 0, 10)
    End Sub

    Private Sub Replenish(state As Object)
      Credits += GROWTHRATE
      If Credits > MAXIMUM Then Credits = MAXIMUM
      If Queue IsNot Nothing AndAlso Queue.Count > 0 Then
        Dim NextMsg As String = Queue(0)
        Dim uCost As UInt16 = BASECOST
        If NextMsg.Length >= THRESHOLD Then
          uCost += NextMsg.Length * HIGHCOST
        Else
          uCost += NextMsg.Length * LOWCOST
        End If
        If Credits >= uCost OrElse Credits >= MAXIMUM And Queue.Count > 0 Then
          Credits -= uCost
          If Queue IsNot Nothing AndAlso Queue.Count > 0 Then Queue.Remove(Queue(0))
          RaiseEvent SendMessage(NextMsg)
        End If
      End If
    End Sub

    Public Sub AddMessage(sMessage As String)
      sMessage = sMessage.Replace(vbNewLine, vbLf)
      sMessage = sMessage.Replace(vbCr, vbLf)
      Do While sMessage.IndexOf(vbLf & vbLf) > 0
        sMessage = sMessage.Replace(vbLf & vbLf, vbLf)
      Loop
      sMessage = sMessage.Replace(vbLf, vbCr)
      If sMessage.IndexOf(vbCr) > -1 Then
        Dim sSplit() As String = Split(sMessage, vbCr)
        For Each sItem As String In (From sItm As String In sSplit Where sItm.Length > 0)
          AddToQueue(sItem)
        Next
      Else
        If sMessage.Length > 0 Then AddToQueue(sMessage)
      End If
    End Sub

    Public Sub ClearQueue()
      Queue.Clear()
    End Sub

    Private Sub AddToQueue(sText As String)
      For Each sItem In MakeChunks(sText)
        Queue.Add(sItem)
      Next
      'If sText.Length > 224 Then
      '  Dim lastSpace As Integer
      '  Do
      '    lastSpace = sText.Substring(0, 224).LastIndexOf(".") + 1
      '    If lastSpace < 150 Then lastSpace = sText.Substring(0, 224).LastIndexOf(",") + 1
      '    If lastSpace < 150 Then lastSpace = sText.Substring(0, 224).LastIndexOf(" ") + 1
      '    If lastSpace < 150 Then lastSpace = 223
      '    Dim sAdd As String = sText.Substring(0, lastSpace)
      '    Queue.Add(sAdd)
      '    sText = sText.Substring(lastSpace)
      '  Loop While sText.Length > 224
      '  If sText.Length > 0 Then Queue.Add(sText)
      'Else
      '  Queue.Add(sText)
      'End If
    End Sub
#Region "IDisposable Support"
    Private disposedValue As Boolean
    Protected Overridable Sub Dispose(disposing As Boolean)
      If Not Me.disposedValue Then
        If disposing Then
          Credits = 0
          Queue.Clear()
          growTimer.Dispose()
        End If
      End If
      Me.disposedValue = True
    End Sub
    Public Sub Dispose() Implements IDisposable.Dispose
      Dispose(True)
      GC.SuppressFinalize(Me)
    End Sub
#End Region

  End Class
  Private Class ChannelList
    Friend Structure ChannelListItem
      Public Username As String
      Public Flags As UInt32
      Public Ping As UInt32
      Public StatString() As Byte
      Public sLastMessage As String
      Public lLastMessage As UInt32
      Private lHash As Integer
      Public Overrides Function ToString() As String
        Return Username
      End Function
    End Structure
    Private ChanItems() As ChannelListItem
    Public Sub AddItem(Username As String, Flags As UInt32, Ping As UInt32, StatString() As Byte)
      Dim Index As Integer = FindItem(Username)
      If Index = -1 Then
        If ChanItems Is Nothing Then
          Index = 0
        Else
          Index = ChanItems.Length
        End If
        ReDim Preserve ChanItems(Index)
      End If
      ChanItems(Index).Username = Username
      ChanItems(Index).Flags = Flags
      ChanItems(Index).Ping = Ping
      If StatString IsNot Nothing AndAlso StatString.Length > 0 Then ChanItems(Index).StatString = StatString
      If ChanItems(Index).lLastMessage = 0 Then ChanItems(Index).lLastMessage = Environment.TickCount
    End Sub

    Public Sub RemoveItem(Index As Integer)
      If Index < 0 Then Exit Sub
      For I As Integer = Index To ChanItems.Length - 2
        ChanItems(I) = ChanItems(I + 1)
      Next
      ReDim Preserve ChanItems(ChanItems.Length - 2)
    End Sub

    Public Sub RemoveItem(Username As String)
      RemoveItem(FindItem(Username))
    End Sub

    Public Sub Clear()
      Erase ChanItems
    End Sub

    Public Function FindItem(Username As String) As Integer
      If ChanItems Is Nothing Then Return -1
      Dim FoundItem = ChanItems.Select(Function(ChanItem, Index) New With {.Item = ChanItem, .Index = Index}).Where(Function(ChanItem, Index) StrComp(ChanItem.Item.Username, Username, CompareMethod.Text) = 0)(0)
      If FoundItem Is Nothing Then Return -1
      Return FoundItem.Index
    End Function

    Public ReadOnly Property Length As Integer
      Get
        If ChanItems Is Nothing Then Return 0
        Return ChanItems.Length
      End Get
    End Property

    Public ReadOnly Property Items As ChannelListItem()
      Get
        Return ChanItems
      End Get
    End Property

    Public ReadOnly Property Username(Index As Integer) As String
      Get
        If ChanItems Is Nothing OrElse ChanItems.Length <= Index Then Return Nothing
        Return ChanItems(Index).Username
      End Get
    End Property
    Public ReadOnly Property Username(Account As String) As String
      Get
        Return ChanItems(FindItem(Account)).Username
      End Get
    End Property

    Public ReadOnly Property Flags(Index As Integer) As UInt32
      Get
        If ChanItems Is Nothing OrElse ChanItems.Length <= Index Then Return 0
        Return ChanItems(Index).Flags
      End Get
    End Property
    Public ReadOnly Property Flags(Username As String) As UInt32
      Get
        If FindItem(Username) = -1 Then Return 0
        Return ChanItems(FindItem(Username)).Flags
      End Get
    End Property

    Public ReadOnly Property Ping(Index As Integer) As UInt32
      Get
        If ChanItems Is Nothing OrElse ChanItems.Length <= Index Then Return 0
        Return ChanItems(Index).Ping
      End Get
    End Property
    Public ReadOnly Property Ping(Username As String) As UInt32
      Get
        Return ChanItems(FindItem(Username)).Ping
      End Get
    End Property

    Public ReadOnly Property StatString(Index As Integer) As Byte()
      Get
        Return ChanItems(Index).StatString
      End Get
    End Property
    Public ReadOnly Property StatString(Username As String) As Byte()
      Get
        If FindItem(Username) >= 0 Then Return ChanItems(FindItem(Username)).StatString
        Return Nothing
      End Get
    End Property

    Public ReadOnly Property LastMessageOf(Index As Integer) As String
      Get
        Return ChanItems(Index).sLastMessage
      End Get
    End Property
    Public ReadOnly Property LastMessageOf(Username As String) As String
      Get
        If FindItem(Username) >= 0 Then Return ChanItems(FindItem(Username)).sLastMessage
        Return Nothing
      End Get
    End Property

    Public ReadOnly Property LastMessageTime(Index As Integer) As Long
      Get
        If Index > ChanItems.Length - 1 Then Return 0
        Return ChanItems(Index).lLastMessage
      End Get
    End Property
    Public ReadOnly Property LastMessageTime(Username As String) As Long
      Get
        If FindItem(Username) = -1 Then Return 0
        Return ChanItems(FindItem(Username)).lLastMessage
      End Get
    End Property

    Public Sub SaysSomething(Index As Integer, Message As String)
      If Index > -1 Then
        ChanItems(Index).lLastMessage = Environment.TickCount
        ChanItems(Index).sLastMessage = Message
      End If
    End Sub
    Public Sub SaysSomething(Username As String, Message As String)
      SaysSomething(FindItem(Username), Message)
    End Sub
  End Class
  Private Class ClanListing
    Private Structure ClanListItem
      Public Username As String
      Public Rank As Byte
      Public Status As Byte
      Public Location As String
      Public Overrides Function ToString() As String
        Return Username
      End Function
    End Structure
    Private ClanItems() As ClanListItem
    Public Sub AddItem(Username As String, Rank As Byte, Status As Byte, Location As String)
      Dim Index As Integer = FindItem(Username)
      If Index = -1 Then
        If ClanItems Is Nothing Then
          Index = 0
        Else
          Index = ClanItems.Length
        End If
        ReDim Preserve ClanItems(Index)
      End If
      ClanItems(Index).Username = Username
      ClanItems(Index).Rank = Rank
      ClanItems(Index).Status = Status
      ClanItems(Index).Location = Location
    End Sub

    Public Sub RemoveItem(Index As Integer)
      If Index < 0 Then Exit Sub
      For I As Integer = Index To ClanItems.Length - 2
        ClanItems(I) = ClanItems(I + 1)
      Next
      ReDim Preserve ClanItems(ClanItems.Length - 2)
    End Sub

    Public Sub RemoveItem(Username As String)
      RemoveItem(FindItem(Username))
    End Sub

    Public Sub Clear()
      Erase ClanItems
    End Sub

    Public Function FindItem(Username As String) As Integer
      If ClanItems Is Nothing Then Return -1
      Dim FoundItem = ClanItems.Select(Function(ChanItem, Index) New With {.Item = ChanItem, .Index = Index}).Where(Function(ChanItem, Index) StrComp(ChanItem.Item.Username, Username, CompareMethod.Text) = 0)(0)
      If FoundItem Is Nothing Then Return -1
      Return FoundItem.Index
    End Function

    Public ReadOnly Property Length As Integer
      Get
        If ClanItems Is Nothing Then Return 0
        Return ClanItems.Length
      End Get
    End Property


    Public ReadOnly Property Username(Index As Integer) As String
      Get
        If ClanItems Is Nothing Then Return Nothing
        Return ClanItems(Index).Username
      End Get
    End Property
    Public ReadOnly Property Username(Account As String) As String
      Get
        If ClanItems Is Nothing Then Return Account
        Return ClanItems(FindItem(Account)).Username
      End Get
    End Property

    Public ReadOnly Property Rank(Index As Integer) As Byte
      Get
        If ClanItems Is Nothing Then Return 0
        Return ClanItems(Index).Rank
      End Get
    End Property
    Public ReadOnly Property Rank(Account As String) As Byte
      Get
        If ClanItems Is Nothing OrElse FindItem(Account) = -1 Then Return 0
        Return ClanItems(FindItem(Account)).Rank
      End Get
    End Property

    Public ReadOnly Property Status(Index As Integer) As Byte
      Get
        If ClanItems Is Nothing Then Return 0
        Return ClanItems(Index).Status
      End Get
    End Property
    Public ReadOnly Property Status(Account As String) As Byte
      Get
        If ClanItems Is Nothing Then Return 0
        Return ClanItems(FindItem(Account)).Status
      End Get
    End Property

    Public ReadOnly Property Location(Index As Integer) As String
      Get
        If ClanItems Is Nothing Then Return Nothing
        Return ClanItems(Index).Location
      End Get
    End Property
    Public ReadOnly Property Location(Account As String) As String
      Get
        If ClanItems Is Nothing Then Return Nothing
        Return ClanItems(FindItem(Account)).Location
      End Get
    End Property

  End Class
  Public Class ProfileRequests
    Public Enum ProfileRequestType
      UserProfile
      AccountInfo
      NormalGameRecord
      LadderGameRecord
      IronManGameRecord
      NormalLadderGameRecord
      NormalLadderIronManGameRecord
      WarcraftLadderMap
      WarcraftCancelLadder
      WarcraftUserStats
      WarcraftClanStats
      WarcraftIconList
      WarcraftIconChange
      Custom
    End Enum

    Public Enum ProfileRequestDisplay
      PublicChat
      PublicWhisper
      PrivateText
      PrivateUI
    End Enum

    Private Structure ProfileRequestItem
      Public Cookie As UInt32
      Public Accounts() As String
      Public Request As ProfileRequestType
      Public Display As ProfileRequestDisplay
      Public Target As String
      Public UpdateType As frmProfile.UpdateTypes
    End Structure

    Private ProfileRequest() As ProfileRequestItem

    Public Sub New()
      Erase ProfileRequest
    End Sub

    Public Function AddRequest(Usernames() As String, Request As ProfileRequestType, Display As ProfileRequestDisplay, UpdateType As frmProfile.UpdateTypes, Optional Target As String = Nothing) As UInt32
      Dim lCookie As UInt32
      If ProfileRequest Is Nothing OrElse ProfileRequest.Length = 0 Then
        ReDim ProfileRequest(0)
        lCookie = Environment.TickCount
      Else
        lCookie = ProfileRequest(ProfileRequest.Count - 1).Cookie + 1
        ReDim Preserve ProfileRequest(ProfileRequest.Count)
      End If
      ProfileRequest(ProfileRequest.Count - 1).Accounts = Usernames
      ProfileRequest(ProfileRequest.Count - 1).Request = Request
      ProfileRequest(ProfileRequest.Count - 1).Display = Display
      ProfileRequest(ProfileRequest.Count - 1).Target = Target
      ProfileRequest(ProfileRequest.Count - 1).Cookie = lCookie
      ProfileRequest(ProfileRequest.Count - 1).UpdateType = UpdateType
      Return lCookie
    End Function

    Public Sub GetRequest(Cookie As UInt32, ByRef Usernames() As String, ByRef Request As ProfileRequestType, ByRef Display As ProfileRequestDisplay, ByRef UpdateType As frmProfile.UpdateTypes, Optional ByRef Target As String = Nothing)
      Dim aInfo As ProfileRequestItem = (From pInfo As ProfileRequestItem In ProfileRequest Where pInfo.Cookie = Cookie).FirstOrDefault
      If aInfo.Cookie = Cookie Then
        Usernames = aInfo.Accounts
        Request = aInfo.Request
        Display = aInfo.Display
        UpdateType = aInfo.UpdateType
        If aInfo.Display = ProfileRequestDisplay.PublicWhisper Then Target = aInfo.Target
        Dim oList As New ArrayList(ProfileRequest)
        oList.Remove(aInfo)
        ProfileRequest = oList.ToArray(GetType(ProfileRequestItem))
      End If
    End Sub
  End Class
  Private Class PanelSizePass
    Public Item As String
    Public Offset As Integer
    Public Width As Integer
    Public Sub New(sItem As String, iOffset As Integer, iWidth As Integer)
      Item = sItem
      Offset = iOffset
      Width = iWidth
    End Sub
  End Class
  Private Class PacketMessages
    Inherits ArrayList
    Public txtMessage As TextBox
    Private c_Parsed As Boolean
    Public Property Parsed As Boolean
      Get
        Return c_Parsed
      End Get
      Set(value As Boolean)
        c_Parsed = value
        Redraw()
      End Set
    End Property
    Public Sub AddPacket(Protocol As String, Recv As Boolean, ID As Byte, Data() As Byte, Client As GameType)
      MyBase.Add(New PacketMessage(Protocol, Recv, ID, Data, Client))
      Redraw()
    End Sub
    Public Overrides Sub Clear()
      MyBase.Clear()
      Redraw()
    End Sub
    Private Sub Redraw()
      If MyBase.Count > 0 Then
        Dim sText As String = String.Empty
        For Each pMsg As PacketMessage In Me
          Dim sTmp As String = IIf(c_Parsed, pMsg.Parse, pMsg.ToString)
          If Not String.IsNullOrEmpty(sTmp) Then sText &= sTmp & vbNewLine & vbNewLine
        Next
        If String.Compare(txtMessage.Text, sText) <> 0 Then
          txtMessage.SuspendLayout()
          txtMessage.Text = sText
          txtMessage.SelectionStart = txtMessage.Text.Length
          txtMessage.SelectionLength = 0
          txtMessage.ScrollToCaret()
          txtMessage.ResumeLayout()
        End If
      Else
        If Not String.IsNullOrEmpty(txtMessage.Text) Then txtMessage.Text = String.Empty
      End If
    End Sub
    Public Sub New()
      Clear()
    End Sub
    Public Sub New(ByRef UseBox As TextBox)
      txtMessage = UseBox
    End Sub
  End Class
  Private Class PacketMessage
    Private c_Protocol As String
    Private c_Recv As Boolean
    Private c_ID As Byte
    Private c_Data As Byte()
    Private c_Client As GameType
    Public Sub New(Protocol As String, Recv As Boolean, ID As Byte, Data() As Byte, Client As GameType)
      c_Protocol = Protocol
      c_Recv = Recv
      c_ID = ID
      c_Data = Data
      c_Client = Client
    End Sub
    Public Property Protocol As String
      Get
        Return c_Protocol
      End Get
      Set(value As String)
        c_Protocol = value
      End Set
    End Property
    Public Property Recv As Boolean
      Get
        Return c_Recv
      End Get
      Set(value As Boolean)
        c_Recv = value
      End Set
    End Property
    Public Property ID As Byte
      Get
        Return c_ID
      End Get
      Set(value As Byte)
        c_ID = value
      End Set
    End Property
    Public Property Data As Byte()
      Get
        Return c_Data
      End Get
      Set(value As Byte())
        c_Data = value
      End Set
    End Property
    Public Overrides Function ToString() As String
      Return c_Protocol & "  " & IIf(Recv, "S > C", "C > S") & "  " & ToID(c_Protocol, c_ID) & vbNewLine & FormatPacket(c_Data)
    End Function
    Public Function Parse() As String
      Dim sParsed = String.Empty
      Dim pReader As New DataReader(c_Data)
      Select Case Protocol
        Case My.Resources.PROTOCOL_BNCS
          Dim BNCSID As Byte = pReader.ReadByte
          Dim PacketID As Byte = pReader.ReadByte
          Dim PacketLen As UInt16 = pReader.ReadUInt16
          Dim sHeader As String = c_Protocol & "  " & IIf(Recv, "S > C", "C > S") & "  0x" & PadHex(PacketID, 2) & " " & ToID(c_Protocol, c_ID) & "  Length: " & PacketLen
          Select Case c_ID
            Case BNCS_NULL
              Return Nothing
              'Return sHeader
            Case BNCS_STOPADV
              Return sHeader
            Case BNCS_SERVERLIST
              If c_Recv Then
                Return sHeader & vbNewLine & " Server Version: " & pReader.ReadUInt32
              Else
                Return sHeader
              End If
            Case BNCS_CLIENTID
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Registration Version: " & pReader.ReadInt32 & vbNewLine &
                        " Registration Authority: " & pReader.ReadInt32 & vbNewLine &
                        " Client ID: " & pReader.ReadInt32 & vbNewLine &
                        " Client Token: " & pReader.ReadInt32
              Else
                Return sHeader & vbNewLine &
                        " Registration Version: " & pReader.ReadInt32 & vbNewLine &
                        " Registration Authority: " & pReader.ReadInt32 & vbNewLine &
                        " Client ID: " & pReader.ReadInt32 & vbNewLine &
                        " Client Token: " & pReader.ReadInt32 & vbNewLine &
                        " Machine Name: " & pReader.ReadCString & vbNewLine &
                        " User Name: " & pReader.ReadCString
              End If
            Case BNCS_STARTVERSIONING
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " MPQ Time: " & UInt64ToDate(pReader.ReadUInt64).ToString("g") & vbNewLine &
                        " MPQ Name: " & pReader.ReadCString & vbNewLine &
                        " CheckRevision Request: " & BitConverter.ToString(pReader.ReadNullTerminatedByteArray)
              Else
                Return sHeader & vbNewLine &
                        " Platform: " & pReader.ReadDWORDString & vbNewLine &
                        " Product: " & GameStringToName(pReader.ReadDWORDString) & vbNewLine &
                        " VerByte: " & pReader.ReadUInt32 & vbNewLine &
                        " Null: " & pReader.ReadUInt32
              End If
            Case BNCS_REPORTVERSION
              If c_Recv Then
                Dim lRet As UInt32
                lRet = pReader.ReadUInt32
                Select Case lRet
                  Case &H0
                    Return sHeader & vbNewLine &
                      " Result: " & My.Resources.VERSION_FAIL
                  Case &H1
                    Return sHeader & vbNewLine &
                      " Result: " & ResString(My.Resources.VERSION_UPGRADE_PATCH, pReader.ReadCString)
                  Case &H2
                    Return sHeader & vbNewLine &
                      " Result: OK."
                  Case &H3
                    Return sHeader & vbNewLine &
                      " Result: " & My.Resources.VERSION_REINSTALL
                  Case Else
                    Return sHeader & vbNewLine &
                      " Result: " & ResString(My.Resources.VERSION_UNKNOWN, "BNCS_REPORTVERSION", Hex(lRet))
                End Select
              Else
                Return sHeader & vbNewLine &
                        " Platform: " & pReader.ReadDWORDString & vbNewLine &
                        " Product: " & GameTypeToGameTitle(GameStringToGameType(pReader.ReadDWORDString)) & vbNewLine &
                        " VerByte: " & pReader.ReadUInt32 & vbNewLine &
                        " EXE Version: " & Hex(pReader.ReadUInt32) & vbNewLine &
                        " EXE Hash: " & Hex(pReader.ReadUInt32) & vbNewLine &
                        " EXE Info: " & BitConverter.ToString(pReader.ReadNullTerminatedByteArray)
              End If
            Case BNCS_STARTADVEX
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Result: " & IIf(pReader.ReadBoolean, My.Resources.INFO_STARTADVEX, My.Resources.ERR_STARTADVEX)
              Else
                Return sHeader & vbNewLine &
                        " State: " & pReader.ReadUInt32 & vbNewLine &
                        " Up Time: " & pReader.ReadUInt32 & vbNewLine &
                        " Game Type: " & pReader.ReadUInt16 & vbNewLine &
                        " Teams: " & pReader.ReadUInt16 & vbNewLine &
                        " Null: " & pReader.ReadUInt32 & vbNewLine &
                        " Null: " & pReader.ReadUInt32 & vbNewLine &
                        " Game Name: " & pReader.ReadCString & vbNewLine &
                        " Game Password: " & pReader.ReadCString & vbNewLine &
                        " Game Statstring: " & pReader.ReadCString
              End If
            Case BNCS_GETADVLISTEX
              If c_Recv Then
                Dim GameList As UInt32 = pReader.ReadUInt32
                If GameList = 0 Then
                  Dim Status As UInt32 = pReader.ReadUInt32
                  Select Case Status
                    Case &H0
                      Return sHeader & vbNewLine &
                        " Result: OK."
                    Case &H1
                      Return sHeader & vbNewLine &
                        " Result: Game doesn't exist."
                    Case &H2
                      Return sHeader & vbNewLine &
                        " Result: Incorrect password."
                    Case &H3
                      Return sHeader & vbNewLine &
                        " Result: Game full."
                    Case &H4
                      Return sHeader & vbNewLine &
                        " Result: Game already started."
                    Case &H6
                      Return sHeader & vbNewLine &
                        " Result: Too many server requests."
                    Case Else
                      Return sHeader & vbNewLine &
                        " Result: Unknown game list status: " & Status & "."
                  End Select
                Else
                  Dim sTmp As String = " Games: " & GameList
                  If c_Client = GameType.WAR3 Or c_Client = GameType.W3XP Then
                    For I As Integer = 0 To GameList - 1
                      sTmp &= vbNewLine & "  Game " & (I + 1) & vbNewLine
                      Dim GameType As UInt32 = pReader.ReadUInt32
                      Dim LanguageID As UInt32 = pReader.ReadUInt32
                      Dim AddressFamily As UInt16 = pReader.ReadUInt16
                      Dim Port As UInt16 = pReader.ReadUInt16
                      Dim HostIP As UInt32 = pReader.ReadUInt32
                      Dim Null1 As UInt32 = pReader.ReadUInt32
                      Dim Null2 As UInt32 = pReader.ReadUInt32
                      Dim GameVisible As UInt32 = pReader.ReadUInt32
                      Dim GameTime As UInt32 = pReader.ReadUInt32
                      Dim GameName As String = Encoding.GetEncoding(UTF_8).GetString(pReader.ReadNullTerminatedByteArray)
                      Dim GameNull As String = pReader.ReadByte
                      Dim FreeSlots As Byte = Byte.Parse(Chr(pReader.ReadByte), NumberStyles.HexNumber)
                      Dim HostCounter As String = System.Text.Encoding.GetEncoding(LATIN_1).GetString(pReader.ReadByteArray(8))
                      Dim GameStats() As Byte = pReader.ReadNullTerminatedByteArray
                      Dim MapStats() As Byte = Nothing
                      ParseW3Stat.Map.DecodeData(GameStats, MapStats)
                      Dim pktMap As New DataReader(MapStats)
                      Dim MapFlags As UInt32 = pktMap.ReadUInt32
                      Dim MapNull1 As Byte = pktMap.ReadByte
                      Dim MapWidth As UInt16 = pktMap.ReadUInt16
                      Dim MapHeight As UInt16 = pktMap.ReadUInt16
                      Dim MapCRC As UInt32 = pktMap.ReadUInt32
                      Dim MapPath As String = pktMap.ReadCString
                      Dim MapHost As String = pktMap.ReadCString
                      Dim MapNull2 As Byte = pktMap.ReadByte
                      Dim MapHash() As Byte = pktMap.ReadByteArray(20)
                      sTmp &= "   Game Type: " & GameType & " (0x" & PadHex(GameType, 8) & ")" & vbNewLine &
                              "   Language ID: " & Globalization.CultureInfo.GetCultureInfo(CInt(LanguageID)).EnglishName & " (0x" & PadHex(LanguageID, 8) & ")" & vbNewLine &
                              "   Address Family: " & AddressFamily & " (0x" & PadHex(AddressFamily, 4) & ")" & vbNewLine &
                              "   Port: " & Port & vbNewLine &
                              "   Host IP: " & PadHex(HostIP, 8) & vbNewLine &
                              "   Null: " & Null1 & vbNewLine &
                              "   Null: " & Null2 & vbNewLine &
                              "   Game Visibility: " & IIf(GameVisible = &H10, "Public", IIf(GameVisible = &H11, "Private", "0x" & PadHex(GameVisible, 8))) & vbNewLine &
                              "   Game Time: " & ConvertTime(GameTime * 1000, True) & vbNewLine &
                              "   Game Name: " & GameName & vbNewLine &
                              "   Game Null: " & GameNull & vbNewLine &
                              "   Free Slots: " & FreeSlots & vbNewLine &
                              "   Host Counter: " & HostCounter & vbNewLine &
                              "   Map Flags: " & MapFlags & " (0x" & PadHex(MapFlags, 8) & ")" & vbNewLine &
                              "   Map Null1: 0x" & PadHex(MapNull1, 2) & vbNewLine &
                              "   Map Width: " & MapWidth & vbNewLine &
                              "   Map Height: " & MapHeight & vbNewLine &
                              "   Map CRC: " & PadHex(MapCRC, 8) & vbNewLine &
                              "   Map Path: " & MapPath & vbNewLine &
                              "   Map Host: " & MapHost & vbNewLine &
                              "   Map Null2: 0x" & PadHex(MapNull2, 2) & vbNewLine &
                              "   Map Hash: " & BitConverter.ToString(MapHash)
                    Next
                    Return sHeader & vbNewLine & sTmp
                  Else
                    For I As Integer = 0 To GameList - 1
                      sTmp &= vbNewLine & "  Game " & (I + 1) & vbNewLine
                      Dim GameType As UInt16 = pReader.ReadUInt16
                      Dim Parameter As UInt16 = pReader.ReadUInt16
                      Dim LanguageID As UInt32 = pReader.ReadUInt32
                      Dim AddressFamily As UInt16 = pReader.ReadUInt16
                      Dim Port As UInt16 = pReader.ReadUInt16
                      Dim HostIP As UInt32 = pReader.ReadUInt32
                      Dim Null1 As UInt32 = pReader.ReadUInt32
                      Dim Null2 As UInt32 = pReader.ReadUInt32
                      Dim GameStatus As UInt32 = pReader.ReadUInt32
                      Dim GameTime As UInt32 = pReader.ReadUInt32
                      Dim GameName As String = Encoding.GetEncoding(LATIN_1).GetString(pReader.ReadNullTerminatedByteArray)
                      Dim GamePassword As String = pReader.ReadCString
                      Dim GameStatString As String = pReader.ReadCString
                      sTmp &= "   Game Type: " & GameType & " (0x" & PadHex(GameType, 4) & ")" & vbNewLine &
                              "   Parameter: " & Parameter & " (0x" & PadHex(Parameter, 4) & ")" & vbNewLine &
                              "   Language ID: " & Globalization.CultureInfo.GetCultureInfo(CInt(LanguageID)).EnglishName & " (0x" & PadHex(LanguageID, 8) & ")" & vbNewLine &
                              "   Address Family: " & AddressFamily & " (0x" & PadHex(AddressFamily, 4) & ")" & vbNewLine &
                              "   Port: " & Port & vbNewLine &
                              "   Host IP: " & PadHex(HostIP, 8) & vbNewLine &
                              "   Null: " & Null1 & vbNewLine &
                              "   Null: " & Null2 & vbNewLine &
                              "   Game Status: " & GameStatus & " (0x" & PadHex(GameStatus, 8) & ")" & vbNewLine &
                              "   Game Time: " & ConvertTime(GameTime * 1000, True) & vbNewLine &
                              "   Game Name: " & GameName & vbNewLine &
                              "   Game Password: " & GamePassword & vbNewLine &
                              "   Game Statstring: " & GameStatString
                    Next
                    Return sHeader & vbNewLine & sTmp
                  End If
                End If
              Else
                Return sHeader & vbNewLine &
                        " Condition 1: 0x" & PadHex(pReader.ReadUInt16, 4) & vbNewLine &
                        " Condition 2: 0x" & PadHex(pReader.ReadUInt16, 4) & vbNewLine &
                        " Condition 3: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Condition 4: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " List Count: " & pReader.ReadUInt32 & vbNewLine &
                        " Game Name: " & pReader.ReadCString & vbNewLine &
                        " Game Password: " & pReader.ReadCString & vbNewLine &
                        " Game Statstring: " & pReader.ReadCString
              End If
            Case BNCS_ENTERCHAT
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Unique Name: " & pReader.ReadCString & vbNewLine &
                        " StatString: " & ParseStatString(pReader.ReadNullTerminatedByteArray) & vbNewLine &
                        " Account Name: " & pReader.ReadCString
              Else
                Return sHeader & vbNewLine &
                        " Username: " & pReader.ReadCString & vbNewLine &
                        " StatString: " & ParseStatString(pReader.ReadNullTerminatedByteArray)
              End If
            Case BNCS_GETCHANNELLIST
              If c_Recv Then
                Dim cList As String = String.Empty
                Do
                  Dim sChannel As String = pReader.ReadCString
                  If String.IsNullOrEmpty(sChannel) Then Exit Do
                  cList &= sChannel & ", "
                Loop
                Return sHeader & vbNewLine &
                        " Channels: " & cList.Substring(0, cList.Length - 2)
              Else
                Return sHeader & vbNewLine &
                        " Product: " & GameStringToName(pReader.ReadDWORDString)
              End If
            Case BNCS_JOINCHANNEL
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " Flags: " & pReader.ReadUInt32 & vbNewLine &
                        " Channel: " & pReader.ReadCString
              End If
            Case BNCS_CHATCOMMAND
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " Message: " & pReader.ReadCString
              End If
            Case BNCS_CHATEVENT
              If c_Recv Then
                Dim EventID As UInt32 = pReader.ReadUInt32
                Dim Flags As UInt32 = pReader.ReadUInt32
                Dim Ping As UInt32 = pReader.ReadUInt32
                Dim IP As UInt32 = pReader.ReadUInt32
                Dim AccountID As UInt32 = pReader.ReadUInt32
                Dim RegistrationID As UInt32 = pReader.ReadUInt32
                Dim Account As String = pReader.ReadCString
                Dim Message As String = pReader.ReadCString
                Dim EventName As String = String.Empty
                Select Case EventID
                  Case EID_SHOWUSER : EventName = "EID_SHOWUSER"
                  Case EID_JOIN : EventName = "EID_JOIN"
                  Case EID_LEAVE : EventName = "EID_LEAVE"
                  Case EID_WHISPER : EventName = "EID_WHISPER"
                  Case EID_TALK : EventName = "EID_TALK"
                  Case EID_BROADCAST : EventName = "EID_BROADCAST"
                  Case EID_CHANNEL : EventName = "EID_CHANNEL"
                  Case EID_USERFLAGS : EventName = "EID_USERFLAGS"
                  Case EID_WHISPERSENT : EventName = "EID_WHISPERSENT"
                  Case EID_CHANNELDOESNOTEXIST : EventName = "EID_CHANNELDOESNOTEXIST"
                  Case EID_CHANNELRESTRICTED : EventName = "EID_CHANNELRESTRICTED"
                  Case EID_CHANNELFULL : EventName = "EID_CHANNELFULL"
                  Case EID_INFO : EventName = "EID_INFO"
                  Case EID_ERROR : EventName = "EID_ERROR"
                  Case EID_EMOTE : EventName = "EID_EMOTE"
                End Select
                Return sHeader & vbNewLine &
                        " Event ID: 0x" & PadHex(EventID, 8) & IIf(String.IsNullOrEmpty(EventName), String.Empty, " " & EventName) & vbNewLine &
                        " Flags: 0x" & PadHex(Flags, 8) & vbNewLine &
                        " Ping: " & Ping & vbNewLine &
                        " IP: 0x" & PadHex(Flags, 8) & vbNewLine &
                        " Account ID: 0x" & PadHex(AccountID, 8) & vbNewLine &
                        " Registration ID: 0x" & PadHex(RegistrationID, 8) & vbNewLine &
                        " Account: " & Account & vbNewLine &
                        " Message: " & Message
              Else
                Return sHeader
              End If
            Case BNCS_LEAVECHAT
              Return sHeader
            Case BNCS_LOCALEINFO
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " System Time: " & UInt64ToDate(pReader.ReadUInt64).ToString("g") & vbNewLine &
                        " Local Time: " & UInt64ToDate(pReader.ReadUInt64).ToString("g") & vbNewLine &
                        " Timezone Bias:" & pReader.ReadUInt32 & vbNewLine &
                        " SystemDefaultLCID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " UserDefaultLCID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " UserDefaultLangID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Abbreviated Language Name: " & pReader.ReadCString & vbNewLine &
                        " Country Name: " & pReader.ReadCString & vbNewLine &
                        " Abbreviated Country Name: " & pReader.ReadCString & vbNewLine &
                        " English Country Name: " & pReader.ReadCString
              End If
            Case BNCS_FLOODDETECTED
              Return sHeader
            Case BNCS_UDPPINGRESPONSE
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " UDP Code: 0x" & PadHex(pReader.ReadUInt32, 8)
              End If
            Case BNCS_CHECKAD
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Ad ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Ad Extension: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Ad Time: " & UInt64ToDate(pReader.ReadUInt64).ToString("g") & vbNewLine &
                        " Ad Name: " & pReader.ReadCString & vbNewLine &
                        " Ad URL: " & pReader.ReadCString
              Else
                Return sHeader & vbNewLine &
                        " Platform: " & pReader.ReadDWORDString & vbNewLine &
                        " Product: " & GameStringToName(pReader.ReadDWORDString) & vbNewLine &
                        " Last Ad ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Time: " & pReader.ReadUInt32
              End If
            Case BNCS_CLICKAD
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " Last Ad ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Time: " & pReader.ReadUInt32
              End If
            Case BNCS_READMEMORY
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Request ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Address: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Length: " & pReader.ReadUInt32
              Else
                Return sHeader & vbNewLine &
                        " Request ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Data: " & BitConverter.ToString(pReader.ReadNullTerminatedByteArray)
              End If
            Case BNCS_REGISTRY
              If c_Recv Then
                Dim Cookie As UInt32 = pReader.ReadUInt32
                Dim HKey As UInt32 = pReader.ReadUInt32
                Dim RegPath As String = pReader.ReadCString
                Dim RegKey As String = pReader.ReadCString
                Dim RegHKey As String = String.Empty
                Select Case HKey
                  Case &H80000000& : RegHKey = "HKEY_CLASSES_ROOT"
                  Case &H80000001& : RegHKey = "HKEY_CURRENT_USER"
                  Case &H80000002& : RegHKey = "HKEY_LOCAL_MACHINE"
                  Case &H80000003& : RegHKey = "HKEY_USERS"
                  Case &H80000004& : RegHKey = "HKEY_PERFORMANCE_DATA"
                  Case &H80000005& : RegHKey = "HKEY_CURRENTCONFIG"
                  Case &H80000006& : RegHKey = "HKEY_PERFORMANCE_DATA"
                End Select
                Return sHeader & vbNewLine &
                        " Cookie: 0x" & PadHex(Cookie, 8) & vbNewLine &
                        " HKEY: 0x" & PadHex(HKey, 8) & " " & RegHKey & vbNewLine &
                        " Registry Path: " & RegPath & vbNewLine &
                        " Registry Key: " & RegKey
              Else
                Return sHeader & vbNewLine &
                        " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Registry Value: " & pReader.ReadCString
              End If
            Case BNCS_MESSAGEBOX
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Style: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Text: " & pReader.ReadCString & vbNewLine &
                        " Caption: " & pReader.ReadCString
              Else
                Return sHeader
              End If
            Case BNCS_STARTADVEX2
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " State: " & pReader.ReadUInt32 & vbNewLine &
                        " Up Time: " & pReader.ReadUInt32 & vbNewLine &
                        " Game Type: " & pReader.ReadUInt16 & vbNewLine &
                        " Teams: " & pReader.ReadUInt16 & vbNewLine &
                        " Null: " & pReader.ReadUInt32 & vbNewLine &
                        " Null: " & pReader.ReadUInt32 & vbNewLine &
                        " Game Name: " & pReader.ReadCString & vbNewLine &
                        " Game Password: " & pReader.ReadCString & vbNewLine &
                        " Game Statstring: " & pReader.ReadCString
              End If
            Case BNCS_GAMEDATAADDRESS
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " SOCKADDR:" & vbNewLine &
                        "  AF_" & pReader.ReadUInt16 & vbNewLine &
                        "  " & BitConverter.ToString(pReader.ReadByteArray(16))
              End If
            Case BNCS_STARTADVEX3
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Result: " & IIf(pReader.ReadBoolean, My.Resources.INFO_STARTADVEX, My.Resources.ERR_STARTADVEX)
              Else
                Return sHeader & vbNewLine &
                        " State: " & pReader.ReadUInt32 & vbNewLine &
                        " Up Time: " & pReader.ReadUInt32 & vbNewLine &
                        " Game Type: " & pReader.ReadUInt16 & vbNewLine &
                        " Teams: " & pReader.ReadUInt16 & vbNewLine &
                        " Unknown: " & pReader.ReadUInt32 & vbNewLine &
                        " Ladder: " & pReader.ReadUInt32 & vbNewLine &
                        " Game Name: " & pReader.ReadCString & vbNewLine &
                        " Game Password: " & pReader.ReadCString & vbNewLine &
                        " Game Statstring: " & pReader.ReadCString
              End If
            Case BNCS_LOGONCHALLENGEEX
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " UDP Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Server Token: 0x" & PadHex(pReader.ReadUInt32, 8)
              Else
                Return sHeader
              End If
            Case BNCS_CLIENTID2
              If c_Recv Then
                Return sHeader
              Else
                Dim RegType As UInt32 = pReader.ReadUInt32
                Dim RegVer, RegAut As UInt32
                If RegType = 1 Then
                  RegVer = pReader.ReadUInt32
                  RegAut = pReader.ReadUInt32
                Else
                  RegAut = pReader.ReadUInt32
                  RegVer = pReader.ReadUInt32
                End If
                Dim CID As UInt32 = pReader.ReadUInt32
                Dim CTok As UInt32 = pReader.ReadUInt32
                Dim sMachine As String = pReader.ReadCString
                Dim sUser As String = pReader.ReadCString
                Return sHeader & vbNewLine &
                        " Registration Type: " & RegType & vbNewLine &
                        " Registration Version: " & RegVer & vbNewLine &
                        " Registration Authority: " & RegAut & vbNewLine &
                        " Client ID: " & CID & vbNewLine &
                        " Client Token: " & CTok & vbNewLine &
                        " Machine Name: " & sMachine & vbNewLine &
                        " User Name: " & sUser
              End If
            Case BNCS_LEAVEGAME
              Return sHeader
            Case BNCS_ANNOUNCEMENT
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Message: " & pReader.ReadCString
              Else
                Return sHeader
              End If
            Case BNCS_DISPLAYAD
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " Platform: " & pReader.ReadDWORDString & vbNewLine &
                        " Product: " & GameStringToName(pReader.ReadDWORDString) & vbNewLine &
                        " Ad ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Ad Name: " & pReader.ReadCString & vbNewLine &
                        " Ad URL: " & pReader.ReadCString
              End If
            Case BNCS_NOTIFYJOIN
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " Product: " & GameStringToName(pReader.ReadDWORDString) & vbNewLine &
                        " VerByte: " & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Game Name: " & pReader.ReadCString & vbNewLine &
                        " Game Password: " & pReader.ReadCString
              End If
            Case BNCS_WRITECOOKIE
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Stamp: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Name: " & pReader.ReadCString & vbNewLine &
                        " Value: " & pReader.ReadCString & vbNewLine
              Else
                Return sHeader
              End If
            Case BNCS_READCOOKIE
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Stamp: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Name: " & pReader.ReadCString & vbNewLine
              Else
                Return sHeader & vbNewLine &
                        " ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Stamp: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Name: " & pReader.ReadCString & vbNewLine &
                        " Value: " & pReader.ReadCString & vbNewLine
              End If
            Case BNCS_PING
              Return sHeader & vbNewLine &
                      " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
            Case BNCS_READUSERDATA
              If c_Recv Then
                Dim lAccounts As UInt32 = pReader.ReadUInt32
                Dim lKeys As UInt32 = pReader.ReadUInt32
                Dim lCookie As UInt32 = pReader.ReadUInt32
                Dim sTmp As String = String.Empty
                sTmp &= vbNewLine & " Accounts: " & lAccounts &
                        vbNewLine & " Keys: " & lKeys &
                        vbNewLine & " Cookie: 0x" & PadHex(lCookie, 8)
                For I As Integer = 0 To lAccounts - 1
                  sTmp &= vbNewLine & " User: " & I
                  For J As Integer = 0 To lKeys - 1
                    sTmp &= vbNewLine & "  Field " & J & ": " & pReader.ReadCString
                  Next
                Next
                Return sHeader & sTmp
              Else
                Dim lAccounts As UInt32 = pReader.ReadUInt32
                Dim lKeys As UInt32 = pReader.ReadUInt32
                Dim lCookie As UInt32 = pReader.ReadUInt32
                Dim sTmp As String = String.Empty
                sTmp &= vbNewLine & " Accounts: " & lAccounts &
                        vbNewLine & " Keys: " & lKeys &
                        vbNewLine & " Cookie: 0x" & PadHex(lCookie, 8)
                For I As Integer = 0 To lAccounts - 1
                  sTmp &= vbNewLine & "  User " & I & ": " & pReader.ReadCString
                Next
                For I As Integer = 0 To lKeys - 1
                  sTmp &= vbNewLine & "  Field " & I & ": " & pReader.ReadCString
                Next
                Return sHeader & sTmp
              End If
            Case BNCS_WRITEUSERDATA
              If c_Recv Then
                Return sHeader
              Else
                Dim lAccounts As UInt32 = pReader.ReadUInt32
                Dim lKeys As UInt32 = pReader.ReadUInt32
                Dim lCookie As UInt32 = pReader.ReadUInt32
                Dim sTmp As String = String.Empty
                sTmp &= vbNewLine & " Accounts: " & lAccounts &
                        vbNewLine & " Keys: " & lKeys
                For I As Integer = 0 To lAccounts - 1
                  sTmp &= vbNewLine & "  User " & I & ": " & pReader.ReadCString
                Next
                For I As Integer = 0 To lKeys - 1
                  sTmp &= vbNewLine & "  Field " & I & ": " & pReader.ReadCString
                Next
                For I As Integer = 0 To lKeys - 1
                  sTmp &= vbNewLine & "  Value " & I & ": " & pReader.ReadCString
                Next
                Return sHeader & sTmp
              End If
            Case BNCS_LOGONCHALLENGE
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Server Token: 0x" & PadHex(pReader.ReadUInt32, 8)
              Else
                Return sHeader
              End If
            Case BNCS_LOGONRESPONSE
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Result: " & IIf(pReader.ReadBoolean, "Success", "Invalid Password")
              Else
                Return sHeader & vbNewLine &
                        " Client Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Server Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Password Hash: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        " Username: " & pReader.ReadCString
              End If
            Case BNCS_CREATEACCOUNT
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Result: " & IIf(pReader.ReadBoolean, "Success", "Failure")
              Else
                Return sHeader & vbNewLine &
                        " Password Hash: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        " Username: " & pReader.ReadCString
              End If
            Case BNCS_SYSTEMINFO
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " Processor Count: " & pReader.ReadUInt32 & vbNewLine &
                        " Processor Architecture: " & pReader.ReadUInt32 & vbNewLine &
                        " Processor Level: " & pReader.ReadUInt32 & vbNewLine &
                        " Processor Timing: " & pReader.ReadUInt32 & vbNewLine &
                        " Total Memory: " & pReader.ReadUInt32 & vbNewLine &
                        " Page File: " & pReader.ReadUInt32 & vbNewLine &
                        " Disk Space: " & pReader.ReadUInt32
              End If
            Case BNCS_GAMERESULT
              If c_Recv Then
                Return sHeader
              Else
                Dim GameType As UInt32 = pReader.ReadUInt32
                Dim sGameType As String = String.Empty
                Select Case GameType
                  Case 0 : sGameType = "Normal"
                  Case 1 : sGameType = "Ladder"
                  Case 2 : sGameType = "Iron Man"
                  Case Else : sGameType = "Unknown"
                End Select
                Dim GameResults As UInt32 = pReader.ReadUInt32
                Dim Results(GameResults - 1) As UInt32
                For I As Integer = 0 To GameResults - 1
                  Results(I) = pReader.ReadUInt32
                Next
                Dim Players(GameResults - 1) As String
                For I As Integer = 0 To GameResults - 1
                  Players(I) = pReader.ReadCString
                Next
                Dim MapName As String = pReader.ReadCString
                Dim PlayerScore As String = pReader.ReadCString
                Dim sTmp As String = vbNewLine & " Game Type: " & GameType & " " & sGameType &
                                      vbNewLine & " Results: " & GameResults
                For I As Integer = 0 To GameResults - 1
                  Dim sRet As String = String.Empty
                  Select Case Results(I)
                    Case 0 : sRet = "No player"
                    Case 1 : sRet = "Win"
                    Case 2 : sRet = "Loss"
                    Case 3 : sRet = "Draw"
                    Case 4 : sRet = "Disconnect"
                    Case 5 : sRet = "Unknown"
                  End Select
                  sTmp &= vbNewLine & "  Player " & (I + 1) & ": " & Players(I) & " - " & sRet & " (" & Results(I) & ")"
                Next
                sTmp &= vbNewLine & " Map Name: " & MapName &
                        vbNewLine & " Player Score: " & PlayerScore
                Return sHeader & sTmp
              End If
            Case BNCS_GETICONDATA
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " File Time: " & UInt64ToDate(pReader.ReadUInt64) & vbNewLine &
                        " File Name: " & pReader.ReadCString
              Else
                Return sHeader
              End If
            Case BNCS_GETLADDERDATA
              If c_Recv Then
                Dim sTmp As String = String.Empty
                Dim LadderType As UInt32 = pReader.ReadUInt32
                Dim League As UInt32 = pReader.ReadUInt32
                Dim SortMethod As UInt32 = pReader.ReadUInt32
                Dim sMethod As String = String.Empty
                Select Case SortMethod
                  Case 0 : sMethod = "Highest Rating"
                  Case 1 : sMethod = "Fastest Climbers"
                  Case 2 : sMethod = "Most Wins on Record"
                  Case 3 : sMethod = "Most Games Played"
                End Select
                Dim SortRank As UInt32 = pReader.ReadUInt32
                sTmp &= vbNewLine & " Ladder Type: " & LadderType &
                        vbNewLine & " League: " & League &
                        vbNewLine & " Sort Method: " & sMethod & " (" & SortMethod & ")" &
                        vbNewLine & " Starting Rank: " & SortRank
                Dim Entries As UInt32 = pReader.ReadUInt32
                sTmp &= vbNewLine & " Entries: " & Entries
                For I As Integer = 0 To Entries - 1
                  sTmp &= vbNewLine & "  Entry " & I & ":" &
                          vbNewLine & "   Wins: " & pReader.ReadUInt32 &
                          vbNewLine & "   Losses: " & pReader.ReadUInt32 &
                          vbNewLine & "   Disconnects: " & pReader.ReadUInt32 &
                          vbNewLine & "   Rating: " & pReader.ReadUInt32 &
                          vbNewLine & "   Rank: " & pReader.ReadUInt32 &
                          vbNewLine & "   Official Wins: " & pReader.ReadUInt32 &
                          vbNewLine & "   Official Losses: " & pReader.ReadUInt32 &
                          vbNewLine & "   Official Disconnects: " & pReader.ReadUInt32 &
                          vbNewLine & "   Official Rating: " & pReader.ReadUInt32 &
                          vbNewLine & "   Unknown: " & pReader.ReadUInt32 &
                          vbNewLine & "   Official Rank: " & pReader.ReadUInt32 &
                          vbNewLine & "   Unknown: " & pReader.ReadUInt32 &
                          vbNewLine & "   Unknown: " & pReader.ReadUInt32 &
                          vbNewLine & "   Highest Rating: " & pReader.ReadUInt32 &
                          vbNewLine & "   Unknown: " & pReader.ReadUInt32 &
                          vbNewLine & "   Season: " & pReader.ReadUInt32 &
                          vbNewLine & "   Last Game Time: " & UInt64ToDate(pReader.ReadUInt64) &
                          vbNewLine & "   Official Last Game Time: " & UInt64ToDate(pReader.ReadUInt64) &
                          vbNewLine & "   Name: " & pReader.ReadCString
                Next
                Return sHeader & sTmp
              Else
                Dim sTmp As String = String.Empty
                Dim LadderType As UInt32 = pReader.ReadUInt32
                Dim League As UInt32 = pReader.ReadUInt32
                Dim SortMethod As UInt32 = pReader.ReadUInt32
                Dim sMethod As String = String.Empty
                Select Case SortMethod
                  Case 0 : sMethod = "Highest Rating"
                  Case 1 : sMethod = "Fastest Climbers"
                  Case 2 : sMethod = "Most Wins on Record"
                  Case 3 : sMethod = "Most Games Played"
                End Select
                Dim SortRank As UInt32 = pReader.ReadUInt32
                sTmp &= vbNewLine & " Ladder Type: " & LadderType &
                        vbNewLine & " League: " & League &
                        vbNewLine & " Sort Method: " & sMethod & " (" & SortMethod & ")" &
                        vbNewLine & " Starting Rank: " & SortRank
                Dim Entries As UInt32 = pReader.ReadUInt32
                sTmp &= vbNewLine & " Ranks to List: " & Entries
                Return sHeader & sTmp
              End If
            Case BNCS_FINDLADDERUSER
              If c_Recv Then
                Dim Rank As UInt32 = pReader.ReadUInt32
                Return sHeader & vbNewLine &
                        "Rank: " & IIf(Rank = 4294967295, "Not Ranked", Rank)
              Else
                Dim sTmp As String = String.Empty
                Dim League As UInt32 = pReader.ReadUInt32
                Dim SortMethod As UInt32 = pReader.ReadUInt32
                Dim sMethod As String = String.Empty
                Select Case SortMethod
                  Case 0 : sMethod = "Highest Rating"
                  Case 1 : sMethod = "Fastest Climbers"
                  Case 2 : sMethod = "Most Wins on Record"
                  Case 3 : sMethod = "Most Games Played"
                End Select
                sTmp &= vbNewLine & " League: " & League &
                        vbNewLine & " Sort Method: " & sMethod & " (" & SortMethod & ")"
                sTmp &= vbNewLine & " Username: " & pReader.ReadCString
                Return sHeader & sTmp
              End If
            Case BNCS_CDKEY
              If c_Recv Then
                Dim lRet As UInt32 = pReader.ReadUInt32
                Select Case lRet
                  Case 1 : Return sHeader & vbNewLine & " Result: OK"
                  Case 2 : Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_INVALID
                  Case 3 : Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_WRONGPRODUCT
                  Case 4 : Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_BANNED
                  Case 5
                    Dim sOwner As String = pReader.ReadCString
                    If String.IsNullOrEmpty(sOwner) Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_INUSE
                    ElseIf sOwner = "TOO MANY SPAWNS" Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_TOOMANYSPAWNS
                    ElseIf sOwner = "NO SPAWNING" Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_NOSPAWNING
                    Else
                      Return sHeader & vbNewLine & " Result: " & ResString(My.Resources.CDKEY_INUSEBY, sOwner)
                    End If
                  Case Else : Return sHeader & vbNewLine & " Result: " & ResString(My.Resources.CDKEY_FAIL, PadHex(lRet, 8))
                End Select
              Else
                Return sHeader & vbNewLine &
                        " Spawn: " & pReader.ReadBoolean & vbNewLine &
                        " CD Key: " & pReader.ReadCString & vbNewLine &
                        " Username: " & pReader.ReadCString
              End If
            Case BNCS_CHANGEPASSWORD
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Result: " & IIf(pReader.ReadByte = 1, "Success", "Failure")
              Else
                Return sHeader & vbNewLine &
                        " Client Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Server Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Old Password: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        " New Password: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        " Username: " & pReader.ReadCString
              End If
            Case BNCS_CHECKDATAFILE
              If c_Recv Then
                Dim lRet As UInt32 = pReader.ReadUInt32
                Select Case lRet
                  Case 0 : Return sHeader & vbNewLine & " Result: Rejected"
                  Case 1 : Return sHeader & vbNewLine & " Result: Approved"
                  Case 2 : Return sHeader & vbNewLine & " Result: Ladder Approved"
                  Case Else : Return sHeader & vbNewLine & " Result: 0x" & PadHex(lRet, 8)
                End Select
              Else
                Return sHeader & vbNewLine &
                        " Checksum: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        " File Name: " & pReader.ReadCString
              End If
            Case BNCS_GETFILETIME
              If c_Recv Then
                Return sHeader & vbNewLine &
                      " Request ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                      " Unknown: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                      " File Time: " & UInt64ToDate(pReader.ReadUInt64) & vbNewLine &
                      " File Name: " & pReader.ReadCString
              Else
                Return sHeader & vbNewLine &
                      " Request ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                      " Unknown: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                      " File Name: " & pReader.ReadCString
              End If
            Case BNCS_QUERYREALMS
              If c_Recv Then
                Dim Unknown As UInt32 = pReader.ReadUInt32
                Dim RealmCount As UInt32 = pReader.ReadUInt32
                Dim RealmUnknowns(RealmCount - 1) As UInt32
                Dim RealmTitles(RealmCount - 1) As String
                Dim RealmDescriptions(RealmCount - 1) As String
                Dim sTmp As String = String.Empty
                For I As Integer = 0 To RealmCount - 1
                  sTmp &= vbNewLine & "  Realm " & I & ": " &
                          vbNewLine & "   Unknown: 0x" & PadHex(pReader.ReadUInt32, 8) &
                          vbNewLine & "   Title: " & pReader.ReadCString &
                          vbNewLine & "   Description: " & pReader.ReadCString
                Next
                Return sHeader & vbNewLine &
                        " Unknown: 0x" & PadHex(Unknown, 8) & vbNewLine &
                        " Realm Count: " & RealmCount & sTmp
              Else
                Return sHeader & vbNewLine &
                        "Unknown: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        "Unknown: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        "Unknown: " & pReader.ReadCString
              End If
            Case BNCS_PROFILE
              If c_Recv Then
                Dim Cookie As UInt32 = pReader.ReadUInt32
                Dim Success As Byte = pReader.ReadByte
                If Success = 0 Then
                  Return sHeader & vbNewLine &
                          " Cookie: 0x" & PadHex(Cookie, 8) & vbNewLine &
                          " Result: Success" & vbNewLine &
                          " Description: " & pReader.ReadCString & vbNewLine &
                          " Location: " & pReader.ReadCString & vbNewLine &
                          " Clan Tag: " & pReader.ReadDWORDString
                Else
                  Return sHeader & vbNewLine &
                          " Cookie: 0x" & PadHex(Cookie, 8) & vbNewLine &
                          " Result: Failure"
                End If
              Else
                Return sHeader & vbNewLine &
                        " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Account: " & pReader.ReadCString
              End If
            Case BNCS_CDKEY2
              If c_Recv Then
                Dim lRet As UInt32 = pReader.ReadUInt32
                Select Case lRet
                  Case 1 : Return sHeader & vbNewLine & " Result: OK"
                  Case 2 : Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_INVALID
                  Case 3 : Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_WRONGPRODUCT
                  Case 4 : Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_BANNED
                  Case 5
                    Dim sOwner As String = pReader.ReadCString
                    If String.IsNullOrEmpty(sOwner) Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_INUSE
                    ElseIf sOwner = "TOO MANY SPAWNS" Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_TOOMANYSPAWNS
                    ElseIf sOwner = "NO SPAWNING" Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_NOSPAWNING
                    Else
                      Return sHeader & vbNewLine & " Result: " & ResString(My.Resources.CDKEY_INUSEBY, sOwner)
                    End If
                  Case Else : Return sHeader & vbNewLine & " Result: " & ResString(My.Resources.CDKEY_FAIL, PadHex(lRet, 8))
                End Select
              Else
                Return sHeader & vbNewLine &
                        "Spawn: " & pReader.ReadBoolean & vbNewLine &
                        "Key Length: " & pReader.ReadUInt32 & vbNewLine &
                        "Key Product: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        "Key Public: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        "Server Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        "Client Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        "Key Hash: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        "Username: " & pReader.ReadCString
              End If
            Case BNCS_LOGONRESPONSE2
              If c_Recv Then
                Dim Ret As UInt32 = pReader.ReadUInt32
                Select Case Ret
                  Case 0 : Return sHeader & vbNewLine & " Result: Success"
                  Case 1 : Return sHeader & vbNewLine & " Result: " & My.Resources.ERR_BADACCOUNT
                  Case 2 : Return sHeader & vbNewLine & " Result: " & My.Resources.ERR_BADPASS
                  Case 6 : Return sHeader & vbNewLine & " Result: " & ResString(My.Resources.ERR_ACCOUNTCLOSED, pReader.ReadCString)
                  Case Else : Return sHeader & vbNewLine & " Result: " & My.Resources.LOGONRESPONSE_UNKNOWN
                End Select
              Else
                Return sHeader & vbNewLine &
                        "Client Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        "Server Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        "Password: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        "Username: " & pReader.ReadCString
              End If
            Case BNCS_CHECKDATAFILE2
              If c_Recv Then
                Dim lRet As UInt32 = pReader.ReadUInt32
                Select Case lRet
                  Case 0 : Return sHeader & vbNewLine & " Result: Rejected"
                  Case 1 : Return sHeader & vbNewLine & " Result: Approved"
                  Case 2 : Return sHeader & vbNewLine & " Result: Ladder Approved"
                  Case Else : Return sHeader & vbNewLine & " Result: 0x" & PadHex(lRet, 8)
                End Select
              Else
                Return sHeader & vbNewLine &
                        " Checksum: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        " File Name: " & pReader.ReadCString
              End If
            Case BNCS_CREATEACCOUNT2
              If c_Recv Then
                Dim lRet As UInt32 = pReader.ReadUInt32
                Dim sSuggest As String = pReader.ReadCString
                Select Case lRet
                  Case 0 : Return sHeader & vbNewLine & " Result: " & My.Resources.INFO_CREATED
                  Case 2 : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_INVALID & IIf(Not String.IsNullOrEmpty(sSuggest), ResString(My.Resources.CREATE_SUGGEST, sSuggest), String.Empty)
                  Case 3 : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_BANNED & IIf(Not String.IsNullOrEmpty(sSuggest), ResString(My.Resources.CREATE_SUGGEST, sSuggest), String.Empty)
                  Case 4 : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_EXISTS & IIf(Not String.IsNullOrEmpty(sSuggest), ResString(My.Resources.CREATE_SUGGEST, sSuggest), String.Empty)
                  Case 6 : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_MORECHARS & IIf(Not String.IsNullOrEmpty(sSuggest), ResString(My.Resources.CREATE_SUGGEST, sSuggest), String.Empty)
                  Case Else : Return sHeader & vbNewLine & " Result: " & ResString(My.Resources.CREATE_FAIL, Hex(lRet)) & IIf(Not String.IsNullOrEmpty(sSuggest), ResString(My.Resources.CREATE_SUGGEST, sSuggest), String.Empty)
                End Select
              Else
                Return sHeader & vbNewLine &
                        " Password: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        " Username: " & pReader.ReadCString
              End If
            Case BNCS_LOGONREALMEX
              If c_Recv Then
                If c_Data.Length > 8 Then
                  Return sHeader & vbNewLine &
                          " Client Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " MCP Status: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " BNCS IP: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " UDP Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " MCP IP: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " Port: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " Null: 0x" & PadHex(pReader.ReadUInt16, 4) & vbNewLine &
                          " Key Product: 0x" & PadHex(pReader.ReadUInt16, 4) & vbNewLine &
                          " Key Public: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " Gateway ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " Product ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " Platform ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " BNCS IP: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " Locale: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " Hash: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                          " Unique Name: " & pReader.ReadCString
                Else
                  Return sHeader & vbNewLine &
                          " Client Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " MCP Status: 0x" & PadHex(pReader.ReadUInt32, 8)
                End If
              Else
                Return sHeader & vbNewLine &
                        " Client Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Password: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        " Realm Title: " & pReader.ReadCString
              End If
            Case BNCS_STARTVERSIONING2
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " File Time: " & UInt64ToDate(pReader.ReadUInt64) & vbNewLine &
                        " File Name: " & pReader.ReadCString & vbNewLine &
                        " Request: " & pReader.ReadCString
              End If
            Case BNCS_QUERYREALMS2
              If c_Recv Then
                Dim Unknown As UInt32 = pReader.ReadUInt32
                Dim RealmCount As UInt32 = pReader.ReadUInt32
                Dim RealmUnknowns(RealmCount - 1) As UInt32
                Dim RealmTitles(RealmCount - 1) As String
                Dim RealmDescriptions(RealmCount - 1) As String
                Dim sTmp As String = String.Empty
                For I As Integer = 0 To RealmCount - 1
                  sTmp &= vbNewLine & "  Realm " & I & ": " &
                          vbNewLine & "   Unknown: 0x" & PadHex(pReader.ReadUInt32, 8) &
                          vbNewLine & "   Title: " & pReader.ReadCString &
                          vbNewLine & "   Description: " & pReader.ReadCString
                Next
                Return sHeader & vbNewLine &
                        " Unknown: 0x" & PadHex(Unknown, 8) & vbNewLine &
                        " Realm Count: " & RealmCount & sTmp
              Else
                Return sHeader
              End If
            Case BNCS_QUERYADURL
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Ad ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " URL: " & pReader.ReadCString
              Else
                Return sHeader & vbNewLine &
                        " Ad ID: 0x" & PadHex(pReader.ReadUInt32, 8)
              End If
            Case BNCS_WARCRAFTUNKNOWN
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Unknown: 0x" & PadHex(pReader.ReadUInt32, 8)
              Else
                Return sHeader
              End If
            Case BNCS_WARCRAFTGENERAL
              If c_Recv Then
                Dim sRecords As String = String.Empty
                Dim CommandID As Byte = pReader.ReadByte
                sRecords &= vbNewLine & " Command ID: 0x" & PadHex(CommandID, 2)
                Select Case CommandID
                  Case &H0
                    sRecords &= " (WID_GAMESEARCH)"
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
                    Dim Status As UInt32 = pReader.ReadUInt32
                    Select Case Status
                      Case &H0 : sRecords &= vbNewLine & "  Status: Search Started"
                      Case &H4 : sRecords &= vbNewLine & "  Status: Banned CD-Key"
                      Case Else : sRecords &= vbNewLine & "  Status: Unknown (0x" & PadHex(Status, 8) & ")"
                    End Select
                  Case &H2
                    sRecords &= " (WID_MAPLIST)"
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
                    Dim Responses As Byte = pReader.ReadByte
                    sRecords &= vbNewLine & "  Number of responses: " & Responses
                    For I As Integer = 0 To Responses - 1
                      sRecords &= vbNewLine & "   Response " & I & ":" &
                                  vbNewLine & "    ID: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & "    Checksum: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & "    Decompressed Length: " & pReader.ReadUInt16
                      Dim CompLength As UInt16 = pReader.ReadUInt16
                      sRecords &= vbNewLine & "    Compressed Length: " & CompLength &
                                  vbNewLine & "    Compressed Data: " & BitConverter.ToString(pReader.ReadByteArray(CompLength))
                    Next
                    sRecords &= "  Remaining Packets: " & pReader.ReadByte
                  Case &H3
                    sRecords &= " (WID_CANCELSEARCH)"
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
                  Case &H4
                    sRecords &= " (WID_USERRECORD)"
                    Dim Cookie As UInt32 = pReader.ReadUInt32
                    Dim IconID As String = pReader.ReadDWORDString
                    Dim LadderRecords As Byte = pReader.ReadByte
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(Cookie, 8) &
                                vbNewLine & "  Icon ID: " & IconID &
                                vbNewLine & "  Ladder Records: " & LadderRecords
                    For I As Integer = 0 To LadderRecords - 1
                      sRecords &= vbNewLine & "   Ladder Record " & I & ":" &
                                  vbNewLine & "    Type: " & pReader.ReadDWORDString &
                                  vbNewLine & "    Wins: " & pReader.ReadUInt16 &
                                  vbNewLine & "    Losses: " & pReader.ReadUInt16 &
                                  vbNewLine & "    Level: " & pReader.ReadByte &
                                  vbNewLine & "    Unknown: " & pReader.ReadByte &
                                  vbNewLine & "    Experience: " & pReader.ReadUInt16 &
                                  vbNewLine & "    Rank: " & pReader.ReadUInt32
                    Next
                    Dim RaceRecords As Byte = pReader.ReadByte
                    sRecords &= vbNewLine & "  Race Records: " & RaceRecords
                    For I As Integer = 0 To RaceRecords - 1
                      sRecords &= vbNewLine & "   Race Record " & I & ":" &
                                  vbNewLine & "    Wins: " & pReader.ReadUInt16 &
                                  vbNewLine & "    Losses: " & pReader.ReadUInt16
                    Next
                    Dim TeamRecords As Byte = pReader.ReadByte
                    sRecords &= vbNewLine & "  Team Records: " & TeamRecords
                    For I As Integer = 0 To TeamRecords - 1
                      sRecords &= vbNewLine & "   Team Record " & I & ":" &
                                  vbNewLine & "    Type: " & pReader.ReadDWORDString &
                                  vbNewLine & "    Wins: " & pReader.ReadUInt16 &
                                  vbNewLine & "    Losses: " & pReader.ReadUInt16 &
                                  vbNewLine & "    Level: " & pReader.ReadByte &
                                  vbNewLine & "    Unknown: " & pReader.ReadByte &
                                  vbNewLine & "    Experience: " & pReader.ReadUInt16 &
                                  vbNewLine & "    Rank: " & pReader.ReadUInt32 &
                                  vbNewLine & "    Last Game: " & UInt64ToDate(pReader.ReadUInt64)
                      Dim Partners As Byte = pReader.ReadByte
                      sRecords &= vbNewLine & "    Partners: " & pReader.ReadByte
                      For J As Int16 = 0 To Partners - 1
                        sRecords &= vbNewLine & "     Partner " & J & ": " & pReader.ReadCString
                      Next J
                    Next I
                  Case &H7
                    sRecords &= " (WID_TOURNAMENT)"
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
                    Dim Status As Byte = pReader.ReadByte
                    Select Case Status
                      Case &H0 : sRecords &= vbNewLine & "  Status: No Tournament"
                      Case &H1 : sRecords &= vbNewLine & "  Status: Starting Soon"
                      Case &H2 : sRecords &= vbNewLine & "  Status: Ending Soon"
                      Case &H3 : sRecords &= vbNewLine & "  Status: Started"
                      Case &H4 : sRecords &= vbNewLine & "  Status: Last Call"
                    End Select
                    sRecords &= vbNewLine & "  Last Status Update: " & UInt64ToDate(pReader.ReadUInt64).ToString("g") &
                                vbNewLine & "  Unknown: 0x" & PadHex(pReader.ReadUInt16, 4) &
                                vbNewLine & "  Unknown: 0x" & PadHex(pReader.ReadUInt16, 4) &
                                vbNewLine & "  Wins: " & pReader.ReadByte &
                                vbNewLine & "  Losses: " & pReader.ReadByte &
                                vbNewLine & "  Draws: " & pReader.ReadByte &
                                vbNewLine & "  Unknown: 0x" & PadHex(pReader.ReadByte, 2) &
                                vbNewLine & "  Unknown: 0x" & PadHex(pReader.ReadByte, 2) &
                                vbNewLine & "  Unknown: 0x" & PadHex(pReader.ReadByte, 2) &
                                vbNewLine & "  Unknown: 0x" & PadHex(pReader.ReadByte, 2)
                  Case &H8
                    sRecords &= " (WID_CLANRECORD)"
                    Dim Cookie As UInt32 = pReader.ReadUInt32
                    Dim LadderRecords As Byte = pReader.ReadByte
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(Cookie, 8) &
                                vbNewLine & "  Ladder Records: " & LadderRecords
                    For I As Integer = 0 To LadderRecords - 1
                      sRecords &= vbNewLine & "   Ladder Record " & I & ":" &
                                  vbNewLine & "    Type: " & pReader.ReadDWORDString &
                                  vbNewLine & "    Wins: " & pReader.ReadUInt32 &
                                  vbNewLine & "    Losses: " & pReader.ReadUInt32 &
                                  vbNewLine & "    Level: " & pReader.ReadByte &
                                  vbNewLine & "    Unknown: " & pReader.ReadByte &
                                  vbNewLine & "    Experience: " & pReader.ReadUInt32 &
                                  vbNewLine & "    Rank: " & pReader.ReadUInt32
                    Next
                    Dim RaceRecords As Byte = pReader.ReadByte
                    sRecords &= vbNewLine & "  Race Records: " & RaceRecords
                    For I As Integer = 0 To RaceRecords - 1
                      sRecords &= vbNewLine & "   Race Record " & I & ":" &
                                  vbNewLine & "    Wins: " & pReader.ReadUInt32 &
                                  vbNewLine & "    Losses: " & pReader.ReadUInt32
                    Next
                  Case &H9
                    sRecords &= " (WID_ICONLIST)"
                    Dim Cookie As UInt32 = pReader.ReadUInt32
                    Dim IconID As String = pReader.ReadDWORDString
                    Dim Teirs As Byte = pReader.ReadByte
                    Dim Count As Byte = pReader.ReadByte
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(Cookie, 8) &
                                vbNewLine & "  Icon ID: " & IconID &
                                vbNewLine & "  Teirs: " & Teirs &
                                vbNewLine & "  Count: " & Count
                    For I As Integer = 0 To Count - 1
                      sRecords &= vbNewLine & "   Icon " & I & ":" &
                                  vbNewLine & "    Icon " & pReader.ReadDWORDString &
                                  vbNewLine & "    Unit ID: " & pReader.ReadDWORDString &
                                  vbNewLine & "    Race: " & pReader.ReadByte &
                                  vbNewLine & "    Required Wins: " & pReader.ReadUInt16 &
                                  vbNewLine & "    Enabled: " & pReader.ReadByte
                    Next
                  Case Else
                    sRecords &= " (WID_UNKNOWN)"
                End Select
                Return sHeader & sRecords
              Else
                Dim sRecords As String = String.Empty
                Dim CommandID As Byte = pReader.ReadByte
                sRecords &= vbNewLine & " Command ID: 0x" & PadHex(CommandID, 2)
                Select Case CommandID
                  Case &H0
                    sRecords &= " (WID_GAMESEARCH)"
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                vbNewLine & "  Unknown: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                vbNewLine & "  Unknown: 0x" & PadHex(pReader.ReadByte, 2)
                    Dim GameType As Byte = pReader.ReadByte
                    Select Case GameType
                      Case &H0 : sRecords &= vbNewLine & "  Game Type: 1vs1"
                      Case &H1 : sRecords &= vbNewLine & "  Game Type: 2vs2"
                      Case &H2 : sRecords &= vbNewLine & "  Game Type: 3vs3"
                      Case &H3 : sRecords &= vbNewLine & "  Game Type: 4vs4"
                      Case &H4 : sRecords &= vbNewLine & "  Game Type: Free for All"
                      Case Else : sRecords &= vbNewLine & "  Game Type: Unknown (0x" & PadHex(GameType, 2) & ")"
                    End Select
                    sRecords &= vbNewLine & "  Enabled Maps: 0x" & PadHex(pReader.ReadUInt16, 4) &
                                vbNewLine & "  Unknown: 0x" & PadHex(pReader.ReadUInt16, 4) &
                                vbNewLine & "  Unknown: 0x" & PadHex(pReader.ReadByte, 2) &
                                vbNewLine & "  Tick Count: " & pReader.ReadUInt32
                    Dim Race As UInt32 = pReader.ReadUInt32
                    Select Case Race
                      Case &H1 : sRecords &= vbNewLine & "  Race: Human"
                      Case &H2 : sRecords &= vbNewLine & "  Race: Orc"
                      Case &H4 : sRecords &= vbNewLine & "  Race: Night Elf"
                      Case &H8 : sRecords &= vbNewLine & "  Race: Undead"
                      Case &H20 : sRecords &= vbNewLine & "  Race: Random"
                      Case Else : sRecords &= vbNewLine & "  Race: Unknown (0x" & PadHex(Race, 2) & ")"
                    End Select
                  Case &H2
                    sRecords &= " (WID_MAPLIST)"
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
                    Dim Requests As Byte = pReader.ReadByte
                    sRecords &= vbNewLine & "  Requests: " & Requests
                    For I As Integer = 0 To Requests - 1
                      sRecords &= vbNewLine & "   Request " & I & ": 0x" & PadHex(pReader.ReadUInt32, 8)
                    Next
                  Case &H3
                    sRecords &= " (WID_CANCELSEARCH)"
                  Case &H4
                    sRecords &= " (WID_USERRECORD)"
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                vbNewLine & "  Account: " & pReader.ReadCString &
                                vbNewLine & "  Product ID: " & pReader.ReadDWORDString
                  Case &H7
                    sRecords &= " (WID_TOURNAMENT)" & vbNewLine &
                                "  Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
                  Case &H8
                    sRecords &= " (WID_CLANRECORD)"
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                vbNewLine & "  Clan Tag: " & pReader.ReadDWORDString &
                                vbNewLine & "  Product ID: " & pReader.ReadDWORDString
                  Case &H9
                    sRecords &= " (WID_ICONLIST)"
                    sRecords &= vbNewLine & "  Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
                  Case &HA
                    sRecords &= " (WID_SETICON)"
                    sRecords &= vbNewLine & "  Icon: " & pReader.ReadDWORDString
                End Select
                Return sHeader & sRecords
              End If
            Case BNCS_NETGAMEPORT
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " Port: " & pReader.ReadUInt16
              End If
            Case BNCS_NEWS_INFO
              If c_Recv Then
                Dim sTmp As String = String.Empty
                Dim Entries As Byte = pReader.ReadByte
                Dim LastLogon As UInt64 = pReader.ReadInt64
                Dim OldestNews As UInt64 = pReader.ReadInt64
                Dim NewestNews As UInt64 = pReader.ReadInt64
                sTmp &= vbNewLine & " Entries: " & Entries &
                        vbNewLine & " Last Logon: " & DateAdd(DateInterval.Second, LastLogon, DateSerial(1970, 1, 1)).ToString("g") &
                        vbNewLine & " Oldest News: " & DateAdd(DateInterval.Second, OldestNews, DateSerial(1970, 1, 1)).ToString("g") &
                        vbNewLine & " Newest News: " & DateAdd(DateInterval.Second, NewestNews, DateSerial(1970, 1, 1)).ToString("g")
                For I As Byte = 0 To Entries - 1
                  Dim TimeStamp As UInt64 = pReader.ReadUInt64
                  Dim News As String = pReader.ReadCString
                  If TimeStamp = 0 Then
                    sTmp &= vbNewLine & " Message of the Day: " & News
                  Else
                    sTmp &= vbNewLine & " Entry for " & DateAdd(DateInterval.Second, TimeStamp, DateSerial(1970, 1, 1)).ToString("g") & ": " & News
                  End If
                Next I
                Return sHeader & sTmp
              Else
                Return sHeader & vbNewLine & " Time Stamp: " & pReader.ReadUInt32
              End If
            Case BNCS_OPTIONALWORK
              If c_Recv Then
                Return sHeader & vbNewLine & " Work DLL Name: " & pReader.ReadCString
              Else
                Return sHeader
              End If
            Case BNCS_EXTRAWORK
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        "Game Type: " & pReader.ReadUInt16 & vbNewLine &
                        "Length: " & pReader.ReadUInt16 & vbNewLine &
                        "Data: " & pReader.ReadCString
              End If
            Case BNCS_REQUIREDWORK
              If c_Recv Then
                Return sHeader & vbNewLine & " Work DLL Name: " & pReader.ReadCString
              Else
                Return sHeader
              End If
            Case BNCS_ADDLEAGUE
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Flags: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " Unknown: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " League Name: " & pReader.ReadCString & vbNewLine &
                        " Penalty: " & pReader.ReadCString & vbNewLine &
                        " League URL: " & pReader.ReadCString & vbNewLine &
                        " League Tag: " & pReader.ReadCString & vbNewLine &
                        " Unknown: " & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Game Type: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " League ID: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " Penalty: " & PadHex(pReader.ReadUInt16, 4) & vbNewLine &
                        " Penalty: " & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Game Class: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " Unknown: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " Unknown: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " Unknown: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " Unknown: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " Unknown: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " Unknown: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " Teams: " & pReader.ReadByte & vbNewLine &
                        " Unknown: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " Requirements: " & PadHex(pReader.ReadByte, 2) & vbNewLine &
                        " Resources: " & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " End Result: " & PadHex(pReader.ReadUInt32, 8)
              Else
                Return sHeader
              End If
            Case BNCS_AUTH_INFO
              If c_Recv Then
                If pReader.Length < 150 Then
                  Return sHeader & vbNewLine &
                          " Logon Type: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " Server Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " UDP Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " MPQ FileTime: " & UInt64ToDate(pReader.ReadUInt64).ToString("g") & vbNewLine &
                          " MPQ FileName: " & pReader.ReadCString & vbNewLine &
                          " Request: " & BitConverter.ToString(pReader.ReadNullTerminatedByteArray)
                Else
                  Return sHeader & vbNewLine &
                          " Logon Type: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " Server Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " UDP Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                          " MPQ FileTime: " & UInt64ToDate(pReader.ReadUInt64).ToString("g") & vbNewLine &
                          " MPQ FileName: " & pReader.ReadCString & vbNewLine &
                          " Request: " & BitConverter.ToString(pReader.ReadNullTerminatedByteArray) & vbNewLine &
                          " Signature: " & BitConverter.ToString(pReader.ReadByteArray(128))
                End If
              Else
                Return sHeader & vbNewLine &
                        " Protocol ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Platform ID: " & pReader.ReadDWORDString & vbNewLine &
                        " Product ID: " & pReader.ReadDWORDString & vbNewLine &
                        " VerByte: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Language: " & pReader.ReadDWORDString & vbNewLine &
                        " Local IP: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Timezone Bias: " & pReader.ReadUInt32 & vbNewLine &
                        " Locale ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Language ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Country Abbreviation: " & pReader.ReadCString & vbNewLine &
                        " Country: " & pReader.ReadCString
              End If
            Case BNCS_AUTH_CHECK
              If c_Recv Then
                Dim lRet As UInt32 = pReader.ReadUInt32
                Select Case lRet
                  Case &H0 : Return sHeader & vbNewLine & " Result: OK"
                  Case &H100 : Return sHeader & vbNewLine & " Result: " & My.Resources.VERSION_UPGRADE
                  Case &H101 : Return sHeader & vbNewLine & " Result: " & My.Resources.VERSION_FAIL
                  Case &H102 : Return sHeader & vbNewLine & " Result: " & My.Resources.VERSION_DOWNGRADE
                  Case &H200 : Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_INVALID
                  Case &H201
                    Dim sOwner As String = pReader.ReadCString
                    If String.IsNullOrEmpty(sOwner) Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_INUSE
                    ElseIf sOwner = "TOO MANY SPAWNS" Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_TOOMANYSPAWNS
                    ElseIf sOwner = "NO SPAWNING" Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_NOSPAWNING
                    Else
                      Return sHeader & vbNewLine & " Result: " & ResString(My.Resources.CDKEY_INUSEBY, sOwner)
                    End If
                  Case &H202 : Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_BANNED
                  Case &H203 : Return sHeader & vbNewLine & " Result: " & My.Resources.CDKEY_WRONGPRODUCT
                  Case &H210 : Return sHeader & vbNewLine & " Result: " & My.Resources.EXPKEY_INVALID
                  Case &H211
                    Dim sOwner As String = pReader.ReadCString
                    If String.IsNullOrEmpty(sOwner) Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.EXPKEY_INUSE
                    ElseIf sOwner = "TOO MANY SPAWNS" Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.EXPKEY_TOOMANYSPAWNS
                    ElseIf sOwner = "NO SPAWNING" Then
                      Return sHeader & vbNewLine & " Result: " & My.Resources.EXPKEY_NOSPAWNING
                    Else
                      Return sHeader & vbNewLine & " Result: " & ResString(My.Resources.EXPKEY_INUSEBY, sOwner)
                    End If
                  Case &H212 : Return sHeader & vbNewLine & " Result: " & My.Resources.EXPKEY_BANNED
                  Case &H213 : Return sHeader & vbNewLine & " Result: " & My.Resources.EXPKEY_WRONGPRODUCT
                  Case Else : Return sHeader & vbNewLine & " Result: " & ResString(My.Resources.ERR_AUTH_UNKNOWN, PadHex(lRet, 8))
                End Select
              Else
                Dim sTmp As String = vbNewLine &
                        " Client Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " EXE Version: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " EXE Hash: 0x" & PadHex(pReader.ReadUInt32, 8)
                Dim KeyCount As UInt32 = pReader.ReadUInt32
                sTmp &= vbNewLine & " CDKeys: " & KeyCount &
                        vbNewLine & " Spawn: " & pReader.ReadBoolean
                For I As Integer = 0 To KeyCount - 1
                  sTmp &= vbNewLine & "  Key " & I & ":" &
                          vbNewLine & "   Length: " & pReader.ReadUInt32 &
                          vbNewLine & "   Key Product: 0x" & PadHex(pReader.ReadUInt32, 8) &
                          vbNewLine & "   Key Public: 0x" & PadHex(pReader.ReadUInt32, 8) &
                          vbNewLine & "   Unknown: 0x" & PadHex(pReader.ReadUInt32, 8) &
                          vbNewLine & "   Hash: " & BitConverter.ToString(pReader.ReadByteArray(20))
                Next
                sTmp &= vbNewLine & " EXE Information: " & pReader.ReadCString &
                        vbNewLine & " CDKey Owner: " & pReader.ReadCString
                Return sHeader & sTmp
              End If
            Case BNCS_AUTH_ACCOUNTCREATE
              If c_Recv Then
                Dim Status As UInt32 = pReader.ReadUInt32
                Select Case Status
                  Case &H0 : Return sHeader & vbNewLine & " Result: " & My.Resources.INFO_CREATED
                  Case &H4 : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_EXISTS
                  Case &H7 : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_SHORT
                  Case &H8 : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_ILLEGAL
                  Case &H9 : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_BANNED
                  Case &HA : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_MORECHARS
                  Case &HB : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_ADJACENTPUNCTUATION
                  Case &HC : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_TOOMUCHPUNCTUATION
                  Case Else : Return sHeader & vbNewLine & " Result: " & My.Resources.CREATE_EXISTS
                End Select
              Else
                Return sHeader & vbNewLine &
                        " Salt: " & BitConverter.ToString(pReader.ReadByteArray(&H20)) & vbNewLine &
                        " Verifier: " & BitConverter.ToString(pReader.ReadByteArray(&H20)) & vbNewLine &
                        " Username: " & pReader.ReadCString
              End If
            Case BNCS_AUTH_ACCOUNTLOGON
              If c_Recv Then
                Dim Status As UInt32 = pReader.ReadUInt32
                Select Case Status
                  Case &H0
                    Return sHeader & vbNewLine &
                            " Result: Logged in" & vbNewLine &
                            " Salt: " & BitConverter.ToString(pReader.ReadByteArray(&H20)) & vbNewLine &
                            " Server Key: " & BitConverter.ToString(pReader.ReadByteArray(&H20))
                  Case &H1 : Return sHeader & vbNewLine & " Result: " & My.Resources.ERR_BADACCOUNT
                  Case &H5 : Return sHeader & vbNewLine & " Result: " & My.Resources.LOGON_UPGRADE
                  Case Else : Return sHeader & vbNewLine & " Result: " & ResString(My.Resources.LOGON_FAIL, PadHex(Status, 8))
                End Select
              Else
                Return sHeader & vbNewLine &
                        " Client Key: " & BitConverter.ToString(pReader.ReadByteArray(&H20)) & vbNewLine &
                        " Username: " & pReader.ReadCString
              End If
            Case BNCS_AUTH_ACCOUNTLOGONPROOF
              If c_Recv Then
                Dim Status As UInt32 = pReader.ReadUInt32
                Dim M2() As Byte = pReader.ReadByteArray(20)
                Dim Info As String = pReader.ReadCString
                Select Case Status
                  Case &H0
                    Return sHeader & vbNewLine &
                            " Result: Logged in" & vbNewLine &
                            " Server Proof: " & BitConverter.ToString(M2) & vbNewLine &
                            " Info: " & Info
                  Case &H2
                    Return sHeader & vbNewLine &
                            " Result: " & My.Resources.ERR_BADPASS & vbNewLine &
                            " Server Proof: " & BitConverter.ToString(M2) & vbNewLine &
                            " Info: " & Info
                  Case &HE
                    Return sHeader & vbNewLine &
                            " Result: " & My.Resources.LOGON_EMAIL & vbNewLine &
                            " Server Proof: " & BitConverter.ToString(M2) & vbNewLine &
                            " Info: " & Info
                  Case &HF
                    Return sHeader & vbNewLine &
                            " Result: Custom Error" & vbNewLine &
                            " Server Proof: " & BitConverter.ToString(M2) & vbNewLine &
                            " Info: " & Info
                  Case &H48
                    Return sHeader & vbNewLine &
                            " Result: Logged in (No Salt)" & vbNewLine &
                            " Server Proof: " & BitConverter.ToString(M2) & vbNewLine &
                            " Info: " & Info
                  Case Else
                    Return sHeader & vbNewLine &
                            " Result: Unknown (0x" & PadHex(Status, 8) & ")" & vbNewLine &
                            " Server Proof: " & BitConverter.ToString(M2) & vbNewLine &
                            " Info: " & Info
                End Select
              Else
                Return sHeader & vbNewLine & " Client Password Proof: " & BitConverter.ToString(pReader.ReadByteArray(20))
              End If
            Case BNCS_AUTH_ACCOUNTCHANGE
              If c_Recv Then
                Dim Status As UInt32 = pReader.ReadUInt32
                Select Case Status
                  Case &H0
                    Return sHeader & vbNewLine &
                            " Result: Accepted; requires proof" & vbNewLine &
                            " Salt: " & BitConverter.ToString(pReader.ReadByteArray(&H20)) & vbNewLine &
                            " Server Key: " & BitConverter.ToString(pReader.ReadByteArray(&H20))
                  Case &H1 : Return sHeader & vbNewLine & " Result: " & My.Resources.ERR_BADACCOUNT
                  Case &H5 : Return sHeader & vbNewLine & " Result: " & My.Resources.LOGON_UPGRADE
                  Case Else : Return sHeader & vbNewLine & " Result: " & My.Resources.PASSWORD_CHANGE_FAIL
                End Select
              Else
                Return sHeader & vbNewLine &
                        " Client Key: " & BitConverter.ToString(pReader.ReadByteArray(&H20)) & vbNewLine &
                        " Username: " & pReader.ReadCString
              End If
            Case BNCS_AUTH_ACCOUNTCHANGEPROOF
              If c_Recv Then
                Dim Status As UInt32 = pReader.ReadUInt32
                Dim M2() As Byte = pReader.ReadByteArray(20)
                Select Case Status
                  Case &H0
                    Return sHeader & vbNewLine &
                            " Result: Password Changed" & vbNewLine &
                            " Server Proof: " & BitConverter.ToString(M2)
                  Case &H2
                    Return sHeader & vbNewLine &
                            " Result: " & My.Resources.ERR_BADPASS & vbNewLine &
                            " Server Proof: " & BitConverter.ToString(M2)
                  Case Else
                    Return sHeader & vbNewLine &
                            " Result: " & My.Resources.PASSWORD_CHANGE_FAIL & " (0x" & PadHex(Status, 8) & ")" & vbNewLine &
                            " Server Proof: " & BitConverter.ToString(M2)
                End Select
              Else
                Return sHeader & vbNewLine &
                        " Old Password Proof: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        " New Password Salt: " & BitConverter.ToString(pReader.ReadByteArray(&H20)) & vbNewLine &
                        " New Password Verifier: " & BitConverter.ToString(pReader.ReadByteArray(&H20))
              End If
            Case BNCS_AUTH_ACCOUNTUPGRADE
              If c_Recv Then
                Dim Status As UInt32 = pReader.ReadUInt32
                Dim Token As UInt32 = pReader.ReadUInt32
                Return sHeader & vbNewLine &
                        " Status: " & IIf(Status = 0, "Accepted", "Denied") & " (0x" & PadHex(Status, 8) & ")" & vbNewLine &
                        " Token: 0x" & PadHex(Token, 8)
              Else
                Return sHeader
              End If
            Case BNCS_AUTH_ACCOUNTUPGRADEPROOF
              If c_Recv Then
                Dim Status As UInt32 = pReader.ReadUInt32
                Dim M2() As Byte = pReader.ReadByteArray(20)
                Select Case Status
                  Case &H0
                    Return sHeader & vbNewLine &
                            " Result: Account Upgraded" & vbNewLine &
                            " Password Proof: " & BitConverter.ToString(M2)
                  Case &H2
                    Return sHeader & vbNewLine &
                            " Result: " & My.Resources.ERR_BADPASS & vbNewLine &
                            " Password Proof: " & BitConverter.ToString(M2)
                  Case Else
                    Return sHeader & vbNewLine &
                            " Result: " & My.Resources.UPGRADE_FAILED & " (0x" & PadHex(Status, 8) & ")" & vbNewLine &
                            " Password Proof: " & BitConverter.ToString(M2)
                End Select
              Else
                Return sHeader & vbNewLine &
                        " Client Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Old Password Hash: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        " New Password Salt: " & BitConverter.ToString(pReader.ReadByteArray(&H20)) & vbNewLine &
                        " New Password Verifier: " & BitConverter.ToString(pReader.ReadByteArray(&H20))
              End If
            Case BNCS_SETEMAIL
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine & " EMail Address: " & pReader.ReadCString
              End If
            Case BNCS_RESETPASSWORD
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " Account: " & pReader.ReadCString & vbNewLine &
                        " EMail Address: " & pReader.ReadCString
              End If
            Case BNCS_CHANGEEMAIL
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " Account: " & pReader.ReadCString & vbNewLine &
                        " Old EMail Address: " & pReader.ReadCString & vbNewLine &
                        " New EMail Address: " & pReader.ReadCString
              End If
            Case BNCS_SWITCHPRODUCT
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine & " Product ID: " & pReader.ReadDWORDString
              End If
            Case BNCS_REPORTCRASH
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine &
                        " Version: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Exception: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Unknown: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Unknown: 0x" & PadHex(pReader.ReadUInt32, 8)
              End If
            Case BNCS_WARDEN
              Return sHeader & vbNewLine & " Raw Data: " & BitConverter.ToString(pReader.ReadByteArray(pReader.Length - 4))
            Case BNCS_GAMEPLAYERSEARCH
              If c_Recv Then
                Dim bPlayers As Byte = pReader.ReadByte
                Dim sTmp As String = vbNewLine & " Players: " & bPlayers
                For I As Integer = 0 To bPlayers - 1
                  sTmp &= vbNewLine & "  Player " & I & ": " & pReader.ReadCString
                Next
                Return sHeader & sTmp
              Else
                Return sHeader
              End If
            Case BNCS_FRIENDSLIST
              If c_Recv Then
                Dim bFriends As Byte = pReader.ReadByte
                Dim sTmp As String = vbNewLine & " Friends: " & bFriends
                For I As Integer = 0 To bFriends - 1
                  Dim sAccount As String = pReader.ReadCString
                  Dim bStatus As Byte = pReader.ReadByte
                  Dim sStatus As String = String.Empty
                  If bStatus Or &H1 Then sStatus &= ", Mutual"
                  If bStatus Or &H2 Then sStatus &= ", DND"
                  If bStatus Or &H4 Then sStatus &= ", Away"
                  Do While sStatus.Substring(0, 2) = ", "
                    sStatus = sStatus.Substring(2)
                  Loop
                  Dim bLocation As Byte = pReader.ReadByte
                  Dim sProduct As String = pReader.ReadDWORDString
                  Dim sLocName As String = pReader.ReadCString
                  sTmp &= vbNewLine & "  Friend " & I & ":" &
                          vbNewLine & "   Account: " & sAccount &
                          vbNewLine & "   Status: " & sStatus &
                          vbNewLine & "   Location: " & LocationCodeToString(bLocation, sLocName) &
                          vbNewLine & "   Product: " & GameStringToName(sProduct)
                Next
                Return sHeader & sTmp
              Else
                Return sHeader
              End If
            Case BNCS_FRIENDSUPDATE
              If c_Recv Then
                Dim sTmp As String = vbNewLine & " Friend Index: " & pReader.ReadByte
                Dim bLocation As Byte = pReader.ReadByte
                Dim bStatus As Byte = pReader.ReadByte
                Dim sStatus As String = String.Empty
                If bStatus Or &H1 Then sStatus &= ", Mutual"
                If bStatus Or &H2 Then sStatus &= ", DND"
                If bStatus Or &H4 Then sStatus &= ", Away"
                Do While sStatus.Substring(0, 2) = ", "
                  sStatus = sStatus.Substring(2)
                Loop
                Dim sProduct As String = pReader.ReadDWORDString
                Dim sLocName As String = pReader.ReadCString
                sTmp &= vbNewLine & " Status: " & sStatus &
                        vbNewLine & " Location: " & LocationCodeToString(bLocation, sLocName) &
                        vbNewLine & " Product: " & GameStringToName(sProduct)
                Return sHeader & sTmp
              Else
                Return sHeader & vbNewLine & " Friend Index: " & pReader.ReadByte
              End If
            Case BNCS_FRIENDSADD
              If c_Recv Then
                Dim sAccount As String = pReader.ReadCString
                Dim bStatus As Byte = pReader.ReadByte
                Dim sStatus As String = String.Empty
                If bStatus Or &H1 Then sStatus &= ", Mutual"
                If bStatus Or &H2 Then sStatus &= ", DND"
                If bStatus Or &H4 Then sStatus &= ", Away"
                Do While sStatus.Substring(0, 2) = ", "
                  sStatus = sStatus.Substring(2)
                Loop
                Dim bLocation As Byte = pReader.ReadByte
                Dim sProduct As String = pReader.ReadDWORDString
                Dim sLocName As String = pReader.ReadCString
                Return sHeader & vbNewLine &
                        " Account: " & sAccount & vbNewLine &
                        " Status: " & sStatus & vbNewLine &
                        " Location: " & LocationCodeToString(bLocation, sLocName) & vbNewLine &
                        " Product: " & GameStringToName(sProduct)
              Else
                Return sHeader
              End If
            Case BNCS_FRIENDSREMOVE
              If c_Recv Then
                Return sHeader & vbNewLine & " Friend Index: " & pReader.ReadByte
              Else
                Return sHeader
              End If
            Case BNCS_FRIENDSPOSITION
              If c_Recv Then
                Return sHeader & vbNewLine &
                        " Old Friend Index: " & pReader.ReadByte & vbNewLine &
                        " New Friend Index: " & pReader.ReadByte
              Else
                Return sHeader
              End If
            Case BNCS_CLANFINDCANDIDATES
              If c_Recv Then
                Dim sTmp As String = vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                      vbNewLine & " Status: " & ClanMessageCodesToString(pReader.ReadByte)
                Dim Candidates As Byte = pReader.ReadByte
                sTmp &= vbNewLine & " Candidates: " & Candidates
                For I As Integer = 0 To Candidates - 1
                  sTmp &= vbNewLine & "  Candidate " & I & ": " & pReader.ReadCString
                Next
                Return sHeader & sTmp
              Else
                Return sHeader & vbNewLine &
                        " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Clan Tag: " & pReader.ReadDWORDString
              End If
            Case BNCS_CLANINVITEMULTIPLE
              If c_Recv Then
                Dim sTmp As String = vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                      vbNewLine & " Result: " & ClanMessageCodesToString(pReader.ReadByte)
                Do
                  Dim sAccount As String = pReader.ReadCString
                  If String.IsNullOrEmpty(sAccount) Then Exit Do
                  sTmp &= vbNewLine & "  Failed Account: " & sAccount
                Loop
                Return sHeader & sTmp
              Else
                Dim sTmp As String = vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                      vbNewLine & " Clan Name: " & pReader.ReadCString &
                                      vbNewLine & " Clan Tag: " & pReader.ReadDWORDString
                Dim Users As Byte = pReader.ReadByte
                sTmp &= vbNewLine & " Invited Users: " & Users
                For I As Integer = 0 To Users - 1
                  sTmp &= vbNewLine & "  User: " & pReader.ReadCString
                Next I
                Return sHeader & sTmp
              End If
            Case BNCS_CLANCREATIONINVITATION
              If c_Recv Then
                Dim sTmp As String = vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                      vbNewLine & " Clan Tag: " & pReader.ReadDWORDString &
                                      vbNewLine & " Clan Name: " & pReader.ReadCString &
                                      vbNewLine & " Clan Inviter: " & pReader.ReadCString
                Dim Users As Byte = pReader.ReadByte
                sTmp &= vbNewLine & " Invited Users: " & Users
                For I As Integer = 0 To Users - 1
                  sTmp &= vbNewLine & "  User: " & pReader.ReadCString
                Next I
                Return sHeader & sTmp
              Else
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Clan Tag: " & pReader.ReadDWORDString &
                                  vbNewLine & " Inviter: " & pReader.ReadCString &
                                  vbNewLine & " Status: " & ClanMessageCodesToString(pReader.ReadByte)
              End If
            Case BNCS_CLANDISBAND
              If c_Recv Then
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Result: " & ClanMessageCodesToString(pReader.ReadByte)
              Else
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
              End If
            Case BNCS_CLANMAKECHIEFTAIN
              If c_Recv Then
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Status: " & ClanMessageCodesToString(pReader.ReadByte)
              Else
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " New Chieftain: " & pReader.ReadCString
              End If
            Case BNCS_CLANINFO
              If c_Recv Then
                Return sHeader & vbNewLine & " Unknown: 0x" & PadHex(pReader.ReadByte, 2) &
                                  vbNewLine & " Clan Tag: " & pReader.ReadDWORDString &
                                  vbNewLine & " Rank: " & ClanRankToString(pReader.ReadByte)
              Else
                Return sHeader
              End If
            Case BNCS_CLANQUITNOTIFY
              If c_Recv Then
                Return sHeader & vbNewLine & " Status: 0x" & PadHex(pReader.ReadByte, 2)
              Else
                Return sHeader
              End If
            Case BNCS_CLANINVITATION
              If c_Recv Then
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Result: " & ClanMessageCodesToString(pReader.ReadByte)
              Else
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Target User: " & pReader.ReadCString
              End If
            Case BNCS_CLANREMOVEMEMBER
              If c_Recv Then
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Status: " & ClanMessageCodesToString(pReader.ReadByte)
              Else
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Target User: " & pReader.ReadCString
              End If
            Case BNCS_CLANINVITATIONRESPONSE
              If c_Recv Then
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Clan Tag: " & pReader.ReadDWORDString &
                                  vbNewLine & " Clan Name: " & pReader.ReadCString &
                                  vbNewLine & " Inviter: " & pReader.ReadCString
              Else
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Clan Tag: " & pReader.ReadDWORDString &
                                  vbNewLine & " Inviter: " & pReader.ReadCString &
                                  vbNewLine & " Response: " & ClanMessageCodesToString(pReader.ReadByte)
              End If
            Case BNCS_CLANRANKCHANGE
              If c_Recv Then
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Status: " & ClanMessageCodesToString(pReader.ReadByte)
              Else
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Username: " & pReader.ReadCString &
                                  vbNewLine & " New Rank: " & ClanRankToString(pReader.ReadByte)
              End If
            Case BNCS_CLANSETMOTD
              If c_Recv Then
                Return sHeader
              Else
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " MotD: " & pReader.ReadCString
              End If
            Case BNCS_CLANMOTD
              If c_Recv Then
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Unknown: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " MotD: " & pReader.ReadCString
              Else
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
              End If
            Case BNCS_CLANMEMBERLIST
              If c_Recv Then
                Dim sTmp As String = vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
                Dim Members As Byte = pReader.ReadByte
                sTmp &= vbNewLine & " Members: " & Members
                For I As Integer = 0 To Members - 1
                  sTmp &= vbNewLine & "  Member " & I & ":" &
                          vbNewLine & "   Username: " & pReader.ReadCString &
                          vbNewLine & "   Rank: " & ClanRankToString(pReader.ReadByte) &
                          vbNewLine & "   Status: " & LocationCodeToString(pReader.ReadByte, pReader.ReadCString)
                Next
                Return sHeader & sTmp
              Else
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8)
              End If
            Case BNCS_CLANMEMBERREMOVED
              If c_Recv Then
                Return sHeader & vbNewLine & " Username: " & pReader.ReadCString
              Else
                Return sHeader
              End If
            Case BNCS_CLANMEMBERSTATUSCHANGE
              If c_Recv Then
                Return sHeader & vbNewLine & " Username: " & pReader.ReadCString &
                                  vbNewLine & " Rank: " & ClanRankToString(pReader.ReadByte) &
                                  vbNewLine & " Location: " & LocationCodeToString(pReader.ReadByte, pReader.ReadCString)
              Else
                Return sHeader & vbNewLine & " Old Rank: " & ClanRankToString(pReader.ReadByte) &
                                  vbNewLine & " New Rank: " & ClanRankToString(pReader.ReadByte) &
                                  vbNewLine & " Rank Changer: " & pReader.ReadCString
              End If
            Case BNCS_CLANMEMBERINFORMATION
              If c_Recv Then
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Status: " & ClanMessageCodesToString(pReader.ReadByte) &
                                  vbNewLine & " Clan Name: " & pReader.ReadCString &
                                  vbNewLine & " User's Rank: " & pReader.ReadByte &
                                  vbNewLine & " Join Date: " & UInt64ToDate(pReader.ReadUInt64).ToString("g")
              Else
                Return sHeader & vbNewLine & " Cookie: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Clan Tag: " & pReader.ReadDWORDString &
                                  vbNewLine & " Username: " & pReader.ReadCString
              End If
            Case Else
              Return sHeader
          End Select
        Case My.Resources.PROTOCOL_MCP
          Dim sHeader As String = c_Protocol & "  " &
                                  IIf(Recv, "S > C", "C > S") & "  " &
                                  ToID(c_Protocol, c_ID) & "  " &
                                  "Packet Length: " & pReader.ReadUInt16 & "  " &
                                  "Packet ID: 0x" & PadHex(pReader.ReadByte, 2)
          Select Case c_ID
            Case MCP_STARTUP
              If c_Recv Then
                Dim Result As UInt32 = pReader.ReadUInt32
                Select Case Result
                  Case &H2, &HA, &HB, &HC, &HD
                    Return sHeader & vbNewLine & " Result: " & My.Resources.REALM_UNAVAILABLE & " (0x" & PadHex(Result, 8) & ")"
                  Case &H7E
                    Return sHeader & vbNewLine & " Result: " & My.Resources.REALM_BANNEDKEY
                  Case &H7F
                    Return sHeader & vbNewLine & " Result: " & My.Resources.REALM_RESTRICTED
                  Case Else
                    Return sHeader & vbNewLine & " Result: Success"
                End Select
              Else
                Return sHeader & vbNewLine &
                        " Client Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " MCP Status: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " BNCS IP: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " UDP Token: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Null: 0x" & PadHex(pReader.ReadUInt16, 4) & vbNewLine &
                        " Key Product: 0x" & PadHex(pReader.ReadUInt16, 4) & vbNewLine &
                        " Key Public: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Gateway ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Product ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Platform ID: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " BNCS IP: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Locale: 0x" & PadHex(pReader.ReadUInt32, 8) & vbNewLine &
                        " Hash: " & BitConverter.ToString(pReader.ReadByteArray(20)) & vbNewLine &
                        " Unique Name: " & pReader.ReadCString
              End If
            Case MCP_CHARCREATE
              If c_Recv Then
                Dim Result As UInt32 = pReader.ReadUInt32
                Select Case Result
                  Case &H0 : Return sHeader & vbNewLine & " Result: Success"
                  Case &H14 : Return sHeader & vbNewLine & " Result: Character exists or maximum characters reached"
                  Case &H15 : Return sHeader & vbNewLine & " Result: Invalid name"
                  Case Else : Return sHeader & vbNewLine & " Result: Unknown (0x" & PadHex(Result, 8) & ")"
                End Select
              Else
                Dim CharClass As UInt32 = pReader.ReadUInt32
                Dim CharFlags As UInt16 = pReader.ReadUInt16
                Dim CharName As String = pReader.ReadCString
                Dim sClass As String = String.Empty
                Select Case CharClass
                  Case &H0 : sClass = "Amazon"
                  Case &H1 : sClass = "Sorcerss"
                  Case &H2 : sClass = "Necromancer"
                  Case &H3 : sClass = "Paladin"
                  Case &H4 : sClass = "Barbarian"
                  Case &H5 : sClass = "Druid"
                  Case &H6 : sClass = "Assassin"
                  Case Else : sClass = "Unknown (0x" & PadHex(CharClass, 8) & ")"
                End Select
                Dim sFlags As String = String.Empty
                If CharFlags And &H0 Then sFlags &= ", Classic"
                If CharFlags And &H4 Then sFlags &= ", Hardcore"
                If CharFlags And &H8 Then sFlags &= ", Dead"
                If CharFlags And &H20 Then sFlags &= ", Expansion"
                If CharFlags And &H40 Then sFlags &= ", Ladder"
                Do While sFlags.Substring(0, 2) = ", "
                  sFlags = sFlags.Substring(2)
                Loop
                Return sHeader & vbNewLine & " Class: " & sClass &
                                  vbNewLine & " Flags: " & sFlags &
                                  vbNewLine & " Name: " & CharName
              End If
            Case MCP_CREATEGAME
              If c_Recv Then
                Dim RequestID As UInt16 = pReader.ReadUInt16
                Dim GameToken As UInt16 = pReader.ReadUInt16
                Dim Unknown As UInt16 = pReader.ReadUInt16
                Dim Result As UInt32 = pReader.ReadUInt32
                Dim sResult As String = String.Empty
                Select Case Result
                  Case &H0 : sResult = "Success"
                  Case &H1E : sResult = "Invalid game name"
                  Case &H1F : sResult = "Game already exists"
                  Case &H20 : sResult = "Game servers are down"
                  Case &H6E : sResult = "Character is dead"
                  Case Else : sResult = "Unknown (0x" & PadHex(Result, 8) & ")"
                End Select
                Return sHeader & vbNewLine & " Request ID: 0x" & PadHex(RequestID, 4) &
                                  vbNewLine & " Game Token: 0x" & PadHex(GameToken, 4) &
                                  vbNewLine & " Unknown: 0x" & PadHex(Unknown, 4) &
                                  vbNewLine & " Result: " & sResult
              Else
                Dim RequestID As UInt16 = pReader.ReadUInt16
                Dim Difficulty As UInt32 = pReader.ReadUInt32
                Dim sDifficulty As String = String.Empty
                Select Case Difficulty
                  Case &H0 : sDifficulty = "Normal"
                  Case &H1000 : sDifficulty = "Nightmare"
                  Case &H2000 : sDifficulty = "Hell"
                  Case Else : sDifficulty = "Unknown (0x" & PadHex(Difficulty, 8) & ")"
                End Select
                Dim Unknown As Byte = pReader.ReadByte
                Dim PlayerDiff As Byte = pReader.ReadByte
                Dim MaxPlayers As Byte = pReader.ReadByte
                Dim GameName As String = pReader.ReadCString
                Dim GamePassword As String = pReader.ReadCString
                Dim GameDescription As String = pReader.ReadCString
                Return sHeader & vbNewLine & " Request ID: 0x" & PadHex(RequestID, 4) &
                                  vbNewLine & " Difficulty: " & sDifficulty &
                                  vbNewLine & " Unknown: 0x" & PadHex(Unknown, 2) &
                                  vbNewLine & " Player Difference: " & PlayerDiff &
                                  vbNewLine & " Maximum Players" & MaxPlayers &
                                  vbNewLine & " Game Name: " & GameName &
                                  vbNewLine & " Game Password: " & GamePassword &
                                  vbNewLine & " Game Description: " & GameDescription
              End If
            Case MCP_JOINGAME
              If c_Recv Then
                Dim RequestID As UInt16 = pReader.ReadUInt16
                Dim GameToken As UInt16 = pReader.ReadUInt16
                Dim Unknown As UInt16 = pReader.ReadUInt16
                Dim D2GSIP As UInt32 = pReader.ReadUInt32
                Dim GameHash As UInt32 = pReader.ReadUInt32
                Dim Result As UInt32 = pReader.ReadUInt32
                Dim sResult As String = String.Empty
                Select Case Result
                  Case &H0 : sResult = "Success"
                  Case &H29 : sResult = "Incorrect password"
                  Case &H2A : sResult = "Game does not exist"
                  Case &H2B : sResult = "Game is full"
                  Case &H2C : sResult = "Level requirements not met"
                  Case &H6E : sResult = "Character is dead"
                  Case &H71 : sResult = "Character does not meet Hardcore requirement"
                  Case &H73 : sResult = "Character does not meet Nightmare requirement"
                  Case &H74 : sResult = "Character does not meet Hell requirement"
                  Case &H78 : sResult = "Character does not meet Expansion requirement"
                  Case &H7D : sResult = "Character does not meet Ladder requirement"
                  Case Else : sResult = "Unknown (0x" & PadHex(Result, 8) & ")"
                End Select
                Return sHeader & vbNewLine & " Request ID: 0x" & PadHex(RequestID, 4) &
                                  vbNewLine & " Game Token: 0x" & PadHex(GameToken, 4) &
                                  vbNewLine & " Unknown: 0x" & PadHex(Unknown, 4) &
                                  vbNewLine & " D2GS IP: 0x" & PadHex(D2GSIP, 8) &
                                  vbNewLine & " Game Hash: 0x" & PadHex(GameHash, 8) &
                                  vbNewLine & " Result: " & sResult
              Else
                Return sHeader & vbNewLine & " Request ID: 0x" & PadHex(pReader.ReadUInt16, 4) &
                                  vbNewLine & " Game Name: " & pReader.ReadCString &
                                  vbNewLine & " Game Password: " & pReader.ReadCString
              End If
            Case MCP_GAMELIST
              If c_Recv Then
                Dim RequestID As UInt16 = pReader.ReadUInt16
                Dim Index As UInt32 = pReader.ReadUInt32
                Dim Players As Byte = pReader.ReadByte
                Dim Status As UInt32 = pReader.ReadUInt32
                Dim GameName As String = pReader.ReadCString
                Dim GameDescription As String = pReader.ReadCString
                Dim sStatus As String = String.Empty
                Select Case Status
                  Case &H300004 : sStatus = "Available"
                  Case &HFFFFFFFF& : sStatus = "Server is down"
                  Case Else : sStatus = "Unknown (0x" & PadHex(Status, 8) & ")"
                End Select
                Return sHeader & vbNewLine & " Request ID: 0x" & PadHex(RequestID, 4) &
                                  vbNewLine & " Game Index: " & Index &
                                  vbNewLine & " Players: " & Players &
                                  vbNewLine & " Status" & sStatus &
                                  vbNewLine & " Game Name: " & GameName &
                                  vbNewLine & " Game Description: " & GameDescription
              Else
                Return sHeader & vbNewLine & " Request ID: 0x" & PadHex(pReader.ReadUInt16, 4) &
                                  vbNewLine & " Unknown: 0x" & PadHex(pReader.ReadUInt32, 8) &
                                  vbNewLine & " Search: " & pReader.ReadCString
              End If
            Case MCP_GAMEINFO
              If c_Recv Then
                Dim RequestID As UInt16 = pReader.ReadUInt16
                Dim Status As UInt32 = pReader.ReadUInt32
                Dim Uptime As UInt32 = pReader.ReadUInt32
                Dim Unknown As UInt16 = pReader.ReadUInt16
                Dim MaxPlayers As Byte = pReader.ReadByte
                Dim InGameChars As Byte = pReader.ReadByte
                Dim Classes(15) As Byte
                For I As Integer = 0 To 15
                  Classes(I) = pReader.ReadByte
                Next
                Dim Levels(15) As Byte
                For I As Integer = 0 To 15
                  Levels(I) = pReader.ReadByte
                Next
                Dim Unused As Byte = pReader.ReadByte
                Dim Characters(15) As String
                For I As Integer = 0 To 15
                  Characters(I) = pReader.ReadCString
                Next
                Dim sCharInfo As String = String.Empty
                For I As Integer = 0 To 15
                  sCharInfo &= vbNewLine & "  Character " & I & ":" &
                                vbNewLine & "   Username: " & Characters(ID) &
                                vbNewLine & "   Class: "
                  Select Case Classes(I)
                    Case &H0 : sCharInfo &= "Amazon"
                    Case &H1 : sCharInfo &= "Sorcerss"
                    Case &H2 : sCharInfo &= "Necromancer"
                    Case &H3 : sCharInfo &= "Paladin"
                    Case &H4 : sCharInfo &= "Barbarian"
                    Case &H5 : sCharInfo &= "Druid"
                    Case &H6 : sCharInfo &= "Assassin"
                    Case Else : sCharInfo &= "Unknown (0x" & PadHex(Classes(I), 2) & ")"
                  End Select
                  sCharInfo &= vbNewLine & "   Level: " & Levels(I)
                Next
                Return sHeader & vbNewLine & " Request ID: 0x" & PadHex(RequestID, 4) &
                                  vbNewLine & " Status: 0x" & PadHex(Status, 8) &
                                  vbNewLine & " Uptime: " & Uptime & " seconds" &
                                  vbNewLine & " Unknown: 0x" & PadHex(Unknown, 4) &
                                  vbNewLine & " Maximum Players: " & MaxPlayers &
                                  vbNewLine & " Characters in game: " & InGameChars & sCharInfo
              Else
                Return sHeader & vbNewLine & " Request ID: 0x" & PadHex(pReader.ReadUInt16, 4) &
                                  vbNewLine & " Game Name: " & pReader.ReadCString
              End If
            Case MCP_CHARLOGON
              If c_Recv Then
                Dim Result As UInt32 = pReader.ReadUInt32
                Select Case Result
                  Case &H0 : Return sHeader & vbNewLine & " Result: Success"
                  Case &H46 : Return sHeader & vbNewLine & " Result: Character not found"
                  Case &H7A : Return sHeader & vbNewLine & " Result: Logon failed"
                  Case &H7B : Return sHeader & vbNewLine & " Result: Character expired"
                  Case Else : Return sHeader & vbNewLine & " Result: Unknown (0x" & PadHex(Result, 8) & ")"
                End Select
              Else
                Return sHeader & vbNewLine & " Character Name: " & pReader.ReadCString
              End If
            Case MCP_CHARDELETE
              If c_Recv Then
                Dim Result As UInt32 = pReader.ReadUInt32
                Select Case Result
                  Case &H0 : Return sHeader & vbNewLine & " Result: Success"
                  Case &H49 : Return sHeader & vbNewLine & " Result: Character doesn't exist"
                  Case Else : Return sHeader & vbNewLine & " Result: Unknown (0x" & PadHex(Result, 8) & ")"
                End Select
              Else
                Return sHeader & vbNewLine & " Unknown: 0x" & PadHex(pReader.ReadUInt16, 4) &
                                  vbNewLine & " Character Name: " & pReader.ReadCString
              End If
            Case MCP_REQUESTLADDERDATA
              If c_Recv Then
                Dim sTmp As String = vbNewLine
                Dim LadderType As Byte = pReader.ReadByte
                Select Case LadderType
                  Case &H0 : sTmp &= " Ladder Type: Classic Hardcore Overall Ladder"
                  Case &H1 : sTmp &= " Ladder Type: Classic Hardcore Amazon Ladder"
                  Case &H2 : sTmp &= " Ladder Type: Classic Hardcore Sorcerss Ladder"
                  Case &H3 : sTmp &= " Ladder Type: Classic Hardcore Necromancer Ladder"
                  Case &H4 : sTmp &= " Ladder Type: Classic Hardcore Paladin Ladder"
                  Case &H5 : sTmp &= " Ladder Type: Classic Hardcore Barbarian Ladder"
                  Case &H9 : sTmp &= " Ladder Type: Classic Softcore Overall Ladder"
                  Case &HA : sTmp &= " Ladder Type: Classic Softcore Amazon Ladder"
                  Case &HB : sTmp &= " Ladder Type: Classic Softcore Sorcerss Ladder"
                  Case &HC : sTmp &= " Ladder Type: Classic Softcore Necromancer Ladder"
                  Case &HD : sTmp &= " Ladder Type: Classic Softcore Paladin Ladder"
                  Case &HE : sTmp &= " Ladder Type: Classic Softcore Barbarian Ladder"
                  Case &H13 : sTmp &= " Ladder Type: Expansion Hardcore Overall Ladder"
                  Case &H14 : sTmp &= " Ladder Type: Expansion Hardcore Amazon Ladder"
                  Case &H15 : sTmp &= " Ladder Type: Expansion Hardcore Sorcerss Ladder"
                  Case &H16 : sTmp &= " Ladder Type: Expansion Hardcore Necromancer Ladder"
                  Case &H17 : sTmp &= " Ladder Type: Expansion Hardcore Paladin Ladder"
                  Case &H18 : sTmp &= " Ladder Type: Expansion Hardcore Barbarian Ladder"
                  Case &H19 : sTmp &= " Ladder Type: Expansion Hardcore Druid Ladder"
                  Case &H1A : sTmp &= " Ladder Type: Expansion Hardcore Assassin Ladder"
                  Case &H1B : sTmp &= " Ladder Type: Expansion Softcore Overall Ladder"
                  Case &H1C : sTmp &= " Ladder Type: Expansion Softcore Amazon Ladder"
                  Case &H1D : sTmp &= " Ladder Type: Expansion Softcore Sorcerss Ladder"
                  Case &H1E : sTmp &= " Ladder Type: Expansion Softcore Necromancer Ladder"
                  Case &H1F : sTmp &= " Ladder Type: Expansion Softcore Paladin Ladder"
                  Case &H20 : sTmp &= " Ladder Type: Expansion Softcore Barbarian Ladder"
                  Case &H21 : sTmp &= " Ladder Type: Expansion Softcore Druid Ladder"
                  Case &H22 : sTmp &= " Ladder Type: Expansion Softcore Assassin Ladder"
                  Case Else : sTmp &= " Ladder Type: Unknown (0x" & PadHex(LadderType, 2) & ")"
                End Select
                Dim TotalResponse As UInt16 = pReader.ReadUInt16
                Dim CurrentMessage As UInt16 = pReader.ReadUInt16
                Dim TotalUnreceived As UInt16 = pReader.ReadUInt16
                Dim RankofFirst As UInt16 = pReader.ReadUInt16
                Dim Unknown1 As UInt16 = pReader.ReadUInt16
                sTmp &= vbNewLine & " Total response size: " & TotalResponse &
                        vbNewLine & " Current message size: " & CurrentMessage &
                        vbNewLine & " Total Unreceived: " & TotalUnreceived &
                        vbNewLine & " Rank of first entry: " & RankofFirst &
                        vbNewLine & " Unknown: 0x" & PadHex(Unknown1, 4)
                Dim Entries As UInt32 = pReader.ReadUInt32
                Dim Unknown2 As UInt32 = pReader.ReadUInt32
                sTmp &= vbNewLine & " Entries: " & Entries &
                        vbNewLine & " Unknown: 0x" & PadHex(Unknown2, 8)
                For I As Integer = 0 To Entries - 1
                  Dim Experience As UInt64 = pReader.ReadUInt64
                  Dim Flags As Byte = pReader.ReadByte
                  Dim Title As Byte = pReader.ReadByte
                  Dim Level As UInt16 = pReader.ReadUInt16
                  Dim CharName() As Byte = pReader.ReadByteArray(16)
                  Dim sClass As String = String.Empty
                  Select Case Flags
                    Case &H0 : sClass = "Amazon"
                    Case &H1 : sClass = "Sorcerss"
                    Case &H2 : sClass = "Necromancer"
                    Case &H3 : sClass = "Paladin"
                    Case &H4 : sClass = "Barbarian"
                    Case &H5 : sClass = "Druid"
                    Case &H6 : sClass = "Assassin"
                    Case &H60 : sClass = "Hardcore Amazon"
                    Case &H61 : sClass = "Hardcore Sorcerss"
                    Case &H62 : sClass = "Hardcore Necromancer"
                    Case &H63 : sClass = "Hardcore Paladin"
                    Case &H64 : sClass = "Hardcore Barbarian"
                    Case &H65 : sClass = "Hardcore Druid"
                    Case &H66 : sClass = "Hardcore Assassin"
                    Case &H70 : sClass = "Dead Hardcore Amazon"
                    Case &H71 : sClass = "Dead Hardcore Sorcerss"
                    Case &H72 : sClass = "Dead Hardcore Necromancer"
                    Case &H73 : sClass = "Dead Hardcore Paladin"
                    Case &H74 : sClass = "Dead Hardcore Barbarian"
                    Case &H75 : sClass = "Dead Hardcore Druid"
                    Case &H76 : sClass = "Dead Hardcore Assassin"
                    Case Else : sClass = "Unknown (0x" & PadHex(Flags, 8) & ")"
                  End Select
                  sTmp &= vbNewLine & "  Entry " & I & ":" &
                          vbNewLine & "   Character Experience: " & Experience &
                          vbNewLine & "   Character Flags: " & Flags &
                          vbNewLine & "   Character Title: " & Title &
                          vbNewLine & "   Character Level: " & Level &
                          vbNewLine & "   Character Name: " & System.Text.Encoding.GetEncoding(LATIN_1).GetString(CharName).Trim(vbNullChar)
                Next
                Return sHeader & sTmp
              Else
                Dim sTmp As String = vbNewLine
                Dim LadderType As Byte = pReader.ReadByte
                Select Case LadderType
                  Case &H0 : sTmp &= " Ladder Type: Classic Hardcore Overall Ladder"
                  Case &H1 : sTmp &= " Ladder Type: Classic Hardcore Amazon Ladder"
                  Case &H2 : sTmp &= " Ladder Type: Classic Hardcore Sorcerss Ladder"
                  Case &H3 : sTmp &= " Ladder Type: Classic Hardcore Necromancer Ladder"
                  Case &H4 : sTmp &= " Ladder Type: Classic Hardcore Paladin Ladder"
                  Case &H5 : sTmp &= " Ladder Type: Classic Hardcore Barbarian Ladder"
                  Case &H9 : sTmp &= " Ladder Type: Classic Softcore Overall Ladder"
                  Case &HA : sTmp &= " Ladder Type: Classic Softcore Amazon Ladder"
                  Case &HB : sTmp &= " Ladder Type: Classic Softcore Sorcerss Ladder"
                  Case &HC : sTmp &= " Ladder Type: Classic Softcore Necromancer Ladder"
                  Case &HD : sTmp &= " Ladder Type: Classic Softcore Paladin Ladder"
                  Case &HE : sTmp &= " Ladder Type: Classic Softcore Barbarian Ladder"
                  Case &H13 : sTmp &= " Ladder Type: Expansion Hardcore Overall Ladder"
                  Case &H14 : sTmp &= " Ladder Type: Expansion Hardcore Amazon Ladder"
                  Case &H15 : sTmp &= " Ladder Type: Expansion Hardcore Sorcerss Ladder"
                  Case &H16 : sTmp &= " Ladder Type: Expansion Hardcore Necromancer Ladder"
                  Case &H17 : sTmp &= " Ladder Type: Expansion Hardcore Paladin Ladder"
                  Case &H18 : sTmp &= " Ladder Type: Expansion Hardcore Barbarian Ladder"
                  Case &H19 : sTmp &= " Ladder Type: Expansion Hardcore Druid Ladder"
                  Case &H1A : sTmp &= " Ladder Type: Expansion Hardcore Assassin Ladder"
                  Case &H1B : sTmp &= " Ladder Type: Expansion Softcore Overall Ladder"
                  Case &H1C : sTmp &= " Ladder Type: Expansion Softcore Amazon Ladder"
                  Case &H1D : sTmp &= " Ladder Type: Expansion Softcore Sorcerss Ladder"
                  Case &H1E : sTmp &= " Ladder Type: Expansion Softcore Necromancer Ladder"
                  Case &H1F : sTmp &= " Ladder Type: Expansion Softcore Paladin Ladder"
                  Case &H20 : sTmp &= " Ladder Type: Expansion Softcore Barbarian Ladder"
                  Case &H21 : sTmp &= " Ladder Type: Expansion Softcore Druid Ladder"
                  Case &H22 : sTmp &= " Ladder Type: Expansion Softcore Assassin Ladder"
                  Case Else : sTmp &= " Ladder Type: Unknown (0x" & PadHex(LadderType, 2) & ")"
                End Select
                sTmp &= vbNewLine & " Starting Position: " & pReader.ReadUInt16
                Return sHeader & sTmp
              End If
            Case MCP_MOTD
              If c_Recv Then
                Return sHeader & vbNewLine & " Unknown: 0x" & PadHex(pReader.ReadByte, 2) &
                                  vbNewLine & " MotD: " & pReader.ReadCString
              Else
                Return sHeader
              End If
            Case MCP_CANCELGAMECREATE
              Return sHeader
            Case MCP_CREATEQUEUE
              If c_Recv Then
                Return sHeader & vbNewLine & " Position: " & pReader.ReadUInt32
              Else
                Return sHeader
              End If
            Case MCP_CHARLIST
              If c_Recv Then
                Dim sTmp As String = String.Empty
                Dim RequestedChars As UInt16 = pReader.ReadUInt16
                Dim ExistingChars As UInt32 = pReader.ReadUInt32
                Dim ReturnedChars As UInt16 = pReader.ReadUInt16
                sTmp &= vbNewLine & " Requested Characters: " & RequestedChars &
                          vbNewLine & " Characters on this Account: " & ExistingChars &
                          vbNewLine & " Returned Characters: " & ReturnedChars
                For I As Integer = 0 To ReturnedChars
                  sTmp &= vbNewLine & "  Character " & I & ":" &
                          vbNewLine & "   Name: " & pReader.ReadCString &
                          vbNewLine & "   StatString: " & BitConverter.ToString(pReader.ReadNullTerminatedByteArray)
                Next
              Else
                Return sHeader & vbNewLine & " Characters to list: " & pReader.ReadUInt32
              End If
            Case MCP_CHARUPGRADE
              If c_Recv Then
                Dim Result As UInt32 = pReader.ReadUInt32
                Select Case Result
                  Case &H0 : Return sHeader & vbNewLine & " Result: Success"
                  Case &H46 : Return sHeader & vbNewLine & " Result: Character not found"
                  Case &H7A : Return sHeader & vbNewLine & " Result: Upgrade failed"
                  Case &H7B : Return sHeader & vbNewLine & " Result: Character is expired"
                  Case &H7C : Return sHeader & vbNewLine & " Result: Already expansion"
                  Case Else : Return sHeader & vbNewLine & " Result: Unknown (0x" & PadHex(Result, 8) & ")"
                End Select
              Else
                Return sHeader & vbNewLine & " Character Name: " & pReader.ReadCString
              End If
            Case MCP_CHARLIST2
              If c_Recv Then
                Dim sTmp As String = String.Empty
                Dim RequestedChars As UInt16 = pReader.ReadUInt16
                Dim ExistingChars As UInt32 = pReader.ReadUInt32
                Dim ReturnedChars As UInt16 = pReader.ReadUInt16
                sTmp &= vbNewLine & " Requested Characters: " & RequestedChars &
                          vbNewLine & " Characters on this Account: " & ExistingChars &
                          vbNewLine & " Returned Characters: " & ReturnedChars
                If ReturnedChars > 0 Then
                  For I As Integer = 0 To ReturnedChars - 1
                    Dim Expires As UInt32 = pReader.ReadUInt32
                    Dim sExpires As String = String.Empty
                    If Expires <> 0 Then
                      Dim ExpiresOn As Date = DateValue("1/1/1970").AddSeconds(Expires)
                      Dim lAdd As Int64 = ((DateTime.UtcNow - DateTime.Now).TotalMinutes)
                      Dim ExpiresIn As Int64 = DateDiff(DateInterval.Second, Now.AddMinutes(lAdd), ExpiresOn)
                      If ExpiresIn > 0 Then
                        sExpires = ConvertTime(ExpiresIn * 1000, False)
                      Else
                        sExpires = "Expired"
                      End If
                    Else
                      sExpires = "Never"
                    End If
                    sTmp &= vbNewLine & "  Character " & I & ":" &
                            vbNewLine & "   Expires: " & sExpires &
                            vbNewLine & "   Name: " & pReader.ReadCString &
                            vbNewLine & "   StatString: " & BitConverter.ToString(pReader.ReadNullTerminatedByteArray)
                  Next
                End If
                Return sHeader & sTmp
              Else
                Return sHeader & vbNewLine & " Characters to list: " & pReader.ReadUInt32
              End If
          End Select
        Case My.Resources.PROTOCOL_UDP
          Select Case c_ID

            'Private Sub PKT_CLIENTREQ_Recv(ByRef ipFrom As DnsEndPoint, ByRef Packet As DataReader)
            '  Dim Code As UInt32 = Packet.ReadUInt32
            '  PKT_CLIENTREQ_Send(ipFrom, Code <> 0)
            'End Sub

            'Private Sub PKT_CLIENTREQ_Send(ByRef ipFrom As DnsEndPoint,  Pong As Boolean)
            '  Using pktTemp As New DataBuffer
            '    pktTemp.InsertUInt32(&H3)
            '    pktTemp.InsertUInt32(&H1)
            '    If Pong Then
            '      gChat.AddChat(GeckoChat.ChatType.Servicesuccess, My.Resources.PROTOCOL_UDP, "Pong from " & ipFrom.Host & ":" & ipFrom.Port.ToString)
            '    Else
            '      If tbsLists.Controls.Contains(tabPacket) Then AddPacket(My.Resources.PROTOCOL_UDP, False, &H3, pktTemp.GetData)
            '      If sckUDP.IsConnected Then sckUDP.SendTo(ipFrom, pktTemp.GetData)
            '      gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_UDP, "Ping to " & ipFrom.Host & ":" & ipFrom.Port.ToString)
            '    End If
            '  End Using
            'End Sub

            'Private Sub PKT_SERVERPING_Recv(ByRef ipFrom As IPEndPoint, ByRef Packet As DataReader)
            '  BNetData.UDPCode = Packet.ReadUInt32
            'End Sub

            'Private Sub PKT_KEEPALIVE_Send()
            '  Using pktTemp As New DataBuffer
            '    pktTemp.InsertUInt32(&H7)
            '    pktTemp.InsertInt32(Environment.TickCount)
            '    If tbsLists.Controls.Contains(tabPacket) Then AddPacket(My.Resources.PROTOCOL_UDP, False, &H7, pktTemp.GetData)
            '    If sckUDP.IsConnected Then sckUDP.SendTo(udpRemoteEndPoint, pktTemp.GetData)
            '  End Using
            'End Sub

            'Private Sub PKT_CONNTEST_Send()
            '  Using pktTemp As New DataBuffer
            '    pktTemp.InsertUInt32(&H8)
            '    pktTemp.InsertInt32(BNetData.ServerToken)
            '    If tbsLists.Controls.Contains(tabPacket) Then AddPacket(My.Resources.PROTOCOL_UDP, False, &H8, pktTemp.GetData)
            '    If sckUDP.IsConnected Then sckUDP.SendTo(udpRemoteEndPoint, pktTemp.GetData)
            '  End Using
            'End Sub

            'Private Sub PKT_CONNTEST2_Send()
            '  Using pktTemp As New DataBuffer
            '    pktTemp.InsertUInt32(&H9)
            '    pktTemp.InsertUInt32(BNetData.ServerToken)
            '    pktTemp.InsertUInt32(BNetData.UDPToken)
            '    If tbsLists.Controls.Contains(tabPacket) Then AddPacket(My.Resources.PROTOCOL_UDP, False, &H9, pktTemp.GetData)
            '    If sckUDP.IsConnected Then sckUDP.SendTo(udpRemoteEndPoint, pktTemp.GetData)
            '  End Using
            'End Sub

          End Select
      End Select

      Return c_Protocol & "  " & IIf(Recv, "S > C", "C > S") & "  " & ToID(c_Protocol, c_ID) & vbNewLine & sParsed
    End Function
    Private Function ClanMessageCodesToString(Status As Byte) As String
      Select Case Status
        Case &H0 : Return "Success"
        Case &H1 : Return "In use"
        Case &H2 : Return "Too soon"
        Case &H3 : Return "Not enough members"
        Case &H4 : Return "Invitation declined"
        Case &H5 : Return "Decline"
        Case &H6 : Return "Accept"
        Case &H7 : Return "Not authorized"
        Case &H8 : Return "Not found"
        Case &H9 : Return "Clan is full"
        Case &HA : Return "Bad tag"
        Case &HB : Return "Bad name"
        Case &HC : Return "User not in clan"
        Case Else : Return "Unknown (0x" & PadHex(Status, 2) & ")"
      End Select
    End Function
    Private Function LocationCodeToString(Location As Byte, sLocation As String) As String
      Select Case Location
        Case 0 : Return IIf(String.IsNullOrEmpty(sLocation), "Offline", "Offline in " & sLocation)
        Case 1 : Return IIf(String.IsNullOrEmpty(sLocation), "Not in Chat", "Online in " & sLocation)
        Case 2 : Return IIf(String.IsNullOrEmpty(sLocation), "In a channel", "In channel " & sLocation)
        Case 3 : Return IIf(String.IsNullOrEmpty(sLocation), "In a public game", "In the public game " & sLocation)
        Case 4 : Return IIf(String.IsNullOrEmpty(sLocation), "In a private game", "In the private game " & sLocation)
        Case 5 : Return IIf(String.IsNullOrEmpty(sLocation), "In a private game", "In the private game " & sLocation)
        Case Else : Return "Unknown (0x" & PadHex(sLocation, 2) & ") " & sLocation
      End Select
    End Function
  End Class
  Friend Class PingSpoofQueue
    Private WithEvents tmrPingSpoof As Timers.Timer
    Private cPackets As New ArrayList
    Private m_StartTime As Integer
    Private m_WaitTime As Integer
    Public Event SpoofUpdate(TimeLeft As Integer)
    Public Event SpoofComplete(Packets As ArrayList)
    Private lastTimeLeft As Integer

    Public Property WaitTime As Integer
      Get
        Return m_WaitTime
      End Get
      Set(value As Integer)
        m_WaitTime = value
      End Set
    End Property

    Public Sub New(StartTime As Integer, WaitTime As Integer)
      m_StartTime = StartTime
      m_WaitTime = WaitTime
      tmrPingSpoof = New Timers.Timer(100)
      tmrPingSpoof.Enabled = True
      lastTimeLeft = 0
    End Sub

    Public Sub AddPacketToQueue(ByRef Packet As Object)
      cPackets.Add(Packet)
    End Sub

    Private Sub tmrPingSpoof_Elapsed(sender As Object, e As System.Timers.ElapsedEventArgs) Handles tmrPingSpoof.Elapsed
      Dim thisTimeLeft As Integer = (m_StartTime + m_WaitTime) - Environment.TickCount
      If thisTimeLeft < 0 Then
        RaiseEvent SpoofComplete(cPackets)
      ElseIf thisTimeLeft <> lastTimeLeft Then
        lastTimeLeft = thisTimeLeft
        RaiseEvent SpoofUpdate(thisTimeLeft)
      End If
    End Sub
  End Class
  Private Class AntiTrivia
    Private sTriviaBot As String
    Private sLatestQuestion As String
    Private Questions As New Collections.ArrayList
    Public OnEmote As TriState
    Public Event HasAnAnwser(Answer As String)
    Private Structure QuestionList
      Public Question As String
      Public Answer As String
    End Structure
    Public Sub New(TriviaBot As String)
      sTriviaBot = TriviaBot
    End Sub
    Public Property TriviaBot As String
      Get
        Return sTriviaBot
      End Get
      Set(value As String)
        sTriviaBot = value
      End Set
    End Property
    Public Sub MessageFromBot(Message As String)
      If Message.StartsWith("Hint:", True, Nothing) Or Message.Contains("Hint:") Then
        'is a hint, ignore
      ElseIf Message.Contains("Well done.") Then
        Dim nQ As QuestionList
        nQ.Question = sLatestQuestion
        nQ.Answer = Message.Substring(1, Message.IndexOf(")"c) - 1)
        If Not (String.IsNullOrEmpty(nQ.Question) Or String.IsNullOrEmpty(nQ.Answer) Or Questions.Contains(nQ)) Then
          Questions.Add(nQ)
          SaveTrivia(AppStore & "\TriviaKiller.txt")
        End If
      ElseIf Message.StartsWith("Congratulations") Then
        Dim nQ As QuestionList
        nQ.Question = sLatestQuestion
        nQ.Answer = Message.Substring(Message.IndexOf("Answer was:") + 12, (Message.IndexOf("! Your score:") - 1) - (Message.IndexOf("Answer was:") + 11))
        If Not (String.IsNullOrEmpty(nQ.Question) Or String.IsNullOrEmpty(nQ.Answer) Or Questions.Contains(nQ)) Then
          Questions.Add(nQ)
          SaveTrivia(AppStore & "\TriviaKiller.txt")
        End If
      ElseIf Message.StartsWith("The answer", True, Nothing) Then
        Dim nQ As QuestionList
        nQ.Question = sLatestQuestion
        nQ.Answer = Message.Substring(15)
        If Not (String.IsNullOrEmpty(nQ.Question) Or String.IsNullOrEmpty(nQ.Answer) Or Questions.Contains(nQ)) Then
          Questions.Add(nQ)
          SaveTrivia(AppStore & "\TriviaKiller.txt")
        End If
      ElseIf Message.Contains("Answer was:") Then
        Dim nQ As QuestionList
        nQ.Question = sLatestQuestion
        nQ.Answer = Message.Substring(Message.IndexOf("Answer was:") + 12)
        If Not (String.IsNullOrEmpty(nQ.Question) Or String.IsNullOrEmpty(nQ.Answer) Or Questions.Contains(nQ)) Then
          Questions.Add(nQ)
          SaveTrivia(AppStore & "\TriviaKiller.txt")
        End If
      Else
        sLatestQuestion = Message
        Dim sAnswer As String = (From item As QuestionList In Questions Where StrComp(Message, item.Question, CompareMethod.Text) = 0 Select item.Answer).FirstOrDefault
        If Not String.IsNullOrEmpty(sAnswer) Then RaiseEvent HasAnAnwser(sAnswer)
      End If
    End Sub
    Public Sub LoadTrivia(Path As String)
      If My.Computer.FileSystem.FileExists(Path) Then
        Using iRead As IO.StreamReader = My.Computer.FileSystem.OpenTextFileReader(Path)
          Do Until iRead.EndOfStream
            Dim nQ As QuestionList
            Dim sItem As String = iRead.ReadLine
            nQ.Question = sItem.Split("|"c)(0)
            nQ.Answer = sItem.Split("|"c)(1)
            If Not Questions.Contains(nQ) Then Questions.Add(nQ)
          Loop
          iRead.Close()
        End Using
      End If
    End Sub
    Public Sub SaveTrivia(Path As String)
      Using iWrite As IO.StreamWriter = My.Computer.FileSystem.OpenTextFileWriter(Path, False)
        For Each item As QuestionList In (From itm As QuestionList In Questions Where Not (String.IsNullOrEmpty(itm.Question) Or String.IsNullOrEmpty(itm.Answer)))
          iWrite.WriteLine(item.Question & "|" & item.Answer)
        Next
        iWrite.Close()
      End Using
    End Sub
  End Class
  Private Class D2Realm
    Friend Enum RealmState
      Offline
      QueryingRealms
      RealmList
      ConnectingToRealm
      GettingCharacterList
      CharacterList
      CharacterCreation
    End Enum
    Friend Status As RealmState
    Friend RealmListing As New RealmList
    Friend CharListing As New RealmChars
    Friend Class RealmList
      Friend Structure Realm
        Public Title As String
        Public Description As String
      End Structure
      Private RealmList() As Realm
      Public Sub ClearRealms()
        Erase RealmList
      End Sub
      Public Function GetRealm(Index As Integer) As Realm
        If RealmList IsNot Nothing AndAlso RealmList.Count > Index And Index > -1 Then Return RealmList(Index)
        Return Nothing
      End Function
      Public Function GetRealms() As Realm()
        Return RealmList
      End Function
      Public Sub AddRealm(Title As String, Description As String)
        If RealmList Is Nothing Then
          ReDim RealmList(0)
        Else
          ReDim Preserve RealmList(RealmList.Count)
        End If
        RealmList(RealmList.Count - 1).Title = Title
        RealmList(RealmList.Count - 1).Description = Description
      End Sub
    End Class
    Friend Class RealmChars
      Private CharList() As Character
      Friend Structure Character
        Public Character As String
        Public StatString() As Byte
        Public Expansion As Boolean
        Public Dead As Boolean
        Public Expires As UInt32
        Public Icon As Image
      End Structure
      Friend Sub Clear()
        Erase CharList
      End Sub
      Public Function GetChar(Index As Integer) As Character
        If CharList IsNot Nothing AndAlso CharList.Count > Index Then Return CharList(Index)
        Return Nothing
      End Function
      Friend Function Count() As Integer
        If CharList IsNot Nothing Then Return CharList.Count
        Return Nothing
      End Function
      Friend Sub AddChar(Expires As UInt32, Name As String, StatString() As Byte)
        If CharList Is Nothing Then
          ReDim CharList(0)
        Else
          ReDim Preserve CharList(CharList.Count)
        End If
        CharList(CharList.Count - 1).Character = Name
        CharList(CharList.Count - 1).StatString = StatString
        CharList(CharList.Count - 1).Expansion = CBool(StatString(26) And &H20)
        CharList(CharList.Count - 1).Dead = CBool(StatString(26) And &H4) And CBool(StatString(26) And &H8)
        CharList(CharList.Count - 1).Expires = Expires
        CharList(CharList.Count - 1).Icon = CharIconCreate(StatString)
      End Sub
      Private Function CharIconCreate(StatString() As Byte) As Image
        Dim icoBase As Image = New Bitmap(28, 14)
        Dim CharClass As Byte = StatString(13) - 1
        Dim CharLev As Byte = StatString(25)
        Dim CharHC As Boolean = StatString(26) And &H4
        Dim CharDead As Boolean = StatString(26) And &H8
        If Not CharHC Then CharDead = False
        Dim CharExp As Boolean = StatString(26) And &H20
        Dim CharLadder As Boolean = Not (StatString(30) = &HFF)
        Dim CharAct As Byte = StatString(27)
        Dim CharNew As Boolean = StatString(28) = &H80
        Dim GroupNum As Byte
        If CharLadder Then
          If CharHC Then
            If CharDead Then
              GroupNum = 5
            Else
              GroupNum = 4
            End If
          Else
            GroupNum = 3
          End If
        Else
          If CharHC Then
            If CharDead Then
              GroupNum = 2
            Else
              GroupNum = 1
            End If
          Else
            GroupNum = 0
          End If
        End If
        If CharExp Then
          Dim ActNum As Integer
          If CharAct >= &H80 And CharAct <= &H9C Then
            ActNum = (CharAct - &H80) / 2
          ElseIf CharAct = &H9E Then
            ActNum = 15
          Else
            ActNum = -1
          End If
          If ActNum > -1 Then
            Dim IcoNum As Integer = (GroupNum * (17 * 7)) + (CharClass * 17) + ActNum + IIf(CharNew, 0, 1)
            icoBase = Image.FromFile(AppTemp & "\icons\D2XP\" & IcoNum.ToString & ".png", True)
          End If
        Else
          Dim ActNum As Integer
          If CharAct >= &H80 And CharAct <= &H96 Then
            ActNum = (CharAct - &H80) / 2
          ElseIf CharAct = &H98 Then
            ActNum = 12
          Else
            ActNum = -1
          End If
          If ActNum > -1 Then
            Dim IcoNum As Integer = (GroupNum * (14 * 5)) + (CharClass * 14) + ActNum + IIf(CharNew, 0, 1)
            icoBase = Image.FromFile(AppTemp & "\icons\D2DV\" & IcoNum.ToString & ".png", True)
          End If
        End If
        Return DrawIconText(icoBase, CharLev, Brushes.White, "D2DV", False)
      End Function
    End Class

  End Class
#End Region

  Public Config As New cConfig(Me)
  Public BNetData As BNCSVariables
  Public ThumbView As Microsoft.WindowsAPICodePack.Taskbar.TabbedThumbnail = Nothing
  Public Index As Integer
  Public W3Icons() As W3IconList = Nothing

  Private ProfileWindow As frmProfile
  Private ClanInviteWindow As frmClanInvitation

  Private WithEvents sckBN2 As New SocketWrapper
  Private WithEvents sckBNCS As New SocketWrapper
  Private WithEvents sckMCP As New SocketWrapper
  Private WithEvents sckUDP As New UDPWrapper
  Private WithEvents wsDownload As New Net.WebClient
  Private wsIdent As New TcpListener(113)
  Private WithEvents cBNET2 As clsBNCS2
  Private WithEvents QueueList As ChatQueue
  Private WithEvents cWarden As clsWarden
  Private WithEvents PingSpoof As PingSpoofQueue
  Private WithEvents TriviaKiller As AntiTrivia

  Private ProfileRequestList As New ProfileRequests
  Private ChanList As New ChannelList
  Private ClanList As New ClanListing
  Private Realms As New D2Realm
  Private SOCKS5Data As SOCKS5Variables
  Private CRev As CRevData
  Private MCP As MCPData
  Private ChatData As ChatVariables
  Private R_NLS As clsNLS
  Private R_new_NLS As clsNLS
  Private pktData As PacketMessages

  Private tmrAds As Timers.Timer
  Private tmrBanList As Timers.Timer
  Private tmrRetryJoin As Timers.Timer
  Private idThread As Thread
  Private udpEndPoint As IPEndPoint
  Private udpRemoteEndPoint As IPEndPoint
  Private LastTenCommands(9) As String
  Private LastChanUpdate As Integer
  Private ConErr As TriState
  Private bBNState As Byte

  Private Const NET_FAILURE As String = "A request to send or receive data was disallowed because the socket is not connected and (when sending on a datagram socket using a sendto call) no address was supplied"

  Private Delegate Sub CallBack(Obj As Object)
  Private Delegate Function ReturnCallBack(Obj As Object) As Object
  Private Delegate Sub ByRefCallBack(ByRef Obj As Object)

#Region "Window Events"
  Public Sub Initialize()
    pktData = New PacketMessages(txtPacketLog)

    tmrAds = New Timers.Timer(120000)
    AddHandler tmrAds.Elapsed, AddressOf tmrAds_Tick
    tmrAds.Interval = 120000
    tmrAds.AutoReset = True
    GC.KeepAlive(tmrAds)

    If My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\iconindex_clan.txt") Then
      Dim sClan() As String = Split(My.Computer.FileSystem.ReadAllText(AppTemp & "\icons\WAR3\iconindex_clan.txt"), vbNewLine)
      For Each sItem As String In (From cItem As String In sClan Where Not String.IsNullOrEmpty(cItem))
        imlClan.Images.Add(Image.FromFile(AppTemp & "\icons\WAR3\" & sItem.Substring(sItem.LastIndexOf("\") + 1) & ".png", True))
      Next
      imlClan.Images.Add(Image.FromFile(AppTemp & "\icons\WAR3\bnet-unknown-off.blp.png", True))
      lvClan.LargeImageList = imlClan
      lvClan.SmallImageList = imlClan
    End If
    If tbsLists.Controls.Contains(tabClan) Then TabRemove(tabClan)
    If tbsLists.Controls.Contains(tabRealm) Then TabRemove(tabRealm)
    ToggleListChannel(False)
  End Sub

  Public Sub Terminate()
    If sckBNCS IsNot Nothing Then
      sckBNCS.Dispose()
      sckBNCS = Nothing
    End If
    If sckMCP IsNot Nothing Then
      sckMCP.Dispose()
      sckMCP = Nothing
    End If
    If sckUDP IsNot Nothing Then
      sckUDP.Dispose()
      sckUDP = Nothing
    End If
    If wsDownload IsNot Nothing Then
      wsDownload.Dispose()
      wsDownload = Nothing
    End If
    If sckBN2 IsNot Nothing Then
      sckBN2.Dispose()
      sckBN2 = Nothing
    End If
    If wsIdent IsNot Nothing Then wsIdent = Nothing
    If pktData IsNot Nothing Then pktData = Nothing
    If tmrAds IsNot Nothing Then tmrAds = Nothing
    If tmrBanList IsNot Nothing Then tmrBanList = Nothing
    If tmrRetryJoin IsNot Nothing Then tmrRetryJoin = Nothing
    If idThread IsNot Nothing Then idThread = Nothing
    If ThumbView IsNot Nothing Then
      ThumbView.Dispose()
      ThumbView = Nothing
    End If
    W3Icons = Nothing
    If ProfileWindow IsNot Nothing Then
      ProfileWindow.Dispose()
      ProfileWindow = Nothing
    End If
    If ClanInviteWindow IsNot Nothing Then
      ClanInviteWindow.Dispose()
      ClanInviteWindow = Nothing
    End If
    If QueueList IsNot Nothing Then
      QueueList.Dispose()
      QueueList = Nothing
    End If
    If cWarden IsNot Nothing Then cWarden = Nothing
    If PingSpoof IsNot Nothing Then PingSpoof = Nothing
    If ProfileRequestList IsNot Nothing Then ProfileRequestList = Nothing
    If ChanList IsNot Nothing Then ChanList = Nothing
    If ClanList IsNot Nothing Then ClanList = Nothing
    SOCKS5Data = Nothing
    CRev = Nothing
    MCP = Nothing
    ChatData = Nothing
    If R_NLS IsNot Nothing Then R_NLS = Nothing
    If R_new_NLS IsNot Nothing Then R_new_NLS = Nothing
    If udpEndPoint IsNot Nothing Then udpEndPoint = Nothing
    If udpRemoteEndPoint IsNot Nothing Then udpRemoteEndPoint = Nothing
    Config = Nothing
    BNetData = Nothing
  End Sub

  Private Sub BNUI_Resize(sender As Object, e As EventArgs) Handles Me.Resize
    If Not lvChannel.Columns(0).Width = lvChannel.ClientSize.Width - 18 Then lvChannel.Columns(0).Width = lvChannel.ClientSize.Width - 18
    If Not lvChannel.Columns(1).Width = 18 Then lvChannel.Columns(1).Width = 18
    If Not lvFriends.Columns(0).Width = lvFriends.ClientSize.Width Then lvFriends.Columns(0).Width = lvFriends.ClientSize.Width
    If lvClan.Columns.Count > 0 Then If Not lvClan.Columns(0).Width = lvClan.ClientSize.Width Then lvClan.Columns(0).Width = lvClan.ClientSize.Width
    If Not lvRealmChars.Columns(0).Width = lvRealmChars.ClientSize.Width - 50 Then lvRealmChars.Columns(0).Width = lvRealmChars.ClientSize.Width - 50
    If Not lvRealmChars.Columns(1).Width = 50 Then lvRealmChars.Columns(1).Width = 50
  End Sub

  Private Sub BNUI_VisibleChanged(sender As Object, e As EventArgs) Handles Me.VisibleChanged
    If lvChannel.Visible AndAlso lvChannel.Columns.Count > 0 Then
      If Not lvChannel.Columns(0).Width = lvChannel.ClientSize.Width - 18 Then lvChannel.Columns(0).Width = lvChannel.ClientSize.Width - 18
      If Not lvChannel.Columns(1).Width = 18 Then lvChannel.Columns(1).Width = 18
    End If
    If lvFriends.Visible And lvFriends.Columns.Count > 0 Then If Not lvFriends.Columns(0).Width = lvFriends.ClientSize.Width Then lvFriends.Columns(0).Width = lvFriends.ClientSize.Width
    If lvClan.Columns.Count > 0 Then If Not lvClan.Columns(0).Width = lvClan.ClientSize.Width Then lvClan.Columns(0).Width = lvClan.ClientSize.Width
    If lvRealmChars.Visible And lvRealmChars.Columns.Count > 1 Then
      If Not lvRealmChars.Columns(0).Width = lvRealmChars.ClientSize.Width - 50 Then lvRealmChars.Columns(0).Width = lvRealmChars.ClientSize.Width - 50
      If Not lvRealmChars.Columns(1).Width = 50 Then lvRealmChars.Columns(1).Width = 50
    End If
  End Sub

  Private Sub gChat_HyperlinkClick(sender As Object, e As GeckoChat.LinkClickEventArgs) Handles gChat.HyperlinkClick
    txtSend.Focus()
    If e.Mouse.Button = 0 Then
      Try
        Process.Start(e.URL)
      Catch ex As Exception
        MsgBox(ResString(My.Resources.ADDRESS_UNABLE_TO_HANDLE, e.URL), MsgBoxStyle.Critical)
      End Try
    ElseIf e.Mouse.Button = 2 Then
      mnuAddress.Tag = e.URL
      mnuAddress.Show(gChat, e.Mouse.Location) ' MousePosition)
    End If
  End Sub

  Private Sub gChat_Load(sender As Object, e As EventArgs) Handles gChat.Load
    gChat.TimeStampFormat = Config.Display.TimeStamp
    gChat.ToggleTimestamps(Config.Display.TimeStampEnabled)
    gChat.MaxLines = Config.Display.MaxLines
    gChat.Emoticons = Config.Display.Emoticons
    gChat.RichText = Config.Display.RichText
  End Sub

  Private Sub gChat_MouseUp(sender As Object, e As MouseEventArgs) Handles gChat.MouseUp
    txtSend.Focus()
    If e.Button = 2 Then
      mnuAdvancedTimestamp.Checked = Config.Display.TimeStampEnabled
      mnuAdvancedRichText.Checked = Config.Display.RichText
      mnuAdvancedUTF8.Checked = Config.UTF8
      mnuAdvancedEmoticons.Checked = Config.Display.Emoticons
      mnuAdvancedJoinLeave.Checked = Config.Display.JoinLeave
      If gChat.Visible Then mnuChatBox.Show(gChat, e.Location) ' MousePosition)
    End If
  End Sub

  Private Sub gChat_ReconnectResult(sender As Object, e As Boolean) Handles gChat.ReconnectResult
    If e Then BNCS_Connect()
  End Sub

  Private Sub gChat_UserNameClick(sender As Object, e As GeckoChat.NameClickEventArgs) Handles gChat.UserNameClick
    txtSend.Focus()
    If e.Mouse.Button = 0 Then
      If lvChannel.FindItemWithText(e.Account) IsNot Nothing Then
        lvChannel.FindItemWithText(e.Account).Selected = True
        lvChannel.FindItemWithText(e.Account).EnsureVisible()
        mnuUser.Tag = e.Account
      End If
    ElseIf e.Mouse.Button = 2 Then
      If lvChannel.FindItemWithText(e.Account) IsNot Nothing Then
        mnuSquelch.Checked = ChanList.Flags(e.Account) And USER_SQUELCHED
        mnuFriend.Checked = IsFriend(e.Account)
      Else
        mnuSquelch.Checked = False
        mnuFriend.Checked = False
      End If
      mnuWhisWin.Visible = Not (Config.Display.WhisWin = 0)
      mnuUser.Tag = e.Account
      mnuUser.Show(gChat, e.Mouse.Location) 'MousePosition)
    End If
  End Sub

  Private Sub spltChat_SplitterMoved(sender As Object, e As SplitterEventArgs) Handles spltChat.SplitterMoved
    BNUI_VisibleChanged(sender, e)
  End Sub

  Private Sub txtSend_KeyDown(sender As Object, e As KeyEventArgs) Handles txtSend.KeyDown
    If e.KeyCode = Keys.N And e.Alt Then
      e.Handled = True
      e.SuppressKeyPress = True
      mnuName_Click(New Object, New EventArgs)
    ElseIf e.KeyCode = Keys.Tab Then
      If e.Shift And Not e.Alt And Not e.Control Then
        Dim bOK As Boolean = False
        If String.IsNullOrEmpty(txtSend.Text) Then
          bOK = True
        ElseIf txtSend.Text.Substring(0, 1) = "/" Then
          bOK = True
        End If
        If bOK Then
          Dim I As Integer
          Do
            txtSend.Tag = txtSend.Tag - 1
            If txtSend.Tag = -1 Then txtSend.Tag = 9
            I += 1
          Loop While String.IsNullOrEmpty(LastTenCommands(txtSend.Tag)) And I < 10
          txtSend.Text = LastTenCommands(txtSend.Tag)
        End If
        e.Handled = True
        e.SuppressKeyPress = True
      ElseIf Not e.Shift And Not e.Alt And Not e.Control Then
        Dim bOK As Boolean = False
        If String.IsNullOrEmpty(txtSend.Text) Then
          bOK = True
        ElseIf txtSend.Text.Substring(0, 1) = "/" Then
          bOK = True
        End If
        If bOK Then
          Dim I As Integer
          Do
            txtSend.Tag = txtSend.Tag + 1
            If txtSend.Tag = 10 Then txtSend.Tag = 0
            I += 1
          Loop While String.IsNullOrEmpty(LastTenCommands(txtSend.Tag)) And I < 10
          txtSend.Text = LastTenCommands(txtSend.Tag)
        End If
        e.Handled = True
        e.SuppressKeyPress = True
      End If
      txtSend.SelectionStart = txtSend.Text.Length
      txtSend.SelectionLength = 0
    ElseIf e.KeyCode = Keys.V And e.Alt Then
      Config.Display.JoinLeave = Not Config.Display.JoinLeave
      SaveSettings(Index, Config)
      If Config.Display.JoinLeave Then
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, My.Resources.INFO_JOINLEAVE_ON)
      Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CONFIG, My.Resources.INFO_JOINLEAVE_OFF)
      End If
      e.Handled = True
      e.SuppressKeyPress = True
    End If
  End Sub

  Private Sub txtSend_KeyPress(sender As Object, e As KeyPressEventArgs) Handles txtSend.KeyPress
    If e.KeyChar = Chr(13) Then
      cmdSend.PerformClick()
      e.Handled = True
    End If
  End Sub

  Private Sub txtSend_KeyUp(sender As Object, e As KeyEventArgs) Handles txtSend.KeyUp
    If e.KeyCode = Keys.F2 Then
      Config.Display.TimeStampEnabled = Not Config.Display.TimeStampEnabled
      gChat.ToggleTimestamps(Config.Display.TimeStampEnabled)
      SaveSettings(Index, Config)
    End If
    ResetSendScrollbars()
  End Sub

  Private Sub ResetSendScrollbars()
    Dim iSelPos As Integer = txtSend.SelectionStart
    Dim bScroll As ScrollBars = IIf(txtSend.Lines.Length > 1 Or (txtSend.GetPositionFromCharIndex(0).Y <> txtSend.GetPositionFromCharIndex(txtSend.Text.Length - 1).Y), ScrollBars.Vertical, ScrollBars.None)
    If Not txtSend.ScrollBars = bScroll Then
      txtSend.ScrollBars = bScroll
      If Not txtSend.SelectionLength = 0 Then txtSend.SelectionLength = 0
      If Not txtSend.SelectionStart = iSelPos Then txtSend.SelectionStart = iSelPos
      txtSend.ScrollToCaret()
    End If
  End Sub

  Private Sub txtSend_MouseDown(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles txtSend.MouseDown
    Me.txtSend.ContextMenu = New ContextMenu
    Me.txtSend.ContextMenuStrip = New ContextMenuStrip
  End Sub

  Private Sub txtSend_MouseUp(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles txtSend.MouseUp
    If e.Button = Windows.Forms.MouseButtons.Right Then
      mnuSendUndo.Enabled = txtSend.CanUndo
      mnuSendCut.Enabled = txtSend.SelectionLength > 0
      mnuSendCopy.Enabled = txtSend.SelectionLength > 0
      mnuSendPaste.Enabled = Clipboard.ContainsText
      mnuSendDelete.Enabled = txtSend.SelectionLength > 0
      mnuSendAll.Enabled = txtSend.TextLength > 0
      mnuSendClear.Enabled = Join(LastTenCommands, String.Empty).Length > 0
      mnuSendBox.Show(txtSend, e.Location) ' MousePosition)
    End If
  End Sub

  Private Sub txtSend_MouseWheel(sender As Object, e As MouseEventArgs) Handles txtSend.MouseWheel
    gChat.ScrollTo(e.Delta)
  End Sub

  Public Sub SendMessage(Message As String)
    If Not String.IsNullOrEmpty(Message) Then
      If Message.StartsWith("//") Then
        SendCommand({Message.Substring(2), True})
      ElseIf Message.StartsWith("/") Then
        SendCommand({Message.Substring(1), False})
      Else
        QueueMessage(Message)
      End If
    End If
  End Sub

  Public Sub QueueMessage(Message As String)
    If Not (String.IsNullOrEmpty(Message) Or String.IsNullOrEmpty(BNetData.UniqueName)) And QueueList IsNot Nothing Then QueueList.AddMessage(Message)
  End Sub

  Private Sub cmdSend_Click(sender As Object, e As EventArgs) Handles cmdSend.Click
    If Not String.IsNullOrEmpty(txtSend.Text) Then
      Dim sMessage As String = txtSend.Text
      sMessage = sMessage.Replace(vbNewLine, vbLf)
      sMessage = sMessage.Replace(vbCr, vbLf)
      Do While sMessage.IndexOf(vbLf & vbLf) > 0
        sMessage = sMessage.Replace(vbLf & vbLf, vbLf)
      Loop
      If sMessage.StartsWith("/") Then
        Do While sMessage.IndexOf(";/") > 0
          sMessage = sMessage.Replace(";/", vbLf & "/")
        Loop
      End If
      sMessage = sMessage.Replace(vbLf, vbCr)
      If sMessage.IndexOf(vbCr) > -1 Then
        Dim sSplit() As String = Split(sMessage, vbCr)
        For Each sText As String In (From sItem As String In sSplit Where Not String.IsNullOrEmpty(sItem) Select (txtPre.Text & sItem))
          SendMessage(sText)
          If sText.StartsWith("/") Then AddToLastTen(sText)
        Next
      Else
        If sMessage.Length > 0 Then
          Dim sText As String = txtPre.Text & sMessage
          SendMessage(sText)
          If sText.StartsWith("/") Then AddToLastTen(sText)
        End If
      End If
      txtSend.Text = String.Empty
    End If
  End Sub

  Friend Sub SendCommand(Obj As Object)
    If Me.InvokeRequired Then
      Me.Invoke(New CallBack(AddressOf SendCommand), Obj)
    Else
      Dim sText As String = Obj(0)
      Dim bPublic As Boolean = Obj(1)
      Dim sCmd() As String
      If InStr(sText, " ") > 0 Then
        sCmd = Split(sText, " ", 2)
      Else
        ReDim sCmd(0)
        sCmd(0) = sText
      End If
      txtSend.Tag = 9
      Select Case sCmd(0).ToLower
        Case "j", "join", "ch", "channel"
          If sCmd.Length > 1 Then
            BNCS_JOINCHANNEL_Send(sCmd(1), JoinFlags.NoCreate)
          Else
            QueueMessage("/" & sText)
          End If
        Case "h", "home"
          If String.IsNullOrEmpty(Config.Account.HomeChannel) Then
            BNCS_JOINCHANNEL_Send(, IIf(Config.Account.Client.Product = GameType.D2DV Or Config.Account.Client.Product = GameType.D2XP, JoinFlags.D2First, JoinFlags.First))
          Else
            BNCS_JOINCHANNEL_Send(Config.Account.HomeChannel)
          End If
        Case "force", "fj", "fc"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H1002)
          Else
            BNCS_JOINCHANNEL_Send(sCmd(1))
          End If
        Case "op"
          BNCS_JOINCHANNEL_Send("Op " & Config.Account.Username)
        Case "rejoin"
          BNCS_LEAVECHAT_Send()
          BNCS_JOINCHANNEL_Send(lblChannel.Tag.ToString)
        Case "ping"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H1005)
          Else
            Dim sRet As String
            Dim gcType As GeckoChat.ChatType
            Dim iPos As Integer = ChanList.FindItem(sCmd(1))
            If iPos = -1 Then
              sRet = ResString(My.Resources.ERR_USER_NOTHERE, sCmd(1))
              gcType = GeckoChat.ChatType.ServiceError
            Else
              sRet = ResString(My.Resources.INFO_PING, ChanList.Username(iPos), IIf(ChanList.Ping(iPos) < 4294967295, ChanList.Ping(iPos).ToString, "-1"))
              gcType = GeckoChat.ChatType.ServiceSuccess
            End If
            If bPublic Then
              QueueMessage(sRet)
            Else
              gChat.AddChat(gcType, String.Empty, sRet)
            End If
          End If
        Case "info"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H1006)
          Else
            Dim sRet As String
            Dim gcType As GeckoChat.ChatType
            Dim iPos As Integer = ChanList.FindItem(sCmd(1))
            If iPos = -1 Then
              sRet = ResString(My.Resources.ERR_USER_NOTHERE, sCmd(1))
              gcType = GeckoChat.ChatType.ServiceError
            Else
              sRet = ResString(My.Resources.INFO_STATSTRING, ChanList.Username(iPos), ParseStatString(Encoding.GetEncoding(LATIN_1).GetString(ChanList.StatString(iPos))))
              gcType = GeckoChat.ChatType.ServiceSuccess
            End If
            If bPublic Then
              QueueMessage(sRet)
            Else
              Dim sMsgs() As String = Split(sRet, vbNewLine)
              For Each sItem As String In (From sItm As String In sMsgs Where Not String.IsNullOrEmpty(sItm))
                gChat.AddChat(gcType, String.Empty, sItem)
              Next
            End If
          End If
        Case "record"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H1007)
          Else
            Dim sProd As String = Config.Account.Client.Product.ToString
            If InStr(sCmd(1), " ") Then
              sProd = sCmd(1).Split(" ")(1)
              sCmd(1) = sCmd(1).Split(" ")(0)
            End If
            GetUserData(sCmd(1), ProfileRequests.ProfileRequestType.NormalGameRecord, IIf(bPublic, ProfileRequests.ProfileRequestDisplay.PublicChat, ProfileRequests.ProfileRequestDisplay.PrivateText), sProd)
            GetUserData(sCmd(1), ProfileRequests.ProfileRequestType.LadderGameRecord, IIf(bPublic, ProfileRequests.ProfileRequestDisplay.PublicChat, ProfileRequests.ProfileRequestDisplay.PrivateText), sProd)
            If sProd.ToUpper = "W2BN" Then
              Thread.Sleep(1000)
              GetUserData(sCmd(1), ProfileRequests.ProfileRequestType.IronManGameRecord, IIf(bPublic, ProfileRequests.ProfileRequestDisplay.PublicChat, ProfileRequests.ProfileRequestDisplay.PrivateText), sProd)
            End If
          End If
        Case "profile"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H1008)
          Else
            Dim bStatString() As Byte = ChanList.StatString(sCmd(1))
            If bStatString IsNot Nothing Then
              Dim sClient As String = StrReverse(System.Text.Encoding.GetEncoding(LATIN_1).GetString(bStatString).Substring(0, 4))
              GetUserData(sCmd(1), ProfileRequests.ProfileRequestType.UserProfile, IIf(bPublic, ProfileRequests.ProfileRequestDisplay.PublicChat, ProfileRequests.ProfileRequestDisplay.PrivateText), sClient)
            Else
              GetUserData(sCmd(1), ProfileRequests.ProfileRequestType.UserProfile, IIf(bPublic, ProfileRequests.ProfileRequestDisplay.PublicChat, ProfileRequests.ProfileRequestDisplay.PrivateText))
            End If
          End If
        Case "invite"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H1009)
          Else
            If Config.Account.Client.Product = GameType.WAR3 Or Config.Account.Client.Product = GameType.W3XP Then
              BNCS_CLANINVITATION_Send(IIf(bPublic, &H2, &H1), sCmd(1))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, ResString(My.Resources.CLAN_INVITATION_NOTW3, TITLE_WAR3, TITLE_W3XP))
            End If
          End If
        Case "server"
          If IsOnline Then
            If bPublic Then
              QueueMessage(ResString(My.Resources.INFO_SERVER, BNetData.ServerIP.ToString))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, String.Empty, ResString(My.Resources.INFO_SERVER, BNetData.ServerIP.ToString))
            End If
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, My.Resources.ERR_SERVER_OFFLINE)
          End If
        Case "tagsquelch"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H100B)
          Else
            Select Case TagSquelchUser(sCmd(1), True)
              Case 0 'Added
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.INFO_TAGSQUELCH_ADDED, sCmd(1)))
              Case 1 'Already exists
                gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, ResString(My.Resources.ERR_TAGSQUELCH_ALREADY, sCmd(1)))
              Case 2 'Failure
                gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, ResString(My.Resources.ERR_TAGSQUELCH_NO_ADD, sCmd(1)))
            End Select
          End If
        Case "tagunsquelch"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H100C)
          Else
            Select Case TagSquelchUser(sCmd(1), False)
              Case 0 'Added
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.INFO_TAGSQUELCH_REMOVED, sCmd(1)))
              Case 1 'Already exists
                gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, ResString(My.Resources.ERR_TAGSQUELCH_NOT, sCmd(1)))
              Case 2 'Failure
                gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, ResString(My.Resources.ERR_TAGSQUELCH_NO_REMOVE, sCmd(1)))
            End Select
          End If
        Case "games"
          If bPublic Then ChatData.PubGameList = bPublic
          BNCS_GETADVLISTEX_Send(0, 0, IIf(Config.Account.Client.Product = GameType.STAR Or Config.Account.Client.Product = GameType.SEXP Or Config.Account.Client.Product = GameType.JSTR Or Config.Account.Client.Product = GameType.SSHR, &H30, 0), 0, 35, Nothing, Nothing, Nothing)
        Case "game"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H100E)
          Else
            If bPublic Then ChatData.PubGameList = bPublic
            Dim sName As String = sText.Substring(sCmd(0).Length + 1)
            If sName.Contains("|"c) Then
              Dim sPass As String = sName.Split("|"c)(1)
              sName = sName.Split("|"c)(0)
              BNCS_GETADVLISTEX_Send(0, 0, IIf(Config.Account.Client.Product = GameType.STAR Or Config.Account.Client.Product = GameType.SEXP Or Config.Account.Client.Product = GameType.JSTR Or Config.Account.Client.Product = GameType.SSHR, &H30, 0), 0, 1, sName, sPass, Nothing)
            Else
              BNCS_GETADVLISTEX_Send(0, 0, IIf(Config.Account.Client.Product = GameType.STAR Or Config.Account.Client.Product = GameType.SEXP Or Config.Account.Client.Product = GameType.JSTR Or Config.Account.Client.Product = GameType.SSHR, &H30, 0), 0, 1, sName, Nothing, Nothing)
            End If
          End If
        Case "r", "reply", "respond"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H2001)
          Else
            If String.IsNullOrEmpty(ChatData.LastWhisper) Then
              gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, My.Resources.ERR_NOREPLY)
            Else
              SendMessage("/w " & ChatData.LastWhisper & " " & sCmd(1))
            End If
          End If
        Case "shout"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H2002)
          Else
            QueueMessage(sCmd(1).ToUpper)
          End If
        Case "expand"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H2003)
          Else
            Dim sExpanded = sCmd(1).Substring(0, 1)
            For I As Integer = 1 To sCmd(1).Length - 1
              sExpanded &= " " & sCmd(1).Substring(I, 1)
            Next I
            QueueMessage(sExpanded)
          End If
        Case "reverse"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H2004)
          Else
            QueueMessage(StrReverse(sCmd(1)))
          End If
        Case "sc"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H2005)
          Else
            If Config.Account.Client.Product = GameType.DRTL Or Config.Account.Client.Product = GameType.DSHR Or Config.Account.Client.Product = GameType.SSHR Then
              BNCS_ENTERCHAT_Send(Config.Account.Client.Product.ToString & " " & sCmd(1))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, ResString(My.Resources.ERR_NOSTATCHAT, TITLE_DRTL, TITLE_DSHR, TITLE_SSHR))
            End If
          End If
        Case "mimic"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H2006)
          Else
            ChatData.MimicUser = sCmd(1)
            If bPublic Then
              QueueMessage(ResString(My.Resources.INFO_MIMIC_ON, sCmd(1)))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_MIMIC_ON, sCmd(1)))
            End If
          End If
        Case "nomimic"
          ChatData.MimicUser = Nothing
          If bPublic Then
            QueueMessage(My.Resources.INFO_MIMIC_OFF)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CONFIG, My.Resources.INFO_MIMIC_OFF)
          End If
        Case "w", "whisper", "m", "msg"
          If sCmd.Length > 1 Then
            If sCmd(1).Contains(" ") Then
              Dim sWhis() As String = Split(sCmd(1), " ", 2)
              Dim sBegin As String = "/" & sCmd(0) & " " & IIf(Config.Account.Client.Product = GameType.D2DV Or Config.Account.Client.Product = GameType.D2XP, "*", String.Empty) & sWhis(0) & " "
              For Each sMsg As String In MakeChunks(sWhis(1), sBegin)
                QueueMessage(sMsg)
              Next
            Else
              QueueMessage("/" & sText)
            End If
          Else
            QueueMessage("/" & sText)
          End If
        Case "squelch", "ignore", "unsquelch", "unignore", "whois", "whereis", "where"
          If sCmd.Length > 1 Then
            QueueMessage("/" & sCmd(0) & " " & IIf(Config.Account.Client.Product = GameType.D2DV Or Config.Account.Client.Product = GameType.D2XP, "*", String.Empty) & sCmd(1))
          Else
            QueueMessage("/" & sText)
          End If
        Case "time"
          If bPublic Then
            QueueMessage(ResString(My.Resources.INFO_TIME, Now.ToString("T"), Now.ToString("D"), Now.ToString("zzz")))
          Else
            QueueMessage("/" & sText)
          End If
        Case "away"
          If sCmd.Length = 2 AndAlso sCmd(1) = "Idle" Then
            QueueMessage("/" & sText)
            ChatData.IsAway = sCmd(1)
          ElseIf sCmd.Length = 1 AndAlso ChatData.IsAway = "Idle" Then
            QueueMessage("/" & sText)
            ChatData.IsAway = Nothing
          ElseIf String.IsNullOrEmpty(ChatData.IsAway) Then
            If sCmd.Length = 2 Then
              If Config.Display.PubAway Or bPublic Then QueueMessage("/me " & My.Resources.INFO_AWAY & " [" & sCmd(1) & "]")
              ChatData.IsAway = sCmd(1)
            Else
              If Config.Display.PubAway Or bPublic Then QueueMessage("/me " & My.Resources.INFO_AWAY)
              ChatData.IsAway = " "
            End If
            QueueMessage("/" & sText)
          Else
            QueueMessage("/" & sText)
            If Config.Display.PubAway Or bPublic Then
              If ChatData.IsAway = " " Then
                QueueMessage("/me " & My.Resources.INFO_NOTAWAY)
              Else
                QueueMessage("/me " & My.Resources.INFO_NOTAWAY & " [" & ChatData.IsAway & "]")
              End If
            Else
              QueueMessage("/" & sText)
            End If
            ChatData.IsAway = Nothing
          End If
        Case "dnd"
          If String.IsNullOrEmpty(ChatData.IsDnD) Then
            If sCmd.Length = 2 Then
              If Config.Display.PubAway Or bPublic Then QueueMessage("/me " & My.Resources.INFO_DND & " [" & sCmd(1) & "]")
              ChatData.IsDnD = sCmd(1)
            Else
              If Config.Display.PubAway Or bPublic Then QueueMessage("/me " & My.Resources.INFO_DND)
              ChatData.IsDnD = " "
            End If
            QueueMessage("/" & sText)
          Else
            QueueMessage("/" & sText)
            If Config.Display.PubAway Or bPublic Then
              If ChatData.IsDnD = " " Then
                QueueMessage("/me " & My.Resources.INFO_NOTDND)
              Else
                QueueMessage("/me " & My.Resources.INFO_NOTDND & " [" & ChatData.IsDnD & "]")
              End If
            End If
            ChatData.IsDnD = Nothing
          End If
        Case "v", "ver", "version"
          If bPublic Then
            QueueMessage("/me " & ResString(My.Resources.INFO_VER_EMOTE, Version))
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.INFO_VER, Version))
          End If
        Case "useragent"
          If bPublic Then
            QueueMessage(UserAgent)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, UserAgent)
          End If
        Case "uptime"
          If bPublic Then
            QueueMessage(ResString(My.Resources.INFO_UPTIME, ConvertTime(Environment.TickCount)))
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.INFO_UPTIME, ConvertTime(Environment.TickCount)))
          End If
        Case "onlinetime"
          If bPublic Then
            QueueMessage(ResString(My.Resources.INFO_ONLINETIME, ConvertTime(Environment.TickCount - ChatData.LoginTime)))
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.INFO_ONLINETIME, ConvertTime(Environment.TickCount - ChatData.LoginTime)))
          End If
        Case "loggedtime"
          If bPublic Then
            QueueMessage(ResString(My.Resources.INFO_LOGGEDTIME, ConvertTime((ChatData.TimeLogged * 1000) + (Environment.TickCount - ChatData.LoginTime))))
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.INFO_LOGGEDTIME, ConvertTime((ChatData.TimeLogged * 1000) + (Environment.TickCount - ChatData.LoginTime))))
          End If
        Case "specs"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H3005)
          Else
            Dim Specs As New SystemInfo
            Dim sDisplay As String = String.Empty
            Select Case sCmd(1).ToLower
              Case "os", "operating system"
                sDisplay = Specs.OperatingSystem
              Case "cpu", "processor", "core"
                sDisplay = Specs.Processor
              Case "mobo", "motherboard", "mainboard"
                sDisplay = Specs.Motherboard
              Case "ram", "memory"
                sDisplay = Specs.Memory
              Case "disk", "drive", "disks", "drives", "hdd"
                sDisplay = Specs.Drives
              Case "video", "vid", "gfx", "graphics", "display"
                sDisplay = Specs.Video
              Case "audio", "aud", "sound"
                sDisplay = Specs.Audio
              Case "all"
                sDisplay = Specs.OperatingSystem & vbNewLine & Specs.Processor & vbNewLine & Specs.Motherboard & vbNewLine & Specs.Memory & vbNewLine & Specs.Drives & vbNewLine & Specs.Video & vbNewLine & Specs.Audio
              Case Else
                sDisplay = My.Resources.ERR_SPECS
            End Select
            If bPublic Then
              QueueMessage(sDisplay)
            Else
              Dim sMsgs() As String = Split(sDisplay, vbNewLine)
              For Each sItem As String In (From sItm As String In sMsgs Where Not String.IsNullOrEmpty(sItm))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, sItem)
              Next
            End If
          End If
        Case "math"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H3006)
          Else
            Dim sRet As String
            Dim gcType As GeckoChat.ChatType = GeckoChat.ChatType.ServiceInfo
            Try
              sRet = sCmd(1) & " = " & EvaluateExpression(sCmd(1)).ToString
            Catch ex As Exception
              sRet = ex.Message
              gcType = GeckoChat.ChatType.ServiceError
            End Try
            If bPublic Then
              QueueMessage(sRet)
            Else
              gChat.AddChat(gcType, String.Empty, sRet)
            End If
          End If
        Case "pinghost"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H3007)
          Else
            Dim sRet As String
            Dim gcType As GeckoChat.ChatType = GeckoChat.ChatType.ServiceInfo
            Dim HostIP As String
            Try
              HostIP = Dns.GetHostAddresses(sCmd(1)).FirstOrDefault.ToString
              If HostIP = sCmd(1) Then HostIP = Dns.GetHostEntry(sCmd(1)).HostName
            Catch ex As Exception
              HostIP = Nothing
            End Try
            If String.IsNullOrEmpty(HostIP) Then
              sRet = ResString(My.Resources.ERR_PINGHOST_UNRESOLVED, sCmd(1))
              gcType = GeckoChat.ChatType.ServiceError
            Else
              Dim lTime As Long = Environment.TickCount
              If My.Computer.Network.Ping(sCmd(1), 5000) Then
                sRet = ResString(My.Resources.INFO_PINGHOST_RESPONSE, sCmd(1) & IIf(StrComp(sCmd(1), HostIP, CompareMethod.Text) <> 0, " [" & HostIP & "]", String.Empty), (Environment.TickCount - lTime))
                gcType = GeckoChat.ChatType.ServiceSuccess
              Else
                sRet = ResString(My.Resources.ERR_PINGHOST_UNRESPONSIVE, sCmd(1) & IIf(StrComp(sCmd(1), HostIP, CompareMethod.Text) <> 0, " [" & HostIP & "]", String.Empty))
                gcType = GeckoChat.ChatType.ServiceInfo
              End If
            End If
            If bPublic Then
              QueueMessage(sRet)
            Else
              gChat.AddChat(gcType, String.Empty, sRet)
            End If
          End If
        Case "convert"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H3008)
          Else
            Dim sRet As String = ResString(My.Resources.CONVERT_ERROR, sCmd(1))
            If sCmd(1).Contains(" ") Then
              Dim sConv() As String = Split(sCmd(1), , 2)
              Select Case sConv(0).ToLower
                Case "b-d" : sRet = ResString(My.Resources.CONVERT_RESULT, BtoD(sConv(1)))
                Case "b-h" : sRet = ResString(My.Resources.CONVERT_RESULT, BtoH(sConv(1)))
                Case "b-t" : sRet = ResString(My.Resources.CONVERT_RESULT, BtoT(sConv(1)))
                Case "d-b" : sRet = ResString(My.Resources.CONVERT_RESULT, DtoB(sConv(1)))
                Case "d-h" : sRet = ResString(My.Resources.CONVERT_RESULT, DtoH(sConv(1)))
                Case "d-t" : sRet = ResString(My.Resources.CONVERT_RESULT, DtoT(sConv(1)))
                Case "h-b" : sRet = ResString(My.Resources.CONVERT_RESULT, HtoB(sConv(1)))
                Case "h-d" : sRet = ResString(My.Resources.CONVERT_RESULT, HtoD(sConv(1)))
                Case "h-t" : sRet = ResString(My.Resources.CONVERT_RESULT, HtoT(sConv(1)))
                Case "t-b" : sRet = ResString(My.Resources.CONVERT_RESULT, TtoB(sConv(1)))
                Case "t-d" : sRet = ResString(My.Resources.CONVERT_RESULT, TtoD(sConv(1)))
                Case "t-h" : sRet = ResString(My.Resources.CONVERT_RESULT, TtoH(sConv(1)))
              End Select
            End If
            If bPublic Then
              QueueMessage(sRet)
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, sRet)
            End If
          End If
        Case "cq"
          If QueueList IsNot Nothing Then QueueList.ClearQueue()
        Case "cls"
          gChat.Clear()
        Case "restat"
          Dim sChannel As String = lblChannel.Tag.ToString
          BNCS_LEAVECHAT_Send()
          BNCS_ENTERCHAT_Send()
          BNCS_JOINCHANNEL_Send(sChannel)
        Case "quit"
          frmMain.Close()
        Case "sethome"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4101)
          Else
            Config.Account.HomeChannel = sCmd(1)
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SETHOME, Config.Account.HomeChannel))
          End If
        Case "setnohome"
          Config.Account.HomeChannel = String.Empty
          SaveSettings(Index, Config)
          gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, My.Resources.INFO_SETHOME_DEFAULT)
        Case "setname"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4102)
          Else
            Config.Account.Username = sCmd(1)
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_USERNAME, Config.Account.Username))
          End If
        Case "setpass"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4103)
          Else
            Config.Account.Password = sCmd(1)
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_PASSWORD, Config.Account.Password))
          End If
        Case "setgame", "setprod", "setproduct"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4104)
          Else
            Config.Account.Client.Product = GameStringToGameType(sCmd(1))
            Config.VerByte = ReadVerbyte(Config.Account.Client.Product)
            If Config.VerByte = 0 Then GetVerByte()
            Dim xKey As Xml.Linq.XElement = (From CDKey As Xml.Linq.XElement In GetCDKeys(False) Where CDKey.Name.LocalName = GetProd.ToString Select CDKey).FirstOrDefault
            Config.Account.Client.CDKey = GrabKeyStruct(xKey)
            xKey = (From EXPKey As Xml.Linq.XElement In GetCDKeys(True) Where EXPKey.Name.LocalName = Config.Account.Client.Product.ToString Select EXPKey).FirstOrDefault
            Config.Account.Client.EXPKey = GrabKeyStruct(xKey)
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_PRODUCT, GameTypeToGameTitle(Config.Account.Client.Product)))
          End If
        Case "listkeys", "keylist"
          Dim KeyList = From CDKey As Xml.Linq.XElement In GetCDKeys(False) Where CDKey.Name.LocalName = GetProd.ToString Select CDKey
          If KeyList.Count > 0 Then
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_LIST_CDKEY, GameTypeToGameTitle(Config.Account.Client.Product)))
            For I As Integer = 0 To KeyList.Count - 1
              Dim tmpKey As ProductKey = GrabKeyStruct(KeyList(I))
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, (I + 1) & ": " & New clsKey(tmpKey).Key)
            Next
          End If
          Dim EXPList = From EXPKey As Xml.Linq.XElement In GetCDKeys(True) Where EXPKey.Name.LocalName = Config.Account.Client.Product.ToString Select EXPKey
          If EXPList.Count > 0 Then
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_LIST_EXPKEY, GameTypeToGameTitle(Config.Account.Client.Product)))
            For I As Integer = 0 To EXPList.Count - 1
              Dim tmpKey As ProductKey = GrabKeyStruct(EXPList(I))
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, (I + 1) & ": " & New clsKey(tmpKey).Key)
            Next
          End If
        Case "setcdkey"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4106)
          Else
            Dim KeyRet = (From CDKey As Xml.Linq.XElement In GetCDKeys(False) Where StrComp(CDLegal(New clsKey(GrabKeyStruct(CDKey)).Key), CDLegal(sCmd(1)), CompareMethod.Text) = 0 Select CDKey).FirstOrDefault
            If KeyRet IsNot Nothing Then
              Config.Account.Client.CDKey = GrabKeyStruct(KeyRet)
              SaveSettings(Index, Config)
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_CDKEY, New clsKey(Config.Account.Client.CDKey).Key))
            Else
              Dim Key As New clsKey(CDLegal(sCmd(1)))
              If Key.IsValid Then
                If ProdMatch(Config.Account.Client.Product, Key.Product, False) Then
                  Dim sKey As New clsKey(sCmd(1))
                  Config.Account.Client.CDKey.ProductVal = sKey.Product
                  Config.Account.Client.CDKey.PublicVal = sKey.PublicVal
                  Config.Account.Client.CDKey.PrivateVal = sKey.PrivateVal
                  Config.Account.Client.CDKey.PrivateVal26 = sKey.PrivateVal26
                  SaveSettings(Index, Config)
                  gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_CDKEY, New clsKey(Config.Account.Client.CDKey).Key))
                Else
                  gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.ERR_SET_CDKEY_PROD, sCmd(1), GameTypeToGameTitle(Config.Account.Client.Product)))
                End If
              Else
                gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.ERR_SET_CDKEY_VALID, sCmd(1)))
              End If
            End If
          End If
        Case "setexpkey"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4107)
          Else
            Dim KeyRet = (From CDKey As Xml.Linq.XElement In GetCDKeys(True) Where StrComp(CDLegal(New clsKey(GrabKeyStruct(CDKey)).Key), CDLegal(sCmd(1)), CompareMethod.Text) = 0 Select CDKey).FirstOrDefault
            If KeyRet IsNot Nothing Then
              Config.Account.Client.EXPKey = GrabKeyStruct(KeyRet)
              SaveSettings(Index, Config)
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_EXPKEY, New clsKey(Config.Account.Client.CDKey).Key))
            Else
              Dim Key As New clsKey(CDLegal(sCmd(1)))
              If Key.IsValid Then
                If ProdMatch(Config.Account.Client.Product, Key.Product, True) Then
                  Dim sKey As New clsKey(sCmd(1))
                  Config.Account.Client.EXPKey.ProductVal = sKey.Product
                  Config.Account.Client.EXPKey.PublicVal = sKey.PublicVal
                  Config.Account.Client.EXPKey.PrivateVal = sKey.PrivateVal
                  Config.Account.Client.EXPKey.PrivateVal26 = sKey.PrivateVal26
                  SaveSettings(Index, Config)
                  gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_EXPKEY, New clsKey(Config.Account.Client.CDKey).Key))
                Else
                  gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.ERR_SET_EXPKEY_PROD, sCmd(1), GameTypeToGameTitle(Config.Account.Client.Product)))
                End If
              Else
                gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.ERR_SET_EXPKEY_VALID, sCmd(1)))
              End If
            End If
          End If
        Case "setstatstring"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4108)
          Else
            Config.Account.StatString = sCmd(1)
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_STATSTRING, Config.Account.StatString))
          End If
        Case "setserver"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4109)
          Else
            Config.Server = sCmd(1)
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_SERVER, Config.Server))
          End If
        Case "setudp"
          If sCmd.Length = 1 OrElse (StrComp(sCmd(1), "on", CompareMethod.Text) <> 0 And StrComp(sCmd(1), "off", CompareMethod.Text) <> 0) Then
            ShowHelp(Me, &H410A)
          Else
            Config.Account.Client.UDPPlug = StrComp(sCmd(1), "on", CompareMethod.Text) = 0
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, IIf(Config.Account.Client.UDPPlug, My.Resources.INFO_SET_UDP_ON, My.Resources.INFO_SET_UDP_OFF))
          End If
        Case "setspawn"
          If sCmd.Length = 1 OrElse (StrComp(sCmd(1), "on", CompareMethod.Text) <> 0 And StrComp(sCmd(1), "off", CompareMethod.Text) <> 0) Then
            ShowHelp(Me, &H410B)
          Else
            Config.Account.Client.Spawn = StrComp(sCmd(1), "on", CompareMethod.Text) = 0
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, IIf(Config.Account.Client.Spawn, My.Resources.INFO_SET_SPAWN_ON, My.Resources.INFO_SET_SPAWN_OFF))
          End If
        Case "setping"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H410C)
          Else
            Select Case sCmd(1)
              Case "-1"
                Config.PingSpoof = 0
              Case "0"
                Config.PingSpoof = 1
              Case "low"
                Config.PingSpoof = 2
              Case "norm", "normal"
                Config.PingSpoof = 3
              Case Else
                If IsNumeric(sCmd(1)) Then
                  Config.PingSpoof = sCmd(1)
                Else
                  ShowHelp(Me, &H410C)
                  Exit Sub
                End If
            End Select
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_PING, sCmd(1)))
          End If
        Case "setrealm"
          If sCmd.Length = 1 OrElse (StrComp(sCmd(1), "on", CompareMethod.Text) <> 0 And StrComp(sCmd(1), "off", CompareMethod.Text) <> 0) Then
            ShowHelp(Me, &H410D)
          Else
            Config.Account.Client.D2Realm = StrComp(sCmd(1), "on", CompareMethod.Text) = 0
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, IIf(Config.Account.Client.D2Realm, My.Resources.INFO_SET_REALM_ON, My.Resources.INFO_SET_REALM_OFF))
            If Config.Account.Client.Product = GameType.D2DV Or Config.Account.Client.Product = GameType.D2XP Then
              If Config.Account.Client.D2Realm Then
                If Not tbsLists.TabPages.Contains(tabRealm) Then TabAdd(tabRealm)
              Else
                If tbsLists.TabPages.Contains(tabRealm) Then TabRemove(tabRealm)
              End If
            End If
          End If
        Case "pubaway"
          If sCmd.Length = 1 OrElse (StrComp(sCmd(1), "on", CompareMethod.Text) <> 0 And StrComp(sCmd(1), "off", CompareMethod.Text) <> 0) Then
            ShowHelp(Me, &H410E)
          Else
            Config.Display.PubAway = StrComp(sCmd(1), "on", CompareMethod.Text) = 0
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, IIf(Config.Display.PubAway, My.Resources.INFO_SET_PUBAWAY_ON, My.Resources.INFO_SET_PUBAWAY_OFF))
          End If
        Case "idle"
          If sCmd.Length = 1 OrElse (StrComp(sCmd(1), "on", CompareMethod.Text) <> 0 And StrComp(sCmd(1), "off", CompareMethod.Text) <> 0) Then
            ShowHelp(Me, &H4201)
          Else
            Config.Idle.IdleOn = StrComp(sCmd(1), "on", CompareMethod.Text) = 0
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, IIf(Config.Idle.IdleOn, My.Resources.INFO_SET_IDLE_ON, My.Resources.INFO_SET_IDLE_OFF))
          End If
        Case "idletype"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4202)
          Else
            Select Case sCmd(1)
              Case "uptime", "up"
                Config.Idle.IdleText = "/me Uptime [Sys: %u][Bot: %b][Net: %o]"
                SaveSettings(Index, Config)
                gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, My.Resources.INFO_SET_IDLE_UPTIME)
              Case "version", "ver"
                Config.Idle.IdleText = "/me is running %v"
                SaveSettings(Index, Config)
                gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, My.Resources.INFO_SET_IDLE_VER)
              Case "song", "mp3"
                Config.Idle.IdleText = "/me is listening to %s"
                SaveSettings(Index, Config)
                gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, My.Resources.INFO_SET_IDLE_SONG)
              Case "text"
                Config.Idle.IdleText = Nothing
                SaveSettings(Index, Config)
                gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, My.Resources.INFO_SET_IDLE_TEXT)
              Case Else
                ShowHelp(Me, &H4202)
            End Select
          End If
        Case "idletime"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4203)
          Else
            If IsNumeric(sCmd(1)) Then
              Config.Idle.IdleOnSong = False
              Config.Idle.IdleTime = sCmd(1)
              SaveSettings(Index, Config)
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_IDLE_TIME, Config.Idle.IdleTime))
            Else
              ShowHelp(Me, &H4203)
            End If
          End If
        Case "idlesong"
          If sCmd.Length = 1 OrElse (StrComp(sCmd(1), "on", CompareMethod.Text) <> 0 And StrComp(sCmd(1), "off", CompareMethod.Text) <> 0) Then
            ShowHelp(Me, &H4204)
          Else
            Config.Idle.IdleOnSong = StrComp(sCmd(1), "on", CompareMethod.Text) = 0
            SaveSettings(Index, Config)
            If Config.Idle.IdleOnSong Then
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, My.Resources.INFO_SET_IDLE_TIME_SONG)
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_IDLE_TIME, Config.Idle.IdleTime))
            End If
          End If
        Case "idletext"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4205)
          Else
            Config.Idle.IdleText = sCmd(1)
            SaveSettings(Index, Config)
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SET_IDLE_TEXT_MSG, Config.Idle.IdleText))
          End If
        Case "quote"
          If My.Computer.FileSystem.FileExists(AppData & "\Quotes.txt") Then
            Dim sQuotes() As String = Split(My.Computer.FileSystem.ReadAllText(AppData & "\Quotes.txt"), vbNewLine)
            Dim lQuote As Integer = Int(Rnd() * sQuotes.Length)
            If bPublic Then
              QueueMessage(sQuotes(lQuote))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, sQuotes(lQuote))
            End If
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, My.Resources.ERR_QUOTES_NOLIST)
          End If
        Case "findq"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4302)
          Else
            If My.Computer.FileSystem.FileExists(AppData & "\Quotes.txt") Then
              Dim sQuotes() As String = Split(My.Computer.FileSystem.ReadAllText(AppData & "\Quotes.txt"), vbNewLine)
              Dim sFound As String = (From sQuote As String In sQuotes Where InStr(sQuote, sCmd(1), CompareMethod.Text) > 0 Select sQuote)(0)
              If String.IsNullOrEmpty(sFound) Then
                gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, ResString(My.Resources.ERR_QUOTES_NOFIND, sCmd(1)))
              Else
                If bPublic Then
                  QueueMessage(sFound)
                Else
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, sFound)
                End If
              End If
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, My.Resources.ERR_QUOTES_NOLIST)
            End If
          End If
        Case "addq"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4303)
          Else
            If My.Computer.FileSystem.FileExists(AppData & "\Quotes.txt") Then
              My.Computer.FileSystem.WriteAllText(AppData & "\Quotes.txt", vbNewLine & sCmd(1), True)
            Else
              My.Computer.FileSystem.WriteAllText(AppData & "\Quotes.txt", sCmd(1), False)
            End If
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, String.Empty, ResString(My.Resources.INFO_QUOTES_ADD, sCmd(1)))
          End If
        Case "quoteuser"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H4304)
          Else
            Dim lUser As Integer = ChanList.FindItem(sCmd(1))
            If lUser > -1 Then
              Dim sQuote As String = ChanList.LastMessageOf(lUser)
              If String.IsNullOrEmpty(sQuote) Then
                gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, ResString(My.Resources.ERR_QUOTES_USER_SILENT, ChanList.Username(lUser)))
              Else
                sQuote = ChanList.Username(lUser) & ": " & sQuote
                If My.Computer.FileSystem.FileExists(AppData & "\Quotes.txt") Then
                  My.Computer.FileSystem.WriteAllText(AppData & "\Quotes.txt", vbNewLine & sQuote, True)
                Else
                  My.Computer.FileSystem.WriteAllText(AppData & "\Quotes.txt", sQuote, False)
                End If
                gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, String.Empty, ResString(My.Resources.INFO_QUOTES_ADD, sQuote))
              End If
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, My.Resources.ERR_QUOTES_USER_NO)
            End If
          End If
        Case "flip"
          If bPublic Then
            QueueMessage("/me " & ResString(My.Resources.INFO_FLIP_PUB, IIf(CBool(Rnd() > 0.5), My.Resources.INFO_FLIP_HEADS, My.Resources.INFO_FLIP_TAILS)))
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.INFO_FLIP_PRIV, IIf(CBool(Rnd() > 0.5), My.Resources.INFO_FLIP_HEADS, My.Resources.INFO_FLIP_TAILS)))
          End If
        Case "roll"
          If sCmd.Length = 1 Then
            If bPublic Then
              QueueMessage("/me " & ResString(My.Resources.INFO_ROLL_PUB, 6, (RandomUInt64(6) + 1)))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.INFO_ROLL_PRIV, 6, (RandomUInt64(6) + 1)))
            End If
          Else
            If sCmd(1).Contains("d") Then
              Dim iDice, iSides As UInt64
              If sCmd(1).StartsWith("d") Then sCmd(1) = "1" & sCmd(1)
              If UInt64.TryParse(sCmd(1).Split("d")(0), iDice) And UInt64.TryParse(sCmd(1).Split("d")(1), iSides) Then
                If iDice >= 10000 Then
                  If bPublic Then
                    QueueMessage("/me " & ResString(My.Resources.ERR_ROLL_MAX_PUB, iDice))
                  Else
                    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.ERR_ROLL_MAX_PRIV, iDice))
                  End If
                Else
                  Dim sRets(iDice - 1) As String
                  Dim iTotal As UInt64
                  For I As Integer = 0 To iDice - 1
                    sRets(I) = (RandomUInt64(iSides) + 1).ToString
                    iTotal += UInt64.Parse(sRets(I))
                  Next
                  If bPublic Then
                    QueueMessage("/me " & ResString(My.Resources.INFO_ROLLS_PUB, iDice, iSides, Join(sRets, ", "), iTotal))
                  Else
                    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.INFO_ROLLS_PRIV, iDice, iSides, Join(sRets, ", "), iTotal))
                  End If
                End If
              Else
                If bPublic Then
                  QueueMessage("/me " & ResString(My.Resources.ERR_ROLL_PARSE_PUB, sCmd(1)))
                Else
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.ERR_ROLL_PARSE_PRIV, sCmd(1)))
                End If
              End If
            Else
              Dim iSides As UInt64
              If UInt64.TryParse(sCmd(1), iSides) Then
                If bPublic Then
                  QueueMessage("/me " & ResString(My.Resources.INFO_ROLL_PUB, iSides, (RandomUInt64(iSides) + 1)))
                Else
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.INFO_ROLL_PRIV, iSides, (RandomUInt64(iSides) + 1)))
                End If
              Else
                If bPublic Then
                  QueueMessage("/me " & ResString(My.Resources.ERR_ROLL_PARSE_PUB, sCmd(1)))
                Else
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.ERR_ROLL_PARSE_PRIV, sCmd(1)))
                End If
              End If
            End If
          End If
        Case "song", "mp3"
          If bPublic Then
            QueueMessage("/me " & ResString(My.Resources.MPLAYER_SONG_PUB, MPControls.GetSong))
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, String.Empty, ResString(My.Resources.MPLAYER_SONG_PRIV, MPControls.GetSong))
          End If
        Case "loadplayer"
          If bPublic Then
            QueueMessage(MPControls.Load)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.Load)
          End If
        Case "closeplayer"
          If bPublic Then
            QueueMessage(MPControls.Close)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.Close)
          End If
        Case "play"
          If sCmd.Length = 1 Then
            If bPublic Then
              QueueMessage(MPControls.MPlay)
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.MPlay)
            End If
          Else
            Dim sTmp(sCmd.Length - 2) As String
            Array.ConstrainedCopy(sCmd, 1, sTmp, 0, sCmd.Length - 1)
            Dim sFile As String = Join(sTmp)
            If bPublic Then
              QueueMessage(MPControls.JumpToFile(sFile))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.JumpToFile(sFile))
            End If
          End If
        Case "opensong"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H5010)
          Else
            Dim sTmp(sCmd.Length - 2) As String
            Array.ConstrainedCopy(sCmd, 1, sTmp, 0, sCmd.Length - 1)
            Dim sFile As String = Join(sTmp)
            If bPublic Then
              QueueMessage(MPControls.OpenFile(sFile))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.OpenFile(sFile))
            End If
          End If
        Case "pause"
          If bPublic Then
            QueueMessage(MPControls.MPause)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.MPause)
          End If
        Case "stop"
          If bPublic Then
            QueueMessage(MPControls.MStop)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.MStop)
          End If
        Case "fos", "fadeout"
          If bPublic Then
            QueueMessage(MPControls.FadeOut)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.FadeOut)
          End If
        Case "stopafter"
          If bPublic Then
            QueueMessage(MPControls.StopAfter)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.StopAfter)
          End If
        Case "previous"
          If bPublic Then
            QueueMessage(MPControls.MPrevious)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.MPrevious)
          End If
        Case "next"
          If bPublic Then
            QueueMessage(MPControls.MNext)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.MNext)
          End If
        Case "setvol", "volume", "setvolume"
          If sCmd.Length = 1 Then
            ShowHelp(Me, &H5011)
          Else
            If bPublic Then
              QueueMessage(MPControls.SetVolume(sCmd(1)))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.SetVolume(sCmd(1)))
            End If
          End If
        Case "repeat"
          If bPublic Then
            QueueMessage(MPControls.Repeat)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.Repeat)
          End If
        Case "shuffle"
          If bPublic Then
            QueueMessage(MPControls.Shuffle)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, MPControls.Shuffle)
          End If
        Case "disconnect"
          BNCS_Disconnect(False)
        Case "connect"
          BNCS_Connect()
        Case "reconnect"
          BNCS_Disconnect(False)
          BNCS_Connect()
        Case "logging"
          If sCmd.Length > 1 Then
            If StrComp(sCmd(1), "on", CompareMethod.Text) = 0 Then
              TabAdd(tabPacket)
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, String.Empty, My.Resources.INFO_LOGGING_ON)
            ElseIf StrComp(sCmd(1), "off", CompareMethod.Text) = 0 Then
              TabRemove(tabPacket)
              gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, My.Resources.INFO_LOGGING_OFF)
            Else
              'ShowHelp(Me,&H???)
            End If
          Else
            If tbsLists.Controls.Contains(tabPacket) Then
              TabRemove(tabPacket)
              gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, My.Resources.INFO_LOGGING_OFF)
            Else
              TabAdd(tabPacket)
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, String.Empty, My.Resources.INFO_LOGGING_ON)
            End If
          End If
        Case "killtrivia"
          If sCmd.Length = 1 Then
            If TriviaKiller IsNot Nothing Then
              TriviaKiller.SaveTrivia(AppStore & "\TriviaKiller.txt")
              TriviaKiller = Nothing
              gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, My.Resources.INFO_TRIVIA_OFF)
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, My.Resources.ERR_TRIVIA_OFF)
            End If
          Else
            Dim sBot As String = String.Empty
            Dim sSpecific As String = String.Empty
            If sCmd(1).Contains(" ") Then
              sBot = Split(sCmd(1), , 2)(0)
              sSpecific = Split(sCmd(1), , 2)(1)
            Else
              sBot = sCmd(1)
            End If
            If TriviaKiller Is Nothing Then
              TriviaKiller = New AntiTrivia(sBot)
              TriviaKiller.LoadTrivia(AppStore & "\TriviaKiller.txt")
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, String.Empty, ResString(My.Resources.INFO_TRIVIA_ON, sBot))
            Else
              TriviaKiller.SaveTrivia(AppStore & "\TriviaKiller.txt")
              TriviaKiller = Nothing
              TriviaKiller = New AntiTrivia(sBot)
              TriviaKiller.LoadTrivia(AppStore & "\TriviaKiller.txt")
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, String.Empty, ResString(My.Resources.INFO_TRIVIA_SET, sBot))
            End If
            If StrComp(sSpecific, "emote", CompareMethod.Text) = 0 Then
              TriviaKiller.OnEmote = TriState.True
            ElseIf StrComp(sSpecific, "chat", CompareMethod.Text) = 0 Then
              TriviaKiller.OnEmote = TriState.False
            Else
              TriviaKiller.OnEmote = TriState.UseDefault
            End If
          End If
        Case "help", "?"
          If bPublic Then
            If sCmd.Count > 1 Then
              Select Case sCmd(1).ToLower
                Case "extensions"
                  ShowHelp(Me, &H10)
                Case "chat"
                  ShowHelp(Me, &H20)
                Case "information"
                  ShowHelp(Me, &H30)
                Case "system"
                  ShowHelp(Me, &H40)
                Case "settings"
                  ShowHelp(Me, &H41)
                Case "idles"
                  ShowHelp(Me, &H42)
                Case "quotes"
                  ShowHelp(Me, &H43)
                Case "entertainment"
                  ShowHelp(Me, &H50)
                Case Else
                  ShowHelp(Me, &H0)
              End Select
            Else
              ShowHelp(Me, &H0)
            End If
          Else
            QueueMessage("/" & sText)
          End If
        Case Else
          If bPublic Then
            gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, My.Resources.ERR_COMMAND_INVALID)
          Else
            QueueMessage("/" & sText)
          End If
      End Select
    End If
  End Sub

  Private Sub cmdWhisper_Click(sender As Object, e As EventArgs) Handles cmdWhisper.Click
    If Not (String.IsNullOrEmpty(txtSend.Text) Or ChanList.Length = 0) Then
      SendMessage("/w " & lvChannel.SelectedItems(0).Text & " " & txtSend.Text)
      txtSend.Text = Nothing
    End If
  End Sub

  Private Sub cmdClanRules_Click(sender As Object, e As EventArgs) Handles cmdClanRules.Click, cmdClanManagerRules.Click
    Process.Start("http://www.battle.net/war3/ladder/war3-ladder-info-clans.aspx")
  End Sub

  Private Sub cmdClanNoneCreate_Click(sender As Object, e As EventArgs) Handles cmdClanNoneCreate.Click
    pnlClanNone.Visible = False
    pnlClanList.Visible = False
    pnlClanCreate.Visible = True
    pnlClanManager.Visible = False
    pnlClanInvitation.Visible = False
  End Sub

  Private Sub cmdClanCancel_Click(sender As Object, e As EventArgs) Handles cmdClanCancel.Click
    pnlClanNone.Visible = True
    pnlClanList.Visible = False
    pnlClanCreate.Visible = False
    pnlClanManager.Visible = False
    pnlClanInvitation.Visible = False
  End Sub

  Private Sub cmdClanCreate_Click(sender As Object, e As EventArgs) Handles cmdClanCreate.Click
    If String.IsNullOrEmpty(txtClanCreateName.Text) Then
      txtClanCreateName.Focus()
    ElseIf String.IsNullOrEmpty(txtClanCreateTag.Text) Then
      txtClanCreateTag.Focus()
    Else
      If ClanInviteWindow Is Nothing Then ClanInviteWindow = New frmClanInvitation
      If ClanInviteWindow.IsDisposed Then ClanInviteWindow = New frmClanInvitation
      If ClanInviteWindow.Visible = False Then ClanInviteWindow.Show(frmMain)
      ClanInviteWindow.Tag = Me
      ClanInviteWindow.ClanName = txtClanCreateName.Text
      ClanInviteWindow.ClanTag = txtClanCreateTag.Text
      BNCS_CLANFINDCANDIDATES_Send(&H1, txtClanCreateTag.Text)
    End If
  End Sub

  Private Sub cmdListChannel_Click(sender As System.Object, e As System.EventArgs) Handles cmdListChannel.Click
    If cmdListChannel.Tag = Nothing Then
      cmdListChannel.Tag = "LOAD"
      cmdListChannel.Image = My.Resources.LOAD
      SquelchUser(BNetData.UniqueName, False)
    End If
    txtSend.Focus()
  End Sub

  Private Sub lvChannel_DoubleClick(sender As Object, e As EventArgs) Handles lvChannel.DoubleClick
    If ChanList.Length > 0 Then mnuProfile.PerformClick()
  End Sub

  Private Sub lvChannel_MouseClick(sender As Object, e As MouseEventArgs) Handles lvChannel.MouseClick
    If ChanList.Length > 0 Then
      If lvChannel.SelectedItems.Count = 0 Then Exit Sub
      mnuUser.Tag = ChanList.Username(lvChannel.SelectedItems(0).Text)
      If e.Button = MouseButtons.Right Then
        Dim selItem As String = lvChannel.SelectedItems(0).Text
        mnuSquelch.Checked = ChanList.Flags(selItem) And USER_SQUELCHED
        mnuFriend.Checked = IsFriend(ChanList.Username(selItem))
        mnuWhisWin.Visible = Not (Config.Display.WhisWin = 0)
        mnuUser.Show(lvChannel, e.Location)
      End If
    End If
  End Sub

  Private Sub lvChannel_SelectedIndexChanged(sender As Object, e As System.EventArgs) Handles lvChannel.SelectedIndexChanged
    If lvChannel.SelectedItems.Count > 0 Then mnuUser.Tag = ChanList.Username(lvChannel.SelectedItems(0).Text)
  End Sub

  Private Sub lvFriends_DoubleClick(sender As Object, e As EventArgs) Handles lvFriends.DoubleClick
    If lvFriends.SelectedItems.Count > 0 Then mnuFriendProfile.PerformClick()
  End Sub

  Private Sub lvFriends_MouseClick(sender As Object, e As MouseEventArgs) Handles lvFriends.MouseClick
    If lvFriends.SelectedItems.Count > 0 Then
      If e.Button = MouseButtons.Right Then
        mnuFriends.Show(lvFriends, e.Location)
      End If
    End If
  End Sub

  Private Sub cmdFriendAdd_Click(sender As Object, e As EventArgs) Handles cmdFriendAdd.Click
    If String.IsNullOrEmpty(txtFriendAdd.Text) Then
      txtFriendAdd.Focus()
    Else
      SendMessage("/f a " & txtFriendAdd.Text)
      txtFriendAdd.Text = Nothing
    End If
  End Sub

  Private Sub txtFriendAdd_KeyPress(sender As Object, e As KeyPressEventArgs) Handles txtFriendAdd.KeyPress
    If e.KeyChar = ControlChars.Cr Then
      cmdFriendAdd.PerformClick()
      e.Handled = True
    End If
  End Sub

  Private Sub mnuClanName_Click(sender As System.Object, e As System.EventArgs) Handles mnuClanName.Click
    txtSend.SelectedText = mnuClan.Tag
  End Sub

  Private Sub lvClan_DoubleClick(sender As Object, e As System.EventArgs) Handles lvClan.DoubleClick
    If lvClan.Items.Count > 0 Then mnuClanProfile.PerformClick()
  End Sub

  Private Sub lvClan_MouseClick(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles lvClan.MouseClick
    If lvClan.Items.Count > 0 Then
      If lvClan.SelectedItems.Count = 0 Then Exit Sub
      Dim sName As String = lvClan.SelectedItems(0).Text
      mnuClan.Tag = sName
      If e.Button = MouseButtons.Right Then
        If ChanList.FindItem(sName) Then
          mnuClanSquelch.Checked = ChanList.Flags(sName) And USER_SQUELCHED
          mnuClanFriend.Checked = IsFriend(sName)
        Else
          mnuClanSquelch.Checked = False
          mnuClanFriend.Checked = False
        End If
        mnuClanPromote.Visible = ClanList.Rank(sName) < 4
        mnuClanDemote.Visible = ClanList.Rank(sName) > 1
        mnuClanSpace4.Visible = StrComp(sName, Config.Account.Username, CompareMethod.Text) = 0
        mnuClanLeave.Visible = StrComp(sName, Config.Account.Username, CompareMethod.Text) = 0
        mnuClan.Show(lvClan, e.Location)
      End If
    End If
  End Sub

  Private Sub mnuClanWhois_Click(sender As System.Object, e As System.EventArgs) Handles mnuClanWhois.Click
    SendMessage("/whois " & mnuClan.Tag)
  End Sub

  Private Sub mnuClanPromote_Click(sender As System.Object, e As System.EventArgs) Handles mnuClanPromote.Click
    BNCS_CLANRANKCHANGE_Send(&H0, mnuClan.Tag, ClanList.Rank(mnuClan.Tag) + 1)
  End Sub

  Private Sub mnuClanDemote_Click(sender As System.Object, e As System.EventArgs) Handles mnuClanDemote.Click
    BNCS_CLANRANKCHANGE_Send(&H0, mnuClan.Tag, ClanList.Rank(mnuClan.Tag) - 1)
  End Sub

  Private Sub mnuClanFriend_Click(sender As System.Object, e As System.EventArgs) Handles mnuClanFriend.Click
    If mnuClanFriend.Checked Then
      SendMessage("/f r " & mnuClan.Tag)
    Else
      SendMessage("/f a " & mnuClan.Tag)
    End If
  End Sub

  Private Sub mnuClanSquelch_Click(sender As System.Object, e As System.EventArgs) Handles mnuClanSquelch.Click
    If ChanList.FindItem(mnuClan.Tag) > -1 Then
      SquelchUser(mnuClan.Tag, Not CBool(ChanList.Flags(mnuClan.Tag) And USER_SQUELCHED))
    Else
      SquelchUser(mnuClan.Tag)
    End If
  End Sub

  Private Sub mnuClanWhisper_Click(sender As System.Object, e As System.EventArgs) Handles mnuClanWhisper.Click
    If ChanList.Length > 0 Then
      If Not frmWhisper.Visible Then frmWhisper.Show()
      frmWhisper.AddWhisper(Me, mnuClan.Tag)
    End If
  End Sub

  Private Sub mnuClanProfile_Click(sender As System.Object, e As System.EventArgs) Handles mnuClanProfile.Click
    GetUIProfile(mnuClan.Tag, IIf(Config.Account.Client.Product = GameType.WAR3, "WAR3", "W3XP"))
  End Sub

  Private Sub mnuClanLeave_Click(sender As System.Object, e As System.EventArgs) Handles mnuClanLeave.Click
    BNCS_CLANREMOVEMEMBER_Send(&H0, Config.Account.Username)
  End Sub

  Private Sub tbsLists_SelectedIndexChanged(sender As Object, e As EventArgs) Handles tbsLists.SelectedIndexChanged
    If IsOnline Then
      If tbsLists.SelectedTab.Name = "tabFriend" Then BNCS_FRIENDSLIST_Send()
      If tbsLists.SelectedTab.Name = "tabClan" Then
        If String.IsNullOrEmpty(ChatData.ClanTag) Then
          pnlClanNone.Visible = True
          pnlClanList.Visible = False
          pnlClanCreate.Visible = False
          pnlClanManager.Visible = False
          pnlClanInvitation.Visible = False
        Else
          pnlClanNone.Visible = False
          pnlClanList.Visible = True
          pnlClanCreate.Visible = False
          pnlClanManager.Visible = False
          pnlClanInvitation.Visible = False
          BNCS_CLANMEMBERLIST_Send(1)
        End If
      End If
      If tbsLists.SelectedTab.Name = "tabRealm" Then
        Select Case Realms.Status
          Case D2Realm.RealmState.Offline
            DisplayRealmWaitMessage(My.Resources.REALM_STATUS_QUERY)
            BNCS_QUERYREALMS2_Send()
          Case D2Realm.RealmState.QueryingRealms
            DisplayRealmWaitMessage(My.Resources.REALM_STATUS_QUERY)
          Case D2Realm.RealmState.RealmList
            DisplayRealmListing(False)
          Case D2Realm.RealmState.ConnectingToRealm
            DisplayRealmWaitMessage(My.Resources.REALM_STATUS_CONNECTING)
          Case D2Realm.RealmState.GettingCharacterList
            DisplayRealmWaitMessage(My.Resources.REALM_STATUS_CHAR_LIST)
          Case D2Realm.RealmState.CharacterList
            DisplayRealmCharListing(False)
          Case D2Realm.RealmState.CharacterCreation
            DisplayRealmCharCreate()
        End Select
      End If
    End If
    If tbsLists.SelectedTab.Name = "tabPacket" Then
      tbsLists.Tag = spltChat.SplitterDistance
      spltChat.SplitterDistance = spltChat.Width - 450
    ElseIf tbsLists.Tag IsNot Nothing Then
      spltChat.SplitterDistance = tbsLists.Tag
      tbsLists.Tag = Nothing
    Else
      If Not lvChannel.Columns(0).Width = lvChannel.ClientSize.Width - 18 Then lvChannel.Columns(0).Width = lvChannel.ClientSize.Width - 18
      If Not lvChannel.Columns(1).Width = 18 Then lvChannel.Columns(1).Width = 18
      If Not lvFriends.Columns(0).Width = lvFriends.ClientSize.Width Then lvFriends.Columns(0).Width = lvFriends.ClientSize.Width
      If lvClan.Columns.Count > 0 Then If Not lvClan.Columns(0).Width = lvClan.ClientSize.Width Then lvClan.Columns(0).Width = lvClan.ClientSize.Width
      If Not lvRealmChars.Columns(0).Width = lvRealmChars.ClientSize.Width - 50 Then lvRealmChars.Columns(0).Width = lvRealmChars.ClientSize.Width - 50
      If Not lvRealmChars.Columns(1).Width = 50 Then lvRealmChars.Columns(1).Width = 50
    End If
  End Sub

  Private Sub mnuName_Click(sender As Object, e As EventArgs) Handles mnuName.Click
    txtSend.SelectedText = mnuUser.Tag
  End Sub

  Private Sub mnuInfo_Click(sender As Object, e As EventArgs) Handles mnuInfo.Click
    SendMessage("/info " & mnuUser.Tag)
  End Sub

  Private Sub mnuWhois_Click(sender As Object, e As EventArgs) Handles mnuWhois.Click
    SendMessage("/whois " & mnuUser.Tag)
  End Sub

  Private Sub mnuFriend_Click(sender As Object, e As EventArgs) Handles mnuFriend.Click
    If mnuFriend.Checked Then
      SendMessage("/f r " & mnuUser.Tag)
    Else
      SendMessage("/f a " & mnuUser.Tag)
    End If
  End Sub

  Private Sub mnuSquelch_Click(sender As Object, e As EventArgs) Handles mnuSquelch.Click
    If ChanList.FindItem(mnuUser.Tag) > -1 Then
      SquelchUser(mnuUser.Tag, Not CBool(ChanList.Flags(mnuUser.Tag) And USER_SQUELCHED))
    Else
      SquelchUser(mnuUser.Tag)
    End If
  End Sub

  Private Sub mnuWhisWin_Click(sender As Object, e As EventArgs) Handles mnuWhisWin.Click
    If ChanList.Length > 0 Then
      If Not frmWhisper.Visible Then frmWhisper.Show()
      frmWhisper.AddWhisper(Me, mnuUser.Tag)
    End If
  End Sub

  Private Sub mnuProfile_Click(sender As Object, e As EventArgs) Handles mnuProfile.Click
    GetUIProfile(mnuUser.Tag)
  End Sub

  Friend Sub GetUIProfile(Username As String, Optional sClient As String = Nothing)
    If ChanList.Length > 0 Then
      If ProfileWindow Is Nothing Then ProfileWindow = New frmProfile
      If ProfileWindow.IsDisposed Then ProfileWindow = New frmProfile
      If ProfileWindow.Visible = False Then ProfileWindow.Show(frmMain)
      ProfileWindow.Left = ((Me.ParentForm.Left + (Me.ParentForm.Width / 2)) - (ProfileWindow.Width / 2))
      ProfileWindow.Top = ((Me.ParentForm.Top + (Me.ParentForm.Height / 2)) - (ProfileWindow.Height / 2))
      ProfileWindow.Tag = Me
      If String.IsNullOrEmpty(sClient) Then
        If ChanList.FindItem(Username) > -1 Then
          Dim bStatString() As Byte = ChanList.StatString(Username)
          If bStatString IsNot Nothing Then
            sClient = StrReverse(System.Text.Encoding.GetEncoding(LATIN_1).GetString(bStatString).Substring(0, 4))
            GetUserData(Username, ProfileRequests.ProfileRequestType.UserProfile, ProfileRequests.ProfileRequestDisplay.PrivateUI, sClient)
          Else
            GetUserData(Username, ProfileRequests.ProfileRequestType.UserProfile, ProfileRequests.ProfileRequestDisplay.PrivateUI)
          End If
        Else
          GetUserData(Username, ProfileRequests.ProfileRequestType.UserProfile, ProfileRequests.ProfileRequestDisplay.PrivateUI)
        End If
      Else
        GetUserData(Username, ProfileRequests.ProfileRequestType.UserProfile, ProfileRequests.ProfileRequestDisplay.PrivateUI, sClient)
      End If
    End If
  End Sub

  Private Sub mnuFriendName_Click(sender As Object, e As EventArgs) Handles mnuFriendName.Click
    txtSend.SelectedText = lvFriends.SelectedItems(0).Text
  End Sub

  Private Sub mnuFriendWhisper_Click(sender As Object, e As EventArgs) Handles mnuFriendWhisper.Click
    If lvFriends.SelectedItems.Count > 0 Then
      If Not frmWhisper.Visible Then frmWhisper.Show()
      frmWhisper.AddWhisper(Me, lvFriends.SelectedItems(0).Text)
    End If
  End Sub

  Private Sub mnuFriendWhois_Click(sender As Object, e As EventArgs) Handles mnuFriendWhois.Click
    SendMessage("/whois " & lvFriends.SelectedItems(0).Text)
  End Sub

  Private Sub mnuFriendPromote_Click(sender As Object, e As EventArgs) Handles mnuFriendPromote.Click
    SendMessage("/f p " & lvFriends.SelectedItems(0).Text)
  End Sub

  Private Sub mnuFriendDemote_Click(sender As Object, e As EventArgs) Handles mnuFriendDemote.Click
    SendMessage("/f d " & lvFriends.SelectedItems(0).Text)
  End Sub

  Private Sub mnuFriendRemove_Click(sender As Object, e As EventArgs) Handles mnuFriendRemove.Click
    If lvFriends.SelectedItems.Count > 0 Then SendMessage("/f r " & lvFriends.SelectedItems(0).Text)
  End Sub

  Private Sub mnuFriendProfile_Click(sender As Object, e As EventArgs) Handles mnuFriendProfile.Click
    If lvFriends.SelectedItems.Count > 0 Then
      If ProfileWindow Is Nothing Then ProfileWindow = New frmProfile
      If ProfileWindow.Visible = False Then ProfileWindow.Show(frmMain)
      ProfileWindow.Left = ((Me.ParentForm.Left + (Me.ParentForm.Width / 2)) - (ProfileWindow.Width / 2))
      ProfileWindow.Top = ((Me.ParentForm.Top + (Me.ParentForm.Height / 2)) - (ProfileWindow.Height / 2))
      ProfileWindow.Tag = Me
      Dim bStatString() As Byte = ChanList.StatString(lvFriends.SelectedItems(0).Text)
      If bStatString IsNot Nothing Then
        Dim sClient As String = System.Text.Encoding.GetEncoding(LATIN_1).GetString(bStatString).Substring(0, 4).Reverse
        GetUserData(lvFriends.SelectedItems(0).Text, ProfileRequests.ProfileRequestType.UserProfile, ProfileRequests.ProfileRequestDisplay.PrivateUI, sClient)
      Else
        GetUserData(lvFriends.SelectedItems(0).Text, ProfileRequests.ProfileRequestType.UserProfile, ProfileRequests.ProfileRequestDisplay.PrivateUI)
      End If
    End If
  End Sub

  Private Sub tmrAds_Tick(source As Object, e As ElapsedEventArgs)
    BNCS_CHECKAD_Send()
  End Sub

  Private Sub tmrIdle_Tick(sender As Object, e As EventArgs) Handles tmrIdle.Tick
    If Me IsNot Nothing And Not BNetData.UniqueName = String.Empty Then DoIdle()
  End Sub

  Private Sub tmrBanList_Tick(sender As Object, e As EventArgs)
    gChat.UpdateProgress("banlist", String.Empty)
    tmrBanList = Nothing
  End Sub

  Private Sub tmrRetryJoin_Tick(sender As Object, e As EventArgs)
    If IsOnline Then
      ChatData.RetryCount += 1
      gChat.UpdateProgress("FULL", ResString(My.Resources.ERR_CHANNELFULLTRYING, ChatData.RetryChannel, ChatData.RetryCount))
      If ChatData.RetryCount Mod 100 = 0 Then
        Thread.Sleep(5000)
        'gChat.TerminateProgress("FULL", ResString(My.Resources.ERR_CHANNELFULLMAX, ChatData.RetryChannel, ChatData.RetryCount))
        'tmrRetryJoin.Stop()
        'ChatData.RetryCount = 0
        'ChatData.RetryChannel = Nothing
        'tmrRetryJoin = Nothing
      Else
        BNCS_JOINCHANNEL_Send(ChatData.RetryChannel, JoinFlags.NoCreate, False)
      End If
      'Else
      'End If
    Else
      gChat.TerminateProgress("FULL", ResString(My.Resources.ERR_CHANNELFULLDONE, ChatData.RetryChannel))
      If tmrRetryJoin IsNot Nothing Then
        tmrRetryJoin.Stop()
        ChatData.RetryCount = 0
        ChatData.RetryChannel = Nothing
        tmrRetryJoin = Nothing
      End If
    End If
  End Sub

  Private Sub QueueList_SendMessage(sMessage As String) Handles QueueList.SendMessage
    BNCS_CHATCOMMAND_Send(sMessage)
  End Sub

  Private Sub PingSpoof_SpoofComplete(Packets As ArrayList) Handles PingSpoof.SpoofComplete
    Dim pTmp As New ArrayList(Packets)
    PingSpoof = Nothing
    If Not gChat.IsDisposed Then gChat.TerminateProgress("pingspoof", My.Resources.PING_SPOOFDONE)
    ChatData.PingFirst = False
    For Each bPacket As Byte() In pTmp
      BNCS_Handle(New BNCSReader(bPacket))
    Next
  End Sub

  Private Sub PingSpoof_SpoofUpdate(TimeLeft As Integer) Handles PingSpoof.SpoofUpdate
    Static iLastNull As Integer
    If iLastNull = 0 Then iLastNull = Environment.TickCount - 10000
    If Not gChat.IsDisposed Then gChat.UpdateProgress("pingspoof", ResString(My.Resources.PING_SPOOFTIME, ConvertTime(TimeLeft, True)))
    If Environment.TickCount - iLastNull > 10000 Then
      BNCS_NULL_Send()
      iLastNull = Environment.TickCount
    End If
  End Sub

  Private Sub sckBN2_SocketConnected(sender As Object, e As System.EventArgs) Handles sckBN2.SocketConnected
    gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNET2, My.Resources.INFO_CONNECTED)
    Initiate()
  End Sub

  Private Sub Initiate()
    If Me.InvokeRequired Then
      Me.Invoke(New MethodInvoker(AddressOf Initiate))
    Else
      Select Case Config.Account.Client.Product
        Case GameType.SCII
          cBNET2 = New clsBNCS2(Config)
          cBNET2.InitiateConnection()
        Case Else
          gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, "Entelechy is unable to log in using " & GameTypeToGameTitle(Config.Account.Client.Product) & " at this time. Keep your copy updated for the latest features!")
          BNCS_Disconnect(True)
      End Select
    End If
  End Sub

  Private Sub sckBN2_SocketDisconnected(sender As Object, e As SocketErrorEventArgs) Handles sckBN2.SocketDisconnected
    Select Case e.ErrorDetails
      Case String.Empty
        'Just disconnected.
      Case My.Resources.SOCKET_ERR_DROPPED
        If ChatData.LoginTime > 0 Then
          BNCS_Disconnect()
          Thread.Sleep(1000)
          BNCS_Connectv2()
        Else
          BNCS_Disconnect()
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNET2, e.ErrorDetails)
        End If
      Case "Already in progress...", "Operation aborted by user.", "Disconnecting..."
        'gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNET2, e.ErrorDetails)
      Case "Destination address required.", "Socket version not supported.", "Protocol type is incorrect for this socket type.", "Unknown, invalid, or unsupported protocol option or level.", "Protocol not supported.", "Protocol faimly not supported.", "Unrecoverable error. Terminating."
        BNCS_Disconnect(True)
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNET2, e.ErrorDetails)
      Case Else
        BNCS_Disconnect(True)
        AttemptReconnect(e.ErrorDetails)
    End Select
  End Sub

  Private Sub sckBN2_SocketReceived(sender As Object, e As SocketReceivedEventArgs) Handles sckBN2.SocketReceived
    If Me.InvokeRequired Then
      Me.Invoke(New CallBack(AddressOf BNet2Received), e.Data)
    Else
      BNet2Received(e.Data)
    End If
  End Sub

  Private Sub BNet2Received(data() As Byte)
    If cBNET2 Is Nothing Then Exit Sub
    cBNET2.PacketIn(data)
    If tbsLists.Controls.Contains(tabPacket) Then AddPacket({My.Resources.PROTOCOL_BNET2, True, 0, data})
  End Sub

  Private Sub sckBNCS_SocketConnected(sender As Object, e As EventArgs) Handles sckBNCS.SocketConnected
    Dim lByte(0) As Byte
    lByte(0) = &H1
    Try
      sckBNCS.Send(lByte)
    Catch ex As Exception
      BNCS_Disconnect(True)
      Select Case ex.Message
        Case NET_FAILURE
          AttemptReconnect(My.Resources.ERR_NET_OFF)
        Case Else
          AttemptReconnect(ResString(My.Resources.ERR_NET_FAIL, ex.Message))
      End Select
      Exit Sub
    End Try
    BNetData.LastPing = Environment.TickCount
    gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_CONNECTED)
    BNetData.ClientToken = Environment.TickCount
    Select Case Config.Account.Client.Product
      Case GameType.DRTL, GameType.DSHR, GameType.JSTR, GameType.W2BN
        BNCS_CLIENTID2_Send()
      Case GameType.D2DV, GameType.D2XP, GameType.STAR, GameType.SEXP, GameType.WAR3, GameType.W3XP
        BNCS_AUTH_INFO_Send()
      Case GameType.SSHR
        BNCS_CLIENTID_Send()
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, ResString(My.Resources.ERR_LOGIN_NOTSUPPORTED, GameTypeToGameTitle(Config.Account.Client.Product)))
        BNCS_Disconnect(True)
    End Select
  End Sub

  Private Sub sckBNCS_SocketDisconnected(sender As Object, e As SocketErrorEventArgs) Handles sckBNCS.SocketDisconnected
    Select Case e.ErrorDetails
      Case String.Empty
        'Just disconnected.
      Case My.Resources.SOCKET_ERR_DROPPED
        If ChatData.LoginTime > 0 Then
          BNCS_Disconnect()
          Thread.Sleep(1000)
          BNCS_Connect()
        Else
          BNCS_Disconnect()
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, e.ErrorDetails)
        End If
      Case "Already in progress...", "Operation aborted by user.", "Disconnecting..."
        'gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, e.ErrorDetails)
      Case "Destination address required.", "Socket version not supported.", "Protocol type is incorrect for this socket type.", "Unknown, invalid, or unsupported protocol option or level.", "Protocol not supported.", "Protocol faimly not supported.", "Unrecoverable error. Terminating."
        BNCS_Disconnect(True)
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, e.ErrorDetails)
      Case Else
        BNCS_Disconnect(True)
        AttemptReconnect(e.ErrorDetails)
    End Select
  End Sub

  Private Sub sckBNCS_SocketReceived(sender As Object, e As SocketReceivedEventArgs) Handles sckBNCS.SocketReceived
    Static bCache() As Byte
    Dim iPos As Integer = 0
    If bCache IsNot Nothing Then iPos = bCache.Length
    ReDim Preserve bCache(iPos + e.Data.Length - 1)
    e.Data.CopyTo(bCache, iPos)
    Do While bCache.Length >= 4
      Using pktTmp As New DataReader(bCache)
        Dim bFF As Byte = pktTmp.ReadByte
        Dim bID As Byte = pktTmp.ReadByte
        Dim iLen As UInt16 = pktTmp.ReadUInt16
        If bFF = &HFF And bCache.Length >= iLen Then
          Dim bPacket(iLen - 1) As Byte
          Array.Copy(bCache, bPacket, iLen)
          Dim bNewCache(bCache.Length - iLen - 1) As Byte
          Array.Copy(bCache, iLen, bNewCache, 0, bCache.Length - iLen)
          bCache = bNewCache
          Erase bNewCache
          BNetData.LastPing = Environment.TickCount
          If ChatData.PingFirst Then
            If bID = BNCS_PING Then
              If Config.PingSpoof > 3 Then
                If PingSpoof Is Nothing Then
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, My.Resources.PING_SPOOFING, "pingspoof")
                  PingSpoof = New PingSpoofQueue(ChatData.PingSpoofing, Config.PingSpoof)
                End If
                PingSpoof.AddPacketToQueue(bPacket)
              ElseIf Config.PingSpoof < 3 Then
                ChatData.PingFirst = False
              Else
                ChatData.PingFirst = False
                BNCS_Handle(New BNCSReader(bPacket))
              End If
            Else
              If Config.PingSpoof > 3 Then
                If PingSpoof Is Nothing Then
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, My.Resources.PING_SPOOFING, "pingspoof")
                  PingSpoof = New PingSpoofQueue(ChatData.PingSpoofing, Config.PingSpoof)
                End If
                PingSpoof.AddPacketToQueue(bPacket)
              Else
                BNCS_Handle(New BNCSReader(bPacket))
              End If
            End If
          Else
            BNCS_Handle(New BNCSReader(bPacket))
          End If
        Else
          Exit Do
        End If
      End Using
    Loop
  End Sub

  Private Sub sckMCP_SocketConnected() Handles sckMCP.SocketConnected
    Dim lByte(0) As Byte
    lByte(0) = &H1
    Try
      sckMCP.Send(lByte)
    Catch e As Exception
      Select Case e.Message
        Case NET_FAILURE
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, My.Resources.ERR_NET_OFF)
          DisplayRealmErrMessage(My.Resources.ERR_NET_OFF)
        Case Else
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, ResString(My.Resources.ERR_NET_FAIL, e.Message))
          DisplayRealmErrMessage(ResString(My.Resources.ERR_NET_FAIL, e.Message))
      End Select
      Realms.Status = D2Realm.RealmState.Offline
      MCP_Disconnect()
      MCP = Nothing
      Exit Sub
    End Try
    gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_MCP, My.Resources.INFO_CONNECTED)
    MCP_STARTUP_Send()
  End Sub

  Private Sub sckMCP_SocketDisconnected(sender As Object, e As SocketErrorEventArgs) Handles sckMCP.SocketDisconnected
    If Not String.IsNullOrEmpty(e.ErrorDetails) And e.ErrorDetails <> "Operation aborted by user." Then
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, e.ErrorDetails)
      DisplayRealmErrMessage(e.ErrorDetails)
    End If
  End Sub

  Private Sub sckMCP_SocketReceived(sender As Object, e As SocketReceivedEventArgs) Handles sckMCP.SocketReceived
    Static bCache() As Byte
    Dim iPos As Integer
    If bCache Is Nothing Then
      iPos = 0
    Else
      iPos = bCache.Length
    End If
    ReDim Preserve bCache(iPos + e.Data.Length - 1)
    e.Data.CopyTo(bCache, iPos)
    Do While bCache.Length >= 3
      Dim pktTmp As New DataReader(bCache)
      Dim iLen As UInt16 = pktTmp.ReadUInt16
      Dim bID As Byte = pktTmp.ReadByte
      If bCache.Length >= iLen Then
        Dim bPacket(iLen - 1) As Byte
        bCache.CopyTo(bPacket, 0)
        Dim bNewCache(bCache.Length - iLen - 1) As Byte
        Array.ConstrainedCopy(bCache, iLen, bNewCache, 0, bCache.Length - iLen)
        bCache = bNewCache
        Erase bNewCache
        MCP_Handle(New MCPReader(e.Data))
      End If
    Loop
  End Sub

  Private Sub sckUDP_SocketReceived(sender As Object, e As SocketReceivedEventArgs) Handles sckUDP.SocketReceived
    PKT_Handle(sckUDP.RemoteEndPoint, e.Data)
  End Sub

  Private Sub wsDownload_DownloadProgressChanged(sender As Object, e As DownloadProgressChangedEventArgs) Handles wsDownload.DownloadProgressChanged
    Static lastPercent As Integer
    If e.UserState = "HASH" Then
      If lastPercent <> e.ProgressPercentage Then
        If Not gChat.IsDisposed Then gChat.UpdateProgress("hashes", My.Resources.INFO_GET_HASH & " " & e.ProgressPercentage.ToString.Trim & "%")
        lastPercent = e.ProgressPercentage
      End If
    End If
  End Sub

  Private Sub wsDownload_DownloadFileCompleted(sender As Object, e As System.ComponentModel.AsyncCompletedEventArgs) Handles wsDownload.DownloadFileCompleted
    If e.UserState = "HASH" Then
      If e.Error Is Nothing Then
        Dim HashZip As String = Config.HashPath & GetHashProd() & ".zip"
        If My.Computer.FileSystem.FileExists(HashZip) Then
          Dim XtractDir As String = Config.HashPath & GetHashProd()
          If Not My.Computer.FileSystem.DirectoryExists(XtractDir) Then My.Computer.FileSystem.CreateDirectory(XtractDir)
          Using zipHashes As ZipFile = zipFile.Read(HashZip)
            Dim zipFile As ZipEntry
            For Each zipFile In zipHashes
              zipFile.Extract(XtractDir, ExtractExistingFileAction.OverwriteSilently)
            Next
          End Using
          Kill(HashZip)
          gChat.TerminateProgress("hashes", My.Resources.INFO_GET_HASH_COMPLETE)
          BNCS_Connect()
        Else
          gChat.TerminateProgress("hashes", wsDownload.ResponseHeaders.ToString)
        End If
      Else
        gChat.TerminateProgress("hashes", ResString(My.Resources.ERR_GET_HASH_FAIL, e.Error.InnerException.Message))
      End If
    End If
  End Sub

  Private Sub wsDownload_DownloadStringCompleted(sender As Object, e As System.Net.DownloadStringCompletedEventArgs) Handles wsDownload.DownloadStringCompleted
    If e.UserState = "VER" Then
      If Not (String.IsNullOrEmpty(e.Result) Or e.Result = "0") Then
        Config.VerByte = CUInt(e.Result)
        SetVerbyte(Config.Account.Client.Product, Config.VerByte)
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_HTTP, My.Resources.INFO_GET_VER_COMPLETE)
      Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_HTTP, ResString(My.Resources.ERR_GET_VER_FAIL, e.Error.InnerException.Message))
      End If
    End If
  End Sub

  Private Sub lstChannels_DoubleClick(sender As Object, e As EventArgs) Handles lstChannels.DoubleClick
    BNCS_JOINCHANNEL_Send(lstChannels.SelectedItem)
  End Sub

  Private Sub mnuChanJoin_Click(sender As Object, e As EventArgs) Handles mnuChanJoin.Click
    BNCS_JOINCHANNEL_Send(lstChannels.SelectedItem, JoinFlags.NoCreate)
  End Sub

  Private Sub mnuChanForce_Click(sender As Object, e As EventArgs) Handles mnuChanForce.Click, mnuChanFocre.Click
    BNCS_JOINCHANNEL_Send(lstChannels.SelectedItem)
  End Sub

  Private Sub SetChannelAsHomeToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles mnuChanSetHome.Click
    Config.Account.HomeChannel = lstChannels.SelectedItem
    SaveSettings(Index, Config)
    gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CONFIG, ResString(My.Resources.INFO_SETHOME, Config.Account.HomeChannel))
  End Sub

  Private Sub WhoToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles mnuChanWho.Click
    SendMessage("/who " & lstChannels.SelectedItem)
  End Sub

  Private Sub ClearChatToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles mnuChatClear.Click
    gChat.Clear()
  End Sub

  Private Sub pctAd_MouseClick(sender As Object, e As MouseEventArgs) Handles pctAd.MouseClick
    If e.Button = Windows.Forms.MouseButtons.Left Then
      If pctAd.Tag IsNot Nothing Then Process.Start(pctAd.Tag)
      BNCS_CLICKAD_Send()
    End If
  End Sub

  Private Sub pnlSend_MouseDown(sender As Object, e As MouseEventArgs) Handles pnlSend.MouseDown
    If e.Button = Windows.Forms.MouseButtons.Left Then
      If e.X > txtPre.Width + 2 And e.X < txtPre.Width + 9 Then
        pnlSend.Tag = New PanelSizePass(txtPre.Name, e.X, txtPre.Width)
      ElseIf e.X > txtPre.Width + txtSend.Width + 8 And e.X < txtPre.Width + txtSend.Width + 15 Then
        pnlSend.Tag = New PanelSizePass(cmdSend.Name, e.X, cmdSend.Width)
      ElseIf e.X > txtPre.Width + txtSend.Width + cmdSend.Width + 14 And e.X < txtPre.Width + txtSend.Width + cmdSend.Width + 21 Then
        pnlSend.Tag = New PanelSizePass(cmdWhisper.Name, e.X, cmdWhisper.Width)
      Else
        pnlSend.Tag = Nothing
      End If
    End If
  End Sub

  Private Sub pnlSend_MouseLeave(sender As Object, e As EventArgs) Handles pnlSend.MouseLeave
    pnlSend.Cursor = Cursors.Arrow
  End Sub

  Private Sub pnlSend_MouseMove(sender As Object, e As MouseEventArgs) Handles pnlSend.MouseMove
    If e.X > txtPre.Width + 2 And e.X < txtPre.Width + 9 Then
      pnlSend.Cursor = Cursors.VSplit
    ElseIf e.X > txtPre.Width + txtSend.Width + 8 And e.X < txtPre.Width + txtSend.Width + 15 Then
      pnlSend.Cursor = Cursors.VSplit
    ElseIf e.X > txtPre.Width + txtSend.Width + cmdSend.Width + 14 And e.X < txtPre.Width + txtSend.Width + cmdSend.Width + 21 Then
      pnlSend.Cursor = Cursors.VSplit
    Else
      pnlSend.Cursor = Cursors.Arrow
    End If
    If pnlSend.Tag IsNot Nothing Then
      Dim PanelSize As PanelSizePass = pnlSend.Tag
      Select Case PanelSize.Item
        Case txtPre.Name
          Dim iWidth As Integer = PanelSize.Width + (e.X - PanelSize.Offset)
          If iWidth < 25 Then
            txtPre.Width = 0
          ElseIf iWidth > 60 Then
            txtPre.Width = 60
          Else
            txtPre.Width = iWidth
          End If
        Case cmdSend.Name
          Dim iWidth As Integer = PanelSize.Width - (e.X - PanelSize.Offset)
          If iWidth < 25 Then
            cmdSend.Width = 0
          ElseIf iWidth > 75 Then
            cmdSend.Width = 75
          Else
            cmdSend.Width = iWidth
          End If
        Case cmdWhisper.Name
          Dim iWidth As Integer = PanelSize.Width - (e.X - PanelSize.Offset)
          If iWidth < 25 Then
            cmdWhisper.Width = 0
          ElseIf iWidth > 75 Then
            cmdWhisper.Width = 75
          Else
            cmdWhisper.Width = iWidth
          End If
      End Select
    End If
  End Sub

  Private Sub pnlSend_MouseUp(sender As Object, e As MouseEventArgs) Handles pnlSend.MouseUp
    pnlSend.Tag = Nothing
  End Sub

  Private Sub mnuAdvancedTimestamp_Click(sender As System.Object, e As System.EventArgs) Handles mnuAdvancedTimestamp.Click
    Config.Display.TimeStampEnabled = Not Config.Display.TimeStampEnabled
    gChat.ToggleTimestamps(Config.Display.TimeStampEnabled)
    SaveSettings(Index, Config)
  End Sub

  Private Sub mnuAdvancedRichText_Click(sender As System.Object, e As System.EventArgs) Handles mnuAdvancedRichText.Click
    Config.Display.RichText = Not Config.Display.RichText
    gChat.RichText = Config.Display.RichText
    SaveSettings(Index, Config)
  End Sub

  Private Sub mnuAdvancedUTF8_Click(sender As System.Object, e As System.EventArgs) Handles mnuAdvancedUTF8.Click
    Config.UTF8 = Not Config.UTF8
    SaveSettings(Index, Config)
  End Sub

  Private Sub mnuAdvancedEmoticons_Click(sender As System.Object, e As System.EventArgs) Handles mnuAdvancedEmoticons.Click
    Config.Display.Emoticons = Not Config.Display.Emoticons
    gChat.Emoticons = Config.Display.Emoticons
    SaveSettings(Index, Config)
  End Sub

  Private Sub mnuAdvancedJoinLeave_Click(sender As System.Object, e As System.EventArgs) Handles mnuAdvancedJoinLeave.Click
    Config.Display.JoinLeave = Not Config.Display.JoinLeave
    SaveSettings(Index, Config)
  End Sub

  Private Sub mnuCopyLog_Click(sender As System.Object, e As System.EventArgs) Handles mnuCopyLog.Click
    Clipboard.SetText(txtPacketLog.Text)
  End Sub

  Private Sub mnuClearLog_Click(sender As System.Object, e As System.EventArgs) Handles mnuClearLog.Click
    pktData.Clear()
  End Sub

  Private Sub mnuViewLogRaw_Click(sender As System.Object, e As System.EventArgs) Handles mnuViewLogRaw.Click
    pktData.Parsed = False
  End Sub

  Private Sub mnuViewLogParsed_Click(sender As System.Object, e As System.EventArgs) Handles mnuViewLogParsed.Click
    pktData.Parsed = True
  End Sub

  Private Sub mnuViewLog_Select(sender As Object, e As System.EventArgs) Handles mnuViewLog.Select
    If pktData.Parsed Then
      mnuViewLogRaw.Checked = False
      mnuViewLogParsed.Checked = True
    Else
      mnuViewLogRaw.Checked = True
      mnuViewLogParsed.Checked = False
    End If
  End Sub

  Private Sub mnuCopyPacket_Click(sender As System.Object, e As System.EventArgs) Handles mnuCopyPacket.Click
    Debug.Print(txtPacketLog.GetCharIndexFromPosition(MousePosition))
  End Sub

  Private Sub mnuSendAll_Click(sender As Object, e As System.EventArgs) Handles mnuSendAll.Click
    txtSend.SelectAll()
  End Sub

  Private Sub mnuSendClear_Click(sender As Object, e As System.EventArgs) Handles mnuSendClear.Click
    Array.Clear(LastTenCommands, 0, 9)
  End Sub

  Private Sub mnuSendCopy_Click(sender As Object, e As System.EventArgs) Handles mnuSendCopy.Click
    txtSend.Copy()
  End Sub

  Private Sub mnuSendUndo_Click(sender As System.Object, e As System.EventArgs) Handles mnuSendUndo.Click
    txtSend.Undo()
    ResetSendScrollbars()
  End Sub

  Private Sub mnuSendDelete_Click(sender As System.Object, e As System.EventArgs) Handles mnuSendDelete.Click
    txtSend.SelectedText = String.Empty
    ResetSendScrollbars()
  End Sub

  Private Sub mnuSendPaste_Click(sender As System.Object, e As System.EventArgs) Handles mnuSendPaste.Click
    txtSend.Paste()
    ResetSendScrollbars()
  End Sub

  Private Sub mnuSendCut_Click(sender As System.Object, e As System.EventArgs) Handles mnuSendCut.Click
    txtSend.Cut()
    ResetSendScrollbars()
  End Sub

  Private Sub TriviaKiller_HasAnAnwser(Answer As String) Handles TriviaKiller.HasAnAnwser
    QueueMessage(Answer)
  End Sub

  Private Sub OpenURLInBrowserToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles OpenURLInBrowserToolStripMenuItem.Click
    Process.Start(mnuAddress.Tag)
  End Sub

  Private Sub CopyURLToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles CopyURLToolStripMenuItem.Click
    Clipboard.SetText(mnuAddress.Tag)
  End Sub

  Private Sub cmdClanManagerDisband_Click(sender As System.Object, e As System.EventArgs) Handles cmdClanManagerDisband.Click
    If MsgBox(My.Resources.CLAN_DISBAND, MsgBoxStyle.Question Or MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then BNCS_CLANDISBAND_Send(&H0)
  End Sub

  Private Sub cmdClanMotDOK_Click(sender As System.Object, e As System.EventArgs) Handles cmdClanMotDOK.Click
    BNCS_CLANSETMOTD_Send(&H0, txtClanMotD.Text)
    pnlClanNone.Visible = False
    pnlClanList.Visible = True
    pnlClanCreate.Visible = False
    pnlClanManager.Visible = False
    pnlClanInvitation.Visible = False
  End Sub

  Private Sub cmdClanMotDCancel_Click(sender As System.Object, e As System.EventArgs) Handles cmdClanMotDCancel.Click
    pnlClanNone.Visible = False
    pnlClanList.Visible = True
    pnlClanCreate.Visible = False
    pnlClanManager.Visible = False
    pnlClanInvitation.Visible = False
  End Sub

  Private Sub cmdClanManagement_Click(sender As System.Object, e As System.EventArgs) Handles cmdClanManagement.Click
    If ChatData.ClanRank = 4 Then
      cmdClanManagerDisband.Enabled = True
      txtClanMotD.ReadOnly = False
      cmdClanMotDOK.Enabled = True
    Else
      cmdClanManagerDisband.Enabled = False
      txtClanMotD.ReadOnly = True
      cmdClanMotDOK.Enabled = False
    End If
    BNCS_CLANMOTD_Send(&H1)
    pnlClanNone.Visible = False
    pnlClanList.Visible = False
    pnlClanCreate.Visible = False
    pnlClanManager.Visible = True
    pnlClanInvitation.Visible = False
  End Sub

  Private Sub cmdClanInviteAccept_Click(sender As System.Object, e As System.EventArgs) Handles cmdClanInviteAccept.Click
    Dim Cookie As UInt32 = CType(pnlClanInvitation.Tag, Array)(0)
    Dim ClanTag As String = CType(pnlClanInvitation.Tag, Array)(1)
    Dim Inviter As String = CType(pnlClanInvitation.Tag, Array)(2)
    BNCS_CLANINVITATIONRESPONSE_Send(Cookie, ClanTag, Inviter, True)
    pnlClanInvitation.Visible = False
    pnlClanCreate.Visible = False
    pnlClanList.Visible = True
    pnlClanManager.Visible = False
    pnlClanNone.Visible = False
  End Sub

  Private Sub cmdClanInviteDecline_Click(sender As System.Object, e As System.EventArgs) Handles cmdClanInviteDecline.Click
    Dim Cookie As UInt32 = CType(pnlClanInvitation.Tag, Array)(0)
    Dim ClanTag As String = CType(pnlClanInvitation.Tag, Array)(1)
    Dim Inviter As String = CType(pnlClanInvitation.Tag, Array)(2)
    BNCS_CLANINVITATIONRESPONSE_Send(Cookie, ClanTag, Inviter, False)
    pnlClanInvitation.Visible = False
    pnlClanCreate.Visible = False
    pnlClanList.Visible = False
    pnlClanManager.Visible = False
    pnlClanNone.Visible = True
  End Sub

  Private Sub ShowClanInvite(Obj As Object)
    If Me.lvClan.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf ShowClanInvite), Obj)
    Else
      Dim Cookie As UInt32 = Obj(0)
      Dim ClanTag As String = Obj(1)
      Dim ClanName As String = Obj(2)
      Dim Inviter As String = Obj(3)
      pnlClanInvitation.Tag = {Cookie, ClanTag, Inviter}
      lblClanInviteDetails.Text = "Clan Invitation:" & vbNewLine & vbNewLine & Inviter & " has invited you to join a clan:"
      lblClanInviteName.Text = ClanName & " [" & ClanTag & "]"
      If Not tbsLists.TabPages.Contains(tabClan) Then TabAdd(tabClan)
      tbsLists.SelectedTab = tabClan
      pnlClanInvitation.Visible = True
      pnlClanCreate.Visible = False
      pnlClanList.Visible = False
      pnlClanManager.Visible = False
      pnlClanNone.Visible = False
    End If
  End Sub

  Private Sub cmdRelmNewCreate_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmNewCreate.Click
    If cmbClass.SelectedIndex >= 0 And Not String.IsNullOrEmpty(txtCharacter.Text) Then
      Dim Flags As UInt16 = 0
      If chkHC.Checked Then Flags = Flags Or &H4
      If chkExp.Checked Then Flags = Flags Or &H20
      If chkLadder.Checked Then Flags = Flags Or &H40
      MCP_CHARCREATE_Send(cmbClass.SelectedIndex, Flags, txtCharacter.Text)
      DisplayRealmWaitMessage(My.Resources.REALM_STATUS_CHAR_CREATE)
    Else
      If cmbClass.SelectedIndex = -1 Then
        cmbClass.Focus()
      Else
        txtCharacter.Focus()
      End If
      Beep()
    End If
  End Sub

  Private Sub chkExp_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkExp.CheckedChanged
    cmbClass.Items.Clear()
    cmbClass.Items.Add(My.Resources.STATSTRING_D2_CLASS_0)
    cmbClass.Items.Add(My.Resources.STATSTRING_D2_CLASS_1)
    cmbClass.Items.Add(My.Resources.STATSTRING_D2_CLASS_2)
    cmbClass.Items.Add(My.Resources.STATSTRING_D2_CLASS_3)
    cmbClass.Items.Add(My.Resources.STATSTRING_D2_CLASS_4)
    If chkExp.Checked Then
      cmbClass.Items.Add(My.Resources.STATSTRING_D2_CLASS_5)
      cmbClass.Items.Add(My.Resources.STATSTRING_D2_CLASS_6)
    End If
  End Sub

  Private Sub cmdRealmNewCancel_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmNewCancel.Click
    DisplayRealmCharListing(False)
  End Sub

  Private Sub cmdRealmStateCancel_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmStateCancel.Click
    MCP_Disconnect()
    Realms.Status = D2Realm.RealmState.Offline
    tbsLists.SelectedTab = tabChannel
  End Sub

  Private Sub cmdRealmLoginCancel_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmLoginCancel.Click
    If Realms.CharListing.Count = 0 Then
      MCP_Disconnect()
      Realms.Status = D2Realm.RealmState.Offline
      tbsLists.SelectedTab = tabChannel
    Else
      DisplayRealmCharListing(False)
    End If
  End Sub

  Private Sub cmdRealmCharCancel_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmCharCancel.Click
    MCP_Disconnect()
    Realms.Status = D2Realm.RealmState.Offline
    tbsLists.SelectedTab = tabChannel
  End Sub

  Private Sub lstRealms_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles lstRealms.SelectedIndexChanged
    lblRealmDescription.Text = Realms.RealmListing.GetRealm(lstRealms.SelectedIndex).Description
  End Sub

  Private Sub cmdRealmLogin_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmLogin.Click
    If lstRealms.SelectedIndex = -1 Then lstRealms.SelectedIndex = 0
    lblRealmName.Text = lstRealms.SelectedItem
    If sckMCP.IsConnected Then MCP_Disconnect(False)
    BNCS_LOGONREALMEX_Send(lblRealmName.Text)
  End Sub

  Private Sub lvRealmChars_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles lvRealmChars.SelectedIndexChanged
    If lvRealmChars.SelectedItems.Count = 0 Then
      cmdRealmCreate.Enabled = Realms.CharListing.Count < 8
      cmdRealmUpgrade.Enabled = False
      cmdRealmDelete.Enabled = False
      cmdRealmCharLogin.Enabled = False
      cmdRealmCharCancel.Enabled = lblChannel.Tag = Nothing
      cmdRealmChange.Enabled = Realms.RealmListing.GetRealms.Length > 1
    Else
      cmdRealmCreate.Enabled = Realms.CharListing.Count < 8
      cmdRealmUpgrade.Enabled = Config.Account.Client.Product = GameType.D2XP And Not Realms.CharListing.GetChar(lvRealmChars.SelectedIndices(0)).Expansion
      cmdRealmDelete.Enabled = True
      cmdRealmCharLogin.Enabled = Not (Realms.CharListing.GetChar(lvRealmChars.SelectedIndices(0)).Expansion And Config.Account.Client.Product = GameType.D2DV)
      cmdRealmCharCancel.Enabled = lblChannel.Tag = Nothing
      cmdRealmChange.Enabled = Realms.RealmListing.GetRealms.Length > 1
    End If
  End Sub

  Private Sub cmdRealmCreate_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmCreate.Click
    DisplayRealmCharCreate()
  End Sub

  Private Sub cmdRealmUpgrade_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmUpgrade.Click
    If Config.Account.Client.Product = GameType.D2XP Then
      MCP_CHARUPGRADE_Send(Realms.CharListing.GetChar(lvRealmChars.SelectedIndices(0)).Character)
    Else
      MsgBox(My.Resources.REALM_UPONCLASSIC, MsgBoxStyle.Critical, My.Resources.REALM_TITLE)
    End If
  End Sub

  Private Sub cmdRealmDelete_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmDelete.Click
    If MsgBox(ResString(My.Resources.DELETE_CONFIRM, Realms.CharListing.GetChar(lvRealmChars.SelectedIndices(0)).Character), MsgBoxStyle.Question Or MsgBoxStyle.YesNo, My.Resources.REALM_TITLE) = MsgBoxResult.Yes Then
      MCP_CHARDELETE_Send(Realms.CharListing.GetChar(lvRealmChars.SelectedIndices(0)).Character)
    End If
  End Sub

  Private Sub cmdRealmCharLogin_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmCharLogin.Click
    If lvRealmChars.Items.Count = 1 Then
      If Realms.CharListing.GetChar(0).Expansion And Config.Account.Client.Product = GameType.D2DV Then
        MsgBox(My.Resources.REALM_EXPONCLASSIC, MsgBoxStyle.Critical + MsgBoxStyle.ApplicationModal, My.Resources.REALM_TITLE)
      Else
        tbsLists.SelectedTab = tabChannel
        MCP_CHARLOGON_Send(Realms.CharListing.GetChar(0).Character)
      End If
    ElseIf lvRealmChars.SelectedItems.Count = 1 Then
      If Realms.CharListing.GetChar(lvRealmChars.SelectedIndices(0)).Expansion And Config.Account.Client.Product = GameType.D2DV Then
        MsgBox(My.Resources.REALM_EXPONCLASSIC, MsgBoxStyle.Critical + MsgBoxStyle.ApplicationModal, My.Resources.REALM_TITLE)
      Else
        tbsLists.SelectedTab = tabChannel
        MCP_CHARLOGON_Send(Realms.CharListing.GetChar(lvRealmChars.SelectedIndices(0)).Character)
      End If
    End If
  End Sub

  Private Sub cmdRealmChange_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmChange.Click
    DisplayRealmListing(False)
  End Sub

  Private Sub cmdRealmStateReconnect_Click(sender As System.Object, e As System.EventArgs) Handles cmdRealmStateReconnect.Click
    DisplayRealmListing(False)
  End Sub

#End Region

#Region "BNet Packets"
  Private Sub BNCS_NULL_Recv(pktRead As BNCSReader)
    BNCS_NULL_Send()
  End Sub

  Private Sub BNCS_NULL_Send()
    Using pktTemp As New BNCSPacket(BNCS_NULL)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_STOPADV_Send()
    If lblChannel.Tag IsNot Nothing Then
      Using pktTemp As New BNCSPacket(BNCS_STOPADV)
        BNCS_Send(pktTemp)
      End Using
    End If
  End Sub

  Private Sub BNCS_SERVERLIST_Recv(pktRead As BNCSReader)
    'Dim ServVer As UInt32 = pktRead.ReadUInt32
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, pktRead.ToString)
  End Sub

  Private Sub BNCS_CLIENTID_Recv(pktRead As BNCSReader)
    Dim cReg As RegistryKey
    cReg = Registry.CurrentUser.OpenSubKey("Software\Battle.net\Configuration", True)
    If cReg Is Nothing Then
      Registry.CurrentUser.CreateSubKey("Software\Battle.net\Configuration")
      cReg = Registry.CurrentUser.OpenSubKey("Software\Battle.net\Configuration", True)
    End If
    cReg.SetValue("Registration Version", pktRead.ReadInt32)
    cReg.SetValue("Registration Authority", pktRead.ReadInt32)
    cReg.SetValue("Client ID", pktRead.ReadInt32)
    cReg.SetValue("Client Token", pktRead.ReadInt32)
  End Sub

  Private Sub BNCS_CLIENTID_Send()
    Using pktTemp As New BNCSPacket(BNCS_CLIENTID)
      Dim cReg As RegistryKey
      cReg = Registry.CurrentUser.OpenSubKey("Software\Battle.net\Configuration")
      If cReg Is Nothing Then
        pktTemp.InsertUInt32(0)
        pktTemp.InsertUInt32(0)
        pktTemp.InsertUInt32(0)
        pktTemp.InsertUInt32(0)
      Else
        pktTemp.InsertUInt32(cReg.GetValue("Registration Version", 0).ToString)
        pktTemp.InsertUInt32(cReg.GetValue("Registration Authority", 0).ToString)
        pktTemp.InsertUInt32(cReg.GetValue("Client ID", 0).ToString)
        pktTemp.InsertUInt32(cReg.GetValue("Client Token", 0).ToString)
      End If
      pktTemp.InsertCString(Environment.MachineName)
      pktTemp.InsertCString(Environment.UserName)
      BNCS_Send(pktTemp)
    End Using
    BNCS_LOCALEINFO_Send()
    If Config.Account.Client.Product = GameType.JSTR Or Config.Account.Client.Product = GameType.SSHR Then BNCS_SYSTEMINFO_Send()
    BNCS_STARTVERSIONING_Send()
  End Sub

  Private Sub BNCS_STARTVERSIONING_Recv(pktRead As BNCSReader)
    CRev.MPQTime = pktRead.ReadUInt64
    CRev.MPQName = pktRead.ReadCString
    CRev.Request = pktRead.ReadNullTerminatedByteArray
    BNCS_REPORTVERSION_Send()
  End Sub

  Private Sub BNCS_STARTVERSIONING_Send()
    Using pktTemp As New BNCSPacket(BNCS_STARTVERSIONING)
      pktTemp.InsertUInt32(GameArch.IX86)
      pktTemp.InsertUInt32(Config.Account.Client.Product)
      pktTemp.InsertUInt32(Config.VerByte)
      pktTemp.InsertUInt32(&H0)
      BNCS_Send(pktTemp)
    End Using
    If Config.PingSpoof = 1 Then
      BNCS_PING_Send(0)
    ElseIf Config.PingSpoof = 2 Then
      For I As Integer = 1 To 500
        If Not IsOnline Then Exit For
        BNCS_NULL_Send()
      Next
      BNCS_PING_Send(0)
    End If
    ChatData.PingFirst = Not Config.PingSpoof = 3
    ChatData.PingSpoofing = Environment.TickCount
  End Sub

  Private Sub BNCS_REPORTVERSION_Recv(pktRead As BNCSReader)
    Dim lRet As UInt32
    lRet = pktRead.ReadUInt32
    Select Case lRet
      Case &H0
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.VERSION_FAIL)
        UpdateHashFiles()
      Case &H1
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.VERSION_UPGRADE_PATCH, pktRead.ReadCString))
        UpdateHashFiles()
      Case &H2
        Select Case Config.Account.Client.Product
          Case GameType.DRTL, GameType.DSHR, GameType.SSHR
            BNCS_LOGONRESPONSE_Send()
          Case GameType.JSTR
            BNCS_CDKEY_Send()
          Case GameType.W2BN
            BNCS_CDKEY2_Send()
        End Select
      Case &H3
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.VERSION_REINSTALL)
        UpdateHashFiles()
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.VERSION_UNKNOWN, "BNCS_REPORTVERSION", Hex(lRet)))
        UpdateHashFiles()
    End Select
  End Sub

  Private Sub BNCS_REPORTVERSION_Send()
    Using pktTemp As New BNCSPacket(BNCS_REPORTVERSION)
      Dim HashFiles(2) As String
      Dim BINFile As String = Nothing
      Dim EXEVer As Int32
      Dim EXEHash As Int32
      Dim EXEInfo() As Byte
      GetHashFiles(HashFiles, BINFile)
      If String.IsNullOrEmpty(CRev.MPQName) Then Exit Sub
      pktTemp.InsertUInt32(GameArch.IX86)
      pktTemp.InsertUInt32(Config.Account.Client.Product)
      pktTemp.InsertUInt32(Config.VerByte)
      If CRev.MPQName.ToLower.Contains("ix86") Then
        If CRev.MPQName.ToLower.Contains("ver") Then
          Dim sRequest = Encoding.GetEncoding(LATIN_1).GetString(CRev.Request)
          Dim EXEInfoS As String = String.Empty
          EXEVer = CheckRevision.GetExeInfo(HashFiles(0), EXEInfoS)
          EXEHash = CheckRevision.DoCheckRevision(sRequest, HashFiles, CheckRevision.ExtractMPQNumber(CRev.MPQName))
          EXEInfo = Encoding.GetEncoding(LATIN_1).GetBytes(EXEInfoS)
        ElseIf CRev.MPQName.ToLower.Contains("lockdown") Then
          Dim MPQPath As String = AppTemp & "\MPQs\" & CRev.MPQName
          Dim DLLPath As String = AppStore & "\CheckRevision Libraries\" & CRev.MPQName.Substring(0, InStr(CRev.MPQName, ".")) & "dll"
          If Not My.Computer.FileSystem.DirectoryExists(AppStore & "\CheckRevision Libraries") Then My.Computer.FileSystem.CreateDirectory(AppStore & "\CheckRevision Libraries")
          If Not My.Computer.FileSystem.FileExists(DLLPath) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_DOWNLOADING, CRev.MPQName))
            If BNFTPRequest(GameArch.IX86, Config.Account.Client.Product, MPQPath, Nothing) Then
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_OK, CRev.MPQName))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_FTP, ResString(My.Resources.ERR_FTP_FAIL, CRev.MPQName))
              BNCS_Disconnect(True)
              Exit Sub
            End If
            Using Archive As New MPQ(MPQPath)
              Dim sFile As String = Archive.GetListFile
              If String.IsNullOrEmpty(sFile) Then
                gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_MPQ_NOLIST, CRev.MPQName))
                BNCS_Disconnect(True)
                Exit Sub
              End If
              If InStr(sFile, vbCr) Then sFile = Split(sFile, vbCr)(0)
              sFile = sFile.Trim(" ", vbCr, vbLf, vbNullChar)
              Dim SaveRet As MPQ.MPQSaveError = Archive.SaveToPath(sFile, IO.Path.GetDirectoryName(DLLPath))
              Select Case SaveRet
                Case MPQ.MPQSaveError.Success
                  'OK
                Case MPQ.MPQSaveError.FileNotFound
                  gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_MPQ_NOTFOUND, sFile, CRev.MPQName))
                  BNCS_Disconnect(True)
                  Exit Sub
                Case MPQ.MPQSaveError.MPQCorrupt
                  gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_MPQ_CORRUPT, sFile, CRev.MPQName))
                  BNCS_Disconnect(True)
                  Exit Sub
                Case MPQ.MPQSaveError.NoMPQ
                  gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_MPQ_NO, CRev.MPQName))
                  BNCS_Disconnect(True)
                  Exit Sub
                Case MPQ.MPQSaveError.UnknownFailure
                  gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_MPQ_FAIL, sFile, CRev.MPQName))
                  BNCS_Disconnect(True)
                  Exit Sub
              End Select
            End Using
          End If
          EXEInfo = Lockdown.CheckRevision(CRev.Request, HashFiles, DLLPath, BINFile, EXEVer, EXEHash)
        Else
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_UNKNOWN, CRev.MPQName))
          BNCS_Disconnect(True)
          Exit Sub
        End If
      ElseIf CRev.MPQName.ToLower.Contains("pmac") Then
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_AUTH_CRAV_PMAC)
        BNCS_Disconnect(True)
        Exit Sub
      ElseIf CRev.MPQName.ToLower.Contains("xmac") Then
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_AUTH_CREV_XMAC)
        BNCS_Disconnect(True)
        Exit Sub
      Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_UNKNOWN, CRev.MPQName))
        BNCS_Disconnect(True)
        Exit Sub
      End If
      pktTemp.InsertInt32(EXEVer)
      pktTemp.InsertInt32(EXEHash)
      pktTemp.InsertByteArray(EXEInfo)
      pktTemp.InsertByte(0)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_STARTADVEX_Recv(pktRead As BNCSReader)
    Select Case pktRead.ReadBoolean
      Case True
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_STARTADVEX)
      Case False
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_STARTADVEX)
    End Select
  End Sub

  Private Sub BNCS_STARTADVEX_Send(State As UInt32, UpTime As UInt32, GameType As UInt16, Teams As UInt16, GameName As String, GamePassword As String, GameCreator As String, GameMap As String, GameSpeed As Byte)
    Using pktTemp As New BNCSPacket(BNCS_STARTADVEX)
      pktTemp.InsertUInt32(State)
      pktTemp.InsertUInt32(UpTime)
      pktTemp.InsertUInt16(GameType)
      If GameType = &HF Then
        pktTemp.InsertUInt16(Teams)
      Else
        pktTemp.InsertUInt16(&H1)
      End If
      pktTemp.InsertUInt32(0)
      pktTemp.InsertUInt32(0)
      pktTemp.InsertCString(GameName)
      pktTemp.InsertCString(GamePassword)
      pktTemp.InsertCString(CreateGameStatString("SSHR", GameMap, GameSpeed, GameType, Teams, GameCreator))
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_GETADVLISTEX_Recv(pktRead As BNCSReader)
    Dim GameList As UInt32 = pktRead.ReadUInt32
    If GameList = 0 Then
      Dim Status As UInt32 = pktRead.ReadUInt32
      Select Case Status
        Case &H0
          If ChatData.PubGameList Then
            QueueMessage(My.Resources.INFO_GAMELIST_RESULT & My.Resources.INFO_GAMELIST_RESULT_0)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_GAMELIST_RESULT_0)
          End If
        Case &H1
          If ChatData.PubGameList Then
            QueueMessage(My.Resources.INFO_GAMELIST_RESULT & My.Resources.INFO_GAMELIST_RESULT_1)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_GAMELIST_RESULT_1)
          End If
        Case &H2
          If ChatData.PubGameList Then
            QueueMessage(My.Resources.INFO_GAMELIST_RESULT & My.Resources.INFO_GAMELIST_RESULT_2)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_GAMELIST_RESULT_2)
          End If
        Case &H3
          If ChatData.PubGameList Then
            QueueMessage(My.Resources.INFO_GAMELIST_RESULT & My.Resources.INFO_GAMELIST_RESULT_3)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_GAMELIST_RESULT_3)
          End If
        Case &H4
          If ChatData.PubGameList Then
            QueueMessage(My.Resources.INFO_GAMELIST_RESULT & My.Resources.INFO_GAMELIST_RESULT_4)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_GAMELIST_RESULT_4)
          End If
        Case &H6
          If ChatData.PubGameList Then
            QueueMessage(My.Resources.INFO_GAMELIST_RESULT & My.Resources.INFO_GAMELIST_RESULT_6)
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_GAMELIST_RESULT_6)
          End If
        Case Else
          If ChatData.PubGameList Then
            QueueMessage(My.Resources.INFO_GAMELIST_RESULT & ResString(My.Resources.INFO_GAMELIST_RESULT_UNKNOWN, Status))
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_RESULT_UNKNOWN, Status))
          End If
      End Select
    Else
      If GameList = 1 Then
        Select Case Config.Account.Client.Product
          Case BNUI.GameType.DRTL, BNUI.GameType.DSHR
            Dim GameType As UInt16 = pktRead.ReadUInt16
            Dim Parameter As UInt16 = pktRead.ReadUInt16
            Dim LanguageID As UInt32 = pktRead.ReadUInt32
            Dim AddressFamily As UInt16 = pktRead.ReadUInt16
            Dim Port As UInt16 = pktRead.ReadUInt16
            Dim HostIP As UInt32 = pktRead.ReadUInt32
            Dim Null1 As UInt32 = pktRead.ReadUInt32
            Dim Null2 As UInt32 = pktRead.ReadUInt32
            Dim GameStatus As UInt32 = pktRead.ReadUInt32
            Dim GameTime As UInt32 = pktRead.ReadUInt32
            Dim GameName As String = pktRead.ReadCString
            Dim GamePassword As String = pktRead.ReadCString
            Dim GameStatString As String = pktRead.ReadCString
            Dim Difficulty As String = ResString(My.Resources.INFO_DIFFICULTY_UNKNOWN, "0")
            Select Case GameStatString.Split(vbCr).First
              Case "0" : Difficulty = My.Resources.STATSTRING_D2_DIFFICULTY_NORMAL
              Case "1" : Difficulty = My.Resources.STATSTRING_D2_DIFFICULTY_NIGHTMARE
              Case "2" : Difficulty = My.Resources.STATSTRING_D2_DIFFICULTY_HELL
              Case Else : Difficulty = ResString(My.Resources.INFO_DIFFICULTY_UNKNOWN, GameStatString.Split(vbCr).First)
            End Select
            Dim CharStatString As String = ParseStatString(GameStatString.Split(vbCr)(2))
            CharStatString = CharStatString.Substring(CharStatString.IndexOf(":") + 1)
            If ChatData.PubGameList Then
              QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_DRTL, GameName, GameStatString.Split(vbCr)(1), Difficulty, New IPAddress(HostIP).ToString, ConvertTime(GameTime * 1000, True)))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_GAME, GameName))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_CREATOR, GameStatString.Split(vbCr)(1), CharStatString))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_DIFF, Difficulty))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_IP, New IPAddress(HostIP).ToString))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_LANG, Globalization.CultureInfo.GetCultureInfo(CInt(LanguageID)).EnglishName))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_TIME, ConvertTime(GameTime * 1000, True)))
            End If
          Case BNUI.GameType.STAR, BNUI.GameType.SEXP
            Dim GameType As UInt16 = pktRead.ReadUInt16
            Dim Parameter As UInt16 = pktRead.ReadUInt16
            Dim LanguageID As UInt32 = pktRead.ReadUInt32
            Dim AddressFamily As UInt16 = pktRead.ReadUInt16
            Dim Port As UInt16 = pktRead.ReadUInt16
            Dim HostIP As UInt32 = pktRead.ReadUInt32
            Dim Null1 As UInt32 = pktRead.ReadUInt32
            Dim Null2 As UInt32 = pktRead.ReadUInt32
            Dim GameStatus As UInt32 = pktRead.ReadUInt32
            Dim GameTime As UInt32 = pktRead.ReadUInt32
            Dim aName() As Byte = pktRead.ReadNullTerminatedByteArray
            Dim GameName As String = Encoding.GetEncoding(UTF_8).GetString(aName)
            Dim GamePassword As String = pktRead.ReadCString
            Dim GameStats() As Byte = pktRead.ReadNullTerminatedByteArray
            Dim GameStatString As String = Encoding.GetEncoding(LATIN_1).GetString(GameStats)
            If ChatData.PubGameList Then
              QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_STAR, GameName, ParseSCStat.ParseMapStats(GameStatString, False).Replace(vbNewLine, ", "), New IPAddress(HostIP).ToString, ConvertTime(GameTime * 1000, True)))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_GAME, GameName))
              For Each parseItem In ParseSCStat.ParseMapStats(GameStatString).Split(vbNewLine)
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, " " & parseItem)
              Next
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_IP, New IPAddress(HostIP).ToString))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_LANG, Globalization.CultureInfo.GetCultureInfo(CInt(LanguageID)).EnglishName))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_TIME, ConvertTime(GameTime * 1000, True)))
            End If
          Case BNUI.GameType.JSTR, BNUI.GameType.SSHR
            Dim GameType As UInt16 = pktRead.ReadUInt16
            Dim Parameter As UInt16 = pktRead.ReadUInt16
            Dim LanguageID As UInt32 = pktRead.ReadUInt32
            Dim AddressFamily As UInt16 = pktRead.ReadUInt16
            Dim Port As UInt16 = pktRead.ReadUInt16
            Dim HostIP As UInt32 = pktRead.ReadUInt32
            Dim Null1 As UInt32 = pktRead.ReadUInt32
            Dim Null2 As UInt32 = pktRead.ReadUInt32
            Dim GameStatus As UInt32 = pktRead.ReadUInt32
            Dim GameTime As UInt32 = pktRead.ReadUInt32
            Dim aName() As Byte = pktRead.ReadNullTerminatedByteArray
            Dim GameName As String = Encoding.GetEncoding(UTF_8).GetString(aName)
            Dim GamePassword As String = pktRead.ReadCString
            Dim GameStats() As Byte = pktRead.ReadNullTerminatedByteArray
            Dim GameStatString As String = Encoding.GetEncoding(LATIN_1).GetString(GameStats)
            If ChatData.PubGameList Then
              QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_STAR, GameName, ParseJSSCStat.ParseMapStats(GameStatString, False).Replace(vbNewLine, ", "), New IPAddress(HostIP).ToString, ConvertTime(GameTime * 1000, True)))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_GAME, GameName))
              For Each parseItem In ParseJSSCStat.ParseMapStats(GameStatString).Split(vbNewLine)
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, " " & parseItem)
              Next
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_IP, New IPAddress(HostIP).ToString))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_LANG, Globalization.CultureInfo.GetCultureInfo(CInt(LanguageID)).EnglishName))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_TIME, ConvertTime(GameTime * 1000, True)))
            End If
          Case BNUI.GameType.W2BN
            Dim GameType As UInt16 = pktRead.ReadUInt16
            Dim Parameter As UInt16 = pktRead.ReadUInt16
            Dim LanguageID As UInt32 = pktRead.ReadUInt32
            Dim AddressFamily As UInt16 = pktRead.ReadUInt16
            Dim Port As UInt16 = pktRead.ReadUInt16
            Dim HostIP As UInt32 = pktRead.ReadUInt32
            Dim Null1 As UInt32 = pktRead.ReadUInt32
            Dim Null2 As UInt32 = pktRead.ReadUInt32
            Dim GameStatus As UInt32 = pktRead.ReadUInt32
            Dim GameTime As UInt32 = pktRead.ReadUInt32
            Dim aName() As Byte = pktRead.ReadNullTerminatedByteArray
            Dim GameName As String = Encoding.GetEncoding(LATIN_1).GetString(aName)
            Dim GamePassword As String = pktRead.ReadCString
            Dim GameStats() As Byte = pktRead.ReadNullTerminatedByteArray
            Dim GameStatString As String = Encoding.GetEncoding(LATIN_1).GetString(GameStats)
            If ChatData.PubGameList Then
              QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_STAR, GameName, ParseW2Stat.ParseMapStats(GameStatString, False).Replace(vbNewLine, ", "), New IPAddress(HostIP).ToString, ConvertTime(GameTime * 1000, True)))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_GAME, GameName))
              For Each parseItem In ParseW2Stat.ParseMapStats(GameStatString).Split(vbNewLine)
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, " " & parseItem)
              Next
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_IP, New IPAddress(HostIP).ToString))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_LANG, Globalization.CultureInfo.GetCultureInfo(CInt(LanguageID)).EnglishName))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_TIME, ConvertTime(GameTime * 1000, True)))
            End If
          Case BNUI.GameType.WAR3, BNUI.GameType.W3XP
            Dim GameType As UInt32 = pktRead.ReadUInt32
            Dim LanguageID As UInt32 = pktRead.ReadUInt32
            Dim AddressFamily As UInt16 = pktRead.ReadUInt16
            Dim Port As UInt16 = pktRead.ReadUInt16
            Dim HostIP As UInt32 = pktRead.ReadUInt32
            Dim Null1 As UInt32 = pktRead.ReadUInt32
            Dim Null2 As UInt32 = pktRead.ReadUInt32
            Dim GameVisible As UInt32 = pktRead.ReadUInt32
            Dim GameTime As UInt32 = pktRead.ReadUInt32
            Dim GameName As String = Encoding.GetEncoding(UTF_8).GetString(pktRead.ReadNullTerminatedByteArray)
            Dim GameNull As Byte = pktRead.ReadByte
            Dim FreeSlots As Byte = Byte.Parse(Chr(pktRead.ReadByte), NumberStyles.HexNumber)
            Dim HostCounter As String = System.Text.Encoding.GetEncoding(LATIN_1).GetString(pktRead.ReadByteArray(8))
            Dim GameStats() As Byte = pktRead.ReadNullTerminatedByteArray
            Dim MapStats() As Byte = Nothing
            ParseW3Stat.Map.DecodeData(GameStats, MapStats)
            Dim pktMap As New DataReader(MapStats)
            Dim MapFlags As UInt32 = pktMap.ReadUInt32
            Dim MapNull1 As Byte = pktMap.ReadByte
            Dim MapWidth As UInt16 = pktMap.ReadUInt16
            Dim MapHeight As UInt16 = pktMap.ReadUInt16
            Dim MapCRC As UInt32 = pktMap.ReadUInt32
            Dim MapPath As String = pktMap.ReadCString
            Dim MapHost As String = pktMap.ReadCString
            Dim MapNull2 As Byte = pktMap.ReadByte
            Dim MapHash() As Byte = pktMap.ReadByteArray(20)
            If ChatData.PubGameList Then
              QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_WAR3, GameName, MapHost, FreeSlots, IIf(ParseW3Stat.Game.PrivateGame(GameType), My.Resources.INFO_GAMELIST_PUB_WAR3_4, String.Empty), ParseW3Stat.Map.Speed(MapFlags), ParseW3Stat.Map.Visibility(MapFlags), ParseW3Stat.Map.Refs(MapFlags), ParseW3Stat.Game.Observers(GameType), IIf(ParseW3Stat.Map.TeamTogether(MapFlags), My.Resources.INFO_GAMELIST_PUB_WAR3_9, String.Empty), IIf(ParseW3Stat.Map.FixedTeam(MapFlags), My.Resources.INFO_GAMELIST_PUB_WAR3_10, String.Empty), IIf(ParseW3Stat.Map.UnitShare(MapFlags), My.Resources.INFO_GAMELIST_PUB_WAR3_11, String.Empty), IIf(ParseW3Stat.Map.RandomHero(MapFlags), My.Resources.INFO_GAMELIST_PUB_WAR3_12, String.Empty), IIf(ParseW3Stat.Map.RandomRace(MapFlags), My.Resources.INFO_GAMELIST_PUB_WAR3_13, String.Empty), ParseW3Stat.Game.GameType(GameType), ParseW3Stat.Game.BattleType(GameType), MapPath, MapWidth, MapHeight, ParseW3Stat.Game.MapSize(GameType), IIf(ParseW3Stat.Game.CustomMap(GameType), My.Resources.INFO_GAMELIST_PUB_WAR3_17, String.Empty), IIf(ParseW3Stat.Game.BlizMap(GameType), My.Resources.INFO_GAMELIST_PUB_WAR3_18, String.Empty), PadHex(MapCRC, 8), New IPAddress(HostIP).ToString, ConvertTime(GameTime * 1000, True)))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_GAME, GameName))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_CREATOR, MapHost))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_SLOTS, FreeSlots))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_SETTINGS, IIf(ParseW3Stat.Game.PrivateGame(GameType), My.Resources.INFO_GAMELIST_PUB_WAR3_4, String.Empty), ParseW3Stat.Map.Speed(MapFlags), ParseW3Stat.Map.Visibility(MapFlags), ParseW3Stat.Map.Refs(MapFlags), ParseW3Stat.Game.Observers(GameType), IIf(ParseW3Stat.Map.TeamTogether(MapFlags), My.Resources.INFO_GAMELIST_PUB_WAR3_9, String.Empty), IIf(ParseW3Stat.Map.FixedTeam(MapFlags), My.Resources.INFO_GAMELIST_PUB_WAR3_10, String.Empty), IIf(ParseW3Stat.Map.UnitShare(MapFlags), My.Resources.INFO_GAMELIST_PUB_WAR3_11, String.Empty), IIf(ParseW3Stat.Map.RandomHero(MapFlags), My.Resources.INFO_GAMELIST_PUB_WAR3_12, String.Empty), IIf(ParseW3Stat.Map.RandomRace(MapFlags), My.Resources.INFO_GAMELIST_PUB_WAR3_13, String.Empty)))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_TYPE, ParseW3Stat.Game.GameType(GameType), ParseW3Stat.Game.BattleType(GameType)))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_MAP, MapPath, MapWidth, MapHeight, ParseW3Stat.Game.MapSize(GameType), IIf(ParseW3Stat.Game.CustomMap(GameType), My.Resources.INFO_GAMELIST_PUB_WAR3_17, String.Empty), IIf(ParseW3Stat.Game.BlizMap(GameType), My.Resources.INFO_GAMELIST_PUB_WAR3_18, String.Empty), PadHex(MapCRC, 8)))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_IP, New IPAddress(HostIP).ToString))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_LANG, Globalization.CultureInfo.GetCultureInfo(CInt(LanguageID)).EnglishName))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_TIME, ConvertTime(GameTime * 1000, True)))
            End If
          Case BNUI.GameType.D2DV, BNUI.GameType.D2XP
            Dim GameType As UInt16 = pktRead.ReadUInt16
            Dim Parameter As UInt16 = pktRead.ReadUInt16
            Dim LanguageID As UInt32 = pktRead.ReadUInt32
            Dim AddressFamily As UInt16 = pktRead.ReadUInt16
            Dim Port As UInt16 = pktRead.ReadUInt16
            Dim HostIP As UInt32 = pktRead.ReadUInt32
            Dim Null1 As UInt32 = pktRead.ReadUInt32
            Dim Null2 As UInt32 = pktRead.ReadUInt32
            Dim GameStatus As UInt32 = pktRead.ReadUInt32
            Dim GameTime As UInt32 = pktRead.ReadUInt32
            Dim GameName As String = pktRead.ReadCString
            Dim GamePassword As String = pktRead.ReadCString
            Dim GameStats() As Byte = pktRead.ReadNullTerminatedByteArray
            If ChatData.PubGameList Then
              QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_D2, GameName, New IPAddress(HostIP).ToString, ConvertTime(GameTime * 1000, True)))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_GAME, GameName))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_IP, New IPAddress(HostIP).ToString))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_LANG, Globalization.CultureInfo.GetCultureInfo(CInt(LanguageID)).EnglishName))
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PRIV_TIME, ConvertTime(GameTime * 1000, True)))
            End If
          Case Else
            Debug.Print(pktRead.ToString)
            If ChatData.PubGameList Then
              QueueMessage(ResString(My.Resources.ERR_GAMELIST_INCOMPLETE, GameTypeToGameTitle(Config.Account.Client.Product)))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_GAMELIST_INCOMPLETE, GameTypeToGameTitle(Config.Account.Client.Product)))
            End If
        End Select
      Else
        If ChatData.PubGameList Then
          QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_COUNT, GameList))
        Else
          gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PUB_COUNT, GameList))
        End If
        Select Case Config.Account.Client.Product
          Case BNUI.GameType.DRTL, BNUI.GameType.DSHR
            For I As Integer = 0 To GameList - 1
              Dim GameType As UInt16 = pktRead.ReadUInt16
              Dim Parameter As UInt16 = pktRead.ReadUInt16
              Dim LanguageID As UInt32 = pktRead.ReadUInt32
              Dim AddressFamily As UInt16 = pktRead.ReadUInt16
              Dim Port As UInt16 = pktRead.ReadUInt16
              Dim HostIP As UInt32 = pktRead.ReadUInt32
              Dim Null1 As UInt32 = pktRead.ReadUInt32
              Dim Null2 As UInt32 = pktRead.ReadUInt32
              Dim GameStatus As UInt32 = pktRead.ReadUInt32
              Dim GameTime As UInt32 = pktRead.ReadUInt32
              Dim aName() As Byte = pktRead.ReadNullTerminatedByteArray
              Dim GameName As String = Encoding.GetEncoding(LATIN_1).GetString(aName)
              Dim GamePassword As String = pktRead.ReadCString
              Dim GameStatString As String = pktRead.ReadCString
              Dim Difficulty As String = ResString(My.Resources.INFO_DIFFICULTY_UNKNOWN, "0")
              Select Case GameStatString.Split(vbCr).First
                Case "0" : Difficulty = My.Resources.STATSTRING_D2_DIFFICULTY_NORMAL
                Case "1" : Difficulty = My.Resources.STATSTRING_D2_DIFFICULTY_NIGHTMARE
                Case "2" : Difficulty = My.Resources.STATSTRING_D2_DIFFICULTY_HELL
                Case Else : Difficulty = ResString(My.Resources.INFO_DIFFICULTY_UNKNOWN, GameStatString.Split(vbCr).First)
              End Select
              If ChatData.PubGameList Then
                QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_CLASSIC, (I + 1), GameName, Difficulty))
              Else
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PUB_CLASSIC, (I + 1), GameName, Difficulty))
              End If
            Next I
          Case GameType.STAR, GameType.SEXP
            For I As Integer = 0 To GameList - 1
              Dim GameType As UInt16 = pktRead.ReadUInt16
              Dim Parameter As UInt16 = pktRead.ReadUInt16
              Dim LanguageID As UInt32 = pktRead.ReadUInt32
              Dim AddressFamily As UInt16 = pktRead.ReadUInt16
              Dim Port As UInt16 = pktRead.ReadUInt16
              Dim HostIP As UInt32 = pktRead.ReadUInt32
              Dim Null1 As UInt32 = pktRead.ReadUInt32
              Dim Null2 As UInt32 = pktRead.ReadUInt32
              Dim GameStatus As UInt32 = pktRead.ReadUInt32
              Dim GameTime As UInt32 = pktRead.ReadUInt32
              Dim aName() As Byte = pktRead.ReadNullTerminatedByteArray
              Dim GameName As String = Encoding.GetEncoding(UTF_8).GetString(aName)
              Dim GamePassword As String = pktRead.ReadCString
              Dim GameStats() As Byte = pktRead.ReadNullTerminatedByteArray
              Dim GameStatString As String = Encoding.GetEncoding(LATIN_1).GetString(GameStats)
              If ChatData.PubGameList Then
                QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_CLASSIC, (I + 1), GameName, ParseSCStat.ParseMapStats(GameStatString, True)))
              Else
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PUB_CLASSIC, (I + 1), GameName, ParseSCStat.ParseMapStats(GameStatString, True)))
              End If
            Next I
          Case GameType.JSTR, GameType.SSHR
            For I As Integer = 0 To GameList - 1
              Dim GameType As UInt16 = pktRead.ReadUInt16
              Dim Parameter As UInt16 = pktRead.ReadUInt16
              Dim LanguageID As UInt32 = pktRead.ReadUInt32
              Dim AddressFamily As UInt16 = pktRead.ReadUInt16
              Dim Port As UInt16 = pktRead.ReadUInt16
              Dim HostIP As UInt32 = pktRead.ReadUInt32
              Dim Null1 As UInt32 = pktRead.ReadUInt32
              Dim Null2 As UInt32 = pktRead.ReadUInt32
              Dim GameStatus As UInt32 = pktRead.ReadUInt32
              Dim GameTime As UInt32 = pktRead.ReadUInt32
              Dim aName() As Byte = pktRead.ReadNullTerminatedByteArray
              Dim GameName As String = Encoding.GetEncoding(UTF_8).GetString(aName)
              Dim GamePassword As String = pktRead.ReadCString
              Dim GameStats() As Byte = pktRead.ReadNullTerminatedByteArray
              Dim GameStatString As String = Encoding.GetEncoding(LATIN_1).GetString(GameStats)
              If ChatData.PubGameList Then
                QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_CLASSIC, (I + 1), GameName, ParseJSSCStat.ParseMapStats(GameStatString, True)))
              Else
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PUB_CLASSIC, (I + 1), GameName, ParseJSSCStat.ParseMapStats(GameStatString, True)))
              End If
            Next I
          Case GameType.W2BN
            For I As Integer = 0 To GameList - 1
              Dim GameType As UInt16 = pktRead.ReadUInt16
              Dim Parameter As UInt16 = pktRead.ReadUInt16
              Dim LanguageID As UInt32 = pktRead.ReadUInt32
              Dim AddressFamily As UInt16 = pktRead.ReadUInt16
              Dim Port As UInt16 = pktRead.ReadUInt16
              Dim HostIP As UInt32 = pktRead.ReadUInt32
              Dim Null1 As UInt32 = pktRead.ReadUInt32
              Dim Null2 As UInt32 = pktRead.ReadUInt32
              Dim GameStatus As UInt32 = pktRead.ReadUInt32
              Dim GameTime As UInt32 = pktRead.ReadUInt32
              Dim aName() As Byte = pktRead.ReadNullTerminatedByteArray
              Dim GameName As String = Encoding.GetEncoding(LATIN_1).GetString(aName)
              Dim GamePassword As String = pktRead.ReadCString
              Dim GameStats() As Byte = pktRead.ReadNullTerminatedByteArray
              Dim GameStatString As String = Encoding.GetEncoding(LATIN_1).GetString(GameStats)
              If ChatData.PubGameList Then
                QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_CLASSIC, (I + 1), GameName, ParseW2Stat.ParseMapStats(GameStatString, True)))
              Else
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PUB_CLASSIC, (I + 1), GameName, ParseW2Stat.ParseMapStats(GameStatString, True)))
              End If
            Next I
          Case BNUI.GameType.WAR3, BNUI.GameType.W3XP
            For I As Integer = 0 To GameList - 1
              Dim GameType As UInt32 = pktRead.ReadUInt32
              Dim LanguageID As UInt32 = pktRead.ReadUInt32
              Dim AddressFamily As UInt16 = pktRead.ReadUInt16
              Dim Port As UInt16 = pktRead.ReadUInt16
              Dim HostIP As UInt32 = pktRead.ReadUInt32
              Dim Null1 As UInt32 = pktRead.ReadUInt32
              Dim Null2 As UInt32 = pktRead.ReadUInt32
              Dim GameVisible As UInt32 = pktRead.ReadUInt32
              Dim GameTime As UInt32 = pktRead.ReadUInt32
              Dim GameName As String = Encoding.UTF8.GetString(pktRead.ReadNullTerminatedByteArray)
              Dim GameNull As Byte = pktRead.ReadByte
              Dim FreeSlots As Byte = Byte.Parse(Chr(pktRead.ReadByte), NumberStyles.HexNumber)
              Dim HostCounter As String = System.Text.Encoding.GetEncoding(LATIN_1).GetString(pktRead.ReadByteArray(8))
              Dim GameStats() As Byte = pktRead.ReadNullTerminatedByteArray
              Dim MapStats() As Byte = Nothing
              ParseW3Stat.Map.DecodeData(GameStats, MapStats)
              Dim pktMap As New DataReader(MapStats)
              Dim MapFlags As UInt32 = pktMap.ReadUInt32
              Dim MapNull1 As Byte = pktMap.ReadByte
              Dim MapWidth As UInt16 = pktMap.ReadUInt16
              Dim MapHeight As UInt16 = pktMap.ReadUInt16
              Dim MapCRC As UInt32 = pktMap.ReadUInt32
              Dim MapPath As String = pktMap.ReadCString
              Dim MapHost As String = pktMap.ReadCString
              Dim MapNull2 As Byte = pktMap.ReadByte
              Dim MapHash() As Byte = pktMap.ReadByteArray(20)
              If ChatData.PubGameList Then
                QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_NEW, (I + 1), GameName))
              Else
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PUB_NEW, (I + 1), GameName))
              End If
            Next I
          Case BNUI.GameType.D2DV, BNUI.GameType.D2XP
            For I As Integer = 0 To GameList - 1
              Dim GameType As UInt16 = pktRead.ReadUInt16
              Dim Parameter As UInt16 = pktRead.ReadUInt16
              Dim LanguageID As UInt32 = pktRead.ReadUInt32
              Dim AddressFamily As UInt16 = pktRead.ReadUInt16
              Dim Port As UInt16 = pktRead.ReadUInt16
              Dim HostIP As UInt32 = pktRead.ReadUInt32
              Dim Null1 As UInt32 = pktRead.ReadUInt32
              Dim Null2 As UInt32 = pktRead.ReadUInt32
              Dim GameStatus As UInt32 = pktRead.ReadUInt32
              Dim GameTime As UInt32 = pktRead.ReadUInt32
              Dim aName() As Byte = pktRead.ReadNullTerminatedByteArray
              Dim GameName As String = Encoding.GetEncoding(LATIN_1).GetString(aName)
              Dim GamePassword As String = pktRead.ReadCString
              Dim GameStats() As Byte = pktRead.ReadNullTerminatedByteArray
              If ChatData.PubGameList Then
                QueueMessage(ResString(My.Resources.INFO_GAMELIST_PUB_NEW, (I + 1), GameName))
              Else
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_GAMELIST_PUB_NEW, (I + 1), GameName))
              End If
            Next I
          Case Else
            Debug.Print(pktRead.ToString)
            If ChatData.PubGameList Then
              QueueMessage(ResString(My.Resources.ERR_GAMELIST_INCOMPLETE, GameTypeToGameTitle(Config.Account.Client.Product)))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_GAMELIST_INCOMPLETE, GameTypeToGameTitle(Config.Account.Client.Product)))
            End If
        End Select
      End If
    End If
    ChatData.PubGameList = Nothing
  End Sub

  Private Sub BNCS_GETADVLISTEX_Send(GameType As UInt16, SubType As UInt16, Filter As UInt32, Reserved As UInt32, ListCount As UInt32, GameName As String, GamePassword As String, GameStatString As String)
    Using pktTemp As New BNCSPacket(BNCS_GETADVLISTEX)
      pktTemp.InsertUInt16(GameType)
      pktTemp.InsertUInt16(SubType)
      pktTemp.InsertUInt32(Filter)
      pktTemp.InsertUInt32(Reserved)
      pktTemp.InsertUInt32(ListCount)
      If String.IsNullOrEmpty(GameName) Then
        pktTemp.InsertByte(0)
      Else
        Dim bData() As Byte
        Select Case Config.Account.Client.Product
          Case BNUI.GameType.STAR, BNUI.GameType.SEXP, BNUI.GameType.JSTR, BNUI.GameType.SSHR
            bData = Encoding.GetEncoding(UTF_8).GetBytes(GameName)
          Case BNUI.GameType.WAR3, BNUI.GameType.W3XP
            bData = Encoding.UTF8.GetBytes(GameName)
          Case BNUI.GameType.DRTL, BNUI.GameType.DSHR, BNUI.GameType.D2DV, BNUI.GameType.D2XP, BNUI.GameType.W2BN
            bData = Encoding.GetEncoding(LATIN_1).GetBytes(GameName)
          Case Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_GAMELIST_INCOMPLETE, GameTypeToGameTitle(Config.Account.Client.Product)))
            Exit Sub
        End Select
        pktTemp.InsertByteArray(bData)
        pktTemp.InsertByte(0)
      End If
      pktTemp.InsertCString(GamePassword)
      pktTemp.InsertCString(GameStatString)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_ENTERCHAT_Recv(pktRead As BNCSReader)
    If ChatData.LoginTime = 0 Then
      bBNState = 3
      If Config.Proxy.Use And Config.Proxy.Ver = ProxyType.SOCKS5 Then
        wsIdent.Stop()
        If idThread IsNot Nothing Then
          wsIdent.Stop()
          idThread = Nothing
        End If
      End If
      BNetData.UniqueName = pktRead.ReadCString
      Dim StatString() As Byte = pktRead.ReadNullTerminatedByteArray
      Dim AccountName As String = pktRead.ReadCString
      ChatData.LoginTime = Environment.TickCount
      gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_LOGIN, BNetData.UniqueName, ParseStatString(StatString), AccountName))
      QueueList = New ChatQueue
      If Config.Account.Client.Product = GameType.WAR3 Or Config.Account.Client.Product = GameType.W3XP Then
        If Not tbsLists.Controls.Contains(tabClan) Then TabAdd(tabClan)
      Else
        If tbsLists.Controls.Contains(tabClan) Then TabRemove(tabClan)
      End If
      BNCS_FRIENDSLIST_Send()
    End If
  End Sub

  Private Sub BNCS_ENTERCHAT_Send(Optional StatString As String = Nothing)
    Using pktTemp As New BNCSPacket(BNCS_ENTERCHAT)
      Select Case Config.Account.Client.Product
        Case GameType.WAR3, GameType.W3XP
          pktTemp.InsertByte(&H0)
        Case Else
          pktTemp.InsertCString(Config.Account.Username)
      End Select
      Select Case Config.Account.Client.Product
        Case GameType.DRTL, GameType.DSHR, GameType.SSHR
          If String.IsNullOrEmpty(StatString) Then
            pktTemp.InsertCString(Config.Account.StatString)
          Else
            pktTemp.InsertCString(StatString)
          End If
        Case Else
          pktTemp.InsertByte(&H0)
      End Select
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_GETCHANNELLIST_Recv(pktRead As BNCSReader)
    ChannelListing_Clear()
    Do
      Dim sChannel As String = pktRead.ReadCString
      If String.IsNullOrEmpty(sChannel) Then Exit Do
      ChannelListing_Add(sChannel)
    Loop
  End Sub

  Private Sub BNCS_GETCHANNELLIST_Send()
    Using pktTemp As New BNCSPacket(BNCS_GETCHANNELLIST)
      pktTemp.InsertUInt32(Config.Account.Client.Product)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_JOINCHANNEL_Send(Optional Channel As String = Nothing, Optional Flags As JoinFlags = JoinFlags.Forced, Optional DoRetry As Boolean = True)
    Using pktTemp As New BNCSPacket(BNCS_JOINCHANNEL)
      If String.IsNullOrEmpty(Channel) Then
        If tmrRetryJoin IsNot Nothing Then
          tmrRetryJoin.Stop()
          tmrRetryJoin = Nothing
        End If
        If Config.Account.Client.Product = GameType.D2DV Or Config.Account.Client.Product = GameType.D2XP Then
          pktTemp.InsertUInt32(JoinFlags.D2First)
        Else
          pktTemp.InsertUInt32(JoinFlags.First)
        End If
        pktTemp.InsertCString(Config.Account.Client.Product.ToString)
      Else
        If Channel.Length > 31 Then Channel = Channel.Substring(0, 31)
        If StrComp(Channel, "The Void", CompareMethod.Text) = 0 Then BNetData.EnterVoid = True
        If DoRetry Then
          If tmrRetryJoin IsNot Nothing Then
            tmrRetryJoin.Stop()
            tmrRetryJoin = Nothing
          End If
          ChatData.RetryChannel = Channel
          ChatData.RetryCount = 0
        End If
        pktTemp.InsertUInt32(Flags)
        pktTemp.InsertCString(Channel)
      End If
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Public Sub BNCS_CHATCOMMAND_Send(sText As String)
    If sText.EndsWith("The Void", True, Nothing) = 0 Then BNetData.EnterVoid = True
    If sText.StartsWith("/") Then
      If sText.StartsWith("/unsquelch ", True, Nothing) Then
        Dim Username As String = sText.Substring(11)
        If Username.StartsWith("*") Then Username = Username.Substring(1)
        If Not String.IsNullOrEmpty((From sName As String In Config.SquelchList Where StrComp(sName, Username, CompareMethod.Text) = 0 Select sName).FirstOrDefault) Then Config.SquelchList.Remove(Username)
      ElseIf sText.StartsWith("/unignore ", True, Nothing) Then
        Dim Username As String = sText.Substring(10)
        If Username.StartsWith("*") Then Username = Username.Substring(1)
        If Not String.IsNullOrEmpty((From sName As String In Config.SquelchList Where StrComp(sName, Username, CompareMethod.Text) = 0 Select sName).FirstOrDefault) Then Config.SquelchList.Remove(Username)
      ElseIf sText.StartsWith("/squelch ", True, Nothing) Then
        Dim Username As String = sText.Substring(9)
        If Username.StartsWith("*") Then Username = Username.Substring(1)
        If String.IsNullOrEmpty((From sName As String In Config.SquelchList Where StrComp(sName, Username, CompareMethod.Text) = 0 Select sName).FirstOrDefault) Then Config.SquelchList.Add(Username)
      ElseIf sText.StartsWith("/ignore ", True, Nothing) Then
        Dim Username As String = sText.Substring(8)
        If Username.StartsWith("*") Then Username = Username.Substring(1)
        If String.IsNullOrEmpty((From sName As String In Config.SquelchList Where StrComp(sName, Username, CompareMethod.Text) = 0 Select sName).FirstOrDefault) Then Config.SquelchList.Add(Username)
      End If
    End If
    Using pktTemp As New BNCSPacket(BNCS_CHATCOMMAND)
      Dim bData() As Byte
      If Config.UTF8 Then
        bData = Encoding.UTF8.GetBytes(sText)
      Else
        bData = Encoding.GetEncoding(LATIN_1).GetBytes(sText)
      End If
      pktTemp.InsertByteArray(bData)
      pktTemp.InsertByte(0)
      BNCS_Send(pktTemp)
    End Using
    If Not String.IsNullOrEmpty(sText.Length) And Not String.IsNullOrEmpty(BNetData.UniqueName) AndAlso sText.Substring(0, 1) <> "/" Then
      gChat.AddChat(GeckoChat.ChatType.SelfChat, BNetData.UniqueName, sText)
      UpdateIdle(BNetData.UniqueName, sText)
    End If
  End Sub

  Private Sub BNCS_CHATEVENT_Recv(pktRead As BNCSReader)
    Const MinInterval As UInt32 = 1000
    Static LastUser As String
    Static LastJoin As Int32
    Static LastMessage As String
    Static LastEvent As UInt32
    Static bBegan As Boolean
    Dim EventID As UInt32 = pktRead.ReadUInt32
    Dim Flags As UInt32 = pktRead.ReadUInt32
    Dim Ping As UInt32 = pktRead.ReadUInt32
    Dim IP As UInt32 = pktRead.ReadUInt32
    Dim AccountID As UInt32 = pktRead.ReadUInt32
    Dim RegistrationID As UInt32 = pktRead.ReadUInt32
    Dim Account As String = pktRead.ReadCString
    Dim Message() As Byte = pktRead.ReadNullTerminatedByteArray()
    Dim Text As String
    If (Config.Account.Client.Product = GameType.D2DV Or Config.Account.Client.Product = GameType.D2XP) And InStr(Account, "*") > 0 Then Account = Account.Substring(InStr(Account, "*"))
    Dim Username As String = Account
    If Username.LastIndexOf("#") > 0 Then Username = Username.Substring(0, Username.LastIndexOf("#"))
    If Config.UTF8 Then
      Text = DeCensor(System.Text.Encoding.UTF8.GetString(Message))
    Else
      Text = DeCensor(System.Text.Encoding.GetEncoding(LATIN_1).GetString(Message))
    End If
    Select Case EventID
      Case EID_SHOWUSER
        If ChanList.Length = 0 And Not bBegan Then
          ChannelToggle(True)
          bBegan = True
        End If
        If Account = BNetData.UniqueName Then
          bBegan = False
          ChannelToggle(False)
        End If
        If ChanList.FindItem(Account) = -1 Then
          ChannelAdd(Account, Flags, Ping, Message)
        Else
          Select Case StrReverse(Text.Substring(0, 4))
            Case "DRTL", "DSHR", "SSHR"
              gChat.AddChat(GeckoChat.ChatType.StatChat, Account, Text.Substring(5))
            Case Else
              ChannelAdd(Account, Flags, Ping, Message)
          End Select
        End If
      Case EID_JOIN
        ChannelAdd(Account, Flags, Ping, Message)
        LastMessage = Nothing
        LastEvent = 0
        LastJoin = Environment.TickCount
        If Config.Display.JoinLeave Then gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_JOIN, Account))
      Case EID_LEAVE
        ChannelRemove(Account)
        If Config.Display.JoinLeave Then gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_LEAVE, Account))
      Case EID_WHISPER
        If Not String.IsNullOrEmpty((From sName As String In Config.SquelchList Where StrComp(sName, Account, CompareMethod.Text) = 0 Select sName).FirstOrDefault) Then Exit Sub
        If Not String.IsNullOrEmpty((From sName As String In Config.TagSquelchList Where InStr(Account, sName, CompareMethod.Text) > 0 Select sName).FirstOrDefault) Then Exit Sub
        If Environment.TickCount - LastJoin < MinInterval And Config.Display.PreventSpam Then
          LastUser = Account
          LastMessage = Text
          LastEvent = EID_WHISPER
        ElseIf StrComp(Trim(LastMessage), Trim(Text), CompareMethod.Text) = 0 And Config.Display.PreventSpam And LastEvent > 0 Then
          'spamming
        ElseIf Not String.IsNullOrEmpty(LastMessage) And LastEvent > 0 Then
          Select Case LastEvent
            Case EID_WHISPER
              WhisperWindow({LastUser, LastMessage, Me, True})
            Case EID_TALK
              If IsFriend(LastUser) Then
                gChat.AddChat(GeckoChat.ChatType.FriendChat, LastUser, LastMessage)
              Else
                gChat.AddChat(GeckoChat.ChatType.UserChat, LastUser, LastMessage)
              End If
              If StrComp(ChatData.MimicUser, LastUser, CompareMethod.Text) = 0 Then QueueMessage(LastMessage)
            Case EID_EMOTE
              If Config.Display.D2Emote Then
                gChat.AddChat(GeckoChat.ChatType.D2Emote, LastUser, LastMessage)
              Else
                gChat.AddChat(GeckoChat.ChatType.Emote, LastUser, LastMessage)
              End If
              If StrComp(ChatData.MimicUser, LastUser, CompareMethod.Text) = 0 Then QueueMessage("/me " & LastMessage)
          End Select
          WhisperWindow({Account, Text, Me, True})
          LastUser = Nothing
          LastMessage = Text
          LastEvent = 0
          LastJoin = 0
          UpdateIdle(Account, Text)
        Else
          If Config.Display.PreventSpam And StrComp(ChanList.LastMessageOf(Account), Text, CompareMethod.Text) = 0 Then
            'Repeat message
          Else
            WhisperWindow({Account, Text, Me, True})
          End If
          If StrComp(ChatData.MimicUser, Account, CompareMethod.Text) = 0 Then QueueMessage(Text)
          LastMessage = Text
          UpdateIdle(Account, Text)
        End If
      Case EID_TALK
        If Not String.IsNullOrEmpty((From sName As String In Config.SquelchList Where StrComp(sName, Account, CompareMethod.Text) = 0 Select sName).FirstOrDefault) Then Exit Sub
        If Not String.IsNullOrEmpty((From sName As String In Config.TagSquelchList Where InStr(Account, sName, CompareMethod.Text) > 0 Select sName).FirstOrDefault) Then Exit Sub
        If Environment.TickCount - LastJoin < MinInterval And Config.Display.PreventSpam Then
          LastUser = Account
          LastMessage = Text
          LastEvent = EID_TALK
        ElseIf StrComp(Trim(LastMessage), Trim(Text), CompareMethod.Text) = 0 And Config.Display.PreventSpam And LastEvent > 0 Then
          'spamming
        ElseIf Not String.IsNullOrEmpty(LastMessage) And LastEvent > 0 Then
          Select Case LastEvent
            Case EID_WHISPER
              WhisperWindow({LastUser, LastMessage, Me, True})
            Case EID_TALK
              If IsFriend(LastUser) Then
                gChat.AddChat(GeckoChat.ChatType.FriendChat, LastUser, LastMessage)
              Else
                gChat.AddChat(GeckoChat.ChatType.UserChat, LastUser, LastMessage)
              End If
              If StrComp(ChatData.MimicUser, LastUser, CompareMethod.Text) = 0 Then QueueMessage(LastMessage)
            Case EID_EMOTE
              If Config.Display.D2Emote Then
                gChat.AddChat(GeckoChat.ChatType.D2Emote, LastUser, LastMessage)
              Else
                gChat.AddChat(GeckoChat.ChatType.Emote, LastUser, LastMessage)
              End If
              If StrComp(ChatData.MimicUser, LastUser, CompareMethod.Text) = 0 Then QueueMessage("/me " & LastMessage)
          End Select
          If IsFriend(Account) Then
            gChat.AddChat(GeckoChat.ChatType.FriendChat, Account, Text)
          Else
            gChat.AddChat(GeckoChat.ChatType.UserChat, Account, Text)
          End If
          If StrComp(ChatData.MimicUser, Account, CompareMethod.Text) = 0 Then QueueMessage(Text)
          LastUser = Nothing
          LastMessage = Text
          LastEvent = 0
          LastJoin = 0
          UpdateIdle(Account, Text)
        Else
          If Config.Display.PreventSpam And StrComp(ChanList.LastMessageOf(Account), Text, CompareMethod.Text) = 0 Then
            'Repeat message
          Else
            If IsFriend(Account) Then
              gChat.AddChat(GeckoChat.ChatType.FriendChat, Account, Text)
            Else
              gChat.AddChat(GeckoChat.ChatType.UserChat, Account, Text)
            End If
            If (StrComp(Username, "RealityRipple", CompareMethod.Text) = 0 Or Username.StartsWith("RealityRipple@", True, Nothing)) And Text = "Identify" Then SendMessage("//ver")
          End If
          If StrComp(ChatData.MimicUser, Account, CompareMethod.Text) = 0 Then QueueMessage(Text)
          LastMessage = Text
          UpdateIdle(Account, Text)
        End If
        If TriviaKiller IsNot Nothing AndAlso (TriviaKiller.OnEmote <> TriState.True And StrComp(TriviaKiller.TriviaBot, Account, CompareMethod.Text) = 0) Then TriviaKiller.MessageFromBot(Text)
      Case EID_BROADCAST
        gChat.AddChat(GeckoChat.ChatType.ServiceBroadcast, My.Resources.PROTOCOL_BNCS, Text)
      Case EID_CHANNEL
        ChannelJoined(Text)
        If Account = Config.Account.Username Then
          gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_CHANNEL, Text, ChanFlags(Flags)))
        Else
          gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_CHANNEL_EX, Text, ChanFlags(Flags), Account))
        End If
        If CBool(Flags And CHANNEL_PUBLIC) And CBool(Flags And CHANNEL_SILENT) Then
          ToggleListChannel(True)
          If Text = "The Void" And Not String.IsNullOrEmpty(Config.Account.HomeChannel) And Not BNetData.EnterVoid Then BNCS_JOINCHANNEL_Send(Config.Account.HomeChannel, JoinFlags.NoCreate)
        Else
          ToggleListChannel(False)
        End If
        If StrComp(ChatData.RetryChannel, Text, CompareMethod.Text) = 0 Then
          If ChatData.RetryCount > 0 Then
            gChat.TerminateProgress("FULL", ResString(My.Resources.ERR_CHANNELFULLDONE, Text))
          Else
            gChat.TerminateProgress("FULL")
          End If
          If tmrRetryJoin IsNot Nothing Then
            tmrRetryJoin.Stop()
            tmrRetryJoin = Nothing
          End If
          ChatData.RetryCount = 0
          ChatData.RetryChannel = Nothing
        ElseIf Not String.IsNullOrEmpty(ChatData.RetryChannel) AndAlso Not Text = "The Void" Then
          gChat.TerminateProgress("FULL", ResString(My.Resources.ERR_CHANNELFULLDONE, ChatData.RetryChannel))
          ChatData.RetryChannel = "STOP"
          If tmrRetryJoin IsNot Nothing Then
            tmrRetryJoin.Stop()
            tmrRetryJoin = Nothing
          End If
          ChatData.RetryCount = 0
        End If
        BNetData.EnterVoid = False
        If Config.AutoAway > 0 And ChatData.IsAway = "Idle" Then
          SendMessage("/away")
          ChatData.IsAway = String.Empty
        End If
      Case EID_USERFLAGS
        If ChanList.Length = 0 And LastChanUpdate = 0 Then ChannelToggle(True)
        LastChanUpdate = Environment.TickCount
        ChannelAdd(Account, Flags, Ping, Message)
      Case EID_WHISPERSENT
        WhisperWindow({Account, Text, Me, False})
      Case EID_CHANNELDOESNOTEXIST
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_CHANNELDOESNOTEXIST, Text))
        BNCS_JOINCHANNEL_Send(Text, JoinFlags.Forced)
      Case EID_CHANNELRESTRICTED
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_CHANNELRESTRICTED, Text))
      Case EID_CHANNELFULL
        If ChatData.RetryChannel = "STOP" Then
          If tmrRetryJoin IsNot Nothing Then
            tmrRetryJoin.Stop()
            tmrRetryJoin = Nothing
          End If
          ChatData.RetryCount = 0
          ChatData.RetryChannel = Nothing
        End If
        If StrComp(ChatData.RetryChannel, Text, CompareMethod.Text) = 0 Then
          If tmrRetryJoin Is Nothing Then
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_CHANNELFULL, Text), "FULL")
            tmrRetryJoin = New Timers.Timer(5000)
            AddHandler tmrRetryJoin.Elapsed, AddressOf tmrRetryJoin_Tick
          End If
          tmrRetryJoin.Enabled = True
        Else
          Debug.Print("Neither STOP nor RetryChannel: " & Text)
          'gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_CHANNELFULLDONE, Text))
        End If
        'If tmrRetryJoin Is Nothing Then
        '  gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_CHANNELFULL, Text), "FULL")
        '  tmrRetryJoin = New Timers.Timer(5000)
        '  ChatData.RetryChannel = Text
        '  AddHandler tmrRetryJoin.Elapsed, AddressOf tmrRetryJoin_Tick
        '  tmrRetryJoin.Enabled = True
        'ElseIf ChatData.RetryChannel <> Text And lblChannel.Tag <> ChatData.RetryChannel Then
        '  gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_CHANNELFULL, Text), "FULL")
        '  ChatData.RetryChannel = Text
        'End If
      Case EID_INFO
        If Text.Contains("*") Then Text = Text.Replace("*", "")
        If ResCompare(My.Resources.SERVER_STILLAWAY, Text) Then
          'Ignore it
        Else
          If ResCompare(My.Resources.SERVER_RED, Text) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, Text)
          ElseIf ResCompare(My.Resources.SERVER_GREEN, Text) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, Text)
          ElseIf ResCompare(My.Resources.SERVER_BANNED, Text) Then
            tmrBanList = Nothing
            gChat.UpdateProgress("banlist", Text)
            tmrBanList = New Timers.Timer(5000)
            AddHandler tmrBanList.Elapsed, AddressOf tmrBanList_Tick
            tmrBanList.Interval = 5000
            tmrBanList.AutoReset = False
            tmrBanList.Enabled = True
          ElseIf ResCompare(My.Resources.SERVER_YOURFRIENDSLIST, Text) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, Text)
            BNCS_FRIENDSLIST_Send()
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, Text)
          End If
        End If
      Case EID_ERROR
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, Text)
      Case EID_EMOTE
        If Not String.IsNullOrEmpty((From sName As String In Config.SquelchList Where StrComp(sName, Account, CompareMethod.Text) = 0 Select sName).FirstOrDefault) Then Exit Sub
        If Not String.IsNullOrEmpty((From sName As String In Config.TagSquelchList Where InStr(Account, sName, CompareMethod.Text) > 0 Select sName).FirstOrDefault) Then Exit Sub
        If Environment.TickCount - LastJoin < MinInterval And Config.Display.PreventSpam Then
          LastUser = Account
          LastMessage = Text
          LastEvent = EID_EMOTE
        ElseIf StrComp(Trim(LastMessage), Trim(Text), CompareMethod.Text) = 0 And Config.Display.PreventSpam And LastEvent > 0 Then
          'spamming
        ElseIf Not String.IsNullOrEmpty(LastMessage) And LastEvent > 0 Then
          Select Case LastEvent
            Case EID_WHISPER
              WhisperWindow({LastUser, LastMessage, Me, True})
            Case EID_TALK
              If IsFriend(LastUser) Then
                gChat.AddChat(GeckoChat.ChatType.FriendChat, LastUser, LastMessage)
              Else
                gChat.AddChat(GeckoChat.ChatType.UserChat, LastUser, LastMessage)
              End If
              If StrComp(ChatData.MimicUser, LastUser, CompareMethod.Text) = 0 Then QueueMessage(LastMessage)
            Case EID_EMOTE
              If Config.Display.D2Emote Then
                gChat.AddChat(GeckoChat.ChatType.D2Emote, LastUser, LastMessage)
              Else
                gChat.AddChat(GeckoChat.ChatType.Emote, LastUser, LastMessage)
              End If
              If StrComp(ChatData.MimicUser, LastUser, CompareMethod.Text) = 0 Then QueueMessage("/me " & LastMessage)
          End Select
          If Config.Display.D2Emote Then
            gChat.AddChat(GeckoChat.ChatType.D2Emote, Account, Text)
          Else
            gChat.AddChat(GeckoChat.ChatType.Emote, Account, Text)
          End If
          If StrComp(ChatData.MimicUser, Account, CompareMethod.Text) = 0 Then QueueMessage("/me " & Text)
          LastUser = Nothing
          LastMessage = Text
          LastEvent = 0
          LastJoin = 0
          UpdateIdle(Account, Text)
        Else
          If Config.Display.PreventSpam And StrComp(ChanList.LastMessageOf(Account), Text, CompareMethod.Text) = 0 And LastEvent > 0 Then
            'Repeat message
          Else
            If Config.Display.D2Emote Then
              gChat.AddChat(GeckoChat.ChatType.D2Emote, Account, Text)
            Else
              gChat.AddChat(GeckoChat.ChatType.Emote, Account, Text)
            End If
          End If
          If StrComp(ChatData.MimicUser, Account, CompareMethod.Text) = 0 Then QueueMessage("/me " & Text)
          LastMessage = Text
          UpdateIdle(Account, Text)
        End If
        If TriviaKiller IsNot Nothing AndAlso (TriviaKiller.OnEmote <> TriState.False And StrComp(TriviaKiller.TriviaBot, Account, CompareMethod.Text) = 0) Then TriviaKiller.MessageFromBot(Text)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, "Unknown Chat Event: " & Hex$(EventID))
    End Select
  End Sub

  Private Sub BNCS_LEAVECHAT_Send()
    Using pktTemp As New BNCSPacket(BNCS_LEAVECHAT)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_LOCALEINFO_Send()
    Using pktTemp As New BNCSPacket(BNCS_LOCALEINFO)
      Dim lTime As UInt64 = DateTime.Now.ToFileTime
      Dim lAdd As Int64 = ((DateTime.UtcNow - DateTime.Now).TotalMilliseconds * 10000)
      pktTemp.InsertUInt64(lTime)
      pktTemp.InsertUInt64(lTime - lAdd)
      pktTemp.InsertInt32((DateTime.UtcNow - DateTime.Now).TotalMinutes)
      pktTemp.InsertInt32(CultureInfo.InstalledUICulture.LCID)
      pktTemp.InsertInt32(CultureInfo.CurrentCulture.LCID)
      pktTemp.InsertInt32(CultureInfo.CurrentUICulture.LCID)
      pktTemp.InsertCString(CultureInfo.CurrentCulture.ThreeLetterWindowsLanguageName)
      pktTemp.InsertCString(RegionInfo.CurrentRegion.NativeName)
      pktTemp.InsertCString(RegionInfo.CurrentRegion.ThreeLetterWindowsRegionName)
      pktTemp.InsertCString(RegionInfo.CurrentRegion.EnglishName)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_FLOODDETECTED_Recv(pktRead As BNCSReader)
    gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_FLOOD)
    BNCS_Disconnect(True)
  End Sub

  Private Sub BNCS_UDPPINGRESPONSE_Send()
    If Not Config.Account.Client.UDPPlug Then
      Using pktTemp As New BNCSPacket(BNCS_UDPPINGRESPONSE)
        If BNetData.UDPCode = 0 Then BNetData.UDPCode = &H626E6574
        pktTemp.InsertUInt32(BNetData.UDPCode)
        BNCS_Send(pktTemp)
      End Using
    End If
  End Sub

  Private Sub BNCS_CHECKAD_Recv(pktRead As BNCSReader)
    BNetData.LastAd = pktRead.ReadUInt32
    Dim AdExt As String = pktRead.ReadDWORDString()
    Dim AdTime As UInt64 = pktRead.ReadUInt64
    Dim AdName As String = pktRead.ReadCString
    Dim AdURL As String = pktRead.ReadCString
    If Not My.Computer.FileSystem.DirectoryExists(AppStore & "\Ads") Then My.Computer.FileSystem.CreateDirectory(AppStore & "\Ads")
    Dim AdPath As String = AppStore & "\Ads\" & AdName
    If Config.Display.GetAds Then
      If My.Computer.FileSystem.FileExists(AdPath) Then
        BNCS_DISPLAYAD_Send(BNetData.LastAd, AdName, AdURL)
      Else
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_AD, AdName))
        If BNFTPRequest(GameArch.IX86, Config.Account.Client.Product, AdPath, Nothing, BNetData.LastAd, AdExt) Then
          BNCS_DISPLAYAD_Send(BNetData.LastAd, AdName, AdURL)
        Else
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_FTP, ResString(My.Resources.ERR_FTP_FAIL, AdName))
        End If
      End If
    End If
  End Sub

  Private Sub BNCS_CHECKAD_Send()
    Using pktTemp As New BNCSPacket(BNCS_CHECKAD)
      pktTemp.InsertUInt32(GameArch.IX86)
      pktTemp.InsertUInt32(Config.Account.Client.Product)
      pktTemp.InsertUInt32(BNetData.LastAd)
      pktTemp.InsertUInt32(0)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_CLICKAD_Send()
    Using pktTemp As New BNCSPacket(BNCS_CLICKAD)
      pktTemp.InsertUInt32(BNetData.LastAd)
      pktTemp.InsertUInt32(0)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_READMEMORY_Recv(pktRead As BNCSReader)
    Dim RequestID As UInt32 = pktRead.ReadUInt32
    Dim Address As UInt32 = pktRead.ReadUInt32
    Dim Length As UInt32 = pktRead.ReadUInt32
  End Sub

  Private Sub BNCS_READMEMORY_Send(RequestID As UInt32, Address As UInt32, Length As UInt32)
    Using pktTmp As New BNCSPacket(BNCS_READMEMORY)
      pktTmp.InsertUInt32(RequestID)
      pktTmp.InsertCString("Nice try. -RR")
      BNCS_Send(pktTmp)
    End Using
  End Sub

  Private Sub BNCS_REGISTRY_Recv(pktRead As BNCSReader)
    BNCS_REGISTRY_Send(pktRead.ReadUInt32, pktRead.ReadUInt32, pktRead.ReadCString, pktRead.ReadCString)
  End Sub

  Private Sub BNCS_REGISTRY_Send(lCookie As Long, lHKey As Long, sRegPath As String, sRegKey As String)
    Using pktTemp As New BNCSPacket(BNCS_REGISTRY)
      pktTemp.InsertUInt32(lCookie)
      Dim cReg As RegistryKey
      Select Case lHKey
        Case &H80000000
          cReg = Registry.ClassesRoot.OpenSubKey(sRegPath)
        Case &H80000001
          cReg = Registry.CurrentUser.OpenSubKey(sRegPath)
        Case &H80000002
          cReg = Registry.LocalMachine.OpenSubKey(sRegPath)
        Case &H80000003
          cReg = Registry.Users.OpenSubKey(sRegPath)
        Case &H80000004
          cReg = Registry.PerformanceData.OpenSubKey(sRegPath)
        Case &H80000005
          cReg = Registry.CurrentConfig.OpenSubKey(sRegPath)
        Case &H80000006
          cReg = Registry.PerformanceData.OpenSubKey(sRegPath)
        Case Else
          Exit Sub
      End Select
      pktTemp.InsertCString(cReg.GetValue(sRegPath, String.Empty))
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_MESSAGEBOX_Recv(pktRead As BNCSReader)
    Dim Style As UInt32 = pktRead.ReadUInt32
    Dim Text As String = pktRead.ReadCString
    Dim Caption As String = pktRead.ReadCString
    Style = Style Or MsgBoxStyle.SystemModal
    MessageBox(frmMain.Handle, Text, Caption, Style)
    If Text = My.Resources.ERR_FLOOD And IsOnline Then
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_FLOOD)
      BNCS_Disconnect(True)
    End If
  End Sub

  Private Sub BNCS_STARTADVEX2_Send(State As UInt32, UpTime As UInt32, GameType As UInt16, Teams As UInt16, GameName As String, GamePassword As String, GameCreator As String, GameMap As String, GameSpeed As Byte)
    Using pktTemp As New BNCSPacket(BNCS_STARTADVEX2)
      pktTemp.InsertUInt32(State)
      pktTemp.InsertUInt32(UpTime)
      pktTemp.InsertUInt16(GameType)
      If GameType = &HF Then
        pktTemp.InsertUInt16(Teams)
      Else
        pktTemp.InsertUInt16(&H1)
      End If
      pktTemp.InsertUInt32(0)
      pktTemp.InsertUInt32(0)
      pktTemp.InsertCString(GameName)
      pktTemp.InsertCString(GamePassword)
      pktTemp.InsertCString(CreateGameStatString("SSHR", GameMap, GameSpeed, GameType, Teams, GameCreator))
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_GAMEDATAADDRESS_SEND()
    Using pktTemp As New BNCSPacket(BNCS_GAMEDATAADDRESS)
      'SOCKADDR
      'BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_STARTADVEX3_Recv(pktRead As BNCSReader)
    Select Case pktRead.ReadBoolean
      Case True
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_STARTADVEX)
      Case False
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_STARTADVEX)
    End Select
  End Sub

  Private Sub BNCS_STARTADVEX3_Send(State As UInt32, UpTime As UInt32, GameType As UInt16, Teams As UInt16, Unknown As UInt32, Ladder As UInt32, GameName As String, GamePassword As String, GameCreator As String, GameMap As String, GameSpeed As Byte)
    Using pktTemp As New BNCSPacket(BNCS_STARTADVEX3)
      pktTemp.InsertUInt32(State)
      pktTemp.InsertUInt32(UpTime)
      pktTemp.InsertUInt16(GameType)
      If GameType = &HF Then
        pktTemp.InsertUInt16(Teams)
      Else
        pktTemp.InsertUInt16(&H1)
      End If
      pktTemp.InsertUInt32(Unknown)
      pktTemp.InsertUInt32(Ladder)
      pktTemp.InsertCString(GameName)
      pktTemp.InsertCString(GamePassword)
      pktTemp.InsertCString(CreateGameStatString(Config.Account.Client.Product.ToString, GameMap, GameSpeed, GameType, Teams, GameCreator))
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_LOGONCHALLENGEEX_Recv(pktRead As BNCSReader)
    BNetData.UDPToken = pktRead.ReadUInt32
    BNetData.ServerToken = pktRead.ReadUInt32
    If sckUDP.IsConnected Then PKT_CONNTEST2_Send()
  End Sub

  Private Sub BNCS_CLIENTID2_Send()
    Using pktTemp As New BNCSPacket(BNCS_CLIENTID2)
      Dim cReg As RegistryKey
      Dim RegType As UInt32
      cReg = Registry.CurrentUser.OpenSubKey("Software\Battle.net\Configuration")
      RegType = Int(Rnd() * 2)
      pktTemp.InsertUInt32(RegType)
      If cReg IsNot Nothing Then
        If RegType = 1 Then
          pktTemp.InsertInt32(cReg.GetValue("Registration Version", 0).ToString)
          pktTemp.InsertInt32(cReg.GetValue("Registration Authority", 0).ToString)
        Else
          pktTemp.InsertInt32(cReg.GetValue("Registration Authority", 0).ToString)
          pktTemp.InsertInt32(cReg.GetValue("Registration Version", 0).ToString)
        End If
        pktTemp.InsertInt32(cReg.GetValue("Client ID", 0).ToString)
        pktTemp.InsertInt32(cReg.GetValue("Client Token", 0).ToString)
      Else
        pktTemp.InsertInt32(0)
        pktTemp.InsertInt32(0)
        pktTemp.InsertInt32(0)
        pktTemp.InsertInt32(0)
      End If
      pktTemp.InsertCString(Environment.MachineName)
      pktTemp.InsertCString(Environment.UserName)
      BNCS_Send(pktTemp)
    End Using
    BNCS_LOCALEINFO_Send()
    If Config.Account.Client.Product = GameType.JSTR Or Config.Account.Client.Product = GameType.SSHR Then BNCS_SYSTEMINFO_Send()
    BNCS_STARTVERSIONING_Send()
  End Sub

  Private Sub BNCS_LEAVEGAME_Send()
    Using pktTemp As New BNCSPacket(BNCS_LEAVEGAME)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_ANNOUNCEMENT_Recv(pktRead As BNCSReader)
    gChat.AddChat(GeckoChat.ChatType.ServiceBroadcast, My.Resources.PROTOCOL_BNCS, pktRead.ReadCString)
  End Sub

  Private Sub BNCS_DISPLAYAD_Send(AdID As UInt32, AdName As String, AdURL As String)
    Dim bBottom As Boolean = gChat.AtBottom
    If Config.Display.GetAds Then
      ShowAd({AdName, AdURL})
    Else
      pctAd.Image = Nothing
      pctAd.Tag = Nothing
      pctAd.Size = New Size(1, 1)
    End If
    If bBottom Then gChat.ToBottom()
    Dim pktTemp As New BNCSPacket(BNCS_DISPLAYAD)
    pktTemp.InsertUInt32(GameArch.IX86)
    pktTemp.InsertUInt32(Config.Account.Client.Product)
    pktTemp.InsertUInt32(AdID)
    pktTemp.InsertCString(AdName)
    pktTemp.InsertCString(AdURL)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_NOTIFYJOIN_Send(GameName As String, Optional GamePassword As String = Nothing)
    Dim pktTemp As New BNCSPacket(BNCS_NOTIFYJOIN)
    pktTemp.InsertUInt32(Config.Account.Client.Product)
    pktTemp.InsertUInt32(Config.VerByte)
    pktTemp.InsertCString(GameName)
    pktTemp.InsertCString(GamePassword)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_WRITECOOKIE_Recv(pktRead As BNCSReader)
    Dim ID As UInt32 = pktRead.ReadUInt32
    Dim Stamp As UInt32 = pktRead.ReadUInt32
    Dim CookieName As String = pktRead.ReadCString
    Dim CookieValue As String = pktRead.ReadCString
    BakeCookie(ID, Stamp, CookieName, CookieValue)
  End Sub

  Private Sub BNCS_READCOOKIE_Recv(pktRead As BNCSReader)
    Dim ID As UInt32 = pktRead.ReadUInt32
    Dim Stamp As UInt32 = pktRead.ReadUInt32
    Dim CookieName As String = pktRead.ReadCString
    Dim oID, oStamp As UInt32, CookieValue As String = String.Empty
    EatCookie(oID, oStamp, CookieName, CookieValue)
    If oID = ID And oStamp = Stamp Then
      Debug.Print("Same Cookie ID and Stamp.")
    Else
      Debug.Print("Different Cookie and Stamp." & vbNewLine & pktRead.ToString)
    End If
    BNCS_READCOOKIE_Send(ID, Stamp, CookieName, CookieValue)
  End Sub

  Private Sub BNCS_READCOOKIE_Send(ID As UInt32, Stamp As UInt32, CookieName As String, CookieValue As String)
    Dim pktTmp As New BNCSPacket(BNCS_READCOOKIE)
    pktTmp.InsertUInt32(ID)
    pktTmp.InsertUInt32(Stamp)
    pktTmp.InsertCString(CookieName)
    pktTmp.InsertCString(CookieValue)
  End Sub

  Private Sub BNCS_PING_Recv(pktRead As BNCSReader)
    BNCS_PING_Send(pktRead.ReadUInt32)
  End Sub

  Private Sub BNCS_PING_Send(Cookie As UInt32)
    Dim pktTemp As New BNCSPacket(BNCS_PING)
    pktTemp.InsertUInt32(Cookie)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_READUSERDATA_Recv(pktRead As BNCSReader)
    Dim lAccounts As UInt32 = pktRead.ReadUInt32
    Dim lKeys As UInt32 = pktRead.ReadUInt32
    Dim lCookie As UInt32 = pktRead.ReadUInt32
    Dim sUsernames() As String = Nothing
    Dim prType As ProfileRequests.ProfileRequestType
    Dim prDisp As ProfileRequests.ProfileRequestDisplay
    Dim prUpdate As frmProfile.UpdateTypes
    Dim prWhisperTo As String = String.Empty
    ProfileRequestList.GetRequest(lCookie, sUsernames, prType, prDisp, prUpdate, prWhisperTo)
    Dim sWhis As String = "/w " & IIf(Config.Account.Client.Product = GameType.D2DV Or Config.Account.Client.Product = GameType.D2XP, "*", String.Empty) & prWhisperTo & " "
    If prDisp = ProfileRequests.ProfileRequestDisplay.PrivateUI And prType <> ProfileRequests.ProfileRequestType.AccountInfo Then
      If lKeys > 0 Then
        If lAccounts > 0 Then
          For I = 0 To lAccounts - 1
            ProfileWindow.UpdateTab(sUsernames(I), prUpdate, pktRead.ReadCStringArray(lKeys, IIf(Config.UTF8, Encoding.GetEncoding(UTF_8), Encoding.GetEncoding(LATIN_1))))
          Next I
        Else
          ProfileWindow.UpdateTab(sUsernames(0), prUpdate, pktRead.ReadCStringArray(lKeys, IIf(Config.UTF8, Encoding.GetEncoding(UTF_8), Encoding.GetEncoding(LATIN_1))))
        End If
      Else
        Debug.Print("NO KEYS RETURNED")
      End If
      Select Case prType
        Case ProfileRequests.ProfileRequestType.UserProfile
          If prUpdate = frmProfile.UpdateTypes.FIND Then
            If ProfileWindow.CheckTab(sUsernames(0), GameType.STAR) = 1 Then
              GetUserData(sUsernames(0), ProfileRequests.ProfileRequestType.NormalLadderGameRecord, ProfileRequests.ProfileRequestDisplay.PrivateUI, "STAR")
            ElseIf ProfileWindow.CheckTab(sUsernames(0), GameType.SEXP) = 1 Then
              GetUserData(sUsernames(0), ProfileRequests.ProfileRequestType.NormalLadderGameRecord, ProfileRequests.ProfileRequestDisplay.PrivateUI, "SEXP")
            ElseIf ProfileWindow.CheckTab(sUsernames(0), GameType.JSTR) = 1 Then
              GetUserData(sUsernames(0), ProfileRequests.ProfileRequestType.NormalLadderGameRecord, ProfileRequests.ProfileRequestDisplay.PrivateUI, "JSTR")
            ElseIf ProfileWindow.CheckTab(sUsernames(0), GameType.SSHR) = 1 Then
              GetUserData(sUsernames(0), ProfileRequests.ProfileRequestType.NormalLadderGameRecord, ProfileRequests.ProfileRequestDisplay.PrivateUI, "SSHR")
            ElseIf ProfileWindow.CheckTab(sUsernames(0), GameType.W2BN) = 1 Then
              GetUserData(sUsernames(0), ProfileRequests.ProfileRequestType.NormalLadderIronManGameRecord, ProfileRequests.ProfileRequestDisplay.PrivateUI, "W2BN")
            End If
          Else
            GetUserData(sUsernames(0), ProfileRequests.ProfileRequestType.UserProfile, ProfileRequests.ProfileRequestDisplay.PrivateUI, "FIND")
          End If
        Case ProfileRequests.ProfileRequestType.NormalLadderGameRecord
          If ProfileWindow.CheckTab(sUsernames(0), GameType.STAR) = 1 Then
            GetUserData(sUsernames(0), ProfileRequests.ProfileRequestType.NormalLadderGameRecord, ProfileRequests.ProfileRequestDisplay.PrivateUI, "STAR")
          ElseIf ProfileWindow.CheckTab(sUsernames(0), GameType.SEXP) = 1 Then
            GetUserData(sUsernames(0), ProfileRequests.ProfileRequestType.NormalLadderGameRecord, ProfileRequests.ProfileRequestDisplay.PrivateUI, "SEXP")
          ElseIf ProfileWindow.CheckTab(sUsernames(0), GameType.JSTR) = 1 Then
            GetUserData(sUsernames(0), ProfileRequests.ProfileRequestType.NormalLadderGameRecord, ProfileRequests.ProfileRequestDisplay.PrivateUI, "JSTR")
          ElseIf ProfileWindow.CheckTab(sUsernames(0), GameType.SSHR) = 1 Then
            GetUserData(sUsernames(0), ProfileRequests.ProfileRequestType.NormalLadderGameRecord, ProfileRequests.ProfileRequestDisplay.PrivateUI, "SSHR")
          ElseIf ProfileWindow.CheckTab(sUsernames(0), GameType.W2BN) = 1 Then
            GetUserData(sUsernames(0), ProfileRequests.ProfileRequestType.NormalLadderIronManGameRecord, ProfileRequests.ProfileRequestDisplay.PrivateUI, "W2BN")
          End If
      End Select
    Else
      Select Case prType
        Case ProfileRequests.ProfileRequestType.UserProfile
          For I As Integer = 0 To lAccounts - 1
            Dim Sex() As Byte = pktRead.ReadNullTerminatedByteArray()
            Dim Age() As Byte = pktRead.ReadNullTerminatedByteArray()
            Dim Location() As Byte = pktRead.ReadNullTerminatedByteArray()
            Dim Description() As Byte = pktRead.ReadNullTerminatedByteArray()
            Dim sAccount As String = sUsernames(I)
            Dim sSex As String = DeCensor(System.Text.Encoding.GetEncoding(LATIN_1).GetString(Sex))
            Dim sAge As String = DeCensor(System.Text.Encoding.GetEncoding(LATIN_1).GetString(Age))
            Dim sLocation As String = DeCensor(System.Text.Encoding.GetEncoding(LATIN_1).GetString(Location))
            Dim sDescription As String = DeCensor(System.Text.Encoding.GetEncoding(LATIN_1).GetString(Description))
            Select Case prDisp
              Case ProfileRequests.ProfileRequestDisplay.PrivateText
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_NAME, sAccount))
                For Each sTmp As String In Split(DeCensor(sSex), vbCr)
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_SEX, Replace(sTmp, vbLf, String.Empty)))
                Next
                For Each sTmp As String In Split(DeCensor(sLocation), vbCr)
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_LOCATION, Replace(sTmp, vbLf, String.Empty)))
                Next
                For Each sTmp As String In Split(DeCensor(sDescription), vbCr)
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_DESCRIPTION, Replace(sTmp, vbLf, String.Empty)))
                Next
              Case ProfileRequests.ProfileRequestDisplay.PublicChat
                QueueMessage(ResString(My.Resources.PROFILE_NAME, sAccount))
                For Each sTmp As String In Split(DeCensor(sSex), vbCr)
                  For Each sItem In MakeChunks(sTmp)
                    QueueMessage(ResString(My.Resources.PROFILE_SEX, Replace(sItem, vbLf, String.Empty)))
                  Next
                Next
                For Each sTmp As String In Split(DeCensor(sLocation), vbCr)
                  For Each sItem In MakeChunks(sTmp)
                    QueueMessage(ResString(My.Resources.PROFILE_LOCATION, Replace(sItem, vbLf, String.Empty)))
                  Next
                Next
                For Each sTmp As String In Split(DeCensor(sDescription), vbCr)
                  For Each sItem In MakeChunks(sTmp)
                    QueueMessage(ResString(My.Resources.PROFILE_DESCRIPTION, Replace(sItem, vbLf, String.Empty)))
                  Next
                Next
              Case ProfileRequests.ProfileRequestDisplay.PublicWhisper
                QueueMessage(sWhis & ResString(My.Resources.PROFILE_NAME, sAccount))
                For Each sTmp As String In Split(DeCensor(sSex), vbCr)
                  For Each sItem In MakeChunks(sTmp)
                    QueueMessage(sWhis & ResString(My.Resources.PROFILE_SEX, Replace(sItem, vbLf, String.Empty)))
                  Next
                Next
                For Each sTmp As String In Split(DeCensor(sLocation), vbCr)
                  For Each sItem In MakeChunks(sTmp)
                    QueueMessage(sWhis & ResString(My.Resources.PROFILE_LOCATION, Replace(sItem, vbLf, String.Empty)))
                  Next
                Next
                For Each sTmp As String In Split(DeCensor(sDescription), vbCr)
                  For Each sItem In MakeChunks(sTmp)
                    QueueMessage(sWhis & ResString(My.Resources.PROFILE_DESCRIPTION, Replace(sItem, vbLf, String.Empty)))
                  Next
                Next
            End Select
          Next
        Case ProfileRequests.ProfileRequestType.AccountInfo
          For I As Integer = 0 To lAccounts - 1
            Dim sAccount As String = sUsernames(I)
            ChatData.AccountCreatead = FTStrToDate(pktRead.ReadCString)
            Dim AuthLevel As String = pktRead.ReadCString
            Dim Flags As String = pktRead.ReadCString
            Dim Friends As String = pktRead.ReadCString
            Dim Icon As String = pktRead.ReadCString
            Dim IP As String = pktRead.ReadCString
            ChatData.LastLogoff = FTStrToDate(pktRead.ReadCString)
            ChatData.LastLogon = FTStrToDate(pktRead.ReadCString)
            Dim League As String = pktRead.ReadCString
            Dim MFT_Bytes As String = pktRead.ReadCString
            Dim MFT_LastWrite As String = pktRead.ReadCString
            Dim MFT_TimeLogged As String = pktRead.ReadCString
            Dim Port As String = pktRead.ReadCString
            ChatData.TimeLogged = CUInt(pktRead.ReadCString)
            Dim Username As String = pktRead.ReadCString
            Select Case prDisp
              Case ProfileRequests.ProfileRequestDisplay.PrivateText
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_ACCOUNTCREATE, ChatData.AccountCreatead))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_LASTLOGOFF, ChatData.LastLogoff))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_LASTLOGON, ChatData.LastLogon))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_TIMELOGGED, ConvertTime(ChatData.TimeLogged * 1000)))
                If Not String.IsNullOrEmpty(Friends) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_FRIENDS, Friends))
                If Not String.IsNullOrEmpty(League) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_LEAGUE, League))
                If Not String.IsNullOrEmpty(Icon) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_ICON, Icon))
                If Not String.IsNullOrEmpty(AuthLevel) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_AUTH, AuthLevel))
                If Not String.IsNullOrEmpty(Flags) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_FLAGS, Flags))
                If Not String.IsNullOrEmpty(IP) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_IP, IP))
                If Not String.IsNullOrEmpty(Port) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_PORT, Port))
                If Not String.IsNullOrEmpty(MFT_Bytes) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_MFT_BYTES, MFT_Bytes))
                If Not String.IsNullOrEmpty(MFT_LastWrite) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_MFT_LASTWRITE, FTStrToDate(MFT_LastWrite)))
                If Not String.IsNullOrEmpty(MFT_TimeLogged) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_MFT_TIMELOGGED, ConvertTime(MFT_TimeLogged * 1000)))
              Case ProfileRequests.ProfileRequestDisplay.PrivateUI
                If Config.Display.AccountInfo Then
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_ACCOUNTCREATE, ChatData.AccountCreatead))
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_LASTLOGOFF, ChatData.LastLogoff))
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_LASTLOGON, ChatData.LastLogon))
                  gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_TIMELOGGED, ConvertTime(ChatData.TimeLogged * 1000)))
                  If Not String.IsNullOrEmpty(Friends) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_FRIENDS, Friends))
                  If Not String.IsNullOrEmpty(League) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_LEAGUE, League))
                  If Not String.IsNullOrEmpty(Icon) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_ICON, Icon))
                  If Not String.IsNullOrEmpty(AuthLevel) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_AUTH, AuthLevel))
                  If Not String.IsNullOrEmpty(Flags) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_FLAGS, Flags))
                  If Not String.IsNullOrEmpty(IP) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_IP, IP))
                  If Not String.IsNullOrEmpty(Port) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_PORT, Port))
                  If Not String.IsNullOrEmpty(MFT_Bytes) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_MFT_BYTES, MFT_Bytes))
                  If Not String.IsNullOrEmpty(MFT_LastWrite) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_MFT_LASTWRITE, FTStrToDate(MFT_LastWrite)))
                  If Not String.IsNullOrEmpty(MFT_TimeLogged) Then gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.PROFILE_MFT_TIMELOGGED, ConvertTime(MFT_TimeLogged * 1000)))
                End If
              Case ProfileRequests.ProfileRequestDisplay.PublicChat
                QueueMessage(ResString(My.Resources.PROFILE_ACCOUNTCREATE, ChatData.AccountCreatead))
                QueueMessage(ResString(My.Resources.PROFILE_LASTLOGOFF, ChatData.LastLogoff))
                QueueMessage(ResString(My.Resources.PROFILE_LASTLOGON, ChatData.LastLogon))
                QueueMessage(ResString(My.Resources.PROFILE_TIMELOGGED, ConvertTime(ChatData.TimeLogged * 1000)))
                If Not String.IsNullOrEmpty(Friends) Then QueueMessage(ResString(My.Resources.PROFILE_FRIENDS, Friends))
                If Not String.IsNullOrEmpty(League) Then QueueMessage(ResString(My.Resources.PROFILE_LEAGUE, League))
                If Not String.IsNullOrEmpty(Icon) Then QueueMessage(ResString(My.Resources.PROFILE_ICON, Icon))
                If Not String.IsNullOrEmpty(AuthLevel) Then QueueMessage(ResString(My.Resources.PROFILE_AUTH, AuthLevel))
                If Not String.IsNullOrEmpty(Flags) Then QueueMessage(ResString(My.Resources.PROFILE_FLAGS, Flags))
                If Not String.IsNullOrEmpty(IP) Then QueueMessage(ResString(My.Resources.PROFILE_IP, IP))
                If Not String.IsNullOrEmpty(Port) Then QueueMessage(ResString(My.Resources.PROFILE_PORT, Port))
                If Not String.IsNullOrEmpty(MFT_Bytes) Then QueueMessage(ResString(My.Resources.PROFILE_MFT_BYTES, MFT_Bytes))
                If Not String.IsNullOrEmpty(MFT_LastWrite) Then QueueMessage(ResString(My.Resources.PROFILE_MFT_LASTWRITE, FTStrToDate(MFT_LastWrite)))
                If Not String.IsNullOrEmpty(MFT_TimeLogged) Then QueueMessage(ResString(My.Resources.PROFILE_MFT_TIMELOGGED, ConvertTime(MFT_TimeLogged * 1000)))
              Case ProfileRequests.ProfileRequestDisplay.PublicWhisper
                QueueMessage(sWhis & ResString(My.Resources.PROFILE_ACCOUNTCREATE, ChatData.AccountCreatead))
                QueueMessage(sWhis & ResString(My.Resources.PROFILE_LASTLOGOFF, ChatData.LastLogoff))
                QueueMessage(sWhis & ResString(My.Resources.PROFILE_LASTLOGON, ChatData.LastLogon))
                QueueMessage(sWhis & ResString(My.Resources.PROFILE_TIMELOGGED, ConvertTime(ChatData.TimeLogged * 1000)))
                If Not String.IsNullOrEmpty(Friends) Then QueueMessage(sWhis & ResString(My.Resources.PROFILE_FRIENDS, Friends))
                If Not String.IsNullOrEmpty(League) Then QueueMessage(sWhis & ResString(My.Resources.PROFILE_LEAGUE, League))
                If Not String.IsNullOrEmpty(Icon) Then QueueMessage(sWhis & ResString(My.Resources.PROFILE_ICON, Icon))
                If Not String.IsNullOrEmpty(AuthLevel) Then QueueMessage(sWhis & ResString(My.Resources.PROFILE_AUTH, AuthLevel))
                If Not String.IsNullOrEmpty(Flags) Then QueueMessage(sWhis & ResString(My.Resources.PROFILE_FLAGS, Flags))
                If Not String.IsNullOrEmpty(IP) Then QueueMessage(sWhis & ResString(My.Resources.PROFILE_IP, IP))
                If Not String.IsNullOrEmpty(Port) Then QueueMessage(sWhis & ResString(My.Resources.PROFILE_PORT, Port))
                If Not String.IsNullOrEmpty(MFT_Bytes) Then QueueMessage(sWhis & ResString(My.Resources.PROFILE_MFT_BYTES, MFT_Bytes))
                If Not String.IsNullOrEmpty(MFT_LastWrite) Then QueueMessage(sWhis & ResString(My.Resources.PROFILE_MFT_LASTWRITE, FTStrToDate(MFT_LastWrite)))
                If Not String.IsNullOrEmpty(MFT_TimeLogged) Then QueueMessage(sWhis & ResString(My.Resources.PROFILE_MFT_TIMELOGGED, ConvertTime(MFT_TimeLogged * 1000)))
            End Select
          Next
        Case ProfileRequests.ProfileRequestType.NormalGameRecord
          For I As Integer = 0 To lAccounts - 1
            Dim lWins, lLosses, lDisconnects As Int64
            Int64.TryParse(pktRead.ReadCString, lWins)
            Int64.TryParse(pktRead.ReadCString, lLosses)
            Int64.TryParse(pktRead.ReadCString, lDisconnects)
            Dim sLastGameResult As String = pktRead.ReadCString
            Dim sLastGame As String = FTStrToDate(pktRead.ReadCString)
            Select Case prDisp
              Case ProfileRequests.ProfileRequestDisplay.PrivateText
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.RECORD_HEADER_NORMAL, sUsernames(I)))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.RECORD_SCORE, lWins.ToString.Trim, lLosses.ToString.Trim, lDisconnects.ToString.Trim))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.RECORD_LASTGAME, sLastGame, sLastGameResult))
              Case ProfileRequests.ProfileRequestDisplay.PublicChat
                QueueMessage(ResString(My.Resources.RECORD_HEADER_NORMAL, sUsernames(I)))
                QueueMessage(ResString(My.Resources.RECORD_SCORE, lWins.ToString.Trim, lLosses.ToString.Trim, lDisconnects.ToString.Trim))
                QueueMessage(ResString(My.Resources.RECORD_LASTGAME, sLastGame, sLastGameResult))
              Case ProfileRequests.ProfileRequestDisplay.PublicWhisper
                QueueMessage(sWhis & ResString(My.Resources.RECORD_HEADER_NORMAL, sUsernames(I)))
                QueueMessage(sWhis & ResString(My.Resources.RECORD_SCORE, lWins.ToString.Trim, lLosses.ToString.Trim, lDisconnects.ToString.Trim))
                QueueMessage(sWhis & ResString(My.Resources.RECORD_LASTGAME, sLastGame, sLastGameResult))
            End Select
          Next
        Case ProfileRequests.ProfileRequestType.LadderGameRecord
          For I As Integer = 0 To lAccounts - 1
            Dim lWins, lLosses, lDisconnects, lRating, lRatingHigh, lRank As Int64
            Int64.TryParse(pktRead.ReadCString, lWins)
            Int64.TryParse(pktRead.ReadCString, lLosses)
            Int64.TryParse(pktRead.ReadCString, lDisconnects)
            Dim sLastGameResult As String = pktRead.ReadCString
            Dim sLastGame As String = FTStrToDate(pktRead.ReadCString)
            Int64.TryParse(pktRead.ReadCString, lRating)
            Int64.TryParse(pktRead.ReadCString, lRatingHigh)
            Int64.TryParse(pktRead.ReadCString, lRank)
            Select Case prDisp
              Case ProfileRequests.ProfileRequestDisplay.PrivateText
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.RECORD_HEADER_LADDER, sUsernames(I)))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.RECORD_SCORE, lWins.ToString.Trim, lLosses.ToString.Trim, lDisconnects.ToString.Trim))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.RECORD_LASTGAME, sLastGame, sLastGameResult))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.RECORD_RANK, lRating.ToString.Trim, lRatingHigh.ToString.Trim, lRank.ToString.Trim))
              Case ProfileRequests.ProfileRequestDisplay.PublicChat
                QueueMessage(ResString(My.Resources.RECORD_HEADER_LADDER, sUsernames(I)))
                QueueMessage(ResString(My.Resources.RECORD_SCORE, lWins.ToString.Trim, lLosses.ToString.Trim, lDisconnects.ToString.Trim))
                QueueMessage(ResString(My.Resources.RECORD_LASTGAME, sLastGame, sLastGameResult))
                QueueMessage(ResString(My.Resources.RECORD_RANK, lRating.ToString.Trim, lRatingHigh.ToString.Trim, lRank.ToString.Trim))
              Case ProfileRequests.ProfileRequestDisplay.PublicWhisper
                QueueMessage(sWhis & ResString(My.Resources.RECORD_HEADER_LADDER, sUsernames(I)))
                QueueMessage(sWhis & ResString(My.Resources.RECORD_SCORE, lWins.ToString.Trim, lLosses.ToString.Trim, lDisconnects.ToString.Trim))
                QueueMessage(sWhis & ResString(My.Resources.RECORD_LASTGAME, sLastGame, sLastGameResult))
                QueueMessage(sWhis & ResString(My.Resources.RECORD_RANK, lRating.ToString.Trim, lRatingHigh.ToString.Trim, lRank.ToString.Trim))
            End Select
          Next
        Case ProfileRequests.ProfileRequestType.IronManGameRecord
          For I As Integer = 0 To lAccounts - 1
            Dim lWins, lLosses, lDisconnects, lRating, lRatingHigh, lRank As Int64
            Int64.TryParse(pktRead.ReadCString, lWins)
            Int64.TryParse(pktRead.ReadCString, lLosses)
            Int64.TryParse(pktRead.ReadCString, lDisconnects)
            Dim sLastGameResult As String = pktRead.ReadCString
            Dim sLastGame As String = FTStrToDate(pktRead.ReadCString)
            Int64.TryParse(pktRead.ReadCString, lRating)
            Int64.TryParse(pktRead.ReadCString, lRatingHigh)
            Int64.TryParse(pktRead.ReadCString, lRank)
            Select Case prDisp
              Case ProfileRequests.ProfileRequestDisplay.PrivateText
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.RECORD_HEADER_IRONMAN, sUsernames(I)))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.RECORD_SCORE, lWins.ToString.Trim, lLosses.ToString.Trim, lDisconnects.ToString.Trim))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.RECORD_LASTGAME, sLastGame, sLastGameResult))
                gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, ResString(My.Resources.RECORD_RANK, lRating.ToString.Trim, lRatingHigh.ToString.Trim, lRank.ToString.Trim))
              Case ProfileRequests.ProfileRequestDisplay.PublicChat
                QueueMessage(ResString(My.Resources.RECORD_HEADER_IRONMAN, sUsernames(I)))
                QueueMessage(ResString(My.Resources.RECORD_SCORE, lWins.ToString.Trim, lLosses.ToString.Trim, lDisconnects.ToString.Trim))
                QueueMessage(ResString(My.Resources.RECORD_LASTGAME, sLastGame, sLastGameResult))
                QueueMessage(ResString(My.Resources.RECORD_RANK, lRating.ToString.Trim, lRatingHigh.ToString.Trim, lRank.ToString.Trim))
              Case ProfileRequests.ProfileRequestDisplay.PublicWhisper
                QueueMessage(sWhis & ResString(My.Resources.RECORD_HEADER_IRONMAN, sUsernames(I)))
                QueueMessage(sWhis & ResString(My.Resources.RECORD_SCORE, lWins.ToString.Trim, lLosses.ToString.Trim, lDisconnects.ToString.Trim))
                QueueMessage(sWhis & ResString(My.Resources.RECORD_LASTGAME, sLastGame, sLastGameResult))
                QueueMessage(sWhis & ResString(My.Resources.RECORD_RANK, lRating.ToString.Trim, lRatingHigh.ToString.Trim, lRank.ToString.Trim))
            End Select
          Next
        Case Else
          For I As Integer = 0 To lAccounts - 1
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, "User: " & I)
            For J As Integer = 0 To lKeys - 1
              gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, " Field " & J & ": " & DeCensor(pktRead.ReadCString))
            Next
          Next
      End Select
    End If
  End Sub

  Private Sub BNCS_READUSERDATA_Send(lCookie As UInt32, sAccounts() As String, sKeys() As String)
    Dim pktTemp As New BNCSPacket(BNCS_READUSERDATA)
    pktTemp.InsertUInt32(sAccounts.Count)
    pktTemp.InsertUInt32(sKeys.Count)
    pktTemp.InsertUInt32(lCookie)
    For Each Account As String In sAccounts
      pktTemp.InsertCString(Account)
    Next
    For Each Key As String In sKeys
      pktTemp.InsertCString(Key)
    Next
    BNCS_Send(pktTemp)
  End Sub

  Public Sub BNCS_WRITEUSERDATA_Send(sAccount As String, Fields() As String, Contents() As String)
    If Fields IsNot Nothing And Contents IsNot Nothing Then
      If Fields.Length = Contents.Length Then
        For I As Integer = 0 To Contents.Length - 1
          If Contents(I).Length > 512 Then Contents(I) = Contents(I).Substring(0, 511)
        Next
        Dim pktTemp As New BNCSPacket(BNCS_WRITEUSERDATA)
        pktTemp.InsertUInt32(1)
        pktTemp.InsertUInt32(Fields.Length)
        pktTemp.InsertCString(sAccount)
        For I As Integer = 0 To Fields.Length - 1
          pktTemp.InsertCString(Fields(I))
        Next
        For I As Integer = 0 To Contents.Length - 1
          If Config.UTF8 Then
            pktTemp.InsertByteArray(System.Text.Encoding.GetEncoding(UTF_8).GetBytes(Contents(I)))
          Else
            pktTemp.InsertByteArray(System.Text.Encoding.GetEncoding(LATIN_1).GetBytes(Contents(I)))
          End If
          pktTemp.InsertByte(0)
        Next
        BNCS_Send(pktTemp)
      End If
    End If
  End Sub

  Private Sub BNCS_LOGONCHALLENGE_Recv(pktRead As BNCSReader)
    BNetData.ServerToken = pktRead.ReadUInt32
    PKT_CONNTEST_Send()
  End Sub

  Private Sub BNCS_LOGONRESPONSE_Recv(pktRead As BNCSReader)
    If pktRead.ReadBoolean Then
      GetUserData(Config.Account.Username, ProfileRequests.ProfileRequestType.AccountInfo, ProfileRequests.ProfileRequestDisplay.PrivateUI)
      BNCS_GETICONDATA_Send()
    Else
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_BADPASS)
      BNCS_CREATEACCOUNT_Send()
    End If
  End Sub

  Private Sub BNCS_LOGONRESPONSE_Send()
    BNCS_UDPPINGRESPONSE_Send()
    If Config.Account.Change.PassReset Then
      BNCS_RESETPASSWORD_Send()
      Exit Sub
    End If
    If Not String.IsNullOrEmpty(Config.Account.Change.Password) Then BNCS_CHANGEPASSWORD_Send()
    If Not String.IsNullOrEmpty(Config.Account.Change.EMail) Then BNCS_CHANGEEMAIL_Send()
    If BNetData.ClientToken = 0 Then BNetData.ClientToken = Environment.TickCount
    If BNetData.ServerToken = 0 Then
      BNCS_Disconnect(True)
      AttemptReconnect(My.Resources.ERR_SERVERTOKEN)
      Exit Sub
    End If
    Dim pktTemp As New BNCSPacket(BNCS_LOGONRESPONSE)
    pktTemp.InsertUInt32(BNetData.ClientToken)
    pktTemp.InsertUInt32(BNetData.ServerToken)
    pktTemp.InsertByteArray(XSHA.DoubleHashPassword(Config.Account.Password, BNetData.ClientToken, BNetData.ServerToken))
    pktTemp.InsertCString(Config.Account.Username)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CREATEACCOUNT_Recv(pktRead As BNCSReader)
    If pktRead.ReadBoolean Then
      gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_CREATED)
      BNCS_LOGONRESPONSE_Send()
    Else
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_FAILED)
      BNCS_Disconnect(True)
    End If
  End Sub

  Private Sub BNCS_CREATEACCOUNT_Send()
    Dim pktTemp As New BNCSPacket(BNCS_CREATEACCOUNT)
    pktTemp.InsertByteArray(XSHA.HashPassword(Config.Account.Password))
    pktTemp.InsertCString(Config.Account.Username)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_SYSTEMINFO_Send()
    Dim pktTemp As New BNCSPacket(BNCS_SYSTEMINFO)
    Dim ProcCount As UInt32
    Dim ProcArch As UInt32
    Dim ProcLev As UInt32
    Dim ProcTime As UInt32
    Dim TotalMem As UInt32
    Dim PageFile As UInt32
    Dim DiskSpace As UInt32
    GetSysInfo(ProcCount, ProcArch, ProcLev, ProcTime, TotalMem, PageFile, DiskSpace)
    pktTemp.InsertUInt32(ProcCount)
    pktTemp.InsertUInt32(ProcArch)
    pktTemp.InsertUInt32(ProcLev)
    pktTemp.InsertUInt32(ProcTime)
    pktTemp.InsertUInt32(TotalMem)
    pktTemp.InsertUInt32(PageFile)
    pktTemp.InsertUInt32(DiskSpace)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_GAMERESULT_Send(GameType As UInt32, GameResults() As UInt32, GamePlayers() As String, MapName As String, PlayerScore As String)
    Dim pktTemp As New BNCSPacket(BNCS_GAMERESULT)
    pktTemp.InsertUInt32(GameType)
    pktTemp.InsertUInt32(8)
    For Each GameResult As UInt32 In GameResults
      pktTemp.InsertUInt32(GameResult)
    Next
    pktTemp.InsertUInt32(8)
    For Each GamePlayer As String In GamePlayers
      pktTemp.InsertCString(GamePlayer)
    Next
    pktTemp.InsertCString(MapName)
    pktTemp.InsertCString(PlayerScore)
  End Sub

  Private Sub BNCS_GETICONDATA_Recv(pktRead As BNCSReader)
    Dim iconTime As UInt64 = pktRead.ReadUInt64
    Dim iconName As String = pktRead.ReadCString
    If Not My.Computer.FileSystem.DirectoryExists(AppStore & "\icons") Then My.Computer.FileSystem.CreateDirectory(AppStore & "\icons")
    If iconName <> "icons.bni" And iconName <> "icons_STAR.bni" And iconName <> "icons-WAR3.bni" Then
      Dim iconPath As String = AppStore & "\icons\" & iconName
      If Not My.Computer.FileSystem.FileExists(iconPath) Then
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_DOWNLOADING, iconName))
        If Config.Account.Client.Product = GameType.WAR3 Or Config.Account.Client.Product = GameType.W3XP Then
          If BNFTPRequest(GameArch.IX86, Config.Account.Client.Product, iconPath, My.Computer.FileSystem.GetFileInfo(iconPath).LastWriteTime, Config.Account.Client.CDKey) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_OK, iconName))
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_FTP, ResString(My.Resources.ERR_FTP_FAIL, iconName))
          End If
        Else
          If BNFTPRequest(GameArch.IX86, Config.Account.Client.Product, iconPath, My.Computer.FileSystem.GetFileInfo(iconPath).LastWriteTime) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_OK, iconName))
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_FTP, ResString(My.Resources.ERR_FTP_FAIL, iconName))
          End If
        End If
      End If
      'File should be loaded somehow as well!
    End If
    BNCS_GETFILETIME_Send(&H1C, 0, "icons.bni")
    Select Case Config.Account.Client.Product
      Case GameType.D2DV, GameType.D2XP
        BNCS_GETFILETIME_Send(&H80000004, 0, "bnserver-D2DV.ini")
      Case GameType.WAR3, GameType.W3XP
        BNCS_GETFILETIME_Send(&H1E, 0, "icons-WAR3.bni")
        BNCS_GETFILETIME_Send(&H3, 0, "bnserver-WAR3.ini")
      Case GameType.STAR, GameType.SEXP, GameType.JSTR, GameType.SSHR
        BNCS_GETFILETIME_Send(&H1D, 0, "icons_STAR.bni")
        BNCS_GETFILETIME_Send(&H1B, 0, "bnserver.ini")
      Case Else
        BNCS_GETFILETIME_Send(&H1B, 0, "bnserver.ini")
    End Select
  End Sub

  Private Sub BNCS_GETICONDATA_Send()
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_GETICONDATA)
    Dim pktTemp As New BNCSPacket(BNCS_GETICONDATA)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_GETLADDERDATA_Recv(pktRead As BNCSReader)
    '(DWORD) Ladder type
    '(DWORD) League
    '(DWORD) Sort method
    '(DWORD) Starting rank
    '(DWORD) Number of ranks listed (Count of items in list)
    'For each list item:
    '    (DWORD) Wins
    '    (DWORD) Losses
    '    (DWORD) Disconnects
    '    (DWORD) Rating
    '    (DWORD) Rank
    '    (DWORD) Official wins
    '    (DWORD) Official losses
    '    (DWORD) Official disconnects
    '    (DWORD) Official rating
    '    (DWORD) Unknown
    '    (DWORD) Official rank
    '    (DWORD) Unknown
    '    (DWORD) Unknown
    '    (DWORD) Highest rating
    '    (DWORD) Unknown
    '    (DWORD) Season
    '    (FILETIME) Last game time
    '    (FILETIME) Official last game time
    '    (STRING) Name
  End Sub

  Private Sub BNCS_GETLADDERDATA_Send()
    Dim pktTemp As New BNCSPacket(BNCS_GETLADDERDATA)
    '(DWORD) Product ID
    '(DWORD) League
    '(DWORD) Sort method
    '(DWORD) Starting rank
    '(DWORD) Number of ranks to list

    'Sort Methods:
    ' 0x00: Highest Rating
    ' 0x01: Fastest Climbers
    ' 0x02: Most wins on record
    ' 0x03: Most games played
  End Sub

  Private Sub BNCS_FINDLADDERUSER_Recv(pktRead As BNCSReader)
    Dim Rank As UInt32 = pktRead.ReadUInt32 '0xFFFFFFFF = Not Ranked
  End Sub

  Private Sub BNCS_FINDLADDERUSER_Send()
    Dim pktTemp As New BNCSPacket(BNCS_FINDLADDERUSER)
    '(DWORD) League
    '(DWORD) Sort method
    '(STRING) Username 

    'Sort Methods:
    ' 0x00: Highest Rating
    ' 0x01: Unused (Fastest Climbers)
    ' 0x02: Most wins on record
    ' 0x03: Most games played
  End Sub

  Private Sub BNCS_CDKEY_Recv(pktRead As BNCSReader)
    Dim lRet As UInt32 = pktRead.ReadUInt32
    Select Case lRet
      Case &H1
        BNCS_LOGONRESPONSE_Send()
      Case &H2
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_INVALID)
        BNCS_Disconnect(True)
      Case &H3
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_WRONGPRODUCT)
        BNCS_Disconnect(True)
      Case &H4
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_BANNED)
        BNCS_Disconnect(True)
      Case &H5
        Dim sOwner As String = pktRead.ReadCString
        If String.IsNullOrEmpty(sOwner) Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_INUSE)
        ElseIf sOwner = "TOO MANY SPAWNS" Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_TOOMANYSPAWNS)
        ElseIf sOwner = "NO SPAWNING" Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_NOSPAWNING)
        ElseIf StrComp(sOwner, Config.Account.Username, CompareMethod.Text) = 0 Then
          AttemptReconnect(My.Resources.CDKEY_INUSEBYSELF, 150)
        Else
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.CDKEY_INUSEBY, sOwner))
        End If
        BNCS_Disconnect(True)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.CDKEY_FAIL, Hex(lRet)))
        BNCS_Disconnect(True)
    End Select
  End Sub

  Private Sub BNCS_CDKEY_Send()
    If String.IsNullOrWhiteSpace(New clsKey(Config.Account.Client.CDKey).Key) Then
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_INVALID)
      BNCS_Disconnect(True)
    Else
      Dim pktTemp As New BNCSPacket(BNCS_CDKEY)
      pktTemp.InsertBoolean(Config.Account.Client.Spawn)
      pktTemp.InsertCString(CDLegal(New clsKey(Config.Account.Client.CDKey).Key))
      pktTemp.InsertCString(Config.Account.Username)
      BNCS_Send(pktTemp)
    End If
  End Sub

  Private Sub BNCS_CHANGEPASSWORD_Recv(pktRead As BNCSReader)
    If pktRead.ReadByte = 1 Then
      gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, My.Resources.PASSWORD_CHANGED)
      Config.Account.Password = Config.Account.Change.Password
      Config.Account.Change.Password = Nothing
      SaveSettings(Index, Config)
      BNCS_LOGONRESPONSE_Send()
    Else
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.PASSWORD_CHANGE_FAIL)
      BNCS_LOGONRESPONSE_Send()
    End If
  End Sub

  Private Sub BNCS_CHANGEPASSWORD_Send()
    Dim pktTemp As New BNCSPacket(BNCS_CHANGEPASSWORD)
    pktTemp.InsertUInt32(BNetData.ClientToken)
    pktTemp.InsertUInt32(BNetData.ServerToken)
    pktTemp.InsertByteArray(XSHA.DoubleHashPassword(Config.Account.Password, BNetData.ClientToken, BNetData.ServerToken))
    pktTemp.InsertByteArray(XSHA.HashPassword(Config.Account.Change.Password))
    pktTemp.InsertCString(Config.Account.Username)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CHECKDATAFILE_Recv(pktRead As BNCSReader)
    Dim lStatus As UInt32 = pktRead.ReadUInt32
    Select Case lStatus
      Case 0
        'Rejected
      Case 1
        'Approved
      Case 2
        'Ladder Approved
    End Select
  End Sub

  Private Sub BNCS_CHECKDATAFILE_Send()
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, "YOU SHOULD NOT BE USING THIS PACKET")
    '(DWORD) [5] File Checksum
    '(STRING) File Name
    'The digest is created by using the broken SHA-1 hash on the first 64-bytes of the (filesize % 64) times. This due to a bug in the client.
  End Sub

  Private Sub BNCS_GETFILETIME_Recv(pktRead As BNCSReader)
    Dim RequestID As Int32 = pktRead.ReadInt32
    Dim Unknown As UInt32 = pktRead.ReadUInt32
    Dim FileTime As UInt64 = pktRead.ReadUInt64
    Dim FileName As String = pktRead.ReadCString
    Select Case RequestID
      Case &H3, &H1B, &H80000004
        Dim bGet As Boolean = False
        If My.Computer.FileSystem.FileExists(AppStore & "\" & FileName) Then
          bGet = UInt64ToDate(FileTime) > My.Computer.FileSystem.GetFileInfo(AppStore & "\" & FileName).LastWriteTime
        Else
          bGet = True
        End If
        If bGet Then
          gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_DOWNLOADING, FileName))
          If BNFTPRequest(GameArch.IX86, GetProd, AppStore & "\" & FileName, IIf(My.Computer.FileSystem.FileExists(AppStore & "\" & FileName), My.Computer.FileSystem.GetFileInfo(AppStore & "\" & FileName).LastWriteTime, Nothing)) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_OK, FileName))
            If GetGateways() Is Nothing Or RequestID = &H3 Then LoadBNServer()
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_FTP, ResString(My.Resources.ERR_FTP_FAIL, FileName))
          End If
        End If
        BNCS_ENTERCHAT_Send()
        BNCS_GETCHANNELLIST_Send()
        BNCS_JOINCHANNEL_Send(Config.Account.HomeChannel)
        SetAds(True)
        BNCS_CHECKAD_Send()
      Case &H1C
        Dim bGet As Boolean = False
        If My.Computer.FileSystem.FileExists(AppStore & "\icons\" & FileName) Then
          bGet = UInt64ToDate(FileTime) > My.Computer.FileSystem.GetFileInfo(AppStore & "\icons\" & FileName).LastWriteTime
        Else
          bGet = True
        End If
        If bGet Then
          gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_DOWNLOADING, FileName))
          If BNFTPRequest(GameArch.IX86, Config.Account.Client.Product, AppStore & "\icons\" & FileName, IIf(My.Computer.FileSystem.FileExists(AppStore & "\icons\" & FileName), My.Computer.FileSystem.GetFileInfo(AppStore & "\icons\" & FileName).LastWriteTime, Nothing)) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_OK, FileName))
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_FTP, ResString(My.Resources.ERR_FTP_FAIL, FileName))
            BNCS_GETFILETIME_Send(&H1C, 0, "icons.bni")
            Exit Sub
          End If
        End If
        ParseIconsDefault()
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\DRTL.png"))
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\DSHR.png"))
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\D2DV.png"))
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\D2XP.png"))
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\STAR.png"))
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\SEXP.png"))
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\JSTR.png"))
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\SSHR.png"))
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\W2BN.png"))
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\WAR3.png"))
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\W3XP.png"))
        imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\icons\CHAT.png"))
        If My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\bnet-unknown-off.blp.png") Then imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\WAR3\bnet-unknown-off.blp.png"))
        If My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\bnet-unknown.blp.png") Then imlFriends.Images.Add(Image.FromFile(AppTemp & "\icons\WAR3\bnet-unknown.blp.png"))
      Case &H1D
        Dim bGet As Boolean = False
        If My.Computer.FileSystem.FileExists(AppStore & "\icons\" & FileName) Then
          bGet = UInt64ToDate(FileTime) > My.Computer.FileSystem.GetFileInfo(AppStore & "\icons\" & FileName).LastWriteTime
        Else
          bGet = True
        End If
        If bGet Then
          gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_DOWNLOADING, FileName))
          If BNFTPRequest(GameArch.IX86, Config.Account.Client.Product, AppStore & "\icons\" & FileName, IIf(My.Computer.FileSystem.FileExists(AppStore & "\icons\" & FileName), My.Computer.FileSystem.GetFileInfo(AppStore & "\icons\" & FileName).LastWriteTime, Nothing)) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_OK, FileName))
            ParseIconsSTAR()
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_FTP, ResString(My.Resources.ERR_FTP_FAIL, FileName))
          End If
        End If
      Case &H1E
        Dim bGet As Boolean = False
        If My.Computer.FileSystem.FileExists(AppStore & "\icons\" & FileName) Then
          bGet = UInt64ToDate(FileTime) > My.Computer.FileSystem.GetFileInfo(AppStore & "\icons\" & FileName).LastWriteTime
        Else
          bGet = True
        End If
        If bGet Then
          gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_DOWNLOADING, FileName))
          If BNFTPRequest(GameArch.IX86, Config.Account.Client.Product, AppStore & "\icons\" & FileName, IIf(My.Computer.FileSystem.FileExists(AppStore & "\icons\" & FileName), My.Computer.FileSystem.GetFileInfo(AppStore & "\icons\" & FileName).LastWriteTime, Nothing), Config.Account.Client.CDKey) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_OK, FileName))
            ParseIconsWAR3()
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_FTP, ResString(My.Resources.ERR_FTP_FAIL, FileName))
          End If
        End If
      Case &H80000005, &H80000006
        If Not My.Computer.FileSystem.DirectoryExists(AppStore & "\Work") Then My.Computer.FileSystem.CreateDirectory(AppStore & "\Work")
        Dim WorkPath As String = AppStore & "\Work\" & FileName
        Dim bGet As Boolean = False
        If My.Computer.FileSystem.FileExists(WorkPath) Then
          bGet = UInt64ToDate(FileTime) > My.Computer.FileSystem.GetFileInfo(WorkPath).LastWriteTime
        Else
          bGet = True
        End If
        If bGet Then
          gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_DOWNLOADING, FileName))
          If Config.Account.Client.Product = GameType.WAR3 Or Config.Account.Client.Product = GameType.W3XP Then
            If BNFTPRequest(GameArch.IX86, Config.Account.Client.Product, WorkPath, Nothing, Config.Account.Client.CDKey) Then
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_OK, FileName))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_FTP, ResString(My.Resources.ERR_FTP_FAIL, FileName))
              Exit Sub
            End If
          Else
            If BNFTPRequest(GameArch.IX86, Config.Account.Client.Product, WorkPath, Nothing) Then
              gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_OK, FileName))
            Else
              gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_FTP, ResString(My.Resources.ERR_FTP_FAIL, FileName))
              Exit Sub
            End If
          End If
        End If
        If My.Computer.FileSystem.FileExists(WorkPath) Then
          Using ExtraWorkMPQ As New MPQ(WorkPath)
            Dim sFile As String = ExtraWorkMPQ.GetListFile
            If String.IsNullOrEmpty(sFile) Then
              gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_MPQ_NOLIST, CRev.MPQName))
            Else
              Dim sFiles() As String = Split(sFile, vbNewLine)
              If Not My.Computer.FileSystem.DirectoryExists(AppStore & "\Work") Then My.Computer.FileSystem.CreateDirectory(AppStore & "\Work")
              For Each sItem As String In sFiles
                Select Case sItem
                  Case "(signature)", Nothing, String.Empty
                    'ignore
                  Case Else
                    ExtraWorkMPQ.SaveToPath(sItem, AppStore & "\Work")
                End Select
              Next
            End If
          End Using
        End If
      Case Else
        Debug.Print(RequestID & ": " & FileName)
    End Select
  End Sub

  Private Sub BNCS_GETFILETIME_Send(RequestID As Int32, Unknown As UInt32, Filename As String)
    Using pktTemp As New BNCSPacket(BNCS_GETFILETIME)
      pktTemp.InsertInt32(RequestID)
      pktTemp.InsertUInt32(Unknown)
      pktTemp.InsertCString(Filename)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_QUERYREALMS_Recv(pktRead As BNCSReader)
    Dim Unknown As UInt32 = pktRead.ReadUInt32
    Dim RealmCount As UInt32 = pktRead.ReadUInt32
    Realms.RealmListing.ClearRealms()
    For I As UInt32 = 0 To RealmCount - 1
      If pktRead.ReadUInt32 = &H1 Then
        Realms.RealmListing.AddRealm(pktRead.ReadCString, pktRead.ReadCString)
      Else
        Realms.RealmListing.AddRealm(pktRead.ReadCString, pktRead.ReadCString)
      End If
    Next I
    DisplayRealmListing(True)
  End Sub

  Private Sub BNCS_QUERYREALMS_Send()
    Dim pktTemp As New BNCSPacket(BNCS_QUERYREALMS)
    pktTemp.InsertUInt32(0)
    pktTemp.InsertUInt32(0)
    pktTemp.InsertCString(String.Empty)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_PROFILE_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim Success As Byte = pktRead.ReadByte
    If Success = 0 Then
      Dim sUsernames() As String = Nothing
      Dim prType As ProfileRequests.ProfileRequestType
      Dim prDisp As ProfileRequests.ProfileRequestDisplay
      Dim prUpdate As frmProfile.UpdateTypes
      Dim prWhisperTo As String = String.Empty
      ProfileRequestList.GetRequest(Cookie, sUsernames, prType, prDisp, prUpdate, prWhisperTo)
      Dim sWhis As String = "/w " & IIf(Config.Account.Client.Product = GameType.D2DV Or Config.Account.Client.Product = GameType.D2XP, "*", String.Empty) & prWhisperTo & " "
      Dim Description As String = pktRead.ReadCString
      Dim Location As String = pktRead.ReadCString
      Dim ClanTag As String = pktRead.ReadDWORDString()
      ProfileWindow.UpdateW3Tab(sUsernames(0), prUpdate, {Location, Description, ClanTag})
      If W3Icons Is Nothing Then BNCS_WARCRAFTGENERAL_Send(WID_ICONLIST, &H1)
      BNCS_WARCRAFTGENERAL_Send(WID_USERRECORD, ProfileRequestList.AddRequest(sUsernames, ProfileRequests.ProfileRequestType.WarcraftUserStats, ProfileRequests.ProfileRequestDisplay.PrivateUI, frmProfile.UpdateTypes.WAR3Stats, prWhisperTo), sUsernames(0), Config.Account.Client.Product)
      If Not String.IsNullOrEmpty(ClanTag) Then
        BNCS_CLANMEMBERINFORMATION_Send(ProfileRequestList.AddRequest(sUsernames, ProfileRequests.ProfileRequestType.WarcraftUserStats, ProfileRequests.ProfileRequestDisplay.PrivateUI, frmProfile.UpdateTypes.WAR3ClanInfo, prWhisperTo), ClanTag, sUsernames(0))
        BNCS_WARCRAFTGENERAL_Send(WID_CLANRECORD, ProfileRequestList.AddRequest(sUsernames, ProfileRequests.ProfileRequestType.WarcraftClanStats, ProfileRequests.ProfileRequestDisplay.PrivateUI, frmProfile.UpdateTypes.WAR3ClanStats, prWhisperTo), ClanTag, Config.Account.Client.Product)
      End If
    End If
  End Sub

  Private Sub BNCS_PROFILE_Send(Cookie As UInt32, Account As String)
    Dim pktTemp As New BNCSPacket(BNCS_PROFILE)
    pktTemp.InsertUInt32(Cookie)
    pktTemp.InsertCString(Account)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CDKEY2_Recv(pktRead As BNCSReader)
    Dim lRet As UInt32 = pktRead.ReadUInt32
    Select Case lRet
      Case &H1
        BNCS_LOGONRESPONSE_Send()
      Case &H2
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_INVALID)
        BNCS_Disconnect(True)
      Case &H3
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_WRONGPRODUCT)
        BNCS_Disconnect(True)
      Case &H4
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_BANNED)
        BNCS_Disconnect(True)
      Case &H5
        Dim sOwner As String = pktRead.ReadCString
        If String.IsNullOrEmpty(sOwner) Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_INUSE)
        ElseIf sOwner = "TOO MANY SPAWNS" Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_TOOMANYSPAWNS)
        ElseIf sOwner = "NO SPAWNING" Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_NOSPAWNING)
        ElseIf StrComp(sOwner, Config.Account.Username, CompareMethod.Text) = 0 Then
          AttemptReconnect(My.Resources.CDKEY_INUSEBYSELF, 150)
        Else
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.CDKEY_INUSEBY, sOwner))
        End If
        BNCS_Disconnect(True)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.CDKEY_FAIL, Hex(lRet)))
        BNCS_Disconnect(True)
    End Select
  End Sub

  Private Sub BNCS_CDKEY2_Send()
    If BNetData.ClientToken = 0 Then BNetData.ClientToken = Environment.TickCount
    If BNetData.ServerToken = 0 Then
      BNCS_Disconnect(True)
      AttemptReconnect(My.Resources.ERR_SERVERTOKEN)
      Exit Sub
    End If
    Dim Key As New clsKey(Config.Account.Client.CDKey)
    If Key.IsValid And ProdMatch(Config.Account.Client.Product, Key.Product, False) Then
      Dim pktTemp As New BNCSPacket(BNCS_CDKEY2)
      pktTemp.InsertBoolean(Config.Account.Client.Spawn)
      pktTemp.InsertUInt32(CDLegal(Key.Key).Length)
      pktTemp.InsertUInt32(Key.Product)
      pktTemp.InsertUInt32(Key.PublicVal)
      pktTemp.InsertUInt32(BNetData.ServerToken)
      pktTemp.InsertUInt32(BNetData.ClientToken)
      pktTemp.InsertByteArray(Key.GetHash(BNetData.ClientToken, BNetData.ServerToken, False))
      pktTemp.InsertCString(Config.Account.Username)
      BNCS_Send(pktTemp)
    Else
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_INVALID)
      BNCS_Disconnect(True)
    End If
  End Sub

  Private Sub BNCS_LOGONRESPONSE2_Recv(pktRead As BNCSReader)
    Select Case pktRead.ReadUInt32
      Case 0
        If (Config.Account.Client.Product = GameType.D2DV Or Config.Account.Client.Product = GameType.D2XP) And Config.Account.Client.D2Realm Then
          BeginRealmLogin()
        Else
          GetUserData(Config.Account.Username, ProfileRequests.ProfileRequestType.AccountInfo, ProfileRequests.ProfileRequestDisplay.PrivateUI)
          BNCS_GETICONDATA_Send()
        End If
      Case 1
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_BADACCOUNT)
        BNCS_CREATEACCOUNT2_Send()
      Case 2
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_BADPASS)
        BNCS_Disconnect(True)
      Case 6
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_ACCOUNTCLOSED, pktRead.ReadCString))
        BNCS_Disconnect(True)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.LOGONRESPONSE_UNKNOWN)
        BNCS_CREATEACCOUNT2_Send()
    End Select
  End Sub

  Private Sub BNCS_LOGONRESPONSE2_Send()
    BNCS_UDPPINGRESPONSE_Send()
    If Config.Account.Change.PassReset Then
      BNCS_RESETPASSWORD_Send()
      Exit Sub
    End If
    If Not String.IsNullOrEmpty(Config.Account.Change.Password) Then BNCS_CHANGEPASSWORD_Send()
    If Not String.IsNullOrEmpty(Config.Account.Change.EMail) Then BNCS_CHANGEEMAIL_Send()
    If BNetData.ClientToken = 0 Then BNetData.ClientToken = Environment.TickCount
    If BNetData.ServerToken = 0 Then
      BNCS_Disconnect(True)
      AttemptReconnect(My.Resources.ERR_SERVERTOKEN)
      Exit Sub
    End If
    Dim pktTemp As New BNCSPacket(BNCS_LOGONRESPONSE2)
    pktTemp.InsertUInt32(BNetData.ClientToken)
    pktTemp.InsertUInt32(BNetData.ServerToken)
    pktTemp.InsertByteArray(XSHA.DoubleHashPassword(Config.Account.Password, BNetData.ClientToken, BNetData.ServerToken))
    pktTemp.InsertCString(Config.Account.Username)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CHECKDATAFILE2_Recv(pktRead As BNCSReader)
    Dim lStatus As UInt32 = pktRead.ReadUInt32
    Select Case lStatus
      Case 0
        'Rejected
      Case 1
        'Approved
      Case 2
        'Ladder Approved
    End Select
  End Sub

  Private Sub BNCS_CHECKDATAFILE2_Send(FilePath As String)
    If My.Computer.FileSystem.FileExists(FilePath) Then
      Dim pktTemp As New BNCSPacket(BNCS_CHECKDATAFILE2)
      Dim bFile() As Byte = My.Computer.FileSystem.ReadAllBytes(FilePath)
      pktTemp.InsertUInt32(bFile.Length)
      Dim SHA As New SHA1Managed
      SHA.Initialize()
      pktTemp.InsertByteArray(SHA.ComputeHash(bFile))
      pktTemp.InsertCString(FilePath.Substring(InStrRev(FilePath, "\") + 1))
      BNCS_Send(pktTemp)
    End If
  End Sub

  Private Sub BNCS_CREATEACCOUNT2_Recv(pktRead As BNCSReader)
    Dim lRet As UInt32 = pktRead.ReadUInt32
    Dim sSuggest As String = pktRead.ReadCString
    Select Case lRet
      Case 0
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_CREATED)
        BNCS_LOGONRESPONSE2_Send()
      Case 2
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_INVALID & IIf(Not String.IsNullOrEmpty(sSuggest), ResString(My.Resources.CREATE_SUGGEST, sSuggest), String.Empty))
        BNCS_Disconnect(True)
      Case 3
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_BANNED & IIf(Not String.IsNullOrEmpty(sSuggest), ResString(My.Resources.CREATE_SUGGEST, sSuggest), String.Empty))
        BNCS_Disconnect(True)
      Case 4
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_EXISTS & IIf(Not String.IsNullOrEmpty(sSuggest), ResString(My.Resources.CREATE_SUGGEST, sSuggest), String.Empty))
        BNCS_Disconnect(True)
      Case 6
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_MORECHARS & IIf(Not String.IsNullOrEmpty(sSuggest), ResString(My.Resources.CREATE_SUGGEST, sSuggest), String.Empty))
        BNCS_Disconnect(True)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.CREATE_FAIL, Hex(lRet)) & IIf(Not String.IsNullOrEmpty(sSuggest), ResString(My.Resources.CREATE_SUGGEST, sSuggest), String.Empty))
        BNCS_Disconnect(True)
    End Select
  End Sub

  Private Sub BNCS_CREATEACCOUNT2_Send()
    Dim pktTemp As New BNCSPacket(BNCS_CREATEACCOUNT2)
    pktTemp.InsertByteArray(XSHA.HashPassword(Config.Account.Password))
    pktTemp.InsertCString(Config.Account.Username)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_LOGONREALMEX_Recv(pktRead As BNCSReader)
    If BNetData.ClientToken = pktRead.ReadUInt32 Then
      MCP.Status = pktRead.ReadUInt32
      If pktRead.Length > 8 Then
        MCP.BNCSIP = pktRead.ReadUInt32
        MCP.UDPToken = pktRead.ReadUInt32
        MCP.MCPIP = New IPAddress(pktRead.ReadUInt32)
        MCP.MCPPort = IPAddress.NetworkToHostOrder(pktRead.ReadInt32) >> &H10
        MCP.NullVal = pktRead.ReadUInt16
        MCP.KeyProd = pktRead.ReadUInt16
        MCP.KeyPub = pktRead.ReadUInt32
        MCP.GatewayID = pktRead.ReadUInt32
        MCP.ProductID = pktRead.ReadUInt32
        MCP.PlatformID = pktRead.ReadUInt32
        MCP.BNCSIP2 = pktRead.ReadUInt32
        MCP.Locale = pktRead.ReadUInt32
        MCP.MCPHash1 = pktRead.ReadUInt32
        MCP.MCPHash2 = pktRead.ReadUInt32
        MCP.MCPHash3 = pktRead.ReadUInt32
        MCP.MCPHash4 = pktRead.ReadUInt32
        MCP.MCPHash5 = pktRead.ReadUInt32
        BNetData.UniqueName = pktRead.ReadCString
        lblRealmAccount.Text = BNetData.UniqueName
        DisplayRealmWaitMessage(My.Resources.REALM_STATUS_CONNECTING)
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_MCP, My.Resources.INFO_CONNECTING)
        If sckMCP.IsConnected Then MCP_Disconnect(False)
        If Config.Proxy.Use Then
          sckMCP.UseProxy = True
          If Config.Proxy.Port = 0 Then Config.Proxy.Port = 1080
          sckMCP.RemoteEndPoint = New Net.DnsEndPoint(Config.Proxy.IP, Config.Proxy.Port)
          sckMCP.Proxy.Ver = Config.Proxy.Ver
          sckMCP.Proxy.User = Config.Proxy.User
          sckMCP.Proxy.Pass = Config.Proxy.Pass
          If MCP.MCPIP IsNot Nothing Then
            sckMCP.Proxy.Dest = New Net.DnsEndPoint(MCP.MCPIP.ToString, MCP.MCPPort)
            sckMCP.Connect()
          End If
        Else
          sckMCP.UseProxy = False
          sckMCP.RemoteEndPoint = New Net.DnsEndPoint(MCP.MCPIP.ToString, MCP.MCPPort)
          sckMCP.Connect()
        End If
      Else
        Select Case MCP.Status
          Case 2147483649
            DisplayRealmErrMessage(My.Resources.REALM_UNAVAILABLE)
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, My.Resources.REALM_UNAVAILABLE)
          Case 2147483650
            DisplayRealmErrMessage(My.Resources.REALM_FAIL)
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, My.Resources.REALM_FAIL)
          Case Else
            DisplayRealmErrMessage(ResString(My.Resources.REALM_UNKNOWN, Hex(MCP.Status)))
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, ResString(My.Resources.REALM_UNKNOWN, Hex(MCP.Status)))
        End Select
      End If
    Else
      DisplayRealmErrMessage(My.Resources.REAM_WRONGCLIENT)
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, My.Resources.REAM_WRONGCLIENT)
      MCP_Disconnect()
      MCP = Nothing
    End If
  End Sub

  Public Sub BNCS_LOGONREALMEX_Send(RealmName As String, Optional RealmPassword As String = "password")
    DisplayRealmWaitMessage(My.Resources.REALM_STATUS_CONNECTING)
    Realms.Status = D2Realm.RealmState.ConnectingToRealm
    Dim pktTemp As New BNCSPacket(BNCS_LOGONREALMEX)
    pktTemp.InsertUInt32(BNetData.ClientToken)
    pktTemp.InsertByteArray(XSHA.DoubleHashPassword(RealmPassword, BNetData.ClientToken, BNetData.ServerToken))
    pktTemp.InsertCString(RealmName)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_STARTVERSIONING2_Recv(pktRead As BNCSReader)
    CRev.MPQTime = pktRead.ReadUInt64
    CRev.MPQName = pktRead.ReadCString
    CRev.Request = pktRead.ReadNullTerminatedByteArray
    BNCS_REPORTVERSION_Send()
  End Sub

  Private Sub BNCS_QUERYREALMS2_Recv(pktRead As BNCSReader)
    Dim Unknown As UInt32 = pktRead.ReadUInt32
    Dim RealmCount As UInt32 = pktRead.ReadUInt32
    Realms.RealmListing.ClearRealms()
    For I As UInt32 = 0 To RealmCount - 1
      If pktRead.ReadUInt32 = &H1 Then
        Realms.RealmListing.AddRealm(pktRead.ReadCString, pktRead.ReadCString)
      Else
        Realms.RealmListing.AddRealm(pktRead.ReadCString, pktRead.ReadCString)
      End If
    Next I
    DisplayRealmListing(True)
  End Sub

  Private Sub BNCS_QUERYREALMS2_Send()
    Dim pktTemp As New BNCSPacket(BNCS_QUERYREALMS2)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_QUERYADURL_Recv(pktRead As BNCSReader)
    Dim ID As UInt32 = pktRead.ReadUInt32
    Dim URL As String = pktRead.ReadCString
  End Sub

  Private Sub BNCS_QUERYADURL_Send(ID As UInt32)
    Dim pktTemp As New BNCSPacket(BNCS_QUERYADURL)
    pktTemp.InsertUInt32(ID)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_WARCRAFTUNKNOWN_Recv(pktRead As BNCSReader)
    Dim Unknown As UInt32 = pktRead.ReadUInt32
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, String.Empty, My.Resources.PROTOCOL_BNCS & "Warcraft Unknown Packet: " & Unknown.ToString.Trim)
    Debug.Print(pktRead.ToString)
  End Sub

  Private Sub BNCS_WARCRAFTGENERAL_Recv(pktRead As BNCSReader)
    Dim pktTmp As New BNCSReader(pktRead.GetAllBytes)
    Dim CommandID As Byte = pktRead.ReadByte
    Select Case CommandID
      Case WID_USERRECORD, WID_CLANRECORD
        Dim Cookie As UInt32 = pktRead.ReadUInt32
        Dim sUsernames() As String = Nothing
        Dim prType As ProfileRequests.ProfileRequestType
        Dim prDisp As ProfileRequests.ProfileRequestDisplay
        Dim prUpdate As frmProfile.UpdateTypes
        Dim prWhisperTo As String = String.Empty
        ProfileRequestList.GetRequest(Cookie, sUsernames, prType, prDisp, prUpdate, prWhisperTo)
        Dim sWhis As String = "/w " & IIf(Config.Account.Client.Product = GameType.D2DV Or Config.Account.Client.Product = GameType.D2XP, "*", String.Empty) & prWhisperTo & " "
        Select Case prDisp
          Case ProfileRequests.ProfileRequestDisplay.PrivateText

          Case ProfileRequests.ProfileRequestDisplay.PrivateUI
            ProfileWindow.UpdateW3Tab(sUsernames(0), prUpdate, pktTmp)
          Case ProfileRequests.ProfileRequestDisplay.PublicChat

          Case ProfileRequests.ProfileRequestDisplay.PublicWhisper

        End Select
      Case WID_ICONLIST
        Dim Cookie As UInt32 = pktRead.ReadUInt32
        Dim Unknown As UInt32 = pktRead.ReadUInt32
        Dim Tiers As Byte = pktRead.ReadByte
        Dim Count As Byte = pktRead.ReadByte
        ReDim W3Icons(Count - 1)
        For I As Byte = 0 To Count - 1
          W3Icons(I).Icon = pktRead.ReadDWORDString()
          W3Icons(I).Name = pktRead.ReadDWORDString()
          W3Icons(I).Race = pktRead.ReadByte
          W3Icons(I).Wins = pktRead.ReadInt16
          W3Icons(I).Enabled = pktRead.ReadByte
        Next I
    End Select
  End Sub

  Public Sub BNCS_WARCRAFTGENERAL_Send(ID As UInt32, ParamArray Data() As Object)
    Dim pktTemp As New BNCSPacket(BNCS_WARCRAFTGENERAL)
    pktTemp.InsertByte(ID)
    Select Case ID
      Case WID_LADDERMAP
        pktTemp.InsertUInt32(Data(0))
        pktTemp.InsertByte(Data(1))
        For I As Integer = 2 To Data.Length - 1
          pktTemp.InsertUInt32(Data(I))
        Next I
      Case WID_CANCEL
        'Blank
      Case WID_USERRECORD
        pktTemp.InsertUInt32(Data(0))
        pktTemp.InsertCString(Data(1))
        pktTemp.InsertUInt32(Data(2))
      Case WID_CLANRECORD
        pktTemp.InsertUInt32(Data(0))
        pktTemp.InsertDwordString(Data(1))
        pktTemp.InsertUInt32(Data(2))
      Case WID_ICONLIST
        pktTemp.InsertUInt32(Data(0))
      Case WID_SETICON
        pktTemp.InsertUInt32(Data(0))
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.WARCRAFTGENERAL_UNKNOWN, Hex(ID)))
        Exit Sub
    End Select
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_NETGAMEPORT_Send()
    Dim pktTemp As New BNCSPacket(BNCS_NETGAMEPORT)
    Dim cReg As RegistryKey
    cReg = Registry.CurrentUser.OpenSubKey("Software\Blizzard Entertainment\Warcraft III\Gameplay")
    If cReg Is Nothing Then
      pktTemp.InsertUInt16(6112)
    Else
      pktTemp.InsertUInt16(cReg.GetValue("netgameport", 6112))
    End If
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_NEWS_INFO_Recv(pktRead As BNCSReader)
    Dim Entries As Byte = pktRead.ReadByte
    Dim LastLogon As UInt64 = pktRead.ReadInt64
    Dim OldestNews As UInt64 = pktRead.ReadInt64
    Dim NewestNews As UInt64 = pktRead.ReadInt64
    For I As Byte = 0 To Entries - 1
      Dim TimeStamp As UInt64 = pktRead.ReadUInt64
      Dim News As String = pktRead.ReadCString
      If TimeStamp = 0 Then
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_NEWS, "[MotD] " & News)
      Else
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_NEWS, "[" & DateAdd(DateInterval.Second, TimeStamp, DateSerial(1970, 1, 1)) & "] " & News)
      End If
    Next I
  End Sub

  Private Sub BNCS_NEWS_INFO_Send(Optional TimeStamp As UInt32 = 0)
    Dim pktTemp As New BNCSPacket(BNCS_NEWS_INFO)
    pktTemp.InsertUInt32(TimeStamp)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_OPTIONALWORK_Recv(pktRead As BNCSReader)
    Dim WorkName As String = pktRead.ReadCString
    Dim cReg As RegistryKey
    cReg = Registry.CurrentUser.OpenSubKey("Software\Battle.net\Optimize")
    If cReg IsNot Nothing Then If cReg.GetValue("SysDesc", 0) = 1 Then BNCS_GETFILETIME_Send(&H80000005, 0, WorkName)
  End Sub

  Private Sub BNCS_EXTRAWORK_Send(GameType As UInt16, Length As UInt16, Data As String)
    Dim pktTemp As New BNCSPacket(BNCS_EXTRAWORK)
    pktTemp.InsertUInt16(GameType)
    pktTemp.InsertUInt16(Length)
    pktTemp.InsertCString(Data)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_REQUIREDWORK_Recv(pktRead As BNCSReader)
    Dim WorkName As String = pktRead.ReadCString
    BNCS_GETFILETIME_Send(&H80000006, 0, WorkName)
  End Sub

  Private Sub BNCS_ADDLEAGUE_Recv(pktRead As BNCSReader)
    Dim Flags As Byte = pktRead.ReadByte
    Dim Unknown1 As Byte = pktRead.ReadByte
    Dim LeagueName As String = pktRead.ReadCString
    Dim Penalty As String = pktRead.ReadCString
    Dim LeagueURL As String = pktRead.ReadCString
    Dim LeagueTag As String = pktRead.ReadCString
    Dim Unknown2 As Byte = pktRead.ReadUInt32
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_LEAGUE, LeagueName, LeagueTag, LeagueURL))
    Dim GameType As Byte = pktRead.ReadByte
    Dim LeagueID As Byte = pktRead.ReadByte
    Dim Penalty1 As UInt16 = pktRead.ReadUInt16
    Dim Penalty2 As UInt32 = pktRead.ReadUInt32
    Dim GameClass As Byte = pktRead.ReadByte
    Dim Unknown3 As Byte = pktRead.ReadByte
    Dim Unknown4 As Byte = pktRead.ReadByte
    Dim Unknown5 As Byte = pktRead.ReadByte
    Dim Unknown6 As Byte = pktRead.ReadByte
    Dim Unknown7 As Byte = pktRead.ReadByte
    Dim Unknown8 As Byte = pktRead.ReadByte
    Dim Teams As Byte = pktRead.ReadByte
    Dim Unknown9 As Byte = pktRead.ReadByte
    Dim Requirements As Byte = pktRead.ReadByte
    Dim Resources As UInt32 = pktRead.ReadUInt32
    Dim EndResult As UInt32 = pktRead.ReadUInt32
    'AddChat(rtbChat, Color.Aqua, "League Data: " & pktRead.ToString)
  End Sub

  Private Sub BNCS_AUTH_INFO_Send()
    Dim pktTemp As New BNCSPacket(BNCS_AUTH_INFO)
    pktTemp.InsertUInt32(&H0)
    pktTemp.InsertUInt32(GameArch.IX86)
    If Config.Account.Client.Product = GameType.WAR3 And Config.Account.Client.EXPKey.ProductVal <> 0 Then
      pktTemp.InsertUInt32(GameType.W3XP)
    Else
      pktTemp.InsertUInt32(Config.Account.Client.Product)
    End If
    pktTemp.InsertUInt32(Config.VerByte)
    pktTemp.InsertDwordString(CultureInfo.CurrentCulture.TwoLetterISOLanguageName & RegionInfo.CurrentRegion.TwoLetterISORegionName)
    Dim uIP As UInt32 = 0
    For Each IP In (From ipItem In Dns.GetHostEntry(System.Net.Dns.GetHostName).AddressList Where ipItem.AddressFamily = AddressFamily.InterNetwork)
      uIP = BitConverter.ToUInt32(IP.GetAddressBytes, 0)
      Exit For
    Next
    pktTemp.InsertUInt32(uIP)
    pktTemp.InsertUInt32((DateTime.UtcNow - DateTime.Now).TotalMinutes)
    pktTemp.InsertInt32(CultureInfo.CurrentCulture.LCID)
    pktTemp.InsertInt32(CultureInfo.CurrentCulture.KeyboardLayoutId)
    pktTemp.InsertCString(RegionInfo.CurrentRegion.ThreeLetterWindowsRegionName)
    pktTemp.InsertCString(RegionInfo.CurrentRegion.EnglishName)
    BNCS_Send(pktTemp)
    If Config.PingSpoof = 1 Then
      BNCS_PING_Send(0)
    ElseIf Config.PingSpoof = 2 Then
      For I As Integer = 1 To 500
        If Not IsOnline Then Exit For
        BNCS_NULL_Send()
      Next
      BNCS_PING_Send(0)
    End If
    ChatData.PingFirst = Not Config.PingSpoof = 3
    ChatData.PingSpoofing = Environment.TickCount
  End Sub

  Private Sub BNCS_AUTH_INFO_Recv(pktRead As BNCSReader)
    Dim LS As UInt32 = pktRead.ReadUInt32
    Select Case LS
      Case 0
        BNetData.UseNLS = False
      Case 1
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.NLS_1)
        BNCS_Disconnect(True)
        Exit Sub
      Case 2
        BNetData.UseNLS = True
        R_NLS = New clsNLS(Config.Account.Username, Config.Account.Password)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.NLS_UNKNOWN, Hex(LS)))
        BNCS_Disconnect(True)
        Exit Sub
    End Select
    BNetData.ServerToken = pktRead.ReadUInt32
    BNetData.UDPToken = pktRead.ReadUInt32
    CRev.MPQTime = pktRead.ReadUInt64
    CRev.MPQName = pktRead.ReadCString
    CRev.Request = pktRead.ReadNullTerminatedByteArray
    If Config.Account.Client.Product = GameType.WAR3 Or Config.Account.Client.Product = GameType.W3XP Then
      Dim ServerSignature() As Byte = pktRead.ReadByteArray(128)
      If Not R_NLS.ValidateServerSignature(ServerSignature, New Net.IPEndPoint(BNetData.ServerIP, 6112)) Then
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_SERVERSIGNATURE)
        'BNCS_Disconnect(True)
        'Exit Sub
      End If
    End If
    If sckUDP.IsConnected Then PKT_CONNTEST2_Send()
    BNCS_AUTH_CHECK_Send()
  End Sub

  Private Sub BNCS_AUTH_CHECK_Send()
    Dim pktTemp As New BNCSPacket(BNCS_AUTH_CHECK)
    If BNetData.ClientToken = 0 Then BNetData.ClientToken = Environment.TickCount
    If BNetData.ServerToken = 0 Then
      BNCS_Disconnect(True)
      AttemptReconnect(My.Resources.ERR_SERVERTOKEN)
      Exit Sub
    End If
    Dim MPQPath As String
    Dim DLLPath As String
    Dim KeyCount As UInt32
    Dim HashFiles(2) As String
    Dim BINFile As String = String.Empty
    Dim EXEVer As Int32
    Dim EXEHash As Int32
    Dim EXEInfo() As Byte = Nothing
    Select Case Config.Account.Client.Product
      Case GameType.D2XP, GameType.W3XP
        KeyCount = 2
      Case GameType.STAR, GameType.W2BN, GameType.SEXP, GameType.D2DV, GameType.WAR3, GameType.JSTR
        KeyCount = 1
      Case Else
        KeyCount = 0
    End Select
    If Config.Account.Client.Product = GameType.WAR3 And Config.Account.Client.EXPKey.ProductVal <> 0 Then KeyCount = 2
    GetHashFiles(HashFiles, BINFile)
    pktTemp.InsertUInt32(BNetData.ClientToken)
    If CRev.MPQName.ToLower.Contains("ix86") Then
      If CRev.MPQName.ToLower.Contains("ver") Then
        Dim sRequest = Encoding.GetEncoding(LATIN_1).GetString(CRev.Request)
        Dim EXEInfoS As String = String.Empty
        EXEVer = CheckRevision.GetExeInfo(HashFiles(0), EXEInfoS)
        EXEHash = CheckRevision.DoCheckRevision(sRequest, HashFiles, CheckRevision.ExtractMPQNumber(CRev.MPQName))
        EXEInfo = Encoding.GetEncoding(LATIN_1).GetBytes(EXEInfoS)
      ElseIf CRev.MPQName.ToLower.Contains("lockdown") Then
        MPQPath = AppTemp & "\MPQs\" & CRev.MPQName
        DLLPath = AppStore & "\CheckRevision Libraries\" & CRev.MPQName.Substring(0, InStr(CRev.MPQName, ".")) & "dll"
        If Not My.Computer.FileSystem.DirectoryExists(AppStore & "\CheckRevision Libraries") Then My.Computer.FileSystem.CreateDirectory(AppStore & "\CheckRevision Libraries")
        If Not My.Computer.FileSystem.FileExists(DLLPath) Then
          gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_DOWNLOADING, CRev.MPQName))
          If BNFTPRequest(GameArch.IX86, Config.Account.Client.Product, MPQPath, Nothing) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_FTP, ResString(My.Resources.INFO_FTP_OK, CRev.MPQName))
          Else
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_FTP, ResString(My.Resources.ERR_FTP_FAIL, CRev.MPQName))
            BNCS_Disconnect(True)
            Exit Sub
          End If
          Using Archive As New MPQ(MPQPath)
            Dim sFile As String = Archive.GetListFile
            If String.IsNullOrEmpty(sFile) Then
              gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_MPQ_NOLIST, CRev.MPQName))
              BNCS_Disconnect(True)
              Exit Sub
            End If
            If InStr(sFile, vbCr) Then sFile = Split(sFile, vbCr)(0)
            sFile = sFile.Trim(" ", vbCr, vbLf, vbNullChar)
            Dim SaveRet As MPQ.MPQSaveError = Archive.SaveToPath(sFile, IO.Path.GetDirectoryName(DLLPath))
            Select Case SaveRet
              Case MPQ.MPQSaveError.Success
                'OK
              Case MPQ.MPQSaveError.FileNotFound
                gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_MPQ_NOTFOUND, sFile, CRev.MPQName))
                BNCS_Disconnect(True)
                Exit Sub
              Case MPQ.MPQSaveError.MPQCorrupt
                gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_MPQ_CORRUPT, sFile, CRev.MPQName))
                BNCS_Disconnect(True)
                Exit Sub
              Case MPQ.MPQSaveError.NoMPQ
                gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_MPQ_NO, CRev.MPQName))
                BNCS_Disconnect(True)
                Exit Sub
              Case MPQ.MPQSaveError.UnknownFailure
                gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_MPQ_FAIL, sFile, CRev.MPQName))
                BNCS_Disconnect(True)
                Exit Sub
            End Select
          End Using
        End If
        EXEInfo = Lockdown.CheckRevision(CRev.Request, HashFiles, DLLPath, BINFile, EXEVer, EXEHash)
      Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_UNKNOWN, CRev.MPQName))
        BNCS_Disconnect(True)
        Exit Sub
      End If
    ElseIf CRev.MPQName.ToLower.Contains("pmac") Then
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_AUTH_CRAV_PMAC)
      BNCS_Disconnect(True)
      Exit Sub
    ElseIf CRev.MPQName.ToLower.Contains("xmac") Then
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_AUTH_CREV_XMAC)
      BNCS_Disconnect(True)
      Exit Sub
    Else
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_CREV_UNKNOWN, CRev.MPQName))
      BNCS_Disconnect(True)
      Exit Sub
    End If
    If EXEHash = -1 Or EXEVer = -1 Then
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_AUTH_CREV_FAIL)
      BNCS_Disconnect(True)
      Exit Sub
    End If
    pktTemp.InsertInt32(EXEVer)
    pktTemp.InsertInt32(EXEHash)
    pktTemp.InsertUInt32(KeyCount)
    pktTemp.InsertBoolean(Config.Account.Client.Spawn)
    If KeyCount > 0 Then
      Dim CD_Key As New clsKey(Config.Account.Client.CDKey)
      If CD_Key.IsValid And ProdMatch(Config.Account.Client.Product, CD_Key.Product, False) Then
        pktTemp.InsertInt32(CDLegal(CD_Key.Key).Length)
        pktTemp.InsertInt32(CD_Key.Product)
        pktTemp.InsertInt32(CD_Key.PublicVal)
        pktTemp.InsertUInt32(0)
        Dim KeyHash() As Byte = CD_Key.GetHash(BNetData.ClientToken, BNetData.ServerToken)
        'If Config.Account.Client.Product = GameType.STAR Or Config.Account.Client.Product = GameType.SEXP Then cWarden.Initialize(KeyHash, AppStore & "\Warden\")
        pktTemp.InsertByteArray(KeyHash)
      Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_INVALID)
        BNCS_Disconnect(True)
        Exit Sub
      End If
      If KeyCount = 2 Then
        Dim EXP_Key As New clsKey(Config.Account.Client.EXPKey)
        If EXP_Key.IsValid And ProdMatch(IIf(Config.Account.Client.Product = GameType.WAR3 And Config.Account.Client.EXPKey.ProductVal <> 0, GameType.W3XP, Config.Account.Client.Product), EXP_Key.Product, True) Then
          pktTemp.InsertInt32(CDLegal(EXP_Key.Key).Length)
          pktTemp.InsertInt32(EXP_Key.Product)
          pktTemp.InsertInt32(EXP_Key.PublicVal)
          pktTemp.InsertUInt32(0)
          pktTemp.InsertByteArray(EXP_Key.GetHash(BNetData.ClientToken, BNetData.ServerToken))
        Else
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.EXPKEY_INVALID)
          BNCS_Disconnect(True)
          Exit Sub
        End If
      End If
    End If
    pktTemp.InsertByteArray(EXEInfo)
    pktTemp.InsertByte(0)
    pktTemp.InsertCString(Config.Account.Username)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_AUTH_CHECK_Recv(pktRead As BNCSReader)
    Dim Ret As UInt32 = pktRead.ReadUInt32
    Select Case Ret
      Case &H0
        If BNetData.UseNLS Then
          If Config.Account.Client.Product = GameType.WAR3 And Config.Account.Client.EXPKey.ProductVal <> 0 Then BNCS_SWITCHPRODUCT_Send()
          BNCS_AUTH_ACCOUNTLOGON_Send()
        Else
          BNCS_LOGONRESPONSE2_Send()
        End If
      Case &H100
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.VERSION_UPGRADE)
        UpdateHashFiles()
      Case &H101
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.VERSION_FAIL)
        UpdateHashFiles()
      Case &H102
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.VERSION_DOWNGRADE)
        UpdateHashFiles()
      Case &H200
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_INVALID)
        BNCS_Disconnect(True)
      Case &H201
        Dim sCDOwner As String = pktRead.ReadCString
        If String.IsNullOrEmpty(sCDOwner) Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_INUSE)
        ElseIf sCDOwner = "TOO MANY SPAWNS" Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_TOOMANYSPAWNS)
        ElseIf sCDOwner = "NO SPAWNING" Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_NOSPAWNING)
        ElseIf StrComp(sCDOwner, Config.Account.Username, CompareMethod.Text) = 0 Then
          AttemptReconnect(My.Resources.CDKEY_INUSEBYSELF, 150)
        Else
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.CDKEY_INUSEBY, sCDOwner))
        End If
        BNCS_Disconnect(True)
      Case &H202
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_BANNED)
        BNCS_Disconnect(True)
      Case &H203
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CDKEY_WRONGPRODUCT)
        BNCS_Disconnect(True)
      Case &H210
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.EXPKEY_INVALID)
        BNCS_Disconnect(True)
      Case &H211
        Dim sEXPOwner As String = pktRead.ReadCString
        If String.IsNullOrEmpty(sEXPOwner) Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.EXPKEY_INUSE)
        ElseIf sEXPOwner = "TOO MANY SPAWNS" Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.EXPKEY_TOOMANYSPAWNS)
        ElseIf sEXPOwner = "NO SPAWNING" Then
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.EXPKEY_NOSPAWNING)
        ElseIf StrComp(sEXPOwner, Config.Account.Username, CompareMethod.Text) = 0 Then
          AttemptReconnect(My.Resources.EXPKEY_INUSEBYSELF, 150)
        Else
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.EXPKEY_INUSEBY, sEXPOwner))
        End If
        BNCS_Disconnect(True)
      Case &H212
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.EXPKEY_BANNED)
        BNCS_Disconnect(True)
      Case &H213
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.EXPKEY_WRONGPRODUCT)
        BNCS_Disconnect(True)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_AUTH_UNKNOWN, Hex(Ret)))
        BNCS_Disconnect(True)
    End Select
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTCREATE_Recv(pktRead As BNCSReader)
    Dim Status As UInt32 = pktRead.ReadUInt32
    Select Case Status
      Case &H0
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_CREATED)
        BNCS_AUTH_ACCOUNTLOGON_Send()
      Case &H4
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_EXISTS)
        BNCS_Disconnect(True)
      Case &H7
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_SHORT)
        BNCS_Disconnect(True)
      Case &H8
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_ILLEGAL)
        BNCS_Disconnect(True)
      Case &H9
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_BANNED)
        BNCS_Disconnect(True)
      Case &HA
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_MORECHARS)
        BNCS_Disconnect(True)
      Case &HB
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_ADJACENTPUNCTUATION)
        BNCS_Disconnect(True)
      Case &HC
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_TOOMUCHPUNCTUATION)
        BNCS_Disconnect(True)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.CREATE_EXISTS)
        BNCS_Disconnect(True)
    End Select
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTCREATE_Send()
    Dim pktTemp As New BNCSPacket(BNCS_AUTH_ACCOUNTCREATE)
    pktTemp.InsertByteArray(R_NLS.Salt)
    pktTemp.InsertByteArray(R_NLS.Verifier)
    pktTemp.InsertCString(Config.Account.Username.ToUpper)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTLOGON_Recv(pktRead As BNCSReader)
    Dim Status As UInt32 = pktRead.ReadUInt32
    Select Case Status
      Case &H0
        BNCS_AUTH_ACCOUNTLOGONPROOF_Send(pktRead.ReadByteArray(32), pktRead.ReadByteArray(32))
      Case &H1
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_BADACCOUNT)
        BNCS_AUTH_ACCOUNTCREATE_Send()
      Case &H5
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.LOGON_UPGRADE)
        BNCS_AUTH_ACCOUNTUPGRADE_Send()
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.LOGON_FAIL, Hex(Status)))
        BNCS_Disconnect(True)
    End Select
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTLOGON_Send()
    If Config.Account.Change.PassReset Then
      BNCS_RESETPASSWORD_Send()
      Exit Sub
    End If
    If Not String.IsNullOrEmpty(Config.Account.Change.Password) Then
      BNCS_AUTH_ACCOUNTCHANGE_Send()
      Exit Sub
    End If
    If Not String.IsNullOrEmpty(Config.Account.Change.EMail) Then BNCS_CHANGEEMAIL_Send()
    If BNetData.ClientToken = 0 Then BNetData.ClientToken = Environment.TickCount
    If BNetData.ServerToken = 0 Then
      BNCS_Disconnect(True)
      AttemptReconnect(My.Resources.ERR_SERVERTOKEN)
      Exit Sub
    End If
    Using pktTemp As New BNCSPacket(BNCS_AUTH_ACCOUNTLOGON)
      pktTemp.InsertByteArray(R_NLS.A)
      pktTemp.InsertCString(Config.Account.Username)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTLOGONPROOF_Recv(pktRead As BNCSReader)
    Dim Status As UInt32 = pktRead.ReadUInt32
    Dim M2() As Byte = pktRead.ReadByteArray(20)
    Dim Info As String = pktRead.ReadCString
    Select Case Status
      Case &H0
        If R_NLS.VerifyServerProof(M2) Then
          GetUserData(Config.Account.Username, ProfileRequests.ProfileRequestType.AccountInfo, ProfileRequests.ProfileRequestDisplay.PrivateUI)
          BNCS_GETICONDATA_Send()
          BNCS_NETGAMEPORT_Send()
        Else
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.LOGON_SERVERPROOF)
          BNCS_Disconnect(True)
        End If
      Case &H2
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_BADPASS)
        BNCS_AUTH_ACCOUNTCREATE_Send()
      Case &HE
        If R_NLS.VerifyServerProof(M2) Then
          If String.IsNullOrEmpty(Config.Account.EMail) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, My.Resources.LOGON_EMAIL)
          Else
            BNCS_SETEMAIL_Send()
          End If
          BNCS_ENTERCHAT_Send()
          BNCS_GETCHANNELLIST_Send()
          BNCS_JOINCHANNEL_Send(Config.Account.HomeChannel)
          SetAds(True)
          BNCS_CHECKAD_Send()
        Else
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.LOGON_SERVERPROOF)
          BNCS_Disconnect(True)
        End If
      Case &HF
        gChat.AddChat(GeckoChat.ChatType.ServiceError, String.Empty, Info)
        BNCS_Disconnect(True)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.LOGON_FAIL, Hex(Status)))
        BNCS_Disconnect(True)
    End Select
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTLOGONPROOF_Send(Salt() As Byte, Key() As Byte)
    Dim pktTemp As New BNCSPacket(BNCS_AUTH_ACCOUNTLOGONPROOF)
    R_NLS.Salt = Salt
    R_NLS.B = Key
    pktTemp.InsertByteArray(R_NLS.M1)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTCHANGE_Recv(pktRead As BNCSReader)
    Dim Status As UInt32 = pktRead.ReadUInt32
    Select Case Status
      Case &H0
        BNCS_AUTH_ACCOUNTCHANGEPROOF_Send(pktRead.ReadByteArray(32), pktRead.ReadByteArray(32))
      Case &H1
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_BADACCOUNT)
        BNCS_AUTH_ACCOUNTCREATE_Send()
      Case &H5
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.LOGON_UPGRADE)
        BNCS_AUTH_ACCOUNTUPGRADE_Send()
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.PASSWORD_CHANGE_FAIL)
        BNCS_AUTH_ACCOUNTLOGON_Send()
    End Select
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTCHANGE_Send()
    Using pktTemp As New BNCSPacket(BNCS_AUTH_ACCOUNTCHANGE)
      pktTemp.InsertByteArray(R_NLS.A)
      pktTemp.InsertCString(Config.Account.Username)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTCHANGEPROOF_Recv(pktRead As BNCSReader)
    Dim Status As UInt32 = pktRead.ReadUInt32
    Dim M2() As Byte = pktRead.ReadByteArray(20)
    Select Case Status
      Case &H0
        If R_NLS.VerifyServerProof(M2) Then
          R_NLS = R_new_NLS
          R_new_NLS = Nothing
          Config.Account.Password = Config.Account.Change.Password
          Config.Account.Change.Password = Nothing
          SaveSettings(Index, Config)
          BNCS_AUTH_ACCOUNTLOGON_Send()
        End If
      Case &H2
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_BADPASS)
        BNCS_Disconnect(True)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.PASSWORD_CHANGE_FAIL)
        BNCS_AUTH_ACCOUNTLOGON_Send()
    End Select
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTCHANGEPROOF_Send(Salt() As Byte, Key() As Byte)
    Using pktTemp As New BNCSPacket(BNCS_AUTH_ACCOUNTCHANGEPROOF)
      R_NLS.Salt = Salt
      R_NLS.B = Key
      pktTemp.InsertByteArray(R_NLS.M1)
      R_new_NLS = New clsNLS(Config.Account.Username, Config.Account.Change.Password)
      pktTemp.InsertByteArray(R_new_NLS.Salt)
      pktTemp.InsertByteArray(R_new_NLS.Verifier)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTUPGRADE_Recv(pktRead As BNCSReader)
    Dim Status As UInt32 = pktRead.ReadUInt32
    BNetData.ServerToken = pktRead.ReadUInt32
    If Status = &H0 Then
      BNCS_AUTH_ACCOUNTUPGRADEPROOF_Send()
    Else
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.UPGRADE_DENIED)
      BNCS_Disconnect(True)
    End If
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTUPGRADE_Send()
    Using pktTemp As New BNCSPacket(BNCS_AUTH_ACCOUNTUPGRADE)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTUPGRADEPROOF_Recv(pktRead As BNCSReader)
    Dim Status As UInt32 = pktRead.ReadUInt32
    Dim M2() As Byte = pktRead.ReadByteArray(20)
    Select Case Status
      Case &H0
        If R_new_NLS.VerifyServerProof(M2) Then
          R_NLS = R_new_NLS
          R_new_NLS = Nothing
          BNCS_AUTH_ACCOUNTLOGON_Send()
        End If
      Case &H2
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.ERR_BADPASS)
        BNCS_Disconnect(True)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.UPGRADE_FAILED, Hex(Status)))
        BNCS_Disconnect(True)
    End Select
  End Sub

  Private Sub BNCS_AUTH_ACCOUNTUPGRADEPROOF_Send()
    Using pktTemp As New BNCSPacket(BNCS_AUTH_ACCOUNTUPGRADEPROOF)
      pktTemp.InsertUInt32(BNetData.ClientToken)
      pktTemp.InsertByteArray(XSHA.DoubleHashPassword(Config.Account.Password.ToLower, BNetData.ClientToken, BNetData.ServerToken))
      R_new_NLS = New clsNLS(Config.Account.Username, Config.Account.Password)
      pktTemp.InsertByteArray(R_new_NLS.A)
      pktTemp.InsertCString(Config.Account.Username)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_SETEMAIL_Recv(pktRead As BNCSReader)
    If String.IsNullOrEmpty(Config.Account.EMail) Then
      gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, My.Resources.LOGON_EMAIL)
    Else
      BNCS_SETEMAIL_Send()
    End If
  End Sub

  Private Sub BNCS_SETEMAIL_Send()
    If Not String.IsNullOrEmpty(Config.Account.EMail) Then
      Using pktTemp As New BNCSPacket(BNCS_SETEMAIL)
        pktTemp.InsertCString(Config.Account.EMail)
        BNCS_Send(pktTemp)
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, My.Resources.EMAIL_BOUND)
      End Using
    End If
  End Sub

  Private Sub BNCS_RESETPASSWORD_Send()
    Using pktTemp As New BNCSPacket(BNCS_RESETPASSWORD)
      Select Case Config.Account.Client.Product
        Case GameType.DRTL, GameType.DSHR, GameType.JSTR, GameType.W2BN
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.PASSWORD_RESET_PRODUCT)
        Case Else
          If String.IsNullOrEmpty(Config.Account.EMail) Then
            gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.PASSWORD_RESET_NOEMAIL)
          Else
            pktTemp.InsertCString(Config.Account.Username)
            pktTemp.InsertCString(Config.Account.EMail)
            BNCS_Send(pktTemp)
            Config.Account.Change.PassReset = False
            SaveSettings(Index, Config)
            BNCS_Disconnect()
          End If
      End Select
    End Using
  End Sub

  Private Sub BNCS_CHANGEEMAIL_Send()
    Using pktTemp As New BNCSPacket(BNCS_CHANGEEMAIL)
      Select Case Config.Account.Client.Product
        Case GameType.DRTL, GameType.DSHR, GameType.JSTR, GameType.W2BN
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, My.Resources.EMAIL_RESET_PRODUCT)
        Case Else
          pktTemp.InsertCString(Config.Account.Username)
          pktTemp.InsertCString(Config.Account.EMail)
          pktTemp.InsertCString(Config.Account.Change.EMail)
          BNCS_Send(pktTemp)
          Config.Account.EMail = Config.Account.Change.EMail
          Config.Account.Change.EMail = Nothing
          gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, My.Resources.EMAIL_RESET_SUCCESS)
          SaveSettings(Index, Config)
      End Select
    End Using
  End Sub

  Private Sub BNCS_SWITCHPRODUCT_Send()
    Using pktTemp As New BNCSPacket(BNCS_SWITCHPRODUCT)
      pktTemp.InsertDwordString("WAR3")
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_REPORTCRASH_Send(Version As UInt32, Exception As UInt32, Unknown1 As UInt32, Unknown2 As UInt32)
    Using pktTemp As New BNCSPacket(BNCS_REPORTCRASH)
      pktTemp.InsertUInt32(Version)
      pktTemp.InsertUInt32(Exception)
      pktTemp.InsertUInt32(Unknown1)
      pktTemp.InsertUInt32(Unknown2)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_WARDEN_Recv(pktRead As BNCSReader)
    Dim bEncrypted() As Byte = pktRead.ReadByteArray(pktRead.Length)
    cWarden.IncomingPacket(bEncrypted)
  End Sub

  Private Sub BNCS_WARDEN_Send(sender As Object, e As WardenEventArgs) Handles cWarden.BNCS_WARDEN_Send
    Using pktTemp As New BNCSPacket(BNCS_WARDEN)
      pktTemp.InsertByteArray(e.Data)
      BNCS_Send(pktTemp)
    End Using
  End Sub

  Private Sub BNCS_GAMEPLAYERSEARCH_Recv(pktRead As BNCSReader)
    Dim playerCount As Byte = pktRead.ReadByte
    Dim sPlayers(playerCount - 1) As String
    For I As Byte = 0 To playerCount - 1
      sPlayers(I) = pktRead.ReadCString
    Next
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_GAMEPLAYERSEARCH)
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, Join(sPlayers, ", "))
  End Sub

  Private Sub BNCS_GAMEPLAYERSEARCH_Send()
    Dim pktTemp As New BNCSPacket(BNCS_GAMEPLAYERSEARCH)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_FRIENDSLIST_Recv(pktRead As BNCSReader)
    Dim bFriends As Byte = pktRead.ReadByte
    FriendClear()
    If bFriends > 0 Then
      For I As Integer = 0 To bFriends - 1
        FriendAdd({I, pktRead.ReadCString, pktRead.ReadByte, pktRead.ReadByte, pktRead.ReadUInt32, pktRead.ReadCString})
      Next I
    End If
  End Sub

  Private Sub BNCS_FRIENDSLIST_Send()
    If Status > 2 Then
      Dim pktTemp As New BNCSPacket(BNCS_FRIENDSLIST)
      BNCS_Send(pktTemp)
    End If
  End Sub

  Private Sub BNCS_FRIENDSUPDATE_Recv(pktRead As BNCSReader)
    FriendAdd({pktRead.ReadByte, String.Empty, pktRead.ReadByte, pktRead.ReadByte, pktRead.ReadUInt32, pktRead.ReadCString})
  End Sub

  Private Sub BNCS_FRIENDSUPDATE_Send(Index As Byte)
    Dim pktTemp As New BNCSPacket(BNCS_FRIENDSLIST)
    pktTemp.InsertByte(Index)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_FRIENDSADD_Recv(pktRead As BNCSReader)
    FriendAdd({255, pktRead.ReadCString, pktRead.ReadByte, pktRead.ReadByte, pktRead.ReadUInt32, pktRead.ReadCString})
  End Sub

  Private Sub BNCS_FRIENDSREMOVE_Recv(pktRead As BNCSReader)
    FriendRemove(pktRead.ReadByte)
  End Sub

  Private Sub BNCS_FRIENDSPOSITION_Recv(pktRead As BNCSReader)
    BNCS_FRIENDSLIST_Send()
  End Sub

  Private Sub BNCS_CLANFINDCANDIDATES_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim Status As Byte = pktRead.ReadByte
    Dim Candidates As Byte = pktRead.ReadByte
    Dim sCandidates(Candidates - 1) As String
    Select Case Status
      Case &H0
        ClanInviteWindow.ClearMembers()
        For I As Integer = 0 To Candidates - 1
          ClanInviteWindow.AddMember(pktRead.ReadCString)
        Next
      Case &H1
        ClanInviteWindow.CloseWindow()
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_TAGINUSE)
      Case &H2
        ClanInviteWindow.CloseWindow()
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_CDKEY)
      Case &H8
        ClanInviteWindow.CloseWindow()
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_ALREADYIN)
      Case &HA
        ClanInviteWindow.CloseWindow()
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_TAGINVALID)
    End Select
  End Sub

  Public Sub BNCS_CLANFINDCANDIDATES_Send(Cookie As UInt32, ClanTag As String)
    Dim pktTemp As New BNCSPacket(BNCS_CLANFINDCANDIDATES)
    pktTemp.InsertUInt32(Cookie)
    pktTemp.InsertDwordString(ClanTag)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANINVITEMULTIPLE_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim Result As Byte = pktRead.ReadByte
    Do
      Dim tmpName As String = pktRead.ReadCString
      If String.IsNullOrEmpty(tmpName) Then Exit Do
    Loop
  End Sub

  Public Sub BNCS_CLANINVITEMULTIPLE_Send(Cookie As UInt32, ClanName As String, ClanTag As String, Invites() As String)
    Dim pktTemp As New BNCSPacket(BNCS_CLANINVITEMULTIPLE)
    pktTemp.InsertUInt32(Cookie)
    pktTemp.InsertCString(ClanName)
    pktTemp.InsertDwordString(ClanTag)
    pktTemp.InsertByte(Invites.Count)
    For I As Integer = 0 To Invites.Count - 1
      pktTemp.InsertCString(Invites(I))
    Next
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANCREATIONINVITIATION_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim ClanTag As String = pktRead.ReadDWORDString()
    Dim ClanName As String = pktRead.ReadCString
    Dim Inviter As String = pktRead.ReadCString
    Dim Invitees As Byte = pktRead.ReadByte
    Dim sInvitees(Invitees - 1) As String
    For I As Integer = 0 To Invitees - 1
      sInvitees(I) = pktRead.ReadCString
    Next
  End Sub

  Private Sub BNCS_CLANCREATIONINVITATION_Send(Cookie As UInt32, ClanTag As String, Inviter As String, Status As Byte)
    Dim pktTemp As New BNCSPacket(BNCS_CLANCREATIONINVITATION)
    pktTemp.InsertUInt32(Cookie)
    pktTemp.InsertDwordString(ClanTag)
    pktTemp.InsertCString(Inviter)
    pktTemp.InsertByte(Status)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANDISBAND_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim Result As Byte = pktRead.ReadByte
    Select Case Result
      Case 0
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_DISBANDED)
      Case 2
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_DISBAND_WEEK)
      Case 7
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_DISBAND_AUTH)
    End Select
  End Sub

  Private Sub BNCS_CLANDISBAND_Send(Cookie As UInt32)
    Dim pktTemp As New BNCSPacket(BNCS_CLANDISBAND)
    pktTemp.InsertUInt32(Cookie)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANMAKECHIEFTAIN_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim Status As Byte = pktRead.ReadByte
    Select Case Status
      Case 0
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_MAKECHIEFTAIN)
      Case 2
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_MAKECHIEFTAIN_WEEK)
      Case 4
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_MAKECHIEFTAIN_DECLINED)
      Case 5
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_MAKECHIEFTAIN_FAILED)
      Case 7
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_MAKECHEIEFTAIN_AUTH)
      Case 8
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_MAKECHIEFTAIN_ALLOWED)
    End Select
  End Sub

  Private Sub BNCS_CLANMAKECHIEFTAIN_Send(Cookie As UInt32, NewChieftain As String)
    Dim pktTemp As New BNCSPacket(BNCS_CLANMAKECHIEFTAIN)
    pktTemp.InsertUInt32(Cookie)
    pktTemp.InsertCString(NewChieftain)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANINFO_Recv(pktRead As BNCSReader)
    Dim Unknown As Byte = pktRead.ReadByte
    ChatData.ClanTag = pktRead.ReadDWORDString()
    ChatData.ClanRank = pktRead.ReadByte
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_CLAN, ResString(My.Resources.CLAN_INFO, ClanRankToString(ChatData.ClanRank), ChatData.ClanTag))
  End Sub

  Private Sub BNCS_CLANQUITNOTIFY_Recv(pktRead As BNCSReader)
    Dim Status As Byte = pktRead.ReadByte
    If Status = 1 Then
      gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_QUIT)
      ChatData.ClanTag = Nothing
      ChatData.ClanRank = 0
    Else
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, ResString(My.Resources.CLAN_QUIT_FAIL, Hex(Status)))
    End If
  End Sub

  Private Sub BNCS_CLANINVITATION_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim Result As Byte = pktRead.ReadByte
    If Cookie = &H2 Then
      Select Case Result
        Case 0
          QueueMessage(My.Resources.CLAN_INVITATION_ACCEPTED)
        Case 4
          QueueMessage(My.Resources.CLAN_INVITATION_DECLINED)
        Case 5
          QueueMessage(My.Resources.CLAN_INVITATION_FAILED)
        Case 9
          QueueMessage(My.Resources.CLAN_INVITATION_FULL)
      End Select
    Else
      Select Case Result
        Case 0
          gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_INVITATION_ACCEPTED)
        Case 4
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_INVITATION_DECLINED)
        Case 5
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_INVITATION_FAILED)
        Case 9
          gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_INVITATION_FULL)
      End Select
    End If
  End Sub

  Private Sub BNCS_CLANINVITATION_Send(Cookie As UInt32, Username As String)
    Dim pktTemp As New BNCSPacket(BNCS_CLANINVITATION)
    pktTemp.InsertUInt32(Cookie)
    pktTemp.InsertCString(Username)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANREMOVEMEMBER_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim Status As Byte = pktRead.ReadByte
    Select Case Status
      Case 0
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_REMOVE_COMPLETE)
      Case 1
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_REMOVE_FAIL)
      Case 2
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_REMOVE_WEEK)
      Case 7
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_REMOVE_AUTH)
      Case 8
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_REMOVE_ALLOWED)
    End Select
  End Sub

  Private Sub BNCS_CLANREMOVEMEMBER_Send(Cookie As UInt32, Username As String)
    Dim pktTemp As New BNCSPacket(BNCS_CLANREMOVEMEMBER)
    pktTemp.InsertUInt32(Cookie)
    pktTemp.InsertCString(Username)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANINVITATIONRESPONSE_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim ClanTag As String = pktRead.ReadDWORDString()
    Dim ClanName As String = pktRead.ReadCString
    Dim Inviter As String = pktRead.ReadCString
    ShowClanInvite({Cookie, ClanTag, ClanName, Inviter})
  End Sub

  Private Sub BNCS_CLANINVITATIONRESPONSE_Send(Cookie As UInt32, ClanTag As String, Inviter As String, Accept As Boolean)
    Dim pktTemp As New BNCSPacket(BNCS_CLANINVITATIONRESPONSE)
    pktTemp.InsertUInt32(Cookie)
    pktTemp.InsertDwordString(ClanTag)
    pktTemp.InsertCString(Inviter)
    pktTemp.InsertByte(IIf(Accept, 6, 4))
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANRANKCHANGE_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim Status As Byte = pktRead.ReadByte
    Select Case Status
      Case 0
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_RANK_CHANGED)
      Case 1
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_RANK_FAIL)
      Case 2
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_RANK_WEEK)
      Case 7
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_RANK_AUTH)
      Case 8
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CLAN, My.Resources.CLAN_RANK_ALLOWED)
    End Select
  End Sub

  Private Sub BNCS_CLANRANKCHANGE_Send(Cookie As UInt32, Username As String, NewRank As Byte)
    Dim pktTemp As New BNCSPacket(BNCS_CLANRANKCHANGE)
    pktTemp.InsertUInt32(Cookie)
    pktTemp.InsertCString(Username)
    pktTemp.InsertByte(NewRank)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANSETMOTD_Send(Cookie As UInt32, MOTD As String)
    Dim pktTemp As New BNCSPacket(BNCS_CLANSETMOTD)
    pktTemp.InsertUInt32(Cookie)
    pktTemp.InsertCString(MOTD)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANMOTD_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim Unknown As UInt32 = pktRead.ReadUInt32
    Dim MOTD As String = pktRead.ReadCString
    If Cookie = &H1 Then
      SetMotD(MOTD)
    Else
      gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_CLAN, "[MotD] " & MOTD)
    End If
  End Sub

  Private Sub BNCS_CLANMOTD_Send(Cookie As UInt32)
    Dim pktTemp As New BNCSPacket(BNCS_CLANMOTD)
    pktTemp.InsertUInt32(Cookie)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANMEMBERLIST_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim Members As Byte = pktRead.ReadByte
    ClanList.Clear()
    For I As Byte = 0 To Members - 1
      ClanAdd(pktRead.ReadCString, pktRead.ReadByte, pktRead.ReadByte, pktRead.ReadCString)
    Next
    ClanUpdate()
  End Sub

  Private Sub BNCS_CLANMEMBERLIST_Send(Cookie As UInt32)
    Dim pktTemp As New BNCSPacket(BNCS_CLANMEMBERLIST)
    pktTemp.InsertUInt32(Cookie)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub BNCS_CLANMEMBERREMOVED_Recv(pktRead As BNCSReader)
    Dim sUser As String = pktRead.ReadCString
    ClanRemove(sUser)
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_CLAN, ResString(My.Resources.CLAN_LEFT, sUser))
  End Sub

  Private Sub BNCS_CLANMEMBERSTATUSCHANGE_Recv(pktRead As BNCSReader)
    ClanAdd(pktRead.ReadCString, pktRead.ReadByte, pktRead.ReadByte, pktRead.ReadCString)
    ClanUpdate()
  End Sub

  Private Sub BNCS_CLANMEMBERRANKCHANGE_Recv(pktRead As BNCSReader)
    Dim OldRank As Byte = pktRead.ReadByte
    Dim NewRank As Byte = pktRead.ReadByte
    Dim Changer As String = pktRead.ReadCString
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_CLAN, ResString(My.Resources.CLAN_RANK_CHANGE, ClanRankToString(OldRank), ClanRankToString(NewRank), Changer))
  End Sub

  Private Sub BNCS_CLANMEMBERINFORMATION_Recv(pktRead As BNCSReader)
    Dim Cookie As UInt32 = pktRead.ReadUInt32
    Dim Status As Byte = pktRead.ReadByte
    If Status = 0 Then
      Dim sUsernames() As String = Nothing
      Dim prType As ProfileRequests.ProfileRequestType
      Dim prDisp As ProfileRequests.ProfileRequestDisplay
      Dim prUpdate As frmProfile.UpdateTypes
      Dim prWhisperTo As String = String.Empty
      ProfileRequestList.GetRequest(Cookie, sUsernames, prType, prDisp, prUpdate, prWhisperTo)
      Dim sWhis As String = "/w " & IIf(Config.Account.Client.Product = GameType.D2DV Or Config.Account.Client.Product = GameType.D2XP, "*", String.Empty) & prWhisperTo & " "
      Dim ClanName As String = Encoding.UTF8.GetString(pktRead.ReadNullTerminatedByteArray)
      Dim Rank As Byte = pktRead.ReadByte
      Dim Joined As UInt64 = pktRead.ReadUInt64
      ProfileWindow.UpdateW3Tab(sUsernames(0), prUpdate, {ClanName, Rank, Joined})
    Else
      'Not in clan
    End If
  End Sub

  Private Sub BNCS_CLANMEMBERINFORMATION_Send(Cookie As UInt32, ClanTag As String, Username As String)
    Dim pktTemp As New BNCSPacket(BNCS_CLANMEMBERINFORMATION)
    pktTemp.InsertUInt32(Cookie)
    pktTemp.InsertDwordString(ClanTag)
    pktTemp.InsertCString(Username)
    BNCS_Send(pktTemp)
  End Sub

  Private Sub PKT_CLIENTREQ_Recv(ByRef ipFrom As DnsEndPoint, ByRef Packet As DataReader)
    Dim Code As UInt32 = Packet.ReadUInt32
    PKT_CLIENTREQ_Send(ipFrom, Code <> 0)
  End Sub

  Private Sub PKT_CLIENTREQ_Send(ByRef ipFrom As DnsEndPoint, Pong As Boolean)
    Using pktTemp As New DataBuffer
      pktTemp.InsertUInt32(&H3)
      pktTemp.InsertUInt32(&H1)
      If Pong Then
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_UDP, "Pong from " & ipFrom.Host & ":" & ipFrom.Port.ToString)
      Else
        If tbsLists.Controls.Contains(tabPacket) Then AddPacket({My.Resources.PROTOCOL_UDP, False, &H3, pktTemp.GetData})
        If sckUDP.IsConnected Then sckUDP.SendTo(ipFrom, pktTemp.GetData)
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_UDP, "Ping to " & ipFrom.Host & ":" & ipFrom.Port.ToString)
      End If
    End Using
  End Sub

  Private Sub PKT_SERVERPING_Recv(ByRef ipFrom As IPEndPoint, ByRef Packet As DataReader)
    BNetData.UDPCode = Packet.ReadUInt32
  End Sub

  Private Sub PKT_KEEPALIVE_Send()
    Using pktTemp As New DataBuffer
      pktTemp.InsertUInt32(&H7)
      pktTemp.InsertInt32(Environment.TickCount)
      If tbsLists.Controls.Contains(tabPacket) Then AddPacket({My.Resources.PROTOCOL_UDP, False, &H7, pktTemp.GetData})
      If sckUDP.IsConnected Then sckUDP.SendTo(udpRemoteEndPoint, pktTemp.GetData)
    End Using
  End Sub

  Private Sub PKT_CONNTEST_Send()
    Using pktTemp As New DataBuffer
      pktTemp.InsertUInt32(&H8)
      pktTemp.InsertInt32(BNetData.ServerToken)
      If tbsLists.Controls.Contains(tabPacket) Then AddPacket({My.Resources.PROTOCOL_UDP, False, &H8, pktTemp.GetData})
      If sckUDP.IsConnected Then sckUDP.SendTo(udpRemoteEndPoint, pktTemp.GetData)
    End Using
  End Sub

  Private Sub PKT_CONNTEST2_Send()
    Using pktTemp As New DataBuffer
      pktTemp.InsertUInt32(&H9)
      pktTemp.InsertUInt32(BNetData.ServerToken)
      pktTemp.InsertUInt32(BNetData.UDPToken)
      If tbsLists.Controls.Contains(tabPacket) Then AddPacket({My.Resources.PROTOCOL_UDP, False, &H9, pktTemp.GetData})
      If sckUDP.IsConnected Then sckUDP.SendTo(udpRemoteEndPoint, pktTemp.GetData)
    End Using
  End Sub

  Private Sub MCP_STARTUP_Recv(ByRef pktRead As MCPReader)
    Dim Result As UInt32 = pktRead.ReadUInt32()
    Select Case Result
      Case &H2, &HA, &HB, &HC, &HD
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, My.Resources.REALM_UNAVAILABLE)
        DisplayRealmErrMessage(My.Resources.REALM_UNAVAILABLE & " [" & PadHex(Result, 2) & "]")
      Case &H7E
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, My.Resources.REALM_BANNEDKEY)
        DisplayRealmErrMessage(My.Resources.REALM_BANNEDKEY)
      Case &H7F
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, My.Resources.REALM_RESTRICTED)
        DisplayRealmErrMessage(My.Resources.REALM_RESTRICTED)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_MCP, My.Resources.REALM_LOGIN)
        Realms.Status = D2Realm.RealmState.GettingCharacterList
        DisplayRealmWaitMessage(My.Resources.REALM_STATUS_CHAR_LIST)
        MCP_CHARLIST2_Send()
    End Select
  End Sub

  Private Sub MCP_STARTUP_Send()
    Dim pktTemp As New MCPPacket(MCP_STARTUP)
    pktTemp.InsertUInt32(BNetData.ClientToken)
    pktTemp.InsertUInt32(MCP.Status)
    pktTemp.InsertUInt32(MCP.BNCSIP)
    pktTemp.InsertUInt32(MCP.UDPToken)
    pktTemp.InsertUInt16(MCP.NullVal)
    pktTemp.InsertUInt16(MCP.KeyProd)
    pktTemp.InsertUInt32(MCP.KeyPub)
    pktTemp.InsertUInt32(MCP.GatewayID)
    pktTemp.InsertUInt32(MCP.ProductID)
    pktTemp.InsertUInt32(MCP.PlatformID)
    pktTemp.InsertUInt32(MCP.BNCSIP2)
    pktTemp.InsertUInt32(MCP.Locale)
    pktTemp.InsertUInt32(MCP.MCPHash1)
    pktTemp.InsertUInt32(MCP.MCPHash2)
    pktTemp.InsertUInt32(MCP.MCPHash3)
    pktTemp.InsertUInt32(MCP.MCPHash4)
    pktTemp.InsertUInt32(MCP.MCPHash5)
    pktTemp.InsertCString(Config.Account.Username)
    MCP_Send(pktTemp)
  End Sub

  Private Sub MCP_CHARCREATE_Recv(ByRef pktRead As MCPReader)
    Dim lRet As UInt32 = pktRead.ReadUInt32
    Select Case lRet
      Case &H0
        Realms.Status = D2Realm.RealmState.GettingCharacterList
        DisplayRealmWaitMessage(My.Resources.REALM_STATUS_CHAR_CREATED & vbNewLine & My.Resources.REALM_STATUS_CHAR_LIST)
        MCP_CHARLIST2_Send()
      Case &H14
        MsgBox(My.Resources.REALM_CREATE_14, MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
        DisplayRealmCharCreate()
      Case &H15
        MsgBox(My.Resources.REALM_CREATE_15, MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
        DisplayRealmCharCreate()
      Case Else
        MsgBox(ResString(My.Resources.REALM_CREATE_UNKNOWN, PadHex(lRet, 2)), MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
        DisplayRealmCharCreate()
    End Select
  End Sub

  Public Sub MCP_CHARCREATE_Send(CharClass As UInt32, CharFlags As UInt16, CharName As String)
    Dim pktTemp As New MCPPacket(MCP_CHARCREATE)
    pktTemp.InsertUInt32(CharClass)
    pktTemp.InsertUInt16(CharFlags)
    pktTemp.InsertCString(CharName)
    MCP_Send(pktTemp)
  End Sub

  Private Sub MCP_CHARLOGON_Recv(ByRef pktRead As MCPReader)
    Dim lRet As UInt32 = pktRead.ReadUInt32
    Select Case lRet
      Case &H0
        If sckBNCS.IsConnected And lblChannel.Tag Is Nothing Then
          GetUserData(Config.Account.Username, ProfileRequests.ProfileRequestType.AccountInfo, ProfileRequests.ProfileRequestDisplay.PrivateUI)
          BNCS_GETICONDATA_Send()
        Else
          'BNCS_LEAVECHAT_Send()
          'BNCS_JOINCHANNEL_Send(lblChannel.Tag.ToString)
        End If
        'Me.Invoke(New EventHandler(AddressOf cmdRealmLoginCancel_Click), "ND") ' ("ND", New EventArgs)
      Case &H46
        MsgBox(My.Resources.REALM_LOGON_46, MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
      Case &H7A
        MsgBox(My.Resources.REALM_LOGON_7A, MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
      Case &H7B
        MsgBox(My.Resources.REALM_LOGON_7B, MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
      Case Else
        MsgBox(ResString(My.Resources.REALM_LOGON_UNKNOWN, PadHex(lRet, 2)), MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
    End Select
  End Sub

  Public Sub MCP_CHARLOGON_Send(Character As String)
    Dim pktTemp As New MCPPacket(MCP_CHARLOGON)
    pktTemp.InsertCString(Character)
    MCP_Send(pktTemp)
  End Sub

  Private Sub MCP_CHARDELETE_Recv(ByRef pktRead As MCPReader)
    Dim lRet As UInt32 = pktRead.ReadUInt32
    Select Case lRet
      Case &H0
        Realms.Status = D2Realm.RealmState.GettingCharacterList
        DisplayRealmWaitMessage(My.Resources.REALM_STATUS_CHAR_DELETED & vbNewLine & My.Resources.REALM_STATUS_CHAR_LIST)
        MCP_CHARLIST2_Send()
      Case &H49
        MsgBox(My.Resources.REALM_DELETE_49, MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
        DisplayRealmCharListing(False)
      Case Else
        MsgBox(ResString(My.Resources.REALM_DELETE_UNKNOWN, PadHex(lRet, 2)), MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
        DisplayRealmCharListing(False)
    End Select
  End Sub

  Public Sub MCP_CHARDELETE_Send(Character As String)
    Dim pktTemp As New MCPPacket(MCP_CHARDELETE)
    pktTemp.InsertUInt16(&H0)
    pktTemp.InsertCString(Character)
    MCP_Send(pktTemp)
  End Sub

  Private Sub MCP_CHARLIST_Recv(ByRef pktRead As MCPReader)
    Dim iRequest As UInt16 = pktRead.ReadUInt16
    Dim iChars As UInt32 = pktRead.ReadUInt32
    Dim iReturned As UInt16 = pktRead.ReadUInt16
    Realms.Status = D2Realm.RealmState.CharacterList
    Realms.CharListing.Clear()
    If iReturned > 0 Then
      Dim aList(iReturned - 1) As Object
      For I As UInt16 = 0 To iReturned - 1
        Realms.CharListing.AddChar(0, pktRead.ReadCString, pktRead.ReadNullTerminatedByteArray)
      Next
    End If
    DisplayRealmCharListing(True)
  End Sub

  Private Sub MCP_CHARLIST_Send()
    Dim pktTemp As New MCPPacket(MCP_CHARLIST)
    pktTemp.InsertUInt32(8)
    MCP_Send(pktTemp)
  End Sub

  Private Sub MCP_CHARUPGRADE_Recv(ByRef pktRead As MCPReader)
    Dim lRet As UInt32 = pktRead.ReadUInt32
    Select Case lRet
      Case &H0
        Realms.Status = D2Realm.RealmState.GettingCharacterList
        DisplayRealmWaitMessage(My.Resources.REALM_STATUS_CHAR_UPGRADED & vbNewLine & My.Resources.REALM_STATUS_CHAR_LIST)
        MCP_CHARLIST2_Send()
      Case &H46
        MsgBox(My.Resources.REALM_UPGRADE_46, MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
        DisplayRealmCharListing(False)
      Case &H7A
        MsgBox(My.Resources.REALM_UPGRADE_7A, MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
        DisplayRealmCharListing(False)
      Case &H7B
        MsgBox(My.Resources.REALM_UPGRADE_7B, MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
        DisplayRealmCharListing(False)
      Case &H7C
        MsgBox(My.Resources.REALM_UPGRADE_7C, MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
        DisplayRealmCharListing(False)
      Case Else
        MsgBox(ResString(My.Resources.REALM_UPGRADE_UNKNOWN, PadHex(lRet, 2)), MsgBoxStyle.Critical + MsgBoxStyle.SystemModal, My.Resources.REALM_TITLE)
        DisplayRealmCharListing(False)
    End Select
  End Sub

  Public Sub MCP_CHARUPGRADE_Send(Character As String)
    Dim pktTemp As New MCPPacket(MCP_CHARUPGRADE)
    pktTemp.InsertCString(Character)
    MCP_Send(pktTemp)
  End Sub

  Private Sub MCP_CHARLIST2_Recv(ByRef pktRead As MCPReader)
    Dim iRequest As UInt16 = pktRead.ReadUInt16
    Dim iChars As UInt32 = pktRead.ReadUInt32
    Dim iReturned As UInt16 = pktRead.ReadUInt16
    Realms.Status = D2Realm.RealmState.CharacterList
    Realms.CharListing.Clear()
    If iReturned > 0 Then
      Dim aList(iReturned - 1) As Object
      For I As UInt16 = 0 To iReturned - 1
        Realms.CharListing.AddChar(pktRead.ReadUInt32, pktRead.ReadCString, pktRead.ReadNullTerminatedByteArray)
      Next
    End If
    DisplayRealmCharListing(True)
  End Sub

  Public Sub MCP_CHARLIST2_Send()
    Dim pktTemp As New MCPPacket(MCP_CHARLIST2)
    pktTemp.InsertUInt32(8)
    MCP_Send(pktTemp)
  End Sub
#End Region

#Region "BNet Functions"
  Public Sub BNCS_Connect()
    Select Case Config.Account.Client.Product
      Case GameType.DRTL, GameType.DSHR, GameType.D2DV, GameType.D2XP, GameType.STAR, GameType.SEXP, GameType.JSTR, GameType.SSHR, GameType.W2BN, GameType.WAR3, GameType.W3XP
        BNCS_Connectv1()
      Case GameType.SCII, GameType.WOW
        gChat.AddChat(GeckoChat.ChatType.VerboseInfo, My.Resources.PROTOCOL_CONFIG, GameTypeToGameTitle(Config.Account.Client.Product) & " is in testing stages. Please be careful.")
        BNCS_Connectv2()
      Case Else
        BNCS_Disconnect()
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_CONFIG, GameTypeToGameTitle(Config.Account.Client.Product) & " is not supported at this time.")
    End Select
  End Sub

  Public Sub BNCS_Connectv1()
    gChat.EndReconnect(False)
    bBNState = 1
    If Config.VerByte = 0 Then Config.VerByte = ReadVerbyte(Config.Account.Client.Product)
    If wsDownload.IsBusy Then Exit Sub
    If Config.VerByte = 0 Then GetVerByte()
    While wsDownload.IsBusy : Application.DoEvents() : End While
    If CheckHashFiles() = False Then
      GetNewHashes()
      Exit Sub
    End If
    ConErr = TriState.UseDefault
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, My.Resources.INFO_CONNECTING)
    Dim Servers() As IPAddress = GetGatewayIPs(GetGatewayURL(Config.Server, Config.Account.Client.Product = GameType.WAR3 Or Config.Account.Client.Product = GameType.W3XP))
    ToggleListChannel(False)
    If Servers Is Nothing Then
      BNetData.ServerIP = Dns.GetHostAddresses(Config.Server).FirstOrDefault
    Else
      BNetData.ServerIP = Servers(Int(Rnd() * Servers.Count))
    End If
    If Config.Proxy.Use Then
      sckBNCS.UseProxy = True
      If Config.Proxy.Port = 0 Then Config.Proxy.Port = 1080
      sckBNCS.RemoteEndPoint = New Net.DnsEndPoint(Config.Proxy.IP, Config.Proxy.Port)
      sckBNCS.Proxy.Ver = Config.Proxy.Ver
      sckBNCS.Proxy.User = Config.Proxy.User
      sckBNCS.Proxy.Pass = Config.Proxy.Pass
      sckBNCS.Proxy.Dest = New Net.DnsEndPoint(BNetData.ServerIP.ToString, 6112)
      If Config.Proxy.Ver = ProxyType.SOCKS5 Then
        idThread = Nothing
        idThread = New Thread(AddressOf GetIdent)
        idThread.IsBackground = True
        idThread.Priority = ThreadPriority.Lowest
        idThread.Start()
        wsIdent.Start(&HFF)
      End If
      sckBNCS.Connect()
    Else
      sckBNCS.UseProxy = False
      sckBNCS.RemoteEndPoint = New Net.DnsEndPoint(BNetData.ServerIP.ToString, 6112)
      sckBNCS.Connect()
    End If
    Select Case Config.Account.Client.Product
      Case GameType.DRTL, GameType.DSHR, GameType.STAR, GameType.SSHR, GameType.JSTR, GameType.SEXP, GameType.W2BN
        GetEndPoint()
      Case Else
        sckUDP.Disconnect()
    End Select
  End Sub

  Public Sub BNCS_Connectv2()
    gChat.EndReconnect(False)
    bBNState = 1
    ConErr = TriState.UseDefault
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNET2, My.Resources.INFO_CONNECTING)
    ToggleListChannel(False)
    Try
      BNetData.ServerIP = Dns.GetHostAddresses(Config.Server).FirstOrDefault
    Catch ex As Exception
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNET2, ex.Message)
      BNCS_Disconnect()
      Exit Sub
    End Try
    'wsDownload.Headers.Set(Net.HttpRequestHeader.UserAgent, "Battle.net Web Client")
    'wsDownload.Headers.Set(Net.HttpRequestHeader.Accept, "*/*")
    'wsDownload.Headers.Set(Net.HttpRequestHeader.Referer, "http://enUS.nydus.battle.net/S2/enUS/alert")
    'wsDownload.DownloadStringAsync(New Uri("http://us.launcher.battle.net/service/s2/alert/en-us"), "BN2")
    If Config.Proxy.Use Then
      sckBN2.UseProxy = True
      If Config.Proxy.Port = 0 Then Config.Proxy.Port = 1080
      sckBN2.RemoteEndPoint = New Net.DnsEndPoint(Config.Proxy.IP, Config.Proxy.Port)
      sckBN2.Proxy.Ver = Config.Proxy.Ver
      sckBN2.Proxy.User = Config.Proxy.User
      sckBN2.Proxy.Pass = Config.Proxy.Pass
      sckBN2.Proxy.Dest = New Net.DnsEndPoint(BNetData.ServerIP.ToString, 6112)
      If Config.Proxy.Ver = ProxyType.SOCKS5 Then
        idThread = Nothing
        idThread = New Thread(AddressOf GetIdent)
        idThread.IsBackground = True
        idThread.Priority = ThreadPriority.Lowest
        idThread.Start()
        wsIdent.Start(&HFF)
      End If
      sckBN2.Connect()
    Else
      sckBN2.UseProxy = False
      sckBN2.RemoteEndPoint = New Net.DnsEndPoint(BNetData.ServerIP.ToString, 1119)
      sckBN2.Connect()
    End If
  End Sub

  Private Sub GetIdent()
    Do
      If wsIdent.Pending Then
        Dim wsClient = wsIdent.AcceptTcpClient
        Dim nsStream As NetworkStream = wsClient.GetStream
        Dim iStart As Integer = Environment.TickCount
        Dim sTmp As String = String.Empty
        Do While wsClient.Connected And Environment.TickCount - iStart < 30000
          Dim bTmp(1023) As Byte
          Dim iLen As Integer = nsStream.Read(bTmp, 0, bTmp.Length)
          sTmp &= Encoding.ASCII.GetString(bTmp, 0, iLen)
          If InStr(sTmp, vbCrLf) Then
            Dim sCommand As String = sTmp.Split(vbCrLf)(0)
            sTmp = sTmp.Split(vbCrLf)(1)
            If InStr(sCommand, ",") > 0 Then
              Dim sCmd() As String = sCommand.Split(",")
              If IsNumeric(sCmd(0)) And IsNumeric(sCmd(1)) Then
                Dim iSPort As Integer = Integer.Parse(sCmd(0).Trim)
                Dim iCPort As Integer = Integer.Parse(sCmd(1).Trim)
                If iSPort = Integer.Parse(Split(wsClient.Client.LocalEndPoint.ToString, ":")(1)) And iCPort = Integer.Parse(Split(wsClient.Client.RemoteEndPoint.ToString, ":")(1)) Then
                  Dim bRet() As Byte = Encoding.ASCII.GetBytes(iSPort.ToString & "," & iCPort.ToString & ":USERID:" & Environment.OSVersion.Platform.ToString & ":" & Environment.UserName & vbCrLf)
                  nsStream.Write(bRet, 0, bRet.Length)
                Else
                  nsStream.Close()
                End If
              End If
            End If
          End If
        Loop
        wsClient.Close()
      End If
    Loop While wsIdent IsNot Nothing AndAlso wsIdent.Server.IsBound
  End Sub

  Private Sub BNCS_Handle(pktRead As BNCSReader)
    If tbsLists.Controls.Contains(tabPacket) Then AddPacket({My.Resources.PROTOCOL_BNCS, True, pktRead.PacketID, pktRead.GetAllBytes})
    Select Case pktRead.PacketID
      Case BNCS_NULL
        BNCS_NULL_Recv(pktRead)
      Case BNCS_SERVERLIST
        BNCS_SERVERLIST_Recv(pktRead)
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_PACKET_DEFUNCT, "BNCS_SERVERLIST"))
      Case BNCS_CLIENTID
        BNCS_CLIENTID_Recv(pktRead)
      Case BNCS_STARTVERSIONING
        BNCS_STARTVERSIONING_Recv(pktRead)
      Case BNCS_REPORTVERSION
        BNCS_REPORTVERSION_Recv(pktRead)
      Case BNCS_STARTADVEX
        BNCS_STARTADVEX_Recv(pktRead)
      Case BNCS_GETADVLISTEX
        BNCS_GETADVLISTEX_Recv(pktRead)
      Case BNCS_ENTERCHAT
        BNCS_ENTERCHAT_Recv(pktRead)
      Case BNCS_GETCHANNELLIST
        BNCS_GETCHANNELLIST_Recv(pktRead)
      Case BNCS_CHATEVENT
        BNCS_CHATEVENT_Recv(pktRead)
      Case BNCS_FLOODDETECTED
        BNCS_FLOODDETECTED_Recv(pktRead)
      Case BNCS_CHECKAD
        BNCS_CHECKAD_Recv(pktRead)
      Case BNCS_READMEMORY
        BNCS_READMEMORY_Recv(pktRead)
      Case BNCS_REGISTRY
        BNCS_REGISTRY_Recv(pktRead)
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_PACKET_DEFUNCT, "BNCS_REGISTRY"))
      Case BNCS_MESSAGEBOX
        BNCS_MESSAGEBOX_Recv(pktRead)
      Case BNCS_STARTADVEX3
        BNCS_STARTADVEX3_Recv(pktRead)
      Case BNCS_LOGONCHALLENGEEX
        BNCS_LOGONCHALLENGEEX_Recv(pktRead)
      Case BNCS_ANNOUNCEMENT
        BNCS_ANNOUNCEMENT_Recv(pktRead)
      Case BNCS_WRITECOOKIE
        BNCS_WRITECOOKIE_Recv(pktRead)
      Case BNCS_READCOOKIE
        BNCS_READCOOKIE_Recv(pktRead)
      Case BNCS_PING
        BNCS_PING_Recv(pktRead)
      Case BNCS_READUSERDATA
        BNCS_READUSERDATA_Recv(pktRead)
      Case BNCS_LOGONCHALLENGE
        BNCS_LOGONCHALLENGE_Recv(pktRead)
      Case BNCS_LOGONRESPONSE
        BNCS_LOGONRESPONSE_Recv(pktRead)
      Case BNCS_CREATEACCOUNT
        BNCS_CREATEACCOUNT_Recv(pktRead)
      Case BNCS_GETICONDATA
        BNCS_GETICONDATA_Recv(pktRead)
      Case BNCS_GETLADDERDATA
        BNCS_GETLADDERDATA_Recv(pktRead)
      Case BNCS_FINDLADDERUSER
        BNCS_FINDLADDERUSER_Recv(pktRead)
      Case BNCS_CDKEY
        BNCS_CDKEY_Recv(pktRead)
      Case BNCS_CHANGEPASSWORD
        BNCS_CHANGEPASSWORD_Recv(pktRead)
      Case BNCS_CHECKDATAFILE
        BNCS_CHECKDATAFILE_Recv(pktRead)
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_PACKET_DEFUNCT, "BNCS_CHECKDATAFILE"))
      Case BNCS_GETFILETIME
        BNCS_GETFILETIME_Recv(pktRead)
      Case BNCS_QUERYREALMS
        BNCS_QUERYREALMS_Recv(pktRead)
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_PACKET_DEFUNCT, "BNCS_QUERYREALMS"))
      Case BNCS_PROFILE
        BNCS_PROFILE_Recv(pktRead)
      Case BNCS_CDKEY2
        BNCS_CDKEY2_Recv(pktRead)
      Case BNCS_LOGONRESPONSE2
        BNCS_LOGONRESPONSE2_Recv(pktRead)
      Case BNCS_CHECKDATAFILE2
        BNCS_CHECKDATAFILE_Recv(pktRead)
      Case BNCS_CREATEACCOUNT2
        BNCS_CREATEACCOUNT2_Recv(pktRead)
      Case BNCS_LOGONREALMEX
        BNCS_LOGONREALMEX_Recv(pktRead)
      Case BNCS_STARTVERSIONING2
        BNCS_STARTVERSIONING2_Recv(pktRead)
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_PACKET_DEFUNCT, "BNCS_STARTVERSIONING2"))
      Case BNCS_QUERYREALMS2
        BNCS_QUERYREALMS2_Recv(pktRead)
      Case BNCS_QUERYADURL
        BNCS_QUERYADURL_Recv(pktRead)
      Case BNCS_WARCRAFTUNKNOWN
        BNCS_WARCRAFTUNKNOWN_Recv(pktRead)
      Case BNCS_WARCRAFTGENERAL
        BNCS_WARCRAFTGENERAL_Recv(pktRead)
      Case BNCS_NEWS_INFO
        BNCS_NEWS_INFO_Recv(pktRead)
      Case BNCS_OPTIONALWORK
        BNCS_OPTIONALWORK_Recv(pktRead)
      Case BNCS_REQUIREDWORK
        BNCS_REQUIREDWORK_Recv(pktRead)
      Case BNCS_ADDLEAGUE
        BNCS_ADDLEAGUE_Recv(pktRead)
      Case BNCS_AUTH_INFO
        BNCS_AUTH_INFO_Recv(pktRead)
      Case BNCS_AUTH_CHECK
        BNCS_AUTH_CHECK_Recv(pktRead)
      Case BNCS_AUTH_ACCOUNTCREATE
        BNCS_AUTH_ACCOUNTCREATE_Recv(pktRead)
      Case BNCS_AUTH_ACCOUNTLOGON
        BNCS_AUTH_ACCOUNTLOGON_Recv(pktRead)
      Case BNCS_AUTH_ACCOUNTLOGONPROOF
        BNCS_AUTH_ACCOUNTLOGONPROOF_Recv(pktRead)
      Case BNCS_AUTH_ACCOUNTCHANGE
        BNCS_AUTH_ACCOUNTCHANGE_Recv(pktRead)
      Case BNCS_AUTH_ACCOUNTCHANGEPROOF
        BNCS_AUTH_ACCOUNTCHANGEPROOF_Recv(pktRead)
      Case BNCS_AUTH_ACCOUNTUPGRADE
        BNCS_AUTH_ACCOUNTUPGRADE_Recv(pktRead)
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_PACKET_DEFUNCT, "BNCS_AUTH_ACCOUNTUPGRADE"))
      Case BNCS_AUTH_ACCOUNTUPGRADEPROOF
        BNCS_AUTH_ACCOUNTUPGRADEPROOF_Recv(pktRead)
        gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_PACKET_DEFUNCT, "BNCS_AUTH_ACCOUNTUPGRADEPROOF"))
      Case BNCS_SETEMAIL
        BNCS_SETEMAIL_Recv(pktRead)
      Case BNCS_WARDEN
        BNCS_WARDEN_Recv(pktRead)
      Case BNCS_GAMEPLAYERSEARCH
        BNCS_GAMEPLAYERSEARCH_Recv(pktRead)
      Case BNCS_FRIENDSLIST
        BNCS_FRIENDSLIST_Recv(pktRead)
      Case BNCS_FRIENDSUPDATE
        BNCS_FRIENDSUPDATE_Recv(pktRead)
      Case BNCS_FRIENDSADD
        BNCS_FRIENDSADD_Recv(pktRead)
      Case BNCS_FRIENDSREMOVE
        BNCS_FRIENDSREMOVE_Recv(pktRead)
      Case BNCS_FRIENDSPOSITION
        BNCS_FRIENDSPOSITION_Recv(pktRead)
      Case BNCS_CLANFINDCANDIDATES
        BNCS_CLANFINDCANDIDATES_Recv(pktRead)
      Case BNCS_CLANINVITEMULTIPLE
        BNCS_CLANINVITEMULTIPLE_Recv(pktRead)
      Case BNCS_CLANCREATIONINVITATION
        BNCS_CLANCREATIONINVITIATION_Recv(pktRead)
      Case BNCS_CLANDISBAND
        BNCS_CLANDISBAND_Recv(pktRead)
      Case BNCS_CLANMAKECHIEFTAIN
        BNCS_CLANMAKECHIEFTAIN_Recv(pktRead)
      Case BNCS_CLANINFO
        BNCS_CLANINFO_Recv(pktRead)
      Case BNCS_CLANQUITNOTIFY
        BNCS_CLANQUITNOTIFY_Recv(pktRead)
      Case BNCS_CLANINVITATION
        BNCS_CLANINVITATION_Recv(pktRead)
      Case BNCS_CLANREMOVEMEMBER
        BNCS_CLANREMOVEMEMBER_Recv(pktRead)
      Case BNCS_CLANINVITATIONRESPONSE
        BNCS_CLANINVITATIONRESPONSE_Recv(pktRead)
      Case BNCS_CLANRANKCHANGE
        BNCS_CLANRANKCHANGE_Recv(pktRead)
      Case BNCS_CLANMOTD
        BNCS_CLANMOTD_Recv(pktRead)
      Case BNCS_CLANMEMBERLIST
        BNCS_CLANMEMBERLIST_Recv(pktRead)
      Case BNCS_CLANMEMBERREMOVED
        BNCS_CLANMEMBERREMOVED_Recv(pktRead)
      Case BNCS_CLANMEMBERSTATUSCHANGE
        BNCS_CLANMEMBERSTATUSCHANGE_Recv(pktRead)
      Case BNCS_CLANMEMBERRANKCHANGE
        BNCS_CLANMEMBERRANKCHANGE_Recv(pktRead)
      Case BNCS_CLANMEMBERINFORMATION
        BNCS_CLANMEMBERINFORMATION_Recv(pktRead)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.INFO_PACKET_UNKNOWN, Hex(pktRead.PacketID) & vbNewLine & pktRead.ToString))
    End Select
  End Sub

  Private Sub PKT_Handle(ByRef ipFrom As EndPoint, ByRef bData() As Byte)
    Dim pktRead = New DataReader(bData)
    Dim pktID As UInt32 = pktRead.ReadUInt32
    If tbsLists.Controls.Contains(tabPacket) Then AddPacket({My.Resources.PROTOCOL_UDP, True, pktID, pktRead.GetAllBytes})
    Select Case pktID
      Case &H3
        PKT_CLIENTREQ_Recv(ipFrom, pktRead)
      Case &H5
        PKT_SERVERPING_Recv(ipFrom, pktRead)
      Case &H7
        'PKT_KEEPALIVE
      Case &H8
        'PKT_CONNTEST
      Case &H9
        'PKT_CONNTEST2
      Case Else
        pktRead = New DataReader(bData)
        Dim Checksum As UInt16 = pktRead.ReadUInt16
        Dim Length As UInt16 = pktRead.ReadUInt16
        Dim Seq1 As UInt16 = pktRead.ReadUInt16
        Dim Seq2 As UInt16 = pktRead.ReadUInt16
        Dim CLS As Byte = pktRead.ReadByte
        Dim CMD As Byte = pktRead.ReadByte
        Dim PID As Byte = pktRead.ReadByte
        Dim Resend As Byte = pktRead.ReadByte
    End Select
  End Sub

  Private Sub MCP_Handle(ByRef pktRead As MCPReader)
    If tbsLists.Controls.Contains(tabPacket) Then AddPacket({My.Resources.PROTOCOL_MCP, True, pktRead.PacketID, pktRead.GetAllBytes})
    Select Case pktRead.PacketID
      Case MCP_STARTUP
        MCP_STARTUP_Recv(pktRead)
      Case MCP_CHARCREATE
        MCP_CHARCREATE_Recv(pktRead)
      Case MCP_CREATEGAME
      Case MCP_JOINGAME
      Case MCP_GAMELIST
      Case MCP_GAMEINFO
      Case MCP_CHARLOGON
        MCP_CHARLOGON_Recv(pktRead)
      Case MCP_CHARDELETE
        MCP_CHARDELETE_Recv(pktRead)
      Case MCP_REQUESTLADDERDATA
      Case MCP_MOTD
        'MCP_MOTD_Recv(pktRead)
      Case MCP_CREATEQUEUE
      Case MCP_CHARLIST
        MCP_CHARLIST_Recv(pktRead)
      Case MCP_CHARUPGRADE
        MCP_CHARUPGRADE_Recv(pktRead)
      Case MCP_CHARLIST2
        MCP_CHARLIST2_Recv(pktRead)
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, ResString(My.Resources.INFO_PACKET_UNKNOWN, Hex(pktRead.PacketID) & vbNewLine & pktRead.ToString))
    End Select
  End Sub

  Private Sub BNCS_Send(ByRef Packet As BNCSPacket)
    Try
      If Not IsOnline Then
        gChat.AddChat(GeckoChat.ChatType.VerboseInfo, My.Resources.PROTOCOL_BNCS, "Unable to send " & ToID(My.Resources.PROTOCOL_BNCS, Packet.PacketID) & " (0x" & PadHex(Packet.PacketID, 2) & ") while offline.")
      Else
        If tbsLists.Controls.Contains(tabPacket) Then AddPacket({My.Resources.PROTOCOL_BNCS, False, Packet.PacketID, Packet.GetData})
        If sckBNCS Is Nothing Then
          BNCS_Disconnect(True)
          AttemptReconnect(My.Resources.ERR_NET_LOST)
        Else
          If sckBNCS.IsConnected Then
            sckBNCS.Send(Packet.GetData)
          End If
        End If
      End If
    Catch e As Exception
      Debug.Print("Send Fail: " & e.Message)
      BNCS_Disconnect(True)
      AttemptReconnect(My.Resources.ERR_NET_LOST)
    Finally
      Packet.Dispose()
    End Try
  End Sub

  Private Sub MCP_Send(ByRef Packet As MCPPacket)
    If tbsLists.Controls.Contains(tabPacket) Then AddPacket({My.Resources.PROTOCOL_MCP, False, Packet.PacketID, Packet.GetData})
    Try
      If sckMCP.IsConnected Then sckMCP.Send(Packet.GetData)
    Catch e As Exception
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, My.Resources.ERR_NET_LOST)
      MCP_Disconnect()
      MCP = Nothing
    Finally
      Packet.Dispose()
    End Try
  End Sub

  Public Sub BNCS_Disconnect(Optional Obj As Object = False)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf BNCS_Disconnect), Obj)
    Else
      Dim bncs2 As Boolean = sckBN2.IsConnected And Not sckBNCS.IsConnected
      Dim Errored As Boolean = Obj
      If Errored Then
        bBNState = 2
      Else
        bBNState = 0
      End If
      sckBN2.Disconnect()
      If cBNET2 IsNot Nothing Then
        cBNET2.Dispose()
        cBNET2 = Nothing
      End If
      sckBNCS.Disconnect()
      QueueList = Nothing
      If tmrRetryJoin IsNot Nothing Then tmrRetryJoin = Nothing
      ToggleListChannel(False)
      SetAds(False)
      sckUDP.Disconnect()
      If idThread IsNot Nothing Then
        wsIdent.Stop()
        idThread = Nothing
      End If
      If PingSpoof IsNot Nothing Then
        If Not gChat.IsDisposed Then gChat.TerminateProgress("pingspoof", My.Resources.PING_SPOOFCANCEL)
        PingSpoof = Nothing
      End If
      ConErr = Errored
      lblChannel.Text = String.Empty
      lblChannel.Tag = Nothing
      If tbsLists.Controls.Contains(tabClan) Then TabRemove(tabClan)
      If tbsLists.Controls.Contains(tabRealm) Then TabRemove(tabRealm)
      BNetData = Nothing
      ChatData = Nothing
      CRev = Nothing
      MCP = Nothing
      R_NLS = Nothing
      pctAd.Image = Nothing
      pctAd.Tag = Nothing
      W3Icons = Nothing
      pctAd.Size = New Size(1, 1)
      ChanList.Clear()
      ClanList.Clear()
      lvChannel.Items.Clear()
      imlList.Images.Clear()
      lvFriends.Items.Clear()
      lstChannels.Items.Clear()
      lvClan.Items.Clear()
      ChannelToggle(False)
      gChat.AddChat(GeckoChat.ChatType.ServiceError, IIf(bncs2, My.Resources.PROTOCOL_BNET2, My.Resources.PROTOCOL_BNCS), My.Resources.INFO_DISCONNECTED)
    End If
  End Sub

  Public Sub MCP_Disconnect(Optional ContinueLogin As Boolean = True)
    If sckMCP.IsConnected Then
      sckMCP.Disconnect()
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_MCP, My.Resources.INFO_DISCONNECTED)
    End If
    If sckBNCS.IsConnected And lblChannel.Tag Is Nothing And ContinueLogin Then
      GetUserData(Config.Account.Username, ProfileRequests.ProfileRequestType.AccountInfo, ProfileRequests.ProfileRequestDisplay.PrivateUI)
      BNCS_GETICONDATA_Send()
    End If
  End Sub

  Private Sub AttemptReconnect(sMessage As String, Optional lTime As UShort = UShort.MaxValue)
    If lTime = UShort.MaxValue Then lTime = Config.AutoReconnect
    If Config.AutoReconnect > 0 Then gChat.ReconnectAlert({sMessage, lTime})
  End Sub

  Friend NotInheritable Class BNFTPQueue
    Shared FileList As New Collection
    Shared Sub Getting(FileName As String)
      FileList.Add(FileName, FileName)
    End Sub
    Shared Sub Got(FileName As String)
      If FileList.Contains(FileName) Then FileList.Remove(FileName)
    End Sub
    Shared Function IsGetting(FileName As String) As Boolean
      Return FileList.Contains(FileName)
    End Function
  End Class

  Private Function BNFTPRequest(Platform As GameArch, Product As GameType, FileName As String, FileTime As Date, Optional BannerID As UInt32 = 0, Optional BannerExt As String = Nothing, Optional bResume As Boolean = False) As Boolean
    If BNFTPQueue.IsGetting(FileName) Then
      Do While BNFTPQueue.IsGetting(FileName)
        Thread.Sleep(50)
        'Application.DoEvents()
      Loop
      Return True
    End If
    BNFTPQueue.Getting(FileName)
    Dim bRet As Boolean = False
    Dim iTries As Integer = 0
    Do Until bRet
      Thread.Sleep(10)
      iTries += 1
      If iTries = 10 Then
        BNFTPQueue.Got(FileName)
        Return False
      End If
      Using BNFTP As New BNFTPv1(Platform, Product, FileName, FileTime, BannerID, BannerExt, bResume)
        BNFTP.Proxy = Config.Proxy
        BNFTP.Server = BNetData.ServerIP
        bRet = BNFTP.ExecuteRequest
      End Using
    Loop
    BNFTPQueue.Got(FileName)
    Return True
  End Function

  Private Function BNFTPRequest(Platform As GameArch, Product As GameType, FileName As String, FileTime As Date, CDKey As ProductKey, Optional BannerID As UInt32 = 0, Optional BannerExt As String = Nothing, Optional bResume As Boolean = False) As Boolean
    If BNFTPQueue.IsGetting(FileName) Then
      Do While BNFTPQueue.IsGetting(FileName)
        Thread.Sleep(50)
        'Application.DoEvents()
      Loop
      Return True
    End If
    BNFTPQueue.Getting(FileName)
    Using BNFTP As New BNFTPv2(Platform, Product, FileName, FileTime, CDKey, BannerID, BannerExt, bResume)
      BNFTP.Proxy = Config.Proxy
      BNFTP.Server = BNetData.ServerIP
      Dim iTries As Integer = 0
      Dim bRet As Boolean = False
      bRet = BNFTP.ExecuteRequest
      Do Until bRet
        Application.DoEvents()
        Thread.Sleep(10)
        iTries += 1
        If iTries = 10 Then
          BNFTPQueue.Got(FileName)
          Return False
        End If
        bRet = BNFTP.ExecuteRequest
      Loop
      BNFTPQueue.Got(FileName)
      Return True
    End Using
  End Function
#End Region

#Region "Realm Functions"
  Private Sub BeginRealmLogin()
    If Me.InvokeRequired Then
      Me.BeginInvoke(New MethodInvoker(AddressOf BeginRealmLogin))
    Else
      Realms.Status = D2Realm.RealmState.Offline
      DisplayRealmWaitMessage(My.Resources.REALM_STATUS_INIT)
      tbsLists.SelectedTab = tabRealm
    End If
  End Sub

  Private Sub DisplayRealmWaitMessage(Message As String)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf DisplayRealmWaitMessage), Message)
    Else
      If Not tbsLists.TabPages.Contains(tabRealm) Then TabAdd(tabRealm)
      pnlRealmState.Visible = True
      pnlRealmLogin.Visible = False
      pnlRealmChars.Visible = False
      pnlRealmNew.Visible = False
      lblRealmStatus.Text = Message
      cmdRealmStateCancel.Visible = False
      cmdRealmStateReconnect.Visible = False
    End If
  End Sub

  Private Sub DisplayRealmErrMessage(Message As String)
    If Me.InvokeRequired Then
      Me.Invoke(New CallBack(AddressOf DisplayRealmErrMessage), Message)
    Else
      Realms.Status = D2Realm.RealmState.Offline
      If Not tbsLists.TabPages.Contains(tabRealm) Then TabAdd(tabRealm)
      pnlRealmState.Visible = True
      pnlRealmLogin.Visible = False
      pnlRealmChars.Visible = False
      pnlRealmNew.Visible = False
      lblRealmStatus.Text = Message
      cmdRealmStateCancel.Visible = True
      cmdRealmStateReconnect.Visible = True
    End If
  End Sub

  Private Sub DisplayRealmListing(Auto As Boolean)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf DisplayRealmListing), Auto)
    Else
      Realms.Status = D2Realm.RealmState.RealmList
      If Not tbsLists.TabPages.Contains(tabRealm) Then TabAdd(tabRealm)
      pnlRealmState.Visible = False
      pnlRealmLogin.Visible = True
      pnlRealmChars.Visible = False
      pnlRealmNew.Visible = False
      lstRealms.Items.Clear()
      For Each realmItem As D2Realm.RealmList.Realm In Realms.RealmListing.GetRealms
        lstRealms.Items.Add(realmItem.Title)
      Next
      If lstRealms.Items.Count = 1 And Auto Then cmdRealmLogin_Click(New Object, New EventArgs)
    End If
  End Sub

  Private Sub DisplayRealmCharListing(Auto As Boolean)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf DisplayRealmCharListing), Auto)
    Else
      If Not tbsLists.TabPages.Contains(tabRealm) Then TabAdd(tabRealm)
      Realms.Status = D2Realm.RealmState.CharacterList
      pnlRealmState.Visible = False
      pnlRealmLogin.Visible = False
      pnlRealmChars.Visible = True
      pnlRealmNew.Visible = False
      lvRealmChars.Items.Clear()
      imlRealm.Images.Clear()
      If Realms.CharListing.Count > 0 Then
        For I As Integer = 0 To Realms.CharListing.Count - 1
          imlRealm.Images.Add("Char" & I.ToString, Realms.CharListing.GetChar(I).Icon)
          Dim lvItem As New ListViewItem(Realms.CharListing.GetChar(I).Character, "Char" & I.ToString)
          If Realms.CharListing.GetChar(I).Expires > 0 And Realms.CharListing.GetChar(I).Expires < &HFFFFFFFF& Then
            Dim ExpiresOn As Date = DateValue("1/1/1970").AddSeconds(Realms.CharListing.GetChar(I).Expires)
            Dim lAdd As Int64 = ((DateTime.UtcNow - DateTime.Now).TotalMinutes)
            Dim ExpiresIn As Int64 = DateDiff(DateInterval.Second, Now.AddMinutes(lAdd), ExpiresOn)
            If ExpiresIn > 0 Then
              If ConvertTime(ExpiresIn * 1000, True).Contains(",") Then
                lvItem.SubItems.Add(ConvertTime(ExpiresIn * 1000, True).Split(","c)(0))
              Else
                lvItem.SubItems.Add(ConvertTime(ExpiresIn * 1000, True))
              End If
            Else
              lvItem.SubItems.Add(My.Resources.REALM_STATUS_EXPIRED)
            End If
          ElseIf Realms.CharListing.GetChar(I).Expires = 0 Then
            lvItem.SubItems.Add("???")
          Else
            lvItem.SubItems.Add(My.Resources.REALM_STATUS_EXPIRED)
          End If
          lvRealmChars.Items.Add(lvItem)
        Next
        lvRealmChars.Items(0).Selected = True
        lvRealmChars_SelectedIndexChanged(New Object, New EventArgs)
        If lvRealmChars.Items.Count = 1 And Auto And lblChannel.Tag = Nothing Then cmdRealmCharLogin_Click(New Object, New EventArgs)
      Else
        cmdRealmCreate.Enabled = True
        cmdRealmUpgrade.Enabled = False
        cmdRealmDelete.Enabled = False
        cmdRealmCharLogin.Enabled = False
        cmdRealmCharCancel.Enabled = lblChannel.Tag = Nothing
        cmdRealmChange.Enabled = Realms.RealmListing.GetRealms.Length > 1
      End If
    End If
  End Sub

  Private Sub DisplayRealmCharCreate()
    If Me.InvokeRequired Then
      Me.BeginInvoke(New MethodInvoker(AddressOf DisplayRealmCharCreate))
    Else
      If Not tbsLists.TabPages.Contains(tabRealm) Then TabAdd(tabRealm)
      Realms.Status = D2Realm.RealmState.CharacterCreation
      pnlRealmState.Visible = False
      pnlRealmLogin.Visible = False
      pnlRealmChars.Visible = False
      pnlRealmNew.Visible = True
      chkExp.Enabled = (Config.Account.Client.Product = BNUI.GameType.D2XP)
      chkExp.Checked = chkExp.Enabled
      chkExp_CheckedChanged(New Object, New EventArgs)
    End If
  End Sub
#End Region

#Region "Properties"
  Public ReadOnly Property IsOnline As Boolean
    Get
      If GameIsBN2(Config.Account.Client.Product) Then
        If sckBN2 Is Nothing Then
          IsOnline = False
        Else
          IsOnline = sckBN2.IsConnected
        End If
      Else
        If sckBNCS Is Nothing Then
          IsOnline = False
        Else
          IsOnline = sckBNCS.IsConnected
        End If
      End If
    End Get
  End Property

  '0 = Offline
  '1 = Connecting
  '2 = Errored, Dropped
  '3 = Online
  '4 = Away
  '5 = DND
  '6 = Away & DND
  Public ReadOnly Property Status As Byte
    Get
      If bBNState < 3 Then Return bBNState
      If Not String.IsNullOrEmpty(ChatData.IsAway) Then
        If Not String.IsNullOrEmpty(ChatData.IsDnD) Then Return 6
        Return 4
      Else
        If Not String.IsNullOrEmpty(ChatData.IsDnD) Then Return 5
      End If
      Return 3
    End Get
  End Property

  Public ReadOnly Property Channel As String
    Get
      If lblChannel.Tag Is Nothing Then
        Channel = My.Resources.INFO_CONNECTING
      Else
        Channel = lblChannel.Tag.ToString
      End If
    End Get
  End Property

  Public ReadOnly Property AtBottom As Boolean
    Get
      If gChat IsNot Nothing Then Return gChat.AtBottom
      Return False
    End Get
  End Property

  Public Sub ToBottom()
    If gChat IsNot Nothing Then gChat.ToBottom()
  End Sub
#End Region

#Region "Useful Functions"
  Public Sub TabAdd(ByRef Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New ByRefCallBack(AddressOf TabAdd), Obj)
    Else
      Dim newTab As TabPage = Obj
      tbsLists.Controls.Add(newTab)
      frmMain.UpdatePreviewBitmap(Me.Tag)
    End If
  End Sub

  Public Sub TabRemove(ByRef Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New ByRefCallBack(AddressOf TabRemove), Obj)
    Else
      Dim delTab As TabPage = Obj
      tbsLists.Controls.Remove(delTab)
      frmMain.UpdatePreviewBitmap(Me.Tag)
    End If
  End Sub

  Private Sub AddPacket(Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf AddPacket), Obj)
    Else
      Dim Protocol As String = Obj(0)
      Dim Recv As Boolean = Obj(1)
      Dim ID As Byte = Obj(2)
      Dim Data() As Byte = Obj(3)
      If tbsLists.Controls.Contains(tabPacket) Then
        pktData.AddPacket(Protocol, Recv, ID, Data, Config.Account.Client.Product)
        'frmMain.UpdatePreviewBitmap(Me.Tag)
      End If
    End If
  End Sub

  Private Sub ChannelJoined(Obj As Object)
    If Me.InvokeRequired Then
      Me.Invoke(New CallBack(AddressOf ChannelJoined), Obj)
    Else
      Dim sChannel As String = Obj
      ChannelListing_Add(sChannel)
      lblChannel.Tag = sChannel
      ChanList.Clear()
      lvChannel.Items.Clear()
      imlList.Images.Clear()
      frmMain.UpdatePreviewBitmap(Me.Tag)
      ChannelUpdate()
    End If
  End Sub

  Private Sub ChannelToggle(Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf ChannelToggle), Obj)
    Else
      If CType(Obj, Boolean) Then
        lvChannel.Tag = "Updating"
        lvChannel.BeginUpdate()
      Else
        lvChannel.Tag = Nothing
        lvChannel.EndUpdate()
        If cmdListChannel.Visible Then
          cmdListChannel.Tag = Nothing
          cmdListChannel.Image = My.Resources.ListChannel
        End If
      End If
    End If
  End Sub

  Private Sub ChannelAdd(Username As String, Flags As UInt32, Ping As UInt32, StatString() As Byte)
    Dim bNew As Boolean = ChanList.FindItem(Username) = -1
    ChanList.AddItem(Username, Flags, Ping, StatString)
    If String.IsNullOrEmpty((From sTag As String In Config.TagSquelchList Where InStr(Username, sTag, CompareMethod.Text) > 0 Select sTag).FirstOrDefault) Then
      Dim bUnlisted As Boolean = String.IsNullOrEmpty((From sName As String In Config.SquelchList Where StrComp(sName, Username, CompareMethod.Text) = 0 Select sName).FirstOrDefault)
      If CBool(Flags And USER_SQUELCHED) Then
        If bUnlisted Then Config.SquelchList.Add(Username)
      ElseIf bNew Then
        If Not bUnlisted Then SquelchUser(Username)
      Else
        If Not bUnlisted Then Config.SquelchList.Remove(Username)
      End If
    Else
      Flags = Flags Or USER_TAGSQUELCHED
    End If
    Dim sStatString As String = Encoding.GetEncoding(LATIN_1).GetString(StatString)
    If String.IsNullOrEmpty(sStatString) Then sStatString = Encoding.GetEncoding(LATIN_1).GetString(ChanList.StatString(Username))
    If String.IsNullOrEmpty(sStatString) Then sStatString = "NULL"
    Dim sTT As String = ResString(My.Resources.USER_TOOLTIP, Username, ParseStatString(sStatString), UserFlags(Flags), IIf(Ping < 4294967295, Ping.ToString, "-1"))
    Dim Index As Integer = ChanList.FindItem(Username)
    ChannelItemUpdate({Username, sTT})
    ChannelIconsAdd(Username, sStatString, Flags, Ping)
    ChannelUpdate()
  End Sub

  Private Sub ChannelRemove(Obj As Object)
    If Me.InvokeRequired Then
      Me.Invoke(New CallBack(AddressOf ChannelRemove), Obj)
    Else
      Dim Username As String = CType(Obj, String)
      ChanList.RemoveItem(Username)
      If lvChannel.Items.Count > 0 Then
        Dim lvItem As ListViewItem = lvChannel.FindItemWithText(Username, False, 0, False)
        If lvItem IsNot Nothing Then lvChannel.Items.Remove(lvItem)
      End If
      While imlList.Images.ContainsKey(Username & "_Ping")
        imlList.Images.RemoveByKey(Username & "_Ping")
      End While
      While imlList.Images.ContainsKey(Username & "_Main")
        imlList.Images.RemoveByKey(Username & "_Main")
      End While
      ChannelUpdate()
      End If
  End Sub

  Private Sub ChannelItemUpdate(Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf ChannelItemUpdate), Obj)
    Else
      If lblChannel.Tag IsNot Nothing Then
        Dim Username As String = Obj(0)
        Dim ToolTip As String = Obj(1)
        Dim lvItem As ListViewItem = Nothing
        If lvChannel.Items.Count > 0 Then lvItem = lvChannel.FindItemWithText(Username, False, 0, False)
        If lvItem IsNot Nothing Then
          If ChanList.Flags(Username) And USER_CHANNELOP Then
            lvChannel.Items.Remove(lvItem)
            lvChannel.Items.Insert(0, lvItem)
          End If
        Else
          lvItem = New ListViewItem
          If ChanList.Flags(Username) And USER_CHANNELOP Then
            lvChannel.Items.Insert(0, lvItem)
          Else
            lvChannel.Items.Add(lvItem)
          End If
          If Not lvChannel.Columns(0).Width = lvChannel.ClientSize.Width - 18 Then lvChannel.Columns(0).Width = lvChannel.ClientSize.Width - 18
        End If
        lvItem.Text = Username
        lvItem.ToolTipText = ToolTip
        lvItem.SubItems.Add(String.Empty)
        If StrComp(Username, BNetData.UniqueName, CompareMethod.Text) = 0 Then
          lvItem.ForeColor = Color.Aqua
        ElseIf IsFriend(Username) Then
          lvItem.ForeColor = Color.Lime
        Else
          lvItem.ForeColor = Color.White
        End If
      End If
    End If
  End Sub

  Private Sub ChannelUpdate()
    If Me.InvokeRequired Then
      Me.BeginInvoke(New MethodInvoker(AddressOf ChannelUpdate))
    Else
      If lvChannel.Tag Is Nothing Then
        If lblChannel.Tag IsNot Nothing Then
          lblChannel.Text = lblChannel.Tag.ToString & " (" & ChanList.Length & ")"
          If Not lvChannel.Columns(0).Width = lvChannel.ClientSize.Width - 18 Then lvChannel.Columns(0).Width = lvChannel.ClientSize.Width - 18
          If lvChannel.Items.Count > 0 Then
            For Each lvItem In lvChannel.Items
              If imlList.Images.ContainsKey(lvItem.Text & "_Main") Then lvItem.ImageKey = lvItem.Text & "_Main"
              lvChannel.AddIconToSubitem(lvItem.Index, 1, imlList.Images.IndexOfKey(lvItem.Text & "_Ping"))
            Next
          End If
        Else
          lblChannel.Text = String.Empty
          lvChannel.Items.Clear()
        End If
      End If
    End If
  End Sub

  Private Sub ChannelIconsAdd(Username As String, StatString As String, Flags As UInt32, Ping As UInt32)
    Dim Product As String = StrReverse(StatString.Substring(0, 4))
    Dim icoBase As Image = New Bitmap(28, 14)
    Dim icoText As Integer = -1
    Dim icoTextColor As Brush = Brushes.White
    Dim icoTextShadow As Boolean = False
    Dim icoSpecial As String = String.Empty
    If My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\" & Product & ".png") Then icoBase = Image.FromFile(AppTemp & "\icons\icons\" & Product & ".png", True)
    If StatString.Length > 4 Then
      Select Case GameStringToGameType(Product)
        Case GameType.DRTL
          Dim Values() As String = Split(StatString.Substring(5), " ")
          If Values.Length = 9 Then
            If IsNumeric(Values(0)) And IsNumeric(Values(1)) And IsNumeric(Values(2)) Then
              If Values(1) + (Values(2) * 3) < 12 And Values(1) + (Values(2) * 3) > -1 Then
                icoBase = Image.FromFile(AppTemp & "\icons\" & Product & "\" & Trim(CStr(Values(1) + (Values(2) * 3))) & ".png", True)
                If Values(0) > Integer.MaxValue Then
                  icoText = -1
                Else
                  icoText = Values(0)
                End If

                icoTextColor = Brushes.White
                icoTextShadow = False
              End If
            End If
          End If
        Case GameType.DSHR
          Dim Values() As String = Split(StatString.Substring(5), " ")
          If Values.Length = 9 Then
            If IsNumeric(Values(0)) And IsNumeric(Values(1)) And IsNumeric(Values(2)) Then
              icoBase = Image.FromFile(AppTemp & "\icons\" & Product & "\0.png", True)
              icoText = Values(0)
              icoTextColor = Brushes.White
              icoTextShadow = False
            End If
          End If
        Case GameType.STAR, GameType.SEXP, GameType.JSTR
          Dim Values() As String = Split(StatString.Substring(5), " ")
          If Values.Length = 9 Then
            If IsNumeric(Values(3)) AndAlso Values(3) = 1 Then
              icoBase = Image.FromFile(AppTemp & "\icons\STAR\22.png", True)
              icoText = -1
              icoTextColor = Brushes.Yellow
              icoTextShadow = True
            ElseIf IsNumeric(Values(0)) AndAlso Values(0) > 0 Then
              icoText = Values(0)
              If Values(1) = 1 Then
                icoBase = Image.FromFile(AppTemp & "\icons\STAR\21.png", True)
              ElseIf Values(1) > 0 And Values(1) <= 1000 Then
                icoBase = Image.FromFile(AppTemp & "\icons\STAR\20.png", True)
              Else
                icoBase = Image.FromFile(AppTemp & "\icons\STAR\19.png", True)
              End If
              icoTextColor = Brushes.Yellow
              icoTextShadow = True
            ElseIf (IsNumeric(Values(2)) AndAlso Values(2) > 0) Then
              Dim iWins As UInt32 = Values(2)
              If iWins > 10 Then iWins = 10
              icoBase = Image.FromFile(AppTemp & "\icons\STAR\" & Trim(CStr(iWins + 8)) & ".png", True)
              icoText = -1
              icoTextColor = Brushes.Yellow
              icoTextShadow = True
            End If
          End If
          icoSpecial = IIf(StrReverse(Values(8)) = Product, String.Empty, StrReverse(Values(8)))
        Case GameType.W2BN
          Dim Values() As String = Split(StatString.Substring(5), " ")
          If Values.Length = 9 Then
            If IsNumeric(Values(3)) AndAlso Values(3) = 1 Then
              icoBase = Image.FromFile(AppTemp & "\icons\STAR\22.png", True)
              icoText = -1
              icoTextColor = Brushes.Yellow
              icoTextShadow = True
            ElseIf IsNumeric(Values(6)) AndAlso Values(6) > 0 Then
              icoText = Values(6)
              If Values(7) = 1 Then
                icoBase = Image.FromFile(AppTemp & "\icons\" & Product & "\33.png", True)
              Else
                icoBase = Image.FromFile(AppTemp & "\icons\" & Product & "\31.png", True)
              End If
              icoTextColor = New SolidBrush(Color.FromArgb(&HFF10B0FC))
              icoTextShadow = True
            ElseIf (IsNumeric(Values(0)) AndAlso Values(0) > 0) Then
              icoText = Values(0)
              If Values(1) = 1 Then
                icoBase = Image.FromFile(AppTemp & "\icons\" & Product & "\32.png", True)
              ElseIf Values(1) > 0 And Values(1) <= 1000 Then
                icoBase = Image.FromFile(AppTemp & "\icons\" & Product & "\20.png", True)
              Else
                icoBase = Image.FromFile(AppTemp & "\icons\" & Product & "\19.png", True)
              End If
              icoTextColor = New SolidBrush(Color.FromArgb(&HFF10B0FC))
              icoTextShadow = True
            ElseIf (IsNumeric(Values(2)) AndAlso Values(2) > 0) Then
              Dim iWins As UInt16 = Values(2)
              If iWins > 10 Then iWins = 10
              icoBase = Image.FromFile(AppTemp & "\icons\" & Product & "\" & Trim(CStr(iWins + 8)) & ".png", True)
              icoTextColor = New SolidBrush(Color.FromArgb(&HFF10B0FC))
              icoTextShadow = True
            End If
          End If
          icoSpecial = IIf(StrReverse(Values(8)) = Product, String.Empty, StrReverse(Values(8)))
        Case GameType.D2DV
          Dim D2String As String = StatString.Substring(5)
          D2String = D2String.Substring(D2String.IndexOf(","c) + 1)
          D2String = D2String.Substring(D2String.IndexOf(","c) + 1)
          Dim Values() As Byte = System.Text.Encoding.GetEncoding(LATIN_1).GetBytes(D2String)
          Dim CharClass As Byte = Values(13) - 1
          Dim CharLev As Byte = Values(25)
          Dim CharHC As Boolean = Values(26) And &H4
          Dim CharDead As Boolean = Values(26) And &H8
          If Not CharHC Then CharDead = False
          Dim CharExp As Boolean = Values(26) And &H20
          Dim CharLadder As Boolean = Not (Values(30) = &HFF)
          Dim CharAct As Byte = Values(27)
          Dim CharNew As Boolean = Values(28) = &H80 And CharAct = &H80
          Dim GroupNum As Byte
          If CharLadder Then
            If CharHC Then
              If CharDead Then
                GroupNum = 5
              Else
                GroupNum = 4
              End If
            Else
              GroupNum = 3
            End If
          Else
            If CharHC Then
              If CharDead Then
                GroupNum = 2
              Else
                GroupNum = 1
              End If
            Else
              GroupNum = 0
            End If
          End If
          If Values(0) <> &H84 Then Debug.Print("Value 0: " & Values(0) & " - " & Username & " " & CharLev & " " & Hex(CharAct) & " " & BitConverter.ToString(Values))
          If Values(1) <> &H80 Then Debug.Print("Value 1: " & Values(1) & " - " & Username & " " & CharLev & " " & Hex(CharAct) & " " & BitConverter.ToString(Values))
          If Values(31) <> &HFF Then Debug.Print("Value31: " & Values(31) & " - " & Username & " " & CharLev & " " & Hex(CharAct) & " " & BitConverter.ToString(Values))
          If Values(32) <> &HFF Then Debug.Print("Value32: " & Values(32) & " - " & Username & " " & CharLev & " " & Hex(CharAct) & " " & BitConverter.ToString(Values))
          Dim ActNum As Integer
          If CharAct >= &H80 And CharAct <= &H96 Then
            ActNum = (CharAct - &H80) / 2
          ElseIf CharAct = &H98 Then
            ActNum = 12
          Else
            ActNum = -1
          End If
          If ActNum > -1 Then
            Dim IcoNum As Integer = (GroupNum * (14 * 5)) + (CharClass * 14) + ActNum + IIf(CharNew, 0, 1)
            icoBase = Image.FromFile(AppTemp & "\icons\D2DV\" & IcoNum.ToString & ".png", True)
            icoText = CharLev
            icoTextColor = Brushes.White
            icoTextShadow = False
          Else
            icoText = -1
            icoSpecial = "D2DV"
          End If
        Case GameType.D2XP
          Dim D2String As String = StatString.Substring(5)
          D2String = D2String.Substring(D2String.IndexOf(","c) + 1)
          D2String = D2String.Substring(D2String.IndexOf(","c) + 1)
          Dim Values() As Byte = System.Text.Encoding.GetEncoding(LATIN_1).GetBytes(D2String)
          Dim CharClass As Byte = Values(13) - 1
          Dim CharLev As Byte = Values(25)
          Dim CharHC As Boolean = Values(26) And &H4
          Dim CharDead As Boolean = Values(26) And &H8
          If Not CharHC Then CharDead = False
          Dim CharExp As Boolean = Values(26) And &H20
          Dim CharLadder As Boolean = Not (Values(30) = &HFF)
          Dim CharAct As Byte = Values(27)
          Dim CharNew As Boolean = Values(28) = &H80 And CharAct = &H80
          Dim GroupNum As Byte
          If CharLadder Then
            If CharHC Then
              If CharDead Then
                GroupNum = 5
              Else
                GroupNum = 4
              End If
            Else
              GroupNum = 3
            End If
          Else
            If CharHC Then
              If CharDead Then
                GroupNum = 2
              Else
                GroupNum = 1
              End If
            Else
              GroupNum = 0
            End If
          End If
          If Values(0) <> &H84 Then Debug.Print("Value 0: " & Values(0) & " - " & Username & " " & CharLev & " " & Hex(CharAct) & " " & BitConverter.ToString(Values))
          If Values(1) <> &H80 Then Debug.Print("Value 1: " & Values(1) & " - " & Username & " " & CharLev & " " & Hex(CharAct) & " " & BitConverter.ToString(Values))
          If Values(31) <> &HFF Then Debug.Print("Value31: " & Values(31) & " - " & Username & " " & CharLev & " " & Hex(CharAct) & " " & BitConverter.ToString(Values))
          If Values(32) <> &HFF Then Debug.Print("Value32: " & Values(32) & " - " & Username & " " & CharLev & " " & Hex(CharAct) & " " & BitConverter.ToString(Values))
          If CharExp Then
            Dim ActNum As Integer
            If CharAct >= &H80 And CharAct <= &H9C Then
              ActNum = (CharAct - &H80) / 2
            ElseIf CharAct = &H9E Then
              ActNum = 15
            Else
              ActNum = -1
            End If
            If ActNum > -1 Then
              Dim IcoNum As Integer = (GroupNum * (17 * 7)) + (CharClass * 17) + ActNum + IIf(CharNew, 0, 1)
              icoBase = Image.FromFile(AppTemp & "\icons\D2XP\" & IcoNum.ToString & ".png", True)
              icoText = CharLev
              icoTextColor = Brushes.White
              icoTextShadow = False
            Else
              icoText = -1
              icoSpecial = "D2XP"
            End If
          Else
            Dim ActNum As Integer
            If CharAct >= &H80 And CharAct <= &H96 Then
              ActNum = (CharAct - &H80) / 2
            ElseIf CharAct = &H98 Then
              ActNum = 12
            Else
              ActNum = -1
            End If
            If ActNum > -1 Then
              Dim IcoNum As Integer = (GroupNum * (14 * 5)) + (CharClass * 14) + ActNum + IIf(CharNew, 0, 1)
              icoBase = Image.FromFile(AppTemp & "\icons\D2DV\" & IcoNum.ToString & ".png", True)
              icoText = CharLev
              icoTextColor = Brushes.White
              icoTextShadow = False
            Else
              icoText = -1
              icoSpecial = "D2DV"
            End If
          End If
        Case GameType.WAR3
          Dim Values() As String = Split(StatString.Substring(5), " ")
          If StrReverse(Values(0)).Substring(0, 2) = "W3" Then
            If StrReverse(Values(0)) = "W3R1" And IsNumeric(Values(1)) AndAlso Values(1) = 0 Then
              icoText = -1
            Else
              Dim sDef() As String = Split(My.Computer.FileSystem.ReadAllText(AppTemp & "\icons\WAR3\iconindex_def.txt"), vbNewLine)
              Dim sIco As String = (From sItm As String In sDef Where Not String.IsNullOrEmpty(sItm) AndAlso sItm.Substring(0, 4) = StrReverse(Values(0)) AndAlso My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\" & sItm.Substring(sItm.LastIndexOf("\") + 1) & ".png")).FirstOrDefault
              If Not String.IsNullOrEmpty(sIco) Then
                icoBase = Image.FromFile(AppTemp & "\icons\WAR3\" & sIco.Substring(sIco.LastIndexOf("\") + 1) & ".png", True)
                icoText = Values(1)
              Else
                icoText = -1
                icoSpecial = StrReverse(Values(0))
              End If
            End If
          Else
            icoText = -1
            icoSpecial = StrReverse(Values(0))
          End If
          icoTextColor = Brushes.White
          icoTextShadow = False
        Case GameType.W3XP
          Dim Values() As String = Split(StatString.Substring(5), " ")
          If StrReverse(Values(0)).Substring(0, 2) = "W3" Then
            If StrReverse(Values(0)) = "W3R1" And IsNumeric(Values(1)) AndAlso Values(1) = 0 Then
              icoText = -1
            ElseIf My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\iconindex_def2.txt") Then
              Dim sDef2() As String = Split(My.Computer.FileSystem.ReadAllText(AppTemp & "\icons\WAR3\iconindex_def2.txt"), vbNewLine)
              Dim sIco As String = (From sItm As String In sDef2 Where Not String.IsNullOrEmpty(sItm) AndAlso sItm.Substring(0, 4) = StrReverse(Values(0)) AndAlso My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\" & sItm.Substring(sItm.LastIndexOf("\") + 1) & ".png")).FirstOrDefault
              If Not String.IsNullOrEmpty(sIco) Then
                icoBase = Image.FromFile(AppTemp & "\icons\WAR3\" & sIco.Substring(sIco.LastIndexOf("\") + 1) & ".png", True)
                icoText = Values(1)
              Else
                icoText = -1
                icoSpecial = StrReverse(Values(0))
              End If
            Else
              icoText = -1
            End If
          Else
            icoText = -1
            icoSpecial = StrReverse(Values(0))
          End If
          icoTextColor = Brushes.White
          icoTextShadow = False
      End Select
    Else
      icoText = -1
    End If
    Dim imgIcon As Image
    If (Flags And USER_SQUELCHED) Then
      imgIcon = Image.FromFile(AppTemp & "\icons\icons\FLAG_" & Hex(USER_SQUELCHED) & ".png", True)
    ElseIf (Flags And USER_TAGSQUELCHED) Then
      imgIcon = Image.FromFile(AppTemp & "\icons\WAR3\battle-red.blp.png", True)
    Else
      If My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\bnet-unknown.blp.png") Then
        imgIcon = Image.FromFile(AppTemp & "\icons\WAR3\bnet-unknown.blp.png", True)
      Else
        imgIcon = New Bitmap(28, 14)
      End If
      If String.IsNullOrEmpty(icoSpecial) Then
        Dim bTry As Boolean = True
        If Not Flags = 0 Then
          For Each Flag As Int32 In GetAvailableFlags()
            If (Flags And Flag) And My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\FLAG_" & Hex(Flag) & ".png") Then
              imgIcon = Image.FromFile(AppTemp & "\icons\icons\FLAG_" & Hex(Flag) & ".png", True)
              bTry = False
            End If
          Next
        End If
        If bTry Then imgIcon = DrawIconText(icoBase, icoText, icoTextColor, Product, icoTextShadow)
      Else
        Select Case GameStringToGameType(Product)
          Case GameType.STAR, GameType.SEXP, GameType.JSTR
            If My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons_STAR\" & icoSpecial & ".png") Then imgIcon = Image.FromFile(AppTemp & "\icons\icons_STAR\" & icoSpecial & ".png", True)
          Case GameType.WAR3, GameType.W3XP
            Dim sExp() As String = Split(Replace(My.Computer.FileSystem.ReadAllText(AppTemp & "\icons\WAR3\iconindex_exp.txt"), "tga", "blp"), vbNewLine)
            Dim sIcon As String = (From sItem As String In sExp Where Not String.IsNullOrEmpty(sItem) AndAlso sItem.Substring(0, 4) = icoSpecial).FirstOrDefault
            If Not String.IsNullOrEmpty(sIcon) Then
              imgIcon = Image.FromFile(AppTemp & "\icons\WAR3\" & sIcon.Substring(sIcon.LastIndexOf("\") + 1) & ".png", True)
            End If
          Case Else
            If My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\" & icoSpecial & ".png") Then imgIcon = Image.FromFile(AppTemp & "\icons\icons\" & icoSpecial & ".png", True)
        End Select
      End If
    End If
    Dim PingIcon As Integer
    If Flags And USER_NOUDP Then
      PingIcon = 7
    Else
      Select Case Ping
        Case 0
          PingIcon = 0
        Case Is < 200
          PingIcon = 1
        Case Is < 300
          PingIcon = 2
        Case Is < 400
          PingIcon = 3
        Case Is < 500
          PingIcon = 4
        Case Is < 600
          PingIcon = 5
        Case Else
          PingIcon = 6
      End Select
    End If
    ChannelIconsSet({Username, imgIcon, imlPing.Images(PingIcon)})
  End Sub

  Private Sub ChannelIconsSet(Obj As Object)
    If Me.InvokeRequired Then
      Try
        Me.Invoke(New CallBack(AddressOf ChannelIconsSet), Obj)
      Catch ex As Exception
        Exit Sub
      End Try
    Else
      Dim Username As String = Obj(0)
      Dim imgIcon As Drawing.Image = Obj(1)
      Dim pingIcon As Drawing.Image = Obj(2)
      While imlList.Images.ContainsKey(Username & "_Ping")
        imlList.Images.RemoveByKey(Username & "_Ping")
      End While
      While imlList.Images.ContainsKey(Username & "_Main")
        imlList.Images.RemoveByKey(Username & "_Main")
      End While
      imlList.Images.Add(Username & "_Main", imgIcon)
      Dim NewImg As Image = New Bitmap(28, 14)
      If VisualStyles.VisualStyleInformation.DisplayName = "Aero style" Then
        Using g As Graphics = Graphics.FromImage(NewImg)
          g.Clear(Color.Transparent)
          g.DrawImage(pingIcon, New Rectangle(0, 0, 18, 14))
        End Using
      Else
        Using g As Graphics = Graphics.FromImage(NewImg)
          g.Clear(Color.Transparent)
          g.DrawImage(pingIcon, New Rectangle(0, 0, 28, 14))
        End Using
      End If
      imlList.Images.Add(Username & "_Ping", NewImg)
    End If
  End Sub

  Friend Function IsFriend(Username As String) As Boolean
    If Me.InvokeRequired Then
      Return Me.Invoke(New ReturnCallBack(AddressOf IsFriend), Username)
    Else
      Return Not String.IsNullOrEmpty((From lvItem As ListViewItem In lvFriends.Items Where StrComp(lvItem.Text, Username, CompareMethod.Text) = 0 Select lvItem.Text).FirstOrDefault)
    End If
  End Function

  Private Sub FriendAdd(Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf FriendAdd), New Object() {Obj})
    Else
      Dim Index As Byte = Obj(0)
      Dim Username As String = Obj(1)
      Dim Status As Byte = Obj(2)
      Dim Location As Byte = Obj(3)
      Dim Product As GameType = Obj(4)
      Dim sLocation As String = Obj(5)
      Dim bFound As Boolean = False
      Dim lvItem As ListViewItem = Nothing
      If Index < 255 Then If lvFriends.Items.Count > Index Then lvItem = lvFriends.Items(Index)
      If lvItem IsNot Nothing Then bFound = True
      If Not bFound Then lvItem = New ListViewItem
      Dim sProd As String = Product.ToString
      With lvItem
        If String.IsNullOrEmpty(Username) Then
          Username = .Text
        Else
          .Text = Username
        End If
        Select Case Product
          Case GameType.DRTL
            .ImageIndex = 0
          Case GameType.DSHR
            .ImageIndex = 1
          Case GameType.D2DV
            .ImageIndex = 2
          Case GameType.D2XP
            .ImageIndex = 3
          Case GameType.STAR
            .ImageIndex = 4
          Case GameType.SEXP
            .ImageIndex = 5
          Case GameType.JSTR
            .ImageIndex = 6
          Case GameType.SSHR
            .ImageIndex = 7
          Case GameType.W2BN
            .ImageIndex = 8
          Case GameType.WAR3
            .ImageIndex = 9
          Case GameType.W3XP
            .ImageIndex = 10
          Case Else
            If sProd = "CHAT" Then
              .ImageIndex = 11
            ElseIf sProd = "0" Then
              .ImageIndex = 12
            Else
              .ImageIndex = 13
            End If
        End Select
        Dim lvSubItem As New ListViewItem.ListViewSubItem
        Dim sStatus As String = String.Empty
        If Status And &H1 Then sStatus &= My.Resources.FRIEND_STATUS_1
        If Status And &H4 Then sStatus &= My.Resources.FRIEND_STATUS_4
        If Status And &H2 Then sStatus &= My.Resources.FRIEND_STATUS_2
        If String.IsNullOrEmpty(sStatus) Then sStatus = IIf(Location = 0 Or Location = 1, My.Resources.INFO_DISCONNECTED, My.Resources.INFO_AWAY_AVAILABLE)
        Dim sLoc As String = String.Empty
        Select Case Location
          Case &H0 : sLoc = My.Resources.FRIEND_LOCATION_0
          Case &H1 : sLoc = My.Resources.FRIEND_LOCATION_1
          Case &H2
            If String.IsNullOrEmpty(sLocation) Then
              sLoc = My.Resources.FRIEND_LOCATION_2_NULL
            Else
              sLoc = ResString(My.Resources.FRIEND_LOCATION_2, sLocation)
            End If
          Case &H3
            If String.IsNullOrEmpty(sLocation) Then
              sLoc = My.Resources.FRIEND_LOCATION_3_NULL
            Else
              sLoc = ResString(My.Resources.FRIEND_LOCATION_3, sLocation)
            End If
          Case &H4, &H5
            If String.IsNullOrEmpty(sLocation) Then
              sLoc = My.Resources.FRIEND_LOCATION_4_NULL
            Else
              sLoc = ResString(My.Resources.FRIEND_LOCATION_4, sLocation)
            End If
        End Select
        .ToolTipText = ResString(My.Resources.FRIEND_TOOLTIP, Username, sStatus, sLoc)
        .SubItems.Add(lvSubItem)
        .Tag = New ArrayList({Username, Status, Location, Product, sLocation})
      End With
      If Not bFound Then lvFriends.Items.Add(lvItem)
      FriendUpdate()
      Dim lvChanItem As ListViewItem = (From lvTemp As ListViewItem In lvChannel.Items Where lvTemp.Text = Username).FirstOrDefault
      If lvChanItem IsNot Nothing Then lvChanItem.ForeColor = Color.Lime
    End If
  End Sub

  Private Sub FriendRemove(Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf FriendRemove), New Object() {Obj})
    Else
      Dim bIndex As Byte = Obj
      Dim lvItem As ListViewItem
      If lvFriends.Items.Count > bIndex Then
        lvItem = lvFriends.Items(bIndex)
        lvFriends.Items.Remove(lvItem)
        FriendUpdate()
      End If
    End If
  End Sub

  Private Sub FriendClear()
    If Me.InvokeRequired Then
      Me.BeginInvoke(New MethodInvoker(AddressOf FriendClear))
    Else
      lvFriends.Items.Clear()
      FriendUpdate()
    End If
  End Sub

  Private Sub FriendUpdate()
    If Me.InvokeRequired Then
      Me.BeginInvoke(New MethodInvoker(AddressOf FriendUpdate))
    Else
      lblFriends.Text = ResString(My.Resources.TITLE_FRIENDS, lvFriends.Items.Count)
      frmMain.UpdatePreviewBitmap(Me.Tag)
    End If
  End Sub

  Private Sub ClanAdd([Username] As String, [Rank] As Byte, [Status] As Byte, [Location] As String)
    ClanList.AddItem(Username, Rank, Status, Location)
  End Sub

  Private Sub ClanRemove(Username As String)
    ClanList.RemoveItem(Username)
    ClanUpdate()
  End Sub

  Private Sub ClanUpdate()
    If Me.InvokeRequired Then
      Me.BeginInvoke(New MethodInvoker(AddressOf ClanUpdate))
    Else
      If Not String.IsNullOrEmpty(ChatData.ClanTag) Then
        If ClanList.Length = 0 Then
          lvClan.Items.Clear()
        Else
          For Each lvItem As ListViewItem In lvClan.Items
            lvItem.Tag = -1
          Next
          lvClan.SuspendLayout()
          For I = 0 To ClanList.Length - 1
            Dim lvItem As ListViewItem = Nothing
            If lvClan.Items.Count > 0 Then lvItem = lvClan.FindItemWithText(ClanList.Username(I), False, 0, False)
            Dim bNew As Boolean = False
            Dim bChanged As Boolean = False
            If lvItem Is Nothing Then
              bNew = True
              lvItem = New ListViewItem
              bChanged = True
            End If
            With lvItem
              .Text = ClanList.Username(I)
              Dim sTT As String = ClanList.Username(I) & " (" & IIf(ClanList.Status(I) = 1, "Online", "Offline") & ")" & vbNewLine & ClanRankToString(ClanList.Rank(I)) & IIf(String.IsNullOrEmpty(ClanList.Location(I)), String.Empty, vbNewLine & ClanList.Location(I))
              If StrComp(.ToolTipText, sTT) <> 0 Then
                .ToolTipText = sTT
                bChanged = True
              End If
              If .SubItems.Count = 0 Then .SubItems.Add(String.Empty)
              If ClanList.Rank(I) = 4 Then
                If Not bNew Then lvClan.Items.Remove(lvItem)
                lvClan.Items.Insert(0, lvItem)
              ElseIf ClanList.Rank(I) = 3 Then
                If Not bNew Then lvClan.Items.Remove(lvItem)
                Dim iPos As Integer = 1
                While iPos < lvClan.Items.Count AndAlso ClanList.Rank(lvClan.Items(iPos).Text) > 2
                  iPos += 1
                End While
                If iPos > lvClan.Items.Count Then iPos = lvClan.Items.Count
                lvClan.Items.Insert(iPos, lvItem)
              ElseIf ClanList.Rank(I) = 2 Then
                If Not bNew Then lvClan.Items.Remove(lvItem)
                Dim iPos As Integer = 2
                While iPos < lvClan.Items.Count AndAlso ClanList.Rank(lvClan.Items(iPos).Text) > 1
                  iPos += 1
                End While
                If iPos > lvClan.Items.Count Then iPos = lvClan.Items.Count
                lvClan.Items.Insert(iPos, lvItem)
              Else
                If bNew Then lvClan.Items.Add(lvItem)
              End If
              .Tag = I
              If ClanList.Status(I) = 1 Then
                .ImageIndex = ClanList.Rank(I)
              Else
                .ImageIndex = 5
              End If
            End With
          Next
          lvClan.ResumeLayout()
          If lvClan.Columns.Count > 0 Then If Not lvClan.Columns(0).Width = lvClan.ClientSize.Width Then lvClan.Columns(0).Width = lvClan.ClientSize.Width
        End If
        lblClan.Text = "Clan " & ChatData.ClanTag & " (" & lvClan.Items.Count & ")"
      Else
        lvClan.Items.Clear()
      End If
      frmMain.UpdatePreviewBitmap(Me.Tag)
    End If
  End Sub

  Public Sub SetMotD(Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf SetMotD), Obj)
    Else
      txtClanMotD.Text = CType(Obj, String)
    End If
  End Sub

  Private Sub ChannelListing_Clear()
    If Me.InvokeRequired Then
      Me.BeginInvoke(New MethodInvoker(AddressOf ChannelListing_Clear))
    Else
      lstChannels.Items.Clear()
    End If
  End Sub

  Private Sub ChannelListing_Add(Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf ChannelListing_Add), Obj)
    Else
      Dim Channel As String = Obj
      Dim bNew As Boolean = True
      For I As Integer = 0 To lstChannels.Items.Count - 1
        If String.Compare(lstChannels.Items(I), Channel, True) = 0 Then
          lstChannels.Items.RemoveAt(I)
          lstChannels.Items.Insert(I, Obj)
          bNew = False
          Exit For
        End If
      Next
      If bNew Then lstChannels.Items.Add(Obj)
    End If
  End Sub

  Private Sub AddToLastTen(Command As String)
    Dim iFound = LastTenCommands.Select(Function(Item, Index) New With {.Item = Item, .Index = Index}).Where(Function(Item, Index) StrComp(Item.Item, Command, CompareMethod.Text) = 0)(0)
    If iFound Is Nothing Then
      For I As Integer = 9 To 1 Step -1
        LastTenCommands(I) = LastTenCommands(I - 1)
      Next
      LastTenCommands(0) = Command
    Else
      For I As Integer = iFound.Index To 1 Step -1
        LastTenCommands(I) = LastTenCommands(I - 1)
      Next
      LastTenCommands(0) = Command
    End If
  End Sub

  Private Sub GetEndPoint(Optional Port As Integer = 6112)
    If BNetData.ServerIP Is Nothing Then Exit Sub
    udpRemoteEndPoint = New IPEndPoint(BNetData.ServerIP, 6112)
    Dim Host As IPAddress = (From ipList In Dns.GetHostEntry(System.Net.Dns.GetHostName).AddressList Where ipList.AddressFamily = AddressFamily.InterNetwork).FirstOrDefault
    If Host IsNot Nothing Then
      udpEndPoint = New IPEndPoint(Host, Port)
      Try
        If Not sckUDP.Bind(udpEndPoint) Then GetEndPoint(Port + 1)
      Catch ex As Exception
        GetEndPoint(Port + 1)
      End Try
    End If
  End Sub

  Private Function GetHashProd() As String
    Dim sProd As String = Config.Account.Client.Product.ToString
    If sProd = "SEXP" Then sProd = "STAR"
    If sProd = "W3XP" Then sProd = "WAR3"
    Return sProd
  End Function

  Private Function GetProd() As BNUI.GameType
    Dim sProd As BNUI.GameType = Config.Account.Client.Product
    If sProd = BNUI.GameType.SEXP Then sProd = BNUI.GameType.STAR
    If sProd = BNUI.GameType.D2XP Then sProd = BNUI.GameType.D2DV
    If sProd = BNUI.GameType.W3XP Then sProd = BNUI.GameType.WAR3
    Return sProd
  End Function

  Private Function CheckHashFiles() As Boolean
    Dim sHashes(2) As String
    Dim sBIN As String = String.Empty
    GetHashFiles(sHashes, sBIN)
    CheckHashFiles = True
    CheckHashFiles = (From Hash As String In sHashes Where Not My.Computer.FileSystem.FileExists(Hash)).FirstOrDefault Is Nothing
    If Not String.IsNullOrEmpty(sBIN) Then If Not My.Computer.FileSystem.FileExists(sBIN) Then CheckHashFiles = False
  End Function

  Private Sub GetHashFiles(ByRef HashFiles() As String, ByRef BINFile As String)
    Select Case Config.Account.Client.Product
      Case GameType.STAR, GameType.SEXP
        HashFiles(0) = Config.HashPath & "STAR\Starcraft.exe"
        HashFiles(1) = Config.HashPath & "STAR\Storm.dll"
        HashFiles(2) = Config.HashPath & "STAR\Battle.snp"
        BINFile = Config.HashPath & "STAR\STAR.bin"
      Case GameType.SSHR
        HashFiles(0) = Config.HashPath & "SSHR\Starcraft.exe"
        HashFiles(1) = Config.HashPath & "SSHR\Storm.dll"
        HashFiles(2) = Config.HashPath & "SSHR\Battle.snp"
        BINFile = Config.HashPath & "SSHR\STAR.bin"
      Case GameType.JSTR
        HashFiles(0) = Config.HashPath & "JSTR\StarcraftJ.exe"
        HashFiles(1) = Config.HashPath & "JSTR\Storm.dll"
        HashFiles(2) = Config.HashPath & "JSTR\Battle.snp"
        BINFile = Config.HashPath & "JSTR\STAR.bin"
      Case GameType.W2BN
        HashFiles(0) = Config.HashPath & "W2BN\Warcraft II BNE.exe"
        HashFiles(1) = Config.HashPath & "W2BN\Storm.dll"
        HashFiles(2) = Config.HashPath & "W2BN\Battle.snp"
        BINFile = Config.HashPath & "W2BN\W2BN.bin"
      Case GameType.D2DV, GameType.D2XP
        HashFiles(0) = Config.HashPath & Config.Account.Client.Product.ToString & "\Game.exe"
        HashFiles(1) = Config.HashPath & Config.Account.Client.Product.ToString & "\Bnclient.dll"
        HashFiles(2) = Config.HashPath & Config.Account.Client.Product.ToString & "\D2client.dll"
      Case GameType.WAR3, GameType.W3XP
        HashFiles(0) = Config.HashPath & "WAR3\War3.exe"
        HashFiles(1) = Config.HashPath & "WAR3\Storm.dll"
        HashFiles(2) = Config.HashPath & "WAR3\Game.dll"
      Case GameType.DRTL
        HashFiles(0) = Config.HashPath & "DRTL\Diablo.exe"
        HashFiles(1) = Config.HashPath & "DRTL\Storm.dll"
        HashFiles(2) = Config.HashPath & "DRTL\Battle.snp"
        BINFile = Config.HashPath & "DRTL\DRTL.bin"
      Case GameType.DSHR
        HashFiles(0) = Config.HashPath & "DSHR\Diablo_s.exe"
        HashFiles(1) = Config.HashPath & "DSHR\Storm.dll"
        HashFiles(2) = Config.HashPath & "DSHR\Battle.snp"
        BINFile = Config.HashPath & "DSHR\DRTL.bin"
    End Select
  End Sub

  Private Sub DoIdle()
    If lblChannel.Tag IsNot Nothing And Config.Idle.IdleOn Then
      Static LastSong As String
      Static LastMsg As Int32
      If LastMsg = 0 Then LastMsg = Environment.TickCount
      If Config.Idle.IdleOnSong Then
        Dim ThisSong As String = MPControls.GetSong
        If LastSong <> ThisSong And Environment.TickCount - LastMsg >= 30 * 1000 And (Not String.IsNullOrEmpty(ThisSong)) And InStr(ThisSong, " - ") > 0 Then
          QueueMessage(IdleMessage)
          LastSong = ThisSong
          LastMsg = Environment.TickCount
        End If
      Else
        If Environment.TickCount - LastMsg >= Config.Idle.IdleTime * 60 * 1000 Then
          QueueMessage(IdleMessage)
          LastMsg = Environment.TickCount
        End If
      End If
    End If
    If Config.AutoAway > 0 Then
      Dim lAway As Integer = Config.AutoAway * 1000 * 60
      Dim MeUser = (From User As ListViewItem In lvChannel.Items Where StrComp(User.Text, BNetData.UniqueName, CompareMethod.Text) = 0 Select User Take 1).FirstOrDefault
      If MeUser IsNot Nothing Then
        Dim lSpoke As Integer = Environment.TickCount - ChanList.LastMessageTime(MeUser.Text)
        If (lSpoke < lAway) AndAlso MeUser.ForeColor = Color.Gray Then
          SendMessage("/away")
        ElseIf (lSpoke >= lAway) AndAlso MeUser.ForeColor = Color.Aqua Then
          SendMessage("/away Idle")
        End If
      End If
      Dim IdleUsers = From User As ListViewItem In lvChannel.Items Where (Environment.TickCount - ChanList.LastMessageTime(User.Text) >= lAway) AndAlso (User.ForeColor = Color.White Or User.ForeColor = Color.Lime Or User.ForeColor = Color.Aqua) Select User
      For Each User As ListViewItem In IdleUsers
        User.ForeColor = Color.Gray
      Next
      Dim NotIdleUsers = From User As ListViewItem In lvChannel.Items Let lSpoke = Environment.TickCount - ChanList.LastMessageTime(User.Text) Where (lSpoke < lAway) AndAlso (User.ForeColor = Color.Gray Or (User.ForeColor = Color.White And IsFriend(User.Text)) Or (User.ForeColor = Color.Lime And Not IsFriend(User.Text))) Select User
      For Each User As ListViewItem In NotIdleUsers
        If StrComp(BNetData.UniqueName, User.Text, CompareMethod.Text) = 0 Then
          User.ForeColor = Color.Aqua
        ElseIf IsFriend(User.Text) Then
          User.ForeColor = Color.Lime
        Else
          User.ForeColor = Color.White
        End If
      Next
    End If
    If BNetData.LastPing > 0 Then
      If Not lblChannel.BackColor = IIf(Math.Floor((Environment.TickCount - BNetData.LastPing) / 1000) >= 150, Color.DarkRed, Color.Black) Then lblChannel.BackColor = IIf(Math.Floor((Environment.TickCount - BNetData.LastPing) / 1000) >= 150, Color.DarkRed, Color.Black)
      If Math.Floor((Environment.TickCount - BNetData.LastPing) / 1000) = 180 Then
        BNCS_Disconnect(True)
        AttemptReconnect(My.Resources.ERR_TIMEOUT)
      End If
    Else
      If Not lblChannel.BackColor = Color.Black Then lblChannel.BackColor = Color.Black
    End If
    If LastChanUpdate > 0 Then
      If LastChanUpdate < BNetData.LastPing Then
        ChannelToggle(False)
        ChannelUpdate()
        LastChanUpdate = 0
      End If
    End If
  End Sub

  Private Sub UpdateIdle([Username] As String, [Message] As String)
    If Config.AutoAway > 0 And ChanList.Length > 0 Then
      ChanList.SaysSomething(Username, Message)
    End If
  End Sub

  Private Function IdleMessage() As String
    Dim sMsg As String = Config.Idle.IdleText
    Dim rndUser As Integer = Int(Rnd() * ChanList.Length)
    Dim sQuote As String
    If My.Computer.FileSystem.FileExists(AppData & "\Quotes.txt") Then
      Dim sQuotes() As String = Split(My.Computer.FileSystem.ReadAllText(AppData & "\Quotes.txt"), vbNewLine)
      Dim lQuote As Integer = Int(Rnd() * sQuotes.Length)
      sQuote = sQuotes(lQuote)
    Else
      sQuote = My.Resources.ERR_QUOTES_NONE
    End If
    sMsg = Replace(sMsg, "%1", BNetData.UniqueName)
    If String.IsNullOrEmpty(ChatData.IsAway) Then
      If String.IsNullOrEmpty(ChatData.IsDnD) Then
        sMsg = Replace(sMsg, "%a", My.Resources.INFO_AWAY_AVAILABLE)
      Else
        sMsg = Replace(sMsg, "%a", ChatData.IsDnD)
      End If
    Else
      If String.IsNullOrEmpty(ChatData.IsDnD) Then
        sMsg = Replace(sMsg, "%a", ChatData.IsAway)
      Else
        sMsg = Replace(sMsg, "%a", ChatData.IsAway & "/" & ChatData.IsDnD)
      End If
    End If
    sMsg = Replace(sMsg, "%b", ConvertTime(Environment.TickCount - StartTime, True))
    sMsg = Replace(sMsg, "%c", lblChannel.Tag.ToString)
    sMsg = Replace(sMsg, "%d", Now.Month & "/" & Now.Day & "/" & Now.Year)
    sMsg = Replace(sMsg, "%l", ConvertTime((ChatData.TimeLogged * 1000) + (Environment.TickCount - ChatData.LoginTime), True))
    sMsg = Replace(sMsg, "%o", ConvertTime(Environment.TickCount - ChatData.LoginTime, True))
    sMsg = Replace(sMsg, "%p", IIf(ChanList.Ping(rndUser) < 4294967295, ChanList.Ping(rndUser).ToString, "-1"))
    sMsg = Replace(sMsg, "%q", sQuote)
    sMsg = Replace(sMsg, "%r", ChanList.Username(rndUser))
    sMsg = Replace(sMsg, "%s", MPControls.GetSong)
    sMsg = Replace(sMsg, "%t", TimeOfDay.ToString(Config.Display.TimeStamp))
    sMsg = Replace(sMsg, "%u", ConvertTime(Environment.TickCount, True))
    sMsg = Replace(sMsg, "%v", "Entelechy " & Version)
    Return sMsg
  End Function

  Public Sub GetUserData(Account As String, DataType As ProfileRequests.ProfileRequestType, Display As ProfileRequests.ProfileRequestDisplay, Optional Client As String = "DRTL", Optional WhisperTo As String = Nothing)
    Static lLastRequest As Integer
    If lLastRequest > 0 Then
      Do While Environment.TickCount - lLastRequest < 2500
        Thread.Sleep(100)
      Loop
    End If
    lLastRequest = Environment.TickCount
    If Not String.IsNullOrEmpty(Client) Then Client = Client.ToUpper
    If Account.Contains("#") AndAlso IsNumeric(Split(Account, "#", 2)(1)) Then Account = Split(Account, "#", 2)(0)
    Select Case Client
      Case "FIND"
        Dim lCookie As UInt32 = ProfileRequestList.AddRequest({Account}, DataType, Display, frmProfile.UpdateTypes.FIND, WhisperTo)
        Dim sKeys(4) As String
        sKeys(0) = "record\STAR\0\last game"
        sKeys(1) = "record\SEXP\0\last game"
        sKeys(2) = "record\JSTR\0\last game"
        sKeys(3) = "record\SSHR\0\last game"
        sKeys(4) = "record\W2BN\0\last game"
        BNCS_READUSERDATA_Send(lCookie, {Account}, sKeys)
      Case "DRTL", "DSHR", "D2DV", "D2XP", "STAR", "SEXP", "JSTR", "SSHR", "W2BN"
        Dim sKeys() As String
        Dim lCookie As UInt32
        Dim UpdateType As frmProfile.UpdateTypes
        Select Case Client
          Case "STAR"
            UpdateType = frmProfile.UpdateTypes.STAR
          Case "SEXP"
            UpdateType = frmProfile.UpdateTypes.SEXP
          Case "JSTR"
            UpdateType = frmProfile.UpdateTypes.JSTR
          Case "SSHR"
            UpdateType = frmProfile.UpdateTypes.SSHR
          Case "W2BN"
            UpdateType = frmProfile.UpdateTypes.W2BN
          Case Else
            UpdateType = frmProfile.UpdateTypes.Account
        End Select
        Select Case DataType
          Case ProfileRequests.ProfileRequestType.UserProfile
            lCookie = ProfileRequestList.AddRequest({Account}, DataType, Display, frmProfile.UpdateTypes.Account, WhisperTo)
            ReDim sKeys(3)
            sKeys(0) = "profile\sex"
            sKeys(1) = "profile\age"
            sKeys(2) = "profile\location"
            sKeys(3) = "profile\description"
          Case ProfileRequests.ProfileRequestType.AccountInfo
            lCookie = ProfileRequestList.AddRequest({Account}, DataType, Display, frmProfile.UpdateTypes.Account, WhisperTo)
            ReDim sKeys(14)
            sKeys(0) = "System\Account Created"
            sKeys(1) = "System\AuthLevel"
            sKeys(2) = "System\Flags"
            sKeys(3) = "System\Friends"
            sKeys(4) = "System\Icon"
            sKeys(5) = "System\IP"
            sKeys(6) = "System\Last Logoff"
            sKeys(7) = "System\Last Logon"
            sKeys(8) = "System\League"
            sKeys(9) = "System\MFT Bytes"
            sKeys(10) = "System\MFT Last Write"
            sKeys(11) = "System\MFT Time Logged"
            sKeys(12) = "System\Port"
            sKeys(13) = "System\Time Logged"
            sKeys(14) = "System\Username"
          Case ProfileRequests.ProfileRequestType.NormalGameRecord
            lCookie = ProfileRequestList.AddRequest({Account}, DataType, Display, UpdateType, WhisperTo)
            ReDim sKeys(4)
            sKeys(0) = "record\" & Client & "\0\wins"
            sKeys(1) = "record\" & Client & "\0\losses"
            sKeys(2) = "record\" & Client & "\0\disconnects"
            sKeys(3) = "record\" & Client & "\0\last game result"
            sKeys(4) = "record\" & Client & "\0\last game"
          Case ProfileRequests.ProfileRequestType.LadderGameRecord
            lCookie = ProfileRequestList.AddRequest({Account}, DataType, Display, UpdateType, WhisperTo)
            ReDim sKeys(7)
            sKeys(0) = "record\" & Client & "\1\wins"
            sKeys(1) = "record\" & Client & "\1\losses"
            sKeys(2) = "record\" & Client & "\1\disconnects"
            sKeys(3) = "record\" & Client & "\1\last game result"
            sKeys(4) = "record\" & Client & "\1\last game"
            sKeys(5) = "record\" & Client & "\1\rating"
            sKeys(6) = "record\" & Client & "\1\high rating"
            sKeys(7) = "DynKey\" & Client & "\1\rank"
          Case ProfileRequests.ProfileRequestType.IronManGameRecord
            lCookie = ProfileRequestList.AddRequest({Account}, DataType, Display, UpdateType, WhisperTo)
            ReDim sKeys(7)
            sKeys(0) = "record\W2BN\3\wins"
            sKeys(1) = "record\W2BN\3\losses"
            sKeys(2) = "record\W2BN\3\disconnects"
            sKeys(3) = "record\W2BN\3\last game result"
            sKeys(4) = "record\W2BN\3\last game"
            sKeys(5) = "record\W2BN\3\rating"
            sKeys(6) = "record\W2BN\3\high rating"
            sKeys(7) = "DynKey\W2BN\3\rank"
          Case ProfileRequests.ProfileRequestType.NormalLadderGameRecord
            lCookie = ProfileRequestList.AddRequest({Account}, DataType, Display, UpdateType, WhisperTo)
            ReDim sKeys(12)
            sKeys(0) = "record\" & Client & "\0\wins"
            sKeys(1) = "record\" & Client & "\0\losses"
            sKeys(2) = "record\" & Client & "\0\disconnects"
            sKeys(3) = "record\" & Client & "\0\last game result"
            sKeys(4) = "record\" & Client & "\0\last game"
            sKeys(5) = "record\" & Client & "\1\wins"
            sKeys(6) = "record\" & Client & "\1\losses"
            sKeys(7) = "record\" & Client & "\1\disconnects"
            sKeys(8) = "record\" & Client & "\1\last game result"
            sKeys(9) = "record\" & Client & "\1\last game"
            sKeys(10) = "record\" & Client & "\1\rating"
            sKeys(11) = "record\" & Client & "\1\high rating"
            sKeys(12) = "DynKey\" & Client & "\1\rank"
          Case ProfileRequests.ProfileRequestType.NormalLadderIronManGameRecord
            lCookie = ProfileRequestList.AddRequest({Account}, DataType, Display, UpdateType, WhisperTo)
            ReDim sKeys(20)
            sKeys(0) = "record\" & Client & "\0\wins"
            sKeys(1) = "record\" & Client & "\0\losses"
            sKeys(2) = "record\" & Client & "\0\disconnects"
            sKeys(3) = "record\" & Client & "\0\last game result"
            sKeys(4) = "record\" & Client & "\0\last game"
            sKeys(5) = "record\" & Client & "\1\wins"
            sKeys(6) = "record\" & Client & "\1\losses"
            sKeys(7) = "record\" & Client & "\1\disconnects"
            sKeys(8) = "record\" & Client & "\1\last game result"
            sKeys(9) = "record\" & Client & "\1\last game"
            sKeys(10) = "record\" & Client & "\1\rating"
            sKeys(11) = "record\" & Client & "\1\high rating"
            sKeys(12) = "DynKey\" & Client & "\1\rank"
            sKeys(13) = "record\W2BN\3\wins"
            sKeys(14) = "record\W2BN\3\losses"
            sKeys(15) = "record\W2BN\3\disconnects"
            sKeys(16) = "record\W2BN\3\last game result"
            sKeys(17) = "record\W2BN\3\last game"
            sKeys(18) = "record\W2BN\3\rating"
            sKeys(19) = "record\W2BN\3\high rating"
            sKeys(20) = "DynKey\W2BN\3\rank"
          Case Else
            lCookie = ProfileRequestList.AddRequest({Account}, DataType, Display, frmProfile.UpdateTypes.Account, WhisperTo)
            ReDim sKeys(0)
            sKeys(0) = "System\Username"
        End Select
        BNCS_READUSERDATA_Send(lCookie, {Account}, sKeys)
      Case "WAR3", "W3XP"
        Select Case DataType
          Case ProfileRequests.ProfileRequestType.UserProfile
            If Config.Account.Client.Product = GameType.WAR3 Or Config.Account.Client.Product = GameType.W3XP Then
              BNCS_PROFILE_Send(ProfileRequestList.AddRequest({Account}, DataType, Display, frmProfile.UpdateTypes.Account, WhisperTo), Account)
            Else
              BNCS_READUSERDATA_Send(ProfileRequestList.AddRequest({Account}, DataType, Display, frmProfile.UpdateTypes.Account, WhisperTo), {Account}, {"profile\sex", "profile\age", "profile\location", "profile\description"})
            End If
          Case ProfileRequests.ProfileRequestType.NormalGameRecord
            Dim lCookie As UInt32 = ProfileRequestList.AddRequest({Account}, DataType, Display, frmProfile.UpdateTypes.WAR3Stats, WhisperTo)
            Dim sKeys(4) As String
            sKeys(0) = "record\" & Client & "\0\wins"
            sKeys(1) = "record\" & Client & "\0\losses"
            sKeys(2) = "record\" & Client & "\0\disconnects"
            sKeys(3) = "record\" & Client & "\0\last game result"
            sKeys(4) = "record\" & Client & "\0\last game"
            BNCS_READUSERDATA_Send(lCookie, {Account}, sKeys)
          Case ProfileRequests.ProfileRequestType.LadderGameRecord
            Dim lCookie As UInt32 = ProfileRequestList.AddRequest({Account}, DataType, Display, frmProfile.UpdateTypes.WAR3Stats, WhisperTo)
            Dim sKeys(7) As String
            sKeys(0) = "record\" & Client & "\1\wins"
            sKeys(1) = "record\" & Client & "\1\losses"
            sKeys(2) = "record\" & Client & "\1\disconnects"
            sKeys(3) = "record\" & Client & "\1\last game result"
            sKeys(4) = "record\" & Client & "\1\last game"
            sKeys(5) = "record\" & Client & "\1\rating"
            sKeys(6) = "record\" & Client & "\1\high rating"
            sKeys(7) = "DynKey\" & Client & "\1\rank"
            BNCS_READUSERDATA_Send(lCookie, {Account}, sKeys)
          Case Else
            Debug.Print(DataType.ToString)
        End Select
      Case Else
        gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNCS, ResString(My.Resources.ERR_USERDATA_NONE, GameStringToName(Client)))
    End Select
  End Sub

  Private Sub WhisperWindow(Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf WhisperWindow), Obj)
    Else
      Dim Account As String = Obj(0)
      Dim Message As String = Obj(1)
      Dim sender As BNUI = Obj(2)
      Dim Recv As Boolean = Obj(3)
      If Recv Then
        ChatData.LastWhisper = Account
        If Message.Contains(ResString(My.Resources.SERVER_YOURFRIENDHAS, Account)) Then
          gChat.AddChat(GeckoChat.ChatType.UserWhisper, "From: " & Account, Message)
          BNCS_FRIENDSLIST_Send()
        Else
          If Config.Display.WhisWin > 0 Then
            If frmWhisper.WhisperFrom(Account, Message, Me) Then
              If Not frmWhisper.Visible Then frmWhisper.Show()
            Else
              gChat.AddChat(GeckoChat.ChatType.UserWhisper, "From: " & Account, Message)
            End If
          Else
            gChat.AddChat(GeckoChat.ChatType.UserWhisper, "From: " & Account, Message)
          End If
          If Not String.IsNullOrEmpty(Config.WhisFwd) Then SendMessage("/w " & Config.WhisFwd & " <From: " & Account & "> " & Message)
        End If
      Else
        If frmWhisper.WhisperTo(Account, Message, Me) Then
          If Not frmWhisper.Visible Then frmWhisper.Show()
        Else
          gChat.AddChat(GeckoChat.ChatType.UserWhisper, "To: " & Account, Message)
        End If
      End If
    End If
  End Sub

  Private Sub ShowAd(Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf ShowAd), Obj)
    Else
      Dim AdName As String = Obj(0)
      Dim AdURL As String = Obj(1)
      Select Case AdName.Substring(AdName.LastIndexOf("."))
        Case ".smk"
          Dim sAd As String = AppStore & "\Ads\" & AdName.Substring(0, AdName.LastIndexOf(".")) & ".tif"
          If My.Computer.FileSystem.FileExists(sAd) Then
            pctAd.Image = Image.FromFile(sAd)
          Else
            If My.Computer.Registry.LocalMachine.OpenSubKey("SOFTWARE\" & IIf(Environment.Is64BitOperatingSystem, "Wow6432Node\", String.Empty) & "RAD Game Tools\RADVideo") IsNot Nothing Then
              Dim smkPath As String = My.Computer.Registry.LocalMachine.OpenSubKey("SOFTWARE\" & IIf(Environment.Is64BitOperatingSystem, "Wow6432Node\", String.Empty) & "RAD Game Tools\RADVideo").GetValue("InstallDir").ToString
              If Not My.Computer.FileSystem.DirectoryExists(AppTemp & "\Ads") Then My.Computer.FileSystem.CreateDirectory(AppTemp & "\Ads")
              Dim sPath As String = AppTemp & "\Ads\" & Guid.NewGuid.ToString("B")
              If Not My.Computer.FileSystem.DirectoryExists(sPath) Then My.Computer.FileSystem.CreateDirectory(sPath)
              Shell(smkPath & "\BinkConv.exe """ & AppStore & "\Ads\" & AdName & """ """ & sPath & "\tmp.tif"" /n-1 /z1 /#", AppWinStyle.MinimizedNoFocus, True)
              If My.Computer.FileSystem.FileExists(sPath & "\tmp.tif") Then
                My.Computer.FileSystem.MoveFile(sPath & "\tmp.tif", sAd)
                pctAd.Image = Image.FromFile(sAd)
              Else
                Dim ioData As IO.Stream = New IO.FileStream(sPath & "\tmp.tif", IO.FileMode.Open)
                Dim bA As New Bitmap(ioData)
                ioData.Close()
                Dim ep As New Drawing.Imaging.EncoderParameters(1)
                Dim enc As Drawing.Imaging.Encoder = Drawing.Imaging.Encoder.SaveFlag
                Dim info As Drawing.Imaging.ImageCodecInfo = Nothing
                Dim ice As Drawing.Imaging.ImageCodecInfo
                For Each ice In Drawing.Imaging.ImageCodecInfo.GetImageEncoders()
                  If ice.MimeType = "image/tiff" Then
                    info = ice
                  End If
                Next ice
                bA.Save(sPath & "\tmp.tif", info, ep)
                ep.Param(0) = New Drawing.Imaging.EncoderParameter(enc, CLng(Drawing.Imaging.EncoderValue.MultiFrame))
                For Each File As String In My.Computer.FileSystem.GetFiles(sPath & "")
                  ioData = New IO.FileStream(File, IO.FileMode.Open)
                  bA.SaveAdd(New Bitmap(ioData), ep)
                  ioData.Close()
                Next
                My.Computer.FileSystem.MoveFile(sPath & "\tmp.tif", sAd)
                pctAd.Image = Image.FromFile(sAd)
              End If
              My.Computer.FileSystem.DeleteDirectory(sPath, FileIO.DeleteDirectoryOption.DeleteAllContents)
            Else
              pctAd.Image = New Bitmap(468, 60)
              Dim g As Graphics = Graphics.FromImage(pctAd.Image)
              Dim sFmt As New Drawing.StringFormat
              sFmt.Alignment = StringAlignment.Center
              sFmt.LineAlignment = StringAlignment.Center
              g.DrawString(My.Resources.ERR_NORAD, New Font(FontFamily.GenericSerif, 24, FontStyle.Regular, GraphicsUnit.Pixel), Brushes.Crimson, New Rectangle(0, 0, 468, 60), sFmt)
              pctAd.Tag = "http://www.radgametools.com/bnkdown.htm"
              Exit Sub
            End If
          End If
        Case (".mng")
          Try
            Dim FIAdd = FreeImageAPI.FreeImage.Load(FreeImageAPI.FREE_IMAGE_FORMAT.FIF_MNG, AppStore & "\Ads\" & AdName, FreeImageAPI.FREE_IMAGE_LOAD_FLAGS.DEFAULT)
            Dim iStream As New IO.MemoryStream
            FreeImageAPI.FreeImage.SaveToStream(FIAdd, iStream, FreeImageAPI.FREE_IMAGE_FORMAT.FIF_GIF)
            FIAdd.SetNull()
            pctAd.Image = Image.FromStream(iStream)
          Catch
            pctAd.Image = New Bitmap(468, 60)
            Dim g As Graphics = Graphics.FromImage(pctAd.Image)
            Dim sFmt As New Drawing.StringFormat
            sFmt.Alignment = StringAlignment.Center
            sFmt.LineAlignment = StringAlignment.Center
            g.DrawString(My.Resources.ERR_NOFREEIMAGE, New Font(FontFamily.GenericSerif, 24, FontStyle.Regular, GraphicsUnit.Pixel), Brushes.Crimson, New Rectangle(0, 0, 468, 60), sFmt)
            pctAd.Tag = "about:blank"
            Exit Sub
          End Try
        Case Else
          Debug.Print(AdName)
      End Select
      pctAd.Tag = AdURL
    End If
  End Sub

  Private Sub SetAds(Obj As Object)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf SetAds), Obj)
    Else
      tmrAds.Enabled = Obj
    End If
  End Sub

  Private Sub SquelchUser(Username As String, Optional Squelch As Boolean = True)
    If Squelch Then
      SendMessage("/squelch " & Username)
    Else
      SendMessage("/unsquelch " & Username)
    End If
  End Sub

  Private Function TagSquelchUser(UserTag As String, Optional Squelch As Boolean = True) As Byte
    If Config.TagSquelchList Is Nothing Then Return 2
    If Squelch Then
      For Each TagSquelchItem In Config.TagSquelchList
        If String.Compare(TagSquelchItem, UserTag, True) = 0 Then
          Return 1
        End If
      Next
      Config.TagSquelchList.Add(UserTag)
      ReloadChannel()
      Return 0
    Else
      For Each TagSquelchItem In Config.TagSquelchList
        If String.Compare(TagSquelchItem, UserTag, True) = 0 Then
          Config.TagSquelchList.Remove(UserTag)
          ReloadChannel()
          Return 0
        End If
      Next
      Return 1
    End If
    'SquelchUser(BNetData.UniqueName, False)
  End Function

  Private Sub ReloadChannel()
    For I As Integer = 0 To ChanList.Length - 1
      ChannelAdd(ChanList.Items(I).Username, ChanList.Items(I).Flags, ChanList.Items(I).Ping, ChanList.Items(I).StatString)
    Next
  End Sub

  Private Function ChanFlags(Flags As UInt32) As String
    Dim sTmp As String = String.Empty
    If CBool(Flags And CHANNEL_PUBLIC) Then sTmp &= My.Resources.FLAGS_CHANNEL_PUBLIC
    If CBool(Flags And CHANNEL_MODERATED) Then sTmp &= My.Resources.FLAGS_CHANNEL_MODERATED
    If CBool(Flags And CHANNEL_RESTRICTED) Then sTmp &= My.Resources.FLAGS_CHANNEL_RESTRICTED
    If CBool(Flags And CHANNEL_SILENT) Then sTmp &= My.Resources.FLAGS_CHANNEL_SILENT
    If CBool(Flags And CHANNEL_SYSTEM) Then sTmp &= My.Resources.FLAGS_CHANNEL_SYSTEM
    If CBool(Flags And CHANNEL_PRODUCTSPECIFIC) Then sTmp &= My.Resources.FLAGS_CHANNEL_PRODUCTSPECIFIC
    If CBool(Flags And CHANNEL_GLOBAL) Then sTmp &= My.Resources.FLAGS_CHANNEL_GLOBAL
    If CBool(Flags And CHANNEL_REDIRECT) Then sTmp &= My.Resources.FLAGS_CHANNEL_REDIRECT
    Return sTmp
  End Function

  Private Function UserFlags(Flags As UInt32) As String
    Dim sTmp As String = String.Empty
    If CBool(Flags And USER_SQUELCHED) Then sTmp &= My.Resources.FLAGS_USER_SQUELCHED & "; "
    If CBool(Flags And USER_TAGSQUELCHED) Then sTmp &= My.Resources.FLAGS_USER_TAGSQUELCHED & "; "
    If CBool(Flags And USER_INVISIBLE) Then sTmp &= My.Resources.FLAGS_USER_INVISIBLE & "; "
    If CBool(Flags And USER_BLIZZREP) Then sTmp &= My.Resources.FLAGS_USER_BLIZZREP & "; "
    If CBool(Flags And USER_ADMIN) Then sTmp &= My.Resources.FLAGS_USER_ADMIN & "; "
    If CBool(Flags And USER_SPEAKER) Then sTmp &= My.Resources.FLAGS_USER_SPEAKER & "; "
    If CBool(Flags And USER_GUEST) Then sTmp &= My.Resources.FLAGS_USER_GUEST & "; "
    If CBool(Flags And USER_PGLOFFICIAL) Then sTmp &= My.Resources.FLAGS_USER_PGLOFFICIAL & "; "
    If CBool(Flags And USER_WCGOFFICIAL) Then sTmp &= My.Resources.FLAGS_USER_WCGOFFICIAL & "; "
    If CBool(Flags And USER_GFOFFICIAL) Then sTmp &= My.Resources.FLAGS_USER_GFOFFICIAL & "; "

    If CBool(Flags And USER_CHANNELOP) Then sTmp &= My.Resources.FLAGS_USER_CHANNELOP & "; "
    If CBool(Flags And USER_PGLPLAYER) Then sTmp &= My.Resources.FLAGS_USER_PGLPLAYER & "; "
    If CBool(Flags And USER_WCGPLAYER) Then sTmp &= My.Resources.FLAGS_USER_WCGPLAYER & "; "
    If CBool(Flags And USER_KBKPLAYER) Then sTmp &= My.Resources.FLAGS_USER_KBKPLAYER & "; "
    If CBool(Flags And USER_KBKBEGINNER) Then sTmp &= My.Resources.FLAGS_USER_KBKBEGINNER & "; "
    If CBool(Flags And USER_KBKWHITE) Then sTmp &= My.Resources.FLAGS_USER_KBKWHITE & "; "
    If CBool(Flags And USER_GFPLAYER) Then sTmp &= My.Resources.FLAGS_USER_GFPLAYER & "; "
    If CBool(Flags And USER_BEEPENABLED) Then sTmp &= My.Resources.FLAGS_USER_BEEPENABLED & "; "
    If CBool(Flags And USER_NOUDP) Then sTmp &= My.Resources.FLAGS_USER_NOUDP & "; "
    If Not String.IsNullOrEmpty(sTmp) Then Return sTmp.Substring(0, sTmp.Length - 2) & "."
    Return My.Resources.FLAGS_USER_NONE
  End Function

  Private Sub ToggleListChannel(Enabled As Boolean)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New CallBack(AddressOf ToggleListChannel), Enabled)
    Else
      If Enabled Then
        cmdListChannel.Tag = Nothing
        cmdListChannel.Visible = True
        pnlChannel.ColumnStyles(1).Width = 20
      Else
        pnlChannel.ColumnStyles(1).Width = 0
        cmdListChannel.Visible = False
      End If
    End If
  End Sub
#End Region

#Region "Site-connected functions"

  Private Sub UpdateHashFiles()
    If Me.InvokeRequired Then
      Me.BeginInvoke(New MethodInvoker(AddressOf UpdateHashFiles))
    Else
      BNCS_Disconnect()
      GetVerByte()
      While wsDownload.IsBusy : Application.DoEvents() : End While
      GetNewHashes()
    End If
  End Sub

  Private Sub GetVerByte()
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_HTTP, My.Resources.INFO_GET_VER)
    Application.DoEvents()
    Thread.Sleep(100)
    Dim uriVerByte As New Uri("http://realityripple.com/Software/Battle.net/Hash_Files/ver.php?f=" & Config.Account.Client.Product.ToString)
    wsDownload.DownloadStringAsync(uriVerByte, "VER")
  End Sub

  Private Sub GetNewHashes()
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_HTTP, My.Resources.INFO_GET_HASH, "hashes")
    Application.DoEvents()
    Thread.Sleep(100)
    Dim HashZip As String = Config.HashPath & GetHashProd() & ".zip"
    Dim uriHashes As New Uri("http://realityripple.com/Software/Battle.net/Hash_Files/download.php?f=" & GetHashProd())
    If Not My.Computer.FileSystem.DirectoryExists(Config.HashPath) Then My.Computer.FileSystem.CreateDirectory(Config.HashPath)
    Dim StartSize As Long = 0
    If My.Computer.FileSystem.FileExists(HashZip) Then StartSize = My.Computer.FileSystem.GetFileInfo(HashZip).Length
    If StartSize > 0 Then
      wsDownload.Headers.Add(System.Net.HttpRequestHeader.Range, "bytes=" & StartSize & "-")
    Else
      wsDownload.Headers.Clear()
    End If
    wsDownload.DownloadFileAsync(uriHashes, HashZip, "HASH")
  End Sub
#End Region

#Region "BNET2 Events"
  Private Sub cBNET2_CreateProgress(id As String, Message As String) Handles cBNET2.CreateProgress
    gChat.AddChat(GeckoChat.ChatType.ServiceInfo, My.Resources.PROTOCOL_HTTP, Message, id)
  End Sub

  Private Sub cBNET2_Disconnect(Message As String, ReconnectAdvised As Boolean) Handles cBNET2.Disconnect
    BNCS_Disconnect(ReconnectAdvised)
    If ReconnectAdvised Then
      AttemptReconnect(Message)
    ElseIf Not String.IsNullOrEmpty(Message) Then
      gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNET2, Message)
    End If
  End Sub

  Private Sub cBNET2_Failure(ex As System.Exception) Handles cBNET2.Failure
    gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNET2, ex.Message)
  End Sub

  Private Sub cBNET2_Send(Packet() As Byte) Handles cBNET2.Send
    Try
      If Not IsOnline Then
        gChat.AddChat(GeckoChat.ChatType.VerboseInfo, My.Resources.PROTOCOL_BNET2, "Unable to send 0x" & PadHex(Packet(0), 2) & " while offline.")
      Else
        If tbsLists.Controls.Contains(tabPacket) Then AddPacket({My.Resources.PROTOCOL_BNET2, False, Packet(0), Packet})
        If sckBN2 Is Nothing Then
          BNCS_Disconnect(True)
          AttemptReconnect(My.Resources.ERR_NET_LOST)
        Else
          If sckBN2.IsConnected Then
            sckBN2.Send(Packet)
          End If
        End If
      End If
    Catch e As Exception
      Debug.Print("Send Fail: " & e.Message)
      BNCS_Disconnect(True)
      AttemptReconnect(My.Resources.ERR_NET_LOST)
    Finally
      Packet = Nothing
    End Try
  End Sub

  Private Sub cBNET2_ServiceError(Message As String) Handles cBNET2.ServiceError
    gChat.AddChat(GeckoChat.ChatType.ServiceError, My.Resources.PROTOCOL_BNET2, Message)
  End Sub

  Private Sub cBNET2_TerminateProgress(id As String, Message As String) Handles cBNET2.TerminateProgress
    gChat.TerminateProgress(id, Message)
  End Sub

  Private Sub cBNET2_UpdateProgress(id As String, Message As String) Handles cBNET2.UpdateProgress
    gChat.UpdateProgress(id, Message)
  End Sub
#End Region
End Class
