﻿Imports System.IO
Public Class XSHA
  Private Sub New()
  End Sub
  Private Shared Function ROL(val As UInteger, shift As Integer) As UInteger
    shift = shift And &H1F
    val = (val >> (&H20 - shift)) Or (val << shift)
    Return val
  End Function
  Private Shared Function BrokenHash(input As Byte()) As Byte()
    If input.Length > 1024 Then Throw New ArgumentOutOfRangeException("Input must be 1024 bytes or less!")
    Dim data As Byte() = New Byte(1023) {}
    Array.Copy(input, 0, data, 0, input.Length)
    Dim mdata As New MemoryStream(data, True)
    Dim br As New BinaryReader(mdata)
    Dim bw As New BinaryWriter(mdata)
    Dim a, b, c, d, e, g As UInteger
    For I As Integer = 0 To 63
      mdata.Seek((I * 4), SeekOrigin.Begin)
      Dim expr_ldata_i As UInteger = br.ReadUInt32()
      mdata.Seek(1 * 4, SeekOrigin.Current)
      Dim expr_ldata_i_2 As UInteger = br.ReadUInt32()
      mdata.Seek(5 * 4, SeekOrigin.Current)
      Dim expr_ldata_i_8 As UInteger = br.ReadUInt32()
      mdata.Seek(4 * 4, SeekOrigin.Current)
      Dim expr_ldata_i_13 As UInteger = br.ReadUInt32()
      Dim shiftVal As Integer = CInt((expr_ldata_i Xor expr_ldata_i_8 Xor expr_ldata_i_2 Xor expr_ldata_i_13) And &H1F)
      mdata.Seek(2 * 4, SeekOrigin.Current)
      bw.Write(ROL(1, shiftVal))
    Next
    a = &H67452301
    b = &HEFCDAB89UI
    c = &H98BADCFEUI
    d = &H10325476
    e = &HC3D2E1F0UI
    g = 0
    mdata.Seek(0, SeekOrigin.Begin)
    For I As Integer = 0 To 19
      g = br.ReadUInt32() + ROL(a, 5) + e + ((b And c) Or (Not b And d)) + &H5A827999
      e = d : d = c : c = ROL(b, 30) : b = a : a = g
    Next I
    For I As Integer = 0 To 19
      g = (d Xor c Xor b) + e + ROL(g, 5) + br.ReadUInt32() + &H6ED9EBA1
      e = d : d = c : c = ROL(b, 30) : b = a : a = g
    Next
    For I As Integer = 0 To 19
      g = br.ReadUInt32() + ROL(g, 5) + e + ((c And b) Or (d And c) Or (d And b)) - &H70E44324
      e = d : d = c : c = ROL(b, 30) : b = a : a = g
    Next I
    For I As Integer = 0 To 19
      g = (d Xor c Xor b) + e + ROL(g, 5) + br.ReadUInt32() - &H359D3E2A
      e = d : d = c : c = ROL(b, 30) : b = a : a = g
    Next
    br.Close()
    bw.Close()
    mdata.Close()
    Dim result As Byte() = New Byte(19) {}
    mdata = New MemoryStream(result, 0, 20, True, True)
    bw = New BinaryWriter(mdata)
    bw.Write(CUInt(&H67452301 + a))
    bw.Write(CUInt(&HEFCDAB89UI + b))
    bw.Write(CUInt(&H98BADCFEUI + c))
    bw.Write(CUInt(&H10325476 + d))
    bw.Write(CUInt(&HC3D2E1F0UI + e))
    mdata.Close()
    bw.Close()
    Return result
  End Function
  Public Shared Function CalculateHash(data() As Byte) As Byte()
    Return BrokenHash(data)
  End Function

  Public Shared Function HashPassword(sPassword As String) As Byte()
    Return BrokenHash(System.Text.Encoding.GetEncoding(LATIN_1).GetBytes(sPassword.ToLower))
  End Function

  Public Shared Function DoubleHashPassword(sPassword As String, ClientToken As UInt32, ServerToken As UInt32)
    Dim ms = New MemoryStream(28)
    Dim bw As New BinaryWriter(ms)
    Dim firstHash() As Byte = HashPassword(sPassword)
    bw.Write(ClientToken)
    bw.Write(ServerToken)
    bw.Write(firstHash)
    Dim toCalc() As Byte = ms.GetBuffer
    Return BrokenHash(toCalc)
  End Function

  Public Shared Function DoubleHashData(data() As Byte, ClientToken As UInt32, ServerToken As UInt32)
    Dim ms = New MemoryStream(28)
    Dim bw As New BinaryWriter(ms)
    Dim firstHash() As Byte = BrokenHash(data)
    bw.Write(ClientToken)
    bw.Write(ServerToken)
    bw.Write(firstHash)
    Dim toCalc() As Byte = ms.GetBuffer
    Return BrokenHash(toCalc)
  End Function

End Class
