﻿Public Class WardenEventArgs
  Inherits EventArgs
  Dim bData() As Byte
  Public Property Data As Byte()
    Get
      Return bData
    End Get
    Set(value As Byte())
      bData = value
    End Set
  End Property
End Class
Public Class clsWarden
  Private Structure RANDOMDATA
    Public Pos As Long
    Public Data() As Byte
    Public Sorc1() As Byte
    Public Sorc2() As Byte
  End Structure

  Public Event BNCS_WARDEN_Send(sender As Object, e As WardenEventArgs)
  Private m_Parse(5) As Long
  Private m_CallBack(7) As Long
  Private m_Func(2) As Long
  Private m_KeyOut(257) As Byte
  Private m_KeyIn(257) As Byte
  Private m_Seed(3) As Byte
  Private m_Mod As Long
  Private m_ModMem As Long
  Private m_ModState As Byte
  Private m_RC4 As Long
  Private m_PKT As String
  Private m_ModMD5(15) As Byte
  Private m_ModFolder As String
  Private m_ModKey(15) As Byte
  Private m_ModLen As Long
  Private m_ModPos As Long
  Private m_ModData() As Byte
  Private m_ModRet As String
  Private m_EXEPath As String
  Private m_LogData As Boolean
  Private m_Libs() As String
  Private PAGE_CHECK_A As Byte
  Private MEM_CHECK As Byte
  Private m_WardenDir As String

  Public Sub Initialize(Seed() As Byte, WardenDir As String)
    Dim bOut(15) As Byte
    Dim bIn(15) As Byte
    Dim uRand As RANDOMDATA
    uRand.Sorc1 = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    uRand.Data = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    uRand.Sorc2 = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    Array.Copy(Seed, m_Seed, 4)
    Data_Init(uRand, m_Seed)
    Data_GetBytes(uRand, bOut, 16)
    Data_GetBytes(uRand, bIn, 16)
    RC4Key(bOut, m_KeyOut, 16)
    RC4Key(bIn, m_KeyIn, 16)
    m_WardenDir = WardenDir
  End Sub

  Public Sub IncomingPacket(pData() As Byte)
    Dim pktWarden As New DataReader(RC4Crypt(pData, m_KeyIn))
    Dim pCode As Byte = pktWarden.ReadByte
    Select Case pCode
      Case 0
        'Module Info
        m_ModMD5 = pktWarden.ReadByteArray(16)
        m_ModKey = pktWarden.ReadByteArray(16)
        m_ModLen = pktWarden.ReadUInt32
        m_ModPos = 0
        Send0x00()
      Case 1
        'Module Data
        Dim iLen As UInt16 = pktWarden.ReadUInt16
        Array.Copy(pktWarden.ReadByteArray(iLen), 0, m_ModData, m_ModLen, iLen)
        m_ModPos += iLen
        If m_ModLen <= m_ModPos Then Send0x01()
      Case 2
        'Data Checker
      Case 3
        'Library Loader
      Case 5
        'Init

    End Select
  End Sub

  Private Sub OutgoingPacket(ByRef pktWarden As DataBuffer)
    Dim Args As New WardenEventArgs
    Args.Data = RC4Crypt(pktWarden.GetData, m_KeyOut)
    RaiseEvent BNCS_WARDEN_Send(Me, Args)
  End Sub

  Private Sub Send0x00()
    Dim pktTmp As New DataBuffer
    pktTmp.InsertByte(0)
    If My.Computer.FileSystem.FileExists(m_WardenDir & BitConverter.ToString(m_ModMD5) & ".bin") Then
      pktTmp.InsertByte(1)
    Else
      pktTmp.InsertByte(0)
    End If
    OutgoingPacket(pktTmp)
  End Sub

  Private Sub Send0x01()
    Dim bData(257) As Byte
    RC4Key(m_ModKey, bData, 16)
    Dim bMod() As Byte = RC4Crypt(m_ModData, bData)
    Dim modStream As New System.IO.FileStream(m_WardenDir & BitConverter.ToString(m_ModMD5) & ".bin", IO.FileMode.OpenOrCreate)
    Dim uncompress As New System.IO.Compression.GZipStream(modStream, IO.Compression.CompressionMode.Decompress)
    modStream.Dispose()
    uncompress.Write(bMod, 0, m_ModLen - &H108)
    uncompress.Read(bMod, 0, m_ModLen)
    uncompress.Dispose()
    My.Computer.FileSystem.WriteAllBytes(m_WardenDir & BitConverter.ToString(m_ModMD5) & ".bin", bMod, False)
    'Load Module
    Dim pktTmp As New DataBuffer
    pktTmp.InsertByte(1)
    Dim MD5Hash As MD5 = MD5.Create
    If MD5Hash.ComputeHash(bMod).Equals(m_ModMD5) Then
      pktTmp.InsertByte(1)
    Else
      pktTmp.InsertByte(0)
    End If
    OutgoingPacket(pktTmp)
  End Sub

  Private Sub Data_Init(ByRef R As RANDOMDATA, Seed() As Byte)
    Dim lSeed(1) As Byte
    Dim rSeed(1) As Byte
    lSeed(0) = Seed(0)
    lSeed(1) = Seed(1)
    rSeed(0) = Seed(2)
    rSeed(1) = Seed(3)
    R.Sorc1 = SHACrypt(lSeed)
    R.Sorc2 = SHACrypt(rSeed)
    R.Data = SHACrypt(JoinRandoms(R))
    R.Pos = 1
  End Sub

  Private Sub Data_GetBytes(ByRef R As RANDOMDATA, ByRef bData() As Byte, lBytes As Integer)
    For I As Integer = 0 To (lBytes - 1)
      bData(I) = R.Data(R.Pos)
      R.Pos = R.Pos + 1
      If (R.Pos > 20) Then
        R.Pos = 1
        R.Data = SHACrypt(JoinRandoms(R))
      End If
    Next I
  End Sub

  Private Function JoinRandoms(R As RANDOMDATA) As Byte()
    Dim bBuf(59) As Byte
    R.Sorc1.CopyTo(bBuf, 0)
    R.Data.CopyTo(bBuf, 20)
    R.Sorc2.CopyTo(bBuf, 40)
    Return bBuf
  End Function

  Private Function SHACrypt(bMessage() As Byte) As Byte()
    Dim SHA As New SHA1Managed
    SHA.Initialize()
    Return SHA.ComputeHash(bMessage)
    SHA.Dispose()
  End Function

  Private Sub RC4Key(ByRef bData() As Byte, ByRef B() As Byte, lngLength As Long)
    Dim bR(255) As Byte
    B(256) = 0
    B(257) = 0
    For I As Integer = 0 To 255
      bR(I) = bData(I Mod lngLength)
      B(I) = I
    Next I
    Dim A As Integer = 0
    Dim c As Byte
    For I As Integer = 0 To 255
      A = (A + B(I) + bR(I)) Mod 256
      c = B(I)
      B(I) = B(A)
      B(A) = c
    Next I
  End Sub

  Private Function RC4Crypt(sMessage As Byte(), sKey As Byte()) As Byte()
    Dim K As Int32
    Dim A, I, J As Int32
    Dim Cipher As Byte()
    ReDim Cipher(sMessage.Length)
    Dim sBox(256) As Int32
    Dim Temp As Int32
    I = 0
    J = 0
    RC4Init(sKey, sBox)
    For A = 0 To sMessage.Length - 1
      I = (I + 1) Mod 256
      J = (J + sBox(I)) Mod 256
      'Swap
      Temp = sBox(I)
      sBox(I) = sBox(J)
      sBox(J) = Temp
      'Get the output
      K = sBox((sBox(I) + sBox(J)) Mod 256)
      sMessage(A) = sMessage(A) Xor Convert.ToByte(K)
    Next
    Return sMessage
  End Function

  Private Sub RC4Init(key As Byte(), ByRef sbox As Int32())
    Dim tempSwap As Int32
    Dim I, J, L As Int32
    L = key.Length
    For I = 0 To 255
      sbox(I) = I
    Next
    J = 0
    For I = 0 To 255
      J = (J + sbox(I) + key(I Mod L)) Mod 256
      tempSwap = sbox(I)
      sbox(I) = sbox(J)
      sbox(J) = tempSwap
    Next
  End Sub
End Class
