﻿Imports System.Net
Imports System.Net.Sockets
Imports System.Threading
Public Class SocketErrorEventArgs
  Inherits EventArgs
  Dim c_Error As String
  Public Sub New()
    c_Error = Nothing
  End Sub
  Public Sub New(sError As String)
    c_Error = sError
  End Sub
  Public Property ErrorDetails As String
    Get
      Return c_Error
    End Get
    Set(value As String)
      c_Error = value
    End Set
  End Property
End Class
Public Class SocketReceivedEventArgs
  Inherits EventArgs
  Dim c_Data() As Byte
  Public Sub New()
    c_Data = Nothing
  End Sub
  Public Sub New(bData() As Byte)
    c_Data = bData
  End Sub
  Public Property Data As Byte()
    Get
      Return c_Data
    End Get
    Set(value As Byte())
      c_Data = value
    End Set
  End Property
End Class
Public Class SocketWrapper
  Inherits Connection

  Public Event SocketConnected(sender As Object, e As EventArgs)
  Public Event SocketReceived(sender As Object, e As SocketReceivedEventArgs)
  Public Event SocketDisconnected(sender As Object, e As SocketErrorEventArgs)
  Public Enum ProxyType
    SOCKS4 = 4
    SOCKS5 = 5
    HTTP = 1
  End Enum
  Private Enum SOCKS4Status
    Granted = &H5A
    Failed = &H5B
    NoIdent = &H5C
    IdentFail = &H5D
  End Enum
  Private Enum SOCKS5AuthMethods
    None = &H0
    GSSAPI = &H1
    UserPass = &H2
    ChallengeHandshake = &H3
    ChallengeResponse = &H5
    SSL = &H6
    NDS = &H7
    MultiAuthFramework = &H8
  End Enum
  Private Enum SOCKS5Status
    Granted = &H0
    Failure = &H1
    NotAllowedByRuleset = &H2
    NetworkUnreachable = &H3
    HostUnreachable = &H4
    RefusedByDestination = &H5
    TTLExpired = &H6
    CommandNotSupported = &H7
    AddressNotSupported = &H8
  End Enum
  Private Enum SOCKS5AddressType
    IPv4 = &H1
    Domain = &H3
    IPv6 = &H4
  End Enum
  Private Enum SOCKS5ConnectState
    Handshake
    Authentication
    Authentication2
    Authentication3
    Authentication4
    Authentication5
    Authentication6
    Request
    Complete
  End Enum
  Private Structure ProxyData
    Public Dest As DnsEndPoint
    Public Ver As ProxyType
    Public User As String
    Public Pass As String
    Public Vars As SOCKS5Variables
    Public bData() As Byte
    Public DataIndex As Integer
  End Structure
  Private Structure SOCKS5Variables
    Public AuthMethod As SOCKS5AuthMethods
    Public ConnectionState As SOCKS5ConnectState
  End Structure
  Public Structure ProxySettings
    Public Dest As DnsEndPoint
    Public Ver As ProxyType
    Public User As String
    Public Pass As String
  End Structure
  Public Proxy As ProxySettings
  Public UseProxy As Boolean
  Public Sub New()
    MyBase.New()
  End Sub
  Protected Overrides Sub Connected()
    If UseProxy Then
      Dim pData As ProxyData
      pData.Dest = Proxy.Dest
      pData.Ver = Proxy.Ver
      pData.User = Proxy.User
      pData.Pass = Proxy.Pass
      pData.Vars.ConnectionState = SOCKS5ConnectState.Request
      pData.bData = Nothing
      pData.DataIndex = 0
      PROXY_BEGIN()
      MyBase.ReceiveNoLock(&H100000, pData)
    Else
      RaiseEvent SocketConnected(New Object, New EventArgs)
      MyBase.ReceiveNoLock(&H100000, "DATA")
    End If
  End Sub
  Protected Overrides Sub ReceivedData(e As SocketAsyncEventArgs)
    If (TypeOf (e.UserToken) Is String) Or Not UseProxy Then
      Dim bData(e.BytesTransferred - 1) As Byte
      Array.Copy(e.Buffer, bData, e.BytesTransferred)
      RaiseEvent SocketReceived(New Object, New SocketReceivedEventArgs(bData))
      MyBase.ReceiveNoLock(&H100000, "DATA")
    Else
      Dim pData As ProxyData = e.UserToken
      ReDim Preserve pData.bData(e.BytesTransferred + pData.DataIndex - 1)
      Array.Copy(e.Buffer, 0, pData.bData, pData.DataIndex, e.BytesTransferred)
      pData.DataIndex += e.BytesTransferred
      Dim pktRead As New DataReader(pData.bData)
      Select Case pData.Ver
        Case ProxyType.HTTP
          Dim lLen As Integer = pktRead.Length
          Dim bData() As Byte = pktRead.ReadByteArray(lLen)
          Dim sData As String = System.Text.Encoding.ASCII.GetString(bData)
          If InStr(sData, vbNewLine & vbNewLine) > 0 Then
            If InStr(sData, " 200") > 0 Then
              RaiseEvent SocketConnected(New Object, New EventArgs)
              MyBase.ReceiveNoLock(&H100000, "DATA")
            Else
              MyBase.Disconnect(sData)
            End If
          Else
            MyBase.ReceiveNoLock(&H100000, pData)
          End If
        Case ProxyType.SOCKS4
          Dim bNull As Byte = pktRead.ReadByte
          Dim bStatus As Byte = pktRead.ReadByte
          Dim bPort() As Byte = pktRead.ReadByteArray(2)
          Dim bIP() As Byte = pktRead.ReadByteArray(2)
          Select Case bStatus
            Case &H5A
              RaiseEvent SocketConnected(New Object, New EventArgs)
              MyBase.ReceiveNoLock(&H100000, "DATA")
            Case &H5B
              MyBase.Disconnect(My.Resources.SOCKET_SOCKS_ERR_5B)
            Case &H5C
              MyBase.Disconnect(My.Resources.SOCKET_SOCKS_ERR_5C)
            Case &H5D
              MyBase.Disconnect(My.Resources.SOCKET_SOCKS_ERR_5D)
            Case Else
              MyBase.Disconnect(ResString(My.Resources.SOCKET_SOCKS_ERR_UNKNOWN, PadHex(bStatus, 2)))
          End Select
        Case ProxyType.SOCKS5
          Select Case pData.Vars.ConnectionState
            Case SOCKS5ConnectState.Handshake
              Dim bVersion As Byte = pktRead.ReadByte
              Dim bMethod As Byte = pktRead.ReadByte
              Select Case bMethod
                Case &H0, &H1, &H2, &H3, &H5, &H6, &H7, &H8
                  pData.Vars.AuthMethod = bMethod
                  'Dim pktTmp As New DataBuffer
                  Select Case pData.Vars.AuthMethod
                    Case SOCKS5AuthMethods.None
                      pData.Vars.ConnectionState = SOCKS5ConnectState.Request
                      SOCKS5_REQUEST_Send()
                      MyBase.ReceiveNoLock(&H100000, pData)
                    Case SOCKS5AuthMethods.GSSAPI
                      pData.Vars.ConnectionState = SOCKS5ConnectState.Authentication
                      Stop
                    Case SOCKS5AuthMethods.UserPass
                      pData.Vars.ConnectionState = SOCKS5ConnectState.Authentication
                      SOCKS5_USERPASS_Send()
                    Case SOCKS5AuthMethods.ChallengeHandshake
                      pData.Vars.ConnectionState = SOCKS5ConnectState.Authentication
                      Stop
                      'pktTmp.InsertByte(&H1)
                      'pktTmp.InsertByte(CHAPATAs.Charset)
                      'pktTmp.InsertString(System.Text.Encoding.ASCII.BodyName, 20127)
                      'pktTmp.InsertByte(CHAPATAs.Algorithms)
                      'pktTmp.InsertString("HMAC-MD5", 20127)
                    Case SOCKS5AuthMethods.ChallengeResponse
                      pData.Vars.ConnectionState = SOCKS5ConnectState.Authentication
                      Stop
                    Case SOCKS5AuthMethods.SSL
                      pData.Vars.ConnectionState = SOCKS5ConnectState.Authentication
                      Stop
                    Case SOCKS5AuthMethods.NDS
                      pData.Vars.ConnectionState = SOCKS5ConnectState.Authentication
                      Stop
                    Case SOCKS5AuthMethods.MultiAuthFramework
                      pData.Vars.ConnectionState = SOCKS5ConnectState.Authentication
                      Stop
                  End Select
                Case &HFF
                  MyBase.Disconnect(My.Resources.SOCKET_SOCKS_ERR_AUTH_NOTLISTED)
                Case Else
                  MyBase.Disconnect(ResString(My.Resources.SOCKET_SOCKS_ERR_AUTH_UNKNOWN, PadHex(bMethod, 2)))
              End Select
            Case SOCKS5ConnectState.Authentication
              Select Case pData.Vars.AuthMethod
                Case SOCKS5AuthMethods.GSSAPI
                  Stop
                Case SOCKS5AuthMethods.UserPass
                  Dim bVersion As Byte = pktRead.ReadByte
                  Dim bStatus As Byte = pktRead.ReadByte
                  If bStatus = &H0 Then
                    pData.Vars.ConnectionState = SOCKS5ConnectState.Request
                    SOCKS5_REQUEST_Send()
                    MyBase.ReceiveNoLock(&H100000, pData)
                  Else
                    MyBase.Disconnect(ResString(My.Resources.LOGON_FAIL, PadHex(bStatus, 2)))
                  End If
                Case SOCKS5AuthMethods.ChallengeHandshake
                  Stop
                Case SOCKS5AuthMethods.ChallengeResponse
                  Stop
                Case SOCKS5AuthMethods.SSL
                  Stop
                Case SOCKS5AuthMethods.NDS
                  Stop
                Case SOCKS5AuthMethods.MultiAuthFramework
                  Stop
              End Select
            Case SOCKS5ConnectState.Authentication2
              Stop
            Case SOCKS5ConnectState.Request
              Dim bVersion As Byte = pktRead.ReadByte
              Dim bStatus As SOCKS5Status = pktRead.ReadByte
              Dim bReserved As Byte = pktRead.ReadByte
              Dim bAddressType As SOCKS5AddressType = pktRead.ReadByte
              Dim bAddress() As Byte
              Select Case bAddressType
                Case SOCKS5AddressType.IPv4
                  bAddress = pktRead.ReadByteArray(4)
                Case SOCKS5AddressType.Domain
                  Dim bLen As Byte = pktRead.ReadByte
                  bAddress = pktRead.ReadByteArray(bLen)
                Case SOCKS5AddressType.IPv6
                  bAddress = pktRead.ReadByteArray(16)
              End Select
              Dim bPort() As Byte = pktRead.ReadByteArray(2)
              Select Case bStatus
                Case SOCKS5Status.Granted
                  RaiseEvent SocketConnected(New Object, New EventArgs)
                  MyBase.ReceiveNoLock(&H100000, "DATA")
                Case SOCKS5Status.Failure
                  MyBase.Disconnect(My.Resources.SOCKET_SOCKS_ERR_FAILURE)
                Case SOCKS5Status.NotAllowedByRuleset
                  MyBase.Disconnect(My.Resources.SOCKET_SOCKS_ERR_NOTALLOWED)
                Case SOCKS5Status.NetworkUnreachable
                  MyBase.Disconnect(My.Resources.SOCKET_SOCKS_ERR_NETWORKUNREACHABLE)
                Case SOCKS5Status.HostUnreachable
                  MyBase.Disconnect(My.Resources.SOCKETS_SOCKS_ERR_HOSTUNREACHABLE)
                Case SOCKS5Status.RefusedByDestination
                  MyBase.Disconnect(My.Resources.SOCKET_SOCKS_ERR_REFUSED)
                Case SOCKS5Status.TTLExpired
                  MyBase.Disconnect(My.Resources.SOCKET_SOCKS_ERR_TTLEXPIRED)
                Case SOCKS5Status.CommandNotSupported
                  MyBase.Disconnect(My.Resources.SOCKET_SOCKS_ERR_PROTOCOLERROR)
                Case SOCKS5Status.AddressNotSupported
                  MyBase.Disconnect(My.Resources.SOCKET_SOCKS_ERR_ADDRESSNOTSUPPORTED)
              End Select
            Case SOCKS5ConnectState.Complete
              Debug.Print("?")
              Debug.Print(pktRead.ToString)
              Stop
          End Select
      End Select
    End If
  End Sub

  Protected Overrides Sub Disconnected(Optional sError As String = Nothing)
    RaiseEvent SocketDisconnected(New Object, New SocketErrorEventArgs(sError))
  End Sub

  Private Sub PROXY_BEGIN()
    Using pktTmp As New DataBuffer
      Select Case Proxy.Ver
        Case ProxyType.HTTP
          pktTmp.InsertByteArray(System.Text.Encoding.ASCII.GetBytes("CONNECT " & Proxy.Dest.Host & ":" & Proxy.Dest.Port.ToString.Trim & " HTTP/1.0" & vbCrLf & "User-agent: " & UserAgent & vbCrLf & vbCrLf))
        Case ProxyType.SOCKS4
          pktTmp.InsertByte(&H4)
          pktTmp.InsertByte(&H1)
          pktTmp.InsertByteArray({&H17, &HE0})
          pktTmp.InsertByteArray(Dns.GetHostAddresses(Proxy.Dest.Host).First.GetAddressBytes)
          pktTmp.InsertCString(Environment.UserName)
        Case ProxyType.SOCKS5
          'Hope Ident is on!
          pktTmp.InsertByte(&H5)
          pktTmp.InsertByte(&H2)
          'pktTmp.InsertByteArray({SOCKS5AuthMethods.None, SOCKS5AuthMethods.GSSAPI, SOCKS5AuthMethods.UserPass, SOCKS5AuthMethods.ChallengeHandshake, SOCKS5AuthMethods.ChallengeResponse, SOCKS5AuthMethods.SSL, SOCKS5AuthMethods.NDS, SOCKS5AuthMethods.MultiAuthFramework})
          pktTmp.InsertByteArray({SOCKS5AuthMethods.None, SOCKS5AuthMethods.UserPass})
        Case Else
          MyBase.Disconnect("Unknown proxy selection!")
          Exit Sub
      End Select
      MyBase.Send(pktTmp.GetData)
    End Using
  End Sub

  Private Sub SOCKS5_REQUEST_Send()
    Using pktTmp As New DataBuffer
      pktTmp.InsertByte(&H5)
      pktTmp.InsertByte(&H1)
      pktTmp.InsertByte(&H0)
      pktTmp.InsertByte(SOCKS5AddressType.IPv4)
      pktTmp.InsertByteArray(Dns.GetHostAddresses(Proxy.Dest.Host).First.GetAddressBytes)
      pktTmp.InsertByteArray({&H17, &HE0})
      MyBase.Send(pktTmp.GetData)
    End Using
  End Sub

  Private Sub SOCKS5_USERPASS_Send()
    Using pktTmp As New DataBuffer
      pktTmp.InsertByte(&H1)
      pktTmp.InsertByte(Proxy.User.Length)
      If Proxy.User.Length > 0 Then pktTmp.InsertByteArray(System.Text.Encoding.ASCII.GetBytes(Proxy.User))
      pktTmp.InsertByte(Proxy.Pass.Length)
      If Proxy.Pass.Length > 0 Then pktTmp.InsertString(Proxy.Pass, 20127)
      MyBase.Send(pktTmp.GetData)
    End Using
  End Sub
End Class
Public Class UDPWrapper
  Inherits Connection
  Public Event SocketReceived(sender As Object, e As SocketReceivedEventArgs)
  Public Sub New()
    MyBase.New()
  End Sub
  Protected Overrides Sub ReceivedData(e As System.Net.Sockets.SocketAsyncEventArgs)
    RaiseEvent SocketReceived(New Object, New SocketReceivedEventArgs(e.Buffer))
    MyBase.ReceiveFrom(&H100000, "DATA")
  End Sub
End Class

Public MustInherit Class Connection
  Implements IDisposable
#Region "Connection Fields"
  Protected connectingResetEvent As AutoResetEvent
  Protected connectingVerifyResetEvent As AutoResetEvent
  Protected receivingResetEvent As AutoResetEvent
  Protected underlyingSocket As Socket
  Protected connectionPool As MemoryPool(Of SocketAsyncEventArgs)
  Protected transmitPool As MemoryPool(Of SocketAsyncEventArgs)
#End Region
#Region "Connection Properties"
  Public Property IsConnected() As Boolean
    Get
      Return m_IsConnected
    End Get
    Set(value As Boolean)
      m_IsConnected = value
    End Set
  End Property
  Private m_IsConnected As Boolean
  Public Property IsConnecting() As Boolean
    Get
      Return m_IsConnecting
    End Get
    Set(value As Boolean)
      m_IsConnecting = value
    End Set
  End Property
  Private m_IsConnecting As Boolean

  Public Property RemoteEndPoint() As DnsEndPoint
    Get
      Return m_RemoteEndPoint
    End Get
    Set(value As DnsEndPoint)
      m_RemoteEndPoint = value
    End Set
  End Property
  Private m_RemoteEndPoint As DnsEndPoint
#End Region
#Region "Connection Constructor"
  Public Sub New(remoteEp As DnsEndPoint)
    If remoteEp Is Nothing Then Throw New ArgumentNullException("remoteEp")
    receivingResetEvent = New AutoResetEvent(True)
    ' TODO: Test with multiple pending threads .. do we need to make this a ManualResetEvent .. ?
    connectingResetEvent = New AutoResetEvent(True)
    ' Slight hack needed. Our first reset event blocks other threads, this one signals a connection was made
    connectingVerifyResetEvent = New AutoResetEvent(False)
    connectionPool = New MemoryPool(Of SocketAsyncEventArgs)()
    transmitPool = New MemoryPool(Of SocketAsyncEventArgs)()
    RemoteEndPoint = remoteEp
  End Sub
  Public Sub New()
    receivingResetEvent = New AutoResetEvent(True)
    ' TODO: Test with multiple pending threads .. do we need to make this a ManualResetEvent .. ?
    connectingResetEvent = New AutoResetEvent(True)
    ' Slight hack needed. Our first reset event blocks other threads, this one signals a connection was made
    connectingVerifyResetEvent = New AutoResetEvent(False)
    connectionPool = New MemoryPool(Of SocketAsyncEventArgs)()
    transmitPool = New MemoryPool(Of SocketAsyncEventArgs)()
  End Sub
#End Region
#Region "Connection Methods"
  Public Sub Connect()
    If Not IsConnected Then
      IsConnecting = True
      underlyingSocket = New Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp)
      underlyingSocket.SetSocketOption(SocketOptionLevel.Socket, SocketOptionName.KeepAlive, True)
      Dim connectAsyncEventArgs = connectionPool.Pull()
      If RemoteEndPoint IsNot Nothing Then connectAsyncEventArgs.RemoteEndPoint = RemoteEndPoint
      If connectAsyncEventArgs.LastOperation = SocketAsyncOperation.None Then AddHandler connectAsyncEventArgs.Completed, AddressOf AsyncEventCompleted
      If Not underlyingSocket.ConnectAsync(connectAsyncEventArgs) Then
        Disconnect(ResString(My.Resources.SOCKET_ERR_FAILED, underlyingSocket.RemoteEndPoint.ToString, ErrorDetails(connectAsyncEventArgs)))
      End If
    End If
  End Sub
  Public Sub Disconnect(Optional Details As String = Nothing)
    If underlyingSocket IsNot Nothing Then
      IsConnecting = False
      If IsConnected Then
        IsConnected = False
        underlyingSocket.Close()
        If underlyingSocket IsNot Nothing Then
          underlyingSocket.Dispose()
          underlyingSocket = Nothing
          Disconnected(Details)
        End If
      Else
        underlyingSocket.Close()
        If underlyingSocket IsNot Nothing Then
          underlyingSocket.Dispose()
          underlyingSocket = Nothing
        End If
        Disconnected(Details)
      End If
    End If
  End Sub
  Public Function Bind(LocalEndPoint As IPEndPoint) As Boolean
    If LocalEndPoint Is Nothing Then Return False
    Try
      underlyingSocket = New Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp)
      Dim bindAsyncEventArgs = transmitPool.Pull()
      underlyingSocket.Bind(LocalEndPoint)
      IsConnecting = False
      IsConnected = True
      Return True
      ReceiveFrom(&H100000, "DATA")
    Catch ex As Exception
      Return False
    End Try
  End Function
  Public Sub Send(data As Byte())
    If data Is Nothing Then Throw New ArgumentNullException("data")
    If IsConnected Then
      Dim sendAsyncEventArgs = transmitPool.Pull()
      sendAsyncEventArgs.RemoteEndPoint = RemoteEndPoint
      If sendAsyncEventArgs.LastOperation = SocketAsyncOperation.None Then AddHandler sendAsyncEventArgs.Completed, AddressOf AsyncEventCompleted
      sendAsyncEventArgs.SetBuffer(data, 0, data.Length)
      If Not underlyingSocket.SendAsync(sendAsyncEventArgs) Then AsyncEventCompleted(Me, sendAsyncEventArgs)
    End If
  End Sub
  Public Sub SendTo(endPoint As EndPoint, data As Byte())
    If data Is Nothing Then Throw New ArgumentNullException("data")
    If IsConnected Then
      Dim sendToAsyncEventArgs = transmitPool.Pull
      sendToAsyncEventArgs.RemoteEndPoint = endPoint
      If sendToAsyncEventArgs.LastOperation = SocketAsyncOperation.None Then AddHandler sendToAsyncEventArgs.Completed, AddressOf AsyncEventCompleted
      sendToAsyncEventArgs.SetBuffer(data, 0, data.Length)
      If Not underlyingSocket.SendToAsync(sendToAsyncEventArgs) Then AsyncEventCompleted(Me, sendToAsyncEventArgs)
    End If
  End Sub
  Public Sub Receive(length As Integer, token As Object)
    If IsConnected Then
      receivingResetEvent.WaitOne()
      Dim receiveAsyncEventArgs = transmitPool.Pull()
      receiveAsyncEventArgs.RemoteEndPoint = RemoteEndPoint
      If receiveAsyncEventArgs.LastOperation = SocketAsyncOperation.None Then AddHandler receiveAsyncEventArgs.Completed, AddressOf AsyncEventCompleted
      receiveAsyncEventArgs.UserToken = token
      receiveAsyncEventArgs.SetBuffer(New Byte(length - 1) {}, 0, length)
      If Not underlyingSocket.ReceiveAsync(receiveAsyncEventArgs) Then AsyncEventCompleted(Me, receiveAsyncEventArgs)
    End If
  End Sub
  Protected Sub ReceiveNoLock(length As Integer, token As Object)
    If token Is Nothing Then Exit Sub
    If IsConnected Then
      Dim receiveAsyncEventArgs = transmitPool.Pull()
      receiveAsyncEventArgs.RemoteEndPoint = RemoteEndPoint
      If receiveAsyncEventArgs.LastOperation = SocketAsyncOperation.None Then AddHandler receiveAsyncEventArgs.Completed, AddressOf AsyncEventCompleted
      receiveAsyncEventArgs.UserToken = token
      receiveAsyncEventArgs.SetBuffer(New Byte(length - 1) {}, 0, length)
      If underlyingSocket IsNot Nothing AndAlso Not underlyingSocket.ReceiveAsync(receiveAsyncEventArgs) Then AsyncEventCompleted(Me, receiveAsyncEventArgs)
    End If
  End Sub
  Public Sub ReceiveFrom(length As Integer, token As Object)
    If IsConnected Then
      'receivingResetEvent.WaitOne()
      Dim receiveFromAsyncEventArgs = transmitPool.Pull
      If receiveFromAsyncEventArgs.LastOperation = SocketAsyncOperation.None Then AddHandler receiveFromAsyncEventArgs.Completed, AddressOf AsyncEventCompleted
      receiveFromAsyncEventArgs.UserToken = token
      receiveFromAsyncEventArgs.SetBuffer(New Byte(length - 1) {}, 0, length)
      If underlyingSocket IsNot Nothing AndAlso Not underlyingSocket.ReceiveFromAsync(receiveFromAsyncEventArgs) Then AsyncEventCompleted(Me, receiveFromAsyncEventArgs)
    End If
  End Sub
  Protected Overridable Sub Connected()
  End Sub
  Protected Overridable Sub ReceivedData(e As SocketAsyncEventArgs)
  End Sub
  Protected Overridable Sub Disconnected(Optional sError As String = Nothing)
  End Sub
  Private Sub AsyncEventCompleted(sender As Object, e As SocketAsyncEventArgs)
    Select Case e.SocketError
      Case SocketError.Success
        Select Case e.LastOperation
          Case SocketAsyncOperation.Connect
            connectingResetEvent.[Set]()
            connectingVerifyResetEvent.[Set]()
            IsConnecting = False
            IsConnected = True
            Connected()
          Case SocketAsyncOperation.Receive
            If e.BytesTransferred = 0 Then
              If e.LastOperation = SocketAsyncOperation.Connect Then
                connectionPool.Push(e)
              Else
                transmitPool.Push(e)
              End If
              If e.SocketError = SocketError.Success Then
                Disconnect(My.Resources.SOCKET_ERR_DROPPED)
              Else
                Disconnect(ErrorDetails(e))
              End If
              Exit Sub
            Else
              ReceivedData(e)
            End If
          Case SocketAsyncOperation.ReceiveFrom
            If e.BytesTransferred = 0 Then
              If e.LastOperation = SocketAsyncOperation.Connect Then
                connectionPool.Push(e)
              Else
                transmitPool.Push(e)
              End If
              If e.SocketError = SocketError.Success Then
                Disconnect(My.Resources.SOCKET_ERR_DROPPED)
              Else
                Disconnect(ErrorDetails(e))
              End If
              Exit Sub
            Else
              ReceivedData(e)
            End If
          Case SocketAsyncOperation.Disconnect
            Debug.Print("Async Disconnect Completed")
          Case Else
            'Debug.Print("Unhandled async event completed: " & e.LastOperation.ToString)
        End Select
        If e.LastOperation = SocketAsyncOperation.Connect Then
          connectionPool.Push(e)
        Else
          transmitPool.Push(e)
        End If
      Case Else
        Select Case e.LastOperation
          Case SocketAsyncOperation.Connect
            connectionPool.Push(e)
          Case SocketAsyncOperation.Disconnect
            Debug.Print("Async Disconnect Errored")
          Case Else
            transmitPool.Push(e)
        End Select
        Disconnect(ErrorDetails(e))
    End Select
  End Sub
#End Region

#Region "Useful Functions"
  Private Function ErrorDetails(e As SocketAsyncEventArgs) As String
    Select Case e.SocketError
      Case SocketError.Success : Return Nothing
      Case SocketError.AccessDenied : Return "Access to " & e.RemoteEndPoint.ToString & " denied."
      Case SocketError.AddressAlreadyInUse : Return "Address is already in use."
      Case SocketError.AddressFamilyNotSupported : Return "Address family " & e.RemoteEndPoint.AddressFamily.ToString & " not supported."
      Case SocketError.AddressNotAvailable : Return "Address is not available."
      Case SocketError.AlreadyInProgress : Return "Already in progress..."
      Case SocketError.ConnectionAborted : Return "Connection aborted!"
      Case SocketError.ConnectionRefused : Return "Connection refused by remote server!"
      Case SocketError.ConnectionReset : Return "Connection reset by remote peer!"
      Case SocketError.DestinationAddressRequired : Return "Destination address required."
      Case SocketError.Disconnecting : Return "Disconnecting..."
      Case SocketError.Fault : Return "Socket fault. Invalid address pointer. Aborting."
      Case SocketError.HostDown : Return "Remote server down."
      Case SocketError.HostNotFound : Return "Remote server not found."
      Case SocketError.HostUnreachable : Return "Remote server unreachable."
      Case SocketError.InProgress : Return "A blocking operation is in progress."
      Case SocketError.Interrupted : Return "Connection interrupted!"
      Case SocketError.InvalidArgument : Return "Invalid argument specified."
      Case SocketError.IOPending : Return "Overlapped socket operation is pending."
      Case SocketError.IsConnected : Return "Already connected."
      Case SocketError.MessageSize : Return "Message is too long"
      Case SocketError.NetworkDown : Return "Network not available."
      Case SocketError.NetworkReset : Return "Network reset."
      Case SocketError.NetworkUnreachable : Return "Network unreachable."
      Case SocketError.NoBufferSpaceAvailable : Return "Not enough available memory for network buffer."
      Case SocketError.NoData : Return "The requested name or IP address was not found on the name server."
      Case SocketError.NoRecovery : Return "Unrecoverable error. Terminating."
      Case SocketError.NotConnected : Return "Not connected."
      Case SocketError.NotInitialized : Return "Not initialized."
      Case SocketError.NotSocket : Return "Not a socket."
      Case SocketError.OperationAborted : Return "Operation aborted by user."
      Case SocketError.OperationNotSupported : Return "Operation not supported by address family " & e.RemoteEndPoint.AddressFamily.ToString & "."
      Case SocketError.ProcessLimit : Return "Too many processes are using the underlying socket."
      Case SocketError.ProtocolFamilyNotSupported : Return "Protocol faimly not supported."
      Case SocketError.ProtocolNotSupported : Return "Protocol not supported."
      Case SocketError.ProtocolOption : Return "Unknown, invalid, or unsupported protocol option or level."
      Case SocketError.ProtocolType : Return "Protocol type is incorrect for this socket type."
      Case SocketError.SocketNotSupported : Return "This socket is not supported by address family " & e.RemoteEndPoint.AddressFamily & "."
      Case SocketError.SystemNotReady : Return "Network subsystem is not ready."
      Case SocketError.TimedOut : Return "Connection timed out."
      Case SocketError.TooManyOpenSockets : Return "Too many open sockets!"
      Case SocketError.TryAgain : Return "Remote server could not be resolved. Try again later."
      Case SocketError.TypeNotFound : Return "Specified class type not found."
      Case SocketError.VersionNotSupported : Return "Socket version not supported."
      Case SocketError.WouldBlock : Return "Operation of non-blocking socket can not be completed immediately."
      Case Else : Return e.SocketError.ToString
    End Select
  End Function
#End Region
#Region "IDisposable"
#Region "IDisposable Property"
  ''' <summary>
  ''' Determines if the resources have been disposed of already.
  ''' </summary>
  Protected isDisposed As Boolean
#End Region
  ''' <summary>
  ''' Dispose of the underlying connection, any pools, and clean up managed resources.
  ''' </summary>
  Public Sub Dispose() Implements IDisposable.Dispose
    Dispose(True)
    GC.SuppressFinalize(Me)
  End Sub
  Private Sub Dispose(disposing As Boolean)
    If Not isDisposed Then
      If disposing Then
        If underlyingSocket IsNot Nothing Then underlyingSocket.Dispose()

        connectingResetEvent.Dispose()
        connectingVerifyResetEvent.Dispose()
        receivingResetEvent.Dispose()
      End If

      underlyingSocket = Nothing
      connectingResetEvent = Nothing
      receivingResetEvent = Nothing
    End If
  End Sub
#End Region
End Class
Public Class MemoryPool(Of T As New)
  Protected items As Stack(Of T)
  Protected ReadOnly sync As Object
  Public Sub New()
    items = New Stack(Of T)()
    sync = New Object()
  End Sub
  Public Function Pull() As T
    SyncLock sync
      If items.Count = 0 Then
        Return New T()
      Else
        Return items.Pop()
      End If
    End SyncLock
  End Function
  Public Sub Push(item As T)
    SyncLock sync
      items.Push(item)
    End SyncLock
  End Sub
End Class