﻿Imports System.Runtime.InteropServices
Imports System.ComponentModel
Friend NotInheritable Class NativeMethods
  Friend Structure SYSTEM_INFO
    Public wProcessorArchitecture As Short
    Public wReserved As Short
    Public dwPageSize As Integer
    Public lpMinimumApplicationAddress As IntPtr
    Public lpMaximumApplicationAddress As IntPtr
    Public dwActiveProcessorMask As IntPtr
    Public dwNumberOfProcessors As Integer
    Public dwProcessorType As Integer
    Public dwAllocationGranularity As Integer
    Public wProcessorLevel As Short
    Public wProcessorRevision As Short
  End Structure

  Friend Structure LV_ITEM
    Public mask As UInt32
    Public iItem As Int32
    Public iSubItem As Int32
    Public state As UInt32
    Public stateMask As UInt32
    Public pszText As String
    Public cchTextMax As Int32
    Public iImage As Int32
    Public lParam As IntPtr
  End Structure

  Friend Structure FLASHWINFO
    Public cbSize As Int32
    Public hwnd As IntPtr
    Public dwFlags As Int32
    Public uCount As Int32
    Public dwTimeout As Int32
  End Structure

  Friend Const FLASHW_CAPTION As Int32 = &H1
  Friend Const FLASHW_TRAY As Int32 = &H2
  Friend Const FLASHW_ALL As Int32 = (FLASHW_CAPTION Or FLASHW_TRAY)

  Private Sub New()
  End Sub

  <DllImport("kernel32.dll", CharSet:=CharSet.Auto)> _
  Friend Shared Sub GetNativeSystemInfo(ByRef lpSystemInfo As SYSTEM_INFO)
  End Sub

  <DllImport("user32.dll", CharSet:=CharSet.Unicode)> _
  Friend Shared Function FindWindow(lpClassName As String, lpWindowName As String) As IntPtr
  End Function

  <DllImport("user32.dll", SetLastError:=True, CharSet:=CharSet.Unicode)> _
  Friend Shared Function FindWindowEx(parentHandle As IntPtr, childAfter As IntPtr, lclassName As String, windowTitle As String) As IntPtr
  End Function

  <DllImport("user32", CharSet:=CharSet.Auto, SetLastError:=True, ExactSpelling:=True)> _
  Friend Shared Function GetWindow(hWnd As IntPtr, uCmd As Integer) As IntPtr
  End Function

  <DllImport("user32", CharSet:=CharSet.Unicode, SetLastError:=True)> _
  Friend Shared Function GetWindowText(hWnd As IntPtr, <Out(), MarshalAs(UnmanagedType.LPWStr)> lpString As String, nMaxCount As Integer) As Integer
  End Function

  <DllImport("user32.dll", SetLastError:=True, CharSet:=CharSet.Auto)> _
  Friend Shared Function SendMessage(hWnd As IntPtr, Msg As UInteger, wParam As IntPtr, <MarshalAs(UnmanagedType.AsAny)> lParam As Object) As IntPtr
  End Function

  <DllImport("user32.dll", SetLastError:=True, CharSet:=CharSet.Auto)> _
  Friend Shared Function PostMessage(hWnd As IntPtr, wMsg As UInteger, wParam As IntPtr, lParam As IntPtr) As IntPtr
  End Function

  <DllImport("user32.dll", CharSet:=CharSet.Unicode)> _
  Friend Shared Function MessageBox(hWnd As IntPtr, t As String, caption As String, t2 As UInt32) As Integer
  End Function

  <DllImport("kernel32.dll", CharSet:=CharSet.Unicode, setlasterror:=True)>
  Friend Shared Function WritePrivateProfileStringW(lpApplicationName As String, lpKeyName As String, lpString As String, lpFileName As String) As Integer
  End Function

  <DllImport("kernel32.dll", CharSet:=CharSet.Unicode, setlasterror:=True)>
  Friend Shared Function GetPrivateProfileStringW(lpApplicationName As String, lpKeyName As String, lpDefault As String, lpReturnedString As String, nSize As Int32, lpFileName As String) As Integer
  End Function

  <DllImport("gdi32.dll")>
  Friend Shared Function BitBlt(hdcDest As IntPtr, nXDest As Integer, nYDest As Integer, nWidth As Integer, nHeight As Integer, hdcSrc As IntPtr, nXSrc As Integer, nYSrc As Integer, dwRop As Integer) As Int32
  End Function

  <DllImport("User32.dll")>
  Friend Shared Function GetDC(hWnd As IntPtr) As IntPtr
  End Function

  <DllImport("User32.dll")>
  Friend Shared Function ReleaseDC(hWnd As IntPtr, hDC As IntPtr) As Integer
  End Function

  <DllImport("User32.dll")>
  Friend Shared Function FlashWindowEx(ByRef pfwi As FLASHWINFO) As Int32
  End Function
End Class