﻿Imports System.Runtime.InteropServices
Imports System.ComponentModel

Friend Class ModuleManager
  Implements IDisposable
  Private Class RC4
    Private State As Byte()
    Private X, Y As Byte

    Public Sub New(key As Byte())
      State = New Byte(255) {}
      X = 0
      Y = 0
      InitKey(key)
    End Sub

    Public Function Transform(ByRef buffer As Byte(), ByRef start As Integer, count As Integer) As Integer
      Return RC4Transform(buffer, start, count, buffer, start)
    End Function

    Private Sub InitKey(key As Byte())
      Dim A As Byte = 0
      Dim B As Byte = 0
      For I As Integer = 0 To 255
        State(I) = CByte(I)
      Next
      X = 0
      Y = 0
      For counter As Integer = 0 To 255
        B = CByte(key(A) + State(counter) + B)
        Dim tmp As Byte = State(counter)
        State(counter) = State(B)
        State(B) = tmp
        A = CByte((A + 1) Mod key.Length)
      Next
    End Sub

    Private Function RC4Transform(inBuffer As Byte(), inIndex As Integer, inCount As Integer, ByRef outBuffer As Byte(), ByRef outIndex As Integer) As Integer
      For I As Integer = 0 To inCount - 1
        X = CByte(X + 1)
        Y = CByte(State(X) + Y)
        Dim tmp As Byte = State(X)
        State(X) = State(Y)
        State(Y) = tmp
        Dim xorer As Byte = CByte(State(X) + State(Y))
        outBuffer(outIndex + I) = CByte(inBuffer(inIndex + I) Xor State(xorer))
      Next
      Return inCount
    End Function
  End Class
  Private Declare Auto Function LoadLibrary Lib "kernel32" (ByVal LibFilePath As String) As Integer
  Private Declare Function GetProcAddress Lib "kernel32" (ByVal ModuleHandle As Integer, ByVal ProcName As String) As Integer
  Private Declare Function FreeLibrary Lib "kernel32" (ByVal ModuleHandle As Integer) As Integer
  Private Delegate Function DllModule() As IntPtr
  Private hHandler, hvTable, hImpArray, hImpHandler, hImpvTable As IntPtr
  Private WithEvents cLib As ChallengeHandler
  Private cModules() As DelegateModule
  Private passwordParam As New InvokeArgs()
  Private DelegateHashTable As Hashtable
  Private Password As String
  Private bReturn() As Byte
  Private iFail As Integer

  Private Enum BufferIDs
    SessionKey = &HB6E372AE
    SRP_A = &H486B15AA
    SRP_M1 = &HBFD92CAD
    SRP_K = &H1609A775
    SRP_B = &H11F43626
    SRP_s = &HAA0B44F6
    SRP_Username = &H98D4D24E
    Password = &H2CC30838
    Second_Challenge = &H1B3433E7
    Username = &H59F8A2FC
    Seed = &H7A7D7B79
    Unknown_Password_03_128 = &HFD2FD63E
    IPv6 = &HF8AC9F37
    Status = &H92C4A81F
  End Enum

  Class DelegateModule
    <UnmanagedFunctionPointer(CallingConvention.StdCall, CharSet:=CharSet.Unicode)> _
    Public Delegate Sub DestroyDelegate()
    <UnmanagedFunctionPointer(CallingConvention.ThisCall, CharSet:=CharSet.Unicode)> _
    Public Delegate Sub InvokeCommandDelegate(This As IntPtr, ChallengeHandler As IntPtr, Command As IntPtr, Implementation As IntPtr, ParamCount As Integer)
    <UnmanagedFunctionPointer(CallingConvention.StdCall, CharSet:=CharSet.Unicode)> _
    Public Delegate Sub DataDelegate(ChallengeHandler As IntPtr, Data As IntPtr, Length As UInteger)
    <UnmanagedFunctionPointer(CallingConvention.StdCall, CharSet:=CharSet.Unicode)> _
    Public Delegate Sub DisposeModuleDelegate()

    Public Destroy As DestroyDelegate
    Public InvokeCommand As InvokeCommandDelegate
    Public Data As DataDelegate
    Public Dispose As DisposeModuleDelegate
    Public hLib As IntPtr
    Public hCreate As IntPtr

    Sub Init(hFunctions As IntPtr)
      Dim hDestroy As IntPtr = Marshal.ReadIntPtr(hFunctions)
      Dim hInvokeCommand As IntPtr = Marshal.ReadIntPtr(hFunctions, 4)
      Dim hData As IntPtr = Marshal.ReadIntPtr(hFunctions, 8)
      Dim hDispose As IntPtr = Marshal.ReadIntPtr(hFunctions, 12)
      Destroy = DirectCast(Marshal.GetDelegateForFunctionPointer(hDestroy, GetType(DestroyDelegate)), DestroyDelegate)
      InvokeCommand = DirectCast(Marshal.GetDelegateForFunctionPointer(hInvokeCommand, GetType(InvokeCommandDelegate)), InvokeCommandDelegate)
      Data = DirectCast(Marshal.GetDelegateForFunctionPointer(hData, GetType(DataDelegate)), DataDelegate)
      Dispose = DirectCast(Marshal.GetDelegateForFunctionPointer(hDispose, GetType(DisposeModuleDelegate)), DisposeModuleDelegate)
    End Sub
  End Class

  Shared Function BufferIDToString(ID As UInteger) As String
    Select Case ID
      Case BufferIDs.SessionKey : Return "Session Key"
      Case BufferIDs.SRP_A : Return "SRP_A"
      Case BufferIDs.SRP_M1 : Return "SRP_M1"
      Case BufferIDs.SRP_K : Return "SRP_K"
      Case BufferIDs.SRP_B : Return "SRP_B"
      Case BufferIDs.SRP_s : Return "SRP_s"
      Case BufferIDs.SRP_Username : Return "SRP_Username"
      Case BufferIDs.Password : Return "Password"
      Case BufferIDs.Second_Challenge : Return "Second Challenge"
      Case BufferIDs.Username : Return "Username"
      Case BufferIDs.Seed : Return "Seed"
      Case BufferIDs.Unknown_Password_03_128 : Return "Unknown Password"
      Case BufferIDs.IPv6 : Return "IPv6"
      Case BufferIDs.Status : Return "Status"
      Case Else : Return PadHex(ID, 8)
    End Select
  End Function

  Class DelegateLibrary
    Public Delegate Function GetBufferDelegate(Index As UInteger, ByRef Buffer As IntPtr, ByVal Length As IntPtr) As Integer
    Public Delegate Function SetBufferDelegate(Index As UInteger, Buffer As IntPtr, Length As Integer) As Integer
    Public Delegate Sub ClearBufferDelegate(Index As UInteger)
    Public Delegate Sub InvokeCommandDelegate(Command As IntPtr, Params As IntPtr, ParamCount As Integer)
    Public Delegate Sub SetResponseDataDelegate(Buffer As IntPtr, Length As Integer)
    Public Delegate Sub ClearResponseDataDelegate()
    Public Delegate Sub Function7Delegate()
    Public Delegate Sub Function8Delegate(ErrorCode As Integer, Unknown1 As Integer, Unknown2 As Integer)
    Event RunCommand(Command As String, params As IntPtr, ParamsCount As Integer)
    Event Fail(ErrorCode As Integer, Unk1 As Integer, Unk2 As Integer)

    Overridable Function GetBuffer(Index As UInteger, ByRef Buffer As IntPtr, ByVal Length As IntPtr) As Integer
      Debug.Print("GetBuffer")
      Debug.Print(" Index: " & BufferIDToString(Index))
      Debug.Print(" Buffer: " & Hex(Buffer.ToString))
      Debug.Print(" Length: " & Hex(Length.ToString))
      Return 1
    End Function
    Public Overridable Function SetBuffer(Index As UInteger, Buffer As IntPtr, Length As Integer) As Integer
      Debug.Print("Set Buffer")
      Debug.Print(" Index: " & BufferIDToString(Index))
      Debug.Print(" Buffer: " & Hex(Buffer.ToString))
      Debug.Print(" Length: " & Length)
      Return 1
    End Function
    Public Overridable Sub ClearBuffer(Index As UInteger)
      Debug.Print("Clear Buffer")
      Debug.Print(" Index: " & Index)
    End Sub
    Public Overridable Sub InvokeCommand(Command As IntPtr, Params As IntPtr, ParamCount As Integer)
      Debug.Print("Invoke Command: """ & Marshal.PtrToStringAnsi(Command) & """ [" & Hex(Params.ToString) & "|" & ParamCount & "]")
      RaiseEvent RunCommand(Command, Params, ParamCount)
    End Sub
    Public Overridable Sub SetResponseData(Buffer As IntPtr, Length As Integer)
      Debug.Print("Set Response Data")
      Debug.Print(" Buffer: " & Hex(Buffer.ToString))
      Debug.Print(" Length: " & Length)
    End Sub
    Public Overridable Sub ClearResponseData()
      'Debug.Print("Clear")
    End Sub
    Public Overridable Sub Function7()
      'Debug.Print("F7")
      RaiseEvent Fail(&HF7, 0, 0)
    End Sub
    Public Overridable Sub Function8(ErrorCode As Integer, Unknown1 As Integer, Unknown2 As Integer)
      'Debug.Print("F8")
      'Debug.Print(" Error Code: " & ErrorCode)
      'Debug.Print(" Unk1: " & Unknown1)
      'Debug.Print(" Unk2:" & Unknown2)
      RaiseEvent Fail(ErrorCode, Unknown1, Unknown2)
    End Sub
  End Class

  Class ChallengeHandler
    Inherits DelegateLibrary
    Private Structure BufferEntry
      Public sharedPtr As IntPtr
      Public BufferLength As Integer
    End Structure
    Dim BufferMap As New Hashtable
    Dim OutBuffer As Byte()
    Dim OutSize As Integer
    Event Response(bRet() As Byte)

    Public Overrides Function GetBuffer(Index As UInteger, ByRef Buffer As System.IntPtr, ByVal Length As IntPtr) As Integer
      If Not BufferMap.ContainsKey(Index) Then
        Debug.Print("Get Buffer " & PadHex(Index, 8) & ": Unset")
        Debug.Print("")
        Stop
        Return 0
      End If
      Dim bEntry As BufferEntry = DirectCast(BufferMap(Index), BufferEntry)
      Buffer = bEntry.sharedPtr
      Marshal.WriteInt32(Length, bEntry.BufferLength)
      Dim localBuffer() As Byte
      ReDim localBuffer(bEntry.BufferLength - 1)
      Marshal.Copy(Buffer, localBuffer, 0, bEntry.BufferLength)
      Debug.Print("Get Buffer " & BufferIDToString(Index) & ":")
      Debug.Print(FormatPacket(localBuffer))
      Debug.Print("")
      Return 1
    End Function

    Public Overrides Function SetBuffer(Index As UInteger, Buffer As System.IntPtr, Length As Integer) As Integer
      Dim sharedPtr As IntPtr
      Dim localBuffer() As Byte
      ReDim localBuffer(Length - 1)
      Marshal.Copy(Buffer, localBuffer, 0, Length)
      Debug.Print("Set Buffer " & BufferIDToString(Index) & ":")
      Debug.Print(FormatPacket(localBuffer))
      Debug.Print("")
      sharedPtr = Marshal.AllocHGlobal(Length)
      Marshal.Copy(localBuffer, 0, sharedPtr, Length)
      If BufferMap.ContainsKey(Index) Then
        BufferMap.Item(Index) = New BufferEntry With {.sharedPtr = sharedPtr, .BufferLength = Length}
      Else
        BufferMap.Add(Index, New BufferEntry With {.sharedPtr = sharedPtr, .BufferLength = Length})
      End If
      Return 1
    End Function

    Public Overrides Sub ClearBuffer(Index As UInteger)
      BufferMap.Remove(Index)
    End Sub

    Public Overrides Sub SetResponseData(Buffer As System.IntPtr, Length As Integer)
      ReDim OutBuffer(Length - 1)
      Marshal.Copy(Buffer, OutBuffer, 0, Length)
      OutSize = Length
      'Debug.Print("Response Data:")
      'Debug.Print(FormatPacket(OutBuffer))
      'Debug.Print("")
      RaiseEvent Response(OutBuffer)
    End Sub

    Sub SetResponseBuffer(Buffer As Byte(), Length As Integer)
      OutBuffer = Buffer
      OutSize = Length
    End Sub
  End Class

  Enum InvokeArgsType
    ARG_TYPE_BOOL = 0
    ARG_TYPE_INT = 1
    ARG_TYPE_STRING = 2
  End Enum

  Class InvokeArgs
    <UnmanagedFunctionPointer(CallingConvention.StdCall, CharSet:=CharSet.Unicode)> _
    Public Delegate Sub Function1Delegate(unk1 As Integer, unk2 As Integer, unk3 As Integer)
    <UnmanagedFunctionPointer(CallingConvention.StdCall, CharSet:=CharSet.Unicode)> _
    Public Delegate Function GetBooleanDelegate(ByRef Buffer As Integer) As Integer
    <UnmanagedFunctionPointer(CallingConvention.StdCall, CharSet:=CharSet.Unicode)> _
    Public Delegate Function GetIntDelegate(ByRef Buffer As Integer) As Integer
    <UnmanagedFunctionPointer(CallingConvention.StdCall, CharSet:=CharSet.Unicode)> _
    Public Delegate Function GetStringDelegate(ByRef Buffer As IntPtr) As Integer
    Public FieldType As Integer
    Public BooleanValue As Integer
    Public IntegerValue As Integer
    Public StringValue As String

    Public dFunction1 As Function1Delegate, dGetBoolean As GetBooleanDelegate, dGetInt As GetIntDelegate, dGetString As GetStringDelegate

    Public Sub New()
      dFunction1 = New Function1Delegate(AddressOf Function1)
      dGetBoolean = New GetBooleanDelegate(AddressOf GetBoolean)
      dGetInt = New GetIntDelegate(AddressOf GetInt)
      dGetString = New GetStringDelegate(AddressOf GetString)
    End Sub

    Public Sub SetFields(iFieldType As InvokeArgsType, iBooleanValue As Integer, iIntegerValue As Integer, sStringValue As String)
      FieldType = iFieldType
      BooleanValue = iBooleanValue
      IntegerValue = iIntegerValue
      StringValue = sStringValue
    End Sub

    Public Sub Function1(unk1 As Integer, unk2 As Integer, unk3 As Integer)
      Debug.Print("Function1")
      Debug.Print(" Unknown1: " & unk1)
      Debug.Print(" Unknown2: " & unk2)
      Debug.Print(" Unknown3: " & unk3)
    End Sub

    Public Function GetBoolean(ByRef Buffer As Integer) As Integer
      Buffer = BooleanValue
      'Debug.Print("GetBoolean: " & Buffer)
      Return 1
    End Function

    Public Function GetInt(ByRef Buffer As Integer) As Integer
      Buffer = IntegerValue
      'Debug.Print("GetInt: " & Buffer)
      Return 1
    End Function

    Public Function GetString(ByRef Buffer As IntPtr) As Boolean
      Buffer = Marshal.StringToHGlobalAnsi(StringValue)
      'Debug.Print("GetString: " & StringValue)
      Return 1
    End Function
  End Class

  Private Function DelegateToPtr(inDel As Object) As IntPtr
    Dim hDel As IntPtr = Marshal.GetFunctionPointerForDelegate(DirectCast(inDel, [Delegate]))
    DelegateHashTable.Add(hDel, inDel)
    Return hDel
  End Function

  Private Function GenerateSalt(Length As Integer) As Byte()
    Dim bRet(Length - 1) As Byte
    For I As Integer = 0 To Length - 1
      bRet(I) = CByte(Int(Rnd() * 256))
    Next
    Return bRet
  End Function

  Sub New(EMail As String, Pass As String, Server As String)
    Randomize()
    cLib = New ChallengeHandler
    DelegateHashTable = New Hashtable
    hHandler = Marshal.AllocHGlobal(4)
    hvTable = Marshal.AllocHGlobal(32)

    Marshal.WriteIntPtr(hHandler, hvTable)
    Marshal.WriteIntPtr(hvTable, DelegateToPtr(New DelegateLibrary.GetBufferDelegate(AddressOf cLib.GetBuffer)))
    Marshal.WriteIntPtr(hvTable, 4, DelegateToPtr(New DelegateLibrary.SetBufferDelegate(AddressOf cLib.SetBuffer)))
    Marshal.WriteIntPtr(hvTable, 8, DelegateToPtr(New DelegateLibrary.ClearBufferDelegate(AddressOf cLib.ClearBuffer)))
    Marshal.WriteIntPtr(hvTable, 12, DelegateToPtr(New DelegateLibrary.InvokeCommandDelegate(AddressOf cLib.InvokeCommand)))
    Marshal.WriteIntPtr(hvTable, 16, DelegateToPtr(New DelegateLibrary.SetResponseDataDelegate(AddressOf cLib.SetResponseData)))
    Marshal.WriteIntPtr(hvTable, 20, DelegateToPtr(New DelegateLibrary.ClearResponseDataDelegate(AddressOf cLib.ClearResponseData)))
    Marshal.WriteIntPtr(hvTable, 24, DelegateToPtr(New DelegateLibrary.Function7Delegate(AddressOf cLib.Function7)))
    Marshal.WriteIntPtr(hvTable, 28, DelegateToPtr(New DelegateLibrary.Function8Delegate(AddressOf cLib.Function8)))

    hImpArray = Marshal.AllocHGlobal(4)
    hImpHandler = Marshal.AllocHGlobal(4)
    hImpvTable = Marshal.AllocHGlobal(16)

    Marshal.WriteIntPtr(hImpArray, hImpHandler)
    Marshal.WriteIntPtr(hImpHandler, hImpvTable)
    Dim hFunc1Del As IntPtr = Marshal.GetFunctionPointerForDelegate(DirectCast(passwordParam.dFunction1, [Delegate]))
    Marshal.WriteIntPtr(hImpvTable, hFunc1Del)
    Dim hGetBoolDel As IntPtr = Marshal.GetFunctionPointerForDelegate(DirectCast(passwordParam.dGetBoolean, [Delegate]))
    Marshal.WriteIntPtr(hImpvTable, 4, hGetBoolDel)
    Dim hGetIntDel As IntPtr = Marshal.GetFunctionPointerForDelegate(DirectCast(passwordParam.dGetInt, [Delegate]))
    Marshal.WriteIntPtr(hImpvTable, 8, hGetIntDel)
    Dim hGetStrDel As IntPtr = Marshal.GetFunctionPointerForDelegate(DirectCast(passwordParam.dGetString, [Delegate]))
    Marshal.WriteIntPtr(hImpvTable, 12, hGetStrDel)

    Password = Pass
    Dim hMail As IntPtr = Marshal.StringToHGlobalAnsi(EMail)
    cLib.SetBuffer(BufferIDs.Username, hMail, EMail.Length + 1)
    Dim hSalt As IntPtr = Marshal.AllocHGlobal(128)
    Dim bSalt As Byte()
    bSalt = GenerateSalt(128)
    Marshal.Copy(bSalt, 0, hSalt, 128)
    cLib.SetBuffer(BufferIDs.Seed, hSalt, 128)

    Dim IPv4 As Net.IPAddress = (From address In Net.Dns.GetHostAddresses(Server) Where address.AddressFamily = Net.Sockets.AddressFamily.InterNetwork).FirstOrDefault
    Dim bV4() As Byte = IPv4.GetAddressBytes
    Dim IPv6 As Net.IPAddress = New Net.IPAddress({&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &HFF, &HFF, bV4(0), bV4(1), bV4(2), bV4(3)})
    For Each ip In Net.Dns.GetHostAddresses(Server)
      If ip.AddressFamily = Net.Sockets.AddressFamily.InterNetworkV6 Then
        IPv6 = ip
        Exit For
      End If
    Next
    Dim bIP() As Byte = IPv6.GetAddressBytes
    Dim hIP As IntPtr = Marshal.AllocHGlobal(16)
    Marshal.Copy(bIP, 0, hIP, 16)
    cLib.SetBuffer(BufferIDs.IPv6, hIP, 16)
  End Sub

  Public Function RunModule(LibPath As String, blob As Byte(), ByRef blobRet() As Byte) As Integer
    Debug.Print("Run Module " & LibPath)
    If cModules Is Nothing Then
      ReDim cModules(0)
    Else
      ReDim Preserve cModules(cModules.Length)
    End If
    Dim modI As Integer = cModules.Length - 1
    cModules(modI) = New DelegateModule
    cModules(modI).hLib = LoadLibrary(LibPath)
    If cModules(modI).hLib = 0 Then
      blobRet = Nothing
      Return &HFA1E
    End If
    Dim hCreate As IntPtr = GetProcAddress(cModules(modI).hLib, "CreateModule")
    cModules(modI).hCreate = Marshal.GetDelegateForFunctionPointer(hCreate, GetType(DllModule)).DynamicInvoke()
    Dim hFunctions As IntPtr = Marshal.ReadIntPtr(cModules(modI).hCreate)
    cModules(modI).Init(hFunctions)

    Dim Buffer As IntPtr = Marshal.AllocHGlobal(blob.Length)
    Marshal.Copy(blob, 0, Buffer, blob.Length)
    bReturn = Nothing
    iFail = 0
    cModules(modI).Data.Invoke(hHandler, Buffer, blob.Length)
    Marshal.FreeHGlobal(Buffer)
    blobRet = bReturn
    Return iFail
  End Function

  Private Sub cLib_Fail(ErrorCode As Integer, Unk1 As Integer, Unk2 As Integer) Handles cLib.Fail
    iFail = ErrorCode
  End Sub

  Private Sub cLib_Response(bRet() As Byte) Handles cLib.Response
    bReturn = bRet
  End Sub

  Private Sub cLib_RunCommand(Command As IntPtr, params As System.IntPtr, ParamsCount As Integer) Handles cLib.RunCommand
    If Marshal.PtrToStringAnsi(Command) = "RequestPassword" Then
      passwordParam.SetFields(InvokeArgsType.ARG_TYPE_STRING, 0, 0, Password)
      cModules(cModules.Length - 1).InvokeCommand(cModules(cModules.Length - 1).hCreate, hHandler, Command, hImpArray, 1)
    Else
      Debug.Print("Run Command: " & Marshal.PtrToStringAnsi(Command))
      cModules(cModules.Length - 1).InvokeCommand(cModules(cModules.Length - 1).hCreate, hHandler, Command, hImpArray, 1)
    End If
  End Sub

  Private serverDecrypt, clientEncrypt As RC4
  Public Sub EnableEncryption()
    Dim server_seed As Byte() = {&H68, &HE0, &HC7, &H2E, &HDD, &HD6, &HD2, &HF3, &H1E, &H5A, &HB1, &H55, &HB1, &H8B, &H63, &H1E}
    Dim client_seed As Byte() = {&HDE, &HA9, &H65, &HAE, &H54, &H3A, &H1E, &H93, &H9E, &H69, &HC, &HAA, &H68, &HDE, &H78, &H39}
    Dim bKey(63) As Byte
    Dim hKey As IntPtr = Marshal.AllocHGlobal(64)
    Dim hLen As IntPtr = Marshal.AllocHGlobal(4)
    cLib.GetBuffer(BufferIDs.SessionKey, hKey, hLen)
    Marshal.Copy(hKey, bKey, 0, 64)
    'Debug.Print("Session Key: " & BitConverter.ToString(bKey))
    Dim sessionKeyHMAC As New HMACSHA256(bKey)
    Dim decryptHASH = sessionKeyHMAC.ComputeHash(server_seed)
    Dim encryptHASH = sessionKeyHMAC.ComputeHash(client_seed)
    serverDecrypt = New RC4(decryptHASH)
    clientEncrypt = New RC4(encryptHASH)
  End Sub

  Public Sub Decrypt(ByRef data() As Byte, ByRef start As Integer, length As Integer)
    serverDecrypt.Transform(data, start, length)
  End Sub

  Public Sub Encrypt(ByRef data() As Byte, ByRef start As Integer, length As Integer)
    clientEncrypt.Transform(data, start, length)
  End Sub
#Region "IDisposable Support"
  Private disposedValue As Boolean ' To detect redundant calls

  ' IDisposable
  Protected Overridable Sub Dispose(disposing As Boolean)
    If Not Me.disposedValue Then
      If disposing Then
        ' TODO: dispose managed state (managed objects).
      End If

      Marshal.FreeHGlobal(hImpvTable)
      Marshal.FreeHGlobal(hImpHandler)
      Marshal.FreeHGlobal(hImpArray)

      Marshal.FreeHGlobal(hvTable)
      Marshal.FreeHGlobal(hHandler)
      'For Each del In DelegateHashTable.Keys
      '  Marshal.FreeHGlobal(del)
      'Next
      For Each cMod In cModules
        FreeLibrary(cMod.hLib)
      Next
      ' TODO: free unmanaged resources (unmanaged objects) and override Finalize() below.
      ' TODO: set large fields to null.
    End If
    Me.disposedValue = True
  End Sub

  ' TODO: override Finalize() only if Dispose(ByVal disposing As Boolean) above has code to free unmanaged resources.
  Protected Overrides Sub Finalize()
    ' Do not change this code.  Put cleanup code in Dispose(ByVal disposing As Boolean) above.
    Dispose(False)
    MyBase.Finalize()
  End Sub

  ' This code added by Visual Basic to correctly implement the disposable pattern.
  Public Sub Dispose() Implements IDisposable.Dispose
    ' Do not change this code.  Put cleanup code in Dispose(ByVal disposing As Boolean) above.
    Dispose(True)
    GC.SuppressFinalize(Me)
  End Sub
#End Region
End Class