﻿Imports Entelechy.NativeMethods
Imports iTunesLib
Public Class clsMediaControls
  Private Const WM_COMMAND As UInteger = &H111
  'General Results:
  '0 = Closed
  '1 = Success
  '2 = Failure
  '3 = Not supported
  Private Class mPlayer
    Friend sPath As String
    Public Overridable Property PlayerPath As String
      Get
        Return sPath
      End Get
      Set(value As String)
        sPath = value
      End Set
    End Property
    Public Overridable Function GetCurrentSong() As String
      Return Nothing
    End Function
    Public Overridable Function GetStatus() As Byte
      Return IIf(String.IsNullOrEmpty(GetCurrentSong), 0, 4)
    End Function
    Public Overridable Function SetVolume(value As Integer) As Byte
      Return 3
    End Function
    Public Overridable Function Load() As Byte
      Return 3
    End Function
    Public Overridable Function OpenFile(ByRef strFileName As String) As Byte
      Return 3
    End Function
    Public Overridable Function JumpToFile(strFile As String) As Byte
      Return 3
    End Function
    Public Overridable Function MPlay() As Byte
      Return 3
    End Function
    Public Overridable Function MPause() As Byte
      Return 3
    End Function
    Public Overridable Function MStop() As Byte
      Return 3
    End Function
    Public Overridable Function MPrevious() As Byte
      Return 3
    End Function
    Public Overridable Function MNext() As Byte
      Return 3
    End Function
    Public Overridable Function FadeOut() As Byte
      Return 3
    End Function
    Public Overridable Function StopAfter() As Byte
      Return 3
    End Function
    Public Overridable Function Repeat() As Byte
      Return 3
    End Function
    Public Overridable Function Shuffle() As Byte
      Return 3
    End Function
    Public Overridable Function Close() As Byte
      Return 3
    End Function
  End Class
  Private Class Winamp
    Inherits mPlayer
    Private Const WM_USER As UInteger = &H400
    Private Const WA_PREVTRACK As UInt16 = 40044
    Private Const WA_NEXTTRACK As UInt16 = 40048
    Private Const WA_PLAY As UInt16 = 40045
    Private Const WA_PAUSE As UInt16 = 40046
    Private Const WA_STOP As UInt16 = 40047
    Private Const WA_FADEOUTSTOP As UInt16 = 40147
    Private Const WA_STOPAFTERTRACK As UInt16 = 40157
    Private Const WA_FASTFORWARD As UInt16 = 40148 '5 secs
    Private Const WA_FASTREWIND As UInt16 = 40144 '5 secs
    Private Const WA_PLAYLISTHOME As UInt16 = 40154
    Private Const WA_PLAYLISTEND As UInt16 = 40158
    Private Const WA_DIALOGOPENFILE As UInt16 = 40029
    Private Const WA_DIALOGOPENURL As UInt16 = 40155
    Private Const WA_DIALOGFILEINFO As UInt16 = 40188
    Private Const WA_TIMEDISPLAYELAPSED As UInt16 = 40037
    Private Const WA_TIMEDISPLAYREMAINING As UInt16 = 40038
    Private Const WA_TOGGLEPREFERENCES As UInt16 = 40012
    Private Const WA_DIALOGVISUALOPTIONS As UInt16 = 40190
    Private Const WA_DIALOGVISUALPLUGINOPTIONS As UInt16 = 40191
    Private Const WA_STARTVISUALPLUGIN As UInt16 = 40192
    Private Const WA_TOGGLEABOUT As UInt16 = 40041
    Private Const WA_TOGGLEAUTOSCROLL As UInt16 = 40189
    Private Const WA_TOGGLEALWAYSONTOP As UInt16 = 40019
    Private Const WA_TOGGLEWINDOWSHADE As UInt16 = 40064
    Private Const WA_TOGGLEPLAYLISTWINDOWSHADE As UInt16 = 40266
    Private Const WA_TOGGLEDOUBLESIZE As UInt16 = 40165
    Private Const WA_TOGGLEEQ As UInt16 = 40036
    Private Const WA_TOGGLEPLAYLIST As UInt16 = 40040
    Private Const WA_TOGGLEMAINWINDOW As UInt16 = 40258
    Private Const WA_TOGGLEMINIBROWSER As UInt16 = 40298
    Private Const WA_TOGGLEEASYMOVE As UInt16 = 40186
    Private Const WA_VOLUMEUP As UInt16 = 40058 'increase 1%
    Private Const WA_VOLUMEDOWN As UInt16 = 40059 'decrease 1%
    Private Const WA_TOGGLEREPEAT As UInt16 = 40022
    Private Const WA_TOGGLESHUFFLE As UInt16 = 40023
    Private Const WA_DIALOGJUMPTOTIME As UInt16 = 40193
    Private Const WA_DIALOGJUMPTOFILE As UInt16 = 40194
    Private Const WA_DIALOGSKINSELECTOR As UInt16 = 40219
    Private Const WA_DIALOGCONFIGUREVISUALPLUGIN As UInt16 = 40221
    Private Const WA_RELOADSKIN As UInt16 = 40291
    Private Const WA_CLOSE As UInt16 = 40001
    Private Const WA_GETVERSION As UInt16 = 0
    Private Const WA_CLEARPLAYLIST As UInt16 = 101
    Private Const WA_GETSTATUS As UInt16 = 104
    Private Const WA_GETTRACKPOSITION As UInt16 = 105
    Private Const WA_GETTRACKLENGTH As UInt16 = 105
    Private Const WA_SEEKTOPOSITION As UInt16 = 106
    Private Const WA_SETVOLUME As UInt16 = 122
    Private Const WA_SETBALANCE As UInt16 = 123
    Private Const WA_GETEQDATA As UInt16 = 127
    Private Const WA_SETEQDATA As UInt16 = 128
    Private ReadOnly Property hWinamp As IntPtr
      Get
        Static hLast As IntPtr
        If Not hLast.Equals(IntPtr.Zero) Then
          Dim sTitle As String = Space(255)
          Dim iLen As Integer
          iLen = GetWindowText(hLast, sTitle, sTitle.Length)
          If iLen = 0 Then hLast = IntPtr.Zero
        End If
        If hLast.Equals(IntPtr.Zero) Then
          Dim hWnd As IntPtr = FindWindow("Winamp v1.x", Nothing)
          If hWnd.Equals(IntPtr.Zero) Then Return IntPtr.Zero
          hLast = hWnd
        End If
        Return hLast
      End Get
    End Property
    Public Overrides Function GetCurrentSong() As String
      Dim sTitle As String = Space(255)
      Dim iLen As Integer = GetWindowText(hWinamp, sTitle, sTitle.Length)
      If iLen = 0 Then Return Nothing
      If InStr(sTitle, " - Winamp") > 0 Then Return sTitle.Substring(0, InStr(sTitle, " - Winamp") - 1)
      Return Nothing
    End Function
    Public Overrides Function GetStatus() As Byte
      Dim Status As Integer
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      Status = SendMessage(hWinamp, WM_USER, 0, WA_GETSTATUS)
      Select Case Status
        Case 1 : Return 1
        Case 3 : Return 2
        Case Else : Return 3
      End Select
    End Function
    Public Overrides Function SetVolume(Value As Integer) As Byte
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      If Value < 0 Or Value > 255 Then Return 2
      SendMessage(hWinamp, WM_USER, Value, WA_SETVOLUME)
      Return 1
    End Function
    Public Overrides Function Load() As Byte
      If GetStatus() = 0 Then
        Dim ReturnValue As Integer = Shell(sPath, AppWinStyle.MinimizedNoFocus)
        If ReturnValue = 0 Then Return 0
        Return 1
      End If
      Return 2
    End Function
    Public Overrides Function OpenFile(ByRef strFileName As String) As Byte
      Dim ReturnValue As Double
      Try
        ReturnValue = Shell(sPath & " /ADD """ & strFileName & """", AppWinStyle.MinimizedNoFocus)
        If ReturnValue = 0 Then
          Return 0
        Else
          Return 1
        End If
      Catch ex As Exception
        Return 2
      End Try
    End Function
    Public Overrides Function JumpToFile(strFile As String) As Byte
      Dim lngEdit As IntPtr
      Dim lngListBox As IntPtr
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      Dim LastSong As String = GetCurrentSong()
      PostMessage(hWinamp, WM_COMMAND, &H9D02, 0)
      Do
        Application.DoEvents()
        Dim lngJumpto As Long = FindWindow("#32770", "Jump to file")
        lngEdit = FindWindowEx(lngJumpto, 0, "Edit", Nothing)
        lngListBox = FindWindowEx(lngJumpto, 0, "ListBox", Nothing)
      Loop Until Not lngListBox.Equals(IntPtr.Zero) And Not lngEdit.Equals(IntPtr.Zero)
      Application.DoEvents()
      If SendMessage(lngEdit, &HC, 0, strFile) <> 1 Then
        Return 2
      Else
        Dim tmpVal As Integer = Environment.TickCount
        Do Until Environment.TickCount - tmpVal > 500
          If SendMessage(lngListBox, &H18B, 0, 0US) <> 0 Then Exit Do
          Application.DoEvents()
        Loop
        Application.DoEvents()
        PostMessage(lngEdit, &H100, &HD, &H1C0001)
        Application.DoEvents()
        Do Until FindWindow("#32770", "Jump to file") = 0
          Application.DoEvents()
          PostMessage(lngEdit, &H100, &H1B, &H10001)
        Loop
        Application.DoEvents()
        If LastSong <> GetCurrentSong() Then Return 1
        If InStr(GetCurrentSong, strFile, CompareMethod.Text) > 0 Then Return 4
        Return 2
      End If
    End Function
    Public Overrides Function MPlay() As Byte
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      SendMessage(hWinamp, WM_COMMAND, WA_PLAY, 0)
      Return 1
    End Function
    Public Overrides Function MPause() As Byte
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      SendMessage(hWinamp, WM_COMMAND, WA_PAUSE, 0)
      Return 1
    End Function
    Public Overrides Function MStop() As Byte
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      SendMessage(hWinamp, WM_COMMAND, WA_STOP, 0)
      Return 1
    End Function
    Public Overrides Function MPrevious() As Byte
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      SendMessage(hWinamp, WM_COMMAND, WA_PREVTRACK, 0)
      Return 1
    End Function
    Public Overrides Function MNext() As Byte
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      SendMessage(hWinamp, WM_COMMAND, WA_NEXTTRACK, 0)
      Return 1
    End Function
    Public Overrides Function FadeOut() As Byte
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      SendMessage(hWinamp, WM_COMMAND, WA_FADEOUTSTOP, 0)
      Return 1
    End Function
    Public Overrides Function StopAfter() As Byte
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      SendMessage(hWinamp, WM_COMMAND, WA_STOPAFTERTRACK, 0)
      Return 1
    End Function
    Public Overrides Function Repeat() As Byte
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      SendMessage(hWinamp, WM_COMMAND, WA_TOGGLEREPEAT, 0)
      Return 1
    End Function
    Public Overrides Function Shuffle() As Byte
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      SendMessage(hWinamp, WM_COMMAND, WA_TOGGLESHUFFLE, 0)
      Return 1
    End Function
    Public Overrides Function Close() As Byte
      If hWinamp.Equals(IntPtr.Zero) Then Return 0
      SendMessage(hWinamp, WM_COMMAND, WA_CLOSE, 0)
      If GetStatus() = 0 Then Return 1
      Return 2
    End Function
  End Class
  Private Class iTunes
    Inherits mPlayer
    Dim NoCOM As Boolean
    Private Sub Init()
      NoCOM = True
      NoCOM = iTunesIsOn()
    End Sub
    Private Function iTunesIsOn() As Boolean
      If FindWindow("iTunes", Nothing).Equals(IntPtr.Zero) Then
        Return False
        NoCOM = True
      Else
        Return True
      End If
    End Function
    Public Overrides Function GetCurrentSong() As String
      If Not iTunesIsOn() Or NoCOM Then Return Nothing
      Dim iApp As New iTunesApp
      If iApp.CurrentTrack Is Nothing Then Return "Nothing"
      If Not iTunesIsOn() Then Return Nothing
      If String.IsNullOrEmpty(iApp.CurrentTrack.Artist) Then
        If Not iTunesIsOn() Then Return Nothing
        Return iApp.CurrentTrack.Name
      Else
        If Not iTunesIsOn() Then Return Nothing
        Return iApp.CurrentTrack.Artist & " - " & iApp.CurrentTrack.Name
      End If
    End Function
    Public Overrides Function GetStatus() As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      Select Case iApp.PlayerState
        Case ITPlayerState.ITPlayerStatePlaying : Return 1
        Case ITPlayerState.ITPlayerStateStopped : Return 3
        Case Else : Return 4
      End Select
    End Function
    Public Overrides Function SetVolume(Value As Integer) As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      iApp.SoundVolume = Value
      Return 1
    End Function
    Public Overrides Function Load() As Byte
      If GetStatus() = 0 Then
        Dim ReturnValue As Double
        ReturnValue = Shell(sPath, AppWinStyle.NormalNoFocus)
        If ReturnValue = 0 Then Return 2
        Init()
        Return 1
      End If
      Return 0
    End Function
    Public Overrides Function JumpToFile(strFile As String) As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      If String.IsNullOrEmpty(strFile) Then Return 0
      Dim Tracks_SongName As IITTrackCollection = iApp.LibraryPlaylist.Search(strFile, 5)
      If Tracks_SongName.Count = 0 Then Return 2
      Dim FoundTrack As IITTrack = Tracks_SongName.Item(1)
      If FoundTrack Is Nothing Then
        Return 2
      Else
        FoundTrack.Play()
        Return 1
      End If
    End Function
    Public Overrides Function MPlay() As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      Select Case iApp.PlayerState
        Case ITPlayerState.ITPlayerStateStopped
          iApp.PlayPause()
          Return 1
        Case ITPlayerState.ITPlayerStateFastForward, ITPlayerState.ITPlayerStateRewind
          iApp.Resume()
          Return 1
      End Select
      Return 2
    End Function
    Public Overrides Function MPause() As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      Select Case iApp.PlayerState
        Case ITPlayerState.ITPlayerStatePlaying
          iApp.PlayPause()
          Return 1
      End Select
      Return 2
    End Function
    Public Overrides Function MStop() As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      iApp.Stop()
      Return 1
    End Function
    Public Overrides Function MPrevious() As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      iApp.PreviousTrack()
      Return 1
    End Function
    Public Overrides Function MNext() As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      iApp.NextTrack()
      Return 1
    End Function
    Public Overrides Function FadeOut() As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      Dim CurVol As Integer = iApp.SoundVolume
      Dim RealVol As Integer = CurVol
      Do Until CurVol = 0
        CurVol = CurVol - 1
        SetVolume(CurVol)
        Application.DoEvents()
        Threading.Thread.Sleep(5)
      Loop
      MStop()
      SetVolume(RealVol)
      Return 1
    End Function
    Public Overrides Function Repeat() As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      Select Case iApp.LibraryPlaylist.SongRepeat
        Case ITPlaylistRepeatMode.ITPlaylistRepeatModeOff
          iApp.LibraryPlaylist.SongRepeat = ITPlaylistRepeatMode.ITPlaylistRepeatModeOne
          Return 4
        Case ITPlaylistRepeatMode.ITPlaylistRepeatModeOne

          iApp.LibraryPlaylist.SongRepeat = ITPlaylistRepeatMode.ITPlaylistRepeatModeAll
          Return 5
        Case ITPlaylistRepeatMode.ITPlaylistRepeatModeAll

          iApp.LibraryPlaylist.SongRepeat = ITPlaylistRepeatMode.ITPlaylistRepeatModeOff
          Return 6
      End Select
      Return 2
    End Function
    Public Overrides Function Shuffle() As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      iApp.LibraryPlaylist.Shuffle = Not iApp.LibraryPlaylist.Shuffle

      If iApp.LibraryPlaylist.Shuffle Then
        Return 4
      Else
        Return 5
      End If
    End Function
    Public Overrides Function Close() As Byte
      If Not iTunesIsOn() Or NoCOM Then Return 0
      Dim iApp As New iTunesApp
      iApp.Quit()
      NoCOM = True
      Return 1
    End Function
  End Class
  Private Class WMP
    Inherits mPlayer
    Private ReadOnly Property hWMP As IntPtr
      Get
        Static hLast As IntPtr
        If Not hLast.Equals(IntPtr.Zero) Then
          Dim sTitle As String = Space(255)
          Dim iLen As Integer
          iLen = GetWindowText(hLast, sTitle, sTitle.Length)
          If iLen = 0 Then hLast = IntPtr.Zero
        End If
        If hLast.Equals(IntPtr.Zero) Then
          Dim hWnd As IntPtr = FindWindow("WMPlayerApp", Nothing)
          If hWnd.Equals(IntPtr.Zero) Then Return IntPtr.Zero
          hLast = hWnd
        End If
        Return hLast
      End Get
    End Property
    Public Overrides Function GetCurrentSong() As String
      Dim sTitle As String = Space(255)
      Dim iLen As Integer
      If hWMP.Equals(IntPtr.Zero) Then Return Nothing
      iLen = GetWindowText(hWMP, sTitle, sTitle.Length)
      If iLen = 0 Then Return Nothing
      If sTitle.Contains(" - Windows Media Player") Then Return sTitle.Substring(0, InStr(sTitle, " - Windows Media Player") - 1)
      Return Nothing
    End Function
    Public Overrides Function SetVolume(value As Integer) As Byte
      If hWMP.Equals(IntPtr.Zero) Then Return 0
      value = (value \ 10) * 10
      For I = 0 To 9
        PostMessage(hWMP, WM_COMMAND, &H497F, 0)
      Next I
      If value <> 100 Then
        For I = 100 To value Step -10
          PostMessage(hWMP, WM_COMMAND, &H4980, 0)
        Next I
      End If
      Return 1
    End Function
    Public Overrides Function Load() As Byte
      If GetStatus() = 0 Then
        Dim ReturnValue As Integer = Shell(sPath, AppWinStyle.NormalNoFocus)
        If ReturnValue = 0 Then Return 2
        Return 1
      End If
      Return 0
    End Function
    Public Overrides Function MPlay() As Byte
      If hWMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hWMP, WM_COMMAND, &H4978, 0)
      Return 1
    End Function
    Public Overrides Function MPause() As Byte
      If hWMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hWMP, WM_COMMAND, &H4978, 0)
      Return 1
    End Function
    Public Overrides Function MStop() As Byte
      If hWMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hWMP, WM_COMMAND, &H4979, 0)
      Return 1
    End Function
    Public Overrides Function MPrevious() As Byte
      If hWMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hWMP, WM_COMMAND, &H497A, 0)
      Return 1
    End Function
    Public Overrides Function MNext() As Byte
      If hWMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hWMP, WM_COMMAND, &H497B, 0)
      Return 1
    End Function
    Public Overrides Function FadeOut() As Byte
      If hWMP.Equals(IntPtr.Zero) Then Return 0
      For I = 100 To 0 Step -10
        Threading.Thread.Sleep(10)
        SetVolume(I)
      Next I
      MStop()
      SetVolume(100)
      Return 1
    End Function
    Public Overrides Function Repeat() As Byte
      If hWMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hWMP, WM_COMMAND, &H499B, 0)
      Return 1
    End Function
    Public Overrides Function Shuffle() As Byte
      If hWMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hWMP, WM_COMMAND, &H499A, 0)
      Return 1
    End Function
    Public Overrides Function Close() As Byte
      If hWMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hWMP, WM_COMMAND, &HE141, 0)
      Return 1
    End Function
  End Class
  Private Class LimeLight
    Inherits mPlayer
    Private ReadOnly Property hLLMP As IntPtr
      Get
        Static hLast As IntPtr
        If Not hLast.Equals(IntPtr.Zero) Then
          Dim sTitle As String = Space(255)
          Dim iLen As Integer
          iLen = GetWindowText(hLast, sTitle, sTitle.Length)
          sTitle = sTitle.Substring(0, InStr(sTitle, vbNullChar) - 1)
          If InStr(sTitle, " (") > 0 Then sTitle = sTitle.Substring(0, InStrRev(sTitle, " (") - 1)
          If sTitle = "TRAYMESSAGES" Or sTitle = "Lime Light Media Player" Or sTitle = "Lime Light PlayList" Or sTitle = "Lime Light" Then iLen = 0
          If iLen = 0 Then hLast = IntPtr.Zero
        End If
        Dim sOwnerTitle As String = String.Empty
        Dim hWndLast As IntPtr = IntPtr.Zero
        Dim hWndOwner As IntPtr
        Dim hWnd As IntPtr
        Dim sTmp As String = String.Empty
        While sOwnerTitle <> "Lime Light"
          sOwnerTitle = Space(255)
          hWnd = FindWindowEx(0, hWndLast, "ThunderRT6FormDC", Nothing)
          If hWnd.Equals(IntPtr.Zero) Then Return IntPtr.Zero
          sTmp = Space(255)
          GetWindowText(hWnd, sTmp, sTmp.Length)
          sTmp = sTmp.Substring(0, InStr(sTmp, vbNullChar) - 1)
          hWndOwner = GetWindow(hWnd, 4)
          If Not hWndOwner.Equals(IntPtr.Zero) Then
            GetWindowText(hWndOwner, sOwnerTitle, sOwnerTitle.Length)
            sOwnerTitle = sOwnerTitle.Substring(0, InStr(sOwnerTitle, vbNullChar) - 1)
          End If
          hWndLast = hWnd
          If (sTmp Like "* [[]*/*[]] (*:*)") Then sOwnerTitle = String.Empty
          If String.IsNullOrEmpty(sTmp) Then sOwnerTitle = String.Empty
          If sTmp = "Lime Light" Then sOwnerTitle = String.Empty
          If sTmp = "Lime Light PlayList" Then sOwnerTitle = String.Empty
          If sTmp = "TRAYMESSAGES" Then sOwnerTitle = String.Empty
        End While
        hLast = hWnd
        If String.IsNullOrEmpty(sTmp) Then
          Return IntPtr.Zero
        Else
          Return hWnd
        End If
      End Get
    End Property
    Public Overrides Function GetCurrentSong() As String
      If hLLMP.Equals(IntPtr.Zero) Then Return Nothing
      Dim sTmp As String = Space(255)
      GetWindowText(hLLMP, sTmp, sTmp.Length)
      sTmp = sTmp.Substring(0, InStr(sTmp, vbNullChar) - 1)
      If sTmp.Contains(" (") Then sTmp = sTmp.Substring(0, InStrRev(sTmp, " (") - 1)
      If sTmp = "Lime Light Media Player" Then sTmp = "Nothing"
      Return sTmp
    End Function
    Public Overrides Function SetVolume(value As Integer) As Byte
      If hLLMP.Equals(IntPtr.Zero) Then Return 0
      value = (value \ 10) * 10
      For I = 0 To 9
        PostMessage(hLLMP, WM_COMMAND, 34, 0)
      Next I
      If value <> 100 Then
        For I = 100 To value Step -10
          PostMessage(hLLMP, WM_COMMAND, 33, 0)
        Next I
      End If
      Return 1
    End Function
    Public Overrides Function Load() As Byte
      If GetStatus() = 0 Then
        Dim ReturnValue As Integer = Shell(sPath, AppWinStyle.NormalNoFocus)
        If ReturnValue = 0 Then Return 2
        Return 1
      End If
      Return 0
    End Function
    Public Overrides Function JumpToFile(strFile As String) As Byte
      Dim ptrOpen As IntPtr
      Dim ptrEdit As IntPtr
      If hLLMP.Equals(IntPtr.Zero) Then Return 0
      Dim LastSong As String = GetCurrentSong()
      PostMessage(hLLMP, WM_COMMAND, 17, 0)
      Do
        Application.DoEvents()
        Dim ptrOpenDlg As IntPtr = FindWindow("ThunderRT6FormDC", "Open...")
        ptrOpen = FindWindowEx(ptrOpenDlg, IntPtr.Zero, "ThunderRT6CommandButton", "&Open")
        Dim ptrCombo As IntPtr = FindWindowEx(ptrOpenDlg, ptrOpen, "ThunderRT6ComboBox", Nothing)
        ptrEdit = FindWindowEx(ptrCombo, IntPtr.Zero, "Edit", Nothing)
      Loop Until Not ptrOpen.Equals(IntPtr.Zero) And Not ptrEdit.Equals(IntPtr.Zero)
      Dim s As New System.Text.StringBuilder(256)
      s.Insert(0, strFile, 1)
      If SendMessage(ptrEdit, &HC, 0, s) <> 1 Then
        Return 2
      Else
        Application.DoEvents()
        PostMessage(ptrOpen, &H201, &H1, &H40034)
        PostMessage(ptrOpen, &H202, &H0, &H40034)
        Do Until FindWindow("ThunderRT6FormDC", "Open...").Equals(IntPtr.Zero)
          Threading.Thread.Sleep(10)
          Application.DoEvents()
        Loop
        If LastSong <> GetCurrentSong() Then Return 1
        If InStr(GetCurrentSong, strFile, CompareMethod.Text) > 0 Then Return 4
        Return 2
      End If
    End Function
    Public Overrides Function MPlay() As Byte
      If hLLMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hLLMP, WM_COMMAND, 20, 0)
      Return 4
    End Function
    Public Overrides Function MPause() As Byte
      If hLLMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hLLMP, WM_COMMAND, 20, 0)
      Return 4
    End Function
    Public Overrides Function MStop() As Byte
      If hLLMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hLLMP, WM_COMMAND, 21, 0)
      Return 1
    End Function
    Public Overrides Function MPrevious() As Byte
      If hLLMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hLLMP, WM_COMMAND, 25, 0)
      Return 1
    End Function
    Public Overrides Function MNext() As Byte
      If hLLMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hLLMP, WM_COMMAND, 26, 0)
      Return 1
    End Function
    Public Overrides Function Repeat() As Byte
      If hLLMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hLLMP, WM_COMMAND, 22, 0)
      Return 1
    End Function
    Public Overrides Function Shuffle() As Byte
      If hLLMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hLLMP, WM_COMMAND, 28, 0)
      Return 1
    End Function
    Public Overrides Function Close() As Byte
      If hLLMP.Equals(IntPtr.Zero) Then Return 0
      PostMessage(hLLMP, WM_COMMAND, 39, 0)
      Return 1
    End Function
  End Class

  Private cPlayer As mPlayer
  Public Sub New()
    Select Case My.Settings.MediaPlayer
      Case "Winamp"
        cPlayer = New Winamp
        cPlayer.PlayerPath = My.Settings.PlayerPath
      Case "LimeLight"
        cPlayer = New LimeLight
        cPlayer.PlayerPath = My.Settings.PlayerPath
      Case "WMP"
        cPlayer = New WMP
        cPlayer.PlayerPath = My.Settings.PlayerPath
      Case "iTunes"
        cPlayer = New iTunes
        cPlayer.PlayerPath = My.Settings.PlayerPath
    End Select
  End Sub
  Public Function Load() As String
    Select Case cPlayer.Load
      Case 0 : Return ResString(My.Resources.MPLAYER_LOAD_0, My.Settings.MediaPlayer)
      Case 1 : Return ResString(My.Resources.MPLAYER_LOAD_1, My.Settings.MediaPlayer)
      Case 2 : Return ResString(My.Resources.MPLAYER_LOAD_2, My.Settings.MediaPlayer)
      Case Else : Return ResString(My.Resources.MPLAYER_LOAD_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
  Public Function GetSong() As String
    Dim sRet As String = cPlayer.GetCurrentSong
    If String.IsNullOrEmpty(sRet) Then Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
    Return sRet
  End Function
  Public Function OpenFile(Path As String) As String
    Select Case cPlayer.OpenFile(Path)
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return My.Resources.MPLAYER_OPEN_1
      Case 2 : Return My.Resources.MPLAYER_OPEN_2
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case Else : Return My.Resources.MPLAYER_OPEN_UNKNOWN
    End Select
  End Function
  Public Function JumpToFile(File As String) As String
    Select Case cPlayer.JumpToFile(File)
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return ResString(My.Resources.MPLAYER_JUMP_1, GetSong)
      Case 2 : Return ResString(My.Resources.MPLAYER_JUMP_2, File)
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case 4 : Return ResString(My.Resources.MPLAYER_JUMP_4, GetSong)
      Case Else : Return My.Resources.MPLAYER_JUMP_UNKNOWN
    End Select
  End Function
  Public Function SetVolume(Value As Integer) As String
    Select Case cPlayer.SetVolume(Value)
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return My.Resources.MPLAYER_VOLUME_1
      Case 2 : Return My.Resources.MPLAYER_VOLUME_2
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case Else : Return ResString(My.Resources.MPLAYER_VOLUME_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
  Public Function MPlay() As String
    Select Case cPlayer.MPlay
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return My.Resources.MPLAYER_PLAY_1
      Case 2 : Return ResString(My.Resources.MPLAYER_PLAY_2, My.Settings.MediaPlayer)
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case 4 : Return My.Resources.MPLAYER_PLAY_4
      Case Else : Return ResString(My.Resources.MPLAYER_PLAY_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
  Public Function MPause() As String
    Select Case cPlayer.MPause
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return My.Resources.MPLAYER_PAUSE_1
      Case 2 : Return ResString(My.Resources.MPLAYER_PAUSE_2, My.Settings.MediaPlayer)
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case 4 : Return My.Resources.MPLAYER_PLAY_4
      Case Else : Return ResString(My.Resources.MPLAYER_PAUSE_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
  Public Function MStop() As String
    Select Case cPlayer.MStop
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return My.Resources.MPLAYER_STOP_1
      Case 2 : Return ResString(My.Resources.MPLAYER_STOP_2, My.Settings.MediaPlayer)
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case Else : Return ResString(My.Resources.MPLAYER_STOP_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
  Public Function MPrevious() As String
    Select Case cPlayer.MPrevious
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return My.Resources.MPLAYER_PREVIOUS_1
      Case 2 : Return ResString(My.Resources.MPLAYER_PREVIOUS_2, My.Settings.MediaPlayer)
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case Else : Return ResString(My.Resources.MPLAYER_PREVIOUS_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
  Public Function MNext() As String
    Select Case cPlayer.MNext
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return My.Resources.MPLAYER_NEXT_1
      Case 2 : Return ResString(My.Resources.MPLAYER_NEXT_2, My.Settings.MediaPlayer)
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case Else : Return ResString(My.Resources.MPLAYER_NEXT_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
  Public Function FadeOut() As String
    Select Case cPlayer.FadeOut
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return My.Resources.MPLAYER_FADEOUT_1
      Case 2 : Return ResString(My.Resources.MPLAYER_FADEOUT_2, My.Settings.MediaPlayer)
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case Else : Return ResString(My.Resources.MPLAYER_FADEOUT_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
  Public Function StopAfter() As String
    Select Case cPlayer.StopAfter
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return My.Resources.MPLAYER_STOPAFTER_1
      Case 2 : Return ResString(My.Resources.MPLAYER_STOPAFTER_2, My.Settings.MediaPlayer)
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case Else : Return ResString(My.Resources.MPLAYER_STOPAFTER_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
  Public Function Repeat() As String
    Select Case cPlayer.Repeat
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return My.Resources.MPLAYER_REPEAT_1
      Case 2 : Return ResString(My.Resources.MPLAYER_REPEAT_2, My.Settings.MediaPlayer)
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case 4 : Return My.Resources.MPLAYER_REPEAT_4
      Case 5 : Return My.Resources.MPLAYER_REPEAT_5
      Case 6 : Return My.Resources.MPLAYER_REPEAT_6
      Case Else : Return ResString(My.Resources.MPLAYER_REPEAT_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
  Public Function Shuffle() As String
    Select Case cPlayer.Repeat
      Case 0 : Return ResString(My.Resources.MPLAYER_NO_LOAD, My.Settings.MediaPlayer)
      Case 1 : Return My.Resources.MPLAYER_SHUFFLE_1
      Case 2 : Return ResString(My.Resources.MPLAYER_SHUFFLE_2, My.Settings.MediaPlayer)
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case 4 : Return My.Resources.MPLAYER_SHUFFLE_4
      Case 5 : Return My.Resources.MPLAYER_SHUFFLE_5
      Case Else : Return ResString(My.Resources.MPLAYER_SHUFFLE_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
  Public Function Close() As String
    Select Case cPlayer.Close
      Case 0 : Return ResString(My.Resources.MPLAYER_CLOSE_0, My.Settings.MediaPlayer)
      Case 1 : Return ResString(My.Resources.MPLAYER_CLOSE_1, My.Settings.MediaPlayer)
      Case 2 : Return ResString(My.Resources.MPLAYER_CLOSE_2, My.Settings.MediaPlayer)
      Case 3 : Return ResString(My.Resources.MPLAYER_NO_SUPPORT, My.Settings.MediaPlayer)
      Case Else : Return ResString(My.Resources.MPLAYER_CLOSE_UNKNOWN, My.Settings.MediaPlayer)
    End Select
  End Function
End Class
