﻿Imports Entelechy.NativeMethods
Imports System.Runtime.InteropServices
Public Class ListViewWithIcons
  Inherits System.Windows.Forms.ListView
  Private Const LVM_FIRST As Int32 = &H1000
  Private Const LVM_GETITEM As Int32 = LVM_FIRST + 5
  Private Const LVM_SETITEM As Int32 = LVM_FIRST + 6
  Private Const LVIF_TEXT As Int32 = &H1
  Private Const LVIF_IMAGE As Int32 = &H2
  Private Const LVW_FIRST As Integer = &H1000
  Private Const LVM_GETEXTENDEDLISTVIEWSTYLE As Integer = LVW_FIRST + 54
  Private Const LVS_EX_GRIDLINES As Integer = &H1
  Private Const LVS_EX_SUBITEMIMAGES As Integer = &H2
  Private Const LVS_EX_CHECKBOXES As Integer = &H4
  Private Const LVS_EX_TRACKSELECT As Integer = &H8
  Private Const LVS_EX_HEADERDRAGDROP As Integer = &H10
  Private Const LVS_EX_FULLROWSELECT As Integer = &H20 ' applies to report mode only
  Private Const LVS_EX_ONECLICKACTIVATE As Integer = &H40
  <DllImport("user32.dll", SetLastError:=True, CharSet:=CharSet.Auto)> _
  Private Shared Function SendMessage(hWnd As IntPtr, Msg As UInteger, wParam As IntPtr, ByRef lParam As LV_ITEM) As IntPtr
  End Function
  Public Sub New()
    AddHandler Me.HandleCreated, AddressOf ListViewWithIcons_HandleCreated
    Me.DoubleBuffered = True
  End Sub
  Private Sub ListViewWithIcons_HandleCreated(sender As Object, e As EventArgs)
    Dim m As System.Windows.Forms.Message = New Message
    m.HWnd = Me.Handle
    m.Msg = LVM_GETEXTENDEDLISTVIEWSTYLE
    m.LParam = New IntPtr(LVS_EX_GRIDLINES Or LVS_EX_FULLROWSELECT Or LVS_EX_SUBITEMIMAGES Or LVS_EX_CHECKBOXES Or LVS_EX_TRACKSELECT)
    m.WParam = IntPtr.Zero
    Me.WndProc(m)
  End Sub
  Public Sub AddIconToSubitem(row As Integer, col As Integer, icon_num As Integer)
    Dim lvi As New LV_ITEM
    lvi.iItem = row
    lvi.iSubItem = col
    lvi.mask = ListViewWithIcons.LVIF_IMAGE
    lvi.iImage = icon_num
    SendMessage(Me.Handle, ListViewWithIcons.LVM_SETITEM, 0, lvi)
  End Sub
End Class