﻿Public Class clsKey
  Private sKey As String
  Private uProd As UInt32
  Private uPub As UInt32
  Private uPriv As UInt32
  Private bPriv(9) As Byte
  Private bRet As Byte
  Public Sub New(CDKey As String)
    sKey = CDKey
    bRet = Decode(sKey)
  End Sub
  Public Sub New(Product As UInt32, PublicVal As UInt32, PrivateVal As UInt32)
    uProd = Product
    uPub = PublicVal
    uPriv = PrivateVal
    Erase bPriv
    bRet = Encode(uProd, uPub, uPriv)
  End Sub
  Public Sub New(Product As UInt32, PublicVal As UInt32, PrivateVal() As Byte)
    uProd = Product
    uPub = PublicVal
    uPriv = 0
    bPriv = PrivateVal
    bRet = Encode(uProd, uPub, bPriv)
  End Sub
  Public Sub New(KeyStruct As BNUI.ProductKey)
    uProd = KeyStruct.ProductVal
    uPub = KeyStruct.PublicVal
    uPriv = KeyStruct.PrivateVal
    bPriv = KeyStruct.PrivateVal26
    If bPriv Is Nothing Then
      bRet = Encode(uProd, uPub, uPriv)
    Else
      bRet = Encode(uProd, uPub, bPriv)
    End If
  End Sub
  Public Property Key As String
    Get
      If sKey Is Nothing Then Return Nothing
      Select Case sKey.Length
        Case 13
          Return sKey.Substring(0, 4) & "-" & sKey.Substring(4, 5) & "-" & sKey.Substring(9, 4)
        Case 16
          Return sKey.Substring(0, 4) & "-" & sKey.Substring(4, 4) & "-" & sKey.Substring(8, 4) & "-" & sKey.Substring(12, 4)
        Case 26
          Return sKey.Substring(0, 6) & "-" & sKey.Substring(6, 4) & "-" & sKey.Substring(10, 6) & "-" & sKey.Substring(16, 4) & "-" & sKey.Substring(20, 6)
        Case Else
          Return sKey
      End Select
      Return sKey
    End Get
    Set(value As String)
      sKey = value
      bRet = Decode(sKey)
    End Set
  End Property
  Public Property Product As UInt32
    Get
      Return uProd
    End Get
    Set(value As UInt32)
      uProd = value
      If uProd <> 0 And uPub <> 0 And uPriv <> 0 Then bRet = Encode(uProd, uPub, uPriv)
      If uProd <> 0 And uPub <> 0 And bPriv IsNot {0, 0, 0, 0, 0, 0, 0, 0, 0, 0} Then bRet = Encode(uProd, uPub, bPriv)
    End Set
  End Property
  Public Property PublicVal As UInt32
    Get
      Return uPub
    End Get
    Set(value As UInt32)
      uPub = value
      If uProd <> 0 And uPub <> 0 And uPriv <> 0 Then bRet = Encode(uProd, uPub, uPriv)
      If uProd <> 0 And uPub <> 0 And bPriv IsNot {0, 0, 0, 0, 0, 0, 0, 0, 0, 0} Then bRet = Encode(uProd, uPub, bPriv)
    End Set
  End Property
  Public Property PrivateVal As UInt32
    Get
      Return uPriv
    End Get
    Set(value As UInt32)
      uPriv = value
      Erase bPriv
      If uProd <> 0 And uPub <> 0 And uPriv <> 0 Then bRet = Encode(uProd, uPub, uPriv)
    End Set
  End Property
  Public Property PrivateVal26 As Byte()
    Get
      Return bPriv
    End Get
    Set(value As Byte())
      bPriv = value
      uPriv = 0
      If uProd <> 0 And uPub <> 0 And bPriv IsNot {0, 0, 0, 0, 0, 0, 0, 0, 0, 0} Then bRet = Encode(uProd, uPub, bPriv)
    End Set
  End Property
  Public ReadOnly Property IsValid As Boolean
    Get
      Return bRet = 0
    End Get
  End Property
  Public Function GetHash(ClientToken As UInt32, ServerToken As UInt32, Optional NullDWORD As Boolean = True) As Byte()
    Dim iVal As Integer
    If NullDWORD Then
      iVal = 26
    Else
      iVal = 20
    End If
    Dim ms = New System.IO.MemoryStream(iVal)
    Dim bw = New System.IO.BinaryWriter(ms)
    If bPriv Is Nothing Then
      bw.Write(CType(ClientToken, UInt32))
      bw.Write(CType(ServerToken, UInt32))
      bw.Write(CType(uProd, UInt32))
      bw.Write(CType(uPub, UInt32))
      If NullDWORD Then bw.Write(CType(0, UInt32))
      bw.Write(CType(uPriv, UInt32))
      Dim bTmp() As Byte = ms.GetBuffer
      ms.Close()
      Return XSHA.CalculateHash(bTmp)
    Else
      bw.Write(ClientToken)
      bw.Write(ServerToken)
      bw.Write(uProd)
      bw.Write(uPub)
      bw.Write(bPriv)
      Dim bTmp() As Byte = ms.GetBuffer
      Dim SHA As New SHA1Managed
      ms.Close()
      Return SHA.ComputeHash(bTmp)
    End If
  End Function
  Private Function Decode(CDKey As String) As Byte
    CDKey = CDKey.Replace("-", String.Empty).ToUpper
    If CDKey.Length = 13 Then
      Erase bPriv
      Decode13DigitKey(CDKey, uProd, uPub, uPriv)
      If uProd = 0 And uPub = 0 And uPriv = 0 Then Return 3
      If uProd = &H1 Or uProd = &H2 Then Return 0
      Return 2
    ElseIf CDKey.Length = 16 Then
      Erase bPriv
      Decode16DigitKey(CDKey, uProd, uPub, uPriv)
      If uProd = 0 And uPub = 0 And uPriv = 0 Then Return 3
      If uProd = &H4 Or uProd = &H6 Or uProd = &HA Then Return 0
      Return 2
    ElseIf CDKey.Length = 26 Then
      uPriv = 0
      Decode26DigitKey(CDKey, uProd, uPub, bPriv)
      If Product = 0 And PublicVal = 0 And bPriv Is Nothing Then Return 3
      If uProd = &H5 Or uProd = &HE Or uProd = &H12 Or uProd = &H17 Or uProd = &H18 Or uProd = &H19 Then Return 0
      Return 2
    Else
      Return 1
    End If
  End Function
  Public Function Encode(Product As UInt32, PublicVal As UInt32, PrivateVal As UInt32) As Byte
    If Product = &H1 Or Product = &H2 Then
      sKey = Encode13DigitKey(Product, PublicVal, PrivateVal)
      If sKey IsNot Nothing Then Return 0
      Return 4
    ElseIf Product = &H4 Or Product = &H6 Or Product = &HA Then
      sKey = Encode16DigitKey(Product, PublicVal, PrivateVal)
      If sKey IsNot Nothing Then Return 0
      Return 4
    ElseIf Product = &HE Or Product = &H12 Or Product = &H17 Or Product = &H18 Or Product = &H19 Then
      Dim bPriv() As Byte = BitConverter.GetBytes(PrivateVal)
      sKey = Encode26DigitKey(Product, PublicVal, bPriv)
      If sKey IsNot Nothing Then Return 0
      Return 4
    End If
    Return 1
  End Function
  Public Function Encode(Product As UInt32, PublicVal As UInt32, PrivateVal() As Byte) As Byte
    If Product = &H1 Or Product = &H2 Then
      Dim uPriv As UInt32 = BitConverter.ToUInt32(PrivateVal, 0)
      sKey = Encode13DigitKey(Product, PublicVal, uPriv)
      If sKey IsNot Nothing Then Return 0
      Return 4
    ElseIf Product = &H4 Or Product = &H6 Or Product = &HA Then
      Dim uPriv As UInt32 = BitConverter.ToUInt32(PrivateVal, 0)
      sKey = Encode16DigitKey(Product, PublicVal, uPriv)
      If sKey IsNot Nothing Then Return 0
      Return 4
    ElseIf Product = &HE Or Product = &H12 Or Product = &H17 Or Product = &H18 Or Product = &H19 Then
      sKey = Encode26DigitKey(Product, PublicVal, PrivateVal)
      If sKey IsNot Nothing Then Return 0
      Return 4
    End If
    Return 1
  End Function
End Class

Friend Module Key_13
  Friend Sub Decode13DigitKey(Key As String, ByRef Product As UInt32, ByRef PublicVal As UInt32, ByRef PrivateVal As UInt32)
    Dim salt As Int32 = &H13AC9741
    Dim aOrd() As Byte = {6, 0, 2, 9, 3, 11, 1, 7, 5, 4, 10, 8}
    Dim Decoded(12) As Char
    For I As Int32 = 11 To 0 Step -1
      Dim C As Byte = Asc(Key.Substring(aOrd(I), 1))
      If C <= 55 Then
        Decoded(I) = Chr(C Xor (salt And 7))
        salt >>= 3
      Else
        Decoded(I) = Chr(C Xor I And 1)
      End If
    Next I
    Dim sDone As String = Decoded
    Product = UInt32.Parse(sDone.Substring(0, 2), Globalization.NumberStyles.AllowHexSpecifier)
    PublicVal = sDone.Substring(2, 7)
    PrivateVal = sDone.Substring(9, 3)
    'If Key.EndsWith(GetLastVal(Key)), then the last digit can go fuck itself.
  End Sub
  Friend Function Encode13DigitKey(Product As UInt32, PublicVal As UInt32, PrivateVal As UInt32) As String
    Dim salt As Int32 = &H13AC9741, aOrd() As Byte = {6, 0, 2, 9, 3, 11, 1, 7, 5, 4, 10, 8}, Encoded(12) As Char
    Dim Key() As Char = (PadValue(Product, 2) & PadValue(PublicVal, 7) & PadValue(PrivateVal, 3)).ToCharArray
    Dim C As Byte
    For I As Int32 = 11 To 0 Step -1
      C = Asc(Key(I))
      If C <= 55 Then Encoded(aOrd(I)) = Chr(C Xor (salt And 7)) : salt >>= 3 Else Encoded(aOrd(I)) = Chr(C Xor I And 1)
    Next I
    Encoded(12) = GetLastVal(Encoded)
    Return Encoded
  End Function
  Private Function GetLastVal(sKey As String) As Char
    Dim lLenVal As UInt32 = 3, Key() As Char = sKey.ToCharArray
    For I As Int32 = 0 To 11 : lLenVal = lLenVal + (CStr(Key(I)) Xor (lLenVal * 2)) : Next I
    Return CStr(lLenVal Mod 10)
  End Function
  Private Function PadValue(Value As UInt32, Length As UInt16) As String
    Dim sVal As String = CStr(Value)
    Do While sVal.Length < Length : sVal = "0" & sVal : Loop
    Return sVal
  End Function
End Module

Friend Module Key_16
  Friend Sub Decode16DigitKey(Key As String, ByRef Product As UInt32, ByRef PublicVal As UInt32, ByRef PrivateVal As UInt32)
    Dim salt As Int32 = &H13AC9741, aOrd() As Byte = {5, 6, 0, 1, 2, 3, 4, 9, 10, 11, 12, 13, 14, 15, 7, 8}
    Const CodeValues As String = "246789BCDEFGHJKMNPRTVWXZ"
    Dim cKey() As Char = Key.ToCharArray
    Dim N As Integer
    For I As Integer = 0 To 14 Step 2
      If Not CodeValues.Contains(cKey(I + 1)) OrElse Not CodeValues.Contains(cKey(I)) Then Exit Sub
      N = (CodeValues.IndexOf(cKey(I + 1))) + (CodeValues.IndexOf(cKey(I)) * 24) And &HFF
      cKey(I) = Chr(IIf(((N >> 4) And &HF) < 10, ((N >> 4) And &HF) + &H30, ((N >> 4) And &HF) + &H37))
      cKey(I + 1) = Chr(IIf((N And &HF) < 10, (N And &HF) + &H30, (N And &HF) + &H37))
    Next I
    Dim Decoded(15) As Char
    Dim C As Byte
    For I As Integer = 15 To 0 Step -1
      C = Asc(Char.ToUpper(cKey(aOrd(I))))
      If C <= 55 Then
        Decoded(I) = Chr(C Xor (salt And 7))
        salt >>= 3
      ElseIf C < 65 Then
        Decoded(I) = Chr(C Xor I And 1)
      Else
        Decoded(I) = Chr(C)
      End If
    Next
    Dim sDone As String = Decoded
    Product = UInt32.Parse(sDone.Substring(0, 2), Globalization.NumberStyles.AllowHexSpecifier)
    PublicVal = UInt32.Parse(sDone.Substring(2, 6), Globalization.NumberStyles.AllowHexSpecifier)
    PrivateVal = UInt32.Parse(sDone.Substring(8), Globalization.NumberStyles.AllowHexSpecifier)
  End Sub
  Friend Function Encode16DigitKey(Product As UInt32, PublicVal As UInt32, PrivateVal As UInt32) As String
    Dim salt As Int32 = &H13AC9741, aOrd() As Byte = {5, 6, 0, 1, 2, 3, 4, 9, 10, 11, 12, 13, 14, 15, 7, 8}, Encoded(15) As Char
    Const CodeValues As String = "246789BCDEFGHJKMNPRTVWXZ"
    Dim Key() As Char = (PadHex(Product, 2) & PadHex(PublicVal, 6) & PadHex(PrivateVal, 8)).ToCharArray
    For I As Int32 = 15 To 0 Step -1
      Dim C As Byte = Asc(Key(I))
      If C <= 55 Then
        Encoded(aOrd(I)) = Chr(C Xor (salt And 7))
        salt >>= 3
      ElseIf C < 65 Then
        Encoded(aOrd(I)) = Chr(C Xor I And 1)
      Else
        Encoded(aOrd(I)) = Chr(C)
      End If
    Next I
    Dim R As Int32 = 3
    For I As Int16 = 0 To 15 : R = R + ((IIf(IsNumeric(Encoded(I)), Asc(Encoded(I)) - &H30, Asc(Char.ToUpper(Encoded(I))) - &H37)) Xor (R * 2)) : Next I
    R = R And &HFF
    Dim tmpByte As Byte = &H80
    For I As Int16 = 14 To 0 Step -2
      Dim A As Int32 = IIf(IsNumeric(Encoded(I)), Asc(Encoded(I)) - &H30, Asc(Char.ToUpper(Encoded(I))) - &H37)
      Dim B As Int32 = (IIf(IsNumeric(Encoded(I + 1)), Asc(Encoded(I + 1)) - &H30, Asc(Char.ToUpper(Encoded(I + 1))) - &H37))
      A = UInt32.Parse(Hex(A) & Hex(B), Globalization.NumberStyles.AllowHexSpecifier)
      If R And tmpByte Then A = A + &H100
      B = 0
      While A >= &H18 : B = B + 1 : A = A - &H18 : End While
      Encoded(I) = Mid(CodeValues, B + 1, 1)
      Encoded(I + 1) = Mid(CodeValues, A + 1, 1)
      tmpByte = tmpByte / 2
    Next I
    Return Encoded
  End Function
  Friend Function PadHex(Value As UInt32, Length As UInt16) As String
    Dim sVal As String = Hex(Value)
    Do While sVal.Length < Length : sVal = "0" & sVal : Loop
    Return sVal
  End Function
End Module

Friend Module Key_26
  Private ReadOnly TRANSLATEMAP()() As Byte = {
    New Byte() {&H9, &H4, &H7, &HF, &HD, &HA, &H3, &HB, &H1, &H2, &HC, &H8, &H6, &HE, &H5, &H0},
    New Byte() {&H9, &HB, &H5, &H4, &H8, &HF, &H1, &HE, &H7, &H0, &H3, &H2, &HA, &H6, &HD, &HC},
    New Byte() {&HC, &HE, &H1, &H4, &H9, &HF, &HA, &HB, &HD, &H6, &H0, &H8, &H7, &H2, &H5, &H3},
    New Byte() {&HB, &H2, &H5, &HE, &HD, &H3, &H9, &H0, &H1, &HF, &H7, &HC, &HA, &H6, &H4, &H8},
    New Byte() {&H6, &H2, &H4, &H5, &HB, &H8, &HC, &HE, &HD, &HF, &H7, &H1, &HA, &H0, &H3, &H9},
    New Byte() {&H5, &H4, &HE, &HC, &H7, &H6, &HD, &HA, &HF, &H2, &H9, &H1, &H0, &HB, &H8, &H3},
    New Byte() {&HC, &H7, &H8, &HF, &HB, &H0, &H5, &H9, &HD, &HA, &H6, &HE, &H2, &H4, &H3, &H1},
    New Byte() {&H3, &HA, &HE, &H8, &H1, &HB, &H5, &H4, &H2, &HF, &HD, &HC, &H6, &H7, &H9, &H0},
    New Byte() {&HC, &HD, &H1, &HF, &H8, &HE, &H5, &HB, &H3, &HA, &H9, &H0, &H7, &H2, &H4, &H6},
    New Byte() {&HD, &HA, &H7, &HE, &H1, &H6, &HB, &H8, &HF, &HC, &H5, &H2, &H3, &H0, &H4, &H9},
    New Byte() {&H3, &HE, &H7, &H5, &HB, &HF, &H8, &HC, &H1, &HA, &H4, &HD, &H0, &H6, &H9, &H2},
    New Byte() {&HB, &H6, &H9, &H4, &H1, &H8, &HA, &HD, &H7, &HE, &H0, &HC, &HF, &H2, &H3, &H5},
    New Byte() {&HC, &H7, &H8, &HD, &H3, &HB, &H0, &HE, &H6, &HF, &H9, &H4, &HA, &H1, &H5, &H2},
    New Byte() {&HC, &H6, &HD, &H9, &HB, &H0, &H1, &H2, &HF, &H7, &H3, &H4, &HA, &HE, &H8, &H5},
    New Byte() {&H3, &H6, &H1, &H5, &HB, &HC, &H8, &H0, &HF, &HE, &H9, &H4, &H7, &HA, &HD, &H2},
    New Byte() {&HA, &H7, &HB, &HF, &H2, &H8, &H0, &HD, &HE, &HC, &H1, &H6, &H9, &H3, &H5, &H4},
    New Byte() {&HA, &HB, &HD, &H4, &H3, &H8, &H5, &H9, &H1, &H0, &HF, &HC, &H7, &HE, &H2, &H6},
    New Byte() {&HB, &H4, &HD, &HF, &H1, &H6, &H3, &HE, &H7, &HA, &HC, &H8, &H9, &H2, &H5, &H0},
    New Byte() {&H9, &H6, &H7, &H0, &H1, &HA, &HD, &H2, &H3, &HE, &HF, &HC, &H5, &HB, &H4, &H8},
    New Byte() {&HD, &HE, &H5, &H6, &H1, &H9, &H8, &HC, &H2, &HF, &H3, &H7, &HB, &H4, &H0, &HA},
    New Byte() {&H9, &HF, &H4, &H0, &H1, &H6, &HA, &HE, &H2, &H3, &H7, &HD, &H5, &HB, &H8, &HC},
    New Byte() {&H3, &HE, &H1, &HA, &H2, &HC, &H8, &H4, &HB, &H7, &HD, &H0, &HF, &H6, &H9, &H5},
    New Byte() {&H7, &H2, &HC, &H6, &HA, &H8, &HB, &H0, &HF, &H4, &H3, &HE, &H9, &H1, &HD, &H5},
    New Byte() {&HC, &H4, &H5, &H9, &HA, &H2, &H8, &HD, &H3, &HF, &H1, &HE, &H6, &H7, &HB, &H0},
    New Byte() {&HA, &H8, &HE, &HD, &H9, &HF, &H3, &H0, &H4, &H6, &H1, &HC, &H7, &HB, &H2, &H5},
    New Byte() {&H3, &HC, &H4, &HA, &H2, &HF, &HD, &HE, &H7, &H0, &H5, &H8, &H1, &H6, &HB, &H9},
    New Byte() {&HA, &HC, &H1, &H0, &H9, &HE, &HD, &HB, &H3, &H7, &HF, &H8, &H5, &H2, &H4, &H6},
    New Byte() {&HE, &HA, &H1, &H8, &H7, &H6, &H5, &HC, &H2, &HF, &H0, &HD, &H3, &HB, &H4, &H9},
    New Byte() {&H3, &H8, &HE, &H0, &H7, &H9, &HF, &HC, &H1, &H6, &HD, &H2, &H5, &HA, &HB, &H4},
    New Byte() {&H3, &HA, &HC, &H4, &HD, &HB, &H9, &HE, &HF, &H6, &H1, &H7, &H2, &H0, &H5, &H8}}
  Private Const CodeValues As String = "246789BCDEFGHJKMNPRTVWXYZ"
  Private ReadOnly aOrd() As Byte = {30, 27, 24, 21, 18, 15, 12, 9, 6, 3, 0, 49, 46,
                                    43, 40, 37, 34, 31, 28, 25, 22, 19, 16, 13, 10, 7,
                                    4, 1, 50, 47, 44, 41, 38, 35, 32, 29, 26, 23, 20,
                                    17, 14, 11, 8, 5, 2, 51, 48, 45, 42, 39, 36, 33}
  Private ReadOnly bOrder() As Byte = {8, 9, 4, 5, 6, 7, 0, 1, 2, 3}
  Friend Sub Decode26DigitKey(Key As String, ByRef Product As UInt32, ByRef PublicVal As UInt32, ByRef PrivateVal() As Byte)
    Try
      Dim cKey() As Char = Key.ToCharArray
      Dim n_digitsBase5(0 To 51) As Byte
      For I As Integer = 0 To 26 - 1
        If Not CodeValues.Contains(cKey(I)) Then Exit Sub
        Dim bC As Byte = CodeValues.IndexOf(cKey(I))
        n_digitsBase5(aOrd(I * 2)) = CByte(bC \ 5)
        n_digitsBase5(aOrd(I * 2 + 1)) = CByte(bC Mod 5)
      Next I
      Erase cKey
      Dim n As Numerics.BigInteger = 0
      For I As Integer = 51 To 0 Step -1 : n = n * 5 + n_digitsBase5(I) : Next I
      Erase n_digitsBase5
      Dim nbytes() As Byte = n.ToByteArray
      Dim nibbles(0 To 29) As Byte
      For I As Integer = 0 To 14
        nibbles(I << 1) = nbytes(I) And &HF
        nibbles((I << 1) + 1) = nbytes(I) >> 4
      Next
      Erase nbytes
      Dim perm() As Byte, c As Byte
      For R As Integer = 29 To 0 Step -1
        perm = TRANSLATEMAP(R)
        c = nibbles(R)
        For r2 As Integer = 29 To 0 Step -1
          If R = r2 Then Continue For
          c = perm(nibbles(r2) Xor perm(c))
        Next r2
        nibbles(R) = perm(c)
      Next R
      Erase perm
      Dim nLen As Integer = (nibbles.Length >> 1) - 1
      Dim bTmp(nLen) As Byte
      For I As Integer = 0 To nLen
        bTmp(I) = nibbles(I << 1) Or (nibbles((I << 1) Or 1) << 4)
      Next
      Erase nibbles
      Dim bits As New BitArray(bTmp)
      Erase bTmp
      For I As Integer = 0 To 119
        Dim J As Integer = (I * 11) Mod 120
        If J <= I Then Continue For
        Dim b As Boolean = bits.Get(I)
        bits(I) = bits(J)
        bits.Set(J, b)
      Next I
      Dim bb(0 To 14) As Byte
      bits.CopyTo(bb, 0)
      If bb(&HE) = &H0 Then
        Product = bb(&HD) >> 2
        PublicVal = BitConverter.ToUInt32(bb, &HA) And &H3FFFFFF
        ReDim PrivateVal(9)
        For I As Integer = 0 To 9
          PrivateVal(I) = bb(bOrder(I))
        Next
      Else
        Product = 0
        PublicVal = 0
        Erase PrivateVal
      End If
    Catch ex As Exception
      Product = 0
      PublicVal = 0
      Erase PrivateVal
    End Try
  End Sub
  Friend Function Encode26DigitKey(Product As UInt32, PublicVal As UInt32, PrivateVal() As Byte) As String
    Dim bb(0 To 14) As Byte
    If PrivateVal.Length > 9 Then
      For I As Integer = 0 To 9 : bb(bOrder(I)) = PrivateVal(I) : Next
    Else
      Dim bPriv(9) As Byte
      Array.Copy(PrivateVal, 0, bPriv, 10 - PrivateVal.Length, PrivateVal.Length)
      For I As Integer = 0 To 9
        bb(bOrder(I)) = bPriv(I)
      Next
    End If
    bb(&HA) = BitConverter.GetBytes(PublicVal)(0)
    bb(&HB) = BitConverter.GetBytes(PublicVal)(1)
    bb(&HC) = BitConverter.GetBytes(PublicVal)(2)
    bb(&HD) = (Product << 2) Or (&H3 And BitConverter.GetBytes(PublicVal)(3))
    Dim bits As New BitArray(bb)
    For I As Integer = 0 To 119
      Dim J As Integer = (I * 11) Mod 120
      If J <= I Then Continue For
      Dim b As Boolean = bits.Get(I)
      bits(I) = bits(J)
      bits.Set(J, b)
    Next I
    Dim nibbles(0 To 29) As Byte
    For I As Integer = 0 To 29
      For J As Integer = 3 To 0 Step -1
        If bits.Get(I * 4 + J) Then nibbles(I) = nibbles(I) Or (&H1 << J)
      Next J
    Next I
    Dim perm() As Byte, c As Byte
    For R As Integer = 0 To 29
      perm = TRANSLATEMAP(R)
      c = FindC(perm, nibbles(R))
      For r2 As Integer = 0 To 29
        If R = r2 Then Continue For
        c = FindC(perm, nibbles(r2) Xor FindC(perm, c))
      Next r2
      nibbles(R) = c
    Next
    Dim nLen As Integer = (nibbles.Length >> 1) - 1
    Dim bTmp(nLen + 1) As Byte
    Dim nI As Integer
    For I As Integer = 0 To nLen
      nI = I << 1
      bTmp(I) = nibbles(nI) Or (nibbles((nI) Or 1) << 4)
    Next
    Erase nibbles
    Dim n As New Numerics.BigInteger(bTmp)
    Dim n_digitsBase5(0 To 51) As Byte
    For I As Integer = 0 To 51
      n_digitsBase5(I) = n Mod 5
      n = (n - n_digitsBase5(I)) / 5
    Next
    Dim bC As Byte, sKey As String = Nothing
    For I As Integer = 0 To 26 - 1
      bC = (n_digitsBase5(aOrd(I * 2)) * 5) + n_digitsBase5(aOrd(I * 2 + 1))
      sKey &= CodeValues.Substring(bC, 1)
    Next I
    Return sKey
  End Function
  Private Function FindC(perm() As Byte, Nibble As Byte) As Byte
    For I As Integer = 0 To perm.Length - 1
      If perm(I) = Nibble Then Return I
    Next
    Return 0
  End Function
  Private Function BitArrayToString(bArray As BitArray) As String
    Dim sTmp As String = String.Empty
    For I As Integer = 0 To bArray.Length - 1
      sTmp &= IIf(bArray(I), "1", "0")
    Next
    Return sTmp
  End Function
End Module