﻿Public Class PcxIcon
  Private C_Image As Drawing.Image
  Public ReadOnly Property Image As Drawing.Image
    Get
      Return C_Image
    End Get
  End Property
  Friend Sub New(img As Drawing.Image)
    C_Image = img
  End Sub
End Class

Public Class PcxFileParser
  Private C_Image As Drawing.Image
  Private C_Icons() As PcxIcon
  Public ReadOnly Property AllIcons As PcxIcon()
    Get
      Return C_Icons
    End Get
  End Property
  Public ReadOnly Property FullImage As Drawing.Image
    Get
      Return C_Image
    End Get
  End Property
  Public Sub New(filePath As String)
    Dim PCX As FreeImageAPI.FIBITMAP = FreeImageAPI.FreeImage.Load(FreeImageAPI.FREE_IMAGE_FORMAT.FIF_PCX, filePath, FreeImageAPI.FREE_IMAGE_LOAD_FLAGS.DEFAULT)
    ParsePCX(PCX)
    PCX.SetNull()
  End Sub
  Public Sub New(pcxFileStream As System.IO.Stream)
    Dim PCX As FreeImageAPI.FIBITMAP = FreeImageAPI.FreeImage.LoadFromStream(pcxFileStream, FreeImageAPI.FREE_IMAGE_LOAD_FLAGS.DEFAULT, FreeImageAPI.FREE_IMAGE_FORMAT.FIF_PCX)
    ParsePCX(PCX)
    PCX.SetNull()
  End Sub
  Private Sub ParsePCX(PCX As FreeImageAPI.FIBITMAP)
    Dim bmpStream As New IO.MemoryStream
    FreeImageAPI.FreeImage.SaveToStream(PCX, bmpStream, FreeImageAPI.FREE_IMAGE_FORMAT.FIF_BMP)
    C_Image = Image.FromStream(bmpStream)
    bmpStream.Close()
    Dim iWidth As Integer = C_Image.Width / 28 - 1
    Dim iHeight As Integer = C_Image.Height / 14 - 1
    ReDim C_Icons((iWidth + 1) * (iHeight + 1))
    Dim I As Integer = 0
    For X As Integer = 0 To iWidth
      For Y As Integer = 0 To iHeight
        Dim tIMG As Image = New System.Drawing.Bitmap(28, 14)
        Dim g As Graphics = Graphics.FromImage(tIMG)
        g.InterpolationMode = Drawing2D.InterpolationMode.HighQualityBicubic
        g.DrawImage(C_Image, -(X * 28), -(Y * 14), C_Image.Width, C_Image.Height)
        g.Dispose()
        Dim cPCX As New PcxIcon(tIMG)
        C_Icons(I) = cPCX
        I += 1
      Next Y
    Next X
  End Sub
End Class

Public Module modIconHandler
  Public Sub ParseAllIcons()
    If Not My.Computer.FileSystem.DirectoryExists(AppTemp & "\icons") Then My.Computer.FileSystem.CreateDirectory(AppTemp & "\icons")
    If Not My.Computer.FileSystem.DirectoryExists(AppStore & "\icons") Then My.Computer.FileSystem.CreateDirectory(AppStore & "\icons")
    ParseStandardIcons()
    Dim bW3 As Boolean = ParseWAR3Icons()
    If My.Computer.FileSystem.FileExists(AppStore & "\icons\icons_STAR.bni") AndAlso Not My.Computer.FileSystem.DirectoryExists(AppTemp & "\icons\icons_STAR") Then ParseIconsSTAR()
    If My.Computer.FileSystem.FileExists(AppStore & "\icons\icons-WAR3.bni") AndAlso bW3 Then ParseIconsWAR3()
  End Sub
  Private Function CheckDir(Directory As String, ImageCount As Integer)
    Dim bDo As Boolean = False
    If My.Computer.FileSystem.DirectoryExists(Directory) Then
      For I As Integer = 0 To ImageCount - 1
        If Not My.Computer.FileSystem.FileExists(Directory & "\" & Trim(CStr(I)) & ".png") Then
          bDo = True
          Exit For
        End If
      Next I
    Else
      bDo = True
    End If
    Return bDo
  End Function
  Private Sub ParseStandardIcons()
    ParseIconsDefault()
    If CheckDir(AppTemp & "\icons\DRTL", 12) Then SavePCX("DRTL", My.Resources.DRTL)
    If CheckDir(AppTemp & "\icons\DSHR", 1) Then SavePCX("DSHR", My.Resources.DSHR)
    If CheckDir(AppTemp & "\icons\STAR", 72) Then SavePCX("STAR", My.Resources.STAR)
    If CheckDir(AppTemp & "\icons\D2DV", 420) Then SavePCX("D2DV", My.Resources.D2DV)
    If CheckDir(AppTemp & "\icons\D2XP", 714) Then SavePCX("D2XP", My.Resources.D2XP)
    If CheckDir(AppTemp & "\icons\W2BN", 34) Then SavePCX("W2BN", My.Resources.W2BN)
  End Sub
  Private Function ParseWAR3Icons() As Boolean
    Dim bLoad As Boolean = False
    If My.Computer.FileSystem.DirectoryExists(AppTemp & "\icons\WAR3") Then
      If My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\iconindex_clan.txt") Then
        Dim sClan() As String = Split(My.Computer.FileSystem.ReadAllText(AppTemp & "\icons\WAR3\iconindex_clan.txt"), vbNewLine)
        For Each sIcon As String In sClan
          If sIcon.Length > 2 Then
            If Not My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\" & sIcon.Substring(sIcon.LastIndexOf("\") + 1) & ".png") Then
              bLoad = True
              Exit For
            End If
          End If
        Next
      End If
      If Not bLoad AndAlso My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\iconindex_def.txt") Then
        Dim sDef() As String = Split(My.Computer.FileSystem.ReadAllText(AppTemp & "\icons\WAR3\iconindex_def.txt"), vbNewLine)
        For Each sIcon As String In sDef
          If sIcon.Length > 2 Then
            If Not My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\" & sIcon.Substring(sIcon.LastIndexOf("\") + 1) & ".png") Then
              bLoad = True
              Exit For
            End If
          End If
        Next
      End If
      If Not bLoad AndAlso My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\iconindex_def2.txt") Then
        Dim sDef2() As String = Split(My.Computer.FileSystem.ReadAllText(AppTemp & "\icons\WAR3\iconindex_def2.txt"), vbNewLine)
        For Each sIcon As String In sDef2
          If sIcon.Length > 2 Then
            If Not My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\" & sIcon.Substring(sIcon.LastIndexOf("\") + 1) & ".png") Then
              bLoad = True
              Exit For
            End If
          End If
        Next
      End If
    Else
      bLoad = True
    End If
    If (Not My.Computer.FileSystem.FileExists(AppStore & "\icons\WAR3.bni")) OrElse (Not My.Computer.FileSystem.GetFileInfo(AppStore & "\icons\WAR3.bni").Length = My.Resources.WAR3.Length) Then bLoad = True
    If bLoad Then SaveBLP("WAR3", "WAR3", My.Resources.WAR3)
    Return bLoad
  End Function
  Public Sub ParseIconsDefault()
    Dim bLoad As Boolean = False
    If My.Computer.FileSystem.DirectoryExists(AppTemp & "\icons\icons") Then
      If My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\DRTL.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\DSHR.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\D2DV.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\D2XP.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\STAR.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\SEXP.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\JSTR.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\SSHR.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\W2BN.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\W3XP.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\CHAT.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\FLAG_1.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\FLAG_2.png") AndAlso
         My.Computer.FileSystem.FileExists(AppTemp & "\icons\icons\FLAG_20.png") Then
        bLoad = False
      Else
        bLoad = True
      End If
    Else
      bLoad = True
    End If
    If bLoad Then SaveBNI("icons")
  End Sub
  Public Sub ParseIconsSTAR()
    SaveBNI("icons_STAR")
  End Sub
  Public Sub ParseIconsWAR3()
    SaveBLP("icons-WAR3", "WAR3")
  End Sub
  Private Sub SavePCX(FileName As String, ByRef Resource() As Byte)
    Dim bDoIt As Boolean = False
    If Not My.Computer.FileSystem.DirectoryExists(AppTemp & "\icons\" & FileName) Then My.Computer.FileSystem.CreateDirectory(AppTemp & "\icons\" & FileName)
    LoadIcons(FileName & ".pcx", Resource)
    Dim parse As New PcxFileParser(AppStore & "\icons\" & FileName & ".pcx")
    Dim Icons() As PcxIcon = parse.AllIcons
    For I As Integer = 0 To Icons.Length - 1
      Dim Icon As PcxIcon = Icons(I)
      If Icon IsNot Nothing Then Icon.Image.Save(AppTemp & "\icons\" & FileName & "\" & I & ".png", Imaging.ImageFormat.Png)
    Next I
  End Sub
  Private Sub SaveBNI(FileName As String)
    If My.Computer.FileSystem.FileExists(AppStore & "\icons\" & FileName & ".bni") Then
      If Not My.Computer.FileSystem.DirectoryExists(AppTemp & "\icons\" & FileName) Then My.Computer.FileSystem.CreateDirectory(AppTemp & "\icons\" & FileName)
      Dim parse As New BniFileParser(AppStore & "\icons\" & FileName & ".bni")
      Dim Icons() As BniIcon = parse.AllIcons
      parse.Dispose()
      For Each Icon As BniIcon In Icons
        If Icon.SoftwareProductCodes.Length > 0 Then
          If Not My.Computer.FileSystem.FileExists(AppTemp & "\icons\" & FileName & "\" & Icon.SoftwareProductCodes(0) & ".png") Then Icon.Image.Save(AppTemp & "\icons\" & FileName & "\" & Icon.SoftwareProductCodes(0) & ".png", Imaging.ImageFormat.Png)
        Else
          If Not My.Computer.FileSystem.FileExists(AppTemp & "\icons\" & FileName & "\FLAG_" & Hex(Icon.UserFlags) & ".png") Then Icon.Image.Save(AppTemp & "\icons\" & FileName & "\FLAG_" & Hex(Icon.UserFlags) & ".png", Imaging.ImageFormat.Png)
        End If
      Next Icon
    End If
  End Sub
  Private Sub SaveBLP(FileName As String, Directory As String, Optional ByRef Resource() As Byte = Nothing)
    If Not My.Computer.FileSystem.DirectoryExists(AppTemp & "\icons\" & Directory) Then My.Computer.FileSystem.CreateDirectory(AppTemp & "\icons\" & Directory)
    If Resource IsNot Nothing Then LoadIcons(FileName & ".bni", Resource)
    Dim Archive As New MPQ(AppStore & "\icons\" & FileName & ".bni")
    Dim sList As String = Archive.GetListFile
    If String.IsNullOrEmpty(sList) Then Exit Sub
    Dim sFile() As String = Split(sList, vbNewLine)
    For Each ListItem As String In sFile
      If String.IsNullOrEmpty(ListItem) Then Continue For
      If ListItem.Substring(0, 1) = "(" Then Continue For
      If ListItem.Substring(ListItem.Length - 3) = "blp" Then
        Dim bData() As Byte = Archive.OpenFile(ListItem)
        Dim BLPImg As Image = New Bitmap(28, 14)
        Dim BLPSrc As Image = ParseBLP(bData, 0)
        Dim ImagePath As String = AppTemp & "\icons\" & Directory & "\" & ListItem.Substring(ListItem.LastIndexOf("\") + 1) & ".png"
        If BLPSrc.Size.Width = 64 And BLPSrc.Size.Height = 64 Then
          Dim g As Graphics = Graphics.FromImage(BLPImg)
          g.InterpolationMode = Drawing2D.InterpolationMode.HighQualityBicubic
          g.DrawImage(BLPSrc, 0, -CInt(Math.Floor(((BLPImg.Height / BLPImg.Width) * BLPSrc.Height) / 4)), BLPImg.Width, BLPImg.Width)
          g.Dispose()
          BLPImg.Save(ImagePath, Imaging.ImageFormat.Png)
        Else
          BLPSrc.Save(ImagePath, Imaging.ImageFormat.Png)
        End If
      ElseIf ListItem.Substring(ListItem.Length - 3) = "txt" Then
        Archive.SaveToPath(ListItem, AppTemp & "\icons\" & Directory)
      Else
        Debug.Print("Unknown file in BLP: " & ListItem)
      End If
    Next
  End Sub
  Private Function LoadIcons(FileName As String, ByRef Resource() As Byte) As Boolean
    If (Not My.Computer.FileSystem.FileExists(AppStore & "\icons\" & FileName)) OrElse (Not My.Computer.FileSystem.GetFileInfo(AppStore & "\icons\" & FileName).Length = Resource.Length) Then
      If Not My.Computer.FileSystem.DirectoryExists(AppStore & "\icons") Then My.Computer.FileSystem.CreateDirectory(AppStore & "\icons")
      My.Computer.FileSystem.WriteAllBytes(AppStore & "\icons\" & FileName, Resource, False)
      Return True
    End If
    Return False
  End Function

  Private Function ParseBLP(bFile() As Byte, Item As Byte) As Image
    Dim cBG As Color = Color.Transparent
    Dim dFile As New DataReader(bFile)
    Dim ID As String = System.Text.Encoding.GetEncoding(LATIN_1).GetString(dFile.ReadByteArray(4))
    If ID = "BLP1" Then
      Dim Compression As UInt32 = dFile.ReadUInt32
      Dim Flags As UInt32 = dFile.ReadUInt32
      Dim Width As Integer = dFile.ReadUInt32
      Dim Height As Integer = dFile.ReadUInt32
      Dim PictureType As UInt32 = dFile.ReadUInt32
      Dim PictureSubType As UInt32 = dFile.ReadUInt32
      Dim MiniMapOffset(15) As UInt32
      MiniMapOffset = dFile.ReadUInt32Array(16)
      Dim MiniMapSize(15) As UInt32
      MiniMapSize = dFile.ReadUInt32Array(16)
      If Compression = 0 Then
        Dim HeaderSize As UInt32 = dFile.ReadUInt32
        Dim Header() As Byte = dFile.ReadByteArray(HeaderSize)
        Dim JPGFile(HeaderSize + MiniMapSize(Item)) As Byte
        Array.Copy(Header, 0, JPGFile, 0, HeaderSize)
        Array.Copy(bFile, MiniMapOffset(Item), JPGFile, HeaderSize, MiniMapSize(Item))
        Dim iStream As New IO.MemoryStream(JPGFile)
        Return New Bitmap(iStream)
        iStream.Dispose()
      ElseIf Compression = 1 And (PictureType = 3 Or PictureType = 4) Then
        Dim ColorPallete(255) As UInt32
        ColorPallete = dFile.ReadUInt32Array(256)
        Dim MM_Width As Integer = Math.Floor(Width / (Item + 1))
        Dim MM_Height As Integer = Math.Floor(Height / (Item + 1))
        Dim bTmp(MiniMapSize(Item)) As Byte
        Array.Copy(bFile, MiniMapOffset(Item), bTmp, 0, MiniMapSize(Item))
        Dim dMiniMap As New DataReader(bTmp)
        Dim IndexList(MM_Width * MM_Height - 1) As Byte
        Dim AlphaList(MM_Width * MM_Height - 1) As Byte
        IndexList = dMiniMap.ReadByteArray(MM_Width * MM_Height)
        AlphaList = dMiniMap.ReadByteArray(MM_Width * MM_Height)
        Dim img As Image = New Bitmap(MM_Width, MM_Height)
        Dim g As Graphics = Graphics.FromImage(img)
        g.Clear(cBG)
        For J As Integer = 0 To MM_Width * MM_Height - 1
          Dim bColor As New SolidBrush(Color.FromArgb(AlphaList(J), Color.FromArgb(ColorPallete(IndexList(J)))))
          Dim rPos As Rectangle = New Rectangle(J Mod MM_Width, J \ MM_Width, 1, 1)
          g.FillRectangle(bColor, rPos)
        Next J
        g.Dispose()
        Return img
      ElseIf Compression = 1 And (PictureType = 5) Then
        Dim ColorPallete(255) As UInt32
        ColorPallete = dFile.ReadUInt32Array(256)
        Dim MM_Width As Integer = Math.Floor(Width / (Item + 1))
        Dim MM_Height As Integer = Math.Floor(Height / (Item + 1))
        Dim bTmp(MiniMapSize(Item)) As Byte
        Array.Copy(bFile, MiniMapOffset(Item), bTmp, 0, MiniMapSize(Item))
        Dim dMiniMap As New DataReader(bTmp)
        Dim IndexList(MM_Width * MM_Height - 1) As Byte
        IndexList = dMiniMap.ReadByteArray(MM_Width * MM_Height)
        Dim img As Image = New Bitmap(MM_Width, MM_Height)
        Dim g As Graphics = Graphics.FromImage(img)
        g.Clear(cBG)
        For J As Integer = 0 To MM_Width * MM_Height - 1
          Dim bColor As New SolidBrush(Color.FromArgb(&HFF000000 Xor ColorPallete(IndexList(J))))
          Dim rPos As Rectangle = New Rectangle(J Mod MM_Width, J \ MM_Width, 1, 1)
          g.FillRectangle(bColor, rPos)
        Next J
        g.Dispose()
        Return img
      Else
        Return New Bitmap(1, 1)
      End If
    Else
      Return New Bitmap(1, 1)
    End If
  End Function
End Module