﻿Public Class ColorSelectorBox
  Inherits System.Windows.Forms.TextBox

  Private c_SelColor As Color
  Private c_Text As String
  Public Property SelectedColor As Color
    Get
      Return c_SelColor
    End Get
    Set(value As Color)
      If value = Color.Empty Then value = Color.Black
      c_SelColor = value
      If c_SelColor.A = 255 Then
        Me.BackColor = c_SelColor
      Else
        Me.BackColor = Color.FromArgb(255, c_SelColor)
      End If
      If c_SelColor.R > 128 Or c_SelColor.G > 128 Or c_SelColor.B > 128 Then
        Me.ForeColor = Color.Black
      Else
        Me.ForeColor = Color.White
      End If
      If String.IsNullOrEmpty(Me.Text) Or Not Me.Focused Then Me.Text = "#" & PadHex(c_SelColor.ToArgb, 8)
    End Set
  End Property
  Protected Overrides Sub OnKeyDown(e As System.Windows.Forms.KeyEventArgs)
    Select Case e.KeyCode
      Case Keys.D0, Keys.D1, Keys.D2, Keys.D3, Keys.D4, Keys.D5, Keys.D6, Keys.D7, Keys.D8, Keys.D9, Keys.A, Keys.B, Keys.C, Keys.D, Keys.E, Keys.F, Keys.Back, Keys.Delete, Keys.Left, Keys.Right, Keys.Home, Keys.End
        'ok
      Case Keys.V, Keys.C, Keys.X, Keys.A
        If e.Control Then
          'ok
        Else
          e.SuppressKeyPress = True
          e.Handled = True
        End If
      Case Else
        e.SuppressKeyPress = True
        e.Handled = True
    End Select
    MyBase.OnKeyDown(e)
  End Sub
  Protected Overrides Sub OnKeyUp(e As System.Windows.Forms.KeyEventArgs)
    Select Case e.KeyCode
      Case Keys.D0, Keys.D1, Keys.D2, Keys.D3, Keys.D4, Keys.D5, Keys.D6, Keys.D7, Keys.D8, Keys.D9, Keys.A, Keys.B, Keys.C, Keys.D, Keys.E, Keys.F, Keys.Back, Keys.Delete, Keys.Left, Keys.Right, Keys.Home, Keys.End
        'ok
      Case Keys.V, Keys.C, Keys.X, Keys.A
        If e.Control Then
          'ok
        Else
          e.SuppressKeyPress = True
          e.Handled = True
        End If
      Case Else
        e.SuppressKeyPress = True
        e.Handled = True
    End Select
    MyBase.OnKeyUp(e)
  End Sub
  Protected Overrides Sub OnDoubleClick(e As System.EventArgs)
    Dim colorChooser As New ColorDialog
    colorChooser.Color = SelectedColor
    colorChooser.AnyColor = True
    If colorChooser.ShowDialog = DialogResult.OK Then
      SelectedColor = colorChooser.Color
      Me.Text = "#" & PadHex(colorChooser.Color.ToArgb, 8)
    End If
    MyBase.OnDoubleClick(e)
  End Sub
  Protected Overrides Sub OnTextChanged(e As System.EventArgs)
    If MyBase.Text.Length = 6 Then
      SelectedColor = Color.FromArgb(Int32.Parse(MyBase.Text.Substring(0, 2), NumberStyles.HexNumber), Int32.Parse(MyBase.Text.Substring(2, 2), NumberStyles.HexNumber), Int32.Parse(MyBase.Text.Substring(4, 2), NumberStyles.HexNumber))
    ElseIf MyBase.Text.Length = 8 Then
      SelectedColor = Color.FromArgb(Int32.Parse(MyBase.Text.Substring(0, 2), NumberStyles.HexNumber), Int32.Parse(MyBase.Text.Substring(2, 2), NumberStyles.HexNumber), Int32.Parse(MyBase.Text.Substring(4, 2), NumberStyles.HexNumber), Int32.Parse(MyBase.Text.Substring(6, 2), NumberStyles.HexNumber))
    End If
    MyBase.OnTextChanged(e)
  End Sub
  Protected Overrides Sub OnGotFocus(e As System.EventArgs)
    Me.Text = c_Text
    MyBase.OnGotFocus(e)
  End Sub
  Protected Overrides Sub OnLostFocus(e As System.EventArgs)
    c_Text = Me.Text
    Me.Text = "#" & PadHex(SelectedColor.ToArgb, 8)
    If MyBase.Text.Length = 7 Then
      SelectedColor = Color.FromArgb(255, Int32.Parse(MyBase.Text.Substring(1, 2), NumberStyles.HexNumber), Int32.Parse(MyBase.Text.Substring(3, 2), NumberStyles.HexNumber), Int32.Parse(MyBase.Text.Substring(5, 2), NumberStyles.HexNumber))
    ElseIf MyBase.Text.Length = 9 Then
      SelectedColor = Color.FromArgb(Int32.Parse(MyBase.Text.Substring(1, 2), NumberStyles.HexNumber), Int32.Parse(MyBase.Text.Substring(3, 2), NumberStyles.HexNumber), Int32.Parse(MyBase.Text.Substring(5, 2), NumberStyles.HexNumber), Int32.Parse(MyBase.Text.Substring(7, 2), NumberStyles.HexNumber))
    End If
    MyBase.OnLostFocus(e)
  End Sub
  Public Overrides Property MaxLength As Integer
    Get
      Return 9
    End Get
    Set(value As Integer)
      MyBase.MaxLength = 9
    End Set
  End Property
  Public Sub New()
    SelectedColor = Color.Black
    MyBase.MaxLength = 9
  End Sub
End Class
