﻿Option Compare Text
Imports System.IO

Public NotInheritable Class CheckRevision
  Private Sub New()
  End Sub
  Private Shared ReadOnly hashcodes As UInteger() = New UInteger() {&HE7F4CB62UI, &HF6A14FFCUI, &HAA5504AFUI, &H871FCDC2UI, &H11BF6A18, &HC57292E6UI, &H7927D27E, &H2FEC8733}

  Public Shared Function ExtractMPQNumber(mpqName As String) As Integer
    If mpqName Like "lockdown-????-##.mpq" Then Return Integer.Parse(mpqName.Substring(14).ToString)
    If mpqName Like "ver-????-#*.mpq" Then Return Integer.Parse(mpqName(9).ToString)
    If mpqName Like "????VER#*.mpq" Then Return Integer.Parse(mpqName(7).ToString)
    Return -1
  End Function

  Public Shared Function DoCheckRevision(Request As String, files As String(), mpqNumber As Integer) As Integer
    If Request = String.Empty Then Return -1
    If files Is Nothing Then Return -1
    If Not files.Length = 3 Then Return -1
    Dim Values(3) As UInt32, opValueDest(3), opValueSrc1(3), opValueSrc2(3) As Integer, operation(3) As Char
    Dim Tokens() As String = Request.Split(" ")
    Dim currentFormula As Integer = 0
    For I As Integer = 0 To Tokens.Length - 1
      Dim token As String = Tokens(I)
      If token.IndexOf("="c) <> -1 Then
        Dim nameTokens As String() = token.Split(New Char() {"="c})
        If nameTokens.Length <> 2 Then Return -1
        Dim variable As Integer = getNum(nameTokens(0)(0))
        Dim value As String = nameTokens(1)
        If Char.IsDigit(value(0)) Then
          Values(variable) = UInteger.Parse(value, CultureInfo.InvariantCulture)
        Else
          opValueDest(currentFormula) = variable
          opValueSrc1(currentFormula) = getNum(value(0))
          operation(currentFormula) = value(1)
          opValueSrc2(currentFormula) = getNum(value(2))
          currentFormula += 1
        End If
      End If
    Next
    Values(0) = Values(0) Xor hashcodes(mpqNumber)
    For I As Integer = 0 To files.Length - 1
      Dim currentFile As New FileStream(files(I), FileMode.Open, FileAccess.Read, FileShare.Read)
      Dim fileLength As Integer = CInt(currentFile.Length)
      Dim bufferSize As Integer = -1
      Dim byteBuffer As Byte() = Nothing
      Dim buffer As MemoryStream = Nothing
      If fileLength Mod 1024 = 0 Then
        bufferSize = fileLength
        byteBuffer = New Byte(bufferSize - 1) {}
        currentFile.Read(byteBuffer, 0, bufferSize)
      Else
        Dim paddingBytes As Integer = (1024 - (fileLength Mod 1024))
        bufferSize = fileLength + paddingBytes
        byteBuffer = New Byte(bufferSize - 1) {}
        currentFile.Read(byteBuffer, 0, fileLength)
        Dim currentPaddingByte As Integer = &HFF
        For J As Integer = fileLength To bufferSize - 1
          byteBuffer(J) = System.Math.Max(System.Threading.Interlocked.Decrement(currentPaddingByte), currentPaddingByte + 1)
        Next
      End If
      buffer = New MemoryStream(byteBuffer, 0, bufferSize, False)
      Dim br As New BinaryReader(buffer)
      For J As Integer = 0 To bufferSize - 1 Step 4
        Values(3) = br.ReadUInt32()
        For K As Integer = 0 To currentFormula - 1
          Select Case operation(K)
            Case "+" : Values(opValueDest(K)) = Values(opValueSrc1(K)) + Values(opValueSrc2(K))
            Case "-" : Values(opValueDest(K)) = Values(opValueSrc1(K)) - Values(opValueSrc2(K))
            Case "^" : Values(opValueDest(K)) = Values(opValueSrc1(K)) Xor Values(opValueSrc2(K))
            Case "*" : Values(opValueDest(K)) = Values(opValueSrc1(K)) * Values(opValueSrc2(K))
            Case "/" : Values(opValueDest(K)) = Values(opValueSrc1(K)) \ Values(opValueSrc2(K))
          End Select
        Next
      Next
    Next
    Return CInt(values(2))
  End Function

  Private Shared Function getNum(c As Char) As Integer
    c = Char.ToUpper(c, CultureInfo.InvariantCulture)
    If c = "S" Then
      Return 3
    Else
      Return Asc(c) - Asc("A"c)
    End If
  End Function

  Public Shared Function GetExeInfo(fileName As String, ByRef exeInfoString As String) As Integer
    If fileName Is Nothing Then Return -1
    Dim file__1 As String = fileName.Substring(fileName.LastIndexOf("\") + 1)
    Dim fs As New FileStream(fileName, FileMode.Open, FileAccess.Read, FileShare.Read)
    Dim fileSize As UInteger = CUInt(fs.Length)
    Dim ft As DateTime = File.GetLastWriteTimeUtc(fileName)
    Dim fvi As FileVersionInfo = FileVersionInfo.GetVersionInfo(fileName)
    Dim version As Integer = ((fvi.FileMajorPart << 24) Or (fvi.FileMinorPart << 16) Or (fvi.FileBuildPart << 8) Or fvi.FilePrivatePart)
    exeInfoString = [String].Format(CultureInfo.InvariantCulture, "{0} {1:d1}/{2:d2}/{3:d2} {4:d2}:{5:d2}:{6:d2} {7}", file__1, ft.Month, ft.Day, ft.Year Mod 100, ft.Hour, ft.Minute, ft.Second, fileSize)
    Return version
  End Function

End Class
