﻿Public Class BNFTPv1
  Implements IDisposable
  Private C_Platform As BNUI.GameArch
  Private C_Product As BNUI.GameType
  Private C_FileName As String
  Private C_FileSize As UInt32
  Private C_FileTime As Date = DateSerial(1601, 1, 1)
  Private C_Server As System.Net.IPAddress = New System.Net.IPAddress({63, 241, 83, 9})
  Private C_BannerID As UInt32 = 0
  Private C_BannerExt As UInt32 = 0
  Private C_Resume As Boolean
  Public Proxy As BNUI.cConfig.cProxy
  Private Const Timeout As Integer = 10000
  Public ReadOnly Property FileName As String
    Get
      Return C_FileName.Substring(C_FileName.LastIndexOf("\") + 1)
    End Get
  End Property
  Public ReadOnly Property FileSize As UInt32
    Get
      Return C_FileSize
    End Get
  End Property
  Public ReadOnly Property FileTime As Date
    Get
      Return C_FileTime
    End Get
  End Property
  Public Property LocalFileName As String
    Get
      Return C_FileName
    End Get
    Set(value As String)
      C_FileName = value
    End Set
  End Property
  Public Overridable ReadOnly Property Product As BNUI.GameType
    Get
      Return C_Product
    End Get
  End Property
  Public Overridable ReadOnly Property Platform As BNUI.GameArch
    Get
      Return C_Platform
    End Get
  End Property
  Public Property Server As System.Net.IPAddress
    Get
      Return C_Server
    End Get
    Set(value As System.Net.IPAddress)
      C_Server = value
    End Set
  End Property
  Public Sub New(Platform As BNUI.GameArch, ProductID As BNUI.GameType, FileName As String, FileTime As Date, Optional bResume As Boolean = False)
    C_Platform = Platform
    C_Product = ProductID
    C_FileName = FileName
    C_FileTime = FileTime
    C_Resume = bResume
  End Sub
  Public Sub New(Platform As BNUI.GameArch, ProductID As BNUI.GameType, FileName As String, FileTime As Date, BannerID As UInt32, BannerExt As String, Optional bResume As Boolean = False)
    C_Platform = Platform
    C_Product = ProductID
    C_FileName = FileName
    C_FileTime = FileTime
    C_BannerID = BannerID
    If BannerExt IsNot Nothing Then C_BannerExt = BitConverter.ToUInt32(System.Text.Encoding.GetEncoding(LATIN_1).GetBytes(BannerExt), 0)
    C_Resume = bResume
  End Sub
  Public Function ExecuteRequest() As Boolean
    Dim sIP As String, iPort As Integer
    If Proxy.Use Then
      sIP = Proxy.IP
      iPort = Proxy.Port
    Else
      sIP = C_Server.ToString
      iPort = 6112
    End If
    Using tcpFTP As New System.Net.Sockets.TcpClient(sIP, iPort)
      If tcpFTP.Connected Then
        If Proxy.Use Then
          Select Case Proxy.Ver
            Case BNUI.ProxyType.HTTP
              tcpFTP.Client.Send(System.Text.Encoding.ASCII.GetBytes("CONNECT " & C_Server.ToString & ":6112 HTTP/1.0" & vbCrLf & "User-agent: " & UserAgent & vbCrLf & vbCrLf))
              Do While tcpFTP.Available = 0
                Threading.Thread.Sleep(10)
                If Not tcpFTP.Client.Connected Then Return False
              Loop
              Dim bHTTP(tcpFTP.Available - 1) As Byte
              tcpFTP.Client.Receive(bHTTP)
              Dim sData As String = System.Text.Encoding.ASCII.GetString(bHTTP)
              If InStr(sData, "200") > 0 Then
                'Done
              Else
                Return False
              End If
            Case BNUI.ProxyType.SOCKS4
              Using pktTmp As New DataBuffer
                pktTmp.InsertByte(&H4)
                pktTmp.InsertByte(&H1)
                pktTmp.InsertByteArray({&H17, &HE0})
                pktTmp.InsertByteArray(C_Server.GetAddressBytes)
                pktTmp.InsertCString(Environment.UserName)
                tcpFTP.Client.Send(pktTmp.GetData)
              End Using
              Do Until tcpFTP.Available > 0
                Threading.Thread.Sleep(10)
                If Not tcpFTP.Client.Connected Then Return False
              Loop
              Dim bTmp(tcpFTP.Available - 1) As Byte
              tcpFTP.Client.Receive(bTmp)
              Dim pktRead As New DataReader(bTmp)
              Dim bNull As Byte = pktRead.ReadByte
              Dim bStatus As Byte = pktRead.ReadByte
              Dim bPort() As Byte = pktRead.ReadByteArray(2)
              Dim bIP() As Byte = pktRead.ReadByteArray(2)
              Select Case bStatus
                Case &H5A
                  'Done
                Case Else
                  Return False
              End Select
            Case BNUI.ProxyType.SOCKS5
              Using pktTmp As New DataBuffer
                pktTmp.InsertByte(&H5)
                pktTmp.InsertByte(&H2)
                'pktTmp.InsertByteArray({SOCKS5AuthMethods.None, SOCKS5AuthMethods.GSSAPI, SOCKS5AuthMethods.UserPass, SOCKS5AuthMethods.ChallengeHandshake, SOCKS5AuthMethods.ChallengeResponse, SOCKS5AuthMethods.SSL, SOCKS5AuthMethods.NDS, SOCKS5AuthMethods.MultiAuthFramework})
                pktTmp.InsertByteArray({0, 2})
                tcpFTP.Client.Send(pktTmp.GetData)
              End Using
              Do Until tcpFTP.Available > 0
                Threading.Thread.Sleep(10)
                If Not tcpFTP.Client.Connected Then Return False
              Loop
              Dim bTmp(tcpFTP.Available - 1) As Byte
              tcpFTP.Client.Receive(bTmp)
              Dim pktRead As New DataReader(bTmp)
              Dim bVersion As Byte = pktRead.ReadByte
              Dim bMethod As Byte = pktRead.ReadByte
              Select Case bMethod
                Case &H0
                  Using pktTmp As New DataBuffer
                    pktTmp.InsertByte(&H5)
                    pktTmp.InsertByte(&H1)
                    pktTmp.InsertByte(&H0)
                    pktTmp.InsertByte(1)
                    pktTmp.InsertByteArray(C_Server.GetAddressBytes)
                    pktTmp.InsertByteArray({&H17, &HE0})
                    tcpFTP.Client.Send(pktTmp.GetData)
                  End Using
                  bVersion = pktRead.ReadByte
                  Dim bStatus As Byte = pktRead.ReadByte
                  Dim bReserved As Byte = pktRead.ReadByte
                  Dim bAddressType As Byte = pktRead.ReadByte
                  Dim bAddress() As Byte
                  Select Case bAddressType
                    Case 1
                      bAddress = pktRead.ReadByteArray(4)
                    Case 2
                      Dim bLen As Byte = pktRead.ReadByte
                      bAddress = pktRead.ReadByteArray(bLen)
                    Case 4
                      bAddress = pktRead.ReadByteArray(16)
                  End Select
                  Dim bPort() As Byte = pktRead.ReadByteArray(2)
                  Select Case bStatus
                    Case 0
                      'Done
                    Case Else
                      Return False
                  End Select
                Case &H2
                  Using pktTmp As New DataBuffer
                    pktTmp.InsertByte(&H1)
                    pktTmp.InsertByte(Proxy.User.Length)
                    If Proxy.User.Length > 0 Then pktTmp.InsertByteArray(System.Text.Encoding.ASCII.GetBytes(Proxy.User))
                    pktTmp.InsertByte(Proxy.Pass.Length)
                    If Proxy.Pass.Length > 0 Then pktTmp.InsertString(Proxy.Pass, 20127)
                    tcpFTP.Client.Send(pktTmp.GetData)
                  End Using
                  Do Until tcpFTP.Available > 0
                    Threading.Thread.Sleep(10)
                    If Not tcpFTP.Client.Connected Then Return False
                  Loop
                  Dim bRet(tcpFTP.Available - 1) As Byte
                  tcpFTP.Client.Receive(bRet)
                  Dim pktRet As New DataReader(bRet)
                  Dim bRetVersion As Byte = pktRet.ReadByte
                  Dim bStatus As Byte = pktRet.ReadByte
                  If bStatus = &H0 Then
                    Using pktTmp As New DataBuffer
                      pktTmp.InsertByte(&H5)
                      pktTmp.InsertByte(&H1)
                      pktTmp.InsertByte(&H0)
                      pktTmp.InsertByte(1)
                      pktTmp.InsertByteArray(C_Server.GetAddressBytes)
                      pktTmp.InsertByteArray({&H17, &HE0})
                      tcpFTP.Client.Send(pktTmp.GetData)
                    End Using
                  Else
                    Return False
                  End If
                Case Else
                  Return False
              End Select
            Case &HFF
              Return False
            Case Else
              Return False
          End Select
        End If
        tcpFTP.Client.Send(New Byte() {&H2})
        Using pBuffer As New DataBuffer
          pBuffer.InsertUInt16(&H100)
          pBuffer.InsertUInt32(C_Platform)
          pBuffer.InsertUInt32(C_Product)
          pBuffer.InsertUInt32(C_BannerID)
          pBuffer.InsertUInt32(C_BannerExt)
          If C_Resume AndAlso My.Computer.FileSystem.FileExists(C_FileName) Then
            pBuffer.InsertUInt32(My.Computer.FileSystem.GetFileInfo(C_FileName).Length)
          Else
            pBuffer.InsertUInt32(0)
          End If
          If C_FileTime.Ticks = 0 Then
            pBuffer.InsertUInt64(0)
          Else
            pBuffer.InsertUInt64(DateToUInt64(FileTime))
          End If
          pBuffer.InsertCString(FileName)
          Dim bTmp() As Byte = pBuffer.GetData
          Using pSend As New DataBuffer
            pSend.InsertUInt16(bTmp.Length + 2)
            pSend.InsertByteArray(bTmp)
            Dim iTmp As Integer = tcpFTP.Client.Send(pSend.GetData)
            If iTmp < 1 Then Return False
          End Using
        End Using
        Dim iStart As Integer = Environment.TickCount
        Do Until tcpFTP.Available > 0
          Threading.Thread.Sleep(10)
          If Not tcpFTP.Client.Connected Or Environment.TickCount - iStart > Timeout Then
            If tcpFTP IsNot Nothing Then tcpFTP.Close()
            Return False
          End If
        Loop
        Dim bData() As Byte
        ReDim bData(3)
        tcpFTP.Client.Receive(bData)
        Dim pReader = New DataReader(bData)
        Dim lLen As UInt32 = pReader.ReadUInt32 - 4
        pReader = Nothing
        Do Until tcpFTP.Available >= lLen
          Threading.Thread.Sleep(10)
          If Not tcpFTP.Client.Connected Then Return False
        Loop
        ReDim bData(lLen - 1)
        tcpFTP.Client.Receive(bData)
        pReader = New DataReader(bData)
        C_FileSize = pReader.ReadUInt32
        C_BannerID = pReader.ReadUInt32
        C_BannerExt = pReader.ReadUInt32
        C_FileTime = UInt64ToDate(pReader.ReadUInt64)
        Dim sName As String = pReader.ReadCString
        If Not C_Resume And My.Computer.FileSystem.FileExists(C_FileName) Then My.Computer.FileSystem.DeleteFile(C_FileName)
        Do
          Threading.Thread.Sleep(10)
          If Not tcpFTP.Client.Connected Then Return False
          If tcpFTP.Available > 0 Then
            ReDim bData(tcpFTP.Available - 1)
            tcpFTP.Client.Receive(bData)
            If Not My.Computer.FileSystem.DirectoryExists(C_FileName.Substring(0, C_FileName.LastIndexOf("\"))) Then My.Computer.FileSystem.CreateDirectory(C_FileName.Substring(0, C_FileName.LastIndexOf("\")))
            Try
              My.Computer.FileSystem.WriteAllBytes(C_FileName, bData, True)
            Catch ex As Exception
              If tcpFTP IsNot Nothing Then tcpFTP.Close()
              Return False
            End Try
          End If
        Loop Until My.Computer.FileSystem.FileExists(C_FileName) AndAlso My.Computer.FileSystem.GetFileInfo(C_FileName).Length = C_FileSize
        My.Computer.FileSystem.GetFileInfo(C_FileName).LastWriteTime = C_FileTime
        tcpFTP.Close()
        Return True
      End If
      Return False
    End Using
  End Function

#Region "IDisposable Support"
  Private disposedValue As Boolean
  Protected Overridable Sub Dispose(disposing As Boolean)
    If Not Me.disposedValue Then
      If disposing Then
        C_Product = Nothing
        C_FileName = Nothing
        C_FileSize = 0
        C_FileTime = Nothing
        C_Server = Nothing
        C_BannerID = 0
        C_BannerExt = 0
        C_Resume = False
        Proxy = Nothing
      End If
    End If
    Me.disposedValue = True
  End Sub
  Public Sub Dispose() Implements IDisposable.Dispose
    Dispose(True)
    GC.SuppressFinalize(Me)
  End Sub
#End Region
End Class

Public Class BNFTPv2
  Implements IDisposable
  Private C_Platform As BNUI.GameArch
  Private C_Product As BNUI.GameType
  Private C_FileName As String
  Private C_FileSize As UInt32
  Private C_FileTime As Date = DateSerial(1601, 1, 1)
  Private C_CDKey As BNUI.ProductKey
  Private C_Server As System.Net.IPAddress = New System.Net.IPAddress({63, 248, 83, 9})
  Private C_BannerID As UInt32 = 0
  Private C_BannerExt As UInt32 = 0
  Private C_Resume As Boolean
  Public Proxy As BNUI.cConfig.cProxy
  Private Const Timeout As Integer = 10000
  Public ReadOnly Property FileName As String
    Get
      Return C_FileName.Substring(C_FileName.LastIndexOf("\") + 1)
    End Get
  End Property
  Public ReadOnly Property FileSize As UInt32
    Get
      Return C_FileSize
    End Get
  End Property
  Public ReadOnly Property FileTime As Date
    Get
      Return C_FileTime
    End Get
  End Property
  Public Property LocalFileName As String
    Get
      Return C_FileName
    End Get
    Set(value As String)
      C_FileName = value
    End Set
  End Property
  Public Overridable ReadOnly Property Product As BNUI.GameType
    Get
      Return C_Product
    End Get
  End Property
  Public Property Server As System.Net.IPAddress
    Get
      Return C_Server
    End Get
    Set(value As System.Net.IPAddress)
      C_Server = value
    End Set
  End Property
  Public Sub New(Platform As BNUI.GameArch, ProductID As BNUI.GameType, FileName As String, FileTime As Date, CDKey As BNUI.ProductKey, Optional bResume As Boolean = False)
    C_Platform = Platform
    C_Product = ProductID
    C_FileName = FileName
    C_FileTime = FileTime
    C_CDKey = CDKey
    C_Resume = bResume
  End Sub
  Public Sub New(Platform As BNUI.GameArch, ProductID As BNUI.GameType, FileName As String, FileTime As Date, CDKey As BNUI.ProductKey, BannerID As UInt32, BannerExt As String, Optional bResume As Boolean = False)
    C_Platform = Platform
    C_Product = ProductID
    C_FileName = FileName
    C_FileTime = FileTime
    C_CDKey = CDKey
    C_BannerID = BannerID
    If BannerExt IsNot Nothing Then C_BannerExt = BitConverter.ToUInt32(System.Text.Encoding.GetEncoding(LATIN_1).GetBytes(BannerExt), 0)
    C_Resume = bResume
  End Sub
  Public Function ExecuteRequest() As Boolean
    Dim sIP As String, iPort As Integer
    If Proxy.Use Then
      sIP = Proxy.IP
      iPort = Proxy.Port
    Else
      sIP = C_Server.ToString
      iPort = 6112
    End If
    Using tcpFTP As New System.Net.Sockets.TcpClient(sIP, iPort)
      If tcpFTP.Connected Then
        If Proxy.Use Then
          Select Case Proxy.Ver
            Case BNUI.ProxyType.HTTP
              tcpFTP.Client.Send(System.Text.Encoding.ASCII.GetBytes("CONNECT " & C_Server.ToString & ":6112 HTTP/1.0" & vbCrLf & "User-agent: " & UserAgent & vbCrLf & vbCrLf))
              Do Until tcpFTP.Available > 0
                Threading.Thread.Sleep(10)
                If Not tcpFTP.Client.Connected Then Return False
              Loop
              Dim bHTTP(tcpFTP.Available - 1) As Byte
              tcpFTP.Client.Receive(bHTTP)
              Dim sData As String = System.Text.Encoding.ASCII.GetString(bHTTP)
              If InStr(sData, "200") > 0 Then
                'Done
              Else
                Return False
              End If
            Case BNUI.ProxyType.SOCKS4
              Using pktTmp As New DataBuffer
                pktTmp.InsertByte(&H4)
                pktTmp.InsertByte(&H1)
                pktTmp.InsertByteArray({&H17, &HE0})
                pktTmp.InsertByteArray(C_Server.GetAddressBytes)
                pktTmp.InsertCString(Environment.UserName)
                tcpFTP.Client.Send(pktTmp.GetData)
              End Using
              Do Until tcpFTP.Available > 0
                Threading.Thread.Sleep(10)
                If Not tcpFTP.Client.Connected Then Return False
              Loop
              Dim bTmp(tcpFTP.Available - 1) As Byte
              tcpFTP.Client.Receive(bTmp)
              Dim pktRead As New DataReader(bTmp)
              Dim bNull As Byte = pktRead.ReadByte
              Dim bStatus As Byte = pktRead.ReadByte
              Dim bPort() As Byte = pktRead.ReadByteArray(2)
              Dim bIP() As Byte = pktRead.ReadByteArray(2)
              Select Case bStatus
                Case &H5A
                  'Done
                Case Else
                  Return False
              End Select
            Case BNUI.ProxyType.SOCKS5
              Using pktTmp As New DataBuffer
                pktTmp.InsertByte(&H5)
                pktTmp.InsertByte(&H2)
                'pktTmp.InsertByteArray({SOCKS5AuthMethods.None, SOCKS5AuthMethods.GSSAPI, SOCKS5AuthMethods.UserPass, SOCKS5AuthMethods.ChallengeHandshake, SOCKS5AuthMethods.ChallengeResponse, SOCKS5AuthMethods.SSL, SOCKS5AuthMethods.NDS, SOCKS5AuthMethods.MultiAuthFramework})
                pktTmp.InsertByteArray({0, 2})
                tcpFTP.Client.Send(pktTmp.GetData)
              End Using
              Do Until tcpFTP.Available > 0
                Threading.Thread.Sleep(10)
                If Not tcpFTP.Client.Connected Then Return False
              Loop
              Dim bTmp(tcpFTP.Available - 1) As Byte
              tcpFTP.Client.Receive(bTmp)
              Dim pktRead As New DataReader(bTmp)
              Dim bVersion As Byte = pktRead.ReadByte
              Dim bMethod As Byte = pktRead.ReadByte
              Select Case bMethod
                Case &H0
                  Using pktTmp As New DataBuffer
                    pktTmp.InsertByte(&H5)
                    pktTmp.InsertByte(&H1)
                    pktTmp.InsertByte(&H0)
                    pktTmp.InsertByte(1)
                    pktTmp.InsertByteArray(C_Server.GetAddressBytes)
                    pktTmp.InsertByteArray({&H17, &HE0})
                    tcpFTP.Client.Send(pktTmp.GetData)
                  End Using
                  bVersion = pktRead.ReadByte
                  Dim bStatus As Byte = pktRead.ReadByte
                  Dim bReserved As Byte = pktRead.ReadByte
                  Dim bAddressType As Byte = pktRead.ReadByte
                  Dim bAddress() As Byte
                  Select Case bAddressType
                    Case 1
                      bAddress = pktRead.ReadByteArray(4)
                    Case 2
                      Dim bLen As Byte = pktRead.ReadByte
                      bAddress = pktRead.ReadByteArray(bLen)
                    Case 4
                      bAddress = pktRead.ReadByteArray(16)
                  End Select
                  Dim bPort() As Byte = pktRead.ReadByteArray(2)
                  Select Case bStatus
                    Case 0
                      'Done
                    Case Else
                      Return False
                  End Select
                Case &H2
                  Using pktTmp As New DataBuffer
                    pktTmp.InsertByte(&H1)
                    pktTmp.InsertByte(Proxy.User.Length)
                    If Proxy.User.Length > 0 Then pktTmp.InsertByteArray(System.Text.Encoding.ASCII.GetBytes(Proxy.User))
                    pktTmp.InsertByte(Proxy.Pass.Length)
                    If Proxy.Pass.Length > 0 Then pktTmp.InsertString(Proxy.Pass, 20127)
                    tcpFTP.Client.Send(pktTmp.GetData)
                  End Using
                  Do Until tcpFTP.Available > 0
                    Threading.Thread.Sleep(10)
                    If Not tcpFTP.Client.Connected Then Return False
                  Loop
                  Dim bRet(tcpFTP.Available - 1) As Byte
                  tcpFTP.Client.Receive(bRet)
                  Dim pktRet As New DataReader(bRet)
                  Dim bRetVersion As Byte = pktRet.ReadByte
                  Dim bStatus As Byte = pktRet.ReadByte
                  If bStatus = &H0 Then
                    Using pktTmp As New DataBuffer
                      pktTmp.InsertByte(&H5)
                      pktTmp.InsertByte(&H1)
                      pktTmp.InsertByte(&H0)
                      pktTmp.InsertByte(1)
                      pktTmp.InsertByteArray(C_Server.GetAddressBytes)
                      pktTmp.InsertByteArray({&H17, &HE0})
                      tcpFTP.Client.Send(pktTmp.GetData)
                    End Using
                  Else
                    Return False
                  End If
                Case Else
                  Return False
              End Select
            Case &HFF
              Return False
            Case Else
              Return False
          End Select
        End If
        tcpFTP.Client.Send(New Byte() {&H2})
        Using pBuffer As New DataBuffer
          With pBuffer
            .InsertUInt16(20)
            .InsertUInt16(&H200)
            .InsertUInt32(C_Platform)
            .InsertUInt32(C_Product)
            .InsertUInt32(C_BannerID)
            .InsertUInt32(C_BannerExt)
            tcpFTP.Client.Send(.GetData)
          End With
          pBuffer.Dispose()
        End Using
        Dim iStart As Integer = Environment.TickCount
        Do Until tcpFTP.Available > 0
          Threading.Thread.Sleep(10)
          If Not tcpFTP.Client.Connected Or Environment.TickCount - iStart > Timeout Then
            If tcpFTP IsNot Nothing Then tcpFTP.Close()
            Return False
          End If
        Loop
        Dim bData(tcpFTP.Available - 1) As Byte
        tcpFTP.Client.Receive(bData)
        Dim pReader As New DataReader(bData)
        Dim ServerToken As UInt32 = pReader.ReadUInt32
        Dim ClientToken As UInt32 = Environment.TickCount
        pReader = Nothing
        Using pBuffer As New DataBuffer
          With pBuffer
            If C_Resume AndAlso My.Computer.FileSystem.FileExists(C_FileName) Then
              .InsertUInt32(My.Computer.FileSystem.GetFileInfo(C_FileName).Length)
            Else
              .InsertUInt32(0)
            End If
            If C_FileTime.Ticks = 0 Then
              .InsertUInt64(0)
            Else
              .InsertUInt64(DateToUInt64(FileTime))
            End If
            .InsertUInt32(ClientToken)
            Dim Key As New clsKey(C_CDKey)
            If Key.IsValid And ProdMatch(C_Product, Key.Product, False) Then
              .InsertInt32(CDLegal(Key.Key).Length)
              .InsertInt32(Key.Product)
              .InsertInt32(Key.PublicVal)
              .InsertUInt32(0)
              Dim KeyHash() As Byte = Key.GetHash(ClientToken, ServerToken)
              .InsertByteArray(KeyHash)
            Else
              Return False
            End If
            .InsertCString(FileName)
            tcpFTP.Client.Send(.GetData)
          End With
          pBuffer.Dispose()
        End Using
        Do Until tcpFTP.Available > 0
          Threading.Thread.Sleep(10)
          If Not tcpFTP.Client.Connected Then Return False
        Loop
        ReDim bData(3)
        tcpFTP.Client.Receive(bData)
        pReader = New DataReader(bData)
        Dim lLen As UInt32 = pReader.ReadUInt32 - 4
        pReader = Nothing
        Do Until tcpFTP.Available >= lLen
          Threading.Thread.Sleep(10)
          If Not tcpFTP.Client.Connected Then Return False
        Loop
        ReDim bData(lLen - 1)
        tcpFTP.Client.Receive(bData)
        pReader = New DataReader(bData)
        C_FileSize = pReader.ReadUInt32
        C_BannerID = pReader.ReadUInt32
        C_BannerExt = pReader.ReadUInt32
        C_FileTime = UInt64ToDate(pReader.ReadUInt64)
        Dim sName As String = pReader.ReadCString
        If Not C_Resume AndAlso My.Computer.FileSystem.FileExists(C_FileName) Then My.Computer.FileSystem.DeleteFile(C_FileName)
        Do
          Threading.Thread.Sleep(10)
          If Not tcpFTP.Client.Connected Then Return False
          If tcpFTP.Available > 0 Then
            ReDim bData(tcpFTP.Available - 1)
            tcpFTP.Client.Receive(bData)
            Try
              My.Computer.FileSystem.WriteAllBytes(C_FileName, bData, True)
            Catch ex As Exception
              If Not (tcpFTP Is Nothing) Then tcpFTP.Close()
              Return False
            End Try
          End If
        Loop Until My.Computer.FileSystem.FileExists(C_FileName) AndAlso My.Computer.FileSystem.GetFileInfo(C_FileName).Length = C_FileSize
        My.Computer.FileSystem.GetFileInfo(C_FileName).LastWriteTime = C_FileTime
        tcpFTP.Close()
        Return True
      End If
      Return False
    End Using
  End Function

#Region "IDisposable Support"
  Private disposedValue As Boolean
  Protected Overridable Sub Dispose(disposing As Boolean)
    If Not Me.disposedValue Then
      If disposing Then
        C_Product = Nothing
        C_FileName = Nothing
        C_FileSize = 0
        C_FileTime = Nothing
        C_CDKey = Nothing
        C_Server = Nothing
        C_BannerID = 0
        C_BannerExt = 0
        C_Resume = False
        Proxy = Nothing
      End If
    End If
    Me.disposedValue = True
  End Sub
  Public Sub Dispose() Implements IDisposable.Dispose
    Dispose(True)
    GC.SuppressFinalize(Me)
  End Sub
#End Region

End Class
