﻿Public Class clsBNCS2
  Implements IDisposable

  Private bufIn As BitReader
  Private mManager As ModuleManager
  Private bnConfig As BNUI.cConfig
  Private WithEvents wsDownload As New Net.WebClient
  Private bEncrypt As Boolean

  Public Event ServiceError(Message As String)
  Public Event Failure(ex As Exception)
  Public Event Disconnect(Message As String, ReconnectAdvised As Boolean)
  Public Event CreateProgress(id As String, Message As String)
  Public Event UpdateProgress(id As String, Message As String)
  Public Event TerminateProgress(id As String, Message As String)
  Public Event Send(Packet() As Byte)

  Private Structure CLIENT_AUTH_COMPLETE
    Public Failure As Boolean
    Public FailPacket As CLIENT_AUTH_COMPLETE_FAIL
    Public SuccessPacket As CLIENT_AUTH_COMPLETE_SUCCESS
    Public Structure CLIENT_AUTH_COMPLETE_FAIL
      Public HasOptModule As Boolean
      Public OptModule As GENERAL_MODULE
      Public FailType As Byte
      Public ErrorCode As UShort
      Public ErrorExtra As Integer
    End Structure
    Public Structure CLIENT_AUTH_COMPLETE_SUCCESS
      Public Modules As Byte
      Public ModuleBlob() As GENERAL_MODULE_BLOB
      Public PingTimeout As Integer
      Public HasOptSegment As Boolean
      Public Bool As Boolean
      Public Threshold As UInteger
      Public Rate As UInteger
      Public FirstName As GENERAL_STRING
      Public LastName As GENERAL_STRING
      Public AccountID As UInteger
      Public Unknowns() As Byte
      Public AccountIDString As GENERAL_STRING
      Public MoreUnknowns() As Byte
    End Structure
  End Structure

  Private Structure CLIENT_AUTH_PROOFREQUEST
    Public Modules As Byte
    Public ModuleBlob() As GENERAL_MODULE_BLOB
  End Structure

  Private Structure GENERAL_MODULE_BLOB
    Public ModuleData As GENERAL_MODULE
    Public BlobData As GENERAL_BLOB
  End Structure
  Private Structure GENERAL_MODULE
    Public modType As String
    Public modLocale As String
    Public modID() As Byte
  End Structure
  Private Structure GENERAL_STRING
    Public Length As UInteger
    Public Value As String
  End Structure
  Private Structure GENERAL_BLOB
    Public Length As UInteger
    Public Value() As Byte
  End Structure

  Public Sub New(Config As BNUI.cConfig)
    bufIn = New BitReader({})
    bnConfig = Config
  End Sub

  Public Sub InitiateConnection()
    bEncrypt = False
    BNET2_CLIENT_AUTH_INFOREQUEST_Send(GetProd)
  End Sub

  Private Function GetProd() As String
    Dim prod As String = String.Empty
    Select Case bnConfig.Account.Client.Product
      Case BNUI.GameType.SCII : prod = "S2"
      Case BNUI.GameType.WOW : prod = "WoW"
      Case Else : prod = String.Empty
    End Select
    Return prod
  End Function

  Public Sub PacketIn(ByRef Data() As Byte)
    If bEncrypt Then
      mManager.Decrypt(Data, 0, Data.Length)
    End If
    bufIn.Append(Data)
    Do
      Dim readBytes As ULong = ReadBuf()
      If readBytes > 0 Then
        bufIn.EraseTo(readBytes)
      Else
        Exit Do
      End If
      If bufIn.GetAllData IsNot Nothing Then
        If bufIn.GetAllData.Length > 0 Then
          Debug.Print(bufIn.GetAllData.Length)
          Stop
        End If
      End If
    Loop While bufIn.GetAllData IsNot Nothing AndAlso bufIn.GetAllData.Length > 0
  End Sub

  Private Function ReadBuf() As ULong
    Try
      bufIn.Position = 0
      Dim bPacket As Byte = bufIn.ReadNumber(6)
      Dim bChannel As Boolean = bufIn.ReadNumber(1) = 1
      Dim bChanID As Byte = 0
      If bChannel Then bChanID = bufIn.ReadNumber(4)
      Dim lRet As ULong = 0
      Select Case bChanID
        Case &H0 'Auth
          Select Case bPacket
            Case &H0 : lRet = BNET2_CLIENT_AUTH_COMPLETE_Recv(bufIn)
            Case &H1 : lRet = BNET2_CLIENT_TIMEOUT_Recv(bufIn)
            Case &H2 : lRet = BNET2_CLIENT_AUTH_PROOFREQUEST_Recv(bufIn)
            Case &H3 : lRet = BNET2_CLIENT_AUTH_UPDATE_Recv(bufIn)
            Case Else
              RaiseEvent Failure(New Exception("Unknown Auth Packet:" & vbNewLine & FormatPacket(bufIn.GetAllData)))
              Stop
          End Select
        Case &H1 'Crep
          Select Case bPacket
            Case &H0 : lRet = BNET2_CLIENT_CREP_UNKNOWN_00_Recv(bufIn)
            Case &H1 : lRet = BNET2_CLIENT_TIMEOUT_Recv(bufIn)
            Case &H4 : lRet = BNET2_CLIENT_CREP_UNKNOWN_04_Recv(bufIn)
            Case Else
              RaiseEvent Failure(New Exception("Unknown Crep Packet:" & vbNewLine & FormatPacket(bufIn.GetAllData)))
              Stop
          End Select
        Case 2 'WoW
          RaiseEvent Failure(New Exception("Unknown WoW Packet:" & vbNewLine & FormatPacket(bufIn.GetAllData)))
          Stop
        Case 3 'SC2 supposedly
          RaiseEvent Failure(New Exception("Unknown SC2 Packet:" & vbNewLine & FormatPacket(bufIn.GetAllData)))
          Stop
        Case &HE 'Channel E
          Select Case bPacket
            Case &H4 : lRet = BNET2_CLIENT_0E_UNKNOWN_04_Recv(bufIn)
            Case Else
              RaiseEvent Failure(New Exception("Unknown Channel E Packet:" & vbNewLine & FormatPacket(bufIn.GetAllData)))
              Stop
          End Select
        Case &HF 'Channel F
          Select Case bPacket
            Case &H0 'Profile
            Case &H2 'Portrait
            Case &HA : lRet = BNET2_CLIENT_0F_UNKNOWN_0A_Recv(bufIn) 'Unknown10
            Case &HB 'File Handles
            Case Else
              RaiseEvent Failure(New Exception("Unknown Channel F Packet:" & vbNewLine & FormatPacket(bufIn.GetAllData)))
              Stop
          End Select
        Case Else
          RaiseEvent Failure(New Exception("Unknown " & Hex(bChanID) & " Packet:" & vbNewLine & FormatPacket(bufIn.GetAllData)))
          Stop
      End Select
      'If lRet = 0 Then Return 0
      Return lRet '+ 6 + IIf(bChannel, 5, 1)
    Catch ex As Exception
      If ex.Message = "Out of buffered data." Then
        Return 0
      Else
        RaiseEvent Failure(ex)
        Return 0
      End If
    End Try
  End Function

  Private Function BNET2_CLIENT_AUTH_COMPLETE_Recv(ByRef Packet As BitReader) As ULong
    Dim Values As CLIENT_AUTH_COMPLETE
    Try
      Values.Failure = Packet.ReadNumber(1) = 1
      If Values.Failure Then
        Values.FailPacket.HasOptModule = Packet.ReadNumber(1) = 1
        If Values.FailPacket.HasOptModule Then
          Packet.alignToBB()
          Values.FailPacket.OptModule.modType = Packet.ReadDWord
          Values.FailPacket.OptModule.modLocale = Packet.ReadDWord
          Values.FailPacket.OptModule.modID = Packet.ReadBytes(32)
        Else
          Values.FailPacket.OptModule.modType = String.Empty
          Values.FailPacket.OptModule.modLocale = String.Empty
          Values.FailPacket.OptModule.modID = Nothing
        End If
        Values.FailPacket.FailType = Packet.ReadNumber(2)
        Select Case Values.FailPacket.FailType
          Case 0, 2
            Packet.alignToBB()
            RaiseEvent ServiceError("Auth failure: " & Values.FailPacket.FailType)
          Case 1
            Values.FailPacket.ErrorCode = Packet.ReadNumber(16)
            Values.FailPacket.ErrorExtra = Packet.ReadNumber(32) + 2147483648UL
        End Select
        If Values.FailPacket.HasOptModule Then Debug.Print("Fail says run " & BitConverter.ToString(Values.FailPacket.OptModule.modID).Replace("-", "").ToLower & "." & Values.FailPacket.OptModule.modType)
        If Values.FailPacket.FailType = 1 Then
          'If Values.FailPacket.ErrorCode = &H65 Then
          '  mManager.Dispose()
          '  mManager = Nothing
          '  If My.Computer.FileSystem.DirectoryExists(AppStore & "\BN2 Modules\") Then My.Computer.FileSystem.DeleteDirectory(AppStore & "\BN2 Modules\", FileIO.DeleteDirectoryOption.DeleteAllContents)
          'End If
          RaiseEvent ServiceError(ErrorCode(Values.FailPacket.ErrorCode) & " [" & PadHex(Values.FailPacket.ErrorExtra, 8) & "]")
        End If
        Packet.alignToBB()
        Return Packet.Position
      Else
        Values.SuccessPacket.Modules = Packet.ReadNumber(3)
        If Values.SuccessPacket.Modules > 0 Then
          ReDim Values.SuccessPacket.ModuleBlob(Values.SuccessPacket.Modules - 1)
          For I As Integer = 0 To Values.SuccessPacket.Modules - 1
            Packet.alignToBB()
            Values.SuccessPacket.ModuleBlob(I).ModuleData.modType = Packet.ReadDWord
            Values.SuccessPacket.ModuleBlob(I).ModuleData.modLocale = Packet.ReadDWord
            Values.SuccessPacket.ModuleBlob(I).ModuleData.modID = Packet.ReadBytes(32)
            Values.SuccessPacket.ModuleBlob(I).BlobData.Length = Packet.ReadNumber(10)
            Packet.alignToBB()
            Values.SuccessPacket.ModuleBlob(I).BlobData.Value = Packet.ReadBytes(Values.SuccessPacket.ModuleBlob(I).BlobData.Length)
          Next
          Packet.alignToBB()
        Else
          ReDim Values.SuccessPacket.ModuleBlob(0)
        End If
        Values.SuccessPacket.PingTimeout = Packet.ReadNumber(32) + 2147483648UL
        Values.SuccessPacket.HasOptSegment = Packet.ReadNumber(1) = 1
        If Values.SuccessPacket.HasOptSegment Then
          Values.SuccessPacket.Bool = Packet.ReadNumber(1) = 1
          If Values.SuccessPacket.Bool Then
            Values.SuccessPacket.Threshold = Packet.ReadNumber(32)
            Values.SuccessPacket.Rate = Packet.ReadNumber(32)
          End If
        End If
        Values.SuccessPacket.FirstName.Length = Packet.ReadNumber(8)
        If Values.SuccessPacket.FirstName.Length > 0 Then
          Packet.alignToBB()
          Values.SuccessPacket.FirstName.Value = Packet.ReadChars(Values.SuccessPacket.FirstName.Length)
        Else
          Values.SuccessPacket.FirstName.Value = String.Empty
        End If
        Values.SuccessPacket.LastName.Length = Packet.ReadNumber(8)
        If Values.SuccessPacket.LastName.Length > 0 Then
          Packet.alignToBB()
          Values.SuccessPacket.LastName.Value = Packet.ReadChars(Values.SuccessPacket.LastName.Length)
        Else
          Values.SuccessPacket.LastName.Value = String.Empty
        End If
        Packet.alignToBB()
        Values.SuccessPacket.AccountID = Packet.ReadNumber(32)

        Values.SuccessPacket.Unknowns = Packet.ReadBytes(10)

        Values.SuccessPacket.AccountIDString.Length = Packet.ReadNumber(8)
        Packet.alignToBB()
        Values.SuccessPacket.AccountIDString.Value = Packet.ReadChars(Values.SuccessPacket.AccountIDString.Length)
        Values.SuccessPacket.MoreUnknowns = Packet.ReadBytes(13)


        If Values.SuccessPacket.Modules > 0 Then
          Dim bRets()() As Byte = RunModules(Values.SuccessPacket.ModuleBlob)
        End If
        BNET2_CLIENT_CREP_REQUEST_PROFILES_Send()
        mManager.EnableEncryption()
        bEncrypt = True
        Return Packet.Position
        End If
    Catch ex As Exception
      If ex.Message = "Out of buffered data." Then
        Return 0
      Else
        Stop
        Return 0
      End If
    End Try
  End Function

  Private Function BNET2_CLIENT_TIMEOUT_Recv(ByRef Packet As BitReader) As ULong
    Return 0
  End Function

  Private Function BNET2_CLIENT_AUTH_PROOFREQUEST_Recv(ByRef Packet As BitReader) As ULong
    Dim Values As CLIENT_AUTH_PROOFREQUEST
    Values.Modules = Packet.ReadNumber(3)
    ReDim Values.ModuleBlob(Values.Modules - 1)
    For I As Integer = 0 To Values.Modules - 1
      Packet.alignToBB()
      Values.ModuleBlob(I).ModuleData.modType = Packet.ReadDWord
      Values.ModuleBlob(I).ModuleData.modLocale = Packet.ReadDWord
      Values.ModuleBlob(I).ModuleData.modID = Packet.ReadBytes(32)
      Values.ModuleBlob(I).BlobData.Length = Packet.ReadNumber(10)
      Packet.alignToBB()
      Values.ModuleBlob(I).BlobData.Value = Packet.ReadBytes(Values.ModuleBlob(I).BlobData.Length)
    Next
    Dim bRets()() As Byte = RunModules(Values.ModuleBlob)
    If bRets IsNot Nothing Then
      BNET2_CLIENT_AUTH_PROOFRESPONSE_Send(bRets.Length, bRets)
    Else
      ReDim bRets(0)
      ReDim bRets(0)(0)
      BNET2_CLIENT_AUTH_PROOFRESPONSE_Send(1, bRets)
      BNET2_CLIENT_CREP_REQUEST_UNKNOWN_00_Send()
    End If
    Return Packet.Position
  End Function

  Private Function BNET2_CLIENT_AUTH_UPDATE_Recv(ByRef Packet As BitReader) As ULong
    Dim AuthWriter As New AuthXML(GetProd)
    Dim authData As AuthXML.AuthData = AuthWriter.Data
    Do
      Dim Prod As String = Packet.ReadDWord
      Dim Plat As String = Packet.ReadDWord
      Dim index As Integer = 0
      If authData.Components IsNot Nothing Then
        Dim bFound As Boolean = False
        For I As Integer = 0 To authData.Components.Length - 1
          If authData.Components(I).Product = Prod And authData.Components(I).Platform = Plat Then
            index = I
            bFound = True
            Exit For
          End If
        Next
        If Not bFound Then
          ReDim Preserve authData.Components(authData.Components.Length)
          index = authData.Components.Length - 1
        End If
      Else
        ReDim authData.Components(0)
      End If
      authData.Components(index).Product = Prod
      authData.Components(index).Platform = Plat
      Dim DataLen As Byte = Packet.ReadNumber(8)
      Packet.alignToBB()
      Dim Data As String = Packet.ReadChars(DataLen)
      Dim Specifics() As String = Data.Split(";"c)
      authData.Components(index).Build = Specifics(3)
      Dim bContinue As Boolean = Packet.ReadNumber(8) = 1
      If Not bContinue Then Exit Do
      Dim C As String = Packet.ReadChars(1)
      Dim Null As Byte = Packet.ReadNumber(3)
    Loop
    If String.IsNullOrEmpty(authData.Product) Then authData.Product = authData.Components(0).Product
    If String.IsNullOrEmpty(authData.Platform) Then authData.Platform = authData.Components(0).Platform
    If String.IsNullOrEmpty(authData.Locale) Then authData.Locale = "enUS"
    AuthWriter.Data = authData
    AuthWriter.Save(authData.Product)
    Return Packet.Position
  End Function

  Private Function BNET2_CLIENT_CREP_UNKNOWN_00_Recv(ByRef Packet As BitReader) As ULong
    Packet.alignToBB()
    'Debug.Print(Packet.ToString)
    Return Packet.Position
  End Function

  Private Function BNET2_CLIENT_CREP_UNKNOWN_04_Recv(ByRef Packet As BitReader) As ULong
    'Debug.Print(BitConverter.ToString(Packet.ReadBytes(12)))
    'Debug.Print(Packet.ToString)
    Packet.alignToBB()
    Packet.ReadBytes(15)
    'RaiseEvent ServiceError("Unable to handle CREP Unknown Packet: " & Packet.ToString)
    'Debug.Print(Packet.ToString)
    Return Packet.Position
  End Function

  Private Function BNET2_CLIENT_0F_UNKNOWN_0A_Recv(ByRef Packet As BitReader) As ULong
    Packet.alignToBB()
    Dim RegEx1Len As Byte = Packet.ReadNumber(8)
    Dim RegEx1 As String = Packet.ReadChars(RegEx1Len)
    Dim Unknown30 As Byte = Packet.ReadNumber(8)
    Dim Unknown1 As Byte = Packet.ReadNumber(8)
    Dim Achv As String = Packet.ReadDWord
    Dim Ctry As String = Packet.ReadDWord
    Dim ThirtyTwo0() As Byte = Packet.ReadBytes(32)
    Dim Prod1 As String = Packet.ReadDWord
    Dim Five1() As Byte = Packet.ReadBytes(5)
    Dim unlk1 As String = Packet.ReadDWord
    Dim Ctry1 As String = Packet.ReadDWord
    Dim ThirtyTwo1() As Byte = Packet.ReadBytes(32)
    Dim unlk2 As String = Packet.ReadDWord
    Dim Ctry2 As String = Packet.ReadDWord
    Dim ThirtyTwo2() As Byte = Packet.ReadBytes(32)
    Dim unlk3 As String = Packet.ReadDWord
    Dim Ctry3 As String = Packet.ReadDWord
    Dim ThirtyTwo3() As Byte = Packet.ReadBytes(32)
    Dim unlk4 As String = Packet.ReadDWord
    Dim Ctry4 As String = Packet.ReadDWord
    Dim ThirtyTwo4() As Byte = Packet.ReadBytes(32)
    Dim unlk5 As String = Packet.ReadDWord
    Dim Ctry5 As String = Packet.ReadDWord
    Dim ThirtyTwo5() As Byte = Packet.ReadBytes(32)
    Dim unlk6 As String = Packet.ReadDWord
    Dim Ctry6 As String = Packet.ReadDWord
    Dim ThirtyTwo6() As Byte = Packet.ReadBytes(32)
    Dim Null As Byte = Packet.ReadNumber(8)
    Dim RegEx2Len As Byte = Packet.ReadNumber(8)
    Dim RegEx2 As String = Packet.ReadChars(RegEx2Len)
    Dim Thirteen() As Byte = Packet.ReadBytes(13)
    Dim Prod2 As String = Packet.ReadDWord
    Dim Five2() As Byte = Packet.ReadBytes(5)
    Dim Four() As Byte = Packet.ReadBytes(4)
    'Stop

    Debug.Print("Regular Expression 1: " & RegEx1)
    Debug.Print("Regular Expression 2: " & RegEx2)
    Debug.Print("30: " & Unknown30)
    Debug.Print("1: " & Unknown1)
    Debug.Print("ACHV: " & Achv)
    Debug.Print("Country: " & Ctry)
    Debug.Print("First 32: " & BitConverter.ToString(ThirtyTwo0))
    Debug.Print("Product: " & Prod1)
    Debug.Print("Five: " & BitConverter.ToString(Five1))

    Debug.Print("UNLK: " & unlk1)
    Debug.Print("Country: " & Ctry1)
    Debug.Print("32: " & BitConverter.ToString(ThirtyTwo1))
    Debug.Print("UNLK: " & unlk2)
    Debug.Print("Country: " & Ctry2)
    Debug.Print("32: " & BitConverter.ToString(ThirtyTwo2))
    Debug.Print("UNLK: " & unlk3)
    Debug.Print("Country: " & Ctry3)
    Debug.Print("32: " & BitConverter.ToString(ThirtyTwo3))
    Debug.Print("UNLK: " & unlk4)
    Debug.Print("Country: " & Ctry4)
    Debug.Print("32: " & BitConverter.ToString(ThirtyTwo4))
    Debug.Print("UNLK: " & unlk5)
    Debug.Print("Country: " & Ctry5)
    Debug.Print("32: " & BitConverter.ToString(ThirtyTwo5))
    Debug.Print("UNLK: " & unlk6)
    Debug.Print("Country: " & Ctry6)
    Debug.Print("32: " & BitConverter.ToString(ThirtyTwo6))

    Debug.Print("Null: " & Null)
    Debug.Print("Thirteen: " & BitConverter.ToString(Thirteen))
    Debug.Print("Product: " & Prod2)
    Debug.Print("Five: " & BitConverter.ToString(Five2))
    Debug.Print("Four: " & BitConverter.ToString(Four))
    Return Packet.Position
  End Function

  Private Function BNET2_CLIENT_0E_UNKNOWN_04_Recv(ByRef Packet As BitReader) As ULong
    'Debug.Print(Packet.ToString)
    Packet.alignToBB()
    Dim FirstChunk As UInt32 = Packet.ReadNumber(24)
    Dim CafeBabe1 As UInt32 = Packet.ReadNumber(32)
    Dim SomeID1 As Byte = Packet.ReadNumber(8)
    Dim Ident1 As UInt16 = Packet.ReadNumber(16)
    Dim Three1 As Byte = Packet.ReadNumber(8)
    Dim Null1 As UInt32 = Packet.ReadNumber(32)
    Dim OhOneOhOneOhOh As UInt32 = Packet.ReadNumber(24)
    Dim C4 As Byte = Packet.ReadNumber(8)
    Dim Six As Byte = Packet.ReadNumber(8)

    Dim SecondChunk As UInt32 = Packet.ReadNumber(24)
    Dim CafeBabe2 As UInt32 = Packet.ReadNumber(32)
    Dim SomeID2 As Byte = Packet.ReadNumber(8)
    Dim Ident2 As UInt16 = Packet.ReadNumber(16)
    Dim Three2 As Byte = Packet.ReadNumber(8)
    Dim Null2 As UInt32 = Packet.ReadNumber(32)
    Dim OhOneOhOneOhOne As UInt32 = Packet.ReadNumber(24)
    Dim FortyFour As Byte = Packet.ReadNumber(8)
    Dim Eight As Byte = Packet.ReadNumber(8)

    Dim ThirdChunk As UInt32 = Packet.ReadNumber(24)
    Dim Null3 As UInt32 = Packet.ReadNumber(32)
    Dim FiveEightEZeroThreeA() As Byte = Packet.ReadBytes(3)
    Dim Unknown() As Byte = Packet.ReadBytes(3)
    Dim OOCOO7O1() As Byte = Packet.ReadBytes(4)
    Dim UserLen As Byte = (Packet.ReadNumber(32) + 3) / 2
    Dim Username As String = Packet.ReadChars(UserLen)
    Dim CE90 As UInt16 = Packet.ReadNumber(16)
    Dim Unknown2 As UInt16 = Packet.ReadNumber(16)
    Dim Null4 As UInt32 = Packet.ReadNumber(32)
    Dim CafeBabe3 As UInt32 = Packet.ReadNumber(32)
    Dim SomeID3 As Byte = Packet.ReadNumber(8)
    Dim Ident3 As UInt16 = Packet.ReadNumber(16)
    Dim Three3 As Byte = Packet.ReadNumber(8)
    Dim Null5 As UInt32 = Packet.ReadNumber(32)

    Debug.Print("First Chunk: " & Hex(FirstChunk))
    Debug.Print(" CafeBabe: " & Hex(CafeBabe1))
    Debug.Print(" ID: " & Hex(SomeID1))
    Debug.Print(" Pattern: " & Hex(Ident1))
    Debug.Print(" 3: " & Three1)
    Debug.Print(" Null1: " & Null1)
    Debug.Print(" 010100: " & Hex(OhOneOhOneOhOh))
    Debug.Print(" C4: " & Hex(C4))
    Debug.Print(" 6: " & Six)
    Debug.Print("Second Chunk: " & Hex(SecondChunk))
    Debug.Print(" CafeBabe: " & Hex(CafeBabe2))
    Debug.Print(" ID: " & Hex(SomeID2))
    Debug.Print(" Pattern: " & Hex(Ident2))
    Debug.Print(" 3: " & Three2)
    Debug.Print(" Null2: " & Null2)
    Debug.Print(" 010101: " & Hex(OhOneOhOneOhOne))
    Debug.Print("  44: " & Hex(FortyFour))
    Debug.Print("  8: " & Eight)
    Debug.Print("Third Chunk: " & Hex(ThirdChunk))
    Debug.Print(" Null: " & Null3)
    Debug.Print(" 58 E0 3A: " & BitConverter.ToString(FiveEightEZeroThreeA))
    Debug.Print(" Unknown: " & BitConverter.ToString(Unknown))
    Debug.Print(" 00 C0 07 01: " & BitConverter.ToString(OOCOO7O1))
    Debug.Print(" Username: " & Username)
    Debug.Print(" CE 90: " & CE90)
    Debug.Print(" Unknown: " & Hex(Unknown2))
    Debug.Print(" Null: " & Null4)
    Debug.Print(" CafeBabe: " & Hex(CafeBabe3))
    Debug.Print(" ID: " & Hex(SomeID3))
    Debug.Print(" Pattern: " & Hex(Ident2))
    Debug.Print(" 3: " & Three3)
    Debug.Print(" Null: " & Null5)

    Return Packet.Position
  End Function

  Private Function RunModules(ModData() As GENERAL_MODULE_BLOB) As Byte()()
    If mManager Is Nothing Then mManager = New ModuleManager(bnConfig.Account.EMail.ToLower, bnConfig.Account.Password.ToUpper, bnConfig.Server)
    Dim bRets()() As Byte = Nothing
    Dim modRet As Integer = 0
    For I As Integer = 0 To ModData.Length - 1
      Dim sURL As Uri = New Uri("http://us.depot.battle.net:1119/" & BitConverter.ToString(ModData(I).ModuleData.modID).Replace("-"c, "").ToLower & "." & ModData(I).ModuleData.modType)
      If Not My.Computer.FileSystem.DirectoryExists(AppStore & "\BN2 Modules") Then My.Computer.FileSystem.CreateDirectory(AppStore & "\BN2 Modules")
      Dim sPath As String = AppStore & "\BN2 Modules\"
      If GetModuleName(ModData(I).ModuleData.modID).EndsWith(".dll") Then
        sPath &= GetModuleName(ModData(I).ModuleData.modID)
      Else
        sPath &= BitConverter.ToString(ModData(I).ModuleData.modID).Replace("-"c, "").ToLower & "." & ModData(I).ModuleData.modType
      End If
      If Not My.Computer.FileSystem.FileExists(sPath) Then
        RaiseEvent CreateProgress("auth" & I, "Downloading Module " & GetModuleName(ModData(I).ModuleData.modID) & "...")
        wsDownload.Headers.Clear()
        wsDownload.Headers.Set(Net.HttpRequestHeader.UserAgent, "Battle.net Web Client")
        wsDownload.DownloadFileAsync(sURL, sPath, {"auth" & I, "Module " & GetModuleName(ModData(I).ModuleData.modID)})
        Do While wsDownload.IsBusy
          Application.DoEvents()
        Loop
      End If
      Dim bRetVal() As Byte = Nothing
      'Debug.Print("Module " & GetModuleName(ModData(I).ModuleData.modID) & ": " & "Data: " & FormatPacket(ModData(I).BlobData.Value))
      Dim iRet As Integer = mManager.RunModule(sPath, ModData(I).BlobData.Value, bRetVal)
      'Debug.Print(sPath & " returns " & Hex(iRet))
      Select Case iRet
        Case 0
          If bRetVal Is Nothing Then
            'Debug.Print("Nothing at all")
          Else
            ReDim Preserve bRets(modRet)
            bRets(modRet) = bRetVal
            modRet += 1
          End If
        Case &HF7 : RaiseEvent ServiceError("Module " & GetModuleName(ModData(I).ModuleData.modID) & " Failure: Unable to handle Function 7 at this time. Nothing to worry about, though! Moving on...")
        Case Else : RaiseEvent ServiceError("Module " & GetModuleName(ModData(I).ModuleData.modID) & " Failure: " & ErrorCode(iRet))
      End Select
      Application.DoEvents()
    Next
    If modRet = 0 Then Return Nothing
    Return bRets
  End Function

  Private Sub BNET2_CLIENT_AUTH_INFOREQUEST_Send(Product As String)
    If Not String.IsNullOrEmpty(Product) Then
      Dim AuthReader As New AuthXML(Product)
      If String.IsNullOrEmpty(AuthReader.ErrMsg) Then
        Dim buf As New BitBuffer
        buf.insertBits(0, 6)
        buf.insertBits(1, 1)
        buf.insertBits(0, 4)
        buf.InsertDWORD(AuthReader.Data.Product)
        buf.InsertDWORD(AuthReader.Data.Platform)
        buf.InsertDWORD(AuthReader.Data.Locale)
        buf.insertBits(AuthReader.Data.Components.Length, 6)
        For I As Integer = 0 To AuthReader.Data.Components.Length - 1
          buf.InsertDWORD(AuthReader.Data.Components(I).Product)
          buf.InsertDWORD(AuthReader.Data.Components(I).Platform)
          buf.insertBits(AuthReader.Data.Components(I).Build, 32)
        Next
        buf.insertBits(1, 1)
        buf.insertBits(bnConfig.Account.EMail.Length - 3, 9)
        buf.AlignToBB()
        buf.insertBits(bnConfig.Account.EMail.ToLower, bnConfig.Account.EMail.Length * 8)
        RaiseEvent Send(buf.GetData)
      Else
        RaiseEvent Disconnect(AuthReader.ErrMsg, False)
      End If
    Else
      RaiseEvent Disconnect("Invalid Product! Please check your settings!", False)
    End If
  End Sub

  Private Sub BNET2_CLIENT_AUTH_PROOFRESPONSE_Send(Modules As Integer, Blobs()() As Byte)
    Dim buf As New BitBuffer
    buf.insertBits(2, 6)
    buf.insertBits(1, 1)
    buf.insertBits(0, 4)
    buf.insertBits(Modules, 3)
    For Each Blob() As Byte In Blobs
      buf.insertBits(Blob.Length, 10)
      buf.AlignToBB()
      buf.insertBits(Blob, Blob.Length * 8)
    Next
    'buf.AlignToBB()
    'Debug.Print(FormatPacket(buf.Out))
    RaiseEvent Send(buf.GetData)
  End Sub

  Private Sub BNET2_CLIENT_CREP_REQUEST_UNKNOWN_00_Send()
    Dim buf As New BitBuffer
    buf.insertBits(0, 6)
    buf.insertBits(1, 1)
    buf.insertBits(1, 4)
    buf.AlignToBB()
    RaiseEvent Send(buf.GetData)
  End Sub

  Private Sub BNET2_CLIENT_CREP_REQUEST_PROFILES_Send()
    Dim buf As New BitBuffer
    buf.insertBits(5, 6)
    buf.insertBits(1, 1)
    buf.insertBits(1, 4)
    buf.AlignToBB()
    RaiseEvent Send(buf.GetData)
  End Sub

  Private Sub wsDownload_DownloadProgressChanged(sender As Object, e As Net.DownloadProgressChangedEventArgs) Handles wsDownload.DownloadProgressChanged
    Dim ID() As String = CType(e.UserState, String())
    Static lastPercent As Integer
    If lastPercent <> e.ProgressPercentage Then
      RaiseEvent UpdateProgress(ID(0), "Downloading " & ID(1) & "... " & e.ProgressPercentage.ToString.Trim & "%")
      lastPercent = e.ProgressPercentage
    End If
  End Sub

  Private Sub wsDownload_DownloadFileCompleted(sender As Object, e As System.ComponentModel.AsyncCompletedEventArgs) Handles wsDownload.DownloadFileCompleted
    Dim ID() As String = CType(e.UserState, String())
    If e.Error Is Nothing Then
      RaiseEvent TerminateProgress(ID(0), ID(1) & " complete.")
    Else
      RaiseEvent TerminateProgress(ID(0), ID(1) & " Download Failed: " & e.Error.InnerException.Message)
    End If
  End Sub

  Private Function GetModuleName(ID As Byte()) As String
    Select Case BitConverter.ToString(ID).Replace("-"c, "").Substring(0, 8)
      Case "8F52906A" : Return "Password.dll"
      Case "36B27CD9" : Return "Thumbprint.dll"
      Case "41686A00" : Return "Agreement.dll"
      Case "D09DC91E" : Return "SYSDESC.dll"
      Case Else : Return BitConverter.ToString(ID).Replace("-"c, "").Substring(0, 8)
    End Select
  End Function

  Private Function ErrorCode(Code As Integer) As String
    Select Case Code
      Case &H64 : Return "Internal error."
      Case &H65 : Return "Authentication module is corrupt. Please retry."
      Case &H66 : Return "No Battletags."
      Case &H67 : Return "You've attempted to connect to a bad server."
      Case &H68 : Return My.Resources.ERR_BADPASS
      Case &H69 : Return "Your connection was closed."
      Case &H6A : Return "Battle.net did not respond to your login attempt."
      Case &H6B : Return "No Game Accounts."
      Case &H6C : Return "Invalid Token."
      Case &H6D : Return "Invalid Program."
      Case &H6E : Return "Invalid Platform."
      Case &H6F : Return "Invalid Locale."
      Case &H70 : Return "Invalid Version."
      Case &H71 : Return "There is a temporary outage with Battle.net. Please try again later."
      Case &H72 : Return "Unable to download authentication module."
      Case &H73 : Return "Duplicate Logon."
      Case &H74 : Return "Account does not exist."
      Case &H75 : Return "Version check succeeded."
      Case &H76 : Return "Bad version hash."
      Case &H77 : Return "Can't retrieve Portal list."
      Case &H78 : Return "Dark Portal does not exist."
      Case &H79 : Return "Dark Portal file corrupted."
      Case &H7A : Return "Server is Private."
      Case &H7B : Return "You have logged in too soon after being disconnected. Please wait a moment and try again."
      Case &H7C : Return "Use Grunt Login."
      Case &H7D : Return "Idle Timeout."
      Case &H7E : Return "Account Expired."
      Case &H7F : Return "Benefactor does not exist."
      Case &H80 : Return "Authentication module not found."
      Case &H81 : Return "Your account is not licensed."
      Case &H82 : Return "Password computation failure."
      Case &H83 : Return "Server didn't know password."
      Case &H84 : Return "Connection failure."
      Case &H85 : Return "Disconnected."
      Case &H86 : Return "No Key."
      Case &H87 : Return "Decryption failure."
      Case &H84 : Return "Key poke failure."
      Case &H85 : Return "Must accept agreement."
      Case &H86 : Return "New patch available."
      Case &H87 : Return "This account does not yet have a password associated with it. Complete the account setup process and try again."
      Case Else : Return "Auth failure: " & PadHex(Code, 4)
    End Select
  End Function

  Friend Class AuthXML
    Public Structure AuthData
      Public Product As String
      Public Platform As String
      Public Locale As String
      Public Components() As AuthComponent
      Public Structure AuthComponent
        Public Product As String
        Public Platform As String
        Public Build As UInt32
      End Structure
    End Structure
    Private cStruct As AuthData
    Private sErr As String
    Public Sub New()
      cStruct = Nothing
      sErr = String.Empty
    End Sub
    Public Sub New(Product As String)
      sErr = String.Empty
      Dim sPath As String = AppStore & "\BN2 Auth\" & Product & ".xml"
      If My.Computer.FileSystem.FileExists(sPath) Then
        Dim XReader As Xml.Linq.XElement = Xml.Linq.XElement.Load(sPath)
        If XReader.Attribute("CLIENT").Value = Product Then
          Dim Info As Xml.Linq.XElement = XReader.Element("INFO")
          If Info IsNot Nothing Then
            cStruct.Product = Info.Element("PRODUCT").Value
            cStruct.Platform = Info.Element("PLATFORM").Value
            cStruct.Locale = Info.Element("LOCALE").Value
          Else
            sErr = "Info Section Missing!"
          End If
          Dim Components As Xml.Linq.XElement = XReader.Element("COMPONENTS")
          If Components IsNot Nothing Then
            Dim iComponents As Integer = Components.Attribute("COUNT").Value
            If iComponents > 0 Then
              ReDim cStruct.Components(iComponents - 1)
              For I As Integer = 0 To iComponents - 1
                Dim Index As Integer = I + 1
                Dim component As Xml.Linq.XElement = (From xFind As Xml.Linq.XElement In Components.Elements Where xFind.Name = "COMPONENT" AndAlso xFind.Attribute("ID").Value = Index Select xFind).FirstOrDefault
                cStruct.Components(I).Product = component.Element("PRODUCT").Value
                cStruct.Components(I).Platform = component.Element("PLATFORM").Value
                cStruct.Components(I).Build = component.Element("BUILD").Value
              Next
            Else
              sErr = "Component Count Null!"
            End If
          Else
            sErr = "Components Section Missing!"
          End If
        Else
          sErr = "Client Mismatch: Expected to read " & Product & ", but read " & XReader.Attribute("CLIENT").Value
        End If
      Else
        sErr = "No Auth info found for " & Product & ". Please check for " & sPath & "!"
      End If
    End Sub
    Public Property Data As AuthData
      Get
        Return cStruct
      End Get
      Set(value As AuthData)
        cStruct = value
      End Set
    End Property
    Public ReadOnly Property ErrMsg As String
      Get
        Return sErr
      End Get
    End Property
    Public Sub Save(Product As String)
      sErr = String.Empty
      Dim sPath As String = AppStore & "\BN2 Auth\" & Product & ".xml"
      Dim xInfo As New Xml.Linq.XElement("INFO",
                   New Xml.Linq.XElement("PRODUCT", cStruct.Product),
                   New Xml.Linq.XElement("PLATFORM", cStruct.Platform),
                   New Xml.Linq.XElement("LOCALE", cStruct.Locale))
      Dim xCompList As New Xml.Linq.XElement("COMPONENTS", New Xml.Linq.XAttribute("COUNT", cStruct.Components.Length))
      For I As Integer = 0 To cStruct.Components.Length - 1
        xCompList.Add(New Xml.Linq.XElement("COMPONENT", New Xml.Linq.XAttribute("ID", I + 1),
                           New Xml.Linq.XElement("PRODUCT", cStruct.Components(I).Product),
                           New Xml.Linq.XElement("PLATFORM", cStruct.Components(I).Platform),
                           New Xml.Linq.XElement("BUILD", cStruct.Components(I).Build)))
      Next
      Dim xWriter As New Xml.Linq.XElement("AUTH",
                                           New Xml.Linq.XAttribute("CLIENT", Product),
                                           xInfo,
                                          xCompList)
      xWriter.Save(sPath)
    End Sub
  End Class

#Region "IDisposable Support"
  Private disposedValue As Boolean ' To detect redundant calls

  ' IDisposable
  Protected Overridable Sub Dispose(disposing As Boolean)
    If Not Me.disposedValue Then
      If disposing Then
        ' TODO: dispose managed state (managed objects).
        If mManager IsNot Nothing Then
          mManager.Dispose()
          mManager = Nothing
        End If
      End If

      ' TODO: free unmanaged resources (unmanaged objects) and override Finalize() below.
      ' TODO: set large fields to null.
    End If
    Me.disposedValue = True
  End Sub

  ' TODO: override Finalize() only if Dispose(ByVal disposing As Boolean) above has code to free unmanaged resources.
  'Protected Overrides Sub Finalize()
  '    ' Do not change this code.  Put cleanup code in Dispose(ByVal disposing As Boolean) above.
  '    Dispose(False)
  '    MyBase.Finalize()
  'End Sub

  ' This code added by Visual Basic to correctly implement the disposable pattern.
  Public Sub Dispose() Implements IDisposable.Dispose
    ' Do not change this code.  Put cleanup code in Dispose(ByVal disposing As Boolean) above.
    Dispose(True)
    GC.SuppressFinalize(Me)
  End Sub
#End Region
End Class
