﻿Imports Ionic.Zip
Module modMain
  Private Structure FileDetails
    Public Structure FileDetail
      Public Attributes As IO.FileAttributes
      Public Created As Date
      Public LastWrite As Date
      Public Length As Long
    End Structure
    Public FilePath As String
    Public FileInfo As FileDetail
    Public FileHash As String
    Public FileURL As String
    Public FileVer As String
  End Structure
  Sub Main()
    Dim sTmpPath As String = String.Empty
    Dim sAppPath As String = String.Empty
    Try
      For Each sItem In My.Application.CommandLineArgs
        If sItem.StartsWith("/tmp=") Then sTmpPath = sItem.Substring(5).Replace("""", String.Empty)
        If sItem.StartsWith("/app=") Then sAppPath = sItem.Substring(5).Replace("""", String.Empty)
      Next
      If My.Computer.FileSystem.FileExists(sTmpPath & "\Update.zip") Then
        Console.Clear()
        Console.WriteLine("==============================")
        Console.WriteLine("  Entelechy Update un-Packer  ")
        Console.WriteLine("==============================")
        Console.WriteLine()
        Console.Write("Waiting for Entelechy to close...")
        Do While Process.GetProcessesByName("Entelechy").Count > 0
          Threading.Thread.Sleep(1000)
          Console.Write(".")
        Loop
        Console.WriteLine()
        Console.WriteLine()
        If Not My.Computer.FileSystem.DirectoryExists(sAppPath) Then My.Computer.FileSystem.CreateDirectory(sAppPath)
        Using zipHashes As ZipFile = zipFile.Read(sTmpPath & "\Update.zip")
          Dim zipFile As ZipEntry
          For Each zipFile In zipHashes
            Console.WriteLine("Extracting " & zipFile.FileName & "...")
            If My.Computer.FileSystem.FileExists(sAppPath & "\" & zipFile.FileName) Then My.Computer.FileSystem.MoveFile(sAppPath & "\" & zipFile.FileName, sTmpPath & "\old\" & zipFile.FileName)
            zipFile.Extract(sAppPath, ExtractExistingFileAction.OverwriteSilently)
            Dim fDetails = GetFileDetails(sTmpPath & "\ver.xml", zipFile.FileName)
            If Not fDetails.FilePath = String.Empty Then
              My.Computer.FileSystem.GetFileInfo(sAppPath & "\" & zipFile.FileName).CreationTimeUtc = fDetails.FileInfo.Created
              My.Computer.FileSystem.GetFileInfo(sAppPath & "\" & zipFile.FileName).LastWriteTimeUtc = fDetails.FileInfo.LastWrite
              My.Computer.FileSystem.GetFileInfo(sAppPath & "\" & zipFile.FileName).Attributes = fDetails.FileInfo.Attributes
            End If
          Next
        End Using
        Console.WriteLine()
        Console.WriteLine("Removing update zip...")
        If My.Computer.FileSystem.FileExists(sTmpPath & "\Update.zip") Then My.Computer.FileSystem.DeleteFile(sTmpPath & "\Update.zip")
        Console.WriteLine()
        Console.WriteLine("Update complete!")
        Process.Start(sAppPath & "\Entelechy.exe")
      Else
        Console.Clear()
        Console.WriteLine("==============================")
        Console.WriteLine("  Entelechy Update un-Packer  ")
        Console.WriteLine("==============================")
        Console.WriteLine()
        Console.WriteLine("You do not need to run this program. It is for self-update purposes.")
        Console.Write("Press any key to close...")
        Console.ReadKey(True)
      End If
    Catch ex As Exception
      Console.Clear()
      Console.WriteLine("==============================")
      Console.WriteLine("  Entelechy Update un-Packer  ")
      Console.WriteLine("==============================")
      Console.WriteLine()
      Console.WriteLine(ex.Message)
      If sAppPath <> String.Empty Then
        Console.WriteLine("Update failed. Press any key to restart Entelechy.")
        Console.ReadKey(True)
        If sTmpPath <> String.Empty Then
          If My.Computer.FileSystem.FileExists(sTmpPath & "\Update.zip") Then My.Computer.FileSystem.DeleteFile(sTmpPath & "\Update.zip")
        End If
        Process.Start(sAppPath & "\Entelechy.exe")
      Else
        Console.WriteLine("Update failed. You will need to restart Entelechy. Press any key to close.")
        Console.ReadKey(True)
      End If
    End Try
  End Sub
  Private Function GetFileDetails(XML As String, Path As String) As FileDetails
    Dim xVer As XDocument = XDocument.Load(XML)
    Dim xVerFile As XElement = xVer.Element("verfile")
    Dim xUpdates As XElement = xVerFile.Element("updates")
    If xUpdates IsNot Nothing Then
      For Each File In xUpdates.Elements("file")
        If File.Element("path").Value = Path Then
          Dim uItem As FileDetails
          uItem.FilePath = File.Element("path").Value
          uItem.FileInfo.Attributes = File.Element("info").Element("attributes").Value
          uItem.FileInfo.Created = DateValue(File.Element("info").Element("created").Value)
          uItem.FileInfo.LastWrite = DateValue(File.Element("info").Element("lastwrite").Value)
          uItem.FileInfo.Length = File.Element("info").Element("length").Value
          uItem.FileHash = File.Element("hash").Value
          uItem.FileURL = File.Element("url").Value
          uItem.FileVer = File.Element("ver").Value
          Return uItem
        End If
      Next
      Return Nothing
    Else
      Return Nothing
    End If
  End Function
End Module
