Attribute VB_Name = "modWinsock"
'---------------------------------------------------------------------------------------
' Module    : modWinsock
' Date      : 6/23/2004
' Author    : LoRd[nK] (thevirushunter@hotmail.com)
' Purpose   : Public Winsock declarations, functions, etc; used when calling Winsock
'             directly.
'---------------------------------------------------------------------------------------

Option Explicit

Public Declare Function htons Lib "ws2_32.dll" (ByVal hostshort As Long) As Integer
Public Declare Function inet_addr Lib "ws2_32.dll" (ByVal CP As String) As Long
Public Declare Function inet_ntoa Lib "ws2_32.dll" (ByRef inaddr As in_addr) As Long
Public Declare Function setsockopt Lib "ws2_32.dll" (ByVal s As Long, ByVal level As Long, ByVal optname As Long, optval As Any, ByVal optlen As Long) As Long 'Set socket options

Private Declare Function gethostbyname Lib "ws2_32.dll" (ByVal strname As String) As Long

Public Const IPPROTO_TCP = 6
Public Const TCP_NODELAY = &H1 '(BOOL) Nagel Algorithm
Public Const SO_KEEPALIVE = 8 '(BOOL) Toggles the sending of keep-alive packets
Public Const SOCKET_ERROR = -1

Public Const AF_INET = 2
Public Const SOCK_STREAM = 1

Public Type in_addr
    s_b1 As Byte
    s_b2 As Byte
    s_b3 As Byte
    s_b4 As Byte
    s_w1 As Integer
    s_w2 As Integer
    s_addr As Long
End Type

Public Type sock_addr
    sin_family As Integer
    sin_port As Integer
    sin_addr As Long
    sin_zero(0 To 7) As Byte
End Type

Public Type HOSTENT
    hName As Long
    hAliases As Long
    hAddrType As Integer
    hLength As Integer
    hAddrList As Long
End Type

Public Type ConResp
    IP As String
    Port As Integer
    RespTime As Long
End Type

Public Enum sckState
    sckClosed = 0
    sckOpen = 1
    sckListening = 2
    sckConnectionPending = 3
    sckResolvingHost = 4
    sckHostResolved = 5
    sckConnecting = 6
    sckConnected = 7
    sckClosing = 8
    sckError = 9
End Enum

Private clsFunctions As New clsFunctions

Public Function GetIPFromHostName(ByVal Hostname As String) As String()
Dim tmpHOSTENT As HOSTENT

Dim tmpArrIP() As String
Dim tmpPointer As Long

tmpPointer = gethostbyname(Hostname)
If tmpPointer Then
    Dim I As Byte
    Dim strIPAddress As String
    Dim arrIPAddress() As Byte
    Dim arrIPAddresses() As String
    Call RtlMoveMemory(tmpHOSTENT, ByVal tmpPointer, LenB(tmpHOSTENT))
    Call RtlMoveMemory(tmpPointer, ByVal tmpHOSTENT.hAddrList, 4)
    ReDim arrIPAddresses(0)
    While tmpPointer
        ReDim arrIPAddress(0 To tmpHOSTENT.hLength)
        Call RtlMoveMemory(arrIPAddress(0), ByVal tmpPointer, tmpHOSTENT.hLength)
        For I = 0 To tmpHOSTENT.hLength - 1
            strIPAddress = strIPAddress & arrIPAddress(I) & "."
        Next
        arrIPAddresses(UBound(arrIPAddresses)) = Mid$(strIPAddress, 1, Len(strIPAddress) - 1)
        strIPAddress = vbNullString
        tmpHOSTENT.hAddrList = tmpHOSTENT.hAddrList + LenB(tmpHOSTENT.hAddrList)
        Call RtlMoveMemory(tmpPointer, ByVal tmpHOSTENT.hAddrList, 4)
        ReDim Preserve arrIPAddresses(0 To UBound(arrIPAddresses) + 1)
    Wend
    ReDim Preserve arrIPAddresses(0 To UBound(arrIPAddresses) - 1)
    GetIPFromHostName = arrIPAddresses
End If
End Function
Public Function GetFastestConResp(ByVal strHostName As String, ByVal intPort As Integer) As ConResp
intPort = 6112

Dim clsWinsock() As New clsWinsock

Dim arrServers() As String
Dim GTC As Long
Dim I As Long
Dim tmpPing As Long

arrServers() = GetIPFromHostName(strHostName)
ReDim clsWinsock(0 To UBound(arrServers))
For I = 0 To UBound(arrServers)
    GTC = GetTickCount()
    If clsWinsock(I).Connect(arrServers(I), intPort) Then
        tmpPing = GetTickCount() - GTC
        With GetFastestConResp
            If tmpPing < .RespTime Or .RespTime = 0 Then
                .IP = arrServers(I)
                .Port = intPort
                .RespTime = tmpPing
            End If
        End With
    Else
        Call AppendRTB(frmMain.rtbChat, True, vbRed, arrServers(I) & ": Connection timed out")
    End If
    Call clsWinsock(I).SendData("hrm")
    Call clsWinsock(I).Disconnect
    Set clsWinsock(I) = Nothing
Next I
Call AppendRTB(frmMain.rtbChat, True, vbRed, GetFastestConResp.IP & " has been resolved as the fastest " & strHostName & " server with a connection response time of " & GetFastestConResp.RespTime & "ms.")
End Function
