Attribute VB_Name = "modModule"
Option Explicit

Public Declare Function OpenEventLogA Lib "advapi32.dll" (ByVal lpUNCServerName As String, ByVallpSourceName As String) As Long
Public Declare Function ReportEventA Lib "advapi32.dll" (ByVal hEventLog As Long, ByVal wType As Long, ByVal wCategory As Long, ByVal dwEventID As Long, lpUserSid As Any, ByVal wNumStrings As Long, ByVal dwDataSize As Long, lpStrings As String, lpRawData As Any) As Long
Public Declare Function BackupEventLogA Lib "advapi32.dll" (ByVal hEventLog As Long, ByVal lpBackupFileName As String) As Long

Public Declare Function SetWindowPos Lib "User32.dll" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Public Declare Function SetWindowLongA Lib "user32" (ByVal hWnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Public Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hWnd As Long, ByVal msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Public Declare Function LockWindowUpdate Lib "User32.dll" (ByVal hWnd As Long) As Boolean 'Toggles automatic redrawing

Public Declare Function MessageBoxA Lib "User32.dll" (ByVal WindowHandle As Long, ByVal lpText As String, ByVal lpCaption As String, ByVal uType As Long) As Integer
Public Declare Function SendMessageA Lib "User32.dll" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Public Declare Function ShellExecuteA Lib "Shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVallpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Public Declare Sub GetLocalTime Lib "Kernel32.dll" (lpSystemTime As SYSTEMTIME)

Private Declare Function GetClientRect Lib "User32.dll" (ByVal hWnd As Long, lpRect As RECT) As Long
Private Declare Sub FatalAppExit Lib "kernel32" Alias "FatalAppExitA" (ByVal uAction As Long, ByVal lpMessageText As String)

'Memory Management/Allocation Functions
Public Declare Sub RtlMoveMemory Lib "Kernel32.dll" (ByRef Destination As Any, ByRef Source As Any, ByVal numBYTEs As Long)

'String Functions:
Public Declare Function lstrlenA Lib "Kernel32.dll" (ByVal lpString As Any) As Long
Public Declare Function lstrcpyA Lib "Kernel32.dll" (ByVal lpString1 As String, ByVal lpString2 As Long) As Long
Public Declare Function IsCharAlphaA Lib "User32.dll" (ByVal str As String) As Boolean
Public Declare Function IsCharAlphaNumericA Lib "User32.dll" (ByVal str As String) As Boolean
Public Declare Function lstrcatA Lib "Kernel32.dll" (ByVal lpString1 As String, ByVal lpString2 As String) As Long 'Appends the two strings and returns the memory address

'Timer Functions:
Public Declare Function GetTickCount Lib "Kernel32.dll" () As Long
Public Declare Function SetTimer Lib "User32.dll" (ByVal hWnd As Long, ByVal nIDEvent As Long, ByVal uElapse As Long, ByVal lpTimerFunc As Long) As Long
Public Declare Function KillTimer Lib "User32.dll" (ByVal hWnd As Long, ByVal nIDEvent As Long) As Long

Public Const WM_USER = &H400
Public Const GWL_WNDPROC = (-4)

Public Const WM_NOTIFY = &H4E
Public Const EM_SETEVENTMASK = &H445
Public Const EM_GETEVENTMASK = &H43B
Public Const EM_GETTEXTRANGE = &H44B
Public Const EM_AUTOURLDETECT = &H45B
Public Const EN_LINK = &H70B
Public Const ENM_LINK = &H4000000

Public Const WM_MOUSEMOVE = &H200 'On Mousemove
Public Const WM_LBUTTONDOWN = &H201 'Left Button Down
Public Const WM_LBUTTONUP = &H202 'Left Button Up
Public Const WM_LBUTTONDBLCLK = &H203 'Left Double Click
Public Const WM_RBUTTONDOWN = &H204 'Right Button Down
Public Const WM_RBUTTONUP = &H205 'Right Button Up
Public Const WM_RBUTTONDBLCLK = &H206 'Right Double Click

Public Type ScTw
    Width As Long
    Height As Long
End Type

Private Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

Private Type POINTL
    X As Long
    Y As Long
End Type

Public Type FILETIME
    dwLowDateTime As Long
    dwHighDateTime As Long
End Type

Public Type SYSTEMTIME
    wYear As Integer
    wMonth As Integer
    wDayOfWeek As Integer
    wDay As Integer
    wHour As Integer
    wMinute As Integer
    wSecond As Integer
    wMilliseconds As Integer
End Type

Public hrm As Long

Public Sub StayOnTop(Form As Form, blnBool As Boolean)
Dim tmpInt As Integer
If blnBool Then tmpInt = -1 Else tmpInt = -2
Call SetWindowPos(Form.hWnd, tmpInt, Form.Left / Screen.TwipsPerPixelX, Form.Top / Screen.TwipsPerPixelY, Form.Width / Screen.TwipsPerPixelX, Form.Height / Screen.TwipsPerPixelY, &H10 Or &H40)
End Sub
Public Sub AppendRTB(RTB As RichTextBox, blnTimeStamp As Boolean, ParamArray saElements() As Variant)
Const EM_GETSCROLLPOS = (WM_USER + 221)
Const EM_SETSCROLLPOS = (WM_USER + 222)
Const EM_LINEFROMCHAR = &HC9
Const EM_CHARFROMPOS = &HD7
Const EM_GETLINECOUNT = &HBA
Const EM_LINELENGTH = 193

Dim i As Integer
Dim LPos As Long
Dim pt As POINTL
Dim r As RECT
Dim l As Long
Dim LCount As Long

LCount = SendMessageA(RTB.hWnd, EM_GETLINECOUNT, &H0, ByVal &H0) - 1
Call GetClientRect(RTB.hWnd, r)
pt.X = r.Left + 1
pt.Y = r.Bottom - 1
LPos = SendMessageA(RTB.hWnd, EM_CHARFROMPOS, &H0, pt)
LPos = SendMessageA(RTB.hWnd, EM_LINEFROMCHAR, LPos, ByVal &H0)
If LPos < LCount Then Call SendMessageA(RTB.hWnd, EM_GETSCROLLPOS, &H0, pt)
Call LockWindowUpdate(RTB.hWnd)
If blnTimeStamp Then
    Dim ST As SYSTEMTIME
    Call GetLocalTime(ST)
    With RTB
        .SelStart = Len(.Text)
        .SelColor = vbWhite
        .SelText = "[" & Format(ST.wHour, "00") & ":" & Format(ST.wMinute, "00") & ":" & Format(ST.wSecond, "00") & "." & Format(ST.wMilliseconds, "000") & "] "
    End With
End If
For i = LBound(saElements) To UBound(saElements) Step 2
    With RTB
        .SelStart = Len(.Text)
        .SelColor = saElements(i)
        .SelText = saElements(i + 1) & Left$(vbCrLf, -2 * CLng((i + 1) = UBound(saElements)))
    End With
    'If SendMessageA(RTB.hWnd, EM_GETLINECOUNT, &H0, &H0) >= 1000 Then
    '    With RTB
    '        .SelStart = 0
    '        .SelLength = SendMessageA(RTB.hWnd, EM_LINELENGTH, &H1, &H0) + 2
    '        .SelText = ""
    '    End With
    'End If
Next i
If LPos < LCount Then Call SendMessageA(RTB.hWnd, EM_SETSCROLLPOS, &H0, pt)
Call LockWindowUpdate(&H0)
End Sub
Public Function WndProc(ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Select Case uMsg
    Case WM_NOTIFY
        MsgBox "!"
End Select
WndProc = CallWindowProc(hrm, hWnd, uMsg, wParam, lParam)
End Function

Public Function PixelToTwips(xwert As Long, ywert As Long) As ScTw
Dim ux As Long
Dim uy As Long
Dim XWert1 As Long
Dim yWert1 As Long

ux = Screen.TwipsPerPixelX
PixelToTwips.Width = xwert * ux
uy = Screen.TwipsPerPixelY
PixelToTwips.Height = ywert * uy
End Function
Public Function TwipsToPixel(xwert As Long, ywert As Long) As ScTw
Dim ux As Long
Dim uy As Long
Dim XWert1 As Long
Dim yWert1 As Long

ux = Screen.TwipsPerPixelX
TwipsToPixel.Width = xwert / ux
uy = Screen.TwipsPerPixelY
TwipsToPixel.Height = ywert / uy
End Function

Public Function Bleh()
MsgBox "!"
End Function
