VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsWinsock"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'---------------------------------------------------------------------------------------
' Module    : clsWinsock
' Date      : 6/23/2004
' Author    : LoRd[nK] (thevirushunter@hotmail.com)
' Purpose   : Class for dealing with Winsock calls directly
'---------------------------------------------------------------------------------------

Option Explicit

Private Declare Function WSAStartup Lib "ws2_32.dll" (ByVal wVersionRequested As Integer, lpWSAData As WSAData) As Integer 'Start use of Ws2_32.dll
Private Declare Function WSACleanup Lib "ws2_32.dll" () As Integer 'End use of Ws2_32.dll

Private Declare Function socket Lib "ws2_32.dll" (ByVal af As Integer, ByVal s_type As Integer, ByVal Protocol As Integer) As Long 'Creates a socket
Private Declare Function listen Lib "ws2_32.dll" (ByVal s As Long, ByVal backlog As Integer) As Long 'Places a socket in a state in which it is listening for an incoming connection
Private Declare Function vbConnect Lib "ws2_32.dll" Alias "connect" (ByVal s As Long, sockaddr As sock_addr, ByVal namelen As Integer) As Integer                 'Establish a connection to a specified socket
Private Declare Function closesocket Lib "ws2_32.dll" (ByVal s As Long) As Long 'Close socket
Private Declare Function send Lib "ws2_32.dll" (ByVal s As Long, ByVal Data As String, ByVal Length As Integer, flags As Long) As Long 'Send data to connected socket
Private Declare Function recv Lib "ws2_32.dll" (ByVal s As Long, ByRef buf As Any, ByVal buflen As Long, ByVal flags As Long) As Long

Private Declare Function getsockname Lib "ws2_32.dll" (ByVal s As Long, ByRef name As sock_addr, ByRef namelen As Long) As Long
Private Declare Function gethostname Lib "ws2_32.dll" (ByVal name As String, ByVal namelen As Integer) As Integer 'Retrieves the standard host name for the local computer
Private Declare Function gethostbyname Lib "ws2_32.dll" (ByVal strname As String) As Long

Private Type WSAData
   wVersion As Integer
   wHighVersion As Integer
   szDescription(0 To 256) As Byte
   szSystemStatus(0 To 128) As Byte
   iMaxSockets As Long
   iMaxUDPDG As Long
   lpVendorInfo As Long
End Type

Private SocketHandle As Long

Public Sub Disconnect()
Call closesocket(SocketHandle)
End Sub
Public Function Connect(ByVal strServer As String, ByVal intPort As Integer) As Boolean
Dim sckaddr As sock_addr
Dim hSocket As Long

SocketHandle = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)
With sckaddr
    .sin_family = AF_INET
    .sin_addr = inet_addr(strServer)
    .sin_port = htons(CLng(intPort))
End With
If vbConnect(SocketHandle, sckaddr, LenB(sckaddr)) = SOCKET_ERROR Then
    Connect = False
Else
    Connect = True
End If
End Function
Public Function SendData(ByVal strData As String) As Long
Dim tmpBuf() As Byte

tmpBuf() = StrConv(strData, vbFromUnicode)
SendData = send(SocketHandle, tmpBuf(0), Len(strData), &H0)
End Function
Public Property Get LocalHostName() As String
Dim strHost As String * 256

If gethostname(strHost, 256) <> SOCKET_ERROR Then
    LocalHostName = strHost
End If
End Property

Private Sub Class_Initialize()
Dim uWSAData As WSAData

If WSAStartup(&H101, uWSAData) = SOCKET_ERROR Then
    Call Class_Terminate
End If
End Sub
Private Sub Class_Terminate()
Call WSACleanup
End Sub
