VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSysTray"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'---------------------------------------------------------------------------------------
' Module    : clsSysTray
' Date      : 6/23/2004
' Author    : LoRd[nK] (thevirushunter@hotmail.com)
' Purpose   : Class for handling the application's system tray icon
'---------------------------------------------------------------------------------------

Option Explicit

Private Declare Function Shell_NotifyIconA Lib "SHELL32" (ByVal dwMessage As Long, pnid As NOTIFYICONDATA) As Boolean

Private Const NIM_ADD = &H0 'Add to Tray
Private Const NIM_MODIFY = &H1 'Modify Details
Private Const NIM_DELETE = &H2 'Remove From Tray
Private Const NIF_MESSAGE = &H1 'Message
Private Const NIF_ICON = &H2 'Icon
Private Const NIF_TIP = &H4 'TooTipText

Private Type NOTIFYICONDATA
    cbSize As Long
    hWnd As Long
    uID As Long
    uFlags As Long
    uCallbackMessage As Long
    hIcon As Long
    szTip As String * 64
End Type

Public Sub CreateSystemTrayIcon(Form As Form, Icon As Long, Tip As String)
Dim NID As NOTIFYICONDATA

With NID
    .cbSize = LenB(NID)
    .hWnd = Form.hWnd
    .uID = vbNull
    .uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE
    .uCallbackMessage = WM_MOUSEMOVE
    .hIcon = Icon
    .szTip = Tip & vbNullChar
End With
Call Shell_NotifyIconA(NIM_ADD, NID)
End Sub
Public Sub ModifySystemTrayIcon(Form As Form, hIcon As Long, Tip As String)
Dim NID As NOTIFYICONDATA

With NID
    .cbSize = LenB(NID)
    .hWnd = Form.hWnd
    .uID = vbNull
    .uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE
    .uCallbackMessage = WM_MOUSEMOVE
    .hIcon = hIcon
    .szTip = Tip & vbNullChar
End With
Call Shell_NotifyIconA(NIM_MODIFY, NID)
End Sub
Public Sub DeleteSystemTrayIcon(Form As Form)
Dim NID As NOTIFYICONDATA

With NID
    .cbSize = LenB(NID)
    .hWnd = Form.hWnd
    .uID = vbNull
    .uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE
    .uCallbackMessage = vbNull
    .hIcon = vbNull
    .szTip = vbNullString & vbNullChar
End With
Call Shell_NotifyIconA(NIM_DELETE, NID)
End Sub
