VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSOCKS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'---------------------------------------------------------------------------------------
' Module    : clsBNCS
' Date      : 6/18/2004
' Author    : LoRd[nK] (thevirushunter@hotmail.com)
' Purpose   : Class for sending and handling of SOCKSv4/5 packets
'---------------------------------------------------------------------------------------

'SOCKSv4 Protocol: http://archive.socks.permeo.com/Protocol/socks4.Protocol
'SOCKSv5 Protocol: http://archive.socks.permeo.com/rfc/rfc1928.txt

Option Explicit

Enum SOCKS_VERSION
    SOCKSv4 = 4
    SOCKSv5 = 5
End Enum

Private SOCKS_SocketHandle As Long
Private SOCKS_PRTCOLVER As Integer
Private SOCKS_USERID As String

Private DEST_IP As String 'DWORD
Private DEST_PORT As Integer 'WORD

Public Sub SendConnectReq()
Dim PacketBuffer As New clsPacketBuffer
Select Case SOCKS_PRTCOLVER
    Case SOCKSv4
        With PacketBuffer
            .InsertBYTE SOCKS_PRTCOLVER 'Protocol version number
            .InsertBYTE &H1 'Command code: [CONNECT(0x01)/BIND(0x02)]
            .InsertWORD DEST_PORT 'Destination Port
            .InsertDWORD CLng(DEST_IP) 'Destination IP
            .InsertNTString SOCKS_USERID 'User ID
            .InsertBYTE &H0
            .SendBuffer SOCKS_SocketHandle
        End With
    
    Case SOCKSv5
        With PacketBuffer
            .InsertBYTE SOCKS_PRTCOLVER
            .InsertBYTE &H1
            .InsertBYTE &H0
            .SendBuffer SOCKS_SocketHandle
            
            .InsertBYTE SOCKS_PRTCOLVER 'Protocol version number
            .InsertBYTE &H1 'Command code: [CONNECT(0x01)/BIND(0x02)/UDP(0x03) - SOCKSv5 ONLY]
            .InsertBYTE &H0 'Reserved
            .InsertBYTE &H1 'Address type of following address: [IPv4(0x01)/Domain(0x03)/IPv6(0x04)]
            .InsertNTString DEST_IP 'Destination IP
            .InsertWORD DEST_PORT 'Destination Port
            .SendBuffer SOCKS_SocketHandle
        End With
        
    Case Else 'Unknown SOCKS version
        Call closesocket(SOCKS_SocketHandle)
End Select
End Sub
Public Sub Parse(ByVal strData As String)
Select Case SOCKS_PRTCOLVER
    Case SOCKSv4
        Select Case Asc(Mid$(strData, 2, 1))
            Case 90 'Request granted
            Case 91 'Request rejected or failed
                Call closesocket(SOCKS_SocketHandle)
            Case 92 'Request rejected becasue SOCKS server cannot connect to identd on the client
                Call closesocket(SOCKS_SocketHandle)
            Case 93 'Request rejected because the client program and identd report different user-ids
                Call closesocket(SOCKS_SocketHandle)
            Case Else 'Unknown Response
                Call closesocket(SOCKS_SocketHandle)
        End Select
        
    Case SOCKSv5
        Select Case Asc(Mid$(strData, 2, 1))
            Case &H0 'Succeeded
            Case &H1 'General SOCKS server failure
                Call closesocket(SOCKS_SocketHandle)
            Case &H3 'Network unreachable
                Call closesocket(SOCKS_SocketHandle)
            Case &H4 'Host unreachable
                Call closesocket(SOCKS_SocketHandle)
            Case &H5 'Connection refused
                Call closesocket(SOCKS_SocketHandle)
            Case &H6 'TTL expired
                Call closesocket(SOCKS_SocketHandle)
            Case &H7 'Command not supported
                Call closesocket(SOCKS_SocketHandle)
            Case &H8 'Address type not supported
                Call closesocket(SOCKS_SocketHandle)
            Case Else 'Unknown SOCKSv5 response received
                Call closesocket(SOCKS_SocketHandle)
        End Select
        
    Case Else 'Unknown SOCKS version
        Call closesocket(SOCKS_SocketHandle)
End Select
End Sub

Public Property Let UserID(ByVal UserID As String)
SOCKS_USERID = UserID
End Property
Public Property Let Version(ByVal sVersion As SOCKS_VERSION)
SOCKS_PRTCOLVER = sVersion
End Property
Public Property Let DestinationIP(ByVal DestIP As String)
DEST_IP = inet_addr(DestIP)
End Property
Public Property Let DestinationPort(ByVal DestPort As Long)
DEST_PORT = htons(DestPort)
End Property
Public Property Let SocketHandle(ByVal sHandle As String)
SOCKS_SocketHandle = sHandle
End Property
