VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsParseStats"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'---------------------------------------------------------------------------------------
' Module    : clsParseStats
' Date      : 7/10/2004
' Author    : LoRd[nK] (thevirushunter@hotmail.com)
' Purpose   : Class for parsing user stat strings
'---------------------------------------------------------------------------------------

Option Explicit

Public Function ParseStatString(ByVal StatString As String) As String
Dim clsFunctions As New clsFunctions

Dim strClientID As String * 4
Dim arrValues() As String
strClientID = StrReverse(Mid$(StatString, 1, 4))

Select Case strClientID
    Case "DSHR", "DRTL" 'Diablo I (Diablo I: Shareware, Diablo I: Retail)
        arrValues() = Split(Mid$(StatString, 6), " ")
        If UBound(arrValues) <> 8 Then
            Exit Function
        End If
        '(BYTE): Level
        '(BYTE): Class
        '(BYTE): Dots
        '(BYTE): Strength
        '(BYTE): Magic
        '(BYTE): Dexterity
        '(BYTE): Vitality
        '(BYTE): Gold
    Case "D2DV", "D2XP" 'Diablo II (Diablo II, Diablo II: Lord of Destruction)
        Dim arrTmp() As String
        If Len(StatString) = 4 Then
            'Open Character
            Exit Function
        End If
    Case "STAR", "SEXP", "SSHR", "JSTR" 'StarCraft (StarCraft, StarCraft: Brood War, StarCraft: Shareware, StarCraft: Japanese)
        '(BYTE): Ladder Rating
        '(BYTE): Ladder Rank
        '(BYTE): Normal Game Wins
        '(BOOL): Spawn
        '(BYTE): Unknown
        '(BYTE): High Ladder Rating
        '(BYTE): Unknown
        '(BYTE): N/A
        '(DWORD): Icon
    Case "W2BN" 'Warcraft II: Battle.net Edition
        arrValues() = Split(Mid$(StatString, 6), " ")
        If UBound(arrValues) <> 8 Then
            Exit Function
        End If
        '(BYTE): Ladder Rating
        '(BYTE): Ladder Rank
        '(BYTE): Normal Game Wins
        '(BOOL): Spawn
        '(BYTE): Unknown
        '(BYTE): High Ladder Rating
        '(BYTE): Unknown
        '(BYTE): IronMan Rating
        '(DWORD): Icon
    Case "WAR3", "W3XP" 'Warcraft III (Warcraft III: Reign of Chaos, Warcarft III: The Frozen Throne)
    Case Else 'Unknown Product ID
End Select
End Function
Public Function ParseD2Realm(arrSS() As Long) As String
'(BYTE): Version
'(Unknown): Unknown
'(BYTE): Helmet
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(BYTE): Weapon
'(Unknown): Unknown
'(BYTE): Shield
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(BYTE): Race
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(Unknown): Unknown
'(BYTE): Level
'(BOOL): Hardcore & 4; Dead & 8
'(BYTE): Act
'(Unknown): Unknown
'(Unknown): Unknown
'(BOOL): Ladder

Dim arrD2Classes(0 To 6) As String

arrD2Classes(0) = "amazon"
arrD2Classes(1) = "sorceress"
arrD2Classes(2) = "necromancer"
arrD2Classes(3) = "paladin"
arrD2Classes(4) = "barbarian"
arrD2Classes(5) = "druid"
arrD2Classes(6) = "assassin"
End Function

Public Function MLProductID(ByVal strClient As String) As String
Select Case strClient
    Case "DSHR"
        strClient = "Diablo I: Shareware"
    Case "DRTL"
        strClient = "Diablo I: Retail"
    Case "D2DV"
        strClient = "Diablo II"
    Case "D2XP"
        strClient = "Diablo II: Lord of Destruction"
    Case "STAR"
        strClient = "StarCraft"
    Case "SEXP"
        strClient = "StarCraft: Brood War"
    Case "SSHR"
        strClient = "StarCraft: Shareware"
    Case "JSTR"
        strClient = "StarCraft: Japanese"
    Case "W2BN"
        strClient = "Warcraft II: Battle.net Edition"
    Case "WAR3"
        strClient = "Warcraft III: Reign of Chaos"
    Case "W3XP"
        strClient = "Warcraft III: The Frozen Throne"
    Case Else
        strClient = "Unknown"
End Select
End Function
