VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsPacketBuffer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'---------------------------------------------------------------------------------------
' Module    : clsPacketBuffer
' Date      : 6/23/2004
' Author    : LoRd[nK] (thevirushunter@hotmail.com)
' Purpose   : Class for building and sending packets for various Protocols
'---------------------------------------------------------------------------------------

Option Explicit

Private buffer As String

Private clsFunctions As New clsFunctions

Public Function InsertBYTE(Data As Integer) 'Insert a BYTE into the buffer
'BYTE: 8 bit unsigned integer (0x00)
buffer = buffer & Chr(Data)
End Function
Public Function InsertWORD(Data As Integer) 'Insert a WORD into the buffer
'WORD: 16 bit unsigned integer in little endian byte order (0x0000)
buffer = buffer & clsFunctions.MakeWORD(Data)
End Function
Public Function InsertDWORD(Data As Long) 'Insert a DWORD into the buffer
'DWORD: 32 bit unsigned integer in little endian byte order (0x00000000)
buffer = buffer & clsFunctions.MakeDWORD(Data)
End Function
Public Function InsertNTString(Data As String) 'Insert a null terminated string into the buffer
'NTString: Null-terminated character array
buffer = buffer & Data & Chr(0)
End Function
Public Function InsertNonNTString(Data As String, Length As Long) 'Insert a non-null terminated string into the buffer
'NonNTString: Character array
buffer = buffer & Data
End Function
Public Sub Clear() 'Clears the buffer
buffer = ""
End Sub
Public Sub BuildPacket(Protocol As BN_PROTOCOLS, PacketID As Byte) 'Finalize the construction of the packet according to the specified header
Select Case Protocol
    Case BNCS
        'Header:
        '(BYTE)      StartPacket - always 0xFF
        '(BYTE)      Packet ID
        '(WORD)      Packet length, including this header
        '(VOID)      Packet Data
        buffer = Chr(&HFF) & Chr(PacketID) & clsFunctions.MakeWORD(Len(buffer) + 4) & buffer
    Case BNFTP1
        'Header:
        '(WORD) Packet length, including this header
        '(VOID) Packet Data
        buffer = clsFunctions.MakeWORD(Len(buffer) + 2) & buffer
    'Case BNFTP2
        'Header:
    Case MCP
        'Header:
        '(WORD)      Packet length, including this header
        '(BYTE)      Packet ID
        '(VOID)      Packet Data
        buffer = clsFunctions.MakeWORD(Len(buffer) + 3) & Chr(PacketID) & buffer
    'Case UDP
        'Header:
        '(DWORD) Unknown (Protocol?/ID?)
        '(WORD) Checksum result
        '(WORD) Packet length, including this header
        '(WORD) Unknown
        '(WORD) Unknown
        '(WORD) Unknown
        '(WORD) Unknown
        '(VOID) Packet Data
    Case D2GS
        'Header:
        '(BYTE)      Packet ID
        '(VOID)      Packet Data
        buffer = Chr(PacketID) & buffer
    Case W3GS
        'Header:
        '(BYTE) StartPacket - always 0xF7
        '(BYTE) Packet ID
        '(WORD) Packet length, including this header
        '(VOID) Packet Data
        buffer = Chr(&HF7) & Chr(PacketID) & clsFunctions.MakeWORD(Len(buffer) + 4) & buffer
    Case BotNet
        'Header:
        '(BYTE)      Protocol Version (Currently 0x01)
        '(BYTE)      Packet ID
        '(WORD)      Packet Length, including this header
        '(VOID)      Packet Data
        buffer = Chr(&H1) & Chr(PacketID) & clsFunctions.MakeWORD(Len(buffer) + 4) & buffer
    Case BNLS
        'Header:
        '(WORD)      Packet Length, including this header
        '(BYTE)      Packet ID
        '(VOID)      Packet Data
        buffer = clsFunctions.MakeWORD(Len(buffer) + 3) & Chr(PacketID) & buffer
    Case Else
        Exit Sub
End Select
End Sub
Public Property Get GetData() As String 'Returns the contents of the buffer and then clears the buffer
GetData = buffer
Call Clear
End Property
Public Property Get PeekData() As String 'Returns the contents of the buffer
PeekData = buffer
End Property
Public Function SendBuffer(ByVal SocketHandle As Long) As Long 'Send the buffer's contents to the specified socket
SendBuffer = modWinsock.SendData(SocketHandle, buffer)
Call Clear
End Function

