VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMCP"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'---------------------------------------------------------------------------------------
' Module    : clsBNCS
' Date      : 6/18/2004
' Author    : LoRd[nK] (thevirushunter@hotmail.com)
' Purpose   : Class for sending and handling of MCP (Master Control Program - Diablo II
'             Realm) packets
'---------------------------------------------------------------------------------------

Option Explicit

Private Const MCP_STARTUP = &H1
Private Const MCP_CHARCREATE = &H2
Private Const MCP_CHARLOGON = &H7
Private Const MCP_CHARDELETE = &HA
Private Const MCP_MOTD = &H12
Private Const MCP_CHARLIST = &H17
Private Const MCP_CHARUPGRADE = &H18

Private Type PacketInfo
    PacketID As Byte
    PacketLength As Integer
    PacketData As String
End Type

Private MCP_CHUNK1 As Long
Private MCP_CHUNK2 As Long
Private BNCS_UNIQUENAME As String

Private Sub Parse(ByVal MCP_SocketHandle As Long, ByVal strData As String)
Dim clsFunctions As New clsFunctions

Dim Packet As PacketInfo

Dim lngStatus As Long

With Packet
    .PacketLength = Asc(Mid$(strData, 1, 2))
    .PacketID = CByte(Asc(Mid$(strData, 3, 1)))
    .PacketData = Mid$(strData, 5)
End With

Select Case Packet.PacketID
    Case MCP_STARTUP '0x01
        lngStatus = clsFunctions.GetDWORD(Mid$(Packet.PacketData, 1, 4))
        Select Case lngStatus
            Case &H0 'Success
            Case &HC 'No Battle.net connection detected
            Case Else 'Unknown MCP_STARTUP response received
        End Select
        
    Case MCP_CHARLOGON '0x07
        lngStatus = clsFunctions.GetDWORD(Mid$(Packet.PacketData, 1, 4))
        Select Case lngStatus
            Case &H0 'Successfully logged onto realm character
            Case &H46 'Character not found
            Case Else 'Unknown MCP_CHARLOGON response received
        End Select
        
    Case MCP_CHARDELETE '0x0A
        lngStatus = clsFunctions.GetDWORD(Mid$(Packet.PacketData, 1, 4))
        Select Case lngStatus
            Case &H0 'Successfully deleted realm character
            Case Else 'Unknown MCP_CHARCREATE response received
        End Select
        
    Case MCP_MOTD '0x12
        Dim tmpLong As Long
        Dim strHeadline As String
        Dim strMOTD As String
        tmpLong = InStr(1, Packet.PacketData, Chr(0), vbTextCompare)
        strHeadline = Mid$(Packet.PacketData, 1, tmpLong)
        tmpLong = tmpLong + 1
        strMOTD = Mid$(Packet.PacketData, tmpLong, InStr(tmpLong, Packet.PacketData, Chr(0), vbTextCompare))
End Select
End Sub
