VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsBNI"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'---------------------------------------------------------------------------------------
' Module    : clsBNI
' Date      : 6/19/2004
' Author    : LoRd[nK] (thevirushunter@hotmail.com)
' Purpose   : Class for the handling of *.BNI (Battle.net Icon) files
'---------------------------------------------------------------------------------------

'BNI File Structure:
'(DWORD) HeaderLength (always 0x10) - Length of this BNI header
'(WORD) BNI Version (This document only supports 0x01)
'(WORD) Unused (always 0x00)
'(DWORD) NumIcons - Number of icons
'(DWORD) DataStart - Length of the BNI file header, and start position of TGA file

'BNI Header Structure:
'(DWORD) Flag Value
'(DWORD) Icon Width
'(DWORD) Icon Height
'(DWORD[]) Software - Only included if flags is zero, User's software must be this value for this icon to be valid. Because the BNI file uses a DWORD-List to match software, the same software icon could be used for users with the different software. The end of the list is specified by a DWORD with a value of zero, and list has a maximum length of 31 DWORDs.

Option Explicit

Public Function SaveTGAToFile(ByVal strBNIPath As String, ByVal strOutputPath As String) As Boolean
Dim clsFunctions As New clsFunctions

Dim intFile As Integer
Dim strData As String

Dim lngNumIcons As Long
Dim strHeader As String
Dim lngHeaderLng As Long

Dim I As Long

intFile = FreeFile

Open strBNIPath For Binary Access Read As intFile
    strData = String(LOF(intFile), vbNullChar)
    Get #intFile, , strData
Close #intFile

lngNumIcons = clsFunctions.GetDWORD(Mid$(strData, 9, 4))
lngHeaderLng = clsFunctions.GetDWORD(Mid$(strData, 13, 4))
strHeader = Mid$(strData, 17, lngHeaderLng)

Open strOutputPath For Output As #intFile
    Print #intFile, Mid$(strData, lngHeaderLng + 1)
Close #intFile
End Function
