Attribute VB_Name = "modFileTime"
Option Explicit

Public Declare Function FileTimeToSystemTime Lib "kernel32" (lpFileTime As FILETIME, lpSystemTime As SystemTime) As Boolean
Public Declare Function FileTimeToLocalFileTime Lib "kernel32" (lpFileTime As FILETIME, lpLocalFileTime As FILETIME) As Long

Public Type FILETIME
   dwLowDateTime As Long
   dwHighDateTime As Long
End Type

Public Type SystemTime
   wYear As Integer
   wMonth As Integer
   wDayOfWeek As Integer
   wDay As Integer
   wHour As Integer
   wMinute As Integer
   wSecond As Integer
   wMilliseconds As Integer
End Type

Public Function ProcessTimeLogged(T As Long) As String
    Dim Days As Long, Hours As Long, Minutes As Long
    If T = 0 Then
        ProcessTimeLogged = "Unavailable"
    Else
        Days = T / 86400
        T = T Mod 86400
        
        Hours = T / 3600
        T = T Mod 3600
        
        Minutes = T / 60
        T = T Mod 60
        
        ProcessTimeLogged = Days & " days, " & Hours & " hours, " & Minutes & " minutes."
    End If
End Function

Public Function StringToFiletime(T As String) As FILETIME
    Dim Frag() As String, FT As FILETIME
    Frag = Split(T, " ")
    If (Val(Frag(0)) < 2 ^ 31) Then
        FT.dwHighDateTime = Val(Frag(0))
    Else
        FT.dwHighDateTime = Val(Frag(0)) - 2147483648# '2 ^ 32
    End If
    If UBound(Frag) > 0 Then
        If (Val(Frag(0)) < 2 ^ 31) And (Val(Frag(0)) > 0) Then
            FT.dwLowDateTime = Val(Frag(0))
            FT.dwLowDateTime = FT.dwLowDateTime - 2147483648# '2 ^ 32
        Else
            FT.dwLowDateTime = Val(Frag(0))
        End If
    End If
    StringToFiletime = FT
End Function

Public Function ProcessSystemTime(T As SystemTime) As String
    On Error Resume Next
   ProcessSystemTime = WeekdayName(T.wDayOfWeek + 1, True) & ", " & MonthName(T.wMonth, True) & " " & T.wDay & ", " & T.wYear & " "
   Dim ap$
   If T.wHour > 12 Then
       T.wHour = T.wHour - 12
       ap = "PM"
   Else
       ap = "AM"
   End If
   ProcessSystemTime = ProcessSystemTime & " " & T.wHour & ":" & Format(T.wMinute, "00") & _
       " " & ap
End Function



