Attribute VB_Name = "modDatabase"
Option Explicit

Public Type tDatabase
    UserName As String
    AddedTime As String
    AddedBy As String
    Rank As String
End Type

Public Type tRank
    Color As Long
    Rank As String
    Alias As String
    Description As String
    BanMessage As String
    Commands As String
    AltRanks As String
    Friend As Boolean
    Banned As Boolean
    Ignored As Boolean
    CanAddRanks As String
    CanDelRanks As String
    GreetMessage As String
End Type

Public Ranks() As tRank
Public Database() As tDatabase

Public Function Matches(ByVal String1 As String, ByVal String2 As String) As Boolean
    Call PrepareCheck(String2)
    If Len(String1) = 0 Then
        Exit Function
    End If
    If LCase$(String1) Like LCase$(String2) Then Matches = True
End Function

Public Sub PrepareCheck(ByRef tocheck As String)
    tocheck = Replace(tocheck, "[", "")
    tocheck = Replace(tocheck, "]", "")
    tocheck = Replace(tocheck, "", "[[]")
    tocheck = Replace(tocheck, "", "[]]")
    tocheck = Replace(tocheck, "#", "[#]")
    tocheck = Replace(tocheck, "-", "[-]")
End Sub

Public Function ColorNameToLong(ByVal ColorName As String) As Long
    Select Case UCase$(ColorName)
        Case "GRAY": ColorNameToLong = &HA0A0A0
        Case "WHITE": ColorNameToLong = vbWhite
        Case "RED": ColorNameToLong = vbRed
        Case "BLUE": ColorNameToLong = vbBlue
        Case "GREEN": ColorNameToLong = vbGreen
        Case "PURPLE": ColorNameToLong = vbMagenta
        Case "YELLOW": ColorNameToLong = vbYellow
        Case "CYAN": ColorNameToLong = vbCyan
        Case "ORANGE": ColorNameToLong = &H80FF&
        Case Else
        ColorNameToLong = vbWhite
    End Select
End Function

Public Function RankIndex(ByVal RankName As String) As Integer
    If Len(RankName) = 0 Then Exit Function
    
    Dim I As Integer
    For I = 1 To UBound(Ranks())
        If LCase$(Ranks(I).Rank) = LCase$(RankName) Then
            RankIndex = I
            Exit Function
        End If
        If LCase$(Ranks(I).Alias) = LCase$(RankName) Then
            RankIndex = I
            Exit Function
        End If
    Next I
End Function

Public Function GetRank(ByVal UserName As String) As String
    If Len(UserName) = 0 Then Exit Function
    
    Dim I As Integer
    For I = 1 To UBound(Database())
        If LCase$(Database(I).UserName) = LCase$(UserName) Then
            GetRank = Database(I).Rank
            Exit Function
        End If
    Next I
End Function

Public Function CanDoCommand(ByVal RankName As String, ByVal CommandName As String) As Boolean
    Dim R As Integer, AltRanks As String, Splt() As String, AR As Integer
                    Dim CSplt() As String, CI As Integer
    R = RankIndex(RankName)
    If (R = 0) Then Exit Function
    
    AltRanks = Ranks(R).AltRanks
    
    ' Check if Command can be done by Rank
    If InStr(Ranks(R).Commands, ",") > 0 Then
        Dim I As Integer
        Splt() = Split(Ranks(R).Commands, ",")
        
        For I = 0 To UBound(Splt())
            If LCase$(Trim$(Splt(I))) = LCase$(CommandName) Then
                CanDoCommand = True
                Exit Function
            End If
        Next I
    Else
        If LCase$(Trim$(Ranks(R).Commands)) = LCase$(CommandName) Then
            CanDoCommand = True
            Exit Function
        End If
    End If
    
    ' Check if Command can be done by AltRank
    If InStr(AltRanks, ",") > 0 Then
        Splt() = Split(AltRanks, ",")
        
        For I = 0 To UBound(Splt())
            AR = RankIndex(Trim$(Splt(I)))
            
            If (AR > 0) Then
                If InStr(Ranks(AR).Commands, ",") > 0 Then
                    CSplt() = Split(Ranks(AR).Commands, ",")
                    For CI = 0 To UBound(CSplt())
                        If LCase$(Trim$(CSplt(CI))) = LCase$(Trim$(CommandName)) Then
                            CanDoCommand = True
                            Exit Function
                        End If
                    Next CI
                Else
                    If LCase$(Trim$(Ranks(AR).Commands)) = LCase$(Trim$(CommandName)) Then
                        CanDoCommand = True
                        Exit Function
                    End If
                End If
            End If
        Next I
    Else
        If Len(AltRanks) > 0 Then
            AR = RankIndex(AltRanks)
            
            If (AR > 0) Then
                If InStr(Ranks(AR).Commands, ",") > 0 Then
                    CSplt() = Split(Ranks(AR).Commands, ",")
                    For CI = 0 To UBound(CSplt())
                        If LCase$(Trim$(CSplt(CI))) = LCase$(Trim$(CommandName)) Then
                            CanDoCommand = True
                            Exit Function
                        End If
                    Next CI
                Else
                    If LCase$(Trim$(Ranks(AR).Commands)) = LCase$(Trim$(CommandName)) Then
                        CanDoCommand = True
                        Exit Function
                    End If
                End If
            End If
        End If
    End If
End Function

Public Function LoadRanks()
    ReDim Ranks(0)
    Dim mm As Integer
    For mm = frmMain.mnuAddAs.UBound To 1 Step -1
        Unload frmMain.mnuAddAs(mm)
    Next mm
    frmMain.mnuAddAs.Item(0).Caption = vbNullString
    
    On Error GoTo UnableToRead:
    Open App.Path & "\Database Config.ini" For Input As #1
    
        Dim strLine As String, Bracket As Boolean
        
        Do Until EOF(1)
            Line Input #1, strLine
            Dim strNewRank As String, strCommands As String, _
            strAltRanks As String, strDescription As String, strAlias As String, _
            strIgn As String, strBan As String, strColor As String, strGreet As String, _
            strFriend As String, strBanM As String, strCanAdd As String, strCanDel As String
            
            
            If strLine = "{" Then
                Bracket = True
                
            ElseIf strLine = "}" Then
                Bracket = False
                Dim tmpRank As tRank
                If Len(strNewRank) > 0 Then
                    With tmpRank
                        .Rank = strNewRank
                        .Description = strDescription
                        .AltRanks = strAltRanks
                        .Commands = strCommands
                        .GreetMessage = strGreet
                        .BanMessage = strBanM
                        Select Case UCase$(strColor)
                            Case "RED", "ORANGE", "GREEN", "BLUE", "PURPLE", "WHITE", "GRAY", _
                                "CYAN", "YELLOW"
                                .Color = ColorNameToLong(UCase$(strColor))
                            Case Else
                                .Color = vbWhite
                        End Select
                        .Alias = strAlias
                        .CanAddRanks = strCanAdd
                        .CanDelRanks = strCanDel
                        .Banned = (UCase$(strBan) = "Y")
                        .Ignored = (UCase$(strIgn) = "Y")
                        .Friend = (UCase$(strFriend) = "Y")
                        
                        If frmMain.mnuAddAs.Item(0).Caption = vbNullString Then
                            frmMain.mnuAddAs.Item(0).Caption = "Add as " & .Rank
                        Else
                            Load frmMain.mnuAddAs(frmMain.mnuAddAs.Count)
                            frmMain.mnuAddAs.Item(frmMain.mnuAddAs.UBound).Caption = "Add as " & .Rank
                        End If
                    End With
                    ReDim Preserve Ranks(UBound(Ranks) + 1)
                    Ranks(UBound(Ranks)) = tmpRank
                    
                    With tmpRank
                        strNewRank = vbNullString
                        strDescription = vbNullString
                        strAltRanks = vbNullString
                        strCommands = vbNullString
                        strAlias = vbNullString
                        strColor = vbNullString
                        strBan = vbNullString
                        strIgn = vbNullString
                        strGreet = vbNullString
                        strFriend = vbNullString
                        strBanM = vbNullString
                        strCanAdd = vbNullString
                        strCanDel = vbNullString
                    End With
                End If
            End If
        
            If Bracket = True Then
                If strLine Like "Rank=*" Then
                    strNewRank = Mid$(strLine, 6)
                End If
                If strLine Like "Alias=*" Then
                    strAlias = Mid$(strLine, 7)
                End If
                If strLine Like "Commands=*" Then
                    strCommands = Mid$(strLine, 10)
                End If
                If strLine Like "Description=*" Then
                    strDescription = Mid$(strLine, 13)
                End If
                If strLine Like "AdditionalRanks=*" Then
                    strAltRanks = Mid$(strLine, 17)
                End If
                If strLine Like "Banned=*" Then
                    strBan = Mid$(strLine, 8, 1)
                End If
                If strLine Like "Ignored=*" Then
                    strIgn = Mid$(strLine, 9, 1)
                End If
                If strLine Like "Friend=*" Then
                    strFriend = Mid$(strLine, 8, 1)
                End If
                If strLine Like "CanAddRanks=*" Then
                    strCanAdd = Mid$(strLine, 13)
                End If
                If strLine Like "CanDelRanks=*" Then
                    strCanDel = Mid$(strLine, 13)
                End If
                If strLine Like "Color=*" Then
                    strColor = Mid$(strLine, 7)
                End If
                If strLine Like "BanMessage=*" Then
                    strBanM = Mid$(strLine, 12)
                End If
                If strLine Like "GreetMessage=*" Then
                    strGreet = Mid$(strLine, 14)
                End If
            End If
        Loop
    
    Exit Function
UnableToRead:
    Close #1
    
    MsgBox "The Database Config.ini file was missing or unreadable, please obtain another copy of this file from www.miragechat.net!", vbCritical, "Database Config.ini Missing!"
    End
End Function

Public Sub ClearDatabase()
    ReDim Database(0)
End Sub

Public Function FindDatabaseUser(ByVal UserName As String) As Integer
    Dim I As Integer
    
    ' Find wildcard matches
    For I = 1 To UBound(Database())
        If InStr(Database(I).UserName, "*") > 1 Then
            If Matches(UserName, Database(I).UserName) = True Then
                FindDatabaseUser = I
                Exit For
            End If
        Else
            If Matches(Database(I).UserName, UserName) = True Then
                FindDatabaseUser = I
                Exit For
            End If
        End If
    Next I
    
    ' Find exact match
    For I = 1 To UBound(Database())
        If LCase$(Database(I).UserName) = LCase$(UserName) Then
            FindDatabaseUser = I
            Exit Function
        End If
    Next I
End Function

Public Function AddDatabaseUser(p As tDatabase) As Boolean
    Dim I As Integer
    For I = 1 To UBound(Database())
        If LCase$(Database(I).UserName) = LCase$(p.UserName) Then
            Exit Function
        End If
    Next I
    
    Dim B As Integer
    B = UBound(Database()) + 1
    ReDim Preserve Database(B)
    
    If Len(p.AddedBy) = 0 Then p.AddedBy = "<Bot Console>"
    If Len(p.AddedTime) = 0 Then p.AddedTime = Date & ", " & Time
    Database(B) = p
    Debug.Print "[ Database Added: " & p.UserName & " with " & p.Rank & " ]"
    
    Call Registry.WriteString(REG_PROFILE & Config.Profile & "\Database\" & p.UserName, "Rank", p.Rank)
    Call Registry.WriteString(REG_PROFILE & Config.Profile & "\Database\" & p.UserName, "AddedBy", p.AddedBy)
    Call Registry.WriteString(REG_PROFILE & Config.Profile & "\Database\" & p.UserName, "AddedTime", p.AddedTime)
    
    frmMain.ReColorChannelList
    
    AddDatabaseUser = True
End Function

Public Function RemoveDatabaseUser(UserName As String) As Boolean
    Call Registry.DeleteKey(Mid$(REG_PROFILE, 6) & Config.Profile & "\Database\" & UserName)
    Dim I As Integer, R As Integer
    For I = 1 To UBound(Database())
        If LCase$(Database(I).UserName) = LCase$(UserName) Then
            Debug.Print "[ Database Removed: " & UserName & " ]"
            For R = I To UBound(Database()) - 1
                Database(R) = Database(R + 1)
            Next R
            RemoveDatabaseUser = True
            ReDim Preserve Database(UBound(Database) - 1)
            frmMain.ReColorChannelList
            Exit Function
        End If
    Next I
End Function

