Attribute VB_Name = "modClanList"
Public Type tClanMembers
    UserName As String
    Rank As Byte
    Status As Byte
End Type

Public MyClanTag As String
Public MyClanname As String
Public MyClanRank As Byte
Public MyClanMOTD As String
Public ClanMembers() As tClanMembers

Public Const CLAN_SUCCESS& = &H0
Public Const CLAN_INUSE& = &H1
Public Const CLAN_TOOSOON& = &H2
Public Const CLAN_DECLINE& = &H4
Public Const CLAN_UNAVAILABLE& = &H5
Public Const CLAN_ACCEPT& = &H6
Public Const CLAN_NOTAUTHORIZED& = &H7
Public Const CLAN_NOTALLOWED& = &H8
Public Const CLAN_FULL& = &H9
Public Const CLAN_BADTAG& = &HA
Public Const CLAN_BADNAME& = &HB

Public Function RemoveNull(ByVal str As String) As String
    RemoveNull = Replace$(str, vbNullChar, vbNullString)
End Function

Public Function RankIDToString(ByVal ID As Byte) As String
    Select Case ID
        Case 0: RankIDToString = "New Peon"
        Case 1: RankIDToString = "Peon"
        Case 2: RankIDToString = "Grunt"
        Case 3: RankIDToString = "Shaman"
        Case 4: RankIDToString = "Chieftain"
    End Select
End Function

Public Sub ClearClanMembers()
    ReDim ClanMembers(0)
End Sub

Public Sub AddClanMember(p As tClanMembers)
    Dim B As Integer
    B = UBound(ClanMembers()) + 1
    ReDim Preserve ClanMembers(B)
    ClanMembers(B).UserName = p.UserName
    ClanMembers(B).Rank = p.Rank
    ClanMembers(B).Status = p.Status
    
    With frmMain.lvClan.ListItems.Add(, , p.UserName, , IIf(p.Rank = 0, 1, p.Rank))
        If p.Status = &H0 Then
            .ForeColor = &H404040
        Else
            .ForeColor = vbCyan
        End If
        If p.Rank = 4 Then
            .ToolTipText = p.UserName & " is the " & RankIDToString(p.Rank) & "."
        Else
            .ToolTipText = p.UserName & " is a " & RankIDToString(p.Rank) & "."
        End If
    End With
    
    Debug.Print "[ ClanList Added: " & p.UserName & " ]"
End Sub

Public Sub RemoveClanMember(UserName As String)
    Dim I As Integer, R As Integer
    For I = frmMain.lvClan.ListItems.Count To 1 Step -1
        If LCase$(frmMain.lvClan.ListItems(I)) = LCase$(UserName) Then
            frmMain.lvClan.ListItems.Remove I
        End If
    Next I
    For I = 1 To UBound(ClanMembers())
        If LCase$(ClanMembers(I).UserName) = LCase$(UserName) Then
            Debug.Print "[ ClanList Removed: " & ClanMembers(I).UserName & " ]"
            For R = I To UBound(ClanMembers()) - 1
                ClanMembers(R) = ClanMembers(R + 1)
            Next R
            ReDim Preserve ClanMembers(0 To UBound(ClanMembers) - 1)
            Exit Sub
        End If
    Next I
End Sub

