Attribute VB_Name = "modBannedList"
Option Explicit

Public Type tBanned
    UserName As String
    BannedBy As String
    BannedTime As String
    Reason As String
End Type

Public BanCount As Long         ' Total BanCount
Public MyBanCount As Long       ' My BanCount
Public Banned() As tBanned

Public Sub ClearBannedUsers()
    ReDim Banned(0)
End Sub

Public Function CheckBanlistCapacity()
    ' Check each individual moderators banlist capacity
    
    If Settings.BanRotation = True Then
    
        Dim Capacity As Long
        Capacity = Settings.BanRotationCapacity
        
        If (Capacity > 0) Then
            ' Count how many bans have been done by this user dynamically
            Dim Moderators() As String, ModeratorCount() As Long
            ReDim Moderators(0), ModeratorCount(0)
            
            If UBound(Banned()) > 0 Then
                Dim I As Integer
                For I = 1 To UBound(Banned())
                    If UBound(Moderators()) > 0 Then
                        Dim m As Integer, mFound As Boolean
                        For m = 1 To UBound(Moderators())
                            If LCase$(Banned(I).BannedBy) = LCase$(Moderators(m)) Then
                                ' Increment ModeratorCount Amount
                                ModeratorCount(m) = ModeratorCount(m) + 1
                                mFound = True
                                Exit For
                            End If
                        Next m
                        If mFound = False Then
                            ' Add Moderator
                            ReDim Preserve Moderators(UBound(Moderators) + 1), _
                                ModeratorCount(UBound(ModeratorCount) + 1)
                            Moderators(UBound(Moderators)) = Banned(I).BannedBy
                            ModeratorCount(UBound(ModeratorCount)) = 1
                        End If
                    Else
                        ' Add Moderator
                        ReDim Preserve Moderators(UBound(Moderators) + 1), _
                            ModeratorCount(UBound(ModeratorCount) + 1)
                        Moderators(UBound(Moderators)) = Banned(I).BannedBy
                        ModeratorCount(UBound(ModeratorCount)) = 1
                    End If
                Next I
                
                If UBound(Moderators()) > 0 Then
                    Dim fm As Integer
                    For fm = 1 To UBound(Moderators())
                        If ModeratorCount(fm) > Capacity Then
                            ' Find first Ban by Moderator in Banned() _
                              remove this entry and resize Banned()
                            
                            Dim fb As Integer, fr As Integer
                            For fb = 1 To UBound(Banned())
                                If LCase$(Banned(fb).BannedBy) = LCase$(Moderators(fm)) Then
                                    ' Remove first entry
                                    For fr = fb To UBound(Banned()) - 1
                                        Banned(fr) = Banned(fr + 1)
                                    Next fr
                                    ReDim Preserve Banned(0 To UBound(Banned) - 1)
                                    GoTo Done:
                                End If
                            Next fb
                        End If
                    Next fm
                End If
            End If
        End If
    End If
Done:
End Function

Public Function ClearIndividualBanlist(ByVal Moderator As String)
    ' Clear all bans done by "Moderator"

    If UBound(Banned()) > 0 Then
        Dim I As Integer, mFound As Boolean
        For I = UBound(Banned()) To 1 Step -1
            If LCase$(Moderator) = LCase$(Banned(I).BannedBy) Then
                ' Remove this item
                mFound = True
                Dim R As Integer
                For R = I To UBound(Banned()) - 1
                    Banned(R) = Banned(R + 1)
                Next R
                ReDim Preserve Banned(0 To UBound(Banned()) - 1)
            End If
        Next I
        If mFound = True Then
            AddChat &HC0C0C0, "Removed users " & Moderator & " has banned from the banlist."
        Else
            AddChat vbRed, Moderator & " has not banned any users."
        End If
    End If
End Function

Public Function FindBannedUser(UserName As String) As Integer
    ' Get Database Index of "Username"
    
    Dim I As Integer
    For I = 1 To UBound(Banned())
        If Banned(I).UserName = UserName Then
            FindBannedUser = I
            Exit For
        End If
    Next I
End Function

Public Sub QueueBannedUser(p As tBanned)
    ' Add New User to "Banned()"
    
    Dim B As Integer
    If FindBannedUser(p.UserName) > 0 Then
        B = FindBannedUser(p.UserName)
        Debug.Print "[ BanList Refreshed: " & p.UserName & " ]"
    Else
        B = UBound(Banned()) + 1
        ReDim Preserve Banned(B)
        Debug.Print "[ BanList Added: " & p.UserName & " ]"
    End If
    
    Banned(B).UserName = p.UserName
    Banned(B).BannedBy = p.BannedBy
    Banned(B).BannedTime = p.BannedTime
    Banned(B).Reason = p.Reason
End Sub

Public Sub RemoveBannedUser(UserName As String)
    ' Remove User from "Banned()"

    Dim I As Integer, R As Integer
    For I = 1 To UBound(Banned())
        If LCase$(Banned(I).UserName) = LCase$(UserName) Then
            Debug.Print "[ BanList Removed: " & Banned(I).UserName & " ]"
            For R = I To UBound(Banned()) - 1
                Banned(R) = Banned(R + 1)
            Next R
            ReDim Preserve Banned(0 To UBound(Banned) - 1)
            Exit Sub
        End If
    Next I
End Sub

