Attribute VB_Name = "modProxies"
Option Explicit

Public Proxies() As PROXYTYPE
Public Type PROXYTYPE
    Proxy As String
    Port As Long
    Version As SOCKSVER
End Type
Public Enum SOCKSVER
    SOCKS4& = 1
    SOCKS5& = 2
End Enum

Public Sub AssignServer(I As Integer)
    'Assign socket detail
    frmMain.wsBNET(I).RemoteHost = Config.Server
    frmMain.wsBNET(I).RemotePort = 6112
End Sub

Public Sub AssignProxy(I As Integer)
    'Get next proxy
    Dim P As PROXYTYPE
    NextProxy P
    'Assign socket detail
    frmMain.wsBNET(I).RemoteHost = P.Proxy
    frmMain.wsBNET(I).RemotePort = P.Port
    'Assign node detail
    Node(I).SocksVersion = P.Version
End Sub

Public Sub NextProxy(ByRef P As PROXYTYPE)
    Static I As Long
    If I > UBound(Proxies) Then I = 0
    Let P = Proxies(I)
    I = I + 1
End Sub

Public Function LoadProxyFile(ByRef file As String, ByRef Arr() As String, ByRef Arr2() As Long) As Boolean
On Error GoTo hErr:
    Dim fs As New FileSystemObject, ts As TextStream
    ReDim Arr(0), Arr2(0)
1   Set ts = fs.OpenTextFile(file, , True)
    'Seek until the end of the file...
2   Do Until ts.AtEndOfStream
        Dim buf As String
        'Remove padding
3       buf = Trim$(ts.ReadLine)
        'Remove tabs
4       buf = Replace$(buf, vbTab, vbNullString)
        'Remove spaces
5       buf = Replace$(buf, " ", vbNullString)
        'Check length
6       If (Len(buf) > 0) And (InStrB(buf, ":") > 0) Then
            'Check proxy for genuinity
            Dim g() As String
7           g = Split(buf, ":")
            'Check port
8           If (CStr(Val(g(1))) = g(1)) Then
                'Check octets
9               If (InStrB(g(0), ".") > 0) Then
                    'Check if correct amount of octets
                    Dim o() As String
10                  o = Split(g(0), ".")
11                  If (UBound(o) = 3) Then
                        'Check octet values
12                      If (Val(o(0)) > 0 And Val(o(0)) < 256) And _
                            (Val(o(1)) > -1 And Val(o(0)) < 256) And _
                            (Val(o(2)) > -1 And Val(o(2)) < 256) And _
                            (Val(o(3)) > -1 And Val(o(3)) < 256) Then
                            'Finally add proxy
13                          If LenB(Arr(0)) = 0 Then
14                              Arr(0) = Val(o(0)) & "." & Val(o(1)) & "." & Val(o(2)) & "." & Val(o(3))
15                              Arr2(0) = Val(g(1))
                            Else
16                              ReDim Preserve Arr(UBound(Arr) + 1), Arr2(UBound(Arr2) + 1)
17                              Arr(UBound(Arr)) = Val(o(0)) & "." & Val(o(1)) & "." & Val(o(2)) & "." & Val(o(3))
18                              Arr2(UBound(Arr2)) = Val(g(1))
                            End If
                        End If
                    End If
                End If
            End If
        End If
    Loop
19  LoadProxyFile = (UBound(Arr) > 0 Or Len(Arr(0)) > 0)
    
    Exit Function
hErr:
    MsgBox "Error Loading Proxy File (Line: " & Erl & ", #: " & Err.Number & ")" & vbNewLine & _
        file, vbExclamation
End Function

Public Function ImportProxies() As Boolean
    Dim fs As New FileSystemObject
    'Create 'Proxys' folder
    If (fs.FolderExists(App.Path & "\Proxies\") = False) Then fs.CreateFolder App.Path & "\Proxies\"
    ReDim Proxies(0)
    Dim Arr() As String, Arr2() As Long, I As Long, s As Long, P As Long
    
    Debug.Print "<Proxies>"
    'Import SOCKS4 Proxys
    If LoadProxyFile(App.Path & "\Proxies\SOCKS4.txt", Arr, Arr2) Then
        'Determine 's'
        If LenB(Proxies(UBound(Proxies)).Proxy) > 0 Then s = UBound(Proxies) + 1 Else s = UBound(Proxies)
        'Resize array
        ReDim Preserve Proxies(s + UBound(Arr))
        'Loop through array
        For I = 0 To UBound(Arr)
            'Determine next index
            If (LenB(Proxies(s + I).Proxy) = 0) Then P = s + I Else P = s + I + 1
            'Personalize Proxy
            With Proxies(P)
                .Proxy = Arr(I)
                .Port = Arr2(I)
                .Version = SOCKS4
            End With
        Next I
    End If
    Debug.Print "   SOCKS4: " & UBound(Arr)
    
    'Import SOCKS5 Proxys
    If LoadProxyFile(App.Path & "\Proxies\SOCKS5.txt", Arr, Arr2) Then
        'Determine 's'
        If LenB(Proxies(UBound(Proxies)).Proxy) > 0 Then s = UBound(Proxies) + 1 Else s = UBound(Proxies)
        'Resize array
        ReDim Preserve Proxies(s + UBound(Arr))
        'Loop through array
        For I = 0 To UBound(Arr)
            'Determine next index
            If (LenB(Proxies(s + I).Proxy) = 0) Then P = s + I Else P = s + I + 1
            'Personalize Proxy
            With Proxies(P)
                .Proxy = Arr(I)
                .Port = Arr2(I)
                .Version = SOCKS5
            End With
        Next I
    End If
    Debug.Print "   SOCKS5: " & UBound(Arr)
    
    ImportProxies = (UBound(Proxies) > 0 Or Len(Proxies(0).Proxy) > 0)
End Function

