Attribute VB_Name = "modGlobal"
Option Explicit

Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
Private Declare Function GetPrivateProfileSection Lib "kernel32" Alias "GetPrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileSection Lib "kernel32" Alias "WritePrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpString As String, ByVal lpFileName As String) As Long

Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)
Public Declare Function GetTickCount Lib "kernel32.dll" () As Long

Public Config As CONFIGTYPE
Public Type CONFIGTYPE
    Server As String
    Account As String
    Password As String
    AccountW3 As String
    PasswordW3 As String
    Channel As String
    IPConnections As Long
    
    DelayW As Long
    DelayA As Long
    DelayP As Long
    DelayI As Long
End Type

Public Verbyte As VERSIONBYTE
Public Type VERSIONBYTE
    SC As Long
    W2 As Long
    D2 As Long
    W3 As Long
End Type

Private fs As New FileSystemObject
Public INIFile As String

Sub Main()
    If Not ImportConfig Then
        MsgBox "Configuration was not loaded correctly, please review errors and fill in the appropriate fields.", vbCritical, "Configuration Problems!"
        Exit Sub
    End If
    If Not ImportCdkeyFile Then
        MsgBox "No cdkeys were loaded, please enter cdkeys in corresponding files found in the 'Cdkeys' directory.", vbCritical, "No Cdkeys!"
        Exit Sub
    End If
    If Not ImportProxies Then
        MsgBox "No proxies were loaded, please enter proxies in corresponding files found in the 'Proxies' directory.", vbCritical, "No Proxies!"
        Exit Sub
    End If
    
    If Not fs.FileExists(App.Path & "\Binaries\Image\analyzing.gif") Or _
        Not fs.FileExists(App.Path & "\Binaries\Image\complete.gif") Or _
        Not fs.FileExists(App.Path & "\Binaries\Image\close.gif") Or _
        Not fs.FileExists(App.Path & "\Binaries\Image\progress.gif") Then
        MsgBox "Error occurred while loading Opal Interface!" & vbNewLine & _
            "This can be resolved by downloading the package from www.BnetDev.net again!", vbCritical
        Exit Sub
    End If
    
    CreateNodes
    Load frmMain
    frmMain.Show
    frmMain.tmrStatus.Enabled = True
    frmMain.tmrUpdate.Enabled = True
End Sub

Public Function ImportConfig() As Boolean
    INIFile = App.Path & "\Config.ini"
    Config.Server = Import("Connection", "Server")
    Config.Account = Import("Connection", "Account")
    Config.Password = Import("Connection", "Password")
    Config.AccountW3 = Import("Connection", "AccountW3")
    Config.PasswordW3 = Import("Connection", "PasswordW3")
    Config.Channel = Import("Connection", "Channel")
    Config.IPConnections = Val(Import("Connection", "IPConnections"))
    Config.DelayW = Val(Import("Delays", "Node_Working"))
    Config.DelayA = Val(Import("Delays", "Node_Analyzed"))
    Config.DelayP = Val(Import("Delays", "Node_Pending"))
    Config.DelayI = Val(Import("Delays", "Node_Inactive"))
    
    Verbyte.SC = Val("&H0" & Import("Verbytes", "SC"))
    Verbyte.W2 = Val("&H0" & Import("Verbytes", "W2"))
    Verbyte.D2 = Val("&H0" & Import("Verbytes", "D2"))
    Verbyte.W3 = Val("&H0" & Import("Verbytes", "W3"))
    
    Debug.Print "<Configuration>"
    Debug.Print "   Verbyte.SC: " & Verbyte.SC
    Debug.Print "   Verbyte.W2: " & Verbyte.W2
    Debug.Print "   Verbyte.D2: " & Verbyte.D2
    Debug.Print "   Verbyte.W3: " & Verbyte.W3
    
    Dim Success As Boolean
    Success = True
    
    If Val(Config.DelayW) = 0 Then Config.DelayW = 8000
    If Val(Config.DelayA) = 0 Then Config.DelayA = 15000
    If Val(Config.DelayP) = 0 Then Config.DelayP = 60000
    If Val(Config.DelayI) = 0 Then Config.DelayI = 10000
    
    If LenB(Config.Channel) = 0 Then Config.Channel = "Opal"
    If LenB(Config.Server) = 0 Then MsgBox "Cannot continue without specifying a server. Try: uswest.battle.net", vbExclamation, "Configuration Error": Success = False
    If LenB(Config.Account) = 0 Then MsgBox "Cannot continue without specifying an existing account.", vbExclamation, "Configuration Error": Success = False
    If LenB(Config.Password) = 0 Then MsgBox "Cannot continue without specifying a password to the account.", vbExclamation, "Configuration Error": Success = False
    If LenB(Config.AccountW3) = 0 Then MsgBox "Cannot continue without specifying an existing account (W3).", vbExclamation, "Configuration Error": Success = False
    If LenB(Config.PasswordW3) = 0 Then MsgBox "Cannot continue without specifying a password to the account (W3).", vbExclamation, "Configuration Error": Success = False
    
    If Verbyte.SC = 0 Then MsgBox "SC verbyte cannot calculate to hexadecimal zero. Try: D1", vbExclamation, "Configuration Problem": Success = False
    If Verbyte.W2 = 0 Then MsgBox "W2 verbyte cannot calculate to hexadecimal zero. Try: 4F", vbExclamation, "Configuration Problem": Success = False
    If Verbyte.D2 = 0 Then MsgBox "D2 verbyte cannot calculate to hexadecimal zero. Try: 0B", vbExclamation, "Configuration Problem": Success = False
    If Verbyte.W3 = 0 Then MsgBox "W3 verbyte cannot calculate to hexadecimal zero. Try: 15", vbExclamation, "Configuration Problem": Success = False
    
    ImportConfig = Success
End Function

Public Function Import(ByRef Section As String, ByRef key As String) As String
    On Error GoTo hErr
    If (Not fs.FileExists(INIFile)) Then fs.CreateTextFile INIFile: Exit Function
    Dim Buffer As String * 256
    GetPrivateProfileString Section, key, vbNullString, Buffer, 256, INIFile
    If InStrB(Buffer, vbNullChar) > 0 Then Buffer = Split(Buffer, vbNullChar)(0)
    Import = Trim$(Buffer)
    Exit Function
hErr:
End Function

Public Sub Export(ByRef Section As String, ByRef key As String, ByRef Value As String)
    On Error GoTo hErr
    If (Not fs.FileExists(INIFile)) Then fs.CreateTextFile INIFile: Exit Sub
    WritePrivateProfileString Section, key, Value, INIFile
    Exit Sub
hErr:
End Sub
