Attribute VB_Name = "modConnection"
Option Explicit

Public Sub Connect(i As Integer)
    If LenB(Node(i).Cdkey) = 0 Then
        Status i, Dead
        Exit Sub
    End If
    frmMain.wsBNET(i).Close
    frmMain.wsBNET(i).Connect
    Status i, Pending
End Sub

Public Sub Disconnect(i As Integer)
    frmMain.wsBNET(i).Close
    Status i, Inactive
End Sub

Public Sub DataArrival(i As Integer, Data As String)
On Error GoTo hErr:
    If (LenB(Data) = 0) Then Exit Sub
    'Check if proxy data...
    If (Node(i).State = Active) Then
        If (Len(Data) = 8) And (Node(i).SocksVersion = SOCKS4) Then
            If (Asc(Left$(Data, 1)) = 0) Or (Asc(Left$(Data, 1)) = 4) Then
                Select Case Asc(Mid$(Data, 2, 1))
                Case &H5A
                    Debug.Print "Request granted"
                    Status i, Granted
                    Send0x50 i: Exit Sub
                Case &H5B, &H5C, &H5D
                    Disconnect i: Exit Sub
                End Select
            End If
        End If
    End If
    
    'Handle normal data
    With Node(i)
        .Buffer = .Buffer & Data
        While (Len(.Buffer) > 3)
            Dim PacketLen As Integer, PacketData As String
            PacketLen = ExtractInt16(Mid$(.Buffer, 3, 2))
            If (Len(.Buffer) < PacketLen) Or (PacketLen < 1) Then Exit Sub
            PacketData = Left$(.Buffer, PacketLen)
            If Asc(Left$(PacketData, 1)) = &HFF Then
                Dim PacketID As Byte
                PacketID = Asc(Mid$(PacketData, 2, 1))
                PacketHandler i, PacketID, Mid$(PacketData, 5)
            End If
            .Buffer = Mid$(.Buffer, PacketLen + 1)
        Wend
    End With
    Exit Sub
hErr:
    Debug.Print "DataArrival2 -> " & Err.Description
End Sub

Public Sub PacketHandler(i As Integer, PID As Byte, Data As String)
On Error GoTo hErr:
    Debug.Print "<< " & Hex(PID)
    Select Case PID
    Case &H0
        'SendNull Index
    Case &H25
        'SendPing Index, ExtractInt32(Left$(Data, 4))
    Case &H50
        Receive0x50 Index, Data
    Case &H51
        'ReceiveAuthCheck Index, Data
    Case &H53
        'ReceiveAuthAccountLogon Index, Data
    Case &H54
        'ReceiveAuthAccountLogonProof Index, Data
    Case &H3A
        'ReceiveLogin Index, Data
    'Case &H3D
        'ReceiveCreate Index, Data
    Case &H46
        'ReceiveNews
    Case &HA
        'ReceiveEnterChat Index, Data
    End Select
    Exit Sub
hErr:
    Debug.Print "PacketHandler -> " & Err.Description
End Sub

Public Sub SendPacket(Index As Integer, PID As Byte, Data As String)
On Error GoTo hErr:
    If (frmMain.wsBNET(Index).State <> sckConnected) Then Exit Sub
    frmMain.wsBNET(Index).SendData Chr$(&HFF) & Chr$(PID) & CreateInt16(Len(Data) + 4) & Data
    Data = vbNullString
    Exit Sub
hErr:
Data = vbNullString
Debug.Print "SendPacket[" & Hex(PID) & "] -> " & Err.Description
End Sub

Public Sub Send0x50(Index As Integer)
    frmMain.wsBNET(Index).SendData Chr$(1)
    Dim pb As New clsPacketBuffer
    With pb
        .InsertInt32 &H0
        Select Case Node(Index).Client
        Case CDKEYCLIENT.SC
            .InsertFixedString "68XIRATS"
            .InsertInt32 Val("&H0" & Verbyte.SC)
        Case CDKEYCLIENT.W2
            .InsertFixedString "68XINB2W"
            .InsertInt32 Val("&H0" & Verbyte.W2)
        Case CDKEYCLIENT.D2
            .InsertFixedString "68XIVD2D"
            .InsertInt32 Val("&H0" & Verbyte.D2)
        Case CDKEYCLIENT.W3
            .InsertFixedString "68XI3RAW"
            .InsertInt32 Val("&H0" & Verbyte.W3)
        Case Else
            Disconnect Index
            Exit Sub
        End Select
        .InsertInt32 &H0
        .InsertInt32 &H0
        .InsertInt32 &H0
        .InsertInt32 &H0
        .InsertInt32 &H0
        .InsertCString "AUS"
        .InsertCString "Australia"
        SendPacket Index, &H50, .Buffer
    End With
End Sub

Public Sub Receive0x50(Index As Integer, Data As String)
    Dim pd As New clsPacketDebuffer
    pd.SetDebuffer Data
    
    Dim ls As Long, vr As Long, cs As Long, mt As String, mn As String, vs As String, hf() As String, dg As String, ud As Long
    ls = pd.ReadInt32()                         'Login style
    If ls = 2 Then
        Node(Index).SRP = True                  'NLS
    ElseIf ls = 0 Then
        Node(Index).SRP = False                 'OLS
    Else
        Disconnect Index                        'Unsupported style
        Exit Sub
    End If
    Node(Index).ClientToken = GetTickCount()    'Client token
    Node(Index).ServerToken = pd.ReadInt32()    'Server token
    ud = pd.ReadInt32()                         'UDP value
    mt = pd.ReadFixedString(8)                  'MPQ filetime
    mn = pd.ReadCString()                       'MPQ name
    vs = pd.ReadCString()                       'Value string
    dg = String$(32, vbNullChar)                'Digest
    
    
    Select Case Node(Index).Client
    Case CDKEYCLIENT.SC
        ReDim hf(5)
        hf(0) = App.Path & "\Binaries\STAR\StarCraft.exe"
        hf(1) = App.Path & "\Binaries\STAR\Storm.dll"
        hf(2) = App.Path & "\Binaries\STAR\Battle.snp"
        hf(3) = App.Path & "\Binaries\Lockdown\" & Replace$(mn, ".mpq", ".dll")
        hf(4) = App.Path & "\Binaries\Lockdown\lockdown-IX86-01.dll"
        hf(5) = App.Path & "\Binaries\Video\STAR.bin"
        If (CheckRevisionLD(hf(0), hf(1), hf(2), vs, vr, cs, dg, hf(3), hf(4), hf(5)) <> 1) Then
            Debug.Print "CheckRevision failed for SC"
            Disconnect Index
            Exit Sub
        End If
    Case CDKEYCLIENT.W2
        ReDim hf(5)
        hf(0) = App.Path & "\Binaries\W2BN\Warcraft II BNE.exe"
        hf(1) = App.Path & "\Binaries\W2BN\Storm.dll"
        hf(2) = App.Path & "\Binaries\W2BN\Battle.snp"
        hf(3) = App.Path & "\Binaries\Lockdown\" & Replace$(mn, ".mpq", ".dll")
        hf(4) = App.Path & "\Binaries\Lockdown\lockdown-IX86-01.dll"
        hf(5) = App.Path & "\Binaries\Video\W2BN.bin"
        If (CheckRevisionLD(hf(0), hf(1), hf(2), vs, vr, cs, dg, hf(3), hf(4), hf(5)) <> 1) Then
            Debug.Print "CheckRevision failed for W2"
            Disconnect Index
            Exit Sub
        End If
    Case CDKEYCLIENT.D2
        ReDim hf(2)
        hf(0) = App.Path & "\Binaries\D2DV\Game.exe"
        hf(1) = App.Path & "\Binaries\D2DV\Bnclient.dll"
        hf(2) = App.Path & "\Binaries\D2DV\D2Client.dll"
        If (CheckRevisionA(vs, hf, extractMPQNumber(mn), cs) = False) Then
            Debug.Print "CheckRevision failed for D2"
            Disconnect Index
            Exit Sub
        End If
        vr = getExeInfo(hf(0), dg)
        If (vr = 0) Then
            Debug.Print "Invalid version for D2"
            Disconnect Index
            Exit Sub
        End If
    Case CDKEYCLIENT.W3
        ReDim hf(2)
        hf(0) = App.Path & "\Binaries\WAR3\Game.exe"
        hf(1) = App.Path & "\Binaries\WAR3\Bnclient.dll"
        hf(2) = App.Path & "\Binaries\WAR3\D2Client.dll"
        If (CheckRevisionA(vs, hf, extractMPQNumber(mn), cs) = False) Then
            Debug.Print "CheckRevision failed for W3"
            Disconnect Index
            Exit Sub
        End If
        vr = getExeInfo(hf(0), dg)
        If (vr = 0) Then
            Debug.Print "Invalid version for W3"
            Disconnect Index
            Exit Sub
        End If
    End Select
    If (InStrB(dg, vbNullChar) > 0) Then dg = Left$(dg, InStr(dg, vbNullChar) - 1)

    
    Dim pb As New clsPacketBuffer
    pb.InsertInt32 Node(Index).ClientToken
    pb.InsertInt32 vr
    pb.InsertInt32 cs
    pb.InsertInt32 1
    pb.InsertInt32 0
    
    Dim hs As String, pr As Long, pu As Long
    If HashCdkey(Index, hs, pr, pu) Then
        pb.InsertInt32 Len(Node(Index).Cdkey)
        pb.InsertInt32 pr
        pb.InsertInt32 pu
        pb.InsertInt32 0
        pb.InsertFixedString hs
    Else
        Disconnect Index
        Exit Sub
    End If
    
    pb.InsertCString dg
    pb.InsertCString "Opal"
    SendPacket Index, &H51, pb.Buffer
End Sub

Private Function HashCdkey(ByVal Index As Integer, ByRef h As String, ByRef productVal As Long, ByRef publicVal As Long) As Boolean
    On Error GoTo hErr
    Dim kd As Long, hashLength As Long, Hash As String
    kd = kd_create(Node(Index).Cdkey, Len(Node(Index).Cdkey))
    If (kd = -1) Then
        Output vbRed, "Cannot initialize cdkey decoder!"
        Disconnect Index
        Exit Function
    End If
    hashLength = kd_calculateHash(kd, Node(Index).ClientToken, Node(Index).ServerToken)
    If (hashLength = 0) Then
        Output vbRed, "Cannot calculate cdkey hash length!"
        Disconnect Index
        Exit Function
    End If
    If kd_isValid(kd) = 0 Then
        Output vbRed, "Cdkey did not pass installer check!"
        Disconnect Index
        Exit Function
    End If
    Hash = Space$(hashLength)
    kd_getHash kd, Hash
    h = Hash
    productVal = kd_product(kd)
    publicVal = kd_val1(kd)
    kd_free kd
    HashCdkey = True
    Exit Function
hErr:
    Debug.Print "HashCdkey -> " & Err.Description
End Function


