Attribute VB_Name = "modConnection"
Option Explicit

Public Sub SendPacket(Index As Integer, Packet As Byte, ByRef Data As String)
On Error GoTo hErr:
    If (frmMain.wsBNET(Index).State <> sckConnected) Then Exit Sub
    frmMain.wsBNET(Index).SendData Chr$(&HFF) & Chr$(Packet) & CreateInt16(Len(Data) + 4) & Data
    Data = vbNullString
    Exit Sub
hErr:
Data = vbNullString
LogError "Connection", "SendPacket[" & Hex(Packet) & "]"
End Sub

Public Sub Connect(I As Integer)
    If LenB(Node(I).Cdkey) = 0 Then
        Status I, Dead
        Exit Sub
    End If
    frmMain.wsBNET(I).Close
    frmMain.wsBNET(I).Connect
    Status I, Pending
End Sub

Public Sub Disconnect(I As Integer)
    frmMain.wsBNET(I).Close
    Status I, Inactive
End Sub

Public Sub NewData(Index As Integer, Data As String)
On Error GoTo hErr:
    If (LenB(Data) = 0) Then Exit Sub
    'Check if proxy data...
    If (Len(Data) = 8) And (Node(Index).State = Active) Then
        If (Asc(Left$(Data, 1)) = 0) Or (Asc(Left$(Data, 1)) = 4) Then
            Select Case Asc(Mid$(Data, 2, 1))
            Case &H5A
                Node(Index).State = Granted
                SendAuthInfo Index: Exit Sub
            Case &H5B, &H5C, &H5D
                Disconnect Index: Exit Sub
            End Select
        End If
    End If
    
    If (Node(Index).State = Active Or Node(Index).State = Request) And Asc(Data) = &H5 Then
        Select Case Asc(Mid$(Data, 2, 1))
        Case &H0
            If (Node(Index).State = Active) Then
                Status Index, Request
                Dim IP As String
                IP = GetIPFromHostName(Config.Server)
                frmMain.wsBNET(Index).SendData Chr$(&H5) & Chr$(&H1) & _
                    vbNullChar & Chr$(&H1) & CreateInt32(inet_addr(IP)) & _
                    CreateInt16(htons(6112))
            ElseIf (Node(Index).State = Request) Then
                Node(Index).State = Granted
                SendAuthInfo Index: Exit Sub
            End If
        Case &H1, &H2, &H3, &H4, &H5, &H6, &H7, &H8
            Disconnect Index: Exit Sub
        End Select
    End If
    
    '...Otherwise handle packet data
    Node(Index).Buffer = Node(Index).Buffer & Data
    While (Len(Node(Index).Buffer) > 3)
        Dim PacketLen As Integer, PacketData As String
        PacketLen = ExtractInt16(Mid$(Node(Index).Buffer, 3, 2))
        If (Len(Node(Index).Buffer) < PacketLen) Or (PacketLen < 1) Then Exit Sub
        PacketData = Left$(Node(Index).Buffer, PacketLen)
        If Asc(Left$(PacketData, 1)) = &HFF Then
            Dim PacketID As Byte
            PacketID = Asc(Mid$(PacketData, 2, 1))
            NewPacket Index, PacketID, Mid$(PacketData, 5)
        End If
        Node(Index).Buffer = Mid$(Node(Index).Buffer, PacketLen + 1)
    Wend
    Exit Sub
hErr:
LogError "Connection", "NewData"
End Sub

Public Sub NewPacket(Index As Integer, Packet As Byte, Data As String)
On Error GoTo hErr:
    Debug.Print "Packet Arrival => " & Hex(Packet)
    Select Case Packet
    Case &H0
        SendNull Index
    Case &HF
        Dim Message As String
        Dim r As New clsPacketDebuffer
        r.SetDebuffer Data
        If r.ReadInt32() = &H13 Then
            r.Skip 20
            Message = r.ReadCString()
            Message = r.ReadCString()
            If (InStrB(Message, "chat privileges suspended") <> 0) Then
                ChangeCdkeyStatus Node(Index).Cdkey, Voided
                Node(Index).State = Analyzed
                Exit Sub
            End If
            If (InStrB(Message, "account is muted") <> 0) Then
                ChangeCdkeyStatus Node(Index).Cdkey, Muted
                Node(Index).State = Analyzed
                Exit Sub
            End If
        End If
    Case &H25
        SendPing Index, ExtractInt32(Left$(Data, 4))
    Case &H50
        ReceiveAuthInfo Index, Data
    Case &H51
        ReceiveAuthCheck Index, Data
    Case &H53
        ReceiveLoginW3 Index, Data
    Case &H54
        ReceiveLoginProofW3 Index, Data
    Case &H3A
        ReceiveLogin Index, Data
    Case &H3D
        ReceiveCreate Index, Data
    Case &HA
        ReceiveEnterChat Index
    Case &H46
        ReceiveNews Index, Data
    End Select
    Exit Sub
hErr:
LogError "Connection", "NewPacket[" & Hex(Packet) & "]"
End Sub

Public Sub SendAuthInfo(Index As Integer)
On Error GoTo hErr:
    'Specify game protocol
    frmMain.wsBNET(Index).SendData Chr$(1)
    'Protocol id
    Dim b As New clsPacketBuffer
    b.InsertInt32 0
    Select Case Node(Index).Client
    Case CDKEYCLIENT.SC
        b.InsertFixedString "68XIRATS"
        b.InsertInt32 Verbyte.SC
    Case CDKEYCLIENT.W2
        b.InsertFixedString "68XINB2W"
        b.InsertInt32 Verbyte.W2
    Case CDKEYCLIENT.D2
        b.InsertFixedString "68XIVD2D"
        b.InsertInt32 Verbyte.D2
    Case CDKEYCLIENT.W3
        b.InsertFixedString "68XI3RAW"
        b.InsertInt32 Verbyte.W3
    Case Else
        Debug.Print "Invalid product error (" & Node(Index).Client & ")!"
        Exit Sub
    End Select
    b.InsertInt32 0
    b.InsertInt32 0
    b.InsertInt32 0
    b.InsertInt32 0
    b.InsertInt32 0
    b.InsertCString "AUS"
    b.InsertCString "Australia"
    SendPacket Index, &H50, b.Buffer
    Exit Sub
hErr:
LogError "Connection", "SendAuthInfo"
End Sub
'
'Public Sub SendCreate(Index as Integer)
'On Error GoTo hErr:
'    If RandomAccounts Then
'        Node(Index).Account = RandomString()
'    Else
'        Node(Index).Account = Username
'    End If
'    Output vbYellow, "Creating account " & Node(Index).Account & "..."
'    'If (LenB(Node(Index).Account) = 0) Then Err.Raise 666, "RandomString", "Account length is zero!": Exit Sub
'    Dim b As New clsPacketBuffer
'    b.InsertFixedString hashPassword(Password)
'    b.InsertCString Node(Index).Account
'    SendPacket Index, &H3D, b.Buffer
'    Exit Sub
'hErr:
'LogError "Connection", "SendCreate"
'End Sub

Public Sub SendLoginW3(Index As Integer)
On Error GoTo hErr:
    Dim b As New clsPacketBuffer
    Debug.Print "Logging into account " & Config.AccountW3 & "..."
    If (Node(Index).nlsV > 0) Then nls_free Node(Index).nlsV
    Node(Index).nlsV = nls_init(Config.AccountW3, Config.PasswordW3)
    If (Node(Index).nlsV = 0) Then
        Debug.Print "Failed to initialize NLS handler!"
        Exit Sub
    End If
    
    nls_get_A Node(Index).nlsV, Node(Index).nlsA
    b.InsertFixedString Node(Index).nlsA
    b.InsertCString Config.AccountW3
    SendPacket Index, &H53, b.Buffer
    Exit Sub
hErr:
LogError "Connection", "SendLoginW3"
End Sub

Public Sub ReceiveLoginW3(Index As Integer, Data As String)
On Error GoTo hErr:
    Dim d As New clsPacketDebuffer
    d.SetDebuffer Data
    Select Case d.ReadInt32()
    Case &H0
        Node(Index).nlsS = d.ReadFixedString(32)
        Node(Index).nlsB = d.ReadFixedString(32)
        nls_get_M1 Node(Index).nlsV, Node(Index).nlsM1, Node(Index).nlsB, Node(Index).nlsS
        SendPacket Index, &H54, Node(Index).nlsM1
    Case &H1
        frmMain.Complete: MsgBox "Specified account does not exist!", vbExclamation
    Case &H5
        frmMain.Complete: MsgBox "Specified account requires upgrade!", vbExclamation
    Case Else
        frmMain.Complete: MsgBox "Unknown login response code!", vbExclamation
    End Select
    Exit Sub
hErr:
LogError "Connection", "ReceiveLoginW3"
End Sub

Public Sub ReceiveLoginProofW3(Index As Integer, Data As String)
On Error GoTo hErr:
    Static fails As Long
    Dim d As New clsPacketDebuffer
    d.SetDebuffer Data
    Dim result As Long, info As String
    result = d.ReadInt32()
    Node(Index).nlsM2 = d.ReadFixedString(20)
    info = d.ReadCString()
    
    Select Case result
    Case &H2
        fails = fails + 1
        If fails >= 10 Then
            frmMain.Complete: MsgBox "Incorrect password specified to current account (W3)!", vbExclamation
        End If
        Exit Sub
    Case &HF
        frmMain.Complete: MsgBox info & "!", vbExclamation
        Exit Sub
    End Select
    
    If nls_check_M2(Node(Index).nlsV, Node(Index).nlsM2, Node(Index).nlsB, Node(Index).nlsS) = 0 Then
        Debug.Print "Password proof rejected!"
        If LenB(info) > 0 Then Debug.Print info
        Disconnect Index
    Else
        SendEnterChat Index
    End If
    Exit Sub
hErr:
LogError "Connection", "ReceiveLoginW3"
End Sub

Public Sub SendLogin(Index As Integer)
On Error GoTo hErr:
    Dim b As New clsPacketBuffer
    Debug.Print "Logging into account " & Config.Account & "..."
    b.InsertInt32 Node(Index).ClientToken
    b.InsertInt32 Node(Index).ServerToken
    b.InsertFixedString doubleHashPassword(Config.Password, Node(Index).ClientToken, Node(Index).ServerToken)
    b.InsertCString Config.Account
    SendPacket Index, &H3A, b.Buffer
    Exit Sub
hErr:
LogError "Connection", "SendLogin"
End Sub

Public Sub SendPing(Index As Integer, Value As Long)
On Error GoTo hErr:
    SendPacket Index, &H25, CreateInt32(Value)
    Exit Sub
hErr:
LogError "Connection", "SendPing"
End Sub

Public Sub SendNull(Index As Integer)
On Error GoTo hErr:
    SendPacket Index, &H0, ""
    Exit Sub
hErr:
LogError "Connection", "SendNull"
End Sub

Public Sub SendEnterChat(Index As Integer)
On Error GoTo hErr:
    Dim b As New clsPacketBuffer
    b.InsertCString Config.Account
    b.InsertByte 0
    SendPacket Index, &HA, b.Buffer
    b.Clear
    b.InsertInt32 2
    b.InsertCString Config.Channel
    SendPacket Index, &HC, b.Buffer
    Exit Sub
hErr:
LogError "Connection", "SendEnterChat"
End Sub

Public Sub ReceiveAuthInfo(Index As Integer, Data As String)
On Error GoTo hErr:
    Dim ls As Long
    Dim d As New clsPacketDebuffer
    d.SetDebuffer Data
    ls = d.ReadInt32()
    If ls = 2 Then
        Node(Index).nls = True
    Else
        Node(Index).nls = False
    End If
    If (ls <> 0 And ls <> 2) Then
        'Unknown login
        Debug.Print "Unknown login style specified..."
        Exit Sub
    End If
    Node(Index).ClientToken = GetTickCount()
    Node(Index).ServerToken = d.ReadInt32
    d.Skip 4
    
    Dim vr As Long, cs As Long, mt As String, mn As String, vs As String, _
        hf() As String, dg As String
    mt = d.ReadFixedString(8)
    mn = d.ReadCString()
    vs = d.ReadCString()
    dg = String$(32, vbNullChar)
    Select Case Node(Index).Client
    Case SC
        ReDim hf(5)
        hf(0) = App.Path & "\Binaries\STAR\StarCraft.exe"
        hf(1) = App.Path & "\Binaries\STAR\Storm.dll"
        hf(2) = App.Path & "\Binaries\STAR\Battle.snp"
        hf(3) = App.Path & "\Binaries\Lockdown\" & Replace$(mn, ".mpq", ".dll")
        hf(4) = App.Path & "\Binaries\Lockdown\lockdown-IX86-01.dll"
        hf(5) = App.Path & "\Binaries\Video\STAR.bin"
        If (CheckRevisionLD(hf(0), hf(1), hf(2), vs, vr, cs, dg, hf(3), hf(4), hf(5)) <> 1) Then
            frmMain.Complete: MsgBox "StarCraft hashes are missing!", vbExclamation
            Exit Sub
        End If
    Case W2
        ReDim hf(5)
        hf(0) = App.Path & "\Binaries\W2BN\Warcraft II BNE.exe"
        hf(1) = App.Path & "\Binaries\W2BN\Storm.dll"
        hf(2) = App.Path & "\Binaries\W2BN\Battle.snp"
        hf(3) = App.Path & "\Binaries\Lockdown\" & Replace$(mn, ".mpq", ".dll")
        hf(4) = App.Path & "\Binaries\Lockdown\lockdown-IX86-01.dll"
        hf(5) = App.Path & "\Binaries\Video\W2BN.bin"
        If (CheckRevisionLD(hf(0), hf(1), hf(2), vs, vr, cs, dg, hf(3), hf(4), hf(5)) <> 1) Then
            frmMain.Complete: MsgBox "WarCraft II hashes are missing!", vbExclamation
            Exit Sub
        End If
    Case D2
        ReDim hf(2)
        hf(0) = App.Path & "\Binaries\D2DV\Game.exe"
        hf(1) = App.Path & "\Binaries\D2DV\Bnclient.dll"
        hf(2) = App.Path & "\Binaries\D2DV\D2Client.dll"
        If (CheckRevisionA(vs, hf, extractMPQNumber(mn), cs) = False) Then
            frmMain.Complete: MsgBox "Diablo II hashes are missing!", vbExclamation
            Disconnect Index
            Exit Sub
        End If
        vr = getExeInfo(hf(0), dg)
        If (vr = 0) Then
            frmMain.Complete: MsgBox "Diablo II invalid version!", vbExclamation
            Exit Sub
        End If
    Case W3
        ReDim hf(2)
        hf(0) = App.Path & "\Binaries\WAR3\War3.exe"
        hf(1) = App.Path & "\Binaries\WAR3\Storm.dll"
        hf(2) = App.Path & "\Binaries\WAR3\Game.dll"
        If (CheckRevisionA(vs, hf, extractMPQNumber(mn), cs) = False) Then
            frmMain.Complete: MsgBox "WarCraft III hashes are missing!", vbExclamation
            Exit Sub
        End If
        vr = getExeInfo(hf(0), dg)
        If (vr = 0) Then
            frmMain.Complete: MsgBox "WarCraft III invalid version!", vbExclamation
            Exit Sub
        End If
    End Select
    If (InStrB(dg, vbNullChar) > 0) Then dg = Left$(dg, InStr(dg, vbNullChar) - 1)

    Dim b As New clsPacketBuffer
    b.InsertInt32 Node(Index).ClientToken
    b.InsertInt32 vr
    b.InsertInt32 cs
    b.InsertInt32 1
    b.InsertInt32 0
    
    Dim hs As String, pr As Long, pu As Long
    If HashCdkey(Index, hs, pr, pu) = True Then
        b.InsertInt32 Len(Node(Index).Cdkey)
        b.InsertInt32 pr
        b.InsertInt32 pu
        b.InsertInt32 0
        b.InsertFixedString hs
    Else
        Disconnect Index
        Exit Sub
    End If
    
    b.InsertCString dg
    b.InsertCString "Opal"
    SendPacket Index, &H51, b.Buffer
    Exit Sub
hErr:
LogError "Connection", "ReceiveAuthInfo"
End Sub

Public Sub ReceiveAuthCheck(Index As Integer, Data As String)
On Error GoTo hErr:
    Dim res As Long, inf As String
    Dim d As New clsPacketDebuffer
    d.SetDebuffer Data
    res = d.ReadInt32
    inf = d.ReadCString
    Select Case res
    Case &H0
        If Node(Index).nls Then
            SendLoginW3 Index
        Else
            SendLogin Index
        End If
        Exit Sub
    Case &H100: Debug.Print "Client version is too old (" & inf & ")!"
    Case &H101: Debug.Print "Client version is invalid!"
    Case &H102: Debug.Print "Client version is too new (" & inf & ")!"
    Case &H200, &H202, &H203
        Debug.Print "Cdkey is useless"
        ChangeCdkeyStatus Node(Index).Cdkey, Useless
        Node(Index).State = Analyzed
        AssignCdkey Index
    Case &H201
        ChangeCdkeyStatus Node(Index).Cdkey, Inuse
        Node(Index).State = Analyzed
        AssignCdkey Index
    'Case &H200: RemoveCdkey Node(Index).Cdkey: NextCdkey Node(Index).Cdkey, Node(Index).Product: Output vbRed, "Cdkey is invalid!"
    'Case &H201: RemoveCdkey Node(Index).Cdkey: NextCdkey Node(Index).Cdkey, Node(Index).Product: Output vbRed, "Cdkey is in use" & IIf(LenB(inf) > 0, " by " & inf & "!", "!")
    'Case &H202: RemoveCdkey Node(Index).Cdkey: NextCdkey Node(Index).Cdkey, Node(Index).Product: Output vbRed, "Cdkey is banned!"
    'Case &H203: RemoveCdkey Node(Index).Cdkey: NextCdkey Node(Index).Cdkey, Node(Index).Product: Output vbRed, "Cdkey is for another client!"
    'Case Val("&H0" & SCVerbyte), Val("&H0" & W2VerbytE), Val("&H0" & D2Verbyte): frmMain.Complete: MsgBox "Version byte for " & Node(Index).Client & " is invalid!", vbExclamation, "Verbyte Invalid!"
    Case Else: Debug.Print "Unexpected response code from 0x51 -> " & Hex(res)
    End Select
    Disconnect Index
    Exit Sub
hErr:
LogError "Connection", "ReceiveAuthCheck"
End Sub

Public Sub ReceiveCreate(Index As Integer, Data As String)
On Error GoTo hErr:
    Dim d As New clsPacketDebuffer
    d.SetDebuffer Data
    Select Case d.ReadInt32
    Case &H0: SendLogin Index: Exit Sub
    Case &H2: Debug.Print "Account contained an illegal character!"
    Case &H3: Debug.Print "Account contained a banned word!"
    Case &H4: Debug.Print "Account creation failed!"
    Case &H6: Debug.Print "Account contains too few alphanumeric characters!"
    Case Else: Debug.Print "Account creation failed!"
    End Select
    Disconnect Index
    Exit Sub
hErr:
LogError "Connection", "ReceiveCreate"
End Sub

Public Sub ReceiveLogin(Index As Integer, Data As String)
On Error GoTo hErr:
    Dim d As New clsPacketDebuffer
    d.SetDebuffer Data
    Select Case d.ReadInt32
    Case &H0: SendEnterChat Index
    Case &H1: frmMain.Complete: MsgBox "Specified account does not exist!", vbExclamation
    Case &H2: frmMain.Complete: MsgBox "Incorrect password to specified account!", vbExclamation
    End Select
    Exit Sub
hErr:
LogError "Connection", "ReceiveLogin"
End Sub

Public Sub ReceiveNews(Index As Integer, Data As String)
    Dim r As New clsPacketDebuffer, e As Byte, I As Byte, s As String
    r.SetDebuffer Data
    e = r.ReadByte()
    r.Skip 12
    For I = 1 To e
        r.Skip 4
        s = LCase$(r.ReadCString())
        If (InStrB(s, "chat privileges suspended") <> 0) Then
            ChangeCdkeyStatus Node(Index).Cdkey, Voided
            Node(Index).State = Analyzed
            Exit Sub
        End If
        If (InStrB(s, "account is muted") <> 0) Then
            ChangeCdkeyStatus Node(Index).Cdkey, Muted
            Node(Index).State = Analyzed
            Exit Sub
        End If
    Next
End Sub

Public Sub ReceiveEnterChat(Index As Integer)
On Error GoTo hErr:
    Status Index, Working
    SendPacket Index, &H46, CreateInt32(-1)
    Exit Sub
hErr:
LogError "Connection", "ReceiveEnterChat"
End Sub

Private Function HashCdkey(ByVal Index As Integer, ByRef h As String, ByRef productVal As Long, ByRef publicVal As Long) As Boolean
    On Error GoTo hErr
    Dim kd As Long, hashLength As Long, Hash As String
    kd = kd_create(Node(Index).Cdkey, Len(Node(Index).Cdkey))
    If (kd = -1) Then
        Debug.Print "Cannot initialize cdkey decoder!"
        Disconnect Index
        Exit Function
    End If
    hashLength = kd_calculateHash(kd, Node(Index).ClientToken, Node(Index).ServerToken)
    If (hashLength = 0) Then
        Debug.Print "Cannot calculate cdkey hash length!"
        Disconnect Index
        Exit Function
    End If
    If kd_isValid(kd) = 0 Then
        Debug.Print "Cdkey did not pass installer check!"
        Disconnect Index
        Exit Function
    End If
    Hash = Space$(hashLength)
    kd_getHash kd, Hash
    h = Hash
    productVal = kd_product(kd)
    publicVal = kd_val1(kd)
    kd_free kd
    HashCdkey = True
    Exit Function
hErr:
    LogError "Connection", "HashCdkey"
End Function
