Attribute VB_Name = "modCdkeys"
Option Explicit

Public Cdkeys() As CDKEYTYPE
Public Type CDKEYTYPE
    Cdkey As String
    Client As CDKEYCLIENT
    Status As CDKEYSTATUS
End Type
Public Enum CDKEYSTATUS
    Neutral = 0
    Analyzing = 1
    Perfect = 2
    Muted = 3
    Voided = 4
    Inuse = 5
    Useless = 6
End Enum
Public Enum CDKEYCLIENT
    D2 = 1
    SC = 2
    W2 = 3
    W3 = 4
End Enum

Public Sub ChangeCdkeyStatus(ByRef Cdkey As String, cs As CDKEYSTATUS)
    Dim I As Long
    For I = 0 To UBound(Cdkeys)
        If Cdkeys(I).Cdkey = Cdkey Then
            Cdkeys(I).Status = cs
            Exit Sub
        End If
    Next I
End Sub

Public Sub GenerateTempFile(ByRef c As CDKEYCLIENT)
    Dim tf As String, cc As String, cd As String, ff As Long, I As Long
    Select Case c
    Case CDKEYCLIENT.D2: cc = "Diablo II": cd = "D2"
    Case CDKEYCLIENT.SC: cc = "StarCraft": cd = "SC"
    Case CDKEYCLIENT.W2: cc = "WarCraft II": cd = "W2"
    Case CDKEYCLIENT.W3: cc = "WarCraft III": cd = "W3"
    End Select
    ff = FreeFile
    tf = App.Path & "\Generated-" & cd & "-" & (1000 + Int(Rnd * 8999)) & ".tmp"
    Open tf For Append As #ff: Close #ff
    Open tf For Output As #ff
        Print #ff, "==============================================="
        Print #ff, "; Opal Cdkey Analyser - " & cc & " Cdkeys"
        Print #ff, "; Date: " & Date & ", Time: " & Time
        Print #ff, "==============================================="
        Print #ff, " "
        Print #ff, "; Perfect"
            For I = 0 To UBound(Cdkeys)
                If (Cdkeys(I).Client = c) And Cdkeys(I).Status = Perfect Then
                    Print #ff, Cdkeys(I).Cdkey
                End If
            Next I
        Print #ff, " "
        Print #ff, "; Muted"
            For I = 0 To UBound(Cdkeys)
                If (Cdkeys(I).Client = c) And Cdkeys(I).Status = Muted Then
                    Print #ff, Cdkeys(I).Cdkey
                End If
            Next I
        Print #ff, " "
        Print #ff, "; Jailed"
            For I = 0 To UBound(Cdkeys)
                If (Cdkeys(I).Client = c) And Cdkeys(I).Status = Voided Then
                    Print #ff, Cdkeys(I).Cdkey
                End If
            Next I
        Print #ff, " "
        Print #ff, "; Used"
            For I = 0 To UBound(Cdkeys)
                If (Cdkeys(I).Client = c) And Cdkeys(I).Status = Inuse Then
                    Print #ff, Cdkeys(I).Cdkey
                End If
            Next I
    Close #ff
    
    Shell "notepad.exe " & """" & tf & """", vbNormalFocus
    Kill tf
End Sub

Public Sub AssignCdkey(I As Integer)
    'Get next proxy
    Dim c As CDKEYTYPE
    NextCdkey c
    
    'Assign node detail
    Node(I).Cdkey = c.Cdkey
    Node(I).Client = c.Client
    
    If LenB(c.Cdkey) = 0 Then
        'No more cdkeys available at the moment...
    End If
End Sub

Public Sub NextCdkey(ByRef c As CDKEYTYPE)
On Error GoTo hErr:
    Static I As Long
    If I > UBound(Cdkeys) Then
        'Search for a cdkey that is not being analyzed yet
        Dim f As Integer
        For f = 0 To UBound(Cdkeys)
            'Check if status is neutral (not being analyzed by ONLINE bot)
            If Cdkeys(f).Status = Neutral Then
                'Use this cdkey...
                c = Cdkeys(f)
                Exit For
            End If
        Next f
        Exit Sub
    End If
    'Change status of cdkey
    Cdkeys(f).Status = Neutral
    'Copy cdkey
    c = Cdkeys(I)
    'Increment counter
    I = I + 1
hErr:
End Sub

Public Sub ExportAllCdkeys()
    Dim I As Long
    For I = 0 To UBound(Cdkeys)
        If (Cdkeys(I).Status = Analyzing) Then Cdkeys(I).Status = Neutral
    Next I
    ExportCdkeyFile "Perfect", Perfect
    ExportCdkeyFile "Muted", Muted
    ExportCdkeyFile "Jailed", Voided
    ExportCdkeyFile "Used", Inuse
    ExportCdkeyFile "Untested", Neutral
End Sub

Public Sub ExportCdkeyFile(Filename As String, Status As CDKEYSTATUS)
    Dim fs As New FileSystemObject, file As String, ff As Long, I As Long
    'Get FreeFile
    ff = FreeFile
    'Specify File
    file = App.Path & "\Cdkeys\" & Filename & ".txt"
    'Create Cdkeys Folder
    If (fs.FolderExists(App.Path & "\Cdkeys\") = False) Then fs.CreateFolder App.Path & "\Cdkeys\"
    'Delete Existing File
    If (fs.FileExists(file)) Then fs.DeleteFile file, True
    'Output Cdkeys
    Open file For Output As #ff
        Print #ff, "==============================================="
        Print #ff, "; Opal Cdkey Analyser - " & Filename & " Cdkeys"
        Print #ff, "; Date: " & Date & ", Time: " & Time
        Print #ff, "==============================================="
        Print #ff, " "
        Print #ff, "; StarCraft"
        For I = 0 To UBound(Cdkeys)
            With Cdkeys(I)
                If (.Client = SC) And .Status = Status And Len(.Cdkey) = 13 Then
                    Print #ff, .Cdkey
                End If
            End With
        Next I
        
        Print #ff, " "
        Print #ff, "; StarCraft Anthology"
        For I = 0 To UBound(Cdkeys)
            With Cdkeys(I)
                If (.Client = SC) And .Status = Status And Len(.Cdkey) = 26 Then
                    Print #ff, .Cdkey
                End If
            End With
        Next I
        
        Print #ff, " "
        Print #ff, "; Diablo II"
        For I = 0 To UBound(Cdkeys)
            With Cdkeys(I)
                If (.Client = D2) And .Status = Status And Len(.Cdkey) = 16 Then
                    Print #ff, .Cdkey
                End If
            End With
        Next I
        
        Print #ff, " "
        Print #ff, "; Diablo II Anthology"
        For I = 0 To UBound(Cdkeys)
            With Cdkeys(I)
                If (.Client = D2) And .Status = Status And Len(.Cdkey) = 26 Then
                    Print #ff, .Cdkey
                End If
            End With
        Next I
        
        Print #ff, " "
        Print #ff, "; WarCraft II"
        For I = 0 To UBound(Cdkeys)
            With Cdkeys(I)
                If (.Client = W2) And .Status = Status And Len(.Cdkey) = 16 Then
                    Print #ff, .Cdkey
                End If
            End With
        Next I
        
        Print #ff, " "
        Print #ff, "; WarCraft III"
        For I = 0 To UBound(Cdkeys)
            With Cdkeys(I)
                If (.Client = W3) And .Status = Status And Len(.Cdkey) = 26 Then
                    Print #ff, .Cdkey
                End If
            End With
        Next I
    Close #ff
End Sub

Public Function ImportCdkeyFile() As Boolean
    Dim fs As New FileSystemObject, ts As TextStream
    'Create Cdkeys Folder
    If (fs.FolderExists(App.Path & "\Cdkeys\") = False) Then fs.CreateFolder App.Path & "\Cdkeys\"
    'Clear Cdkeys Array
    ReDim Cdkeys(0)
    'Open Cdkeys File
    Set ts = fs.OpenTextFile(App.Path & "\Cdkeys\Untested.txt", ForReading, True)
    'Read Each Line of Cdkeys File
    Do Until ts.AtEndOfStream
        Dim buf As String
        'Remove padding
3       buf = Trim$(UCase$(ts.ReadLine))
        'Remove dashes
        If LenB(buf) > 1 Then
            If Left$(buf, 1) <> ";" And Left$(buf, 1) <> "=" Then
4               buf = Replace$(buf, "-", vbNullString)
                'Find previous test marking (eg '<cdkey> [muted]')
5               If InStr(buf, " [") > 0 Then buf = Left$(buf, InStr(buf, " [") - 1)
                'Remove spaces
6               buf = Replace$(buf, " ", vbNullString)
                'Check length
                Select Case Len(buf)
                Case 13, 16, 26
                    Dim Client As String, s As Long
                    'Determine s
7                   If LenB(Cdkeys(UBound(Cdkeys)).Cdkey) > 0 Then s = UBound(Cdkeys) + 1 Else s = UBound(Cdkeys)
                    'Determine CD-key's client
8                   Client = DetermineCdkey(buf)
                    Select Case Client
                    Case "STAR"
                        'StarCraft
9                       ReDim Preserve Cdkeys(s)
10                      Cdkeys(s).Client = SC
11                      Cdkeys(s).Cdkey = buf
                    Case "D2DV"
                        'Diablo II
12                      ReDim Preserve Cdkeys(s)
13                      Cdkeys(s).Client = D2
14                      Cdkeys(s).Cdkey = buf
                    Case "W2BN"
                        'WarCraft II
15                      ReDim Preserve Cdkeys(s)
16                      Cdkeys(s).Client = W2
17                      Cdkeys(s).Cdkey = buf
                    Case "WAR3"
                        'WarCraft III
18                      ReDim Preserve Cdkeys(s)
19                      Cdkeys(s).Client = W3
20                      Cdkeys(s).Cdkey = buf
                    Case "D2XP", "W3XP"
21                      'Save elsewhere...
                    End Select
                End Select
            End If
        End If
    Loop
    ts.Close
    
    If UBound(Cdkeys) > 0 Or LenB(Cdkeys(0).Cdkey) > 0 Then ImportCdkeyFile = True
    Exit Function
hErr:
    MsgBox "Error occurred at line " & Erl & " while importing cdkeys:" & vbNewLine & Err.Description, vbExclamation, "Error #" & Err.Number
End Function

Public Function CountCdkeysAnalyzed() As Long
    Dim I As Long, a As Long
    For I = 0 To UBound(Cdkeys)
        If Cdkeys(I).Status <> Neutral And Cdkeys(I).Status <> Analyzing Then
            a = a + 1
        End If
    Next
    CountCdkeysAnalyzed = a
End Function

Public Sub CountCdkeys(Client As CDKEYCLIENT, ByRef u As Long, ByRef P As Long, ByRef m As Long, ByRef v As Long, ByRef f As Long, ByRef z As Long)
    Dim I As Long
    u = 0: P = 0: m = 0: v = 0: f = 0
    For I = 0 To UBound(Cdkeys)
        If Cdkeys(I).Client = Client Then
            Select Case Cdkeys(I).Status
            Case CDKEYSTATUS.Muted: m = m + 1
            Case CDKEYSTATUS.Voided: v = v + 1
            Case CDKEYSTATUS.Perfect: P = P + 1
            Case CDKEYSTATUS.Useless: f = f + 1
            Case CDKEYSTATUS.Inuse: z = z + 1
            Case Else: u = u + 1
            End Select
        End If
    Next
End Sub
