Attribute VB_Name = "modGeneral"
Option Explicit

Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)
Public Declare Function GetTickCount Lib "kernel32.dll" () As Long
Public Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Public Cfg As New clsConfig
Public Pkt As New clsPacket
Public Reg As New clsRegistryAccess
Public Acc() As String
Public Hash As tHash
Public Counter As Integer

Public CreateTick As Long

Public Type tHash
    KeyDecoder As Long
    HashLength As Long
    KeyHash As String
    Account As String
    Password As String
    NLS As Long
    NLSversion As Long
    ClientKey As Long
    ServerKey As Long
    MPQFile As String
    MPQFileTime As String
    mpqNumber As Long
    ChecksumFormula As String
End Type

Public Sub AddChat(ParamArray saElements() As Variant)
    Dim I As Integer

    For I = LBound(saElements) To UBound(saElements) Step 2
        With frmMain.rtbChat
            .SelStart = Len(.Text)
            .SelLength = 0
            .SelColor = saElements(I)
            .SelText = saElements(I + 1) & Left$(vbCrLf, -2 * CLng((I + 1) = UBound(saElements)))
            .SelStart = Len(.Text)
        End With
    Next I
End Sub

Public Function IsLastAccount() As Boolean
    If Counter >= UBound(Acc()) Then
        IsLastAccount = True
    End If
End Function

Public Function NextAccount(ByRef Account As String, ByRef Password As String) As Boolean
    Counter = Counter + 1
    If Counter > UBound(Acc()) Then
        Exit Function
    End If
    
    If Len(Acc(Counter)) > 0 Then
        Account = Acc(Counter)
        Password = Cfg.Password
        NextAccount = True
    End If
End Function

Public Sub LoadAccounts()
    ReDim Acc(0)
    Counter = 0
    Dim strLine As String
    
    On Error GoTo CloseFile:
    Open App.Path & "\Accounts.txt" For Input As #1
        Do Until EOF(1)
        Line Input #1, strLine
            ReDim Preserve Acc(UBound(Acc) + 1)
            Acc(UBound(Acc)) = strLine
        Loop
    Close #1
    Exit Sub
CloseFile:
    Close #1
    MsgBox "Unable to load accounts, please enter accounts before beginning the revive cycle.", vbExclamation
End Sub

Public Sub SaveAccounts()
    On Error GoTo CloseFile:
    Dim strLine As String
    
    Open App.Path & "\Accounts.txt" For Append As #1
    Close #1
    
    Open App.Path & "\Accounts.txt" For Output As #1
        Dim I As Integer
        For I = 0 To UBound(Acc())
            If Len(Acc(I)) > 0 Then
                Print #1, Acc(I)
            End If
        Next I
    Close #1
    Exit Sub
CloseFile:
    Close #1
    MsgBox "You have to load some accounts before you can save them!", vbExclamation
End Sub

Public Sub SaveCreatedAccount(ByVal Server As String, ByVal Account As String, ByVal Password As String)
    Open App.Path & "\Created Accounts.txt" For Append As #1
        Print #1, NameOfServer(Server) & ": " & Account & " / " & Password
    Close #1
    Open App.Path & "\Created Display List.txt" For Append As #1
        Print #1, NameOfServer(Server) & ": " & Account
    Close #1
    
    Dim I  As Integer
    For I = UBound(Acc()) To 1 Step -1
        If LCase$(Acc(I)) = LCase$(Account) Then
            Dim J As Integer
            For J = I To UBound(Acc()) - 1
                Acc(J) = Acc(J + 1)
            Next J
            ReDim Preserve Acc(UBound(Acc) - 1)
            AddChat vbYellow, "Removed " & Account & " from account creation list."
            Exit Sub
        End If
    Next I
End Sub

Private Function NameOfServer(ByVal ServerIP As String) As String
    Dim tmpServer As String
    Const USWEST_IP = "63.241.83.*"
    Const USEAST_IP = "63.240.202.*"
    Const ASIA_IP = "211.233.0.*"
    Const EUROPE_IP = "213.248.106.*"
    
    tmpServer = ServerIP
    
    If LCase$(ServerIP) Like USWEST_IP Then tmpServer = "USWest"
    If LCase$(ServerIP) Like "usw*" Then tmpServer = "USWest"
    If LCase$(ServerIP) Like "raynor.*" Then tmpServer = "USWest"
    If LCase$(ServerIP) Like "kerrigan.*" Then tmpServer = "USWest"
    If LCase$(ServerIP) Like USEAST_IP Then tmpServer = "USEast"
    If LCase$(ServerIP) Like "use*" Then tmpServer = "USEast"
    If LCase$(ServerIP) Like "exodus.*" Then tmpServer = "USEast"
    If LCase$(ServerIP) Like "tassadar.*" Then tmpServer = "USEast"
    If LCase$(ServerIP) Like ASIA_IP Then tmpServer = "Asia"
    If LCase$(ServerIP) Like "asia.*" Then tmpServer = "Asia"
    If LCase$(ServerIP) Like "kor*" Then tmpServer = "Asia"
    If LCase$(ServerIP) Like "fenix.*" Then tmpServer = "Asia"
    If LCase$(ServerIP) Like EUROPE_IP Then tmpServer = "Europe"
    If LCase$(ServerIP) Like "zeratul.*" Then tmpServer = "Europe"
    If LCase$(ServerIP) Like "eur*" Then tmpServer = "Europe"
    
    If Cfg.Client = "WAR3" Then
        Select Case tmpServer
            Case "USWest": tmpServer = "Lordaeron"
            Case "USEast": tmpServer = "Azeroth"
            Case "Asia": tmpServer = "Kalimdor"
            Case "Europe": tmpServer = "Northrend"
        End Select
    End If
    
    NameOfServer = tmpServer
End Function

