
""" dos.py

	Simple plugin to print chat events.
		
	"""
	
import support, threading, sys, os, support
import datetime
from time import localtime, strftime
import webbrowser

from bni import bni
from statstring import statstring

wnd_title = "PyBot"

try:
	import wx
	#import wx.richtext
	wxen = True
except:
	support.doprint( " * It appears as though you do not have wxPython installed." )
	support.doprint( " * It is required for a bot interface. You can disable it in the config." )
	support.doprint( " * Literal: " + str(sys.exc_info()[1]) )
	wxen = False
	
config = support.config("pybot.ini")
def safe_unicode(string):
    try:
        return unicode(string)
    except UnicodeDecodeError:
        return '<Decode error.>'
	
class MailTaskBarIcon(wx.TaskBarIcon):  
	def __init__(self, parent, shown=''):  
		wx.TaskBarIcon.__init__(self)
		self.callback = shown
		
		self.parentApp = parent  
		self.icon = wx.Icon("img\\python_red_16.png", wx.BITMAP_TYPE_PNG)   
		self.CreateMenu()  
		self.SetIconImage()
		self.ordered = []

	def CreateMenu(self):  
		self.Bind(wx.EVT_TASKBAR_RIGHT_UP, self.ShowMenu)  
		self.menu=wx.Menu()
		self.menu.Append(wx.ID_ABOUT, "Toggle Visibility")
		self.menu.AppendSeparator()  
		self.menu.Append(wx.ID_EXIT, "Close")

	def ShowMenu(self, event):  
		self.PopupMenu(self.menu)  
		
	def ShowUI(self, event):
		self.callback()

	def SetIconImage(self):
		try:
			self.parentApp.SetIcon(self.icon)
		except:
			support.doprint( "Failed to set window icon." )
			print sys.exc_info()
		try:
			self.SetIcon(self.icon, config.get("main", "username") + "@" + config.get("main", "bncs"))
		except:
			self.SetIcon(self.icon, "PyBot")
	
class MailFrame(wx.Frame):
	def __init__(self, parent, id, title, tree, size=(100,100)):  
		wx.Frame.__init__(self, parent, -1, title, size = size) 
			#style=wx.NO_FULL_REPAINT_ON_RESIZE)  
	
		self.tree = tree
		self.tbicon = MailTaskBarIcon(self)  
		self.tbicon.Bind(wx.EVT_MENU, self.__fail__, id=wx.ID_EXIT)
		self.tbicon.Bind(wx.EVT_MENU, self.__tv__, id=wx.ID_ABOUT)		
		self.Show(True)
		self.shown = True

	def __fail__(self, event): 
		try:
			self.tbicon.RemoveIcon()
			self.tbicon.Destroy()
		except:
			pass
		sys.exit()
		
	def __tv__(self, event):  
		if self.shown == True:
			self.shown = False
			self.Show(False)
		else:
			self.shown = True
			self.Show(True)

config_info = (('Username', 'username'),
               ('Password', 'password', {'style': wx.TE_PASSWORD}),
               ('CD Key', 'cdkey'),
               ('Server', 'bncs'),
               ('BNLS Server', 'bnls'),
               ('Home Channel', 'home')
               )

class config():
        def __init__(self, parent):
                self.p = parent
                self.config = support.config(self.p.cfgfile)
                self.frame = wx.Frame(None, -1, 'Settings', size=(400, 400))
                self.sizer = wx.GridSizer(len(config_info)+1, 2)

                self.textctrls = []

                for setting in config_info:
                        self.sizer.Add(wx.StaticText(self.frame, label=setting[0]+':', style=wx.ALIGN_RIGHT), flag=wx.ALIGN_RIGHT | wx.ALIGN_CENTER_VERTICAL)
                        if len(setting) < 3:
                                kwargs = {}
                        else:
                                kwargs = setting[2]
                        self.textctrls.append(wx.TextCtrl(self.frame, value=self.config.get('main', setting[1]), **kwargs))
                        self.sizer.Add(self.textctrls[-1], flag=wx.EXPAND)

                self.cancel = wx.Button(self.frame, label="Cancel")
                self.sizer.Add(self.cancel, flag=wx.EXPAND)
                self.apply = wx.Button(self.frame, label="Apply and Close")
                self.sizer.Add(self.apply, flag=wx.EXPAND)

                self.frame.Bind(wx.EVT_BUTTON, self.fcancel, self.cancel)
                self.frame.Bind(wx.EVT_BUTTON, self.fapply, self.apply)

                self.frame.SetSizerAndFit(self.sizer)
                self.frame.Show()
        def fcancel(self, *rest):
                self.frame.Destroy()

        def fapply(self, *rest):
                for setting in zip(config_info, self.textctrls):
                        self.config.set('main', setting[0][1], setting[1].GetValue(), True)
                self.frame.Destroy()
	
class exposed(threading.Thread):
	def __init__(self, parent):
		if (not wxen): return None  

                self.upd_count = -1
		self.ordered = []
		self.status_bin = {}
		self.p = parent
		#self.channel = self.p.plugins.find("channel")
		self.masterSize = wx.Size(800, 500)
		
		threading.Thread.__init__(self)
		self.setDaemon(True)
		self.start()
	def reset_upd(self, evt):
                if type(evt) == wx.ActivateEvent and not evt.GetActive():
                        self.upd_count = 0
                        return
                self.upd_count = -1
                self.frame.SetTitle(wnd_title)
        def do_upd(self):
                if self.upd_count < 0:
                        return
                self.upd_count += 1
                self.frame.SetTitle('[%d] %s' % (self.upd_count, wnd_title))

        def open_config(self, *rest):
                config(self.p)
                
	def run(self):
		self.app = wx.App(False)
		self.frame = MailFrame(None, -1, 'PyBot', self, size = self.masterSize)
		self.ibar = self.frame.CreateStatusBar()
		self.ibar.SetStatusText("Welcome to PyBot")
                #Icon stuff
		self.draw = []
                self.bni = bni()
                self.type = [0x02, 0x00, 0x02, 0x00]
                self.icons, self.il, self.count = self.load_icons()
                
		""" Create widgets """

		#Menus
		self.mnu_bot = wx.Menu()
		self.mnu_bot.Append(200, "Connect\tCtrl+B", "Connect to Battle.net")
                self.mnu_bot.Append(201, "Disconnect\tCtrl+D", "Disconnect from Battle.net")
                self.mnu_bot.AppendSeparator()
		self.mnu_bot.Append(wx.ID_ABOUT, "&Hide", "Puts the window in the taskbar so you can't see it")
		self.mnu_bot.Append(wx.ID_EXIT, "E&xit", "Exit PyBot")

		wx.EVT_MENU(self.frame, wx.ID_ABOUT, self.frame.__tv__)
		wx.EVT_MENU(self.frame, wx.ID_EXIT,  self.frame.__fail__)
		wx.EVT_MENU(self.frame, 200, self.mnuf_connect)
		wx.EVT_MENU(self.frame, 201, self.mnuf_disc)

		self.mnu_settings = wx.Menu()
		self.mnu_settings.Append(300, "Bot Settings\tCtrl+P")

		wx.EVT_MENU(self.frame, 300, self.open_config)

		self.menu = wx.MenuBar()
		self.menu.Append(self.mnu_bot, "&Bot")
		self.menu.Append(self.mnu_settings, "Settings")
		
		
		self.frame.SetMenuBar(self.menu)
		
		''' Layout '''
		''' Vert split '''
		self.frame.half =  wx.BoxSizer(wx.HORIZONTAL)
		self.frame.left = wx.Panel(self.frame, -1, style=wx.SUNKEN_BORDER)
		self.frame.right = wx.Panel(self.frame, -1, style=wx.SUNKEN_BORDER)
		
		self.frame.left.SetBackgroundColour("BLUE")
		self.frame.right.SetBackgroundColour("RED")
		
		self.frame.leftsizer = wx.BoxSizer(wx.VERTICAL)
		self.frame.rightsizer = wx.BoxSizer(wx.VERTICAL)
		
		self.frame.half.Add(self.frame.left, 500, wx.EXPAND)
		self.frame.half.Add(self.frame.right, 0, wx.EXPAND)

		
		''' Widgets '''
		self.rtb = wx.TextCtrl(self.frame.left, style = wx.TE_MULTILINE |\
                           wx.TE_READONLY | wx.TE_RICH2 | wx.TE_NOHIDESEL | wx.TE_AUTO_URL)
		self.rtb.SetBackgroundColour("black")
                self.frame.Bind(wx.EVT_TEXT_URL, self.txt_url,
                                self.rtb)
		self.frame.leftsizer.Add(self.rtb, 500, wx.EXPAND)
		
		self.send = wx.TextCtrl(self.frame.left, style=wx.TE_AUTO_URL | wx.TE_PROCESS_ENTER)
		self.send.SetBackgroundColour("black")
		self.send.SetForegroundColour("white")
		self.frame.Bind(wx.EVT_TEXT_ENTER, self.send_text, self.send)
		#self.frame.Bind(wx.EVT_SET_FOCUS, self.reset_upd)
		self.frame.Bind(wx.EVT_ACTIVATE, self.reset_upd)
		#self.send.Bind(wx.EVT_CHAR, self.OnPress)
                
		self.frame.leftsizer.Add(self.send, 0, wx.EXPAND)
                self.frame.Bind(wx.EVT_TEXT_URL, self.txt_url,
                                self.send)
		
		self.cview = wx.ListCtrl(self.frame.right, style= wx.LC_REPORT |\
                                         wx.LC_ALIGN_LEFT | wx.LC_ALIGN_TOP)
		self.cview.SetBackgroundColour("black")
		self.cview.SetForegroundColour("white")
		self.cview.InsertColumn(0, "Icon", width=34)
		self.cview.InsertColumn(1, "Username", width=140)
		self.cview.InsertColumn(2, "Lag", width=30)
		self.cview.InsertColumn(3, "Clan", width=40)
		self.cview.SetImageList(self.il, wx.IMAGE_LIST_SMALL)
		self.cview.SetSizeHints(265, 1)

		
		self.frame.rightsizer.Add(self.cview, 1, wx.EXPAND)
		
		
		''' Finish '''
		self.frame.left.SetSizer(self.frame.leftsizer)
		self.frame.right.SetSizer(self.frame.rightsizer)
		self.frame.left.Layout()
		self.frame.right.Layout()
		self.frame.SetSizer(self.frame.half)
		self.frame.Layout()

		self.frame.Bind(wx.EVT_WINDOW_DESTROY, self.frame.__fail__)
		
		""" Stop creating widgets """
		#self.frame.Center(wx.BOTH) 
		
		self.frame.Show() 
		self.app.MainLoop()
        def addchat(self, *args, **kwargs):
                wx.CallAfter(self.do_addchat, *args, **kwargs)

	def do_addchat(self, *args):
                if self.rtb.GetNumberOfLines() >= 250:
                        length = self.rtb.GetLineLength(0) + 1
                        self.rtb.Remove(0, length)

                self._indivchat('white', strftime('[%I:%M:%S %p] ', localtime()))
                    
                if len(args) > 1:
                        for x in range(0, len(args), 2):
                                self._indivchat(args[x], args[x+1])
                else:
                        self._indivchat('yellow', args[0])

                self.rtb.AppendText('\n')

        def _indivchat(self, style, text):  
                style = wx.TextAttr(style)
                self.rtb.SetDefaultStyle(style)
                try:
                    self.rtb.AppendText(text)
                except UnicodeDecodeError:
                    self.rtb.SetDefaultStyle(wx.TextAttr('red'))
                    self.rtb.AppendText('<Unicode decode error>')

        def mnuf_disc(self, *rest):
                self.clear()
                
                self.p.disconnect()
                self.p.saydisc = False
                self.addchat("red", "All connections closed.")

        def mnuf_connect(self, *rest):
                self.p.connect()

        def txt_url (self, tue):
                if tue.GetMouseEvent().LeftDown():
                        webbrowser.open(tue.EventObject.GetRange(tue.GetURLStart(),
                                                                 tue.GetURLEnd()))
##
##    def insert_user(self, evt_list):
##        #Prepare yourself.
##        list_col = self.type.index(0x00)
##        list_item = self.lc.GetItem(evt_list.GetIndex(), list_col)
##        list_text = list_item.GetText()
##        self.parent.cb_send.SetValue(self.parent.cb_send.GetValue() +\
##                                     list_text)
##
##        evt_list.Skip(True)
##
##    def popup_list(self, evt_list):
##        if self.menu != None:
##            sel_count = self.lc.GetSelectedItemCount()
##            self.bot.status['selected'] = []
##            last = -1
##            
##            for x in range(sel_count):
##                last = self.lc.GetNextItem(last, wx.LIST_NEXT_ALL,
##                                           wx.LIST_STATE_SELECTED)
##                self.bot.status['selected'].append(last)
##            
##            self.lc.PopupMenu(self.menu)
##
##        evt_list.Skip(True)
##
        def get_lag_idx(self, arg):
                ping, flags = arg
                if (flags & 0x10) == 0x10:
                        return self.bni.legacy[49]['idx']
                elif ping <= 0:
                        return self.bni.legacy[42]['idx']
                elif ping < 200:
                        return self.bni.legacy[43]['idx']
                elif ping > 700:
                        return self.bni.legacy[48]['idx']
                else:
                        return self.bni.legacy[ping / 100 + 42]['idx']
        def get_bni_idx(self, user, draw):
                il = self.bni.il
                try:
                    icon = user['icon'][-4:] or user['product'][-4:]
                except KeyError:
                    icon = user['product'][-4:]
                flags = user['flags']

                idx = -1
                for x in self.bni.flag:
                    if (flags & x['flags']) == x['flags']:
                        idx = x['idx']
                        return idx

                if (icon in ['STAR', 'SEXP', 'SSHR', 'JSTR']):
                    try:
                        if user['ladder_rank'] != 0:
                            if user['ladder_rank'] == 1:
                                idx = self.bni.legacy[13]['idx']
                            else:
                                idx = self.bni.legacy[12]['idx']
                        elif user['ladder_rating'] != 0:
                            idx = self.bni.legacy[11]['idx']
                        elif user['wins'] > 0:
                            idx = ((user['wins'] > 10) and 10) or\
                                    user['wins']
                            idx = self.bni.legacy[idx]['idx']
                            return idx
                    except KeyError:
                        pass

                elif icon == 'W2BN':
                    try:
                        if user['ladder_rank'] != 0:
                            if user['ladder_rank'] == 1:
                                idx = self.bni.legacy[28]['idx']
                            else:
                                idx = self.bni.legacy[26]['idx']
                        elif user['ladder_rating'] != 0:
                            idx = self.bni.legacy[25]['idx']
                        elif user['wins'] > 0:
                            idx = (((user['wins'] > 10) and 10) or\
                                    user['wins']) + 14
                            return idx
                    except KeyError:
                        pass
                        
                elif icon in ['DRTL', 'DSHR']:
                    try:
                        if user['class_num'] != -1:
                            idx = 30 + user['class_num'] + 3 * user['dots']
                    except KeyError:
                        pass
                elif user['product'] in ['WAR3', 'W3XP']:
                    try:
                        if user['level'] == 0:
                                icon = user['product'] #Override to more specific icon
                    except KeyError:
                        icon = user['product']
                if idx == -1:
                    try:
                        idx = self.bni.prod[icon]['idx']
                    except KeyError:
                        return -1

                if 'level' in user:
                    if user['level'] == 0:
                        return idx
                    bitm = il.GetBitmap(idx)
                    mdc = wx.MemoryDC(bitm)
                    mdc.SetTextForeground('#3399FF')
                    font = wx.Font(6, wx.FONTFAMILY_ROMAN,
                                   wx.FONTSTYLE_NORMAL,
                                   wx.FONTWEIGHT_NORMAL)
                    mdc.SetFont(font)
                    if user['product'] in ['WAR3', 'W3XP']:
                        mdc.DrawText(str(user['level']), 22, 3)
                    elif user['product'] in ['DRTL', 'DSHR']:
                        mdc.DrawText(str(user['level']), 16, 3)
                    elif user['product'] in ['D2DV', 'D2XP']:
                        mdc.DrawText(str(user['level']), 16, 3)

                    mdc.SelectObjectAsSource(wx.NullBitmap)
                    idx = self.bni.add(bitm)
                    draw.append(idx)
                    return idx

                if 'ladder_rating' in user:
                    if user['ladder_rating'] == 0:
                        return idx

                    bitm = il.GetBitmap(idx)
                    mdc = wx.MemoryDC(bitm)
                    font = wx.Font(6, wx.FONTFAMILY_ROMAN,
                                       wx.FONTSTYLE_NORMAL,
                                       wx.FONTWEIGHT_NORMAL)
                    mdc.SetFont(font)
                    mdc.SetTextForeground('#FFFFFF')
                    mdc.DrawText(str(user['ladder_rating']), 5, 3)
                    #if user['ladder_rank'] != 0:
                    #    mdc.SetTextForeground('#3399FF')
                    #    mdc.DrawText(str(user['ladder_rank']), 26, 10)
                    #Not enough space anymore
                    mdc.SelectObjectAsSource(wx.NullBitmap)
                        
                    idx = self.bni.add(bitm)
                    draw.append(idx)
                    return idx

                return idx
        def get_icon_idx(self, icon):
                fgsfds = type(icon)
                if fgsfds == tuple:
                        return self.get_lag_idx(icon)
                elif fgsfds == dict:
                        return self.get_bni_idx(icon, self.draw)
                else:
                        return self.icons[icon]
##
##    def upd_header(self, *rest):
##        wx.CallAfter(self.do_upd_header, *rest)
##    def do_upd_header(self, text):
##        self.header.Clear()
##        self.header.AppendText(text)
##
        def add_entry(self, *args, **kwargs):
                wx.CallAfter(self.do_add_entry, *args, **kwargs)
        def do_add_entry(self, *args, **kwargs):
                if ('idx' in kwargs) == False:
                        kwargs['idx'] = self.cview.GetItemCount()

                idx = self.cview.InsertImageStringItem(kwargs['idx'],
                                                            '',
                                                            -1)
                if 'bold' in kwargs:
                        if kwargs['bold']:
                                font = wx.Font(10, wx.FONTFAMILY_DEFAULT,
                                               wx.FONTSTYLE_NORMAL,
                                               wx.FONTWEIGHT_BOLD)
                                self.cview.SetItemFont(idx, font)
                if 'color' in kwargs:
                        self.cview.SetItemTextColour(idx, kwargs['color'])
                if 'bgcolor' in kwargs:
                        self.cview.SetItemBackGroundColour(idx, kwargs['bgcolor'])

                x = 0
                for arg in args:
                        if self.type[x] == 0x02:
                                img_idx = self.get_icon_idx(arg)
                                self.cview.SetItemColumnImage(idx, x, img_idx)
                        else:
                                self.cview.SetStringItem(idx, x, safe_unicode(arg))
                        x += 1

        def upd_entry(self, *args, **kwargs):
                wx.CallAfter(self.do_upd_entry, *args, **kwargs)
        def do_upd_entry(self, idx, *args, **kwargs):
                if 'newidx' in kwargs:
                        self.do_remove_entry(idx)
                        kwargs['idx'] = kwargs['newidx']
                        self.do_add_entry(*args, **kwargs)
                else:
                        if 'color' in kwargs:
                                self.cview.SetItemTextColour(idx, kwargs['color'])
                        if 'bgcolor' in kwargs:
                                self.cview.SetItemBackgroundColour(idx, kwargs['bgcolor'])
                        for x in range(0, len(args), 2):
                                if self.type[args[x]] == 0x02:
                                        icon = self.get_icon_idx(args[x+1])
                                        self.cview.SetItemColumnImage(idx, args[x], icon)
                                else:
                                        self.cview.SetStringItem(idx, args[x], safe_unicode(args[x+1]))

        def remove_entry(self, idx):
                wx.CallAfter(self.do_remove_entry, idx)
        def do_remove_entry(self, idx):
                col = 0
                for kind in self.type:
                        if kind == 0x02:
                                list_item = self.cview.GetItem(idx, col)
                                img_idx = list_item.GetImage()

                                if img_idx in self.draw:
                                        self.bni.remove(img_idx)
                                        self.draw.remove(img_idx)
                        col += 1

                self.cview.DeleteItem(idx)

        def clear(self):
                wx.CallAfter(self.do_clear)
        def do_clear(self):
                self.ordered = []
                #self.header.Clear()
                for x in self.draw:
                        self.bni.remove(x)
                self.draw = []
                self.cview.DeleteAllItems()

##    def menu_add(self, *rest):
##        wx.CallAfter(self.do_menu_add, *rest)
##    def do_menu_add(self, *rest):
##        self.menu = wx.Menu()
##
##        for x in range(0, len(rest), 2):
##            self.menu.Append(self.parent.menu_count, rest[x], '')
##            wx.EVT_MENU(self.parent.frame, self.parent.menu_count, rest[x+1])
##            self.parent.menu_count += 1
##        
##    def __del__(self):
##        for x in self.draw:
##            self.parent.bni.remove(x)
        def load_icons(self, x=28, y=14, **kwargs):
                if kwargs == {}:
                        il = self.bni.il
                        icons = None
                        count = self.bni.count
                    
                else:        
                        il = wx.ImageList(x, y)
                        icons = {}
                        count = 0
                        for k, v in kwargs.iteritems():
                                icons[k] = il.Add(wx.Bitmap(v))
                        count += 1
                        
                return icons, il, count

        def set_status(self, text, **kwargs):
                self.status_bin.update(kwargs)
                if not hasattr(self, 'ibar'):
                       return 
                self.ibar.SetStatusText(text % self.status_bin)
                
	def send_text(self, event):
		text = self.send.GetValue().strip('\n\r').split('\n')
		for msg in text:
                        if msg != '':
                                self.p.pluginConsoleText(msg)
		self.send.Clear()
##	def OnPress(self, event):
##		if event.GetKeyCode() == 13:
##			self.p.queue.addq( self.send.GetLineText(0) )
##			self.send.Clear()
##		else:
##			event.Skip()
		
	def __attr__(self):
		return {
			'name' : 'ui',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Provides a simple interface for the bot.',
			'notes' : '',
			'help' : '',
			'chatexplicit' : False
			}
		
	def __invoke__(self, ID, Length, Data, p):
		if (ID == 0x0A):
			#self.frame.tbicon.icon = wx.Icon("img\\pybot16_cssc.png", wx.BITMAP_TYPE_PNG)
			#self.frame.tbicon.SetIconImage()
			pass
		
	def __cevent__(self, ID, Data, p):
		if (not wxen): return None
		self.p = p
		self.do_upd()
		
		if (ID == 0x00):
			''' CE_UNKNOWN '''
			self.addchat("red", "Unknown chat event.")
		elif (ID == 0x01):
                        if Data['username'].lower() in self.ordered:
                                return
                        Data.update(statstring(Data['text']))
                        
                        if (Data['flags'] & 0x02) == 0x02:
                                self.ordered.insert(0, Data['username'].lower())
                                self.add_entry(Data, Data['username'], (Data['ping'], Data['flags']), Data['clan'], idx=0)
                        else:
                                self.ordered.append(Data['username'].lower())
                                self.add_entry(Data, Data['username'], (Data['ping'], Data['flags']), Data['clan'])
                        
			''' CE_USERINCHANNEL '''
			if Data['username'].lower() == p.plugins.find("bncs").unique.lower():
				#self.addchat("green", "-- There are ", "yellow", str(len(self.ordered)), "green", " users in this channel.")
				self.set_status('Connected (%(server)s) as %(name)s in channel %(chan)s (%(users)d)', users=len(self.ordered))
		elif (ID == 0x02):
                        if Data['username'].lower() in self.ordered:
                                return
                        Data.update(statstring(Data['text']))
                        if (Data['flags'] & 0x02) == 0x02:
                                self.ordered.insert(0, Data['username'].lower())
                                self.add_entry(Data, Data['username'], (Data['ping'], Data['flags']), Data['clan'], idx=0)
                        else:
                                self.ordered.append(Data['username'].lower())
                                self.add_entry(Data, Data['username'], (Data['ping'], Data['flags']), Data['clan'])
			''' CE_USERJOIN '''
			o = support.channelObject( Data['username'], Data['flags'], Data['ping'], Data['text'] )
			self.addchat(
				"green", "-- ",
				"yellow", o.name + " [" + str(o.ping) + "]", 
				"green", " has joined the channel. " + o.infostring
				)
			self.set_status('Connected (%(server)s) as %(name)s in channel %(chan)s (%(users)d)', users=len(self.ordered))
		elif (ID == 0x03):
                        try:
                                idx = self.ordered.index(Data['username'].lower())
                                del self.ordered[idx]
                                #print self.ordered
                        except IndexError:
                                pass
                        else:
                                self.remove_entry(idx)
			''' CE_USERLEAVES '''
			self.addchat(
				"green", "-- ",
				"yellow", Data['username'], 
				"green", " has left the channel."
				)
			self.set_status('Connected (%(server)s) as %(name)s in channel %(chan)s (%(users)d)', users=len(self.ordered))
		elif (ID == 0x04):
			''' CE_WHISPERFROM '''
			self.addchat(
				"#0099CC", "<From ",
				"yellow", Data['username'], 
				"#0099CC", "> ", 
				"gray", Data['text']
				)
		elif (ID == 0x05):
			''' CE_USERTALK '''
			if (Data['text'][0] == "/"):
				return None
				
			ucolor = 'yellow'
			if (p.plugins.find("bncs").unique.lower() == Data['username'].lower()):
				ucolor = 'cyan'
			if ( (Data['flags'] & 0x02) == 0x02):
				ucolor = 'white'
				
			self.addchat(
				"#0099CC", "<",
				ucolor, Data['username'], 
				"#0099CC", "> ", 
				"white", Data['text']
				)
		elif (ID == 0x06):
			''' CE_BROADCAST '''
			self.addchat(
				"#0099CC", "<Battle.net> ", 
				"white", Data['text']
				)
		elif (ID == 0x07):
                        self.clear()
			''' CE_CHANNELJOIN '''
			self.addchat("green", "-- Joined: ", "yellow", Data['text'])
		elif (ID == 0x09):
                        if Data['username'].lower() in self.ordered:
                                ''' CE_USERUPDATE / CE_FLAGSUPDATE '''
                                channel = p.plugins.find("channel")
                                for user in channel.IChannel:
                                        if user.name == Data['username']:
                                                break
                                if user.prevflags != None:
                                        if user.flags != Data['flags']: #channel not yet updated
                                                prevflags = user.flags
                                        else: #updated
                                                prevflags = user.prevflags
                                else:
                                        prevflags = user.flags
                                idx = self.ordered.index(Data['username'].lower())
                                Data.update(statstring(Data['text']))
                                if (prevflags & 0x02) == 0x00 and (Data['flags'] & 0x02) == 0x02:
                                        self.upd_entry(idx, Data, Data['username'], (Data['ping'], Data['flags']), user.clan, newidx=0)

                                        self.ordered.insert(0, self.ordered[idx])
                                        del self.ordered[idx+1]
                                else:
                                        self.upd_entry(idx, 0, Data, 2, (Data['ping'], Data['flags']), 3, user.clan)
                                
			self.addchat(
				"green", "-- ",
				"yellow", Data['username'], 
				"green", " now has flags " + hex(Data['flags']) + "."
				)
		elif (ID == 0x0A):
			''' CE_WHISPERTO '''
			self.addchat(
				"#0099CC", "<To ",
				"yellow", Data['username'], 
				"#0099CC", "> ", 
				"gray", Data['text']
				)
		elif (ID == 0x0D or ID == 0x0F or ID == 0x0E or ID == 0x13):
			''' CE_ERROR '''
			self.addchat("red", Data['text'])
		elif (ID == 0x12):
			''' CE_INFO '''
			self.addchat("#0099CC", Data['text'])
		elif (ID == 0x17):
			''' CE_USEREMOTE '''
			self.addchat(
				"yellow", "<" + Data['username'] + " " + Data['text'] + ">"
				)
		elif (ID == 0x100):
			''' CUSTOM_RAISEADDCHATEVENT '''
			self.addchat(*Data)
