""" support.py

	Contains classes useful to the bot such as config or userlists. """

import ConfigParser, os, sys, datetime, time, re, random, threading, urllib2
import statstring
	
def timestamp():
	return time.strftime("%H:%M:%S")
	
def doprint(text):
	print str(text)
	d = open("logs\\" + str(datetime.date.today()) + ".txt", "a").write("[" + str(datetime.datetime.now().hour) + ":" + str(datetime.datetime.now().minute) + ":" + str(datetime.datetime.now().second) + "] " + str(text) + "\r\n")
	
def now():
	return datetime.datetime.now()
	
def execafter(delay, func):
	t = threading.Timer(delay, func)
	t.start()
	del t
	
def unlame_message():
	d = ["no u", "ORLY", "lolhai", "sup", "deploy lolcats~!", "IMA FIRIN MA LAZOR", "oops", "misclick",
		"lolbai", "peace", "Fwd: The Void", "try again later", "denial", "^^", "noob", "so?", "i no rite",
		"http://www.youtube.com/watch?v=oHg5SJYRHA0", "step back", "not so fast", "gotcha"]
	return d[random.randint(0, len(d)-1)]
	
def trimopbrackets(name):
	if (name[0] == "[" and name[len(name)-1] == "]"):
		return name[1:len(name)-1]
	else:
		return name
	
def swfTime(seconds):
	''' Stopwatch format '''
	s, m, h = (seconds,0,0)
	while s > 60:
		s -= 60
		m += 1
		if m == 60:
			h += 1
			m = 0
	if h > 0:
		return str(h) + ":" + str(m).zfill(2) + ":" + str(s).zfill(2)
	else:
		return str(m) + ":" + str(s).zfill(2)
	
class news():
	def retr(self):
		data = urllib2.urlopen("http://python.bot.nu/pybot/news.txt").read()
		return data
	
def match(text, pattern, mod=re.IGNORECASE):
		''' Instances a lit class so you do not have to constantly declare it. '''
		o = lit()
		return o.match(text, pattern, mod)

def servers(text, e, type="all"):
	''' Returns the internal list of bncs servers as lists within a dictionary. '''
	file = open("bncs_servers.txt", "r").read().replace("\r", "").split("\n")
	gateway = "useast.battle.net"
	ip3 = "0.0.0"
	servers = {}
	for line in file:
		if "|" in line:
			gateway, ip3 = line.split("|")
			servers[gateway] = []
		else:
			servers[gateway].append( ip3 + line )
		
class lit():
	''' Textual help '''
	def __init__(self):
		pass
		
	def regex(self, text, e, mod=re.IGNORECASE):
		if len(e) == "": return ''
		if e[0] == "*":
			expression = "." + e
		else:
			expression = e
			
		try:
			exp = re.compile(expression, mod)
		except:
			exp = re.compile(expression)
		try:
			return str(exp.match(text).group())
		except:
			return ''

	def soundex(self, v, len=4):
		digits = '01230120022455012623010202'
		sndx = ''
		fc = ''

		for c in v.upper():
			if c.isalpha():
				if not fc: fc = c
				d = digits[ord(c)-ord('A')]
				if not sndx or (d != sndx[-1]):
					sndx += d

		sndx = fc + sndx[1:]
		sndx = sndx.replace('0','')
		return (sndx + (len * '0'))[:len]

	def match(self, text, pattern, mod=re.IGNORECASE):
		''' By default it is a non-case-sensative, absolutely no matches comparison '''
		if self.regex(text, pattern, mod) == '':
			return False
		else:
			return True
	
class config():
	''' Reads a configuration file. '''
	def __init__(self, source):
		self.config = ConfigParser.ConfigParser()
		self.path = source
		if not os.path.exists(self.path):
			open(self.path, "w").write("")
			doprint( "Created file %s." % self.path )
		
	def set(self, target, key, value, overwrite=True):
		self.config.read(self.path)
		if not self.config.has_section(target):
			self.config.add_section(target)
		if self.config.has_option(target, key):
			if overwrite == True:
				self.config.set(target, key, value)
		else:
			self.config.set(target, key, value)
		self.config.write(open(self.path, "w"))
			
	def get(self, target, key, default=''):
		self.config.read(self.path)
		try:
			return self.config.get(target, key)
		except:
			return default
			
	def gettype(self, target, key, type='int'):
		self.config.read(self.path)
		try:
			value = self.config.get(target, key)
			if (type == 'int'):
				return int(value)
			elif (type == 'bool'):
				return bool(value)
			elif (type == 'str'):
				return str(value)
			elif (type == 'list'):
				return list(value)
			else:
				return value
		except:
			return 0

class flags():
	''' Lists of possible flag types. '''
	def __init__(self):
		pass
		
	def clanRankIS(self):
		''' ID -> STRING '''
		return {
				0x00: "Peon (probation)",
				0x01: "Peon",
				0x02: "Grunt",
				0x03: "Shaman",
				0x04: "Chieftain"
				}
				
def flipntrim(string): return ''.join(reversed(string)).strip(' \r\n\0')
			
class channelObject():
	''' Handles a user in the channel. '''
	def __init__(self, name, flags, ping, statstring):
		self.name = name
		self.flags = flags
		self.statstring = statstring
		self.ping = ping
		
		''' Only available after a string is parsed. '''
		self.game = 'CHAT'
		self.level = 0
		
		''' Warcraft III and Warcraft III Frozen Throne Explicit '''
		self.w3icon = ''
		self.w3teir = ''
		self.clan = ''
		
		''' Diablo II and Lord of Destruction Explicit '''
		self.d2character = ''
		self.d2realm = ''
		self.d2characternt = []
		
		''' Starcraft and Legacy Explicit '''
		self.data = []
		
		''' ... '''
		self.infostring = self.__parse__() + ")"
		
	def hasFlag(self, flag):
		if (self.flags & int(flag)) == int(flag):
			return True
		else:
			return False
		
	def __parse__(self):
		if (self.statstring == ''):
			return "("
		else:
			s = self.statstring.split(" ")
			self.game = flipntrim(self.statstring[0:4])
			try:
				i = statstring.long_name[self.game] + " ("
			except KeyError:
				return self.statstring + " ("
			
			try:
				if (self.game == "WAR3" or self.game == "W3XP"):
					self.w3icon = s[1]
					self.w3teir = self.w3icon[1]
					self.level = int(s[2])
					i += "level %s with a %s icon" % ( str(self.level), statstring.iconset(self.w3icon, self.game)[self.w3icon] )
					try:
						self.clan = flipntrim(s[3])
						i += ", in Clan " + self.clan
					except:
						pass
				elif (self.game == "STAR" or self.game == "SEXP"):
					self.data = s[1:9]
					i += "Starcraft"
				elif (self.game == "D2XP" or self.game == "D2DV"):
					if len(s) == 1:
						self.d2character = "Open Character"
						i += "No character"
					else:
						self.d2character = s[2]
						self.d2realm = s[1]
						self.d2characternt = s[3:]
						i += self.d2character + " on " + self.d2realm
				elif (self.game == "W2BN"):
					self.data = s[1:9]
					i += "Warcraft II: BNE"
				else:
					doprint( "Code unknown ? " + self.game )
					self.game = "UNKN"
			except:
				#doprint( "* Statstring parse failed: %s: %s" % (self.name, self.statstring)
				pass
				
			return i
			
class userlist():
	''' Handles a list of users with flags and access. '''
	def __init__(self):
		self.db = config("users.ini")
		
	def getAccess(self, username):
		if type(username) == type(''):
			return int(self.db.get("access", username, 0))
		else:
			returns = 0
			access = self.db.config.items("access")
			for key, value in access:
				if self.accessWildcard(username, key):
					print value
					if int(value) > returns:
						returns = int(value)
			return returns
		
	def getFlags(self, username):
		if type(username) == type(''):
			fset = self.db.get("flags", username, "")
		else:
			returns = ""
			access = self.db.config.items("flags")
			for key, value in access:
				if self.accessWildcard(username, key):
					for flag in value:
						if not flag in returns:
							returns += flag
			fset = returns
		if ("i" in fset) and (not "a" in fset):
			return "i"
		else:
			return fset
			
	def accessWildcard(self, user, e):
		try:
			if user.name.lower() == expression.lower():
				return True
		except: pass
			
		try:
			expression = e.lower()
			
			# num
			if (expression == "num"):
				if ("#" in user.name):
					return True
			if ("num|" in expression):
				if "#" in user.name:
					b = user.name.split("#")[1]
					if "@" in b: b = b.split("@")[0]
					if int(b) >= int(expression[4:]):
						return True
						
			# all
			elif (expression == "all"):
				return True
				
			# lag
			elif ("lag|" in expression):
				## Ping
				if (user.ping >= int(expression[4:])):
					return True
					
			# games
			elif ("game|" in expression):
				games = expression[5:].split(",")
				for game in games:
					if (user.game.lower() == game.strip().lower()):
						return True
			elif ("peon" in expression):
				## Warcraft peons
				if (user.icon == "1R3W"): return True
			elif ("icon|" in expression):
				## Any icon ID
				if (user.icon == expression[5:]): return True
			elif ("level|" in expression):
				## Diablo or warcraft level
				pass
			elif ("wins|" in expression):
				## Starcraft victories
				pass
			elif (expression == "noch"):
				## Open diablo character boolean
				pass
			# clan
			elif ("clan|" in expression):
				if (user.clan.lower() == expression[5:].lower()): return True
			elif ("rank|" in expression):
				pass
			# regex
			else:
				if match(user.name, expression):
					return True
			return False
		except:
			print "Compared:"
			print sys.exc_info()
			# regex solution
			if match(user, expression):
				return True
			else:
				return False
		return False
		
	def setAccess(self, username, access, overwrite=True):
		self.db.set("access", username, int(access), overwrite)
		
	def setFlags(self, username, flags, overwrite=True):
		self.db.set("flags", username, flags.lower(), overwrite)
	
	def safelisted(self, username):
		## If a user is safelisted they should not be banned by the bot
		## unless explicitly told to do so
		f = self.getFlags(username)
		if (not "a" in f) and (not "s" in f) and (not self.getAccess(username) > 50):
			return False
		else:
			return True
			
	def shitlisted(self, username):
		## If a user is shitlisted they should be banned by the bot
		## unless explicitly told to remove their b flag.
		f = self.getFlags(username)
		if (not "a" in f) and (not "b" in f):
			return False
		else:
			return True
	
	def flagName(self, flag):
		flags = {
			"a" : "bot admin",
			"b" : "shitlisted", 
			"s" : "safelisted",
			"o" : "operator",
			"i" : "access locked",
			"r" : "rotating shaman"}
			
		if flag in flags:
			return flags[flag]
		else:
			return "?:" + flag
		
class version():
	def __init__(self):
		self.major = 1
		self.minor = 0
		self.revision = 100 #Only really applies to source
		self.beta = 0
		self.hotfix = 0
		self.edition = "Development Edition"
		
	def history(self):
		base = ".: PyBot %i.%i" % (self.major, self.minor)
		
		## Beta release
		if self.beta > 0:
			base = " Beta %i" % self.beta
		## Revised
		if self.revision > 0:
			base += " Revision %i" % self.revision
		## Hotfix
		if self.hotfix > 0:
			base += " Hotfix #%i" % self.hotfix
		## Editions
		if not self.edition == "":
			base += " " + self.edition
			
		return base + " :: by The PyBot Dev Team (http://python.bot.nu/) :."
		
class command():
	def __init__(self, cfg="pybot.ini"):
		self.config = config(cfg)
		self.udb = userlist()
		
	def trigger(self):
		return self.config.get("main", "trigger", ".")
		
	def iscommand(self, string, parent, flag=0x00, flist=[]):
		''' Returns False if the string is not in command format, returns the parsed string if it is. '''
		# Literal
		cmd = string.split(" ")
		# For comparison
		cmdfc = string.lower().split(" ")
		name = parent.plugins.find("bncs").unique.lower()
		if len(flist) > 0:
			trg = flist
		else:
			trg = [self.trigger(),
					"all, ", "bots, ", "pybots, ", name + ", ",
					"all: ", "bots: ", "pybots: ", name + ": "]
			if (flag & 0x02) == 0x02:
				trg.append("ops, ")
				trg.append("ops: ")

		for trigger in trg:
			if (string[:len(trigger)] == trigger.lower()):
				s = string[len(trigger):].split(" ")
				if (len(s) == 1):
					cmd = commandObject(s[0])
				else:
					cmd = commandObject(s[0], s[1:])
				return cmd
		return False
			
class commandObject():
	def __init__(self, name, parameters=''):
		self.name = name
		self.parameters = parameters
		
		c = config("access.ini")
		if (c.get("access", self.name, "NONE") != "NONE"):
			self.hackedaccess = c.gettype("access", self.name, 'int')
		else:
			self.hackedaccess = -1
		
class clan():
	def __init__(self):
		self.members = [] ## All of them
		self.chieftain = ""
		
	def chieftain(self):
		return self.chieftain
		
	def shamans(self):
		shamans = []
		for member in self.members:
			if member.rank == 3:
				shamans.append(member)
		return shamans
		
	def members(self, full=False):
		## full = True if you do not want iniates
		members = []
		for member in self.members:
			if member.rank < 3:
				if full:
					if member.rank > 0: members.append(member)
				else:
					members.append(member)
		return members
		
	def remove(self, name):
		for member in self.members:
			if member.name.lower() == name.lower():
				self.members.remove(member)
				return True
		return False
		
	def find(self, name):
		for member in self.members:
			if member.name.lower() == name.lower():
				return member
		return None
		
	def modify(self, name, new):
		for member in self.members:
			if member.name.lower() == name.lower():
				member = new
				return True
		return False
	
class clanObject():
	def __init__(self, name, rank, online=False, location=''):
		self.name = name
		self.rank = rank
		self.online = online
		self.location = location
		
	def status(self):
		if self.online:
			s = "online"
		else:
			s = "offline"
		return s
		
class ssparser():
	''' Parses user statstrings and converts flags into human-readable strings. '''
	def __init__(self):
		pass