
""" channel.py

	Battle.net channel(s).
		
	"""
	
import buffer, language, support
	
class exposed():
	def __init__(self, parent):
		''' Contains the default channels after 0x0B is recieved. '''
		self.GChannels = [] # Internal list of channels.
		
		''' Internal '''
		self.IChannel = [] # Internal channel list.
		self.IPopulation = (0, 0) # This seems useless, but may be very helpful for PvPGN bots.
		
	def __attr__(self):
		return {
			'name' : 'channel',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Handles Battle.net channels.',
			'notes' : 'This class should generally not be edited.',
			'help' : '',
			'chatexplicit' : False
			}
			
	def __invoke__(self, ID, Length, Data, p):
		tr = language.english()
		b = buffer.pin()
		b.unbuild(Data)
		
		if (ID == 0x0B):
			''' SID_CHANNELLIST '''
			support.doprint( "Recieving list..." )
			self.GChannels = []
			last = " "
			while (len(last) > 0):
				last = b.getString()
				if not last == "": self.GChannels.append( last )
		
	def countops(self):
		c = 1
		for user in self.IChannel:
			if user.hasFlag(0x02):
				c += 1
		return c
		
	def GetUserByExpression(self, e):
		for u in self.IChannel:
			if u.name.lower() == e.lower():
				return u
		for u in self.IChannel:
			if support.match(u.name, e):
				return u
		return None
		
	def __cevent__(self, ID, Data, p):
		if (ID == 0x01) or (ID == 0x02):
			''' CE_USERINCHANNEL or CE_USERJOINS '''
			for u in self.IChannel:
				if u.name == Data['username']:
                                        u.prevflags = None
					u.flags = Data['flags']
					u.statstring = Data['text']
					u.__parse__()
					return None

			self.IChannel.append( support.channelObject( Data['username'], Data['flags'], Data['ping'], Data['text'] ) )
		elif (ID == 0x03):
			''' CE_USERLEAVES '''
			for o in self.IChannel:
				if (o.name == Data['username']):
					self.IChannel.remove(o)
		elif (ID == 0x09):
			''' CE_USERUPDATE / CE_FLAGSUPDATE '''
			for o in self.IChannel:
				if (o.name == Data['username']):
                                        o.prevflags = o.flags
					o.flags = Data['flags']
					o.statstring = Data['text']
					o.__parse__()
			
		elif (ID == 0x12):
			if self.IPopulation == ():
				''' Server populus '''
				if support.match(Data['text'], "There are currently*users playing*"):
					part = Data['text'].split(", and ")[1].split(" games on Battle.net")[0].split(" ")
					self.IPopulation = (int(part[0]), int(part[3]))
		elif (ID == 0x07):
			''' CE_CHANNELJOIN '''
			self.IChannel = []
