
""" op.py

	Operator commands.
		
	"""
	
	
""" README

	--> Queue Types
	
		normal
			* Queue progresses like a stress bar:
				- First message is instant
				- Following messages add to 'stress' on the queue, making it wait longer
				- A busy queue can max 'stress' and just become periodic
				- The queue cools down when not busy
			* Best for chatting
		burn
			* Burns sections of the queue at a time:
				- Takes between 1 and 5 messages and sends them in a burst
				- Depending on the size, it will wait anywhere between 2 and 25 seconds to burst again
			* Best for sending many small messages quickly
	
	--> Ban Types

	''' Loadban '''
	Bans bots as quickly as possible while trying to avoid dropping.
	
	Ideal for banning loads when (it is):
		* The fastest in the channel (no Forsakens to double ban)
		* Grouped with StealthBots
		* Alone
		
	''' Mass tag ban '''
	Queues a list of bots and bans all of them when filled.
	
	Ideal for banning loads when:
		* With other PyBots in Mass tag ban mode
		* The other ops are not banning fast enough
		* You don't care if the bots can say their text
		* The load is big
		
	''' Match ban '''
	Bans bots matching the pattern when possible via the queue.
	
	Ideal for banning loads when:
		* There are other bots banning quickly
		* You need a bot to pick up the bans the others are not doing



	How to use ban expressions:
	
		The bot not only supports regex patterns like:
			spambot_*   -Ban names starting with spambot_
			.*spambot*  -Ban names with spambot in it
			.*#*        -Ban numbered names (num word is just as good)
			.*#*[2468]  -Bans even-numbered [sic] numbered accounts
		
		but also 'magic' words:
			lag|x - X being the ping to ban
			lag - Determine the average ping of those being banned
			num - Bans numbered accounts only
			all - Bans everyone that isn't safelisted
			gen - Bans users with conspicuously bot-like names
				* This includes: lack of spacers, random interjectory numbers, obviously alternating text case
			game|id - Bans all users using the game code
			peon - Bans warcraft peons
			icon|id - Bans all users using the icon code
			
	"""
	
import support, default, sys, random, time
	
class exposed():
	def __init__(self, parent):
		self.p = parent
		self.udb = support.userlist()
		
		self.config = support.config("pybot.ini")
		self.config.set("op", "detect", "yes", False)
		
		''' Load detection '''
		self.jps = 0
		self.jpst = support.now()
		
		''' Record keeping '''
		self.bansc = 0
		self.reg = support.lit()
		self.match = ''
		self.bantime = support.now()
		self.ci = []
		self.bans = {}
			# banned, by operator
		
								# (total, amt)
		self.load_average_ping = (0, 0)
		
		''' Loadban '''
		self.loadban = False
		self.loadban_aggro = 0
		self.loadban_tol = 5
		self.loadban_calm = 18
		self.loadban_adr = 5
		
		''' Channelban '''
		self.cbstream = False
		self.cbs = False
		self.cbtarg = ''
		self.cblist = []
		self.cbshuffle = True
		
		''' Matchban '''
		self.matchban = False
		
	def __attr__(self):
		return {
			'name' : 'op',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Does simple op commands.',
			'notes' : '',
			'help' : '',
			'chatexplicit' : True
			}
		
	def createCI(self):
		self.ci = []
		for user in self.p.plugins.find("channel").IChannel:
			self.ci.append(user.name)
		
	def findce(self, usernames):
		''' Tries to find common expressions in load names. '''
		pass
		
	def execloadban(self, u, msg="Loadban", q='instant'):
		''' msg = Message to ban with
			q = queue type, you can use:
				instant (instantly send)
				q (send with queue)
				overloaded (send using brother client)
			
			By sending the user object, we can do some neat
			'intelligent' tricks like modify the ban to match
			pings.
			'''
			
		if q == 'instant':
			## Bans as fast as you can get data across the internet.
			self.p.queue.instant("/ban " + u.name + " " + msg + ") (" + str(self.bansc))
		elif q == 'overloaded':
			## Sends a ban to another bot using their queue.
			if self.parent.family.oldest(self.parent) and self.parent.family.brothers() > 0:
				m = self.parent.family.brother(self.parent, True)
				if m.cfgfile == self.parent.cfgfile:
					print "Overloaded loadban queue failed to forward: we got out own object back"
					return ''
			else:
				print "Overloaded loadban queue failed to forward: no other bots to send with"
				return ''
			m.queue.addq("/ban " + u.name + " " + msg + ") (from " + self.p.plugins("bncs").unique + ") (" + str(self.bansc))
		elif q == 'q' or q == 'hp':
			## Bans using the queue.
			self.p.queue.addq("/ban " + u.name + " " + msg + ") (" + str(self.bansc), 0)
			
		self.bansc += 1
		self.bantime = support.now()
		self.loadban_aggro += 1
		# Load avg ping
		total, amt = self.load_average_ping; self.load_average_ping = ( (total + u.ping), (amt + 1) )
		print (total / amt)
		
	def clearvar(self):
		self.bantime = support.now()
		self.mtb = []
		self.loadban = False
		self.mtb = False
		
	def userobjectIs(self, e, user):
		if (user.name in self.ci): return None
		
		expression = e.lower()
		if (expression == "num"):
			if ("#" in user.name):
				return True
			else:
				return False
		elif (expression == "all"):
			return True
		elif (expression == "gen"):
			vowels = ["a", "e", "i", "o", "u"]
			## Detect randomly generated names.
			jumps = 0
			for c in user.name.lower():
				if not (self.reg.match(c, "[_-@#]")):
					if not (c in vowels):
						# Consonant
						jumps += 1
					else:
						jumps = 0
				else:
					jumps -= 1
					if jumps <= 0: jumps = 0
					
				if jumps >= 4: ## No base word in the english language has 4 consonants in a row
					print "ISGENERATED",user.name
					return True
			print "j",jumps
		elif ("lag|" in expression):
			if (user.ping >= int(expression[4:])):
				return True
			else:
				return False
		elif (expression == "lag"):
			total, amt = self.load_average_ping
			if amt > 0:
				average = (round(total / amt, 0) - 25)
				if average > 500: average = 500
			else:
				average = 200
			if amt < 10:
				if user.ping >= 200:
					return True
			else:
				if user.ping >= average:
					return True
		elif ("game|" in expression):
			games = expression[5:].split(",")
			for game in games:
				if (user.game.lower() == game.strip().lower()):
					return True
			return False
		elif ("peon" in expression):
			if (user.icon == "1R3W"): return True
		elif ("icon|" in expression):
			if (user.icon == expression[5:]): return True
		elif ("clan|" in expression):
			if (user.clan.lower() == expression[5:].lower()): return True
		else:
			if self.reg.match(user.name, expression):
				return True
			else:
				return False
		return False
			
		
	def __ban__(self, uObj):
		u = uObj.name
		last = int((support.now() - self.bantime).seconds)
		
		if self.loadban:
			print "AGGRO: " + str(self.loadban_aggro)
			if self.userobjectIs(self.match, uObj):
				if not self.udb.safelisted(u):
					''' Calculate cooldown '''

					if (last >= self.loadban_adr) and (self.loadban_aggro <= 5):
						if (last >= (self.loadban_adr * 3)):
							self.loadban_aggro =- 3
							print "SUPPRESS HEAVY %i" % self.loadban_aggro
						if (last >= (self.loadban_adr * 2)):
							self.loadban_aggro =- 2
							print "SUPPRESS MEDIUM %i" % self.loadban_aggro
						elif (last >= self.loadban_adr):
							self.loadban_aggro =- 1
							print "SUPPRESS LIGHT %i" % self.loadban_aggro
						if self.loadban_aggro <= 0: self.loadban_aggro = 0

					if (self.loadban_aggro <= self.loadban_tol):
						self.execloadban(uObj)
					else:
						if (last >= self.loadban_calm):
							self.loadban_aggro = 0
							self.execloadban(uObj)
							for user in self.p.plugins.find("channel").IChannel:
								self.__ban__(user)
							print "CALM"
						else:
							self.execloadban(uObj, q="overloaded")
		elif self.matchban:
			if self.userobjectIs(self.match, uObj):
				if not self.udb.safelisted(u): self.execloadban(uObj, msg="Matchban", q='q')
		else:
			''' No ban mode '''
			return False
		return True
		# }
				
		
	def __command__(self, COMMAND, o, source='~local', origin=4):
		''' You don't need to use this system. '''
		CMD = COMMAND
		if (not COMMAND.lower() in default.commands()):
			''' has Alias? '''
			if (COMMAND.lower() in default.aliases()):
				''' Yup. '''
				CMD = default.aliases()[COMMAND.lower()]
			else:
				''' Nope. '''
					
		p = self.p
		par = o.parameters
		
		access = self.udb.getAccess(source)
		flags = self.udb.getFlags(source)
		
		if "a" in flags: access = 200
		if (source == "~console"): access=201
		
		if (not CMD.lower() in default.commands()):
			return ''
		if (not access >= default.commands()[CMD.lower()]):
			return ''
		
		p.veto = True
		if (CMD == "loadban"):
			p.queue.padq(3)
			try:
				if par[0] == "?":
					return "Loadban [%s] \"%s\" {%i temporarily safelisted}" % (str(self.loadban), self.match, len(self.ci))
				else:
					self.clearvar()
				self.match = par[0]
				self.loadban = True
				self.loadban_aggro = 2
				self.createCI()
				return "Loadban enabled, match: " + self.match
			except:
				self.ci = []
				self.loadban = False
				return "Loadban disabled."
		if (CMD == "matchban"):
			p.queue.padq(3)
			try:
				if par[0] == "?":
					return "Match ban [%s] \"%s\" {%i temporarily safelisted}" % (str(self.matchban), self.match, len(self.ci))
				else:
					self.clearvar()
				self.match = par[0]
				self.matchban = True
				self.createCI()
				return "Match ban enabled, match: " + self.match
			except:
				self.ci = []
				self.matchban = False
				return "Match ban disabled."
		if (CMD == "queuetype"):
			try:
				p.queue.type = par[0]
				return "Queue type set to %s." % p.queue.type
			except:
				return "Queue is currently set to %s." % p.queue.type
		if (CMD == "cb"):
			try:
				self.cbtarg = ' '.join(par[0:])
				self.cbs = True
				self.cblist = []
				p.queue.addq( "/who " + self.cbtarg )
				return ''
			except:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
		if (CMD == "kick") or (CMD == "ban"):
			try:
				safe = 0
				expression = par[0]
				try:
					msg = ' '.join(par[1:])
				except:
					msg = expression
				bans = 0
				for usere in p.plugins.find("channel").IChannel:
					if self.userobjectIs(expression, usere):
						if not self.udb.safelisted(usere.name):
							p.queue.addq( "/%s %s %s" % (CMD.lower(), usere.name, msg) )
							bans += 1
						else:
							safe += 1
				if (safe > 0):
					return "Failed to remove %i users because they are safelisted." % safe
				if not (bans > 0):
					p.queue.addq( "/%s %s %s" % (CMD.lower(), expression, msg) )
				return ''
			except:
				print sys.exc_info()
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
		if (CMD == "unban"):
			try:
				expression = par[0]
				unbans = 0
				for banned, op in self.bans.items():
					if self.reg.match(banned, expression):
						p.queue.addq( "/unban %s" % banned )
						unbans += 1
				if unbans == 0:
					p.queue.addq( "/unban %s" % expression )
				return ''
			except:
				print sys.exc_info()
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
		if (CMD == "bancount"):
			print self.bans
			try:
				oper = par[0]
				bc = 0
				for banned, op in self.bans.items():
					print banned,op
					if oper.lower() == op.lower():
						oper = op
						bc += 1
				return "Since I joined this channel, %s has banned %i users." % (oper, bc)
			except: pass
			return "Since I joined this channel, %i users have been banned." % len(self.bans)
		if (CMD == "sleep"):
			self.clearvar()
			return "All bans disabled."
		if (CMD == "family"):
			if p.family.brothers() > 0:
				info = "Bots in this family: "
				for bro in p.family.children:
					u = bro.plugins.find("bncs").me
					info += u.name + " (Queue: " + str(bro.queue.bytes) + "b) (Trigger \"" + bro.config.get("main", "trigger") + "\"); "
				return info[:len(info)-2]
			else:
				return "I am an only child."
		else:
			p.veto = False
			return ''
		
	def cb_timer(self):
		self.cbs = False
		self.cbstream = False
		c = 0
		if self.cbshuffle: random.shuffle(self.cblist)
		self.p.plugins.find("ui").addchat("#0099CC", "Banning %i users from %s." % (len(self.cblist), self.cbtarg))
		for user in self.cblist:
			c += 1
			self.p.queue.addq("/ban " + user)
		self.cbtarg = ''
		
	def __cevent__(self, ID, Data, p):
		if (ID == 0x101):
			id = Data[3]
			s = self.__command__(Data[2].name, Data[2], source=Data[0], origin=id)
			if not s == '':
				if (id == 1):
					p.queue.addq( s )
				if (id == 2):
					p.queue.addq( "/me %s" % s )
				if (id == 3):
					p.queue.addq( "/w %s %s" % (Data[0], s) )
				if (id == 4):
					p.plugins.find("ui").addchat( "#0099CC", "<from Operator> ", "gray", s)
				if (id == 5):
					p.queue.addq( s )
		elif (ID == 0x02):
			''' CE_USERJOIN '''
			o = support.channelObject( Data['username'], Data['flags'], Data['ping'], Data['text'] )
			if self.__ban__(o):
				return None
			
			last = int((support.now() - self.jpst).seconds)
			self.jps += 1
			if (last > 5):
				self.jps = 0
			else:
				if (self.jps >= 5) and (self.match == ''):
					print "LOAD DETECTION: turning on matchban... [250 ping]"
					self.match = "lag|250"
					self.matchban = True
			self.jpst = support.now()
			
			if self.udb.shitlisted(Data['username']):
				p.queue.instant( "/ban %s %s" % (Data['username'], "Flags B") )
		elif (ID == 0x03):
			for banned, op in self.bans.items():
				if op == Data['username']:
					del self.bans[banned]
		elif (ID == 0x0D or ID == 0x0F or ID == 0x0E or ID == 0x13):
			''' CE_ERROR '''
			if self.cbs:
				if (Data['text'] == "That channel does not exist.") or (Data['text'] == "You do not have permission to view that channel."):
					self.p.queue.addq( "I can not see %s." % self.cbtarg )
					self.cbs = False
		elif (ID == 0x12):
			if (support.match(Data['text'], ".* was banned by *")):
				parts = Data['text'].split(" ")
				self.bans[parts[0]] = parts[4].rstrip(".")
			elif (support.match(Data['text'], ".* was unbanned by *")):
				parts = Data['text'].split(" ")
				del self.bans[parts[0]]
			if self.cbs:
				if (Data['text'].find("Users in channel") != -1):
					channel = Data['text'].split("Users in channel ")[1]
					channel = channel[:len(channel)-1]
					print channel
					if channel.lower() == self.cbtarg.lower():
						self.cbstream = True
						self.cbtarg = channel
						lag = float(self.p.plugins.find("channel").countops()) + 0.50
						support.execafter( lag, self.cb_timer)
				elif self.cbstream:
					tup = Data['text'].split(" ")
					if len(tup) == 2:
						if "," in tup[0]:
							self.cblist.append( support.trimopbrackets(tup[0][:len(tup[0])-1]) )
							self.cblist.append( support.trimopbrackets(tup[1]))
					elif len(tup) == 1:
						self.cblist.append( support.trimopbrackets(tup[0]))
			# }
