
""" general.py

	General bot functions and commands.
		
	"""
	
import support, default, sys, winamp, random
import __builtin__

disabled_names = list(set(dir(__builtin__)) ^\
                 set(['True', 'False', 'None', 'abs', 'all', 'any', 'apply',
                      'basestring', 'bin', 'bool', 'bytearray', 'bytes',
                      'callable', 'chr', 'cmp', 'complex', 'copyright',
                      'credits', 'dict', 'dir', 'divmod', 'enumerate', 'filter',
                      'float', 'format', 'frozenset', 'hash', 'help', 'hex',
                      'id', 'int', 'isinstance', 'issubclass', 'iter', 'len',
                      'license', 'list', 'long', 'map', 'max', 'min', 'oct',
                      'ord', 'pow', 'range', 'reduce', 'repr', 'reversed',
                      'round', 'slice', 'sorted', 'str', 'sum', 'tuple', 'type',
                      'unichr', 'unicode', 'xrange', 'zip', 'set']))
disabled_builtins = dict(zip(disabled_names, (None,) * len(disabled_names)))
	
class exposed():
	def __init__(self, parent):
		self.p = parent
		self.udb = support.userlist()
		self.cfg = support.config("pybot.ini")
		
	def __attr__(self):
		return {
			'name' : 'cmd',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Does simple chat commands.',
			'notes' : '',
			'help' : '',
			'chatexplicit' : True
			}
		
	def __command__(self, COMMAND, o, source='~local', origin=4):
		''' You don't need to use this system. '''
		CMD = COMMAND
		if (not COMMAND.lower() in default.commands()):
			''' has Alias? '''
			if (COMMAND.lower() in default.aliases()):
				''' Yup. '''
				CMD = default.aliases()[COMMAND.lower()]
			else:
				''' Nope. '''
					
		print "Assumed: " + CMD
					
		p = self.p
		par = o.parameters

		access = self.udb.getAccess(source)
		flags = self.udb.getFlags(source)
		
		if ("a" in flags): access = 200
		if (source == "~console"): access=201
		
		if (not CMD.lower() in default.commands()):
			return ''
		if (not access >= default.commands()[CMD.lower()]):
			return ''
		
		space = ""
		if access < 80: space = ' '
		
		p.veto = True
		if (CMD == "say"):
			p.queue.addq(space + ' '.join(par))
			return ''
		elif (CMD == "yell"):
			p.queue.addq(space + ' '.join(par).upper())
			return ''
		elif (CMD == "whois"):
			try:
				user = None
				for u in p.plugins.find("channel").IChannel:
					if u.name.lower() == par[0].lower():
						user = u
				typer = "cumulative"
				if user == None: user = par[0]; typer = "defined"
				a = self.udb.getAccess(user)
				f = self.udb.getFlags(user)
				if a > 0:
					return par[0] + " has " + typer + " access " + str(a) + " and flags \"" + str(f) + "\"."
				else:
					return "No one found by that name or any user matching database wildcards."
			except:
				print sys.exc_info()
				return "You need to supply a username."
		elif (CMD == "whoami"):
			user = None
			for u in p.plugins.find("channel").IChannel:
				if u.name.lower() == p.plugins.find("bncs").unique.lower():
					user = u
			typer = "cumulative"
			if user == None: user = par[0]; typer = "defined"
			a = self.udb.getAccess(user)
			f = self.udb.getFlags(user)
			if a > 0:
				return "You have " + typer + " access " + str(a) + " and flags \"" + str(f) + "\"."
			else:
				return "You have no access or flags."
		elif (CMD == "set"):
			tacc = self.udb.getAccess(par[0])
			tfla = self.udb.getFlags(par[0])
			try:
				newacc = int(par[1])
			except: return "Parameters missing."
			try:
				newfla = par[2]
			except:
				newfla = "!"
				
			if (newacc >= access) or (tacc >= access) or (newacc > 200) or (newacc < 0):
				return "You do not have enough access to do that."
				
			rest = '.'
			if not newfla == "!":
				self.udb.setFlags(par[0], newfla.lower())
				rest = " and flags \"" + par[2] + "\"."
			self.udb.setAccess(par[0], newacc)
			return par[0] + " now has access " + par[1] + rest
		elif (CMD == "rem"):
			try:
				tacc = self.udb.getAccess(par[0])
			except:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
			if (tacc >= access):
				return "You do not have enough access to do that."
			else:
				self.udb.setAccess(par[0], 0)
				self.udb.setFlags(par[0], '')
				return "Removed " + par[0] + " from the local database."
		elif (CMD == "version"):
			version = support.version()
			return version.history()
		elif (CMD == "cq"):
			p.queue.queue = []
			return "Queue cleared. {%ib}" % p.queue.bytes
		elif (CMD == "scq"):
			p.queue.queue = []
			return ''
		elif (CMD == "where"):
			me = p.plugins.find("bncs").me
			if me.hasFlag(0x02):
				duty = "an operator of"
			else:
				duty = "talking in"
			return "I am " + duty + " " + p.plugins.find("bncs").mychannel + " (" + str(len(p.plugins.find("channel").IChannel)) + " users) with flags " + hex(me.flags) + "."
		elif (CMD == "quit"):
			print "Quit by command"
			p.destroy()
			sys.exit()
		elif (CMD == "plugins"):
			# god damn swent
			retr = []
			for plugin in self.p.plugins.all():
				retr.append(plugin.info['name'])
			return str(retr).replace("'", "")
		elif (CMD == "roll"):
			if len(par) == 0:
				return "Random number between 1 and 100: %i" % random.randint(1, 100)
			elif len(par) == 1:
				try:
					val = int(par[0])
					return "Random number between 1 and %i: %i" % (val, random.randint(1, val))
				except:
					return "Invalid number."
			elif len(par) >= 2:
				try:
					val = int(par[0])
					val2 = int(par[1])
					return "Random number between %i and %i: %i" % (val, val2, random.randint(val, val2))
				except:
					return "Invalid numbers."
		elif (CMD == "shuffle"):
			items = []
			for p in par:
				if len(p) > 0:
					items.append(p)
			random.shuffle(items)
			try:
				return "Randomly shuffled list: " + ", ".join(items)
			except:
				pass
		elif (CMD == "choice"):
			items = []
			for p in par:
				if len(p) > 0:
					items.append(p)
			try:
				return "Random item from list: " + random.choice(items)
			except:
				pass
		elif (CMD == "flip"):
			if random.randint(1, 100) > 50:
				return "Heads."
			else:
				return "Tails."
		elif (CMD == "exec"):
			evalutation = ' '.join(par[:])
			try:
				val = str(eval(evalutation, disabled_builtins))
				if (len(val) > 210) and (access < 100):
					return "Your math evaluation was too long to display."
				else:
					return space + val
			except:
				return "An error has occured, please make sure it is a valid math command."
				print "More error info:"
				print sys.exc_info()
		elif (CMD == "soundex"):
			lit = support.lit()
			try:
				a = lit.soundex(par[0])
				b = lit.soundex(par[1])
				if a == b:
					return "Values sound alike. (%s, %s)" % (a, b)
				else:
					return "Values sound different. (%s, %s)" % (a, b)
			except:
				print sys.exc_info()
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 2)
		elif (CMD == "join"):
			try:
				if not p.plugins.find("bncs").mychannel.lower() == ' '.join(par[0:]).lower():
					p.queue.addq( "/join %s" % ' '.join(par[0:]) )
					return ''
			except:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
		elif (CMD == "home"):
			p.queue.addq( "/join %s" % self.p.config.get("main", "home", "The Void"))
			return ''
		elif (CMD == "rejoin"):
			if p.plugins.find("bncs").me.hasFlag(0x02):
				p.queue.addq( "/rejoin" )
			else:
				location = p.plugins.find("bncs").mychannel
				p.queue.instant( "/join Rejoin %s" % location )
				p.queue.instant( "/join %s" % location )
			return ""
		elif (CMD == "accept") or (CMD == "decline"):
			try:
				tag = par[0]
			except: return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
			for invite in p.plugins.find("clan").i_pending:
				if invite.tag.lower() == tag.lower():
					p.plugins.find("clan").i_pending.remove(invite)
					if CMD == "accept":
						p.send(invite.accept())
						return "Invitation to " + invite.name + " has been accepted."
					else:
						p.send(invite.decline())
						return "Invitation to " + invite.name + " has been declined."
			return "No clans have invited me with that tag."
		else:
			try:
				if (CMD == "next"):
					p.winamp.doCommand(40048)
					return "Skipped to %s." % self.formatMP3string()
				elif (CMD == "back"):
					p.winamp.doCommand(40044)
					return "Skipped to %s." % self.formatMP3string()
				elif (CMD == "mp3"):
					return "Now Playing: %s" % self.formatMP3string()
			except winamp.WinampError:
				return "Winamp is not loaded."
			except TypeError:
				return "Error has occured in Winamp."
			
			p.veto = False
			return ''
		p.veto = True
		return ''
		
	def formatMP3string(self):
		length = self.p.winamp.getCurrentTrackLength()
		elap = self.p.winamp.getCurrentTrackPos()
		runtime = str(round((elap / length) * 100, 1)) + "%"
		volume = str(round((self.p.winamp.getVolume() / 255.0) * 100, 0)).replace(".0", "") + "%"
		return "%s (%s runtime @ %s volume)" % (self.p.winamp.getCurrentTrackName(), support.swfTime(length), volume)
		
	def __cevent__(self, ID, Data, p):
		if (ID == 0x101):
			id = Data[3]
			s = self.__command__(Data[2].name, Data[2], source=Data[0], origin=id)
			if not s == '':
				if (id == 1):
					p.queue.addq( s )
				if (id == 2):
					p.queue.addq( "/me %s" % s )
				if (id == 3):
					p.queue.addq( "/w %s %s" % (Data[0], s) )
				if (id == 4):
					p.plugins.find("ui").addchat( "#0099CC", "<from Console> ", "gray", s)
				if (id == 5):
					p.queue.addq( s )
		elif (ID == 0x103):
			print Data
