
""" bncs.py

	Battle.net Connection Sequence
	
	Supports:
		* WarCraft 3
		
	"""
	
import buffer, support, language
import bnls, wx, time, random
	
class exposed():
	def __init__(self, parent):
		self.out = buffer.pout()
		self.config = support.config(parent.cfgfile)
		
		self.mychannel = "The Void"
		self.me = support.channelObject( '~' + self.config.get("main", "username", "PyBot"), 0x00, 0, self.config.get("main", "game", "3RAW") )
		
		''' PRELOADS '''
		self.server = self.config.get("main", "bncs", "europe.battle.net")
		self.username= self.config.get("main", "username")
		self.password = self.config.get("main", "password")
		self.cdkey = self.config.get("main", "cdkey")
		self.expcdkey = self.config.get("main", "expcdkey")
		self.platform = self.config.get("main", "platform", "68XI")
		self.gameID = self.config.get("main", "game", "3RAW")
		self.gameVB = self.config.gettype("main", "verbyte", "int")
		self.location = self.config.get("main", "originfull", "United States")
		self.locationID = self.config.get("main", "origin", "USA")
		self.home = self.config.get("main", "home", "")
		
		''' HOLDS CONNECTION INFORMATION '''
		self.servertoken = ''
		self.mpqfiletime = ''
		self.clienttoken = ''
		self.SEPCookie = -1
		
		''' HOLDS LAST REFERENCED PARENT OBJECT '''
		self.p = parent
		
		#support.doprint( "Loading BNCS as " + self.username + " from " + self.locationID + " (" + self.location + ".)" )
		#support.doprint( "Connecting as a " + self.gameID + " () with verbyte " + hex(self.gameVB) + "." )
		
	def __attr__(self):
		return {
			'name' : 'bncs',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Logs into Battle.net and handles it\'s data.',
			'notes' : 'This class should generally not be edited.',
			'help' : '',
			'chatexplicit' : False
			}
			
	def log_out(self, text):
		support.doprint( "[BNCS] %s" % text )
			
	def __invoke__(self, ID, Length, Data, p):
		tr = language.english()
		b = buffer.pin()
		b.unbuild(Data)
		self.p = p
		
		Unhandled = [0x75, 0x0B, 0x00]
		if (ID == 0x104):
			self.bnls = bnls.BNLS(self.config.get("main", "bnls", "pyro.no-ip.biz"), self.p.cfgfile)
			self.bnls.connect()
			''' CUSTOM_CONNECTIONESTABLISHED 
				* Note: The core sends the protocol ID.
			'''
			self.out.insertDWord(0)
			self.out.insertRawData(self.platform)
			self.out.insertRawData(self.gameID)
			self.out.insertDWord(self.gameVB) #version byte
			self.out.insertDWord(0)
			self.out.insertDWord(0)
			self.out.insertDWord(0)
			self.out.insertDWord(0)
			self.out.insertDWord(0)
			self.out.insertString(self.locationID)
			self.out.insertString(self.location)
			p.send(self.out.build(0x50))
			p.pluginSay(0x100, "green", "[BNET] Connected!" )
		elif (ID == 0x101):
			''' CUSTOM_CONNECTIONTERMINATED '''
			pass
		elif (ID == 0x102):
			''' CUSTOM_CORE_ERROR '''
			pass
		elif (ID == 0x103):
			''' CUSTOM_BNLSANGRY '''
			pass
		elif (ID == 0x104):
			''' CUSTOM_BNFTPACTION '''
			pass
		elif (ID == 0x25):
			''' SID_PING '''
			self.out.insertDWord(b.getDWord())
			p.send(self.out.build(0x25))
		elif (ID == 0x50):
			''' SID_AUTH_INFO '''
			self.bnls.nls = b.getDWord()
			self.servertoken = b.getDWord()
			b.getDWord()
			self.mpqfiletime = b.getRawData(8)
			mpqinfo = (b.getString(), b.getString())

			hash = self.bnls.hashcdkey(self.servertoken, self.cdkey)
			if hash == '':
                                self.p.pluginSay(0x100, "red",  "[BNCS] CDKey hashing failed, please check the key")
				self.log_out("CDKey hashing failed, please check the key")
				return ''
			else:
				self.clienttoken = hash[0]
			checksum = self.bnls.gamechecksum(0x07, self.mpqfiletime, mpqinfo[0], mpqinfo[1])
			if checksum == '':
                                self.p.pluginSay(0x100, "red",  "[BNCS] Checksum failure")
				self.log_out("Checksum failure")
				return ''
			
			self.out.insertDWord(self.clienttoken) #clienttoken
			self.out.insertDWord(checksum[0]) #exe version
			self.out.insertDWord(checksum[1]) #hash
			self.out.insertDWord(1) #cdkey count
			self.out.insertDWord(0) #spawn?
			self.out.insertRawData(hash[1]) #9x long
			self.out.insertString(checksum[2]) #cdkey info
			self.out.insertString('PyBot: %s' % self.username) #owner
			p.send(self.out.build(0x51))
			p.pluginSay(0x100, "yellow", "[BNET] Sending authorization.")
		elif (ID == 0x51):
			''' SID_AUTHCHECK '''
			result = b.getDWord()
			info = tr.SID_AUTHCHECK()
			if result in info:
				if result == 0:
					p.pluginSay(0x100, "green", "[BNET] Authorized.")
					support.doprint( "[BNET] Authorized!" )
					logondata = self.bnls.logonchallenge(self.username, self.password)
					self.out.insertRawData(logondata)
					self.out.insertString(self.username)
					p.send(self.out.build(0x53))
				else:
					msg = info[result] % {'info': b.getString()}
					support.doprint( "[BNET] " + msg)
					p.pluginSay(0x100, "red", "[BNET] " + msg)
			else:
                                self.p.pluginSay(0x100, "red",  "[BNCS] Unknown version check response in 0x51. Check game verbytes.")
				self.log_out("Unknown version check response in 0x51. Check game verbytes.")
		elif (ID == 0x53):
			''' SID_AUTH_ACCOUNTLOGON (WarCraft) '''
			result = b.getDWord()
			info = tr.SID_AUTHCHECK()
			if result in info:
				if result == 0:
					salt = b.data[4:]
					proof = self.bnls.logonproof(salt)
					self.out.insertRawData(proof)
					p.send(self.out.build(0x54))
					self.p.pluginSay(0x100, "yellow",  "[BNCS] Sending logon proof...")
					self.log_out("Sending logon proof...")
					#p.plugins.find("ui").frame.tbicon.icon = wx.Icon("img\\pybot32_orange.png", wx.BITMAP_TYPE_PNG)
					#p.plugins.find("ui").frame.tbicon.SetIconImage()
				elif result == 1:
					salt = self.bnls.create(self.username, self.password)
					self.log_out("Recieved salt code from BNLS...")
					self.out.insertRawData(salt)
					self.out.insertString(self.username)
					p.pluginSay(0x100, "red", "[BNET] Account does not exist.")
					p.pluginSay(0x100, "yellow", "[BNET] Creating account...")
					p.send(self.out.build(0x52))
			else:
				self.log_out("Unknown login response in 0x53.")
		elif (ID == 0x52):
			''' SID_AUTH_ACCOUNTCREATE (WarCraft) '''
			result = b.getDWord()
			info = tr.SID_ACCOUNTCREATE()
			if result in info:
				if result == 0x00:
					self.log_out("Account created.")
					p.pluginSay(0x100, "green", "[BNET] Account created!")
					self.die()
				else:
					self.log_out(info[result])
					p.pluginSay(0x100, "red", "[BNET] " + info[result])
			else:
				self.log_out("Account does not exist.")
		elif (ID == 0x54):
			''' SID_AUTH_ACCOUNTLOGONPROOF '''
			result = b.getDWord()
			info = tr.SID_LOGONRESULT()
			if result in info:
				if not (result == 2):
					self.out.insertWord(6112)
					p.send(self.out.build(0x45))
					self.out.insertString(self.username)
					self.out.insertString("")
					p.send(self.out.build(0x0a))
					self.log_out("Account information accepted!")
					p.pluginSay(0x100, "green", "[BNET] Login accepted!")
				else:
                                        self.p.pluginSay(0x100, "red",  "[BNCS] %s" % info[result] )
					support.doprint( "[BNCS] %s" % info[result] )
			else:
				self.log_out("Unknown version check response in 0x54.")
		elif (ID == 0x0A):
			''' SID_ENTERCHAT '''
			self.log_out("Login sequence completed.")
			self.unique = b.getString()
			self.log_out("Logged in as "+self.unique+".")
			p.pluginSay(0x100, "green", "[BNET] Logged in as ", "yellow", self.unique, "green", ".")
                        self.p.plugins.find("ui").set_status('Connected (%(server)s) as %(name)s', name=self.unique)

			self.bnls.disconnect()
			
			''' >> EP INFO '''
			self.act_RequestSystemEP()
			
			self.me.name = self.unique
			''' >> SID_REQUESTCHANNELLIST '''
			self.out.insertDWord(0)
			p.send(self.out.build(0x0b))
			''' >> SID_CHANNELJOIN '''
			self.act_EnterChat("PyBot", 0x01)
		elif (ID == 0x26):
			''' SID_READUSERDATA '''
			accounts = b.getDWord()
			keys = b.getDWord()
			id = b.getDWord()
			if id == self.SEPCookie:
				p.plugins.find("ui").addchat("#0099CC", "Account Created: " + b.getString())
				p.plugins.find("ui").addchat("#0099CC", "Last Logon: " + b.getString())
				p.plugins.find("ui").addchat("#0099CC", "Last Logoff: " + b.getString())
				p.plugins.find("ui").addchat("#0099CC", "Time Logged: " + b.getString())
		elif (ID in Unhandled):
			pass
		else:
			support.doprint( "Warning: Packet with ID %s is unhandled by BNCS." % hex(ID) )
		
	def act_EnterChat(self, ID, Mode=0x02):
		''' SID_CHANNELJOIN or SID_ENTERCHAT (/forcejoin) '''
		self.out.insertDWord(Mode)
		self.out.insertString(ID)
		self.p.send(self.out.build(0x0c))
		if (self.home != ""): self.em_SendText("/join %s" % self.home)
		support.execafter( 1, self.act_RequestLists)
		
	def act_RequestLists(self):
		self.p.plugins.find("clan").getClanList()
		
	def act_RequestSystemEP(self):
		## Extended profile of system info
		## /accountinfo
		self.SEPCookie = int(random.randint(1, 500))
		self.out.insertDWord(1)
		self.out.insertDWord(4)
		self.out.insertDWord(self.SEPCookie)
		self.out.insertString(self.username)
		self.out.insertString("System\Account Created")
		self.out.insertString("System\Last Logon")
		self.out.insertString("System\Last Logoff")
		self.out.insertString("System\Time Logged")
		self.p.send(self.out.build(0x26))
			
	def em_SendText(self, text):
		''' SID_SENDTEXT (?)
			* Note: Remove characters under ASCII: 20
		'''
		self.p.em_SendText(text)
		
	def __cevent__(self, ID, Data, p):
		if (ID == 0x09) or (ID == 0x02) or (ID == 0x01):
			if Data['username'] == self.unique:
				self.me = support.channelObject( Data['username'], Data['flags'], Data['ping'], Data['text'] )
		elif (ID == 0x07):
			self.mychannel = Data['text']
                        self.p.plugins.find("ui").set_status('Connected (%(server)s) as %(name)s in channel %(chan)s',
                                                           chan= self.mychannel)
		elif (ID == 0x102):
			''' Socket failure? '''
			support.doprint( "Reconnecting in 10 seconds..." )
			time.sleep(10)
			p.connect()
