""" plugin.py

	Plugin base class. """
	
import sys, os, threading, time, support
	
class pluginList():
	def __init__(self):
		self.list = []
		
	def all(self):
		return self.list
		
	def find(self, entry):
		for p in self.list:
			if p.info["name"].lower() == entry.lower():
				return p.p
		return None
		
	def add(self, entry):
		self.list.append( entry )
	
class plugin(threading.Thread):
	def __init__(self, source, p):
		''' Ideally, all plugins should have at least:
			* p.exposed (class)
			  * p.__attr_ (dictionary return)
			  * p.__invoke__ (to decide what to do)
			  * p.__cevent__ (chat event)
			* more classes
			
			The class will send anything raw to the plugins, except for chat events. They have their own function.
		'''
		threading.Thread.__init__(self)
		self.setDaemon(True)
		
		self.skip = False
		
		self.info = {}
		self.source = source
		self.p = None
		self.onlyCE = False
		self.onlyM = False ## Only loads for the oldest bot.
			
		try:
			source = __import__(self.source)
			self.p = source.exposed(p)
			self.info = self.p.__attr__()
		except:
			self.skip = True
			support.doprint( "Skipped %s because:" % self.source )
			for line in sys.exc_info():
				support.doprint( "   * " + str(line) )
			try:
				del source
			except: pass
			return None
			
		try:
			self.onlyM = self.info["onlymain"]
		except KeyError:
			self.onlyM = False

		if (self.onlyM and not p.family.oldest(p)):
			self.skip = True
			support.doprint( "Skipped %s because:" % self.source )
			support.doprint( "   * This plugin only loads for the main bot." )
			return None

		try:
			self.onlyCE = self.info["chatexplicit"]
			support.doprint( "Loaded %s %s by %s." % (self.info["name"],
                                                                  '.'.join(map(str, self.info["version"])),
                                                                  self.info["author"]) )
		except:
			self.skip = True
			support.doprint( "Warning: %s error in file [%s.py]:" % (str(sys.exc_info()[0]), self.source) )
			support.doprint( "   * " + str(sys.exc_info()[1]) )
			support.doprint( "   * " + str(sys.exc_info()[2]) )
			return None
		
		self.start()
		
	def run(self):
		''' This is to keep the plugin on it's own thread. '''
		while True:
			time.sleep(1)
