""" main.py

	Loads classes for the bot and plugins.
	
	The only thing that is not a plugin is the connection between the Battle.net server and the bot.

	"""

''' Fix people who aren't running this by a batch file, and
	don't have a Python25/Lib reference. '''
import sys, os, support

support.doprint( " ============== System Startup ==============" )

try:
	import wx
except:
	for folder, name, file in os.walk( "C:\\Python25\\Lib\\site-packages", False):
		level = folder.split("C:\\Python25\\Lib\\site-packages")[1].split("\\")
		if len(level) > 1:
			level = level[1]
			if level.find("wx-") != -1:
				module = level
	support.doprint( " * Trying to fix pathing... (" + module + ")" )
	sys.path.insert(0, os.path.abspath("C:\\Python25\\Lib\\site-packages\\" + module))
	try:
		import wx
		support.doprint( " * Import successful." )
	except:
		support.doprint( " * Path could not be redirected." )

support.doprint( " * Loading winamp controller..." )
try:
	import winamp
	support.doprint( " * Import successful." )
except:
	support.doprint( " * Failed to load winamp controller." )
	
try:
	pfolders = ['sppt', 'ui', 'plugins']
	for folder in pfolders:
		sys.path.insert(0, os.path.abspath("./" + folder + "/"))
except:
	support.doprint( "Python will not allow the plugin folder to be added as an import location." )
	sys.exit()
	
import threading, socket
from select import select
import plugin, vbs, buffer, time, queue

support.doprint( " ============== System Loaded ==============" )

class fakeui():
	# This is way easier than adding a try..catch to everything
	def __init__(self):
		self.info = {
				'name' : 'ui',
				'author' : "",
				'version' : (1, 0),
				'description' : 'LOLFAKE',
				'chatexplicit' : True
				}
		self.p = self
		self.source = 'FAKEUI'
		self.onlyCE = True
		
	def __cevent__(self, ID, Data, p):
		pass
	
	def set_status(self, *args, **kwargs):
		pass
		
	def addchat(self, *args, **kwargs):
		pass

class family():
	def __init__(self):
		self.children = []
		
	def add(self, cfg):
		bot = pybot(self, cfg)
		bot.connect()
		print "[INT] Created a new bot handle with %s." % cfg
		self.children.append(bot)
		
	def rem(self, cfg):
		for c in self.children:
			if c.cfgfile == cfg:
				c.destroy()
				self.children.remove(c)
				print "[INT] Terminated a bot handle with %s." % cfg
				return True
		return False
		
	def brothers(self):
		return len(self.children)-1
		
	def oldest(self, src):
		try:
			if src.cfgfile == self.children[0].cfgfile:
				return True
			else:
				return False
		except IndexError:
			return True
		
	def brother(self, src, onlyops=False):
		try:
		## Returns the brother with the lowest queue stress.
			if not src.cfgfile == self.children[0].cfgfile:
				# Only the leader
				return None
			else:
				bro = src
				for b in self.children:
					if ((onlyops and b.plugins.find("bncs").me.hasFlag(0x02)) or (not onlyops)):
						if (b.queue.qsize() < bro.queue.qsize()):
							bro = b
				return bro
		except IndexError:
			## No brothers, return nothing
			return None
	
class pybot(threading.Thread):
	def __init__(self, family, cfg="pybot.ini"):
		self.cfgfile = cfg
		self.plugins = plugin.pluginList()
		self.vbsplugins = []
		self.queue = queue.queue(self)
		self.command = support.command(cfg)
		self.family = family
		self.winamp = winamp.Winamp()
	
		''' CONFIG '''
		self.config = support.config(cfg)
		
		''' srs '''
		self.config.set("main", "username", "PyBot", False)
		self.config.set("main", "password", "", False)
		self.config.set("main", "cdkey", "", False)
		self.config.set("main", "expcdkey", "", False)
		self.config.set("main", "verbyte", "22", False)
		self.config.set("main", "game", "3RAW", False)
		self.config.set("main", "platform", "68XI", False)
		self.config.set("main", "origin", "USA", False)
		self.config.set("main", "originfull", "United States", False)
		self.config.set("main", "bnls", "pyro.no-ip.biz", False)
		self.config.set("main", "bncs", "europe.battle.net", False)
		self.config.set("main", "ui", "yes", False)
		
		''' For fun '''
		self.config.set("main", "trigger", ".", False)
	
		''' SETUP '''
		self.socket = socket.socket ( socket.AF_INET, socket.SOCK_STREAM )
		self.socket.settimeout(300.0)
		self.connected = False #socket connected?
		self.execute = True #true as long as something does not want the listening operation to stop
		self.saydisc = False #true if something wants us to tell plugins we disconnected
		self.alive = False #true if the thread was started
		
		self.data = ""
	
		''' PLUGINS '''
		''' Python '''
		if (self.config.get("main", "ui") == "no" or not self.family.oldest(self)):
			try:
				pfolders.remove("ui")
			except: pass
			
			self.plugins.list.append(fakeui())

		support.doprint( "Loading plugins..." )
		for folder in pfolders:
			for file in os.listdir(folder + "/"):
				if file.lower().endswith(".py"):
					name = file[:len(file)-3]
					plug = plugin.plugin(name, self) 
					if not plug.skip:
						self.plugins.add( plug )
					del plug

		threading.Thread.__init__(self)
		
		self.newsctrl = support.news()
		self.pybotmotd = self.newsctrl.retr()
		
		time.sleep(0.5) ## Wait for ui to be initialized
		
		self.plugins.find("ui").addchat("#0099CC", "Welcome to PyBot.")
		self.plugins.find("ui").addchat("#0099CC", "You can download the latest version of PyBot at: http://python.bot.nu/")
		news = self.pybotmotd.split("\n")
		for item in news:
			self.plugins.find("ui").addchat("#00BBFF", item.rstrip("\r"))
		
	def connect(self):
		self.disconnect()
		self.socket = socket.socket ( socket.AF_INET, socket.SOCK_STREAM )
		self.socket.settimeout(300.0)
		try:
			self.socket.connect( (self.config.get("main", "bncs"), 6112) )
		except socket.error, socket.herror:
			self.plugins.find("ui").addchat("red", "[BNCS] Connection could not be established.")
			self.disconnect()
			return False
		except socket.timeout:
			self.plugins.find("ui").addchat("red", "[BNCS] Connection timed out.")
			self.disconnect()
			return False
		except:
			self.plugins.find("ui").addchat("red", "[BNCS] Socket failure.")
			self.disconnect()
			return False

		self.plugins.find("ui").set_status('Connected (%(server)s)', server=self.config.get("main", "bncs"))
		
		self.connected = True
		self.saydisc = True
		
		''' Make the queue a slow and empty it
			300b is about 5 medium-length messages '''
		self.queue.queue = []
		self.queue.bytes = 300
		
		''' CONNECTION TYPE '''
		self.socket.sendall( chr(0x01) )
		
		''' BEGIN SOCKET '''
		self.globalInvoke(0x104, 0, {})
		if not self.alive:
			self.start()
		else:
			print "No need to start the thread again."
		
	def destroy(self):
		self.execute = False
		self.disconnect()
		
	def disconnect(self):
		try:
                        self.data = ""
                        self.socket.close()
			self.socket = None
			self.connected = False
			#self.saydisc = True
		except:
			pass
			
	def send(self, data):
		i = buffer.pin()
		id = i.unbuild(data)
		## support.doprint( " >> %s [BNCS] %s" % (hex(id), str(i.length)) )
		self.socket.sendall( data )
		
	def em_SendText(self, text):
		''' SID_SENDTEXT (?)
			* Note: Remove characters under ASCII: 20
		'''
		try:
			output = ''
			for char in text:
				if ord(char) > 20:
					output += char
			out = buffer.pout()
			if (len(output) > 250):
				self.plugins.find("ui").addchat("red", "Output too large: %s" % output)
				return None
			print "OUT",output
			if (len(output) > 0):
				if output[:4] == "/ban":
					if not (self.plugins.find("bncs").me.flags & 0x02) == 0x02:
						self.plugins.find("ui").addchat("red", "The bot is not an operator.")
						return None
				out.insertString(str(output))
				self.send(out.build(0x0e))
			self.pluginSay(0x05, {"username" : self.plugins.find("bncs").unique, "flags" : 0, "ping" : 0, "text" : output})
		except:
			support.doprint( "SendText error:" )
			support.doprint( sys.exc_info() )
		
	def recieve(self, ID, Length, Data):
		# support.doprint( " << %s [BNCS] %s" % (hex(ID), str(Length))
		self.globalInvoke(ID, Length, Data)
		
	def globalInvoke(self, ID, Length, Data):
		eventID = 0x0
		eventCMD = False
		for plugin in self.plugins.all():
			try:
				if (ID == 0x0F):
					''' Chat event '''
					b = buffer.pin()
					b.unbuild(Data)
					eventID = b.getDWord()
					eventData = {"flags":b.getDWord(), "ping":b.getDWord()}
					eventLegacy = [b.getDWord(), b.getDWord(), b.getDWord()]
					eventData["username"] = b.getString()
					eventData["text"] = b.getString()
					if (eventID == 0x12):
						self.queue.tryremban(eventData["text"])
						
						## Append ban count to messages
						if support.match(eventData["text"], ".*was banned by*"):
							bc = 1
							try:
								oper = eventData['text'].split(" ")[4].rstrip(".")
								for banned, op in self.plugins.find("op").bans.items():
									if oper.lower() == op.lower(): bc += 1
							except: bc = 0
							if bc > 1: eventData['text'] += " [%i]" % bc
						## Append original ban author to messages
						elif support.match(eventData["text"], ".*was unbanned by*"):
							try:
								for banned, op in self.plugins.find("op").bans.items():
									if banned.lower() == eventData['text'].split(" ")[0].lower():
										banby = op
							except: banby = ""
							if (banby != ""): eventData['text'] += " [%s]" % banby
						elif eventData['text'] == "Welcome to Battle.net!":
							## No one cares that we are welcome on Battle.net
							## we already know they love us regardless
							v = support.version()
							self.plugins.find("ui").addchat("orange", "You are connected to an official Battle.net server.")
							self.plugins.find("ui").addchat("orange", v.history())
							return None
						##
					if (eventID in [0x04, 0x05]) and (eventCMD == False):
						cmd = self.command.iscommand(eventData['text'], self, self.plugins.find("bncs").me.flags)
						if (not cmd == False):
							if eventID == 0x05: id = 1
							if eventID == 0x04: id = 3
							self.pluginSay( 0x101, (eventData['username'], eventData['flags'], cmd, id) )
							eventCMD = True
					plugin.p.__cevent__(eventID, eventData, self)
				else:
					''' Packet event '''
					if not plugin.onlyCE: plugin.p.__invoke__(ID, Length, Data, self)
			except:
				support.doprint( "* Plugin failure [ID " + hex(ID) + "-" + hex(eventID) + "]: " + plugin.source )
				for line in sys.exc_info():
					support.doprint( "    * " + str(line) )
				
	def pluginConsoleText(self, text):
		veto = False
		if len(text) > 2:
			if text[:1] == "/" and (not text[:2] == "//"):
				me = self.plugins.find("bncs").me
				cmd = self.command.iscommand(text, self, me.flags, flist=["/"])
				if (not cmd == False):
					if self.pluginSay( 0x101, ("~console", me.flags, cmd, 4) ):
						veto = True
			if text[:2] == "//":
				me = self.plugins.find("bncs").me
				cmd = self.command.iscommand(text, self, me.flags, flist=["//"])
				if (not cmd == False):
					if self.pluginSay( 0x101, ("~console", me.flags, cmd, 5) ):
						veto = True

		self.pluginSay(0x103, (text))
		if not veto: self.queue.addq( text )
				
	def pluginSay(self, ID, *Data):
		if len(Data) == 1:
			Data = Data[0]
		v = False
		for plugin in self.plugins.all():
			self.veto = False
			plugin.p.__cevent__(ID, Data, self)
			if self.veto:
				v = True
				print "MUFFLE CONSOLE"
				self.veto = False
		return v
		
	def run(self):
		self.alive = True
		while self.execute:
			while self.connected:
                                r = select([self.socket], [], [self.socket], 420)
                                if r[0] == []: #Nothing to read in 420 seconds
                                        #Send SID_NULL to test connection
                                        self.socket.sendall('\xff\x00\x04\x00')
                                if self.socket in r[2]: #Error
                                        support.doprint("Socket error")
                                        self.disconnect()
                                        break
				try:
					data = self.socket.recv(2048)
					if data == "":
                                                self.disconnect()
                                                break
					if not self.connected:
						break
					self.data += data
				except:
					support.doprint( "Stream stopped?!" )
					self.disconnect()
					
				if not self.data:
					self.disconnect()
				elif len(self.data) > 0:
					b = buffer.pin()
					id = int(b.unbuild(self.data))
					if len(self.data) == int(b.length): #perfect size
						self.recieve(id, b.length, self.data)
						self.data = ''
					elif len(self.data) >= int(b.length): #over sent, cut off the stuff we want and leave the rest for next iteration
						while len(self.data) >= int(b.length):
							#self.log_out(" >> %s %s" % (len(self.data), b.length))
							self.recieve(id, b.length, self.data[:b.length])
							self.data = self.data[b.length:]
							id = int(b.unbuild(self.data))
			if self.saydisc:
				support.doprint( "Disconnected by socket failure." )
				self.pluginSay(0x102, [])
				self.saydisc = False
			else:
				time.sleep(0.04)
		support.doprint( " ============== System Terminated Safely ==============" )
''' <--- '''
