from struct import pack, unpack

""" buffer.py
	These classes are for building and unbuilding BNCS / BNLS packets. """

class pout():
	def __init__(self):
		self.clear()
	
	def insertByte(self, byte):
		self.data += chr(byte)

	def insertString(self, text):
		self.data += text + chr(0)
		
	def insertDWord(self, dword):
		self.data += pack('<L', dword)

	def insertWord(self, word):
		self.data += pack('<H', word)

	def insertRawData(self, raw):
		self.data += raw

	def clear(self):
		self.data = ""
		
	def build(self, id, bnls=False):
		if bnls == True:
			self.data = pack('<H', len(self.data) + 3) + chr(id) + self.data
			#print "BNLS: " + hex(id),"C -> S",str(len(self.data) + 4)
		else:
			self.data = chr(0xff) + chr(id) + pack('<H', len(self.data) + 4) + self.data
			#print "BNET: " + hex(id),"C -> S",str(len(self.data) + 4)
		give = self.data
		self.clear()
		return give

	
class pin():
	def __init__(self):
		self.data = ""
		self.id = 0x00
		self.length = 0
		self.pos = 0
		pass
		
	def getByte(self):
		d = ord(self.data[self.pos])
		self.pos += 1
		return d
	
	def getString(self):
		t = ""
		for m in range(self.pos, len(self.data)):
			if ord(self.data[m]) == 0:
				break
			else:
				t += str(self.data[m])
		self.pos += len(t) + 1
		return t

	def getDWord(self):
		d = unpack('<L', self.data[self.pos:self.pos + 4])[0]
		self.pos += 4
		return d
		
	def getWord(self):
		d = unpack('<H', self.data[self.pos:self.pos + 2])[0]
		self.pos += 2
		return d
		
	def getRawData(self, length):
		r = ""
		for i in range(self.pos, self.pos+length):
			r += self.data[i]
		self.pos += length
		return r
		
	def unbuild(self, new, bnls=False):
		if len(new) > 0:
			self.data = ""
			if bnls == True:
				self.id = ord(new[2])
				self.length = unpack('<H', new[0:2])[0]
				self.data = ''.join(new[3:])
				#print "BNLS:",hex(self.id),"S -> C",len(self.data)
				return self.id
			else:
				if not new[0] == chr(0xFF):
					print new
					print "Data corrupt:",' '.join (map (hex, map (ord, new[:])))
					return True
				else:
					self.id = ord(new[1])
					self.length = unpack('<H', new[2:4])[0]
					self.data = ''.join(new[4:])
					#print "BNET: " + hex(self.id),"S -> C",self.length
					return self.id
		else:
			return -1
