import java.util.Properties;
import java.io.IOException;

import javax.swing.JComponent;

import callback_interfaces.PluginCallbackRegister;
import callback_interfaces.PublicExposedFunctions;
import callback_interfaces.StaticExposedFunctions;
import exceptions.CommandUsedIllegally;
import exceptions.CommandUsedImproperly;
import exceptions.PluginException;
import plugin_interfaces.EventCallback;
import plugin_interfaces.GenericPluginInterface;
import plugin_interfaces.CommandCallback;

public class PluginMain extends GenericPluginInterface implements EventCallback, CommandCallback
{

    private PublicExposedFunctions out;

    public void load(StaticExposedFunctions staticFuncs)
    {
        // TODO Auto-generated method stub

    }

    public void activate(PublicExposedFunctions out, PluginCallbackRegister register)
    {
        // TODO Auto-generated method stub
        register.registerEventPlugin(this, null);
        this.out = out;
        register.registerCommandPlugin(this, "leavemessage", 1, false, "AN", "[message]", "Displays the current message sent to users who leave or sets it.", null);
    }

    public void deactivate(PluginCallbackRegister register)
    {
        // TODO Auto-generated method stub

    }

    public String getName()
    {
        // TODO Auto-generated method stub
        return "Whisper on Leave Plugin";
    }

    public String getVersion()
    {
        // TODO Auto-generated method stub
        return "1.0";
    }

    public String getAuthorName()
    {
        // TODO Auto-generated method stub
        return "Ryan Marcus";
    }

    public String getAuthorWebsite()
    {
        // TODO Auto-generated method stub
        return "N/A";
    }

    public String getAuthorEmail()
    {
        // TODO Auto-generated method stub
        return "ryan@marcusfamily.info";
    }

    public String getLongDescription()
    {
        // TODO Auto-generated method stub
        return "This plugin allows you to send whispers to users when they leave the channel. You must restart JavaOp after enabling this plugin.";
    }

    public Properties getDefaultSettingValues()
    {
        // TODO Auto-generated method stub
        Properties p = new Properties();
        p.setProperty("message", "Join Clan SoF, channel: clan sof");
        return p;

    }

    public Properties getSettingsDescription()
    {
        // TODO Auto-generated method stub
        Properties p = new Properties();
        p.setProperty("message", "This is the message that will be sent to users that are leaving.");
        return p;

    }

    public JComponent getComponent(String settingName, String value)
    {
        // TODO Auto-generated method stub
        return null;
    }

    public Properties getGlobalDefaultSettingValues()
    {
        // TODO Auto-generated method stub
        Properties p = new Properties();
        return p;
    }

    public Properties getGlobalSettingsDescription()
    {
        // TODO Auto-generated method stub
        Properties p = new Properties();
        return p;
    }

    public JComponent getGlobalComponent(String settingName, String value)
    {
        // TODO Auto-generated method stub
        return null;
    }

    public void commandExecuted(String user, String command, String[] args, int loudness, Object data) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly
    {
        if (command.equalsIgnoreCase("leavemessage"))
        {
            if (args.length == 0)
            {
                out.sendTextUser(user, "Message is currently " + out.getLocalSetting(getName(), "message"), loudness);
            }
            else
            {
                out.putLocalSetting(getName(), "idle", args[0]);
                out.sendText("Message set to " + args[0]);
            }
        }
    }

    public void talk(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
    }

    public void emote(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
    }

    public void whisperFrom(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
    }

    public void whisperTo(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
    }

    public void userShow(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
    }

    public void userJoin(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
    }

    public void userLeave(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
        String goodbye = out.getLocalSetting(getName(), "message");
        out.sendTextUser(user, goodbye, QUIET);
    }

    public void userFlags(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
    }

    public void error(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
    }

    public void info(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
    }

    public void broadcast(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
    }

    public void channel(String user, String statstring, int ping, int flags) throws IOException, PluginException
    {
    }

}
