/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.Advertisements;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.PacketCallback;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;
import com.javaop.util.ColorConstants;
import com.javaop.util.FileTime;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.TimerTask;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements PacketCallback {
    private PublicExposedFunctions pubFuncs;
    private int lastId = 0;
    private String filetime;
    private String filename;
    private String url;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.pubFuncs = publicExposedFunctions;
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 21, null);
        publicExposedFunctions.schedule((TimerTask)new GetAd(), 15000L);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "Advertisements";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "javaop.googlecode.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getLongDescription() {
        return "I don't see any use for this, but it displays the ads that you would see if you were on a real client. It requests a new ad every 15 seconds, and I've found that a new one is usually loaded every half hour or so.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("Announce ads", "false");
        properties.setProperty("Display ads", "true");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("Announce ads", "If this is set, the current ad will be displayed in the channel. Very annoying.");
        properties.setProperty("Display ads", "If this is set, the current ad will be displayed to the user");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        return new JCheckBox("", string2.equalsIgnoreCase("true"));
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public BnetPacket processingPacket(BnetPacket bnetPacket, Object object) throws IOException, PluginException {
        return bnetPacket;
    }

    public void processedPacket(BnetPacket bnetPacket, Object object) throws IOException, PluginException {
        this.lastId = bnetPacket.removeDWord();
        bnetPacket.removeDWord();
        this.filetime = new Date(FileTime.fileTimeToMillis((long)bnetPacket.removeLong())).toString();
        this.filename = bnetPacket.removeNTString();
        this.url = bnetPacket.removeNTString();
        if (this.pubFuncs.getLocalSettingDefault(this.getName(), "Announce ads", "false").equalsIgnoreCase("true")) {
            this.pubFuncs.sendTextPriority("Current ad: '" + this.filename + "' (" + this.url + ")", -50);
        }
        if (this.pubFuncs.getLocalSettingDefault(this.getName(), "Display ads", "true").equalsIgnoreCase("false")) {
            this.pubFuncs.showMessage(ColorConstants.getColor((String)"info") + "[" + this.filetime + "] Current ad: '" + this.filename + "' (" + this.url + ")");
        }
    }

    private class GetAd
    extends TimerTask {
        private GetAd() {
        }

        @Override
        public void run() {
            try {
                BnetPacket bnetPacket = new BnetPacket(21);
                bnetPacket.addString("68XI");
                bnetPacket.addString("RATS");
                bnetPacket.addDWord(PluginMain.this.lastId);
                bnetPacket.addDWord((int)(System.currentTimeMillis() / 1000L));
                PluginMain.this.pubFuncs.sendPacket((Buffer)bnetPacket);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

